category: '*gsmonticello'
method: AbstractDictionary
at: key ifPresent: aBlock
	"Lookup the given key in the receiver. If it is present, answer the value of evaluating the given block with the value associated with the key. Otherwise, answer nil."

	| v |
	v := self at: key ifAbsent: [^ nil].
	^ aBlock value: v
%

category: '*gsmonticello'
method: AbstractDictionary
isDictionary

    ^true
%

category: '*gsmonticello'
method: AbstractDictionary
associations
	"Answer an OrderedCollection containing the receiver's associations in an 
	arbitrary order."

	| aCollection |
	aCollection := Array new.
	self associationsDo: [:assn | aCollection add: assn].
	^aCollection
%

