! Copyright (C) GemTalk Systems 1986-2025.  All Rights Reserved.
! Class Declarations
! Generated file, do not Edit

doit
(Error
	subclass: 'CypressError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Definitions';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressError
removeallclassmethods CypressError

doit
(Error
	subclass: 'CypressJsonError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Structure';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressJsonError
removeallclassmethods CypressJsonError

doit
(Error
	subclass: 'CypressLoaderError'
	instVarNames: #(exception patchOperation)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Definitions';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.

CypressLoaderError is used to report a failure applying a specific CypressPatchOperation.
The CypressLoader made a first attempt to apply the Patch Operation and reported a 
CypressLoaderErrorNotification, set aside the Patch Operation, and has retried it after applying
all other Patch Operations.


Instance Variables:

patchOperation:		the CypressPatchOperation that could not be applied.
exception:			the Error which occurred while trying to apply the Patch Operation.
';
		immediateInvariant.
true.
%

removeallmethods CypressLoaderError
removeallclassmethods CypressLoaderError

doit
(Error
	subclass: 'CypressLoaderMissingClasses'
	instVarNames: #(requirementsMap)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Definitions';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressLoaderMissingClasses
removeallclassmethods CypressLoaderMissingClasses

doit
(GsFileIn
	subclass: 'GsFileinPackager'
	instVarNames: #(definedProject packageNameToComponentNameMap defaultComponentName packageDefinition packageCount onDoitBlock packageConvention)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-Core-37x';
		immediateInvariant.
true.
%

removeallmethods GsFileinPackager
removeallclassmethods GsFileinPackager

doit
(Magnitude
	indexableSubclass: 'RwGemStoneVersionNumber'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Core-Conditional-Support';
		comment: '# GemStone version format

GemStone versions are simply an unbounded collection of $. separated positive integers.';
		immediateInvariant.
true.
%

removeallmethods RwGemStoneVersionNumber
removeallclassmethods RwGemStoneVersionNumber

doit
(Magnitude
	subclass: 'RwSemanticVersionNumber'
	instVarNames: #(normalVersion preReleaseVersion buildVersion)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Core-Conditional-Support';
		comment: 'RwSemanticVersionNumber conforms to version 2.0.0 of  [Semantic Versioning 2.0.0](http://semver.org/)

**Semantic Versioning Specification** extracted from [Semantic versioning 2.0.0](https://raw.githubusercontent.com/semver/semver/347f73f880ebe1de61891832bf8702e864ca0998/semver.md):

Semantic Versioning 2.0.0
==============================

Summary
-------

Given a version number MAJOR.MINOR.PATCH, increment the:

1. MAJOR version when you make incompatible API changes,
1. MINOR version when you add functionality in a backwards-compatible
   manner, and
1. PATCH version when you make backwards-compatible bug fixes.

Additional labels for pre-release and build metadata are available as extensions
to the MAJOR.MINOR.PATCH format.

Introduction
------------

In the world of software management there exists a dreaded place called
"dependency hell." The bigger your system grows and the more packages you
integrate into your software, the more likely you are to find yourself, one
day, in this pit of despair.

In systems with many dependencies, releasing new package versions can quickly
become a nightmare. If the dependency specifications are too tight, you are in
danger of version lock (the inability to upgrade a package without having to
release new versions of every dependent package). If dependencies are
specified too loosely, you will inevitably be bitten by version promiscuity
(assuming compatibility with more future versions than is reasonable).
Dependency hell is where you are when version lock and/or version promiscuity
prevent you from easily and safely moving your project forward.

As a solution to this problem, I propose a simple set of rules and
requirements that dictate how version numbers are assigned and incremented.
These rules are based on but not necessarily limited to pre-existing
widespread common practices in use in both closed and open-source software.
For this system to work, you first need to declare a public API. This may
consist of documentation or be enforced by the code itself. Regardless, it is
important that this API be clear and precise. Once you identify your public
API, you communicate changes to it with specific increments to your version
number. Consider a version format of X.Y.Z (Major.Minor.Patch). Bug fixes not
affecting the API increment the patch version, backwards compatible API
additions/changes increment the minor version, and backwards incompatible API
changes increment the major version.

I call this system "Semantic Versioning." Under this scheme, version numbers
and the way they change convey meaning about the underlying code and what has
been modified from one version to the next.


Semantic Versioning Specification (SemVer)
------------------------------------------

The key words "MUST", "MUST NOT", "REQUIRED", "SHALL", "SHALL NOT", "SHOULD",
"SHOULD NOT", "RECOMMENDED", "MAY", and "OPTIONAL" in this document are to be
interpreted as described in [RFC 2119](http://tools.ietf.org/html/rfc2119).

1. Software using Semantic Versioning MUST declare a public API. This API
could be declared in the code itself or exist strictly in documentation.
However it is done, it SHOULD be precise and comprehensive.

1. A normal version number MUST take the form X.Y.Z where X, Y, and Z are
non-negative integers, and MUST NOT contain leading zeroes. X is the
major version, Y is the minor version, and Z is the patch version.
Each element MUST increase numerically. For instance: 1.9.0 -> 1.10.0 -> 1.11.0.

1. Once a versioned package has been released, the contents of that version
MUST NOT be modified. Any modifications MUST be released as a new version.

1. Major version zero (0.y.z) is for initial development. Anything MAY change
at any time. The public API SHOULD NOT be considered stable.

1. Version 1.0.0 defines the public API. The way in which the version number
is incremented after this release is dependent on this public API and how it
changes.

1. Patch version Z (x.y.Z | x > 0) MUST be incremented if only backwards
compatible bug fixes are introduced. A bug fix is defined as an internal
change that fixes incorrect behavior.

1. Minor version Y (x.Y.z | x > 0) MUST be incremented if new, backwards
compatible functionality is introduced to the public API. It MUST be
incremented if any public API functionality is marked as deprecated. It MAY be
incremented if substantial new functionality or improvements are introduced
within the private code. It MAY include patch level changes. Patch version
MUST be reset to 0 when minor version is incremented.

1. Major version X (X.y.z | X > 0) MUST be incremented if any backwards
incompatible changes are introduced to the public API. It MAY also include minor
and patch level changes. Patch and minor version MUST be reset to 0 when major
version is incremented.

1. A pre-release version MAY be denoted by appending a hyphen and a
series of dot separated identifiers immediately following the patch
version. Identifiers MUST comprise only ASCII alphanumerics and hyphen
[0-9A-Za-z-]. Identifiers MUST NOT be empty. Numeric identifiers MUST
NOT include leading zeroes. Pre-release versions have a lower
precedence than the associated normal version. A pre-release version
indicates that the version is unstable and might not satisfy the
intended compatibility requirements as denoted by its associated
normal version. Examples: 1.0.0-alpha, 1.0.0-alpha.1, 1.0.0-0.3.7,
1.0.0-x.7.z.92.

1. Build metadata MAY be denoted by appending a plus sign and a series of dot
separated identifiers immediately following the patch or pre-release version.
Identifiers MUST comprise only ASCII alphanumerics and hyphen [0-9A-Za-z-].
Identifiers MUST NOT be empty. Build metadata MUST be ignored when determining
version precedence. Thus two versions that differ only in the build metadata,
have the same precedence. Examples: 1.0.0-alpha+001, 1.0.0+20130313144700,
1.0.0-beta+exp.sha.5114f85.

1. Precedence refers to how versions are compared to each other when ordered.
Precedence MUST be calculated by separating the version into major, minor, patch
and pre-release identifiers in that order (Build metadata does not figure
into precedence). Precedence is determined by the first difference when
comparing each of these identifiers from left to right as follows: Major, minor,
and patch versions are always compared numerically. Example: 1.0.0 < 2.0.0 <
2.1.0 < 2.1.1. When major, minor, and patch are equal, a pre-release version has
lower precedence than a normal version. Example: 1.0.0-alpha < 1.0.0. Precedence
for two pre-release versions with the same major, minor, and patch version MUST
be determined by comparing each dot separated identifier from left to right
until a difference is found as follows: identifiers consisting of only digits
are compared numerically and identifiers with letters or hyphens are compared
lexically in ASCII sort order. Numeric identifiers always have lower precedence
than non-numeric identifiers. A larger set of pre-release fields has a higher
precedence than a smaller set, if all of the preceding identifiers are equal.
Example: 1.0.0-alpha < 1.0.0-alpha.1 < 1.0.0-alpha.beta < 1.0.0-beta <
1.0.0-beta.2 < 1.0.0-beta.11 < 1.0.0-rc.1 < 1.0.0.

Backus-Naur Form Grammar for Valid SemVer Versions
--------------------------------------------------

    <valid semver> ::= <version core>
                     | <version core> "-" <pre-release>
                     | <version core> "+" <build>
                     | <version core> "-" <pre-release> "+" <build>

    <version core> ::= <major> "." <minor> "." <patch>

    <major> ::= <numeric identifier>

    <minor> ::= <numeric identifier>

    <patch> ::= <numeric identifier>

    <pre-release> ::= <dot-separated pre-release identifiers>

    <dot-separated pre-release identifiers> ::= <pre-release identifier>
                                              | <pre-release identifier> "." <dot-separated pre-release identifiers>

    <build> ::= <dot-separated build identifiers>

    <dot-separated build identifiers> ::= <build identifier>
                                        | <build identifier> "." <dot-separated build identifiers>

    <pre-release identifier> ::= <alphanumeric identifier>
                               | <numeric identifier>

    <build identifier> ::= <alphanumeric identifier>
                         | <digits>

    <alphanumeric identifier> ::= <non-digit>
                                | <non-digit> <identifier characters>
                                | <identifier characters> <non-digit>
                                | <identifier characters> <non-digit> <identifier characters>

    <numeric identifier> ::= "0"
                           | <positive digit>
                           | <positive digit> <digits>

    <identifier characters> ::= <identifier character>
                              | <identifier character> <identifier characters>

    <identifier character> ::= <digit>
                             | <non-digit>

    <non-digit> ::= <letter>
                  | "-"

    <digits> ::= <digit>
               | <digit> <digits>

    <digit> ::= "0"
              | <positive digit>

    <positive digit> ::= "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9"

    <letter> ::= "A" | "B" | "C" | "D" | "E" | "F" | "G" | "H" | "I" | "J"
               | "K" | "L" | "M" | "N" | "O" | "P" | "Q" | "R" | "S" | "T"
               | "U" | "V" | "W" | "X" | "Y" | "Z" | "a" | "b" | "c" | "d"
               | "e" | "f" | "g" | "h" | "i" | "j" | "k" | "l" | "m" | "n"
               | "o" | "p" | "q" | "r" | "s" | "t" | "u" | "v" | "w" | "x"
               | "y" | "z"


Why Use Semantic Versioning?
----------------------------

This is not a new or revolutionary idea. In fact, you probably do something
close to this already. The problem is that "close" isn''t good enough. Without
compliance to some sort of formal specification, version numbers are
essentially useless for dependency management. By giving a name and clear
definition to the above ideas, it becomes easy to communicate your intentions
to the users of your software. Once these intentions are clear, flexible (but
not too flexible) dependency specifications can finally be made.

A simple example will demonstrate how Semantic Versioning can make dependency
hell a thing of the past. Consider a library called "Firetruck." It requires a
Semantically Versioned package named "Ladder." At the time that Firetruck is
created, Ladder is at version 3.1.0. Since Firetruck uses some functionality
that was first introduced in 3.1.0, you can safely specify the Ladder
dependency as greater than or equal to 3.1.0 but less than 4.0.0. Now, when
Ladder version 3.1.1 and 3.2.0 become available, you can release them to your
package management system and know that they will be compatible with existing
dependent software.

As a responsible developer you will, of course, want to verify that any
package upgrades function as advertised. The real world is a messy place;
there''s nothing we can do about that but be vigilant. What you can do is let
Semantic Versioning provide you with a sane way to release and upgrade
packages without having to roll new versions of dependent packages, saving you
time and hassle.

If all of this sounds desirable, all you need to do to start using Semantic
Versioning is to declare that you are doing so and then follow the rules. Link
to this website from your README so others know the rules and can benefit from
them.


FAQ
---

### How should I deal with revisions in the 0.y.z initial development phase?

The simplest thing to do is start your initial development release at 0.1.0
and then increment the minor version for each subsequent release.

### How do I know when to release 1.0.0?

If your software is being used in production, it should probably already be
1.0.0. If you have a stable API on which users have come to depend, you should
be 1.0.0. If you''re worrying a lot about backwards compatibility, you should
probably already be 1.0.0.

### Doesn''t this discourage rapid development and fast iteration?

Major version zero is all about rapid development. If you''re changing the API
every day you should either still be in version 0.y.z or on a separate
development branch working on the next major version.

### If even the tiniest backwards incompatible changes to the public API require a major version bump, won''t I end up at version 42.0.0 very rapidly?

This is a question of responsible development and foresight. Incompatible
changes should not be introduced lightly to software that has a lot of
dependent code. The cost that must be incurred to upgrade can be significant.
Having to bump major versions to release incompatible changes means you''ll
think through the impact of your changes, and evaluate the cost/benefit ratio
involved.

### Documenting the entire public API is too much work!

It is your responsibility as a professional developer to properly document
software that is intended for use by others. Managing software complexity is a
hugely important part of keeping a project efficient, and that''s hard to do if
nobody knows how to use your software, or what methods are safe to call. In
the long run, Semantic Versioning, and the insistence on a well defined public
API can keep everyone and everything running smoothly.

### What do I do if I accidentally release a backwards incompatible change as a minor version?

As soon as you realize that you''ve broken the Semantic Versioning spec, fix
the problem and release a new minor version that corrects the problem and
restores backwards compatibility. Even under this circumstance, it is
unacceptable to modify versioned releases. If it''s appropriate,
document the offending version and inform your users of the problem so that
they are aware of the offending version.

### What should I do if I update my own dependencies without changing the public API?

That would be considered compatible since it does not affect the public API.
Software that explicitly depends on the same dependencies as your package
should have their own dependency specifications and the author will notice any
conflicts. Determining whether the change is a patch level or minor level
modification depends on whether you updated your dependencies in order to fix
a bug or introduce new functionality. I would usually expect additional code
for the latter instance, in which case it''s obviously a minor level increment.

### What if I inadvertently alter the public API in a way that is not compliant with the version number change (i.e. the code incorrectly introduces a major breaking change in a patch release)?

Use your best judgment. If you have a huge audience that will be drastically
impacted by changing the behavior back to what the public API intended, then
it may be best to perform a major version release, even though the fix could
strictly be considered a patch release. Remember, Semantic Versioning is all
about conveying meaning by how the version number changes. If these changes
are important to your users, use the version number to inform them.

### How should I handle deprecating functionality?

Deprecating existing functionality is a normal part of software development and
is often required to make forward progress. When you deprecate part of your
public API, you should do two things: (1) update your documentation to let
users know about the change, (2) issue a new minor release with the deprecation
in place. Before you completely remove the functionality in a new major release
there should be at least one minor release that contains the deprecation so
that users can smoothly transition to the new API.

### Does SemVer have a size limit on the version string?

No, but use good judgment. A 255 character version string is probably overkill,
for example. Also, specific systems may impose their own limits on the size of
the string.

### Is "v1.2.3" a semantic version?

No, "v1.2.3" is not a semantic version. However, prefixing a semantic version
with a "v" is a common way (in English) to indicate it is a version number.
Abbreviating "version" as "v" is often seen with version control. Example:
`git tag v1.2.3 -m "Release version 1.2.3"`, in which case "v1.2.3" is a tag
name and the semantic version is "1.2.3".


About
-----

The Semantic Versioning specification is authored by [Tom
Preston-Werner](http://tom.preston-werner.com), inventor of Gravatar and
cofounder of GitHub.

If you''d like to leave feedback, please [open an issue on
GitHub](https://github.com/mojombo/semver/issues).


License
-------

Creative Commons - CC BY 3.0
http://creativecommons.org/licenses/by/3.0/';
		immediateInvariant.
true.
%

removeallmethods RwSemanticVersionNumber
removeallclassmethods RwSemanticVersionNumber

doit
(Notification
	subclass: 'CypressLoaderErrorNotification'
	instVarNames: #(exception patchOperation)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Definitions';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.

CypressLoaderErrorNotification is used to notify a consumer of the CypressLoader that a particular CypressPatchOperation failed.
As a Notification, it resumes by default, logging the error to the Transcript.


Instance Variables:

patchOperation:		the CypressPatchOperation that could not be applied.
exception:			the Error which occurred while trying to apply the Patch Operation.
';
		immediateInvariant.
true.
%

removeallmethods CypressLoaderErrorNotification
removeallclassmethods CypressLoaderErrorNotification

doit
(Notification
	subclass: 'GsInteractionRequest'
	instVarNames: #(interaction)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'GemStone-Interactions-Core';
		immediateInvariant.
true.
%

removeallmethods GsInteractionRequest
removeallclassmethods GsInteractionRequest

doit
(Notification
	subclass: 'RwNotification'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		comment: 'General way for Cypress to toss things up the stack for consideration by a higher authority.';
		immediateInvariant.
true.
%

removeallmethods RwNotification
removeallclassmethods RwNotification

doit
(RwNotification
	subclass: 'RwAddUpdateRemoveMethodForUnpackagedClassNotification'
	instVarNames: #(errorMessage)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwAddUpdateRemoveMethodForUnpackagedClassNotification
removeallclassmethods RwAddUpdateRemoveMethodForUnpackagedClassNotification

doit
(RwNotification
	subclass: 'RwAdoptAuditErrorNotification'
	instVarNames: #(packageName description reason)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwAdoptAuditErrorNotification
removeallclassmethods RwAdoptAuditErrorNotification

doit
(RwAdoptAuditErrorNotification
	subclass: 'RwAdoptAuditClassErrorNotification'
	instVarNames: #(className isClassExtension)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwAdoptAuditClassErrorNotification
removeallclassmethods RwAdoptAuditClassErrorNotification

doit
(RwAdoptAuditClassErrorNotification
	subclass: 'RwAdoptClassCategoryPackageConventionViolationErrorNotification'
	instVarNames: #(category packageConvention)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwAdoptClassCategoryPackageConventionViolationErrorNotification
removeallclassmethods RwAdoptClassCategoryPackageConventionViolationErrorNotification

doit
(RwAdoptAuditClassErrorNotification
	subclass: 'RwAdoptMissingClassErrorNotification'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwAdoptMissingClassErrorNotification
removeallclassmethods RwAdoptMissingClassErrorNotification

doit
(RwAdoptAuditErrorNotification
	subclass: 'RwAdoptAuditMethodErrorNotification'
	instVarNames: #(selector isMetaclass isTrait className isClassExtension)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwAdoptAuditMethodErrorNotification
removeallclassmethods RwAdoptAuditMethodErrorNotification

doit
(RwAdoptAuditMethodErrorNotification
	subclass: 'RwAdoptMissingMethodErrorNotification'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwAdoptMissingMethodErrorNotification
removeallclassmethods RwAdoptMissingMethodErrorNotification

doit
(RwAdoptAuditMethodErrorNotification
	subclass: 'RwAuditMethodErrorNotification'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwAuditMethodErrorNotification
removeallclassmethods RwAuditMethodErrorNotification

doit
(RwAdoptAuditErrorNotification
	subclass: 'RwAdoptAuditTraitErrorNotification'
	instVarNames: #(traitName)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwAdoptAuditTraitErrorNotification
removeallclassmethods RwAdoptAuditTraitErrorNotification

doit
(RwAdoptAuditTraitErrorNotification
	subclass: 'RwAdoptMissingTraitErrorNotification'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwAdoptMissingTraitErrorNotification
removeallclassmethods RwAdoptMissingTraitErrorNotification

doit
(RwAdoptAuditTraitErrorNotification
	subclass: 'RwAdoptTraitCategoryPackageConventionViolationErrorNotification'
	instVarNames: #(category packageConvention)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwAdoptTraitCategoryPackageConventionViolationErrorNotification
removeallclassmethods RwAdoptTraitCategoryPackageConventionViolationErrorNotification

doit
(RwNotification
	subclass: 'RwAllowChangeRepositoryRevisionOnResolveNotification'
	instVarNames: #(loadSpecification)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-DefinitionsV2';
		immediateInvariant.
true.
%

removeallmethods RwAllowChangeRepositoryRevisionOnResolveNotification
removeallclassmethods RwAllowChangeRepositoryRevisionOnResolveNotification

doit
(RwNotification
	subclass: 'RwAuditTraitErrorNotification'
	instVarNames: #(traitName packageName description reason)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwAuditTraitErrorNotification
removeallclassmethods RwAuditTraitErrorNotification

doit
(RwAuditTraitErrorNotification
	subclass: 'RwAuditTraitMethodErrorNotification'
	instVarNames: #(method selector isMetaclass)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwAuditTraitMethodErrorNotification
removeallclassmethods RwAuditTraitMethodErrorNotification

doit
(RwNotification
	subclass: 'RwCompileErrorCompilingMethodsForNewClassVersionNotification'
	instVarNames: #(compileError)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwCompileErrorCompilingMethodsForNewClassVersionNotification
removeallclassmethods RwCompileErrorCompilingMethodsForNewClassVersionNotification

doit
(RwNotification
	subclass: 'RwDeleteClassFromSystemNotification'
	instVarNames: #(candidateClass)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwDeleteClassFromSystemNotification
removeallclassmethods RwDeleteClassFromSystemNotification

doit
(RwNotification
	subclass: 'RwExecuteClassInitializeMethodsAfterLoadNotification'
	instVarNames: #(candidateClass)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwExecuteClassInitializeMethodsAfterLoadNotification
removeallclassmethods RwExecuteClassInitializeMethodsAfterLoadNotification

doit
(RwNotification
	subclass: 'RwExistingAssociationWithSameKeyNotification'
	instVarNames: #(errorMessage)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwExistingAssociationWithSameKeyNotification
removeallclassmethods RwExistingAssociationWithSameKeyNotification

doit
(RwNotification
	subclass: 'RwExistingVisitorAddingExistingClassNotification'
	instVarNames: #(incomingProject incomingPackage theClass classDefinition loadedClass loadedProject)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwExistingVisitorAddingExistingClassNotification
removeallclassmethods RwExistingVisitorAddingExistingClassNotification

doit
(RwNotification
	subclass: 'RwExistingVisitorAddingExistingMethodNotification'
	instVarNames: #(incomingProject incomingPackage loadedMethod methodDefinition)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwExistingVisitorAddingExistingMethodNotification
removeallclassmethods RwExistingVisitorAddingExistingMethodNotification

doit
(RwNotification
	subclass: 'RwExistingVisitorChangingPackageOwnershipNotification'
	instVarNames: #(incomingProject incomingPackage loadedClassOrMethodDefinition)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		comment: 'This notification is signalled when an project set load encounters a method (or class) that is already being managed by another project, that is not present in the incoming project set. If unhandled, by default the method (or class) will be moved to the incoming project/package.';
		immediateInvariant.
true.
%

removeallmethods RwExistingVisitorChangingPackageOwnershipNotification
removeallclassmethods RwExistingVisitorChangingPackageOwnershipNotification

doit
(RwNotification
	subclass: 'RwInvalidCategoryProtocolConventionErrorNotification'
	instVarNames: #(packageName packageConvention)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwInvalidCategoryProtocolConventionErrorNotification
removeallclassmethods RwInvalidCategoryProtocolConventionErrorNotification

doit
(RwInvalidCategoryProtocolConventionErrorNotification
	subclass: 'RwInvalidClassCategoryConventionErrorNotification'
	instVarNames: #(classDefinition)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwInvalidClassCategoryConventionErrorNotification
removeallclassmethods RwInvalidClassCategoryConventionErrorNotification

doit
(RwInvalidCategoryProtocolConventionErrorNotification
	subclass: 'RwInvalidMethodProtocolConventionErrorNotification'
	instVarNames: #(methodDefinition className isMeta)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwInvalidMethodProtocolConventionErrorNotification
removeallclassmethods RwInvalidMethodProtocolConventionErrorNotification

doit
(RwInvalidMethodProtocolConventionErrorNotification
	subclass: 'RwExtensionProtocolExtensionMethodPackageMismatchErrorNotification'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwExtensionProtocolExtensionMethodPackageMismatchErrorNotification
removeallclassmethods RwExtensionProtocolExtensionMethodPackageMismatchErrorNotification

doit
(RwInvalidMethodProtocolConventionErrorNotification
	subclass: 'RwExtensionProtocolNonExtensionMethodErrorNotification'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwExtensionProtocolNonExtensionMethodErrorNotification
removeallclassmethods RwExtensionProtocolNonExtensionMethodErrorNotification

doit
(RwInvalidMethodProtocolConventionErrorNotification
	subclass: 'RwNonExtensionProtocolExtensionMethodErrorNotification'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwNonExtensionProtocolExtensionMethodErrorNotification
removeallclassmethods RwNonExtensionProtocolExtensionMethodErrorNotification

doit
(RwNotification
	subclass: 'RwPerformingUnpackagedEditNotification'
	instVarNames: #(informMessage)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwPerformingUnpackagedEditNotification
removeallclassmethods RwPerformingUnpackagedEditNotification

doit
(RwNotification
	subclass: 'RwUnreadPackagesErrorNotification'
	instVarNames: #(errorMessage unreadPackageNames)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwUnreadPackagesErrorNotification
removeallclassmethods RwUnreadPackagesErrorNotification

doit
(Object
	subclass: 'CypressAbstractPackageFiler'
	instVarNames: #(repository packageDirectory packageStructure)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-GemStoneFileServer';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressAbstractPackageFiler
removeallclassmethods CypressAbstractPackageFiler

doit
(CypressAbstractPackageFiler
	subclass: 'CypressAbstractFileoutWriter'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-GemStoneFileServer';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressAbstractFileoutWriter
removeallclassmethods CypressAbstractFileoutWriter

doit
(CypressAbstractFileoutWriter
	subclass: 'CypressSmalltalkFileoutWriter'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-GemStoneFileServer';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressSmalltalkFileoutWriter
removeallclassmethods CypressSmalltalkFileoutWriter

doit
(CypressAbstractFileoutWriter
	subclass: 'CypressTopazFileoutWriter'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-GemStoneFileServer';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressTopazFileoutWriter
removeallclassmethods CypressTopazFileoutWriter

doit
(CypressAbstractPackageFiler
	subclass: 'CypressAbstractPackageReader'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-GemStoneFileServer';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressAbstractPackageReader
removeallclassmethods CypressAbstractPackageReader

doit
(CypressAbstractPackageReader
	subclass: 'CypressDoNothingPackageReader'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-GemStoneFileServer';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressDoNothingPackageReader
removeallclassmethods CypressDoNothingPackageReader

doit
(CypressAbstractPackageReader
	subclass: 'CypressFileTreeFormatPackageReader'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-GemStoneFileServer';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressFileTreeFormatPackageReader
removeallclassmethods CypressFileTreeFormatPackageReader

doit
(CypressAbstractPackageReader
	subclass: 'CypressFlexiblePackageReader'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-GemStoneFileServer';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressFlexiblePackageReader
removeallclassmethods CypressFlexiblePackageReader

doit
(CypressAbstractPackageReader
	subclass: 'CypressPackageReader'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-GemStoneFileServer';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressPackageReader
removeallclassmethods CypressPackageReader

doit
(CypressAbstractPackageFiler
	subclass: 'CypressAbstractPackageWriter'
	instVarNames: #()
	classVars: #()
	classInstVars: #(specials)
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-GemStoneFileServer';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressAbstractPackageWriter
removeallclassmethods CypressAbstractPackageWriter

doit
(CypressAbstractPackageWriter
	subclass: 'CypressFileTreeFormatPackageWriter'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-GemStoneFileServer';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressFileTreeFormatPackageWriter
removeallclassmethods CypressFileTreeFormatPackageWriter

doit
(CypressAbstractPackageWriter
	subclass: 'CypressPackageWriter'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-GemStoneFileServer';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressPackageWriter
removeallclassmethods CypressPackageWriter

doit
(CypressAbstractPackageWriter
	subclass: 'CypressStrictFileTreeFormatDoNothingPackageWriter'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-GemStoneFileServer';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressStrictFileTreeFormatDoNothingPackageWriter
removeallclassmethods CypressStrictFileTreeFormatDoNothingPackageWriter

doit
(Object
	subclass: 'CypressAbstractRepository'
	instVarNames: #(url properties readerClass writerClass)
	classVars: #(DefaultCopyrightNotice)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-PackageManagement';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressAbstractRepository
removeallclassmethods CypressAbstractRepository

doit
(CypressAbstractRepository
	subclass: 'CypressAbstractFileoutRepository'
	instVarNames: #(directoryPath)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-PackageManagement';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressAbstractFileoutRepository
removeallclassmethods CypressAbstractFileoutRepository

doit
(CypressAbstractFileoutRepository
	subclass: 'CypressSmalltalkRepository'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-PackageManagement';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.

This is a "write-only" repository.
It could be made readable, to be able to file-in Smalltalk scripts, but it''s not the same thing.
';
		immediateInvariant.
true.
%

removeallmethods CypressSmalltalkRepository
removeallclassmethods CypressSmalltalkRepository

doit
(CypressAbstractFileoutRepository
	subclass: 'CypressTopazRepository'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-PackageManagement';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.

This is a "write-only" repository.
It could be made readable, to be able to file-in Topaz scripts, but it''s not the same thing.
';
		immediateInvariant.
true.
%

removeallmethods CypressTopazRepository
removeallclassmethods CypressTopazRepository

doit
(CypressAbstractRepository
	subclass: 'CypressDictionaryRepository'
	instVarNames: #(dictionary)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-PackageManagement';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressDictionaryRepository
removeallclassmethods CypressDictionaryRepository

doit
(CypressAbstractRepository
	subclass: 'CypressFileSystemRepository'
	instVarNames: #(directoryPath)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-PackageManagement';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressFileSystemRepository
removeallclassmethods CypressFileSystemRepository

doit
(CypressFileSystemRepository
	subclass: 'CypressFileSystemGitRepository'
	instVarNames: #(remoteUrl)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-PackageManagement';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressFileSystemGitRepository
removeallclassmethods CypressFileSystemGitRepository

doit
(Object
	subclass: 'CypressFileUtilities'
	instVarNames: #()
	classVars: #(Current)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-GemStoneFileServer';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressFileUtilities
removeallclassmethods CypressFileUtilities

doit
(CypressFileUtilities
	subclass: 'CypressGemStoneDirectoryUtilities'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-GemStoneFileServer';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressGemStoneDirectoryUtilities
removeallclassmethods CypressGemStoneDirectoryUtilities

doit
(Object
	subclass: 'CypressGsGeneralDependencySorter'
	instVarNames: #(candidates dependsOnConverter dependentConverter individualDependencyMap dependencyGraphs candidateAliasMap)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Structure';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressGsGeneralDependencySorter
removeallclassmethods CypressGsGeneralDependencySorter

doit
(Object
	subclass: 'CypressJsonParser'
	instVarNames: #(stream)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Structure';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressJsonParser
removeallclassmethods CypressJsonParser

doit
(Object
	subclass: 'CypressObject'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Definitions';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressObject
removeallclassmethods CypressObject

doit
(CypressObject
	subclass: 'CypressAbstractPackageInformation'
	instVarNames: #(name)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-PackageManagement';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressAbstractPackageInformation
removeallclassmethods CypressAbstractPackageInformation

doit
(CypressAbstractPackageInformation
	subclass: 'CypressConflictingPackageInformation'
	instVarNames: #(conflictsWith)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-PackageManagement';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressConflictingPackageInformation
removeallclassmethods CypressConflictingPackageInformation

doit
(CypressAbstractPackageInformation
	subclass: 'CypressEclipsedPackageInformation'
	instVarNames: #(eclipsedBy)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-PackageManagement';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressEclipsedPackageInformation
removeallclassmethods CypressEclipsedPackageInformation

doit
(CypressAbstractPackageInformation
	subclass: 'CypressKnownPackageInformation'
	instVarNames: #(repositories digests)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-PackageManagement';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressKnownPackageInformation
removeallclassmethods CypressKnownPackageInformation

doit
(CypressAbstractPackageInformation
	subclass: 'CypressUnknownPackageInformation'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-PackageManagement';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressUnknownPackageInformation
removeallclassmethods CypressUnknownPackageInformation

doit
(CypressObject
	subclass: 'CypressDefinition'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Definitions';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressDefinition
removeallclassmethods CypressDefinition

doit
(CypressDefinition
	subclass: 'CypressClassDefinition'
	instVarNames: #(category classInstVarNames classVarNames comment defaultSymbolDictionaryName instVarNames name poolDictionaryNames subclassType superclassName gs_options gs_constraints)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Definitions';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressClassDefinition
removeallclassmethods CypressClassDefinition

doit
(CypressDefinition
	subclass: 'CypressMethodDefinition'
	instVarNames: #(category classIsMeta className selector source)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Definitions';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressMethodDefinition
removeallclassmethods CypressMethodDefinition

doit
(CypressMethodDefinition
	subclass: 'RwCypressMethodDefinition'
	instVarNames: #(isExtensionMethod)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Cypress-Core';
		immediateInvariant.
true.
%

removeallmethods RwCypressMethodDefinition
removeallclassmethods RwCypressMethodDefinition

doit
(CypressObject
	subclass: 'CypressDefinitionIndex'
	instVarNames: #(definitionMap)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Definitions';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressDefinitionIndex
removeallclassmethods CypressDefinitionIndex

doit
(CypressObject
	subclass: 'CypressDependencySorter'
	instVarNames: #(orderedItems provided required)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Definitions';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressDependencySorter
removeallclassmethods CypressDependencySorter

doit
(CypressDependencySorter
	subclass: 'CypressEnvironmentDependencySorter'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Environmental-Tools';
		immediateInvariant.
true.
%

removeallmethods CypressEnvironmentDependencySorter
removeallclassmethods CypressEnvironmentDependencySorter

doit
(CypressObject
	subclass: 'CypressLoader'
	instVarNames: #(additions defaultSymbolDictionaryName errors exceptionClass methodAdditions obsoletions provisions removals requirements unloadable)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Definitions';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressLoader
removeallclassmethods CypressLoader

doit
(CypressLoader
	subclass: 'CypressEnvironmentLoader'
	instVarNames: #(defaultEnvironmentId lookupSymbolList compilationSymbolList)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Environmental-Tools';
		immediateInvariant.
true.
%

removeallmethods CypressEnvironmentLoader
removeallclassmethods CypressEnvironmentLoader

doit
(CypressObject
	subclass: 'CypressPackageDefinition'
	instVarNames: #(name)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Definitions';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressPackageDefinition
removeallclassmethods CypressPackageDefinition

doit
(CypressPackageDefinition
	subclass: 'CypressEnvironmentPackageDefinition'
	instVarNames: #(lookupSymbolList)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Environmental-Tools';
		comment: 'No class-specific documentation for CypressEnvironmentPackageDefinition, hierarchy is: 
Object
  CypressObject
    CypressPackageDefinition( name)
      CypressEnvironmentPackageDefinition( lookupSymbolList)
';
		immediateInvariant.
true.
%

removeallmethods CypressEnvironmentPackageDefinition
removeallclassmethods CypressEnvironmentPackageDefinition

doit
(CypressObject
	subclass: 'CypressPackageInformation'
	instVarNames: #(name type advice competingPackageNames imageDefinitions savedDefinitions savedLocation repository repositoryDescription imageCounts changesCount)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-PackageManagement';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.

CypressPackageInformation documents potential and actual packages for the Cypress Package Manager. 

Candidate package names come from class categories and from method categories beginning with an asterisk. Category names may contain more information than just the package name, such as logical subdivisions within a package or method categorization in addition to the package name. For example, a Package might be named X or Y-Z or whatever. Classes could be categorized as X, Y-Z, X-A, or Y-Z-A, and methods could be categorized as *X, *Y-Z, *X-A, *Y-Z-A, etc. (The various letters X, Y, Z, and A can represent almost any sequence of characters, in either uppercase, lowercase, or both. Package names are case-insensitive.)

There are four types of CypressPackageInformation objects:
 - Known Package - those which are known to represent real packages (e.g., Y-Z). In general, it is because there is a savedLocation specified.
 - Qualified Name - the name is a Known Package name qualified by further details, and cannot be used to represent a Known Package (e.g., X-accessing).
 - Conflicted Name - the name is a prefix of a Known Package name (e.g. given a Known Package named Y-Z, there can be no package named Y).
 - Unknown - the name could represent a package, but it is not known to do so.

Instance Variables
	advice	<String>	Additional information about the type of the instance, usually used only for Qualified Names and Conflcited Names.
	changesCount	<Integer>	The number of differences between the in-image definitions of the package and the definitions previously saved to disk.
	competingPackageNames	<String>*	0 or more strings naming packages in competition with this one.
	imageCounts	<Integer pair>	The number of classes and the number of methods in the image for the package.
	name	<String>	The name of the package or potential package.
	savedLocation	<String>	The path to the directory in which the package was or should be saved, with a trailing slash (e.g., /usr/src/project/).
	type	<String>	One of ''Known Package'', ''Qualified Name'', ''Conflicted Name'', and ''Unknown''.
	imageDefinitions	<CypressDefinition>*	0 or more definitions from the image.
	savedDefinitions	<CypressDefinition>*	0 or more definitions from the savedLocation storage.

';
		immediateInvariant.
true.
%

removeallmethods CypressPackageInformation
removeallclassmethods CypressPackageInformation

doit
(CypressObject
	subclass: 'CypressPatch'
	instVarNames: #(operations)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Definitions';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressPatch
removeallclassmethods CypressPatch

doit
(CypressObject
	subclass: 'CypressPatchOperation'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Definitions';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressPatchOperation
removeallclassmethods CypressPatchOperation

doit
(CypressPatchOperation
	subclass: 'CypressAddition'
	instVarNames: #(definition)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Definitions';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressAddition
removeallclassmethods CypressAddition

doit
(CypressPatchOperation
	subclass: 'CypressModification'
	instVarNames: #(modification obsoletion)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Definitions';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressModification
removeallclassmethods CypressModification

doit
(CypressPatchOperation
	subclass: 'CypressRemoval'
	instVarNames: #(definition)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Definitions';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressRemoval
removeallclassmethods CypressRemoval

doit
(CypressObject
	subclass: 'CypressSnapshot'
	instVarNames: #(definitions)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Definitions';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressSnapshot
removeallclassmethods CypressSnapshot

doit
(CypressObject
	subclass: 'CypressStructure'
	instVarNames: #(name properties packageStructure)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Structure';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressStructure
removeallclassmethods CypressStructure

doit
(CypressStructure
	subclass: 'CypressClassStructure'
	instVarNames: #(instanceMethods classMethods comment isClassExtension)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Structure';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressClassStructure
removeallclassmethods CypressClassStructure

doit
(CypressStructure
	subclass: 'CypressMethodStructure'
	instVarNames: #(source isMetaclass classStructure)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Structure';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressMethodStructure
removeallclassmethods CypressMethodStructure

doit
(CypressMethodStructure
	subclass: 'RwCypressMethodStructure'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Cypress-Core';
		immediateInvariant.
true.
%

removeallmethods RwCypressMethodStructure
removeallclassmethods RwCypressMethodStructure

doit
(CypressStructure
	subclass: 'CypressPackageStructure'
	instVarNames: #(classes extensions)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Structure';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressPackageStructure
removeallclassmethods CypressPackageStructure

doit
(CypressPackageStructure
	subclass: 'RwCypressPackageStructure'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Cypress-Core';
		immediateInvariant.
true.
%

removeallmethods RwCypressPackageStructure
removeallclassmethods RwCypressPackageStructure

doit
(Object
	subclass: 'CypressPackageComparator'
	instVarNames: #(directoryPackageMap diskTimestamps diskSnapshots imageSnapshots snapshotDifferences currentPackageName currentAdditions currentRemovals)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Comparison';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressPackageComparator
removeallclassmethods CypressPackageComparator

doit
(Object
	subclass: 'CypressPackageManager'
	instVarNames: #(knownPackages knownRepositories packageInformationList)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-PackageManagement';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressPackageManager
removeallclassmethods CypressPackageManager

doit
(Object
	subclass: 'CypressPackageManager2'
	instVarNames: #(knownRepositories packageInformationList)
	classVars: #(SavedPackageManagers)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-PackageManagement';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressPackageManager2
removeallclassmethods CypressPackageManager2

doit
(Object
	subclass: 'CypressPackageManager3'
	instVarNames: #(knownRepositories defaultSymbolDictionaryName resolvedPackageReferences)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-PackageManagement';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressPackageManager3
removeallclassmethods CypressPackageManager3

doit
(CypressPackageManager3
	subclass: 'CypressEnvironmentPackageManager'
	instVarNames: #(defaultSymbolList lookupSymbolList compilationSymbolList defaultEnvironmentId)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Environmental-Tools';
		immediateInvariant.
true.
%

removeallmethods CypressEnvironmentPackageManager
removeallclassmethods CypressEnvironmentPackageManager

doit
(Object
	subclass: 'CypressPackageStringComparator'
	instVarNames: #(directoryPackageMap diskTimestamps diskSnapshots imageSnapshots snapshotDifferences currentPackageName currentOperations)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Comparison';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressPackageStringComparator
removeallclassmethods CypressPackageStringComparator

doit
(Object
	subclass: 'CypressReference'
	instVarNames: #(name)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-PackageManagement';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.

A CypressReference is an abstract superclass for various kinds of references to Cypress packages. Inspired by GoferReference in Pharo';
		immediateInvariant.
true.
%

removeallmethods CypressReference
removeallclassmethods CypressReference

doit
(CypressReference
	subclass: 'CypressPackageReference'
	instVarNames: #(package branch)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-PackageManagement';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.

A CypressPackageReference refers to a specific Cypress package.';
		immediateInvariant.
true.
%

removeallmethods CypressPackageReference
removeallclassmethods CypressPackageReference

doit
(CypressPackageReference
	subclass: 'CypressResolvedReference'
	instVarNames: #(repository)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-PackageManagement';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.

A CypressResolvedReference refers to a specific Cypress package in a repository. This class is the only one that can actually load a package, because it is the only one knowing where to find it.';
		immediateInvariant.
true.
%

removeallmethods CypressResolvedReference
removeallclassmethods CypressResolvedReference

doit
(Object
	subclass: 'CypressUrl'
	instVarNames: #(fragment)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Network-Url';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.

A Uniform Resource Locator.  It specifies the location of a document on the Internet.  The base class is abstract; child classes break different types of URLs down in ways appropriate for that type.';
		immediateInvariant.
true.
%

removeallmethods CypressUrl
removeallclassmethods CypressUrl

doit
(CypressUrl
	subclass: 'CypressFileUrl'
	instVarNames: #(host path isAbsolute)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Network-Url';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.

This class models a file URL according to (somewhat) RFC1738, see http://www.w3.org/Addressing/rfc1738.txt

Here is the relevant part of the RFC:

3.10 FILES

   The file URL scheme is used to designate files accessible on a
   particular host computer. This scheme, unlike most other URL schemes,
   does not designate a resource that is universally accessible over the
   Internet.

   A file URL takes the form:

       file://<host>/<path>

   where <host> is the fully qualified domain name of the system on
   which the <path> is accessible, and <path> is a hierarchical
   directory path of the form <directory>/<directory>/.../<name>.

   For example, a VMS file

     DISK$USER:[MY.NOTES]NOTE123456.TXT

   might become

     <URL:file://vms.host.edu/disk$user/my/notes/note12345.txt>

   As a special case, <host> can be the string "localhost" or the empty
   string; this is interpreted as `the machine from which the URL is
   being interpreted''.

   The file URL scheme is unusual in that it does not specify an
   Internet protocol or access method for such files; as such, its
   utility in network protocols between hosts is limited.

From the above we can conclude that the RFC says that the <path> part never starts or ends with a slash and is always absolute. If the last name can be a directory instead of a file is not specified clearly.

The path is stored as a SequenceableCollection of path parts.

Notes regarding non RFC features in this class:

- If the last path part is the empty string, then the FileUrl is referring to a directory. This is also shown with a trailing slash when converted to a String.

- The FileUrl has an attribute isAbsolute which signals if the path should be considered absolute or relative to the current directory. This distinction is not visible in the String representation of FileUrl, since the RFC does not have that.

- Fragment is supported (kept for historical reasons)

';
		immediateInvariant.
true.
%

removeallmethods CypressFileUrl
removeallclassmethods CypressFileUrl

doit
(CypressFileUrl
	subclass: 'CypressAbstractFileUrl'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-PackageManagement';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressAbstractFileUrl
removeallclassmethods CypressAbstractFileUrl

doit
(CypressAbstractFileUrl
	subclass: 'CypressCypressFileUrl'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-PackageManagement';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressCypressFileUrl
removeallclassmethods CypressCypressFileUrl

doit
(CypressAbstractFileUrl
	subclass: 'CypressFileTreeFormatFileUrl'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-PackageManagement';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressFileTreeFormatFileUrl
removeallclassmethods CypressFileTreeFormatFileUrl

doit
(CypressAbstractFileUrl
	subclass: 'CypressFileTreeReadOnlyFileUrl'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-PackageManagement';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressFileTreeReadOnlyFileUrl
removeallclassmethods CypressFileTreeReadOnlyFileUrl

doit
(CypressAbstractFileUrl
	subclass: 'CypressGitFileUrl'
	instVarNames: #(projectPath projectBranchOrTag repositoryPath)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-PackageManagement';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressGitFileUrl
removeallclassmethods CypressGitFileUrl

doit
(CypressGitFileUrl
	subclass: 'CypressGitFileTreeUrl'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-PackageManagement';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressGitFileTreeUrl
removeallclassmethods CypressGitFileTreeUrl

doit
(CypressAbstractFileUrl
	subclass: 'CypressLaxFileUrl'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-PackageManagement';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressLaxFileUrl
removeallclassmethods CypressLaxFileUrl

doit
(CypressAbstractFileUrl
	subclass: 'CypressSmalltalkUrl'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-PackageManagement';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressSmalltalkUrl
removeallclassmethods CypressSmalltalkUrl

doit
(CypressAbstractFileUrl
	subclass: 'CypressTopazUrl'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-PackageManagement';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressTopazUrl
removeallclassmethods CypressTopazUrl

doit
(CypressUrl
	subclass: 'CypressGenericUrl'
	instVarNames: #(schemeName locator)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Network-Url';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.

a URL type that can''t be broken down in any systematic way.  For example, mailto: and telnet: URLs.  The part after the scheme name is stored available via the #locator message.';
		immediateInvariant.
true.
%

removeallmethods CypressGenericUrl
removeallclassmethods CypressGenericUrl

doit
(CypressGenericUrl
	subclass: 'CypressBrowserUrl'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Network-Url';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.

URLs that instruct a browser to do something.';
		immediateInvariant.
true.
%

removeallmethods CypressBrowserUrl
removeallclassmethods CypressBrowserUrl

doit
(CypressGenericUrl
	subclass: 'CypressMailtoUrl'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Network-Url';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.

a URL specifying a mailing address; activating it triggers a mail-sender to start up, if one is present.';
		immediateInvariant.
true.
%

removeallmethods CypressMailtoUrl
removeallclassmethods CypressMailtoUrl

doit
(CypressUrl
	subclass: 'CypressHierarchicalUrl'
	instVarNames: #(schemeName authority path query port username password)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Network-Url';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.

A URL which has a hierarchical encoding.  For instance, http and ftp URLs are hierarchical.';
		immediateInvariant.
true.
%

removeallmethods CypressHierarchicalUrl
removeallclassmethods CypressHierarchicalUrl

doit
(CypressHierarchicalUrl
	subclass: 'CypressFtpUrl'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Network-Url';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressFtpUrl
removeallclassmethods CypressFtpUrl

doit
(CypressHierarchicalUrl
	subclass: 'CypressHttpUrl'
	instVarNames: #(realm)
	classVars: #(Passwords)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Network-Url';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.

A URL that can be accessed via the Hypertext Transfer Protocol (HTTP), ie, a standard Web URL

realm = the name of the security realm that has been discovered for this URL.   Look it up in Passwords.

Passwords = a Dictionary of (realm -> encoded user&password)


TODO: use the username and password, if specified
';
		immediateInvariant.
true.
%

removeallmethods CypressHttpUrl
removeallclassmethods CypressHttpUrl

doit
(CypressHttpUrl
	subclass: 'CypressHttpsUrl'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-Network-Url';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressHttpsUrl
removeallclassmethods CypressHttpsUrl

doit
(Object
	subclass: 'CypressVersionReference'
	instVarNames: #(name package author branch versionNumber)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-PackageManagement';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.

A CypressVersionReference refers to a specific version of a Monticello package.';
		immediateInvariant.
true.
%

removeallmethods CypressVersionReference
removeallclassmethods CypressVersionReference

doit
(Object
	subclass: 'GsInteraction'
	instVarNames: #(defaultActionBlock)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'GemStone-Interactions-Core';
		immediateInvariant.
true.
%

removeallmethods GsInteraction
removeallclassmethods GsInteraction

doit
(GsInteraction
	subclass: 'GsChoiceInteraction'
	instVarNames: #(prompt labels values lines)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'GemStone-Interactions-Core';
		immediateInvariant.
true.
%

removeallmethods GsChoiceInteraction
removeallclassmethods GsChoiceInteraction

doit
(GsInteraction
	subclass: 'GsConfirmInteraction'
	instVarNames: #(prompt confirm cancel abort)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'GemStone-Interactions-Core';
		immediateInvariant.
true.
%

removeallmethods GsConfirmInteraction
removeallclassmethods GsConfirmInteraction

doit
(GsConfirmInteraction
	subclass: 'GsNotifyInteraction'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'GemStone-Interactions-Core';
		immediateInvariant.
true.
%

removeallmethods GsNotifyInteraction
removeallclassmethods GsNotifyInteraction

doit
(GsInteraction
	subclass: 'GsInformInteraction'
	instVarNames: #(message)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'GemStone-Interactions-Core';
		immediateInvariant.
true.
%

removeallmethods GsInformInteraction
removeallclassmethods GsInformInteraction

doit
(GsInteraction
	subclass: 'GsInspectInteraction'
	instVarNames: #(theObject)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'GemStone-Interactions-Core';
		immediateInvariant.
true.
%

removeallmethods GsInspectInteraction
removeallclassmethods GsInspectInteraction

doit
(GsInspectInteraction
	subclass: 'GsExploreInteraction'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'GemStone-Interactions-Core';
		immediateInvariant.
true.
%

removeallmethods GsExploreInteraction
removeallclassmethods GsExploreInteraction

doit
(GsInteraction
	subclass: 'GsTextInteraction'
	instVarNames: #(prompt template requestPassword)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'GemStone-Interactions-Core';
		immediateInvariant.
true.
%

removeallmethods GsTextInteraction
removeallclassmethods GsTextInteraction

doit
(GsTextInteraction
	subclass: 'GsMultiLineTextInteraction'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'GemStone-Interactions-Core';
		immediateInvariant.
true.
%

removeallmethods GsMultiLineTextInteraction
removeallclassmethods GsMultiLineTextInteraction

doit
(Object
	subclass: 'GsInteractionHandler'
	instVarNames: #(choiceBlock confirmBlock informBlock textBlock multiLineTextBlock defaultBlock inspectBlock)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'GemStone-Interactions-Core';
		immediateInvariant.
true.
%

removeallmethods GsInteractionHandler
removeallclassmethods GsInteractionHandler

doit
(Object
	subclass: 'GsTonelOrderedDictionary'
	instVarNames: #(size keys values)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-Core';
		comment: 'I am an implementation of a dictionary. Compared to other dictionaries I am very efficient for small sizes, speed- and space-wise. I also mantain the order in which elements are added when iterating. My implementation features some ideas from the RefactoringBrowser.';
		immediateInvariant.
true.
%

removeallmethods GsTonelOrderedDictionary
removeallclassmethods GsTonelOrderedDictionary

doit
(Object
	subclass: 'RBParser'
	instVarNames: #(scanner currentToken nextToken errorBlock source comments pragmas)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBParser takes a source code string and generates an AST for it. This is a hand-written, recursive descent parser and has been optimized for speed. The simplest way to call this is either ''RBParser parseExpression: aString'' if you want the AST for an expression, or ''RBParser parseMethod: aString'' if you want to parse an entire method.

Instance Variables:
	currentToken	<RBToken>	The current token being processed.
	emptyStatements	<Boolean>	True if empty statements are allowed. In IBM, they are, in VW they aren''t.
	errorBlock	<BlockClosure>	The block to evaluate on a syntax error.
	nextToken	<RBToken>	The next token that will be processed. This allows one-token lookahead.
	scanner	<RBScanner>	The scanner that generates a stream of tokens to parse.
	source	<String>	The source code to parse
	tags	<Collection of: Interval>	The source intervals of the tags appearing at the top of a method (e.g. Primitive calls)

Shared Variables:
	ParserType	<Symbol>	the type code we are parsing';
		immediateInvariant.
true.
%

removeallmethods RBParser
removeallclassmethods RBParser

doit
(RBParser
	subclass: 'RBPatternParser'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBPatternParser is a subclass of RBParser that allows the extended syntax that creates matching trees. These trees can be used by the ParseTreeMatcher to search and transform source code.
';
		immediateInvariant.
true.
%

removeallmethods RBPatternParser
removeallclassmethods RBPatternParser

doit
(RBParser
	subclass: 'RBTonelParser'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		immediateInvariant.
true.
%

removeallmethods RBTonelParser
removeallclassmethods RBTonelParser

doit
(Object
	subclass: 'RBParseTreeRule'
	instVarNames: #(searchTree owner)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBParseTreeRule is the abstract superclass of all of the parse tree searching rules. A parse tree rule is the first class representation of a particular rule to search for. The owner of a rule is the algorithm that actually executes the search. This arrangement allows multiple searches to be conducted by a single Searcher.

Instance Variables:
	owner	<ParseTreeSearcher>	The searcher that is actually performing the search.
	searchTree	<RBProgramNode>	The parse tree to be searched.

';
		immediateInvariant.
true.
%

removeallmethods RBParseTreeRule
removeallclassmethods RBParseTreeRule

doit
(RBParseTreeRule
	subclass: 'RBReplaceRule'
	instVarNames: #(verificationBlock)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBReplaceRule is the abstract superclass of all of the transforming rules. The rules change the source code by replacing the node that matches the rule. Subclasses implement different strategies for this replacement.

Subclasses must implement the following messages:
	matching
		foundMatchFor:

Instance Variables:
	verificationBlock	<BlockClosure>	Is evaluated with the matching node. This allows for further verification of a match beyond simple tree matching.

';
		immediateInvariant.
true.
%

removeallmethods RBReplaceRule
removeallclassmethods RBReplaceRule

doit
(RBReplaceRule
	subclass: 'RBBlockReplaceRule'
	instVarNames: #(replaceBlock)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBBlockReplaceRule replaces the matching node by the result of evaluating replaceBlock. This allows arbitrary computation to come up with a replacement.

Instance Variables:
	replaceBlock	<BlockClosure>	The block that returns the node to replace to matching node with.
';
		immediateInvariant.
true.
%

removeallmethods RBBlockReplaceRule
removeallclassmethods RBBlockReplaceRule

doit
(RBReplaceRule
	subclass: 'RBStringReplaceRule'
	instVarNames: #(replaceTree)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBStringReplaceRule replaces a matched tree with another tree (which may include metavariable from the matching tree). This is a very succint syntax for specifying most rewrites.

Instance Variables:
	replaceTree	<RBProgramNode>	The tree to replace the matched tree with.

';
		immediateInvariant.
true.
%

removeallmethods RBStringReplaceRule
removeallclassmethods RBStringReplaceRule

doit
(RBParseTreeRule
	subclass: 'RBSearchRule'
	instVarNames: #(answerBlock)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBSearchRule is a parse tree rule that simply searches for matches to the rule. Every time a match is found, answerBlock is evaluated with the node that matches and the cureent answer. This two-argument approach allows a collection to be formed from all of the matches (Think inject:into:).

Instance Variables:
	answerBlock	<BlockClosure>	Block to evaluate with the matching node and the current answer.

';
		immediateInvariant.
true.
%

removeallmethods RBSearchRule
removeallclassmethods RBSearchRule

doit
(Object
	subclass: 'RBProgramNode'
	instVarNames: #(parent comments properties)
	classVars: #(FormatterClass)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBProgramNode is an abstract class that represents an abstract syntax tree node in a Smalltalk program.

Subclasses must implement the following messages:
	accessing
		start
		stop
	visitor
		acceptVisitor:

The #start and #stop methods are used to find the source that corresponds to this node. "source copyFrom: self start to: self stop" should return the source for this node.

The #acceptVisitor: method is used by RBProgramNodeVisitors (the visitor pattern). This will also require updating all the RBProgramNodeVisitors so that they know of the new node.

Subclasses might also want to redefine match:inContext: and copyInContext: to do parse tree searching and replacing.

Subclasses that contain other nodes should override equalTo:withMapping: to compare nodes while ignoring renaming temporary variables, and children that returns a collection of our children nodes.

Instance Variables:
	comments	<Collection of: Interval>	the intervals in the source that have comments for this node
	parent	<RBProgramNode>	the node we''re contained in

Shared Variables:
	FormatterClass	<Behavior>	the formatter class that is used when we are formatted';
		immediateInvariant.
true.
%

removeallmethods RBProgramNode
removeallclassmethods RBProgramNode

doit
(RBProgramNode
	subclass: 'RBMethodNode'
	instVarNames: #(selector selectorParts body source arguments pragmas replacements nodeReplacements)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBMethodNode is the AST that represents a Smalltalk method.

Instance Variables:
	arguments	<SequenceableCollection of: RBVariableNode>	the arguments to the method
	body	<BRSequenceNode>	the body/statements of the method
	nodeReplacements	<Dictionary>	a dictionary of oldNode -> newNode replacements
	replacements	<Collection of: RBStringReplacement>	the collection of string replacements for each node replacement in the parse tree
	selector	<Symbol | nil>	the method name (cached)
	selectorParts	<SequenceableCollection of: RBValueToken>	the tokens for the selector keywords
	source	<String>	the source we compiled
	tags	<Collection of: Interval>	the source location of any resource/primitive tags

';
		immediateInvariant.
true.
%

removeallmethods RBMethodNode
removeallclassmethods RBMethodNode

doit
(RBMethodNode
	subclass: 'RBPatternMethodNode'
	instVarNames: #(isList)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBPatternMethodNode is a RBMethodNode that will match other method nodes without their selectors being equal. 

Instance Variables:
	isList	<Boolean>	are we matching each keyword or matching all keywords together (e.g., `keyword1: would match a one argument method whereas `@keywords: would match 0 or more arguments)

';
		immediateInvariant.
true.
%

removeallmethods RBPatternMethodNode
removeallclassmethods RBPatternMethodNode

doit
(RBProgramNode
	subclass: 'RBPragmaNode'
	instVarNames: #(selector selectorParts arguments isProtected left right)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBPragmaNode is an AST node that represents a method pragma.

Instance Variables:
	arguments <SequenceableCollection of: RBLiteralNode> our argument nodes
	left <Integer | nil> position of <
	right <Integer | nil> position of >
	selector <Symbol | nil>	the selector we''re sending (cached)
	selectorParts <SequenceableCollection of: RBValueToken> the tokens for each keyword';
		immediateInvariant.
true.
%

removeallmethods RBPragmaNode
removeallclassmethods RBPragmaNode

doit
(RBPragmaNode
	subclass: 'RBPatternPragmaNode'
	instVarNames: #(isList)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		immediateInvariant.
true.
%

removeallmethods RBPatternPragmaNode
removeallclassmethods RBPatternPragmaNode

doit
(RBProgramNode
	subclass: 'RBReturnNode'
	instVarNames: #(return value)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBReturnNode is an AST node that represents a return expression.

Instance Variables:
	return	<Integer>	the position of the ^ character
	value	<RBValueNode>	the value that is being returned

';
		immediateInvariant.
true.
%

removeallmethods RBReturnNode
removeallclassmethods RBReturnNode

doit
(RBProgramNode
	subclass: 'RBSequenceNode'
	instVarNames: #(leftBar rightBar statements periods temporaries)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBSequenceNode is an AST node that represents a sequence of statements. Both RBBlockNodes and RBMethodNodes contain these.

Instance Variables:
	leftBar	<Integer | nil>	the position of the left | in the temporaries definition
	periods	<SequenceableCollection of: Integer>	the positions of all the periods that separate the statements
	rightBar	<Integer | nil>	the position of the right | in the temporaries definition
	statements	<SequenceableCollection of: RBStatementNode>	the statement nodes
	temporaries	<SequenceableCollection of: RBVariableNode>	the temporaries defined

';
		immediateInvariant.
true.
%

removeallmethods RBSequenceNode
removeallclassmethods RBSequenceNode

doit
(RBProgramNode
	subclass: 'RBValueNode'
	instVarNames: #(parentheses)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBValueNode is an abstract class that represents a node that returns some value.

Subclasses must implement the following messages:
	accessing
		startWithoutParentheses
		stopWithoutParentheses
	testing
		needsParenthesis

Instance Variables:
	parentheses	<SequenceableCollection of: Inteval>	the positions of the parethesis around this node. We need a collection of intervals for stupid code such as "((3 + 4))" that has multiple parethesis around the same expression.

';
		immediateInvariant.
true.
%

removeallmethods RBValueNode
removeallclassmethods RBValueNode

doit
(RBValueNode
	subclass: 'RBArrayNode'
	instVarNames: #(left right statements periods)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'A RBArrayNode is an AST node for runtime arrays.

Instance Variables
	left:	 <Integer | nil> position of {
	periods: <SequenceableCollection of: Integer> the positions of all the periods that separate the statements
	right: <Integer | nil> position of }
	statements: <SequenceableCollection of: RBStatementNode> the statement nodes';
		immediateInvariant.
true.
%

removeallmethods RBArrayNode
removeallclassmethods RBArrayNode

doit
(RBValueNode
	subclass: 'RBAssignmentNode'
	instVarNames: #(variable assignment value)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBAssignmentNode is an AST node for assignment statements

Instance Variables:
	assignment	<Integer>	position of the :=
	value	<RBValueNode>	the value that we''re assigning
	variable	<RBVariableNode>	the variable being assigned

';
		immediateInvariant.
true.
%

removeallmethods RBAssignmentNode
removeallclassmethods RBAssignmentNode

doit
(RBValueNode
	subclass: 'RBBlockNode'
	instVarNames: #(left right colons arguments bar body)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBBlockNode is an AST node that represents a block "[...]".

Instance Variables:
	arguments	<SequenceableCollection of: RBVariableNode>	the arguments for the block
	bar	<Integer | nil>	position of the | after the arguments
	body	<RBSequenceNode>	the code inside the block
	colons	<SequenceableCollection of: Integer>	positions of each : before each argument
	left	<Integer>	position of [
	right	<Integer>	position of ]

';
		immediateInvariant.
true.
%

removeallmethods RBBlockNode
removeallclassmethods RBBlockNode

doit
(RBBlockNode
	subclass: 'RBPatternBlockNode'
	instVarNames: #(valueBlock)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBPatternBlockNode is the node in matching parse trees (it never occurs in normal Smalltalk code) that executes a block to determine if a match occurs. valueBlock takes two arguments, the first is the actual node that we are trying to match against, and second node is the dictionary that contains all the metavariable bindings that the matcher has made thus far.

Instance Variables:
	valueBlock	<BlockClosure>	The block to execute when attempting to match this to a node.

';
		immediateInvariant.
true.
%

removeallmethods RBPatternBlockNode
removeallclassmethods RBPatternBlockNode

doit
(RBPatternBlockNode
	subclass: 'RBPatternWrapperBlockNode'
	instVarNames: #(wrappedNode)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBPatternWrapperBlockNode allows further matching using a block after a node has been matched by a pattern node.

Instance Variables:
	wrappedNode	<RBProgramNode>	The original pattern node to match';
		immediateInvariant.
true.
%

removeallmethods RBPatternWrapperBlockNode
removeallclassmethods RBPatternWrapperBlockNode

doit
(RBBlockNode
	subclass: 'RBQueryBlockNode'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		immediateInvariant.
true.
%

removeallmethods RBQueryBlockNode
removeallclassmethods RBQueryBlockNode

doit
(RBValueNode
	subclass: 'RBCascadeNode'
	instVarNames: #(messages semicolons)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBCascadeNode is an AST node for cascaded messages (e.g., "self print1 ; print2").

Instance Variables:
	messages	<SequenceableCollection of: RBMessageNode>	the messages 
	semicolons	<SequenceableCollection of: Integer>	positions of the ; between messages

';
		immediateInvariant.
true.
%

removeallmethods RBCascadeNode
removeallclassmethods RBCascadeNode

doit
(RBValueNode
	subclass: 'RBLiteralNode'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBLiteralNode is an AST node that represents literals.';
		immediateInvariant.
true.
%

removeallmethods RBLiteralNode
removeallclassmethods RBLiteralNode

doit
(RBLiteralNode
	subclass: 'RBLiteralArrayNode'
	instVarNames: #(isByteArray stop contents start)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'A RBLiteralArrayNode is an AST node that represents literal arrays and literal byte arrays.

Instance Variables
	contents: <Array of: RBLiteralNode> literal nodes of the array
	isByteArray: <Boolean> if the receiver is a literal byte array
	start: <Integer | nil> source position of #( or #[
	stop: <Integer | nil> source position of ) or ]';
		immediateInvariant.
true.
%

removeallmethods RBLiteralArrayNode
removeallclassmethods RBLiteralArrayNode

doit
(RBLiteralNode
	subclass: 'RBLiteralValueNode'
	instVarNames: #(token)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBLiteralNode is an AST node that represents literal values (e.g., #foo, true, 1, etc.), but not literal arrays.

Instance Variables:
	token	<RBLiteralToken>	the token that contains the literal value as well as its source positions';
		immediateInvariant.
true.
%

removeallmethods RBLiteralValueNode
removeallclassmethods RBLiteralValueNode

doit
(RBValueNode
	subclass: 'RBMessageNode'
	instVarNames: #(receiver selector selectorParts arguments)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBMessageNode is an AST node that represents a message send.

Instance Variables:
	arguments	<SequenceableCollection of: RBValueNode>	our argument nodes
	receiver	<RBValueNode>	the receiver''s node
	selector	<Symbol | nil>	the selector we''re sending (cached)
	selectorParts	<SequenceableCollection of: RBValueToken>	the tokens for each keyword

';
		immediateInvariant.
true.
%

removeallmethods RBMessageNode
removeallclassmethods RBMessageNode

doit
(RBMessageNode
	subclass: 'RBPatternMessageNode'
	instVarNames: #(isList isCascadeList)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBPatternMessageNode is a RBMessageNode that will match other message nodes without their selectors being equal. 

Instance Variables:
	isCascadeList	<Boolean>	are we matching a list of message nodes in a cascaded message
	isList	<Boolean>	are we matching each keyword or matching all keywords together (e.g., `keyword1: would match a one argument method whereas `@keywords: would match 0 or more arguments)';
		immediateInvariant.
true.
%

removeallmethods RBPatternMessageNode
removeallclassmethods RBPatternMessageNode

doit
(RBValueNode
	subclass: 'RBVariableNode'
	instVarNames: #(token)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBVariableNode is an AST node that represent a variable (global, inst var, temp, etc.).

Instance Variables:
	token	<RBValueToken>	the token that contains our name and position

';
		immediateInvariant.
true.
%

removeallmethods RBVariableNode
removeallclassmethods RBVariableNode

doit
(RBVariableNode
	subclass: 'RBPatternVariableNode'
	instVarNames: #(recurseInto isList isLiteral isStatement isAnything)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBPatternVariableNode is an AST node that is used to match several other types of nodes (literals, variables, value nodes, statement nodes, and sequences of statement nodes).

The different types of matches are determined by the name of the node. If the name contains a # character, then it will match a literal. If it contains, a . then it matches statements. If it contains no extra characters, then it matches only variables. These options are mutually exclusive.

The @ character can be combined with the name to match lists of items. If combined with the . character, then it will match a list of statement nodes (0 or more). If used without the . or # character, then it matches anything except for list of statements. Combining the @ with the # is not supported.

Adding another ` in the name will cause the search/replace to look for more matches inside the node that this node matched. This option should not be used for top level expressions since that would cause infinite recursion (e.g., searching only for "``@anything").

Instance Variables:
	isAnything	<Boolean>	can we match any type of node
	isList	<Boolean>	can we match a list of items (@)
	isLiteral	<Boolean>	only match a literal node (#)
	isStatement	<Boolean>	only match statements (.)
	recurseInto	<Boolean>	search for more matches in the node we match (`)

';
		immediateInvariant.
true.
%

removeallmethods RBPatternVariableNode
removeallclassmethods RBPatternVariableNode

doit
(RBProgramNode
	subclass: 'RBWorkspaceNode'
	instVarNames: #(body source)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		immediateInvariant.
true.
%

removeallmethods RBWorkspaceNode
removeallclassmethods RBWorkspaceNode

doit
(Object
	subclass: 'RBProgramNodeVisitor'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBProgramNodeVisitor is an abstract visitor for the RBProgramNodes.

';
		immediateInvariant.
true.
%

removeallmethods RBProgramNodeVisitor
removeallclassmethods RBProgramNodeVisitor

doit
(RBProgramNodeVisitor
	subclass: 'RBConfigurableFormatter'
	instVarNames: #(codeStream indent lookaheadCode originalSource lineStart inQueryBlock)
	classVars: #(CascadedMessageInsideParentheses FormatCommentWithStatements IndentsForKeywords IndentString InQueryBlock KeepBlockInMessage LineUpBlockBrackets MaxLineLength MethodSignatureOnMultipleLines MinimumNewLinesBetweenStatements MultiLineMessages NewLineAfterCascade NewLineBeforeFirstCascade NewLineBeforeFirstKeyword NewLinesAfterMethodComment NewLinesAfterMethodPattern NewLinesAfterTemporaries NumberOfArgumentsForMultiLine OneLineMessages PeriodsAtEndOfBlock PeriodsAtEndOfMethod RetainBlankLinesBetweenStatements StringFollowingReturn StringInsideBlocks StringInsideParentheses TraditionalBinaryPrecedence UseTraditionalBinaryPrecedenceForParentheses)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBConfigurableFormatter formats the Refactoring Browser''s parse trees. It has many more formatting options than the default formatter used by the RB. To change the RB to use this formatter, execute "RBProgramNode formatterClass: RBConfigurableFormatter". For some refactorings the RB must reformat the code after the change, so it is good to have a formatter configured to your tastes.

Instance Variables:
	codeStream	<PositionableStream>	the stream we are writing our output to
	indent	<Integer>	how many times are we indenting a new line -- indents are normally tabs but could be any whitespace string
	lineStart	<Integer>	the position of the character that started the current line. This is used for calculating the line length.
	lookaheadCode	<Dictionary key: RBProgramNode value: String>	sometimes we need to lookahead while formatting, this dictionary contains the nodes that have already been formatted by lookahead
	originalSource	<String>	the original source before we started formatting. This is used to extract the comments from the original source.

';
		immediateInvariant.
true.
%

removeallmethods RBConfigurableFormatter
removeallclassmethods RBConfigurableFormatter

doit
(RBProgramNodeVisitor
	subclass: 'RBFormatter'
	instVarNames: #(codeStream lineStart firstLineLength tabs inQueryBlock)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBFormatter formats a parse tree. It is an example of a Visitor. This is rarely called directly. Sending ''formattedCode'' to a parse tree uses this algorithm to return a pretty-printed version.

Instance Variables:
	codeStream	<PositionableStream>	The buffer where the output is accumulated.
	firstLineLength	<Integer>	The length of the first line of a message send.
	lineStart	<Integer>	The position of the current line''s start.
	tabs	<Integer>	The number of tabs currently indented.

';
		immediateInvariant.
true.
%

removeallmethods RBFormatter
removeallclassmethods RBFormatter

doit
(RBProgramNodeVisitor
	subclass: 'RBParseTreeSearcher'
	instVarNames: #(searches answer argumentSearches context messages)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'ParseTreeSearcher walks over a normal source code parse tree using the visitor pattern, and then matches these nodes against the meta-nodes using the match:inContext: methods defined for the meta-nodes.

Instance Variables:
	answer	<Object>	the "answer" that is propagated between matches
	argumentSearches	<Collection of: (Association key: RBProgramNode value: BlockClosure)>	argument searches (search for the BRProgramNode and perform the BlockClosure when its found)
	context	<RBSmallDictionary>	a dictionary that contains what each meta-node matches against. This could be a normal Dictionary that is created for each search, but is created once and reused (efficiency).
	messages	<Collection>	the sent messages in our searches
	searches	<Collection of: (Association key: RBProgramNode value: BlockClosure)>	non-argument searches (search for the BRProgramNode and perform the BlockClosure when its found)';
		immediateInvariant.
true.
%

removeallmethods RBParseTreeSearcher
removeallclassmethods RBParseTreeSearcher

doit
(RBParseTreeSearcher
	subclass: 'RBParseTreeRewriter'
	instVarNames: #(tree)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'ParseTreeRewriter walks over and transforms its RBProgramNode (tree). If the tree is modified, then answer is set to true, and the modified tree can be retrieved by the #tree method.

Instance Variables:
	tree	<RBProgramNode>	the parse tree we''re transforming';
		immediateInvariant.
true.
%

removeallmethods RBParseTreeRewriter
removeallclassmethods RBParseTreeRewriter

doit
(RBProgramNodeVisitor
	subclass: 'RBReadBeforeWrittenTester'
	instVarNames: #(read checkNewTemps scopeStack)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBReadBeforeWrittenTester is a visitor that identifies variables that may have been read before they are initialized.

Instance Variables:
	checkNewTemps	<Boolean>	description of checkNewTemps
	read	<Collection>	description of read
	scopeStack	<OrderedCollection>	description of scopeStack

';
		immediateInvariant.
true.
%

removeallmethods RBReadBeforeWrittenTester
removeallclassmethods RBReadBeforeWrittenTester

doit
(Object
	subclass: 'RBScanner'
	instVarNames: #(stream buffer tokenStart currentCharacter characterType classificationTable comments errorBlock)
	classVars: #(PatternVariableCharacter)
	classInstVars: #(classificationTable)
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBScanner is a stream that returns a sequence of token from the string that it is created on. The tokens know where they came from in the source code and which comments were attached to them.

Instance Variables:
	buffer	<PositionableStream>	Accumulates the text for the current token.
	characterType	<ByteSymbol>	The type of the next character. (e.g. #alphabetic, etc.)
	classificationTable	<Array of: Symbol>	Mapping from Character values to their characterType.
	comments	<Collection of: Interval>	Source intervals of scanned comments that must be attached to the next token.
	currentCharacter	<Character>	The character currently being processed.
	errorBlock	<BlockClosure>	The block to execute on lexical errors.
	extendedLiterals	<Boolean>	True if IBM-type literals are allowed. In VW, this is false.
	nameSpaceCharacter	<Character>	The character used to separate namespaces.
	numberType	<ByteSymbol>	The method to perform: to scan a number. 
	separatorsInLiterals	<Boolean>	True if separators are allowed within literals.
	stream	<PositionableStream>	Contains the text to be scanned.
	tokenStart	<Integer>	The source position of the beginning of the current token

Class Instance Variables:
	classificationTable	<Array>		the default classification table for all characters

Shared Variables:
	PatternVariableCharacter	<Character>	the character that starts a pattern node';
		immediateInvariant.
true.
%

removeallmethods RBScanner
removeallclassmethods RBScanner

doit
(RBScanner
	subclass: 'RBPatternScanner'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBPatternScanner is a subclass of RBScanner that allows the extended syntax of pattern matching trees.
';
		immediateInvariant.
true.
%

removeallmethods RBPatternScanner
removeallclassmethods RBPatternScanner

doit
(RBScanner
	subclass: 'RBTonelScanner'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		immediateInvariant.
true.
%

removeallmethods RBTonelScanner
removeallclassmethods RBTonelScanner

doit
(Object
	subclass: 'RBSmallDictionary'
	instVarNames: #(keys values tally)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBSmallDictionary is a special dictionary optimized for small collections. In addition to the normal dictionary protocol, it also supports an #empty message which "empties" the collection but may hang on to the original elements (so it could collect garbage). Without #empty we would either need to create a new dictionary or explicitly remove everything from the dictionary. Both of these take more time and #empty.

Instance Variables:
array <Array of: Object> array of keys (we don''t use Associations for our key value pairs)
tally <Integer> the size of the dictionary
values <Array of: Object> array of our values
';
		immediateInvariant.
true.
%

removeallmethods RBSmallDictionary
removeallclassmethods RBSmallDictionary

doit
(Object
	subclass: 'RBStringReplacement'
	instVarNames: #(startPosition stopPosition string)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBStringReplacement represents replacing source in the original method with a different string. These are used when reformatting code after a parse tree change has been made. Depending on the change, it may be possible to minimally change the parse tree without needing to format it.

Instance Variables:
	startPosition	<Integer>	the start position in the original source
	stopPosition	<Integer>	the end position in the original source
	string	<String>	replaces everything from the startPosition to the endPosition with this string

';
		immediateInvariant.
true.
%

removeallmethods RBStringReplacement
removeallclassmethods RBStringReplacement

doit
(Object
	subclass: 'RBToken'
	instVarNames: #(sourcePointer comments)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBToken is the abstract superclass of all of the RB tokens. These tokens (unlike the standard parser''s) remember where they came from in the original source code.

Subclasses must implement the following messages:
	accessing
		length

Instance Variables:
	sourcePointer	<Integer>	The position in the original source code where this token began.
';
		immediateInvariant.
true.
%

removeallmethods RBToken
removeallclassmethods RBToken

doit
(RBToken
	subclass: 'RBAssignmentToken'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBAssignmentToken is the first-class representation of the assignment token '':=''
';
		immediateInvariant.
true.
%

removeallmethods RBAssignmentToken
removeallclassmethods RBAssignmentToken

doit
(RBAssignmentToken
	subclass: 'RBShortAssignmentToken'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		immediateInvariant.
true.
%

removeallmethods RBShortAssignmentToken
removeallclassmethods RBShortAssignmentToken

doit
(RBToken
	subclass: 'RBValueToken'
	instVarNames: #(value)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBValueToken is the abstract superclass of all tokens that have additional information attached. For example, the BinarySelector token holds onto the actual character (e.g. $+).

Instance Variables:
	value	<String>	The value of this token

';
		immediateInvariant.
true.
%

removeallmethods RBValueToken
removeallclassmethods RBValueToken

doit
(RBValueToken
	subclass: 'RBBinarySelectorToken'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBBinarySelectorToken is the first-class representation of a binary selector (e.g. +)
';
		immediateInvariant.
true.
%

removeallmethods RBBinarySelectorToken
removeallclassmethods RBBinarySelectorToken

doit
(RBValueToken
	subclass: 'RBIdentifierToken'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBIdentifierToken is the first class representation of an identifier token (e.g. Class)
';
		immediateInvariant.
true.
%

removeallmethods RBIdentifierToken
removeallclassmethods RBIdentifierToken

doit
(RBIdentifierToken
	subclass: 'RBPathToken'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		immediateInvariant.
true.
%

removeallmethods RBPathToken
removeallclassmethods RBPathToken

doit
(RBValueToken
	subclass: 'RBKeywordToken'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBKeywordToken is the first-class representation of a keyword token (e.g. add:)';
		immediateInvariant.
true.
%

removeallmethods RBKeywordToken
removeallclassmethods RBKeywordToken

doit
(RBValueToken
	subclass: 'RBLiteralArrayToken'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		immediateInvariant.
true.
%

removeallmethods RBLiteralArrayToken
removeallclassmethods RBLiteralArrayToken

doit
(RBValueToken
	subclass: 'RBLiteralToken'
	instVarNames: #(stopPosition)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBLiteralToken is the first-class representation of a literal token (entire literals, even literal arrays, are a single token in the ST80 grammar.).

Instance Variables:
	stopPosition	<Integer>	The position within the source code where the token terminates.

';
		immediateInvariant.
true.
%

removeallmethods RBLiteralToken
removeallclassmethods RBLiteralToken

doit
(RBLiteralToken
	subclass: 'RBMultiKeywordLiteralToken'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		immediateInvariant.
true.
%

removeallmethods RBMultiKeywordLiteralToken
removeallclassmethods RBMultiKeywordLiteralToken

doit
(RBLiteralToken
	subclass: 'RBNumberLiteralToken'
	instVarNames: #(source)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		immediateInvariant.
true.
%

removeallmethods RBNumberLiteralToken
removeallclassmethods RBNumberLiteralToken

doit
(RBValueToken
	subclass: 'RBPatternBlockToken'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBPatternBlockToken is the first-class representation of the pattern block token.

';
		immediateInvariant.
true.
%

removeallmethods RBPatternBlockToken
removeallclassmethods RBPatternBlockToken

doit
(RBValueToken
	subclass: 'RBSpecialCharacterToken'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'AST-Core';
		comment: 'RBSpecialCharacterToken is the first class representation of special characters.

';
		immediateInvariant.
true.
%

removeallmethods RBSpecialCharacterToken
removeallclassmethods RBSpecialCharacterToken

doit
(Object
	subclass: 'Rowan'
	instVarNames: #()
	classVars: #()
	classInstVars: #(configuration)
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Kernel';
		comment: 'No class-specific documentation for Cypress, hierarchy is: 
Object
  Cypress
';
		immediateInvariant.
true.
%

removeallmethods Rowan
removeallclassmethods Rowan

doit
(Object
	subclass: 'RowanGsGeneralDependencySorter'
	instVarNames: #(candidates dependsOnConverter dependentConverter individualDependencyMap dependencyGraphs candidateAliasMap)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-Core';
		comment: 'Copied from CypressGsGeneralDependencySorter';
		immediateInvariant.
true.
%

removeallmethods RowanGsGeneralDependencySorter
removeallclassmethods RowanGsGeneralDependencySorter

doit
(Object
	subclass: 'RowanInterface'
	instVarNames: #(name)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RowanInterface
removeallclassmethods RowanInterface

doit
(RowanInterface
	subclass: 'RwAbstractProject'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwAbstractProject
removeallclassmethods RwAbstractProject

doit
(RwAbstractProject
	subclass: 'RwAbstractUnloadedProject'
	instVarNames: #(concreteProject)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwAbstractUnloadedProject
removeallclassmethods RwAbstractUnloadedProject

doit
(RwAbstractUnloadedProject
	subclass: 'RwDefinedProject'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwDefinedProject
removeallclassmethods RwDefinedProject

doit
(RwDefinedProject
	subclass: 'RwDefinedFromResolvedProject'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwDefinedFromResolvedProject
removeallclassmethods RwDefinedFromResolvedProject

doit
(RwAbstractUnloadedProject
	subclass: 'RwResolvedProject'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwResolvedProject
removeallclassmethods RwResolvedProject

doit
(RwResolvedProject
	subclass: 'RwResolvedFromDefinedProject'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwResolvedFromDefinedProject
removeallclassmethods RwResolvedFromDefinedProject

doit
(RwAbstractProject
	subclass: 'RwProject'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwProject
removeallclassmethods RwProject

doit
(RowanInterface
	subclass: 'RwPackage'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwPackage
removeallclassmethods RwPackage

doit
(Object
	subclass: 'RwAbstractComponent'
	instVarNames: #(name projectName comment componentNames packageNames)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Components';
		immediateInvariant.
true.
%

removeallmethods RwAbstractComponent
removeallclassmethods RwAbstractComponent

doit
(RwAbstractComponent
	subclass: 'RwAbstractActiveComponent'
	instVarNames: #(conditionalPackageMapSpecs preloadDoitName postloadDoitName doitDict projectNames)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Components';
		immediateInvariant.
true.
%

removeallmethods RwAbstractActiveComponent
removeallclassmethods RwAbstractActiveComponent

doit
(RwAbstractActiveComponent
	subclass: 'RwLoadComponent'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Components';
		immediateInvariant.
true.
%

removeallmethods RwLoadComponent
removeallclassmethods RwLoadComponent

doit
(RwLoadComponent
	subclass: 'RwSubcomponent'
	instVarNames: #(condition)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Components';
		immediateInvariant.
true.
%

removeallmethods RwSubcomponent
removeallclassmethods RwSubcomponent

doit
(RwSubcomponent
	subclass: 'RwPlatformSubcomponent'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Components';
		immediateInvariant.
true.
%

removeallmethods RwPlatformSubcomponent
removeallclassmethods RwPlatformSubcomponent

doit
(RwAbstractComponent
	subclass: 'RwPackageGroup'
	instVarNames: #(condition)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Components';
		immediateInvariant.
true.
%

removeallmethods RwPackageGroup
removeallclassmethods RwPackageGroup

doit
(Object
	subclass: 'RwAbstractConfigurationPlatformAttributeMatcher'
	instVarNames: #(pattern patternMatchBlock)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Core-Conditional-Support';
		immediateInvariant.
true.
%

removeallmethods RwAbstractConfigurationPlatformAttributeMatcher
removeallclassmethods RwAbstractConfigurationPlatformAttributeMatcher

doit
(RwAbstractConfigurationPlatformAttributeMatcher
	subclass: 'RwGemStoneVersionConfigurationPlatformAttributeMatcher'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Core-Conditional-Support';
		immediateInvariant.
true.
%

removeallmethods RwGemStoneVersionConfigurationPlatformAttributeMatcher
removeallclassmethods RwGemStoneVersionConfigurationPlatformAttributeMatcher

doit
(RwGemStoneVersionConfigurationPlatformAttributeMatcher
	subclass: 'RwGemStoneVersionRangeConfigurationPlatformAttributeMatcher'
	instVarNames: #(pattern2)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Core-Conditional-Support';
		immediateInvariant.
true.
%

removeallmethods RwGemStoneVersionRangeConfigurationPlatformAttributeMatcher
removeallclassmethods RwGemStoneVersionRangeConfigurationPlatformAttributeMatcher

doit
(RwAbstractConfigurationPlatformAttributeMatcher
	subclass: 'RwStringConfigurationPlatformAttributeMatcher'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Core-Conditional-Support';
		immediateInvariant.
true.
%

removeallmethods RwStringConfigurationPlatformAttributeMatcher
removeallclassmethods RwStringConfigurationPlatformAttributeMatcher

doit
(RwAbstractConfigurationPlatformAttributeMatcher
	subclass: 'RwUnconditionalPlatformAttributeMatcher'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Core-Conditional-Support';
		immediateInvariant.
true.
%

removeallmethods RwUnconditionalPlatformAttributeMatcher
removeallclassmethods RwUnconditionalPlatformAttributeMatcher

doit
(Object
	subclass: 'RwAbstractProjectSetModificationVisitor'
	instVarNames: #(currentProjectDefinition currentPackageDefinition currentClassDefinition currentClassExtension)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwAbstractProjectSetModificationVisitor
removeallclassmethods RwAbstractProjectSetModificationVisitor

doit
(Object
	subclass: 'RwAbstractReaderWriterVisitor'
	instVarNames: #(currentProjectDefinition packageConvention currentPackageDefinition currentClassDefinition currentClassExtension currentTraitDefinition)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwAbstractReaderWriterVisitor
removeallclassmethods RwAbstractReaderWriterVisitor

doit
(RwAbstractReaderWriterVisitor
	subclass: 'RwModificationWriterVisitor'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		comment: 'Abstract class with support for walking a modification tree and writing out the source code in a variety of formats:
	topaz fileout
	Tonel
	Filetree';
		immediateInvariant.
true.
%

removeallmethods RwModificationWriterVisitor
removeallclassmethods RwModificationWriterVisitor

doit
(RwModificationWriterVisitor
	subclass: 'RwAbstractGsModificationTopazWriterVisitorV2'
	instVarNames: #(bufferedStream classDefinitions classExtensions classInitializationDefinitions classSymbolDictionaryNames excludeClassInitializers excludeRemoveAllMethods filenameExtension logCreation topazFileFooter topazFileHeader)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-CoreV2';
		immediateInvariant.
true.
%

removeallmethods RwAbstractGsModificationTopazWriterVisitorV2
removeallclassmethods RwAbstractGsModificationTopazWriterVisitorV2

doit
(RwAbstractGsModificationTopazWriterVisitorV2
	subclass: 'RwGsModificationTopazPackageWriterVisitorV2'
	instVarNames: #(packagesRoot)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-Core-36x';
		immediateInvariant.
true.
%

removeallmethods RwGsModificationTopazPackageWriterVisitorV2
removeallclassmethods RwGsModificationTopazPackageWriterVisitorV2

doit
(RwModificationWriterVisitor
	subclass: 'RwGsModificationTopazWriterVisitorV2'
	instVarNames: #(topazFilename topazFileHeader topazFileFooter excludeClassInitializers excludeRemoveAllMethods fileNamesInFileInOrder logCreation filenameExtension classSymbolDictionaryNames classDefinitions classExtensions traitDefinitions bufferedStream topazFilenamePackageNamesMap classDefPackageNameMap classExtPackageNameMap classInitializationDefinitions buildPackageNamesMap repositoryRootPath)
	classVars: #(Character_lf)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-CoreV2';
		comment: 'No class-specific documentation for RwGsModificationTopazWriterVisitorV2, hierarchy is:
Object
  RwAbstractReaderWriterVisitor( currentProjectDefinition packageConvention currentPackageDefinition currentClassDefinition currentClassExtension)
    RwModificationWriterVisitor
      RwGsModificationTopazWriterVisitorV2( topazFilenameComponentMap topazFilename topazFileHeader filenameExtension classSymbolDictionaryNames classDefinitions classExtensions bufferedStream topazFilenamePackageNamesMap classDefPackageNameMap classExtPackageNameMap classInitializationDefinitions buildPackageNamesMap repositoryRootPath)
';
		immediateInvariant.
true.
%

removeallmethods RwGsModificationTopazWriterVisitorV2
removeallclassmethods RwGsModificationTopazWriterVisitorV2

doit
(RwModificationWriterVisitor
	subclass: 'RwModificationCypressFamilyWriterVisitorV2'
	instVarNames: #(classDefFileNameMap classExtFileNameMap traitDefFileNameMap traitDefBeforeFileNameMap classDefBeforeFileNameMap classExtBeforeFileNameMap packageDefFileNameMap packageDefBeforeFileNameMap packagesRoot)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwModificationCypressFamilyWriterVisitorV2
removeallclassmethods RwModificationCypressFamilyWriterVisitorV2

doit
(RwModificationCypressFamilyWriterVisitorV2
	subclass: 'RwModificationFiletreeWriterVisitorV2'
	instVarNames: #(instanceFileNameMap classFileNameMap instanceBeforeFileNameMap classBeforeFileNameMap packageExtension separateMethodMetaAndSource noMethodMetaData useCypressPropertiesFile monticelloMetadata)
	classVars: #()
	classInstVars: #(specials)
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwModificationFiletreeWriterVisitorV2
removeallclassmethods RwModificationFiletreeWriterVisitorV2

doit
(RwModificationCypressFamilyWriterVisitorV2
	subclass: 'RwModificationTonelWriterVisitorV2'
	instVarNames: #(methodSortBlock)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwModificationTonelWriterVisitorV2
removeallclassmethods RwModificationTonelWriterVisitorV2

doit
(RwModificationTonelWriterVisitorV2
	subclass: 'RwModificationPharoTonelFormatV1WriterVisitorV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwModificationPharoTonelFormatV1WriterVisitorV2
removeallclassmethods RwModificationPharoTonelFormatV1WriterVisitorV2

doit
(RwAbstractReaderWriterVisitor
	subclass: 'RwRepositoryComponentProjectReaderVisitor'
	instVarNames: #(packageNames packageNamesBlock currentProjectReferenceDefinition)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-DefinitionsV2';
		immediateInvariant.
true.
%

removeallmethods RwRepositoryComponentProjectReaderVisitor
removeallclassmethods RwRepositoryComponentProjectReaderVisitor

doit
(RwRepositoryComponentProjectReaderVisitor
	subclass: 'RwRepositoryResolvedProjectFiletreeReaderVisitorV2'
	instVarNames: #(packageExtension)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-DefinitionsV2';
		immediateInvariant.
true.
%

removeallmethods RwRepositoryResolvedProjectFiletreeReaderVisitorV2
removeallclassmethods RwRepositoryResolvedProjectFiletreeReaderVisitorV2

doit
(RwRepositoryComponentProjectReaderVisitor
	subclass: 'RwRepositoryResolvedProjectTonelReaderVisitorV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-DefinitionsV2';
		immediateInvariant.
true.
%

removeallmethods RwRepositoryResolvedProjectTonelReaderVisitorV2
removeallclassmethods RwRepositoryResolvedProjectTonelReaderVisitorV2

doit
(RwRepositoryComponentProjectReaderVisitor
	subclass: 'RwRepositoryResolvedProjectTopazPackageReaderVisitorV2'
	instVarNames: #(filenameExtension)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-Core-36x';
		immediateInvariant.
true.
%

removeallmethods RwRepositoryResolvedProjectTopazPackageReaderVisitorV2
removeallclassmethods RwRepositoryResolvedProjectTopazPackageReaderVisitorV2

doit
(Object
	subclass: 'RwAbstractResolvedObjectV2'
	instVarNames: #(projectRepository loadSpecification projectSpecification)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Definitions-Common';
		immediateInvariant.
true.
%

removeallmethods RwAbstractResolvedObjectV2
removeallclassmethods RwAbstractResolvedObjectV2

doit
(RwAbstractResolvedObjectV2
	subclass: 'RwAbstractResolvedProjectV2'
	instVarNames: #(projectDefinition projectComponents)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-DefinitionsV2';
		immediateInvariant.
true.
%

removeallmethods RwAbstractResolvedProjectV2
removeallclassmethods RwAbstractResolvedProjectV2

doit
(RwAbstractResolvedProjectV2
	subclass: 'RwResolvedProjectSpecificationV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-DefinitionsV2';
		immediateInvariant.
true.
%

removeallmethods RwResolvedProjectSpecificationV2
removeallclassmethods RwResolvedProjectSpecificationV2

doit
(RwAbstractResolvedProjectV2
	subclass: 'RwResolvedProjectV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-DefinitionsV2';
		immediateInvariant.
true.
%

removeallmethods RwResolvedProjectV2
removeallclassmethods RwResolvedProjectV2

doit
(RwAbstractResolvedProjectV2
	subclass: 'RwResolvedRepositoryV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-DefinitionsV2';
		immediateInvariant.
true.
%

removeallmethods RwResolvedRepositoryV2
removeallclassmethods RwResolvedRepositoryV2

doit
(Object
	subclass: 'RwAbstractTool'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		comment: 'Fundamental concepts:

	read			(disk -> def)
	write			(def -> disk)

	install			(def -> image)
	derive			(image -> def)

	load			(disk ->  image)
	commit			(image -> disk)

	project			manages collections of packages
	package			manages collections of definitions
	definitions	manages properties of classes and methods
	repository		manages disk representation of defintions';
		immediateInvariant.
true.
%

removeallmethods RwAbstractTool
removeallclassmethods RwAbstractTool

doit
(RwAbstractTool
	subclass: 'RwClassTool'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwClassTool
removeallclassmethods RwClassTool

doit
(RwClassTool
	subclass: 'RwClsCommonAuditTool'
	instVarNames: #(theAuditDetails)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwClsCommonAuditTool
removeallclassmethods RwClsCommonAuditTool

doit
(RwClsCommonAuditTool
	subclass: 'RwClsAuditTool'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		comment: 'This class audits individual classes';
		immediateInvariant.
true.
%

removeallmethods RwClsAuditTool
removeallclassmethods RwClsAuditTool

doit
(RwClsCommonAuditTool
	subclass: 'RwClsExtensionAuditTool'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwClsExtensionAuditTool
removeallclassmethods RwClsExtensionAuditTool

doit
(RwClassTool
	subclass: 'RwClsDiffTool'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwClsDiffTool
removeallclassmethods RwClsDiffTool

doit
(RwAbstractTool
	subclass: 'RwExamplesTool'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Examples';
		immediateInvariant.
true.
%

removeallmethods RwExamplesTool
removeallclassmethods RwExamplesTool

doit
(RwExamplesTool
	subclass: 'RwExampleComponentRefactoringTool'
	instVarNames: #(definedProject components packages conditions platformConditions)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Examples';
		comment: 'This is an example tool that was used to refactor the Rowan component structure that was present 
in commit ebdabb9d9 of the Rowan project. See https://github.com/GemTalk/Rowan/issues/617 for
additional information.

The goal of the restructuring was to move the tests, classes and methods that were managed by 
conditional components with the condition v2Only and v2 into packages where possible and new
component structure otherwise. The process involved basically folding the v2 and v2Only 
components into the existing common component structure.

If you inspect the result of the following expression:

	Rowan projectTools examples componentRefactoring forProjectNamed: ''Rowan'' componentNamed: ''Rowan''

you see that there are 6 instance variables:
	project					- the loaded project for Rowan (instance of RwProject)
	components			- a dictionary of the components on disk for the current Rowan project
	packages				- a dictionary that maps the packageNames to the component that manages
									the package
	conditions				- a dictionary that maps the subcomponent conditions to a list of the
									subcomponents that specify that condition
	platformConditions	- a dictionary that maps the platformComponent condition arrays to a list of
									the plaformComponents that specifies that condition array

Inspecting these fields can give you an overview of the composition of the given project and load spec.

The method #refactorComponentsWithCondition: does folds the classes and methods into existing 
packages or creates new components to manage the existing packages when an appropriate existing
package cannot be found.

	Rowan projectTools examples componentRefactoring componentRefactoring forProjectNamed: ''Rowan'' componentNamed: ''Rowan''
		refactorComponentsWithCondition: ''v2Only'';
		refactorComponentsWithCondition: ''v2'';
		export';
		immediateInvariant.
true.
%

removeallmethods RwExampleComponentRefactoringTool
removeallclassmethods RwExampleComponentRefactoringTool

doit
(RwAbstractTool
	subclass: 'RwGitTool'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwGitTool
removeallclassmethods RwGitTool

doit
(RwAbstractTool
	subclass: 'RwPackageTool'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwPackageTool
removeallclassmethods RwPackageTool

doit
(RwPackageTool
	subclass: 'RwPkgAdoptTool'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwPkgAdoptTool
removeallclassmethods RwPkgAdoptTool

doit
(RwPackageTool
	subclass: 'RwPkgCreateTool'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwPkgCreateTool
removeallclassmethods RwPkgCreateTool

doit
(RwPackageTool
	subclass: 'RwPkgDisownTool'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwPkgDisownTool
removeallclassmethods RwPkgDisownTool

doit
(RwPackageTool
	subclass: 'RwPkgLoadTool'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwPkgLoadTool
removeallclassmethods RwPkgLoadTool

doit
(RwPackageTool
	subclass: 'RwPkgRevertTool'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwPkgRevertTool
removeallclassmethods RwPkgRevertTool

doit
(RwAbstractTool
	subclass: 'RwPkgAuditToolV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-CoreV2';
		immediateInvariant.
true.
%

removeallmethods RwPkgAuditToolV2
removeallclassmethods RwPkgAuditToolV2

doit
(RwAbstractTool
	subclass: 'RwProjectTool'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwProjectTool
removeallclassmethods RwProjectTool

doit
(RwProjectTool
	subclass: 'RwPrjAdoptTool'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwPrjAdoptTool
removeallclassmethods RwPrjAdoptTool

doit
(RwProjectTool
	subclass: 'RwPrjAuditTool'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwPrjAuditTool
removeallclassmethods RwPrjAuditTool

doit
(RwProjectTool
	subclass: 'RwPrjBrowserToolV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Obsolete';
		immediateInvariant.
true.
%

removeallmethods RwPrjBrowserToolV2
removeallclassmethods RwPrjBrowserToolV2

doit
(RwProjectTool
	subclass: 'RwPrjCloneTool'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwPrjCloneTool
removeallclassmethods RwPrjCloneTool

doit
(RwProjectTool
	subclass: 'RwPrjCommitTool'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwPrjCommitTool
removeallclassmethods RwPrjCommitTool

doit
(RwProjectTool
	subclass: 'RwPrjCreateToolV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-CoreV2';
		immediateInvariant.
true.
%

removeallmethods RwPrjCreateToolV2
removeallclassmethods RwPrjCreateToolV2

doit
(RwProjectTool
	subclass: 'RwPrjDeleteTool'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwPrjDeleteTool
removeallclassmethods RwPrjDeleteTool

doit
(RwProjectTool
	subclass: 'RwPrjDiffTool'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwPrjDiffTool
removeallclassmethods RwPrjDiffTool

doit
(RwProjectTool
	subclass: 'RwPrjDisownTool'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwPrjDisownTool
removeallclassmethods RwPrjDisownTool

doit
(RwProjectTool
	subclass: 'RwPrjEditTool'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwPrjEditTool
removeallclassmethods RwPrjEditTool

doit
(RwProjectTool
	subclass: 'RwPrjInstallToolV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-CoreV2';
		immediateInvariant.
true.
%

removeallmethods RwPrjInstallToolV2
removeallclassmethods RwPrjInstallToolV2

doit
(RwProjectTool
	subclass: 'RwPrjLoadToolV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-CoreV2';
		immediateInvariant.
true.
%

removeallmethods RwPrjLoadToolV2
removeallclassmethods RwPrjLoadToolV2

doit
(RwProjectTool
	subclass: 'RwPrjQueryTool'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwPrjQueryTool
removeallclassmethods RwPrjQueryTool

doit
(RwProjectTool
	subclass: 'RwPrjReadToolV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-CoreV2';
		immediateInvariant.
true.
%

removeallmethods RwPrjReadToolV2
removeallclassmethods RwPrjReadToolV2

doit
(RwProjectTool
	subclass: 'RwPrjReconcileToolV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-CoreV2';
		immediateInvariant.
true.
%

removeallmethods RwPrjReconcileToolV2
removeallclassmethods RwPrjReconcileToolV2

doit
(RwProjectTool
	subclass: 'RwPrjTestTool'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwPrjTestTool
removeallclassmethods RwPrjTestTool

doit
(RwProjectTool
	subclass: 'RwPrjTraceTool'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwPrjTraceTool
removeallclassmethods RwPrjTraceTool

doit
(RwProjectTool
	subclass: 'RwPrjWriteToolV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-CoreV2';
		immediateInvariant.
true.
%

removeallmethods RwPrjWriteToolV2
removeallclassmethods RwPrjWriteToolV2

doit
(RwAbstractTool
	subclass: 'RwTraitAuditTool'
	instVarNames: #(theAuditDetails)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwTraitAuditTool
removeallclassmethods RwTraitAuditTool

doit
(Object
	subclass: 'RwAuditDetail'
	instVarNames: #(reason message owner)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		comment: 'Audit failure detail for a class. 

Reasons:
	#loadedPackageNotInRegistry
	#loadedPackageInWrongRegistry';
		immediateInvariant.
true.
%

removeallmethods RwAuditDetail
removeallclassmethods RwAuditDetail

doit
(RwAuditDetail
	subclass: 'RwAuditClassDetail'
	instVarNames: #(behavior)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		comment: 'Audit failure detail for a class. 

Reasons:
	#missingGemStoneClassForLoadedClass
	#missingGemStoneClassForLoadedClassExtension
	#emptyLoadedClassExtension
	#missingCompiledMethodsForLoadedClassExtension';
		immediateInvariant.
true.
%

removeallmethods RwAuditClassDetail
removeallclassmethods RwAuditClassDetail

doit
(RwAuditDetail
	subclass: 'RwAuditClassPropertyDetail'
	instVarNames: #(class loadedPropertyValue classPropertyValue)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		comment: 'Audit failure detail for class properties. 

Reasons:
	#differentSuperclass
	#differentClassInstVars
	#differentClassVars
	#differentPoolDictionaries
	#differentComment
	#differentCategory
	#missingSymbolDictionary
	#missingClassInSymbolDictionary';
		immediateInvariant.
true.
%

removeallmethods RwAuditClassPropertyDetail
removeallclassmethods RwAuditClassPropertyDetail

doit
(RwAuditDetail
	subclass: 'RwAuditMethodCategoryDetail'
	instVarNames: #(behavior category)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		comment: 'Audit failure detail for a class. 

Reasons:
	#rowanHybridExtensionCategoryMatchesClassPackage
	#rowanHybridExtensionCategoryFormatError';
		immediateInvariant.
true.
%

removeallmethods RwAuditMethodCategoryDetail
removeallclassmethods RwAuditMethodCategoryDetail

doit
(RwAuditDetail
	subclass: 'RwAuditMethodDetail'
	instVarNames: #(behavior selector loadedMethod method loadedCategory category)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		comment: 'Audit failure detail for method. 

Reasons:
	#missingCompiledMethod
	#missingLoadedMethod
	#differentMethodCategory
	#methodsNotIdentical';
		immediateInvariant.
true.
%

removeallmethods RwAuditMethodDetail
removeallclassmethods RwAuditMethodDetail

doit
(RwAuditDetail
	subclass: 'RwAuditPackageDetail'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwAuditPackageDetail
removeallclassmethods RwAuditPackageDetail

doit
(RwAuditPackageDetail
	subclass: 'RwAuditPackageClassSymbolDictionaryDetail'
	instVarNames: #(loadedClass classSymbolDictionaryName packageSymbolDictionaryName)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		comment: 'Audit failure detail for a package and class. 

Reasons:
	#differentSymbolDictionaryForClassAndPackage
	#differentSymbolDictionaryForClassExtensionAndPackage';
		immediateInvariant.
true.
%

removeallmethods RwAuditPackageClassSymbolDictionaryDetail
removeallclassmethods RwAuditPackageClassSymbolDictionaryDetail

doit
(RwAuditPackageDetail
	subclass: 'RwAuditPackageTraitSymbolDictionaryDetail'
	instVarNames: #(loadedTrait traitSymbolDictionaryName packageSymbolDictionaryName)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwAuditPackageTraitSymbolDictionaryDetail
removeallclassmethods RwAuditPackageTraitSymbolDictionaryDetail

doit
(RwAuditDetail
	subclass: 'RwAuditTraitDetail'
	instVarNames: #(trait)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwAuditTraitDetail
removeallclassmethods RwAuditTraitDetail

doit
(RwAuditDetail
	subclass: 'RwAuditTraitPropertyDetail'
	instVarNames: #(trait loadedPropertyValue traitPropertyValue)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwAuditTraitPropertyDetail
removeallclassmethods RwAuditTraitPropertyDetail

doit
(Object
	subclass: 'RwBasicProjectLoadComponentV2'
	instVarNames: #(name comment projectName conditionalPackageMapSpecs preloadDoitName postloadDoitName doitDict)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-ComponentsV2';
		immediateInvariant.
true.
%

removeallmethods RwBasicProjectLoadComponentV2
removeallclassmethods RwBasicProjectLoadComponentV2

doit
(RwBasicProjectLoadComponentV2
	subclass: 'RwAbstractSimpleProjectLoadComponentV2'
	instVarNames: #(packageNames condition)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-ComponentsV2';
		immediateInvariant.
true.
%

removeallmethods RwAbstractSimpleProjectLoadComponentV2
removeallclassmethods RwAbstractSimpleProjectLoadComponentV2

doit
(RwAbstractSimpleProjectLoadComponentV2
	subclass: 'RwAbstractRowanProjectLoadComponentV2'
	instVarNames: #(componentNames)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-ComponentsV2';
		immediateInvariant.
true.
%

removeallmethods RwAbstractRowanProjectLoadComponentV2
removeallclassmethods RwAbstractRowanProjectLoadComponentV2

doit
(RwAbstractRowanProjectLoadComponentV2
	subclass: 'RwSimpleProjectLoadComponentV2'
	instVarNames: #(projectNames)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-ComponentsV2';
		immediateInvariant.
true.
%

removeallmethods RwSimpleProjectLoadComponentV2
removeallclassmethods RwSimpleProjectLoadComponentV2

doit
(RwSimpleProjectLoadComponentV2
	subclass: 'RwSimpleNestedProjectLoadComponentV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-ComponentsV2';
		immediateInvariant.
true.
%

removeallmethods RwSimpleNestedProjectLoadComponentV2
removeallclassmethods RwSimpleNestedProjectLoadComponentV2

doit
(RwSimpleNestedProjectLoadComponentV2
	subclass: 'RwPlatformNestedProjectLoadComponentV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-ComponentsV2';
		immediateInvariant.
true.
%

removeallmethods RwPlatformNestedProjectLoadComponentV2
removeallclassmethods RwPlatformNestedProjectLoadComponentV2

doit
(Object
	subclass: 'RwClassAdditionOrRemoval'
	instVarNames: #(projectDefinition packageDefinition classKey classesModification)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		comment: 'No class-specific documentation for CypClassAdditionOrRemoval, hierarchy is: 
Object
  CypClassAdditionOrRemoval( packageDefinition classKey classesModification)
';
		immediateInvariant.
true.
%

removeallmethods RwClassAdditionOrRemoval
removeallclassmethods RwClassAdditionOrRemoval

doit
(Object
	subclass: 'RwConfiguration'
	instVarNames: #(packageInfoSource)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		comment: 'Configuration that guides Cypress operation.

Specific parameters:

packageInfoSource
--------------------------
A Symbol indicating where the authoritative repository of information about package membership of classes and methods is.
Acceptable values are platform-specific:

#Cypress -- the information is stored in Cypress-specific objects. Valid on all platforms, but recommended only when all code modifications are done through Cypress or tools that are Cypress-aware

#Category -- Valid for Pharo and GemStone. The category of a class is the name of its package, and a method''s membership in a protocol whose name starts with $* indicates extension methods.

#SymbolDictionary -- Valid for GemStone. The SymbolDictionary in which the class''s name is first found is the name of its package, and a method''s membership in a protocol whose name starts with $* indicates extension methods.

#Store -- Valid for VW. Cypress package membership is Store package membership.';
		immediateInvariant.
true.
%

removeallmethods RwConfiguration
removeallclassmethods RwConfiguration

doit
(Object
	subclass: 'RwDefinition'
	instVarNames: #(properties)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Definitions';
		comment: 'Abstract.
Defines some "code" entity.
The definition object''s primary responsibility is to hold information.
It holds exactly the same information as the disk representation in some form of Cypress repository.
Other non-definition classes construct and use the information in definitions to read, write, and compare
code.

properties is a dictionary. Keys and values should be strings. These correspond to the properties in a Cypress repository, and are used in various ways, some of them dialect-specific.';
		immediateInvariant.
true.
%

removeallmethods RwDefinition
removeallclassmethods RwDefinition

doit
(RwDefinition
	subclass: 'RwAbstractClassDefinition'
	instVarNames: #(classMethodDefinitions instanceMethodDefinitions)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Definitions';
		immediateInvariant.
true.
%

removeallmethods RwAbstractClassDefinition
removeallclassmethods RwAbstractClassDefinition

doit
(RwAbstractClassDefinition
	subclass: 'RwClassDefinition'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Definitions';
		comment: 'Defines a class.
Properties should include ''name'' and ''super''.
Other typical properties are ''instvars'' ''classinstvars'' ''classvars''.
Methods are their own definitions: classMethodDefinitions instanceMethodDefinitions
';
		immediateInvariant.
true.
%

removeallmethods RwClassDefinition
removeallclassmethods RwClassDefinition

doit
(RwAbstractClassDefinition
	subclass: 'RwClassExtensionDefinition'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Definitions';
		comment: 'Extends an existing class with additional methods.
Properties must include ''name'', the name of the class to be extended, but should not include other things like ''super'' or ''instvars''.
';
		immediateInvariant.
true.
%

removeallmethods RwClassExtensionDefinition
removeallclassmethods RwClassExtensionDefinition

doit
(RwAbstractClassDefinition
	subclass: 'RwTraitDefinition'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Definitions';
		immediateInvariant.
true.
%

removeallmethods RwTraitDefinition
removeallclassmethods RwTraitDefinition

doit
(RwDefinition
	subclass: 'RwAbstractRepositoryDefinitionV2'
	instVarNames: #(projectsHome repositoryRoot repositoryUrl)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Definitions-Common';
		immediateInvariant.
true.
%

removeallmethods RwAbstractRepositoryDefinitionV2
removeallclassmethods RwAbstractRepositoryDefinitionV2

doit
(RwAbstractRepositoryDefinitionV2
	subclass: 'RwDiskRepositoryDefinitionV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-DefinitionsV2';
		immediateInvariant.
true.
%

removeallmethods RwDiskRepositoryDefinitionV2
removeallclassmethods RwDiskRepositoryDefinitionV2

doit
(RwDiskRepositoryDefinitionV2
	subclass: 'RwGitRepositoryDefinitionV2'
	instVarNames: #(remote remoteUrl committish gitUrl gitRoot relativeRepositoryRoot)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-DefinitionsV2';
		immediateInvariant.
true.
%

removeallmethods RwGitRepositoryDefinitionV2
removeallclassmethods RwGitRepositoryDefinitionV2

doit
(RwDiskRepositoryDefinitionV2
	subclass: 'RwNoRepositoryDefinitionV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-DefinitionsV2';
		immediateInvariant.
true.
%

removeallmethods RwNoRepositoryDefinitionV2
removeallclassmethods RwNoRepositoryDefinitionV2

doit
(RwDiskRepositoryDefinitionV2
	subclass: 'RwReadOnlyDiskRepositoryDefinitionV2'
	instVarNames: #(sesstionTempsKey commitId)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-DefinitionsV2';
		immediateInvariant.
true.
%

removeallmethods RwReadOnlyDiskRepositoryDefinitionV2
removeallclassmethods RwReadOnlyDiskRepositoryDefinitionV2

doit
(RwDefinition
	subclass: 'RwDefinitionSetDefinition'
	instVarNames: #(definitions)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Definitions';
		comment: 'No class-specific documentation for CypPackageSetDefinition, hierarchy is: 
Object
  CypDefinition( properties)
    CypPackageSetDefinition( packages)
';
		immediateInvariant.
true.
%

removeallmethods RwDefinitionSetDefinition
removeallclassmethods RwDefinitionSetDefinition

doit
(RwDefinitionSetDefinition
	subclass: 'RwPackageSetDefinition'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Definitions';
		comment: 'No class-specific documentation for CypPackageSetDefinition, hierarchy is: 
Object
  CypDefinition( properties)
    CypPackageSetDefinition( packages)
';
		immediateInvariant.
true.
%

removeallmethods RwPackageSetDefinition
removeallclassmethods RwPackageSetDefinition

doit
(RwDefinitionSetDefinition
	subclass: 'RwProjectSetDefinition'
	instVarNames: #(attributes)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Definitions';
		comment: 'No class-specific documentation for CypPackageSetDefinition, hierarchy is: 
Object
  CypDefinition( properties)
    CypPackageSetDefinition( packages)
';
		immediateInvariant.
true.
%

removeallmethods RwProjectSetDefinition
removeallclassmethods RwProjectSetDefinition

doit
(RwDefinition
	subclass: 'RwMethodDefinition'
	instVarNames: #(source)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Definitions';
		immediateInvariant.
true.
%

removeallmethods RwMethodDefinition
removeallclassmethods RwMethodDefinition

doit
(RwMethodDefinition
	subclass: 'RwTraitMethodDefinition'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Definitions';
		immediateInvariant.
true.
%

removeallmethods RwTraitMethodDefinition
removeallclassmethods RwTraitMethodDefinition

doit
(RwDefinition
	subclass: 'RwPackageDefinition'
	instVarNames: #(classDefinitions classExtensions traitDefinitions)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Definitions';
		comment: 'Defines a package, which is a bunch of class definitions and class extensions.
Properties include ''name''.
Sub-definitions are classDefinitions and classExtensions
';
		immediateInvariant.
true.
%

removeallmethods RwPackageDefinition
removeallclassmethods RwPackageDefinition

doit
(RwDefinition
	subclass: 'RwProjectDefinition'
	instVarNames: #(packages)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Definitions';
		immediateInvariant.
true.
%

removeallmethods RwProjectDefinition
removeallclassmethods RwProjectDefinition

doit
(Object
	subclass: 'RwElementsModification'
	instVarNames: #(elementsModified)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		comment: 'Abstract. Represents a modification to the elements of some code entity. "Modification" means that the code entity exists both before and after, but has differences in some of its elements.

Instvars:

elementsAdded		Dictionary elementKey -> element
elementsRemoved	Dictonary elementKey -> element
elementsModified	Dictionary elementKey -> CypModification  (key may have changed -- if so the key here is the old key)';
		immediateInvariant.
true.
%

removeallmethods RwElementsModification
removeallclassmethods RwElementsModification

doit
(RwElementsModification
	subclass: 'RwClassesModification'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		comment: 'A modification showing the difference between the classes or classExtensions of a package. The elements are classes. Key is class name.';
		immediateInvariant.
true.
%

removeallmethods RwClassesModification
removeallclassmethods RwClassesModification

doit
(RwElementsModification
	subclass: 'RwClassExtensionsModification'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		comment: 'No class-specific documentation for CypClassExtensionsModification, hierarchy is: 
Object
  CypElementsModification( elementsAdded elementsRemoved elementsModified)
    CypClassExtensionsModification
';
		immediateInvariant.
true.
%

removeallmethods RwClassExtensionsModification
removeallclassmethods RwClassExtensionsModification

doit
(RwElementsModification
	subclass: 'RwEntitySetModification'
	instVarNames: #(movedClasses movedMethods movedPackages movedTraits movedTraitMethods)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwEntitySetModification
removeallclassmethods RwEntitySetModification

doit
(RwEntitySetModification
	subclass: 'RwPackageSetModification'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		comment: 'A modification showing the difference between two PackageSets. The elements are packages. Key is package name.
movedClasses are classes that have moved from one package to another within the package set.
movedMethods are methods that have moved from a class definition to an extension of that class, or vice versa, or between two extensions of the same class.';
		immediateInvariant.
true.
%

removeallmethods RwPackageSetModification
removeallclassmethods RwPackageSetModification

doit
(RwEntitySetModification
	subclass: 'RwProjectSetModification'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		comment: 'A modification showing the difference between two PackageSets. The elements are packages. Key is package name.
movedClasses are classes that have moved from one package to another within the package set.
movedMethods are methods that have moved from a class definition to an extension of that class, or vice versa, or between two extensions of the same class.';
		immediateInvariant.
true.
%

removeallmethods RwProjectSetModification
removeallclassmethods RwProjectSetModification

doit
(RwElementsModification
	subclass: 'RwMethodsModification'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		comment: 'A modification showing the difference between the instance or class methods defined by a class or class extension. The elements are method definitions. Key is selector (as string).';
		immediateInvariant.
true.
%

removeallmethods RwMethodsModification
removeallclassmethods RwMethodsModification

doit
(RwMethodsModification
	subclass: 'RwExtensionMethodsModification'
	instVarNames: #(extendedClassName)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwExtensionMethodsModification
removeallclassmethods RwExtensionMethodsModification

doit
(RwMethodsModification
	subclass: 'RwTraitMethodsModification'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwTraitMethodsModification
removeallclassmethods RwTraitMethodsModification

doit
(RwElementsModification
	subclass: 'RwPackagesModification'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		comment: 'A modification showing the difference between the classes or classExtensions of a package. The elements are classes. Key is class name.';
		immediateInvariant.
true.
%

removeallmethods RwPackagesModification
removeallclassmethods RwPackagesModification

doit
(RwElementsModification
	subclass: 'RwPropertiesModification'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		comment: 'A modification showing the difference between the properties of a single entity. The elements are associations of propertyName -> propertyValue. Key is property name.';
		immediateInvariant.
true.
%

removeallmethods RwPropertiesModification
removeallclassmethods RwPropertiesModification

doit
(RwElementsModification
	subclass: 'RwSourceModification'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		comment: 'DELETE ME';
		immediateInvariant.
true.
%

removeallmethods RwSourceModification
removeallclassmethods RwSourceModification

doit
(RwElementsModification
	subclass: 'RwTraitsModification'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwTraitsModification
removeallclassmethods RwTraitsModification

doit
(Object
	subclass: 'RwEntitySet'
	instVarNames: #(entities)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Definitions';
		comment: 'Holds some number of RwDefinitions or RwLoadedThingss to be operated on together. The entities put into the receiver should be at the same semantic level: all methods, class, packages , or projects.

When the receiver is sent #asDefinition, the receiver is converted to a RwDefinitionSetDefinition and all entities are converted to their definition counterparts.';
		immediateInvariant.
true.
%

removeallmethods RwEntitySet
removeallclassmethods RwEntitySet

doit
(RwEntitySet
	subclass: 'RwLoadedProjectSet'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Definitions';
		immediateInvariant.
true.
%

removeallmethods RwLoadedProjectSet
removeallclassmethods RwLoadedProjectSet

doit
(RwEntitySet
	subclass: 'RwLoadSpecSet'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Definitions';
		immediateInvariant.
true.
%

removeallmethods RwLoadSpecSet
removeallclassmethods RwLoadSpecSet

doit
(Object
	subclass: 'RwGsImage'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-Core';
		comment: 'Keeps track of what LoadedPackages are in the GemStone repository, and is the gateway for operations to query or change the image.';
		immediateInvariant.
true.
%

removeallmethods RwGsImage
removeallclassmethods RwGsImage

doit
(Object
	subclass: 'RwGsImagePatchVisitor_V2'
	instVarNames: #(patchSet currentProject currentPackage currentClass currentTrait currentMethod)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		comment: 'Walks a diff tree and adds patches to a patchSet that will update the GemStone image (repository) to the code state represented by the ''after'' state of the diff, provided that the ''before'' state of the diff is the current state of the image.';
		immediateInvariant.
true.
%

removeallmethods RwGsImagePatchVisitor_V2
removeallclassmethods RwGsImagePatchVisitor_V2

doit
(Object
	subclass: 'RwGsInstanceMigrator'
	instVarNames: #(migrationEnabled maxThreads maxCpuPercentage clearClassHistoryAfterMigrate)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-Core';
		immediateInvariant.
true.
%

removeallmethods RwGsInstanceMigrator
removeallclassmethods RwGsInstanceMigrator

doit
(RwGsInstanceMigrator
	subclass: 'RwGsDeferredInstanceMigrator'
	instVarNames: #(classesToMigrate)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-Core';
		immediateInvariant.
true.
%

removeallmethods RwGsDeferredInstanceMigrator
removeallclassmethods RwGsDeferredInstanceMigrator

doit
(Object
	subclass: 'RwGsPatchSet_V2'
	instVarNames: #(instanceMigrator addedProjects addedPackages deletedPackages movedPackages projectsWithPropertyChanges addedClasses deletedClasses deletedTraits movedClasses extendedClasses classesWithPropertyChanges classesWithSymbolDictionaryChanges classesWithClassVariableChanges classesWithConstraintChanges classesWithNewVersions addedTraits addedMethods addedTraitMethods deletedMethods deletedTraitMethods deleteNewVersionMethods movedMethods extendedMethods methodsWithPropertyChanges methodsNeedingRecompile traitMethodsNeedingRecompile tempSymbols createdClasses changedTraits createdTraits classesWithTraits errors currentProjectDefinition movedClassesSymbolList addedUnmanagedClasses loadSymbolList)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		comment: 'A set of patches (changes) to be applied atomically (or as close to atomically as possible) to a GemStone repository.';
		immediateInvariant.
true.
%

removeallmethods RwGsPatchSet_V2
removeallclassmethods RwGsPatchSet_V2

doit
(Object
	subclass: 'RwGsPatchV2'
	instVarNames: #(packageDefinition projectDefinition)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsPatchV2
removeallclassmethods RwGsPatchV2

doit
(RwGsPatchV2
	subclass: 'RwGsClassPatchV2'
	instVarNames: #(classDefinition)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsClassPatchV2
removeallclassmethods RwGsClassPatchV2

doit
(RwGsClassPatchV2
	subclass: 'RwGsClassAdditionSymbolDictPatchV2'
	instVarNames: #(newClass symbolAssociation)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsClassAdditionSymbolDictPatchV2
removeallclassmethods RwGsClassAdditionSymbolDictPatchV2

doit
(RwGsClassAdditionSymbolDictPatchV2
	subclass: 'RwGsClassUnmanagedAdditionSymbolDictPatchV2'
	instVarNames: #(oldClassVersion)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsClassUnmanagedAdditionSymbolDictPatchV2
removeallclassmethods RwGsClassUnmanagedAdditionSymbolDictPatchV2

doit
(RwGsClassPatchV2
	subclass: 'RwGsClassConstraintsSymDictPatchV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsClassConstraintsSymDictPatchV2
removeallclassmethods RwGsClassConstraintsSymDictPatchV2

doit
(RwGsClassPatchV2
	subclass: 'RwGsClassDeletionSymbolDictPatchV2'
	instVarNames: #(existingClass)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsClassDeletionSymbolDictPatchV2
removeallclassmethods RwGsClassDeletionSymbolDictPatchV2

doit
(RwGsClassPatchV2
	subclass: 'RwGsClassExtensionSymbolDictPatchV2'
	instVarNames: #(patchClass)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsClassExtensionSymbolDictPatchV2
removeallclassmethods RwGsClassExtensionSymbolDictPatchV2

doit
(RwGsClassPatchV2
	subclass: 'RwGsClassPropertiesSymDictPatchV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsClassPropertiesSymDictPatchV2
removeallclassmethods RwGsClassPropertiesSymDictPatchV2

doit
(RwGsClassPatchV2
	subclass: 'RwGsClassSymbolDictionaryMoveSymDictPatchV2'
	instVarNames: #(classModification)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsClassSymbolDictionaryMoveSymDictPatchV2
removeallclassmethods RwGsClassSymbolDictionaryMoveSymDictPatchV2

doit
(RwGsClassPatchV2
	subclass: 'RwGsClassVariableChangeSymbolDictPatchV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsClassVariableChangeSymbolDictPatchV2
removeallclassmethods RwGsClassVariableChangeSymbolDictPatchV2

doit
(RwGsClassPatchV2
	subclass: 'RwGsClassVersioningPatchV2'
	instVarNames: #(classModification oldClassVersion newClassVersion symbolAssociation)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsClassVersioningPatchV2
removeallclassmethods RwGsClassVersioningPatchV2

doit
(RwGsClassPatchV2
	subclass: 'RwGsClassVersioningSymbolDictPatchV2'
	instVarNames: #(classModification oldClassVersion newClassVersion symbolAssociation)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsClassVersioningSymbolDictPatchV2
removeallclassmethods RwGsClassVersioningSymbolDictPatchV2

doit
(RwGsClassVersioningSymbolDictPatchV2
	subclass: 'RwGsClassUnmanagedVersioningSymbolDictPatchV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsClassUnmanagedVersioningSymbolDictPatchV2
removeallclassmethods RwGsClassUnmanagedVersioningSymbolDictPatchV2

doit
(RwGsPatchV2
	subclass: 'RwGsMethodPatchV2'
	instVarNames: #(isMeta methodDefinition classDefinition behavior selector compiledMethod)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsMethodPatchV2
removeallclassmethods RwGsMethodPatchV2

doit
(RwGsMethodPatchV2
	subclass: 'RwGsMethodAdditionSymbolDictPatchV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsMethodAdditionSymbolDictPatchV2
removeallclassmethods RwGsMethodAdditionSymbolDictPatchV2

doit
(RwGsMethodAdditionSymbolDictPatchV2
	subclass: 'RwGsTraitMethodAdditionSymbolDictPatchV2'
	instVarNames: #(traitDefinition traitInstance)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsTraitMethodAdditionSymbolDictPatchV2
removeallclassmethods RwGsTraitMethodAdditionSymbolDictPatchV2

doit
(RwGsMethodPatchV2
	subclass: 'RwGsMethodDeletionSymbolDictPatchV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsMethodDeletionSymbolDictPatchV2
removeallclassmethods RwGsMethodDeletionSymbolDictPatchV2

doit
(RwGsMethodDeletionSymbolDictPatchV2
	subclass: 'RwGsMethodDeletionExtensionSymbolDictPatchV2'
	instVarNames: #(extendedClassName)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsMethodDeletionExtensionSymbolDictPatchV2
removeallclassmethods RwGsMethodDeletionExtensionSymbolDictPatchV2

doit
(RwGsMethodDeletionExtensionSymbolDictPatchV2
	subclass: 'RwGsMethodDeletionExtensionSessionMethodSymbolDictPatchV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsMethodDeletionExtensionSessionMethodSymbolDictPatchV2
removeallclassmethods RwGsMethodDeletionExtensionSessionMethodSymbolDictPatchV2

doit
(RwGsMethodDeletionSymbolDictPatchV2
	subclass: 'RwGsTraitMethodDeletionSymbolDictPatchV2'
	instVarNames: #(traitDefinition traitInstance)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsTraitMethodDeletionSymbolDictPatchV2
removeallclassmethods RwGsTraitMethodDeletionSymbolDictPatchV2

doit
(RwGsMethodPatchV2
	subclass: 'RwGsMethodExtensionSymbolDictPatchV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsMethodExtensionSymbolDictPatchV2
removeallclassmethods RwGsMethodExtensionSymbolDictPatchV2

doit
(RwGsMethodExtensionSymbolDictPatchV2
	subclass: 'RwGsMethodExtensionSessionMethodSymbolDictPatchV2'
	instVarNames: #(sessionDictsArray methDict catDict pArray)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsMethodExtensionSessionMethodSymbolDictPatchV2
removeallclassmethods RwGsMethodExtensionSessionMethodSymbolDictPatchV2

doit
(RwGsMethodPatchV2
	subclass: 'RwGsMethodPropertiesSymDictPatchV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsMethodPropertiesSymDictPatchV2
removeallclassmethods RwGsMethodPropertiesSymDictPatchV2

doit
(RwGsMethodPropertiesSymDictPatchV2
	subclass: 'RwGsMethodExtensionSessionMethodPropertiesSymDictPatchV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsMethodExtensionSessionMethodPropertiesSymDictPatchV2
removeallclassmethods RwGsMethodExtensionSessionMethodPropertiesSymDictPatchV2

doit
(RwGsMethodPatchV2
	subclass: 'RwGsMethodSourceSymbolDictPatchV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsMethodSourceSymbolDictPatchV2
removeallclassmethods RwGsMethodSourceSymbolDictPatchV2

doit
(RwGsMethodSourceSymbolDictPatchV2
	subclass: 'RwGsMethodExtensionSessionMethodSourceSymbolDictPatchV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsMethodExtensionSessionMethodSourceSymbolDictPatchV2
removeallclassmethods RwGsMethodExtensionSessionMethodSourceSymbolDictPatchV2

doit
(RwGsMethodSourceSymbolDictPatchV2
	subclass: 'RwGsTraitMethodSourceSymbolDictPatchV2'
	instVarNames: #(traitDefinition traitInstance)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsTraitMethodSourceSymbolDictPatchV2
removeallclassmethods RwGsTraitMethodSourceSymbolDictPatchV2

doit
(RwGsPatchV2
	subclass: 'RwGsPackagePatchV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsPackagePatchV2
removeallclassmethods RwGsPackagePatchV2

doit
(RwGsPackagePatchV2
	subclass: 'RwGsPackageAdditionSymbolDictPatchV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsPackageAdditionSymbolDictPatchV2
removeallclassmethods RwGsPackageAdditionSymbolDictPatchV2

doit
(RwGsPackagePatchV2
	subclass: 'RwGsPackageDeletionSymbolDictPatchV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsPackageDeletionSymbolDictPatchV2
removeallclassmethods RwGsPackageDeletionSymbolDictPatchV2

doit
(RwGsPackagePatchV2
	subclass: 'RwGsPackageMoveSymbolDictPatchV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsPackageMoveSymbolDictPatchV2
removeallclassmethods RwGsPackageMoveSymbolDictPatchV2

doit
(RwGsPatchV2
	subclass: 'RwGsProjectPatchV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsProjectPatchV2
removeallclassmethods RwGsProjectPatchV2

doit
(RwGsProjectPatchV2
	subclass: 'RwGsProjectAdditionPatchV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsProjectAdditionPatchV2
removeallclassmethods RwGsProjectAdditionPatchV2

doit
(RwGsPatchV2
	subclass: 'RwGsTraitPatchV2'
	instVarNames: #(traitDefinition)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsTraitPatchV2
removeallclassmethods RwGsTraitPatchV2

doit
(RwGsTraitPatchV2
	subclass: 'RwGsTraitAdditionSymbolDictPatchV2'
	instVarNames: #(newTrait symbolAssociation)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsTraitAdditionSymbolDictPatchV2
removeallclassmethods RwGsTraitAdditionSymbolDictPatchV2

doit
(RwGsTraitPatchV2
	subclass: 'RwGsTraitDeletionSymbolDictPatchV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsTraitDeletionSymbolDictPatchV2
removeallclassmethods RwGsTraitDeletionSymbolDictPatchV2

doit
(RwGsTraitPatchV2
	subclass: 'RwGsTraitModificationSymbolDictPatchV2'
	instVarNames: #(existingTrait theModificationForMove)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		immediateInvariant.
true.
%

removeallmethods RwGsTraitModificationSymbolDictPatchV2
removeallclassmethods RwGsTraitModificationSymbolDictPatchV2

doit
(Object
	subclass: 'RwGsSymbolDictionaryRegistryV2'
	instVarNames: #(symbolDictionary packageRegistry)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2-36x';
		immediateInvariant.
true.
%

removeallmethods RwGsSymbolDictionaryRegistryV2
removeallclassmethods RwGsSymbolDictionaryRegistryV2

doit
(Object
	subclass: 'RwGsSymbolDictionaryRegistry_ImplementationV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanLoader
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-LoaderV2';
		comment: 'The Rowan-GemStone-Loader implementation does depend upon having a stable and consistent implementation of the RwGsSymbolDictionaryRegistry behavior for the duration of a load.

Right before a load, all of the classes that make up the Rowan-GemStone-Loader package are copied and isolated from the rest of the system, so that updates to the loader code itself will not change the behavior of the loader implementation while the load is in progress.

The class RwGsSymbolDictionaryRegistry is not part of the Rowan-GemStone-Loader package, because instance of the class are expected to have long lifetimes.

This class implements the behavior for RwGsSymbolDictionaryRegistry and since it is the Rowan-GemStone-Loader package, it can be copied and isolated during a load, without affecting the long lived instances of RwGsSymbolDictionaryRegistry.

The methods in the receiver (class-side only) have an extra `instance:` argument tacked on that refers to the instance of RwGsSymbolDictionaryRegistry that was the original target of the message. For example:

	RwGsSymbolDictionaryRegistry_implementation class>>addClassAssociation:forClass:toPackageNamed:instance:

The methods in RwGsSymbolDictionaryRegistry are implemented with a compiled in reference to the RwGsSymbolDictionaryRegistry_implementation class as follows:

	addClassAssociation: assoc forClass: class toPackageNamed: packageName

		^ RwGsSymbolDictionaryRegistry_implementation addClassAssociation: assoc forClass: class toPackageNamed: packageName instance: self

This form is adequate for message sends from classes outside of the Rowan-GemStone-Loader package.

Inside the Rowan-GemStone-Loader package, the messgaes sends must pass in a reference to the `RwGsSymbolDictionaryRegistry_implementation`. This reference will refer to the cloned copy of the class when the RowanLoader symbol dictionary is cloned. The methods have and extra `implementationClass:` that refers to the class and allows the caller to pass in a reference to the cloned class. For example:

	addClassAssociation: assoc forClass: class toPackageNamed: packageName implementationClass: implementationClass

		"Copy the name association to the correct 
			SymbolDictionary in the live SymbolList.
			Create a LoadedClass for the new class, add it to the defining LoadedPackage."

		^ implementationClass addClassAssociation: assoc forClass: class toPackageNamed: packageName instance: self';
		immediateInvariant.
true.
%

removeallmethods RwGsSymbolDictionaryRegistry_ImplementationV2
removeallclassmethods RwGsSymbolDictionaryRegistry_ImplementationV2

doit
(Object
	subclass: 'RwLoadedThing'
	instVarNames: #(properties name handle)
	classVars: #(AbsentToken)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Loader';
		comment: 'properties: dictionary of properties
name: name of class or package, selector of method
handle: reference to the class or method object, or to the native package object for dialects that have that.';
		immediateInvariant.
true.
%

removeallmethods RwLoadedThing
removeallclassmethods RwLoadedThing

doit
(RwLoadedThing
	subclass: 'RwLoadedClass'
	instVarNames: #(loadedPackage loadedInstanceMethods loadedClassMethods)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Loader';
		comment: 'package: the CypLoadedPackage that defines me and all my methods that are not extension methods.
extensions: a collection of CypLoadedExtendedClasses for this class. From these we can tell which methods don''t belong to our default package.';
		immediateInvariant.
true.
%

removeallmethods RwLoadedClass
removeallclassmethods RwLoadedClass

doit
(RwLoadedClass
	subclass: 'RwGsLoadedSymbolDictClass'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-Core';
		immediateInvariant.
true.
%

removeallmethods RwGsLoadedSymbolDictClass
removeallclassmethods RwGsLoadedSymbolDictClass

doit
(RwLoadedThing
	subclass: 'RwLoadedClassExtension'
	instVarNames: #(loadedPackage loadedInstanceMethods loadedClassMethods)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Loader';
		comment: 'No class-specific documentation for CypLoadedClassExtension, hierarchy is: 
Object
  CypLoadedThing( properties name handle)
    CypLoadedClassExtension( loadedPackage loadedMethods)
';
		immediateInvariant.
true.
%

removeallmethods RwLoadedClassExtension
removeallclassmethods RwLoadedClassExtension

doit
(RwLoadedClassExtension
	subclass: 'RwGsLoadedSymbolDictClassExtension'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-Core';
		immediateInvariant.
true.
%

removeallmethods RwGsLoadedSymbolDictClassExtension
removeallclassmethods RwGsLoadedSymbolDictClassExtension

doit
(RwLoadedThing
	subclass: 'RwLoadedMethod'
	instVarNames: #(loadedClass classIsMeta)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Loader';
		comment: 'No class-specific documentation for CypLoadedMethod, hierarchy is: 
Object
  CypLoadedThing( properties name handle)
    CypLoadedMethod
';
		immediateInvariant.
true.
%

removeallmethods RwLoadedMethod
removeallclassmethods RwLoadedMethod

doit
(RwLoadedMethod
	subclass: 'RwGsLoadedSymbolDictMethod'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-Core';
		comment: 'The MethodRegistry maps GsNMethods to LoadedMethods.';
		immediateInvariant.
true.
%

removeallmethods RwGsLoadedSymbolDictMethod
removeallclassmethods RwGsLoadedSymbolDictMethod

doit
(RwGsLoadedSymbolDictMethod
	subclass: 'RwGsLoadedSymbolDictTraitMethod'
	instVarNames: #(source)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-Core';
		immediateInvariant.
true.
%

removeallmethods RwGsLoadedSymbolDictTraitMethod
removeallclassmethods RwGsLoadedSymbolDictTraitMethod

doit
(RwLoadedThing
	subclass: 'RwLoadedPackage'
	instVarNames: #(repository commitId loadedClasses loadedClassExtensions loadedTraits isDirty loadedProject)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Loader';
		comment: 'repository: The repository I was loaded from (if known, nil otherwise)
commitId: A repository-specific way of identifying source code commit, if it''s a type of repository that has that kind of information (nil otherwise)
loadedClasses: Dictionary -- keys are (non-meta) classes, values are the LoadedClasses that I define.
loadedClassExtensions: -- Dictionary -- keys are (non-meta) classes, values are the LoadedClassExtensions that I define.';
		immediateInvariant.
true.
%

removeallmethods RwLoadedPackage
removeallclassmethods RwLoadedPackage

doit
(RwLoadedPackage
	subclass: 'RwGsLoadedSymbolDictPackage'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-Core';
		immediateInvariant.
true.
%

removeallmethods RwGsLoadedSymbolDictPackage
removeallclassmethods RwGsLoadedSymbolDictPackage

doit
(RwLoadedThing
	subclass: 'RwLoadedProject'
	instVarNames: #(loadedPackages isDirty)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Loader';
		immediateInvariant.
true.
%

removeallmethods RwLoadedProject
removeallclassmethods RwLoadedProject

doit
(RwLoadedProject
	subclass: 'RwGsLoadedSymbolDictResolvedProjectV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-CoreV2';
		immediateInvariant.
true.
%

removeallmethods RwGsLoadedSymbolDictResolvedProjectV2
removeallclassmethods RwGsLoadedSymbolDictResolvedProjectV2

doit
(RwLoadedThing
	subclass: 'RwLoadedTrait'
	instVarNames: #(loadedPackage loadedInstanceMethods loadedClassMethods)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Loader';
		immediateInvariant.
true.
%

removeallmethods RwLoadedTrait
removeallclassmethods RwLoadedTrait

doit
(RwLoadedTrait
	subclass: 'RwGsLoadedSymbolDictTrait'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-Core';
		immediateInvariant.
true.
%

removeallmethods RwGsLoadedSymbolDictTrait
removeallclassmethods RwGsLoadedSymbolDictTrait

doit
(Object
	subclass: 'RwMethodAdditionOrRemoval'
	instVarNames: #(projectDefinition packageDefinition classDefinitionOrExtension methodKey isMeta methodsModification)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		comment: 'No class-specific documentation for CypMethodAdditionOrRemoval, hierarchy is: 
Object
  CypMethodAdditionOrRemoval( packageDefinition classDefinitionOrExtension methodKey isMeta methodsModification)
';
		immediateInvariant.
true.
%

removeallmethods RwMethodAdditionOrRemoval
removeallclassmethods RwMethodAdditionOrRemoval

doit
(Object
	subclass: 'RwModification'
	instVarNames: #(propertiesModification before after)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		comment: 'Abstract. Represents a modification to some code entity. "Modification" means that the code entity exists both before and after, but has differences in some of its elements.

Instvars:

before		A definition of the state before the modification
after		A definition of state after the modification';
		immediateInvariant.
true.
%

removeallmethods RwModification
removeallclassmethods RwModification

doit
(RwModification
	subclass: 'RwClassModification'
	instVarNames: #(instanceMethodsModification classMethodsModification)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		comment: 'Represents modifications to a single class definition or class extension.

Instvars:

propertiesModification			PropertiesModification -- changes to class or class extension properties
instanceMethodsModification	MethodsModification -- changes to instance methods defined
classMethodsModification		MethodsModification -- changes to class methods defined';
		immediateInvariant.
true.
%

removeallmethods RwClassModification
removeallclassmethods RwClassModification

doit
(RwClassModification
	subclass: 'RwClassExtensionModification'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwClassExtensionModification
removeallclassmethods RwClassExtensionModification

doit
(RwClassModification
	subclass: 'RwClassModificationForcingNewClassVersion'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-Core';
		immediateInvariant.
true.
%

removeallmethods RwClassModificationForcingNewClassVersion
removeallclassmethods RwClassModificationForcingNewClassVersion

doit
(RwClassModification
	subclass: 'RwClassUnmanagedModification'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-Core';
		immediateInvariant.
true.
%

removeallmethods RwClassUnmanagedModification
removeallclassmethods RwClassUnmanagedModification

doit
(RwClassModification
	subclass: 'RwTraitModification'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwTraitModification
removeallclassmethods RwTraitModification

doit
(RwModification
	subclass: 'RwMethodModification'
	instVarNames: #(sourceModification isMeta classDefinition)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		comment: 'Represents modifications to a single method

Instvars:

propertiesModification			PropertiesModification -- changes to method properties
oldSource						String -- source code before
newSource						String -- source code after';
		immediateInvariant.
true.
%

removeallmethods RwMethodModification
removeallclassmethods RwMethodModification

doit
(RwMethodModification
	subclass: 'RwExtensionMethodModification'
	instVarNames: #(extendedClassName)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwExtensionMethodModification
removeallclassmethods RwExtensionMethodModification

doit
(RwMethodModification
	subclass: 'RwMethodModificationForNewClassVersion'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwMethodModificationForNewClassVersion
removeallclassmethods RwMethodModificationForNewClassVersion

doit
(RwMethodModificationForNewClassVersion
	subclass: 'RwExtensionMethodModificationForNewClassVersion'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwExtensionMethodModificationForNewClassVersion
removeallclassmethods RwExtensionMethodModificationForNewClassVersion

doit
(RwMethodModification
	subclass: 'RwTraitMethodModification'
	instVarNames: #(traitName)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwTraitMethodModification
removeallclassmethods RwTraitMethodModification

doit
(RwModification
	subclass: 'RwPackageModification'
	instVarNames: #(classesModification classExtensionsModification traitsModification)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		comment: 'Represents modifications to a single package.

Instvars:

propertiesModification			PropertiesModification -- changes to package properties
classesModification				ClassesModification -- changes to classes defined
classExtensionsModification		ClassesModificaiton -- changes to classes extended';
		immediateInvariant.
true.
%

removeallmethods RwPackageModification
removeallclassmethods RwPackageModification

doit
(RwModification
	subclass: 'RwProjectModification'
	instVarNames: #(packagesModification)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		comment: 'Represents modifications to a single package.

Instvars:

propertiesModification			PropertiesModification -- changes to package properties
classesModification				ClassesModification -- changes to classes defined
classExtensionsModification		ClassesModificaiton -- changes to classes extended';
		immediateInvariant.
true.
%

removeallmethods RwProjectModification
removeallclassmethods RwProjectModification

doit
(Object
	subclass: 'RwMove'
	instVarNames: #(projectBefore projectAfter packageBefore packageAfter)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwMove
removeallclassmethods RwMove

doit
(RwMove
	subclass: 'RwClassExtensionMove'
	instVarNames: #(classExtensionBefore classExtensionAfter)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwClassExtensionMove
removeallclassmethods RwClassExtensionMove

doit
(RwMove
	subclass: 'RwClassMove'
	instVarNames: #(classBefore classAfter)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		comment: 'Represents the move of a class definition from one package to another.';
		immediateInvariant.
true.
%

removeallmethods RwClassMove
removeallclassmethods RwClassMove

doit
(RwMove
	subclass: 'RwMethodMove'
	instVarNames: #(methodBefore methodAfter isMeta classOrExtensionBefore classOrExtensionAfter)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		comment: 'Represents a move of a method from a class definition to a class extension, or from a class extension to a class definition, or between two extensions, of the same class. This should always also result in a change of package, since a class should not be defined and extended in the same package, nor extended twice in the same package.';
		immediateInvariant.
true.
%

removeallmethods RwMethodMove
removeallclassmethods RwMethodMove

doit
(RwMove
	subclass: 'RwPackageMove'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwPackageMove
removeallclassmethods RwPackageMove

doit
(RwMove
	subclass: 'RwTraitMethodMove'
	instVarNames: #(traitBefore traitAfter methodBefore methodAfter isMeta)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwTraitMethodMove
removeallclassmethods RwTraitMethodMove

doit
(RwMove
	subclass: 'RwTraitMove'
	instVarNames: #(traitBefore traitAfter classBefore classAfter)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwTraitMove
removeallclassmethods RwTraitMove

doit
(Object
	subclass: 'RwPackageAdditionOrRemoval'
	instVarNames: #(projectDefinition packageDefinition packageKey packagesModification)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwPackageAdditionOrRemoval
removeallclassmethods RwPackageAdditionOrRemoval

doit
(Object
	subclass: 'RwPlatform'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Kernel';
		comment: 'Provides services specific to the Smalltalk dialect being run,
and locates other services that are dialect-specific.';
		immediateInvariant.
true.
%

removeallmethods RwPlatform
removeallclassmethods RwPlatform

doit
(RwPlatform
	subclass: 'RwGsPlatform'
	instVarNames: #(alternateImageClass enableInstanceMigration instanceMigrator)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-Core';
		comment: 'This class is private to Cypress.
A GsPlatform is the gateway object for requesting platform-specific actions.';
		immediateInvariant.
true.
%

removeallmethods RwGsPlatform
removeallclassmethods RwGsPlatform

doit
(Object
	subclass: 'RwPropertyModification'
	instVarNames: #(key oldValue newValue)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		comment: 'No class-specific documentation for CypPropertyModification, hierarchy is: 
Object
  CypDiff( changes)
    CypLeafModification( key before after)
      CypPropertyModification
';
		immediateInvariant.
true.
%

removeallmethods RwPropertyModification
removeallclassmethods RwPropertyModification

doit
(RwPropertyModification
	subclass: 'RwUnconditionalPropertyModification'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		comment: 'No class-specific documentation for CypPropertyModification, hierarchy is: 
Object
  CypDiff( changes)
    CypLeafModification( key before after)
      CypPropertyModification
';
		immediateInvariant.
true.
%

removeallmethods RwUnconditionalPropertyModification
removeallclassmethods RwUnconditionalPropertyModification

doit
(Object
	subclass: 'RwResolvedProjectComponentsV2'
	instVarNames: #(components packageGroups)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-DefinitionsV2';
		immediateInvariant.
true.
%

removeallmethods RwResolvedProjectComponentsV2
removeallclassmethods RwResolvedProjectComponentsV2

doit
(Object
	subclass: 'RwResolvedProjectComponentVisitorV2'
	instVarNames: #(projectLoadSpecs readComponents readProjects visitedComponents visitedComponentNames customConditionalAttributes platformConditionalAttributes definedGroupNames projectNames groupNames componentNames resolvedProject)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Components';
		immediateInvariant.
true.
%

removeallmethods RwResolvedProjectComponentVisitorV2
removeallclassmethods RwResolvedProjectComponentVisitorV2

doit
(Object
	subclass: 'RwSpecification'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Specifications';
		immediateInvariant.
true.
%

removeallmethods RwSpecification
removeallclassmethods RwSpecification

doit
(RwSpecification
	subclass: 'RwLoadSpecificationV2'
	instVarNames: #(specName projectName projectAlias gitUrl diskUrl mercurialUrl readonlyDiskUrl relativeRepositoryRoot svnUrl revision projectSpecFile versionPrefix componentNames customConditionalAttributes platformProperties comment projectsHome repositoryResolutionPolicy)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-SpecificationsV2';
		immediateInvariant.
true.
%

removeallmethods RwLoadSpecificationV2
removeallclassmethods RwLoadSpecificationV2

doit
(RwLoadSpecificationV2
	subclass: 'RwEmbeddedLoadSpecificationV2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-SpecificationsV2';
		immediateInvariant.
true.
%

removeallmethods RwEmbeddedLoadSpecificationV2
removeallclassmethods RwEmbeddedLoadSpecificationV2

doit
(RwSpecification
	subclass: 'RwProjectSpecificationV2'
	instVarNames: #(specName projectName projectSpecPath componentsPath packagesPath projectsPath specsPath packageFormat packageConvention comment repoType loadedCommitId)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-SpecificationsV2';
		comment: 'RwProjectSpecificationV2 is a project specification that is use by Rowan V2 and Rowan V3 to specify project-specific attributes for Rowan.

Rowan 3 reads and writes projects that use this class.

methodSortOrder is `unicode`';
		immediateInvariant.
true.
%

removeallmethods RwProjectSpecificationV2
removeallclassmethods RwProjectSpecificationV2

doit
(RwProjectSpecificationV2
	subclass: 'RwProjectSpecificationV3'
	instVarNames: #(projectVersion)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-SpecificationsV2';
		comment: 'RwProjectSpecificationV3 is a project specification that is use by Rowan V3 to specify project-specific attributes for Rowan.

Rowan versions 3.0.0 through 3.3.0 use this class.  Methods in tonel packages are sorted using unicode sort order';
		immediateInvariant.
true.
%

removeallmethods RwProjectSpecificationV3
removeallclassmethods RwProjectSpecificationV3

doit
(RwProjectSpecificationV3
	subclass: 'RwProjectSpecificationV4'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-SpecificationsV2';
		comment: 'RwProjectSpecificationV4 is a project specification that is use by Rowan V3.4.0 and beyond to specify project-specific attributes for Rowan.

Projects managed using this class write tonel files that conform to the tonel spec. Specifically this class writes packages sorting methods based  Unicode codePoint sort';
		immediateInvariant.
true.
%

removeallmethods RwProjectSpecificationV4
removeallclassmethods RwProjectSpecificationV4

doit
(Object
	subclass: 'RwTraitAdditionOrRemoval'
	instVarNames: #(projectDefinition packageDefinition traitKey traitsModification)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwTraitAdditionOrRemoval
removeallclassmethods RwTraitAdditionOrRemoval

doit
(Object
	subclass: 'RwTraitMethodAdditionOrRemoval'
	instVarNames: #(projectDefinition packageDefinition traitDefinition methodKey isMeta methodsModification)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Core';
		immediateInvariant.
true.
%

removeallmethods RwTraitMethodAdditionOrRemoval
removeallclassmethods RwTraitMethodAdditionOrRemoval

doit
(Object
	subclass: 'RwUrl'
	instVarNames: #(fragment)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Url-Core';
		comment: 'A Uniform Resource Locator.  It specifies the location of a document on the Internet.  The base class is abstract; child classes break different types of URLs down in ways appropriate for that type.

The classes in this hierarchy:

RwUrl
 RwFileUrl
  RwCypressUrl
  RwFiletreeUrl
   RwTonelUrl
  RwGithubUrl
 RwGenericUrl
 RwHierarchicalUrl
  RwSmalltalkRepositoryUrl
   RwGitFileTreeUrl

are specificaly designed for parsing URLS for Rowan source code repositories:

 file:/opt/git/shared/repos/rowan/sample/repository
 http://gsdevkit.github.io/GsDevKit_home/rowan/Sample.ston
 https://raw.githubusercontent.com/dalehenrich/sample/master/specs/Sample.ston

 github://GsDevKit/GsDevKit:master/repository
 filetree:///opt/git/shared/repos/rowan/sample/repository
 tonel:/opt/git/shared/repos/rowan/sample/repository
 gitfiletree://gitlab.com/GsDevKit/GsDevKit:master/repository

 cypress:/opt/git/shared/repos/rowan/sample/repository/
 smalltalk://dkh:pass@gitlab.ferlicot.fr:3456/Projet/Bazard:dev/src
 smalltalk://git@git.gemtalksystems.com/btree340:dev/repository
 smalltalk://git@github.com/GsDevKit/GsDevKit:350/repository
 smalltalk://github.com/GsDevKit/GsDevKit:350/repository


The file:, http: and https: schemes should conform to the standard specs. ZnUrl is used for parsing http: and https: urls.

The github:, filetree:, gitfiletree: and tonel: schemes are supported for backward compatibility with schemes that have historically been used to identify Metacello repository urls.

The cypress: and smalltalk: schemes are new and intended to be used moving forward with Metacello and Rowan.

The cypress: url is used to indicate that path to a Cypress-style repository, i.e., a disk-based format for storing Smalltalk packages in filetree or tonel format. A cypress: url does not define the specific repository type (filetree or tonel). The type of the repository is encoded in a .filetree file located in the directory specified by pathString of the url.

The smalltalk: scheme is based on Thierry Goubier''s gitfiletree url[1]. The original github: scheme cannot be used for arbitrary git servers or git servers using non-standard ports or requiring usernames and passwords. Thierry''s scheme handles the full range of possibilites.

[1] https://github.com/dalehenrich/filetree/blob/734eed46ea57ebf5e24e5d935768bd49727fc22f/repository/MonticelloFileTree-Git.package/MCFileTreeGitRepository.class/class/basicFromUrl..st';
		immediateInvariant.
true.
%

removeallmethods RwUrl
removeallclassmethods RwUrl

doit
(RwUrl
	subclass: 'RwFileUrl'
	instVarNames: #(host path isAbsolute)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Url-Core';
		comment: 'This class models a file URL according to (somewhat) RFC1738, see http://www.w3.org/Addressing/rfc1738.txt

Here is the relevant part of the RFC:

3.10 FILES

   The file URL scheme is used to designate files accessible on a
   particular host computer. This scheme, unlike most other URL schemes,
   does not designate a resource that is universally accessible over the
   Internet.

   A file URL takes the form:

       file://<host>/<path>

   where <host> is the fully qualified domain name of the system on
   which the <path> is accessible, and <path> is a hierarchical
   directory path of the form <directory>/<directory>/.../<name>.

   For example, a VMS file

     DISK$USER:[MY.NOTES]NOTE123456.TXT

   might become

     <URL:file://vms.host.edu/disk$user/my/notes/note12345.txt>

   As a special case, <host> can be the string "localhost" or the empty
   string; this is interpreted as `the machine from which the URL is
   being interpreted''.

   The file URL scheme is unusual in that it does not specify an
   Internet protocol or access method for such files; as such, its
   utility in network protocols between hosts is limited.

From the above we can conclude that the RFC says that the <path> part never starts or ends with a slash and is always absolute. If the last name can be a directory instead of a file is not specified clearly.

The path is stored as a SequenceableCollection of path parts.

Notes regarding non RFC features in this class:

- If the last path part is the empty string, then the FileUrl is referring to a directory. This is also shown with a trailing slash when converted to a String.

- The FileUrl has an attribute isAbsolute which signals if the path should be considered absolute or relative to the current directory. This distinction is not visible in the String representation of FileUrl, since the RFC does not have that.

- Fragment is supported (kept for historical reasons)

';
		immediateInvariant.
true.
%

removeallmethods RwFileUrl
removeallclassmethods RwFileUrl

doit
(RwUrl
	subclass: 'RwGenericUrl'
	instVarNames: #(schemeName locator)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Url-Core';
		comment: 'a URL type that can''t be broken down in any systematic way.  For example, mailto: and telnet: URLs.  The part after the scheme name is stored available via the #locator message.';
		immediateInvariant.
true.
%

removeallmethods RwGenericUrl
removeallclassmethods RwGenericUrl

doit
(RwUrl
	subclass: 'RwHierarchicalUrl'
	instVarNames: #(schemeName authority path query port username password)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Url-Core';
		comment: 'A URL which has a hierarchical encoding.  For instance, http and ftp URLs are hierarchical.';
		immediateInvariant.
true.
%

removeallmethods RwHierarchicalUrl
removeallclassmethods RwHierarchicalUrl

doit
(RwHierarchicalUrl
	subclass: 'RwHttpUrl'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Url-Core';
		immediateInvariant.
true.
%

removeallmethods RwHttpUrl
removeallclassmethods RwHttpUrl

doit
(RwHttpUrl
	subclass: 'RwHttpsUrl'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Url-Core';
		immediateInvariant.
true.
%

removeallmethods RwHttpsUrl
removeallclassmethods RwHttpsUrl

doit
(STONWriter
	subclass: 'TonelSTONWriter'
	instVarNames: #(aliases)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-Core';
		comment: 'I''m a modified STON writer to make tonel metadata look as we want.

- it accept aliasses for classes, so I can say OrderedDictionary -> nil (then I do not have an extra information I do not want). Btw, tonel needs to use ordered dictionaries instead plain dictionaries because output needs to be deterministic, and we want to control the order of attributes we publish.
- if dictionary has just one element, it prints it in just one line, to have a more compact view.';
		immediateInvariant.
true.
%

removeallmethods TonelSTONWriter
removeallclassmethods TonelSTONWriter

doit
(TonelSTONWriter
	subclass: 'PharoTonelV1STONWriter'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-GemStone-Core';
		immediateInvariant.
true.
%

removeallmethods PharoTonelV1STONWriter
removeallclassmethods PharoTonelV1STONWriter

doit
(StringKeyValueDictionary
	subclass: 'RwAuditReport'
	instVarNames: #(owner logStream)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwAuditReport
removeallclassmethods RwAuditReport

doit
(StringKeyValueDictionary
	subclass: 'RwProjectAuditReport'
	instVarNames: #(projectName)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanTools
	options: #( #logCreation )
)
		category: 'Rowan-Tools-Core';
		immediateInvariant.
true.
%

removeallmethods RwProjectAuditReport
removeallclassmethods RwProjectAuditReport

doit
(WriteStream
	subclass: 'CypressMessageDigestStream'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Cypress-MesssageDigest';
		comment: 'All Cypress classes are private to GemStone and are likely to be removed in a future release.';
		immediateInvariant.
true.
%

removeallmethods CypressMessageDigestStream
removeallclassmethods CypressMessageDigestStream

! Class implementation for 'CypressLoaderError'

!		Class methods for 'CypressLoaderError'

category: 'instance creation'
classmethod: CypressLoaderError
patchOperation: aPatchOperation exception: anException

	^self new
		initializePatchOperation: aPatchOperation exception: anException;
		yourself
%

!		Instance methods for 'CypressLoaderError'

category: 'accessing'
method: CypressLoaderError
exception
	"Answer the original exception raised when applying the Patch Operation."

	^exception
%

category: 'updating'
method: CypressLoaderError
exception: anException
	"Assign the original exception raised when applying the Patch Operation."

	exception := anException
%

category: 'initializing - private'
method: CypressLoaderError
initialize

	super initialize.
	gsResumable := true
%

category: 'initializing - private'
method: CypressLoaderError
initializeMessageText

	| str |
	(str := String new )
		addAll: self patchOperation printString;
		addAll: ' failed because ';
		addAll: self exception printString.
	self details: str .
%

category: 'initializing - private'
method: CypressLoaderError
initializePatchOperation: aPatchOperation exception: anException

	self
		patchOperation: aPatchOperation;
		exception: anException;
		initializeMessageText
%

category: 'handling'
method: CypressLoaderError
logNotification: aString

	GsFile gciLogServer: aString.
	Transcript cr; nextPutAll: aString.
%

category: 'accessing'
method: CypressLoaderError
patchOperation
	"Answer the Patch Operation that could not be applied."

	^patchOperation
%

category: 'updating'
method: CypressLoaderError
patchOperation: aCypressPatchOperation
	"Assign the Patch Operation that could not be applied."

	patchOperation := aCypressPatchOperation
%

! Class implementation for 'CypressLoaderMissingClasses'

!		Class methods for 'CypressLoaderMissingClasses'

category: 'instance creation'
classmethod: CypressLoaderMissingClasses
missingRequirementsMap: aDictionary
	"Answer an instance of the receiver initialized on the specified
	 missing requirements. aDictionary maps prerequisite names to
	 a collection of dependent definitions."

	^self new
		initializeRequirementsMap: aDictionary;
		yourself
%

!		Instance methods for 'CypressLoaderMissingClasses'

category: 'initializing - private'
method: CypressLoaderMissingClasses
initialize

	super initialize.
	gsResumable := true
%

category: 'initializing - private'
method: CypressLoaderMissingClasses
initializeMessageText

	| str |
	str := 'Missing classes:' copy .
	self requirementsMap keysAndValuesDo: 
			[:className :definitions |
			str
				space;
				addAll: className printString , '(' , definitions size printString
							, ')'].
	self details: str.
%

category: 'initializing - private'
method: CypressLoaderMissingClasses
initializeRequirementsMap: aDictionary

	self
		requirementsMap: aDictionary;
		initializeMessageText.
%

category: 'accessing'
method: CypressLoaderMissingClasses
requirementsMap
	"The requirements map is a Dictionary mapping missing class
	 names to a collection of dependent definitions."

   ^requirementsMap
%

category: 'updating'
method: CypressLoaderMissingClasses
requirementsMap: aDictionary
	"The requirements map is a Dictionary mapping missing class
	 names to a collection of dependent definitions."

	requirementsMap := aDictionary
%

! Class implementation for 'GsFileinPackager'

!		Class methods for 'GsFileinPackager'

category: 'instance creation'
classmethod: GsFileinPackager
toPackage: packageName fromServerPath: aString packageConvention: packageConvention onDoitBlock: aZeroOneOrTwoArgBlockOrNil
	| fileStream gsFilein |
	fileStream := FileStreamPortable read: aString type: #'serverText'.
	[ 
	(gsFilein := self newFromStream: fileStream)
		packageConvention: packageConvention;
		setSession: nil .
	aZeroOneOrTwoArgBlockOrNil
		ifNotNil: [ gsFilein onDoitBlock: aZeroOneOrTwoArgBlockOrNil ].
	gsFilein currentPackage: packageName.
	gsFilein doFileIn ]
		ensure: [ fileStream close ]
%

category: 'instance creation'
classmethod: GsFileinPackager
toPackage: packageName packageConvention: packageConvention fromServerPath: aString
	self toPackage: packageName fromServerPath: aString packageConvention: packageConvention onDoitBlock: nil
%

category: 'instance creation'
classmethod: GsFileinPackager
toPackagesForDefinedProject: definedProject componentName: componentName fromServerPath: aString
	self
		toPackagesForDefinedProject: definedProject
		packageNameToComponentNameMap: Dictionary new
		defaultComponentName: componentName
		fromServerPath: aString
		onDoitBlock: [ :chunk :fileinPackager | fileinPackager parseRBDoitChunkForDefinition: chunk ]
%

category: 'instance creation'
classmethod: GsFileinPackager
toPackagesForDefinedProject: definedProject componentName: componentName fromStream: aStream
	self
		toPackagesForDefinedProject: definedProject
		packageNameToComponentNameMap: Dictionary new
		defaultComponentName: componentName
		fromStream: aStream
		onDoitBlock: [ :chunk :fileinPackager | fileinPackager parseRBDoitChunkForDefinition: chunk ]
%

category: 'instance creation'
classmethod: GsFileinPackager
toPackagesForDefinedProject: definedProject fromServerPath: aString
	self
		toPackagesForDefinedProject: definedProject
		componentName: 'Core'
		fromServerPath: aString
%

category: 'instance creation'
classmethod: GsFileinPackager
toPackagesForDefinedProject: definedProject fromStream: aStream
	self
		toPackagesForDefinedProject: definedProject
		componentName: 'Core'
		fromStream: aStream
%

category: 'instance creation'
classmethod: GsFileinPackager
toPackagesForDefinedProject: definedProject packageNameToComponentNameMap: packageNameToComponentNameMap defaultComponentName: defaultComponentName fromServerPath: aString onDoitBlock: aZeroOneOrTwoArgBlockOrNil
	| fileStream |
	fileStream := FileStreamPortable read: aString type: #'serverText'.
	[ 
	self
		toPackagesForDefinedProject: definedProject
		packageNameToComponentNameMap: packageNameToComponentNameMap
		defaultComponentName: defaultComponentName
		fromStream: fileStream
		onDoitBlock: aZeroOneOrTwoArgBlockOrNil ]
		ensure: [ fileStream close ]
%

category: 'instance creation'
classmethod: GsFileinPackager
toPackagesForDefinedProject: definedProject packageNameToComponentNameMap: packageNameToComponentNameMap defaultComponentName: defaultComponentName fromStream: aStream onDoitBlock: aZeroOneOrTwoArgBlockOrNil
	|  gsFilein |
	(gsFilein := self newFromStream: aStream)
		setSession: nil;
		setEnableRemoveAll: false.
	aZeroOneOrTwoArgBlockOrNil
		ifNotNil: [ gsFilein onDoitBlock: aZeroOneOrTwoArgBlockOrNil ].
	gsFilein 
		definedProject: definedProject;
		defaultComponentName: defaultComponentName;
		packageNameToComponentNameMap: packageNameToComponentNameMap .
	gsFilein doFileIn
%

!		Instance methods for 'GsFileinPackager'

category: 'processing'
method: GsFileinPackager
abort
	^ GsSession isSolo
		ifFalse: [ super abort ]
%

category: 'processing'
method: GsFileinPackager
abortTransaction
	^ GsSession isSolo
		ifFalse: [ super abortTransaction ]
%

category: 'processing'
method: GsFileinPackager
classMethod
  | className |
  super parseClassmethodLine .
	(className := self currentClass) ifNil: [ self error: 'current class not defined' ].
	self packageDefinition
		ifNotNil: [ :packageDef | 
			| classDef methodDef |
			methodDef := ((classDef := packageDef
				classDefinitionNamed: className
				ifAbsent: [  ])
				ifNil: [ 
					packageDef
						classExtensionDefinitionNamed: className
						ifAbsent: [ packageDef addClassExtensionNamed: className ] ])
				addClassMethod: self nextChunk
				protocol: category.
			[ 
			RwAbstractReaderWriterVisitor
				validatePackageConvention: self packageConvention
				forClassDefinition: classDef
				forMethodDefinitionProtocol: methodDef
				className: className
				isMeta: true
				forPackageNamed: packageDef name ]
				on: RwInvalidMethodProtocolConventionErrorNotification
				do: [ :ex | 
					"opportunity to automatically correct method protocol"
					self _correctMethodProtocolFor: methodDef ] ]
		ifNil: [ super classMethodBody ]
%

category: 'processing'
method: GsFileinPackager
commit
	^ GsSession isSolo
		ifFalse: [ super commit ]
%

category: 'processing'
method: GsFileinPackager
commitTransaction
	^ GsSession isSolo
		ifFalse: [ super commitTransaction ]
%

category: 'class definition creation'
method: GsFileinPackager
createClassDefinitionFromCommentCategoryImmediateInvariantCascadeNode: cascadeNode
	| messages classCreationMessageNode args cat comment superclassName classDef |
	self packageDefinition ifNil: [ self error: 'current package not defined' ].
	messages := cascadeNode messages.
	classCreationMessageNode := messages first receiver.
	args := classCreationMessageNode arguments.
	superclassName := classCreationMessageNode receiver token value.

	(messages detect: [ :each | each selector == #'category:' ] ifNone: [  ])
		ifNotNil: [ :messageNode | cat := messageNode arguments first token value ].
	(messages detect: [ :each | each selector == #'comment:' ] ifNone: [  ])
		ifNotNil: [ :messageNode | comment := messageNode arguments first token value ].

	(classCreationMessageNode selector
		==
			#'subclass:instVarNames:classVars:classInstVars:poolDictionaries:inDictionary:options:'
		or: [ 
			classCreationMessageNode selector
				==
					#'_newKernelSubclass:instVarNames:classVars:classInstVars:poolDictionaries:inDictionary:options:reservedOop:'
				or: [ 
					classCreationMessageNode selector
						==
							#'_newKernelIndexableSubclass:instVarNames:classVars:classInstVars:poolDictionaries:inDictionary:options:reservedOop:'
						or: [ 
							classCreationMessageNode selector
								==
									#'indexableSubclass:instVarNames:classVars:classInstVars:poolDictionaries:inDictionary:options:' ] ] ])
		ifTrue: [ 
			| type |
			type := 'normal'.
			(classCreationMessageNode selector
				==
					#'_newKernelIndexableSubclass:instVarNames:classVars:classInstVars:poolDictionaries:inDictionary:options:reservedOop:'
				or: [ 
					classCreationMessageNode selector
						==
							#'indexableSubclass:instVarNames:classVars:classInstVars:poolDictionaries:inDictionary:options:' ])
				ifTrue: [ type := 'variable' ].
			classDef := self packageDefinition
				addClassNamed: (args at: 1) token value
				super: superclassName
				instvars: (args at: 2) value
				classinstvars: (args at: 4) value
				classvars: (args at: 3) value
				category: cat
				comment: comment
				pools: (args at: 5) value
				type: type.
			classDef gs_options: (args at: 7) value.
			classCreationMessageNode selector
				==
					#'_newKernelSubclass:instVarNames:classVars:classInstVars:poolDictionaries:inDictionary:options:reservedOop:'
				ifTrue: [ classDef gs_reservedOop: (args at: 8) token value asString ] ]
		ifFalse: [ 
			(classCreationMessageNode selector
				== #'byteSubclass:classVars:poolDictionaries:inDictionary:options:'
				or: [ 
					classCreationMessageNode selector
						==
							#'_newKernelByteSubclass:classVars:poolDictionaries:inDictionary:options:reservedOop:' ])
				ifTrue: [ 
					| type |
					type := 'byteSubclass'.
					classDef := self packageDefinition
						addClassNamed: (args at: 1) token value
						super: superclassName
						instvars: #()
						classinstvars: #()
						classvars: (args at: 2) value
						category: cat
						comment: comment
						pools: (args at: 3) value
						type: type.
					classDef gs_options: (args at: 5) value.
					classCreationMessageNode selector
						==
							#'_newKernelByteSubclass:classVars:poolDictionaries:inDictionary:options:reservedOop:'
						ifTrue: [ classDef gs_reservedOop: (args at: 6) token value asString ] ] ].
	[ 
	RwAbstractReaderWriterVisitor
		validatePackageConvention: self packageConvention
		forClassCategory: classDef
		inPackageNamed: self packageDefinition name ]
		on: RwInvalidClassCategoryConventionErrorNotification
		do: [ :ex | 
			"opportunity to automatically correct class category"
			self _correctClassCategoryFor: classDef ]
%

category: 'class definition creation'
method: GsFileinPackager
createClassDefinitionFromCommentCategoryImmediateInvariantGsComCascadeNode: cascadeNode
	| messages classCreationMessageNode args cat comment superclassName classDef |
	self packageDefinition ifNil: [ self error: 'current package not defined' ].
	messages := cascadeNode messages.
	classCreationMessageNode := cascadeNode receiver.
	args := classCreationMessageNode arguments.
	superclassName := classCreationMessageNode receiver leaf litValue asString.

	(messages detect: [ :each | each selector == #'category:' ] ifNone: [  ])
		ifNotNil: [ :messageNode | cat := messageNode arguments first leaf litValue ].
	(messages detect: [ :each | each selector == #'comment:' ] ifNone: [  ])
		ifNotNil: [ :messageNode | comment := messageNode arguments first leaf litValue ].

	(classCreationMessageNode selector
		==
			#'subclass:instVarNames:classVars:classInstVars:poolDictionaries:inDictionary:options:'
		or: [ 
			classCreationMessageNode selector
				==
					#'_newKernelSubclass:instVarNames:classVars:classInstVars:poolDictionaries:inDictionary:options:reservedOop:'
				or: [ 
					classCreationMessageNode selector
						==
							#'_newKernelIndexableSubclass:instVarNames:classVars:classInstVars:poolDictionaries:inDictionary:options:reservedOop:'
						or: [ 
							classCreationMessageNode selector
								==
									#'indexableSubclass:instVarNames:classVars:classInstVars:poolDictionaries:inDictionary:options:' ] ] ])
		ifTrue: [ 
			| type |
			type := 'normal'.
			(classCreationMessageNode selector
				==
					#'_newKernelIndexableSubclass:instVarNames:classVars:classInstVars:poolDictionaries:inDictionary:options:reservedOop:'
				or: [ 
					classCreationMessageNode selector
						==
							#'indexableSubclass:instVarNames:classVars:classInstVars:poolDictionaries:inDictionary:options:' ])
				ifTrue: [ type := 'variable' ].
			classDef := self packageDefinition
				addClassNamed: (args at: 1) leaf litValue
				super: superclassName
				instvars: (args at: 2) leaf litValue
				classinstvars: (args at: 4) leaf litValue
				classvars: (args at: 3) leaf litValue
				category: cat
				comment: comment
				pools: (args at: 5) leaf litValue
				type: type.
			classDef gs_options: (args at: 7) leaf litValue.
			classCreationMessageNode selector
				==
					#'_newKernelSubclass:instVarNames:classVars:classInstVars:poolDictionaries:inDictionary:options:reservedOop:'
				ifTrue: [ classDef gs_reservedOop: (args at: 8) leaf litValue asString ] ]
		ifFalse: [ 
			(classCreationMessageNode selector
				== #'byteSubclass:classVars:poolDictionaries:inDictionary:options:'
				or: [ 
					classCreationMessageNode selector
						==
							#'_newKernelByteSubclass:classVars:poolDictionaries:inDictionary:options:reservedOop:' ])
				ifTrue: [ 
					| type |
					type := 'byteSubclass'.
					classDef := self packageDefinition
						addClassNamed: (args at: 1) leaf litValue
						super: superclassName
						instvars: #()
						classinstvars: #()
						classvars: (args at: 2) leaf litValue
						category: cat
						comment: comment
						pools: (args at: 3) leaf litValue
						type: type.
					classDef gs_options: (args at: 5) leaf litValue.
					classCreationMessageNode selector
						==
							#'_newKernelByteSubclass:classVars:poolDictionaries:inDictionary:options:reservedOop:'
						ifTrue: [ classDef gs_reservedOop: (args at: 6) leaf litValue asString ] ] ].
	[ 
	RwAbstractReaderWriterVisitor
		validatePackageConvention: self packageConvention
		forClassCategory: classDef
		inPackageNamed: self packageDefinition name ]
		on: RwInvalidClassCategoryConventionErrorNotification
		do: [ :ex | 
			"opportunity to automatically correct class category"
			self _correctClassCategoryFor: classDef ]
%

category: 'private'
method: GsFileinPackager
createGsComMethodForWorkspace: chunk
	| lastNonSeparatorCharacter |
	lastNonSeparatorCharacter := nil.
	chunk size to: 1 do: [ :index | 
		lastNonSeparatorCharacter
			ifNil: [ 
				| ch |
				(ch := chunk at: index) isSeparator
					ifFalse: [ lastNonSeparatorCharacter := ch ] ] ].
	^ lastNonSeparatorCharacter = $.
		ifTrue: [ ^ 'xxx ' , chunk , ' ^ true ' ]
		ifFalse: [ ^ 'xxx ' , chunk , '. ^ true ' ]
%

category: 'processing'
method: GsFileinPackager
currentPackage: aPackageName
	(self definedProject notNil and: [ aPackageName notNil ])
		ifTrue: [ 
			| componentName packageDef |
			self packageCount: self packageCount + 1.
			self packageCount > 1
				ifTrue: [ 
					self
						error:
							'Only one CURRENTPACKAGE: command allowed when creating package definitions' ].
			componentName := self packageNameToComponentNameMap
				at: aPackageName
				ifAbsent: [ self defaultComponentName ].
			packageDef := self definedProject
				packageNamed: aPackageName
				ifAbsent: [ 
					self definedProject
						addPackageNamed: aPackageName
						toComponentNamed: componentName ].
			self packageDefinition: packageDef ]
		ifFalse: [ Rowan gemstoneTools topaz currentTopazPackageName: aPackageName ]
%

category: 'accessing'
method: GsFileinPackager
defaultComponentName
	^ defaultComponentName ifNil: [ 'Core' ]
%

category: 'accessing'
method: GsFileinPackager
defaultComponentName: object
	defaultComponentName := object
%

category: 'accessing'
method: GsFileinPackager
definedProject
	^definedProject
%

category: 'accessing'
method: GsFileinPackager
definedProject: object
	definedProject := object
%

category: 'processing'
method: GsFileinPackager
doit
	self onDoitBlock cull: self nextChunk cull: self
%

category: 'processing'
method: GsFileinPackager
ignoreList
	^ super ignoreList , #('IFERROR' 'DEFINE' 'SEND' 'OBJ')
%

category: 'testing'
method: GsFileinPackager
isSupportedClassCreationSelector: sel
	^ #(#'subclass:instVarNames:classVars:classInstVars:poolDictionaries:inDictionary:options:' #'_newKernelSubclass:instVarNames:classVars:classInstVars:poolDictionaries:inDictionary:options:reservedOop:' #'_newKernelIndexableSubclass:instVarNames:classVars:classInstVars:poolDictionaries:inDictionary:options:reservedOop:' #'indexableSubclass:instVarNames:classVars:classInstVars:poolDictionaries:inDictionary:options:' #'byteSubclass:classVars:poolDictionaries:inDictionary:options:' #'_newKernelByteSubclass:classVars:poolDictionaries:inDictionary:options:reservedOop:')
		includes: sel
%

category: 'processing'
method: GsFileinPackager
method
  | className |
  super parseMethodLine .
	(className := self currentClass) ifNil: [ self error: 'current class not defined' ].
	self packageDefinition
		ifNotNil: [ :packageDef | 
			| classDef methodDef |
			methodDef := ((classDef := packageDef
				classDefinitionNamed: className
				ifAbsent: [ ])
				ifNil: [ 
					packageDef
						classExtensionDefinitionNamed: className
						ifAbsent: [ packageDef addClassExtensionNamed: className ] ])
				addInstanceMethod: self nextChunk
				protocol: category.
			[ 
			RwAbstractReaderWriterVisitor
				validatePackageConvention: self packageConvention
				forClassDefinition: classDef
				forMethodDefinitionProtocol: methodDef
				className: className
				isMeta: false
				forPackageNamed: packageDef name ]
				on: RwInvalidMethodProtocolConventionErrorNotification
				do: [ :ex | 
					"opportunity to automatically correct method protocol"
					self _correctMethodProtocolFor: methodDef ] ]
		ifNil: [ super methodBody ]
%

category: 'accessing'
method: GsFileinPackager
onDoitBlock
	"give user ability to track doits in .gs file ... by default execute the doitSrc"

	^ onDoitBlock ifNil: [ ^ [ :doitSrc | self execute: doitSrc ] ]
%

category: 'accessing'
method: GsFileinPackager
onDoitBlock: aZeroOneOrTwoArgBlock
	onDoitBlock := aZeroOneOrTwoArgBlock
%

category: 'accessing'
method: GsFileinPackager
packageConvention
	^ packageConvention
		ifNil: [ packageConvention := self definedProject packageConvention ]
%

category: 'accessing'
method: GsFileinPackager
packageConvention: object
	packageConvention := object
%

category: 'accessing'
method: GsFileinPackager
packageCount
	^ packageCount ifNil: [ packageCount := 0 ]
%

category: 'accessing'
method: GsFileinPackager
packageCount: object
	packageCount := object
%

category: 'accessing'
method: GsFileinPackager
packageDefinition
	^packageDefinition
%

category: 'accessing'
method: GsFileinPackager
packageDefinition: aPackageDefinition
	packageDefinition := aPackageDefinition
%

category: 'accessing'
method: GsFileinPackager
packageNameToComponentNameMap
	^packageNameToComponentNameMap
%

category: 'accessing'
method: GsFileinPackager
packageNameToComponentNameMap: object
	packageNameToComponentNameMap := object
%

category: 'doit parser'
method: GsFileinPackager
parseRBDoitChunkForDefinition: chunk
	"The doit chunk produced by topaz fileout (via Rowan) is:
		(<class-creation-message>)
			category: #categoryOrNil;
			comment: 'xxx';
			immediateInvariant.
	Will attempt to recognize as many standard class creation patterns as is required ..."

	| workspaceNode |
	workspaceNode := RBParser parseWorkspace: chunk.
	workspaceNode body
		do: [ :sequenceNode | 
			sequenceNode isSequence
				ifTrue: [ 
					sequenceNode statements
						do: [ :cascadeNode | 
							cascadeNode isCascade
								ifTrue: [ 
									| messages cascadeMessagePattern |
									"start matching class creation cascade message patterns"
									messages := cascadeNode messages.
									(messages size = 3
										and: [ 
											(cascadeMessagePattern := (messages collect: [ :message | message selector ])
												asArray sort)
												= #(#'comment:' #'category:' #'immediateInvariant') sort ])
										ifTrue: [ 
											| classCreationSelector |
											classCreationSelector := messages first receiver selector.
											(self isSupportedClassCreationSelector: classCreationSelector)
												ifTrue: [ 
													^ self
														createClassDefinitionFromCommentCategoryImmediateInvariantCascadeNode:
															cascadeNode ]
												ifFalse: [ 
													self
														error:
															'Unrecognized class creation selector: ' , classCreationSelector printString ] ]
										ifFalse: [ 
											((messages size = 3
												and: [ 
													(cascadeMessagePattern := (messages collect: [ :message | message selector ])
														asArray sort)
														= #(#'comment:' #'category:' #'immediateInvariant') sort ])
												or: [ 
													messages size = 2
														and: [ 
															(cascadeMessagePattern := (messages collect: [ :message | message selector ])
																asArray sort) = #(#'category:' #'immediateInvariant') sort ] ])
												ifTrue: [ 
													| classCreationSelector |
													classCreationSelector := messages first receiver selector.
													(self isSupportedClassCreationSelector: classCreationSelector)
														ifTrue: [ 
															^ self
																createClassDefinitionFromCommentCategoryImmediateInvariantCascadeNode:
																	cascadeNode ]
														ifFalse: [ 
															self
																error:
																	'Unrecognized class creation selector: ' , classCreationSelector printString ] ]
												ifFalse: [ 
													self
														error:
															'Unrecognized class creation message pattern: '
																, cascadeMessagePattern printString ] ] ]
								ifFalse: [ 
									((cascadeNode isMessage and: [ cascadeNode selector == #'initialize' ])
										or: [ cascadeNode isLiteralNode and: [ cascadeNode value == true ] ])
										ifTrue: [ 
											"initialize message sends and literal true in doits should be ignored"
											 ]
										ifFalse: [ self unexpectedNode: cascadeNode expectedNode: 'RBCascadeNode' ] ] ] ]
				ifFalse: [ self unexpectedNode: sequenceNode expectedNode: 'RBSequenceNode' ] ]
%

category: 'errors'
method: GsFileinPackager
unexpectedNode: node expectedNode: expectedNode
	self
		error:
			'Unrecognized class creation pattern. Expected a ' , expectedNode , ' not '
				, node class name asString , '.'
%

category: 'private'
method: GsFileinPackager
_correctClassCategoryFor: classDef
	(self packageConvention = 'RowanHybrid'
		or: [ self packageConvention = 'Monticello' ])
		ifTrue: [ classDef category: self packageDefinition name ]
		ifFalse: [ 
			self
				error:
					'Unexpected invalid class category for package convention '
						, self packageConvention printString ]
%

category: 'private'
method: GsFileinPackager
_correctMethodProtocolFor: methodDef
	(self packageConvention = 'RowanHybrid'
		or: [ self packageConvention = 'Monticello' ])
		ifTrue: [ methodDef protocol: '*' , self packageDefinition name asLowercase ]
		ifFalse: [ 
			self
				error:
					'Unexpected invalid method protocol for package convention '
						, self packageConvention printString ]
%

category: 'private'
method: GsFileinPackager
_setClass: aString
	"GsFileinPackager does not use currentClassObj, since we're building definitions not classes"

	self _setCurrentClassName: aString
%

! Class implementation for 'RwGemStoneVersionNumber'

!		Class methods for 'RwGemStoneVersionNumber'

category: 'instance creation'
classmethod: RwGemStoneVersionNumber
fromString: aString
	| new components |
	components := OrderedCollection new.
	(aString substrings: '.')
		do: [ :subString | 
			subString
				do: [ :each | 
					each isDigit
						ifFalse: [ 
							self
								error:
									'Encountered a non-digit character ', each printString, ' in a numeric version number field' ] ].
			components add: subString asInteger ].
	new := self new: components size.
	1 to: components size do: [ :i | new at: i put: (components at: i) ].
	^ new
%

!		Instance methods for 'RwGemStoneVersionNumber'

category: 'comparing'
method: RwGemStoneVersionNumber
< aRwGemStoneVersionNumber

	| condensed aCondensed |
	aRwGemStoneVersionNumber species = self species
		ifFalse: [ ^ false ].
	condensed := self collapseZeros.
	aCondensed := aRwGemStoneVersionNumber collapseZeros.
	(condensed ~~ self or: [ aCondensed ~~ aRwGemStoneVersionNumber ])
		ifTrue: [ ^ condensed compareLessThan: aCondensed ].
	^ self compareLessThan: aRwGemStoneVersionNumber
%

category: 'comparing'
method: RwGemStoneVersionNumber
= aRwGemStoneVersionNumber

	| condensed aCondensed |
	aRwGemStoneVersionNumber species = self species
		ifFalse: [ ^ false ].
	condensed := self collapseZeros.
	aCondensed := aRwGemStoneVersionNumber collapseZeros.
	(condensed ~~ self or: [ aCondensed ~~ aRwGemStoneVersionNumber ])
		ifTrue: [ ^ condensed compareEqualTo: aCondensed ].
	^ self compareEqualTo: aRwGemStoneVersionNumber
%

category: 'accessing'
method: RwGemStoneVersionNumber
approximateBase

	| base condensed |
	condensed := self collapseZeros.
	base := condensed copyFrom: 1 to: condensed size - 1.
	base at: base size put: (base at: base size) + 1.
	^base
%

category: 'converting'
method: RwGemStoneVersionNumber
asRwGemStoneVersionNumber

	^self
%

category: 'printing'
method: RwGemStoneVersionNumber
asString
	"Answer a string that represents the receiver."

	^ self printString
%

category: 'private'
method: RwGemStoneVersionNumber
collapseZeros
	"the rule must be that zeros can be collapsed as long as the series of zeros ends in a 0"

	| collection newSize new j lastElementIsStringOrZero canCollapse |
	(self size = 0 or: [ self at: 1 ]) == 0
		ifTrue: [ ^ self ].
	collection := OrderedCollection new.
	lastElementIsStringOrZero := true.
	canCollapse := true.
	self size to: 1 by: -1 do: [ :i | 
		| element |
		element := self at: i.
		(canCollapse and: [ element == 0 ])
			ifTrue: [ 
				lastElementIsStringOrZero
					ifFalse: [ 
						canCollapse := false.
						collection addFirst: element.]]
			ifFalse: [ 
				collection addFirst: element.
				canCollapse := lastElementIsStringOrZero := element isString ] ].
	collection size = self size
		ifTrue: [ ^ self ].
	newSize := collection size.
	new := self species new: newSize.
	j := 0.
	collection
		do: [ :element | 
			new at: j + 1 put: element.
			j := j + 1 ].
	^ new
%

category: 'private'
method: RwGemStoneVersionNumber
compareEqualTo: aRwGemStoneVersionNumber

	| mySize |
	aRwGemStoneVersionNumber species = self species ifFalse: [ ^false ].
	mySize := self size.
	mySize = aRwGemStoneVersionNumber size 
		ifFalse: [ ^false ].
	1 to: mySize do: [:i |
		(self at: i) = (aRwGemStoneVersionNumber at: i) ifFalse: [ ^false ]].
	^true
%

category: 'private'
method: RwGemStoneVersionNumber
compareLessThan: aRwGemStoneVersionNumber

	| mySize aSize commonSize count more |
	mySize := self size.
	aSize := aRwGemStoneVersionNumber size.
	commonSize :=  mySize min: aSize.
	count := 0.
	more := true.
	[ more and: [ count < commonSize ]] whileTrue: [
		(self at: count + 1) = (aRwGemStoneVersionNumber at: count + 1)
			ifTrue: [ count := count + 1 ]
			ifFalse: [ more := false ]].
	count < commonSize
		ifTrue: [ 
			^(self at: count + 1) < (aRwGemStoneVersionNumber at: count + 1) ].
	mySize < aSize
		ifTrue: [ 
			mySize = 0 ifTrue: [ ^true ].
			"if the versions at commonSize are equal and the next version slot in aRwGemStoneVersionNumber 
			 is a string, then it's considered that I'm > aRwGemStoneVersionNumber
			 (i.e., '2.9.9' is greater than '2.9.9-alpha.2')"
			(self at: commonSize) = (aRwGemStoneVersionNumber at: commonSize)
				ifFalse: [ ^true ]. 
			^(aRwGemStoneVersionNumber at: commonSize+1) isString not]
		ifFalse: [ 
			mySize = aSize ifTrue: [ ^false ].
			aSize <= 0 ifTrue: [ ^false ].
			"if the versions at commonSize are equal and the next version slot is a string, 
			 then it's considered that I'm < aRwGemStoneVersionNumber
			 (i.e., '2.9.9-alpha.2' is less than '2.9.9')"
			(self at: commonSize) = (aRwGemStoneVersionNumber at: commonSize)
				ifFalse: [ ^false ].
			 ^(self at: commonSize+1) isString]
%

category: 'copying'
method: RwGemStoneVersionNumber
copyFrom: start to: stop 
	"Answer a copy of a subset of the receiver, starting from element at 
	index start until element at index stop."

	| newSize new j |
	newSize := stop - start + 1.
	new := self species new: newSize.
	j := 0.
	start to: stop do: [:i |
		new at: j + 1 put: (self at: i).
		j := j + 1 ].
	^new
%

category: 'enumerating'
method: RwGemStoneVersionNumber
do: aBlock 
	"Refer to the comment in Collection|do:."
	1 to: self size do:
		[:index | aBlock value: (self at: index)]
%

category: 'enumerating'
method: RwGemStoneVersionNumber
do: elementBlock separatedBy: separatorBlock
	"Evaluate the elementBlock for all elements in the receiver,
	and evaluate the separatorBlock between."

	| beforeFirst | 
	beforeFirst := true.
	self do:
		[:each |
		beforeFirst
			ifTrue: [beforeFirst := false]
			ifFalse: [separatorBlock value].
		elementBlock value: each]
%

category: 'comparing'
method: RwGemStoneVersionNumber
hash

"Returns a numeric hash key for the receiver."

| mySize interval hashValue |

(mySize := self size) == 0
  ifTrue: [ ^15243 ].

"Choose an interval so that we sample at most 5 elements of the receiver"
interval := ((mySize - 1) // 4) max: 1.

hashValue := 4459.
1 to: mySize by: interval do: [ :i | | anElement |
  anElement := self at: i.
  (anElement isKindOf: SequenceableCollection)
    ifTrue: [
      hashValue := (hashValue bitShift: -1) bitXor: anElement size.
      ]
    ifFalse: [
      hashValue := (hashValue bitShift: -1) bitXor: anElement hash.
      ].
  ].

^ hashValue abs
%

category: 'printing'
method: RwGemStoneVersionNumber
printOn: aStream

	| beforeFirst | 
	beforeFirst := true.
	self do:
		[:each |
		beforeFirst
			ifTrue: [beforeFirst := false]
			ifFalse: [
				each isString
					ifTrue: [ aStream nextPut: $- ]
					ifFalse: [ aStream nextPut: $. ] ].
		aStream nextPutAll: each asString ]
%

category: 'matching'
method: RwGemStoneVersionNumber
rwPlatformAttributeMatchForGemStoneVersion: anRwGemStoneVersionConfigurationPlatformAttributeMatcher

	^ anRwGemStoneVersionConfigurationPlatformAttributeMatcher matchVersion: self
%

category: 'matching'
method: RwGemStoneVersionNumber
rwPlatformAttributeMatchForString: anRwStringConfigurationPlatformAttributeMatcher

	^ anRwStringConfigurationPlatformAttributeMatcher matchString: self printString
%

category: 'accessing'
method: RwGemStoneVersionNumber
versionString

	| strm |
	strm := WriteStream on: String new.
	self printOn: strm.
	^strm contents
%

category: 'comparing'
method: RwGemStoneVersionNumber
~> aRwGemStoneVersionNumber

	aRwGemStoneVersionNumber size == 1 ifTrue: [ ^false ].
	^self >= aRwGemStoneVersionNumber and: [ self < aRwGemStoneVersionNumber approximateBase ]
%

! Class implementation for 'RwSemanticVersionNumber'

!		Class methods for 'RwSemanticVersionNumber'

category: 'private'
classmethod: RwSemanticVersionNumber
extractNumericComponent: subString
    "$. separated components are integers"

    | number stream |
	stream := subString readStream.
	number := [ Integer fromStream: stream ] on: Error do: [:ex | ^ subString ].
	^ stream atEnd
		ifTrue: [ 
			(subString size > 1 and: [ (subString at: 1) = $0 ])
				ifTrue: [ self error: 'invalid version number: numberic components may not have a leading 0' ]
				ifFalse: [ number ] ]
		ifFalse: [ subString ]
%

category: 'instance creation'
classmethod: RwSemanticVersionNumber
fromString: aString
  | preRelease build versionString identifierCount normalEnd preReleaseEnd normalComponents preReleaseComponents buildComponents |
  normalComponents := OrderedCollection new.
  preReleaseComponents := OrderedCollection new.
  buildComponents := OrderedCollection new.
  preRelease := aString indexOf: $- startingAt: 1.
  build := aString indexOf: $+ startingAt: 1.
  (build > 0 and: [ preRelease > build ])
    ifTrue: [ preRelease := 0 ].
  normalEnd := preRelease = 0
    ifTrue: [ 
      build = 0
        ifTrue: [ aString size ]
        ifFalse: [ build - 1 ] ]
    ifFalse: [ preRelease - 1 ].
  versionString := aString copyFrom: 1 to: normalEnd.
  identifierCount := 0.
  (versionString subStrings: '.')
    do: [ :subString | 
      | integer |
      subString isEmpty
        ifTrue: [ self error: 'invalid version number: normal version component MUST NOT be empty' ].
	  integer := self integerFromString: subString.
	  integer < 0
		ifTrue: [ 
		  self
			error:
			  'invalid version number: normal version component MUST be integer '
				, subString printString ] .
      normalComponents add: integer.
      identifierCount := identifierCount + 1 ].
  identifierCount ~= 3
    ifTrue: [ self error: 'invalid version number: normal version MUST have only 3 components' ].
  preReleaseEnd := build = 0
    ifTrue: [ aString size ]
    ifFalse: [ build - 1 ].
  preRelease > 0
    ifTrue: [ 
      versionString := aString copyFrom: preRelease + 1 to: preReleaseEnd.
      (versionString subStrings: '.')
        do: [ :subString | 
	      subString isEmpty
              ifTrue: [ self error: 'invalid version number: preRelease version component MUST NOT be empty' ].
          (self isSemanticIdentifier: subString)
            ifFalse: [ 
              self
                error:
                  'invalid version number: preRelease version component must be one of [0-9A-Za-z-], MUST NOT be empty, and first component MUST NOT be 0' ].
          preReleaseComponents
            add:
              (self extractNumericComponent: subString) ] ].
  build > 0
    ifTrue: [ 
      versionString := aString copyFrom: build + 1 to: aString size.
      (versionString subStrings: '.')
        do: [ :subString | 
	      subString isEmpty
              ifTrue: [ self error: 'invalid version number: preRelease version component MUST NOT be empty' ].
          (self isSemanticIdentifier: subString)
            ifFalse: [ 
              self
                error:
                  'invalid version number: build version component must be one of [0-9A-Za-z-] and MUST NOT be empty' ].
          buildComponents add: subString ] ].

  ^ self new
    normalVersion: normalComponents;
    preReleaseVersion: preReleaseComponents;
    buildVersion: buildComponents;
    yourself
%

category: 'private'
classmethod: RwSemanticVersionNumber
integerFromString: aString
  aString
    detect: [ :char | char isDigit not ]
    ifNone: [ 
      | integer |
      integer := aString asInteger.
      ((aString at: 1) = $0 and: [ aString size > 1 ])
        ifTrue: [ 
          self
            error:
              'invalid version number: normal version component must not have leading 0s'
                , aString asString ].
      ^ integer ].
  self
    error:
      'invalid version number: normal version component must be integer '
        , aString asString
%

category: 'private'
classmethod: RwSemanticVersionNumber
isSemanticIdentifier: aString
    "whether the receiver is composed entirely of alphanumerics"

   aString do: [ :c | 
     c isAlphaNumeric
       ifFalse: [ c = $- ifFalse: [ ^ false ] ] ].
    ^ true
%

category: 'private'
classmethod: RwSemanticVersionNumber
validateVersionNumber: svn against: aString
  svn printString = aString
    ifFalse: [ 
      self
        error:
          'The printString of a semantic version number should be equal to the source version string' ]
%

!		Instance methods for 'RwSemanticVersionNumber'

category: 'comparing'
method: RwSemanticVersionNumber
< aRwSemanticVersionNumber
    aRwSemanticVersionNumber species = self species
        ifFalse: [ ^ false ].
    ^ self compareLessThan: aRwSemanticVersionNumber
%

category: 'comparing'
method: RwSemanticVersionNumber
= aMetacelloVersionNumber
    aMetacelloVersionNumber species = self species
        ifFalse: [ ^ false ].
    ^ self compareEqualTo: aMetacelloVersionNumber
%

category: 'accessing'
method: RwSemanticVersionNumber
approximateBase

	| base |
	base := self copyFrom: 1 to: self size - 1.
	base at: base size put: (base at: base size) + 1.
	^base
%

category: 'converting'
method: RwSemanticVersionNumber
asRwSemanticVersionNumber
    ^ self
%

category: 'printing'
method: RwSemanticVersionNumber
asString
	"Answer a string that represents the receiver."

	^ self printString
%

category: 'accessing'
method: RwSemanticVersionNumber
buildVersion
    buildVersion ifNil: [ buildVersion := #() ].
    ^ buildVersion
%

category: 'accessing'
method: RwSemanticVersionNumber
buildVersion: anObject
	buildVersion := anObject
%

category: 'private'
method: RwSemanticVersionNumber
compareEqualTo: aRwSemanticVersionNumber
    aRwSemanticVersionNumber species = self species
        ifFalse: [ ^ false ].
    (self compareEqualTo: self normalVersion other: aRwSemanticVersionNumber normalVersion)
        ifFalse: [ ^ false ].
    (self compareEqualTo: self preReleaseVersion other: aRwSemanticVersionNumber preReleaseVersion)
        ifFalse: [ ^ false ].
    ^ true
%

category: 'private'
method: RwSemanticVersionNumber
compareEqualTo: myComponents other: otherComponents
    | mySize |
    mySize := myComponents size.
    mySize = otherComponents size
        ifFalse: [ ^ false ].
    1 to: mySize do: [ :i | 
        (myComponents at: i) = (otherComponents at: i)
            ifFalse: [ ^ false ] ].
    ^ true
%

category: 'private'
method: RwSemanticVersionNumber
compareLessThan: aRwSemanticVersionNumber
    | myComponents otherComponents defaultResult |
    aRwSemanticVersionNumber species = self species
        ifFalse: [ ^ false ].
    myComponents := self normalVersion.
    otherComponents := aRwSemanticVersionNumber normalVersion.
    defaultResult := true.
    (self compareEqualTo: myComponents other: otherComponents)
        ifTrue: [ defaultResult := false ]
        ifFalse: [ 
            (self compareLessThan: myComponents other: otherComponents version: #'normal')
                ifFalse: [ ^ false ] ].
    myComponents := self preReleaseVersion.
    otherComponents := aRwSemanticVersionNumber preReleaseVersion.
    (self compareEqualTo: myComponents other: otherComponents)
        ifTrue: [ 
            myComponents size > 0
                ifTrue: [ defaultResult := false ] ]
        ifFalse: [ ^ self compareLessThan: myComponents other: otherComponents version: #'preRelease' ].
    ^ defaultResult
%

category: 'private'
method: RwSemanticVersionNumber
compareLessThan: myComponents other: otherComponents version: version
    | mySize aSize commonSize count more |
    mySize := myComponents size.
    aSize := otherComponents size.
    commonSize := mySize min: aSize.
    count := 0.
    more := true.
    [ more and: [ count < commonSize ] ]
        whileTrue: [ 
            (myComponents at: count + 1) = (otherComponents at: count + 1)
                ifTrue: [ count := count + 1 ]
                ifFalse: [ more := false ] ].
    count < commonSize
        ifTrue: [ ^ (myComponents at: count + 1) rwSemanticVersionComponentLessThan: (otherComponents at: count + 1) ].
    mySize < aSize
        ifTrue: [ 
            mySize = 0
                ifTrue: [ 
                    #'preRelease' == version
                        ifTrue: [ ^ false ].
                    ^ true ].
            (myComponents at: commonSize) = (otherComponents at: commonSize)
                ifFalse: [ ^ true ].
            ^ true ]
        ifFalse: [ 
            mySize = aSize
                ifTrue: [ ^ false ].
            aSize = 0
                ifTrue: [ 
                    #'build' == version
                        ifTrue: [ ^ false ].
                    ^ true ].
            (myComponents at: commonSize) = (otherComponents at: commonSize)
                ifFalse: [ ^ false ].
            ^ true ]
%

category: 'copying'
method: RwSemanticVersionNumber
copyFrom: start to: stop 
	"Answer a copy of a subset of the receiver, starting from element at 
	index start until element at index stop."

	| newSize new j |
	newSize := stop - start + 1.
	new := self species new: newSize.
	j := 0.
	start to: stop do: [:i |
		new at: j + 1 put: (self at: i).
		j := j + 1 ].
	^new
%

category: 'operations'
method: RwSemanticVersionNumber
decrementMajorVersion
  self decrementNormalVersionAt: 1
%

category: 'operations'
method: RwSemanticVersionNumber
decrementMinorVersion
  self decrementNormalVersionAt: 2
%

category: 'operations'
method: RwSemanticVersionNumber
decrementMinorVersionNumber
  self decrementNormalVersionAt: 3
%

category: 'private'
method: RwSemanticVersionNumber
decrementNormalVersionAt: index
  | int col |
  col := self normalVersion.
  int := col at: index.
  int > 0
    ifTrue: [ col at: index put: int - 1 ]
%

category: 'operations'
method: RwSemanticVersionNumber
decrementPatchVersion
  self decrementNormalVersionAt: 3
%

category: 'enumerating'
method: RwSemanticVersionNumber
do: aBlock 
	"Refer to the comment in Collection|do:."
	1 to: self size do:
		[:index | aBlock value: (self at: index)]
%

category: 'enumerating'
method: RwSemanticVersionNumber
do: elementBlock separatedBy: separatorBlock
	"Evaluate the elementBlock for all elements in the receiver,
	and evaluate the separatorBlock between."

	| beforeFirst | 
	beforeFirst := true.
	self do:
		[:each |
		beforeFirst
			ifTrue: [beforeFirst := false]
			ifFalse: [separatorBlock value].
		elementBlock value: each]
%

category: 'comparing'
method: RwSemanticVersionNumber
hash
    ^ self versionComponents hash
%

category: 'operations'
method: RwSemanticVersionNumber
incrementMajorVersion
  self incrementNormalVersionAt: 1
%

category: 'operations'
method: RwSemanticVersionNumber
incrementMinorVersion
  self incrementNormalVersionAt: 2
%

category: 'operations'
method: RwSemanticVersionNumber
incrementMinorVersionNumber
  self incrementNormalVersionAt: 3
%

category: 'private'
method: RwSemanticVersionNumber
incrementNormalVersionAt: index
  | int col |
  col := self normalVersion.
  int := col at: index.
  col at: index put: int + 1
%

category: 'operations'
method: RwSemanticVersionNumber
incrementPatchVersion
  self incrementNormalVersionAt: 3
%

category: 'accessing'
method: RwSemanticVersionNumber
normalVersion
    normalVersion ifNil: [ normalVersion := #() ].
    ^ normalVersion
%

category: 'accessing'
method: RwSemanticVersionNumber
normalVersion: anObject
	normalVersion := anObject
%

category: 'copying'
method: RwSemanticVersionNumber
postCopy
  normalVersion := normalVersion copy.
  preReleaseVersion := preReleaseVersion copy.
  buildVersion := buildVersion copy
%

category: 'accessing'
method: RwSemanticVersionNumber
preReleaseVersion
    preReleaseVersion ifNil: [ preReleaseVersion := #() ].
    ^ preReleaseVersion
%

category: 'accessing'
method: RwSemanticVersionNumber
preReleaseVersion: anObject
	preReleaseVersion := anObject
%

category: 'printing'
method: RwSemanticVersionNumber
print: components prefix: prefixChar on: aStream
    | beforeFirst |
    beforeFirst := true.
    components
        do: [ :component | 
            beforeFirst
                ifTrue: [ 
                    beforeFirst := false.
                    prefixChar ifNotNil: [ aStream nextPut: prefixChar ] ]
                ifFalse: [ aStream nextPut: $. ].
            aStream nextPutAll: component asString ]
%

category: 'printing'
method: RwSemanticVersionNumber
printOn: aStream
    self print: self normalVersion prefix: nil on: aStream.
    self print: self preReleaseVersion prefix: $- on: aStream.
    self print: self buildVersion prefix: $+ on: aStream
%

category: 'private'
method: RwSemanticVersionNumber
versionComponents
    ^ self normalVersion , self preReleaseVersion , self buildVersion
%

category: 'accessing'
method: RwSemanticVersionNumber
versionString

	| strm |
	strm := WriteStream on: String new.
	self printOn: strm.
	^strm contents
%

category: 'comparing'
method: RwSemanticVersionNumber
~> aMetacelloVersionNumber

	"if this selector is to survive it will need work ... see RwGemStoneVersionNumber ... I think that collapseZeroes will be needed (in some form) to 
		make this boy give expected results"

	aMetacelloVersionNumber size == 1 ifTrue: [ ^false ].
	^self >= aMetacelloVersionNumber and: [ self < aMetacelloVersionNumber approximateBase ]
%

! Class implementation for 'CypressLoaderErrorNotification'

!		Class methods for 'CypressLoaderErrorNotification'

category: 'instance creation'
classmethod: CypressLoaderErrorNotification
patchOperation: aPatchOperation exception: anException

	^self new
		initializePatchOperation: aPatchOperation exception: anException;
		yourself
%

!		Instance methods for 'CypressLoaderErrorNotification'

category: 'handling'
method: CypressLoaderErrorNotification
defaultAction
	"Log the notification to the GCI log and the Transcript, then resume."

	self logNotification: 'Notice: ' , self asString.
	^super defaultAction
%

category: 'accessing'
method: CypressLoaderErrorNotification
exception
	"Answer the original exception raised when applying the Patch Operation."

	^exception
%

category: 'updating'
method: CypressLoaderErrorNotification
exception: anException
	"Assign the original exception raised when applying the Patch Operation."

	exception := anException
%

category: 'initializing - private'
method: CypressLoaderErrorNotification
initializeMessageText

	| str |
	str :=	self patchOperation printString ,  ' failed because '.
	str addAll: self exception printString.
	self details: str .
%

category: 'initializing - private'
method: CypressLoaderErrorNotification
initializePatchOperation: aPatchOperation exception: anException

	self
		patchOperation: aPatchOperation;
		exception: anException;
		initializeMessageText
%

category: 'handling'
method: CypressLoaderErrorNotification
logNotification: aString

	GsFile gciLogServer: aString.
	Transcript cr; nextPutAll: aString.
%

category: 'accessing'
method: CypressLoaderErrorNotification
patchOperation
	"Answer the Patch Operation that could not be applied."

	^patchOperation
%

category: 'updating'
method: CypressLoaderErrorNotification
patchOperation: aCypressPatchOperation
	"Assign the Patch Operation that could not be applied."

	patchOperation := aCypressPatchOperation
%

! Class implementation for 'GsInteractionRequest'

!		Class methods for 'GsInteractionRequest'

category: 'interacting'
classmethod: GsInteractionRequest
signal: aGsInteraction
  ^ (self new interaction: aGsInteraction) signal
%

!		Instance methods for 'GsInteractionRequest'

category: 'signaling'
method: GsInteractionRequest
defaultAction
  ^ self interaction defaultActionFor: self
%

category: 'Compatibility'
method: GsInteractionRequest
gsArguments
  "This method included here for G/S 2.x only ... not needed nor used in 3.x"

  ^ {(self interaction)}
%

category: 'Instance initialization'
method: GsInteractionRequest
initialize
  super initialize.
  gsNumber := 121001
%

category: 'accessing'
method: GsInteractionRequest
interaction

   "Return the value of the instance variable 'interaction'."
   ^interaction
%

category: 'accessing'
method: GsInteractionRequest
interaction: anObject

   "Modify the value of the instance variable 'interaction'."
   interaction := anObject
%

category: 'signaling'
method: GsInteractionRequest
response: anObject
  self resume: anObject
%

! Class implementation for 'RwAdoptAuditErrorNotification'

!		Class methods for 'RwAdoptAuditErrorNotification'

category: 'instance creation'
classmethod: RwAdoptAuditErrorNotification
classNamed: className isClassExtension: classExtension  intoPackageNamed: packageName

	^ self new
		className: className;
		isClassExtension: classExtension;
		packageName: packageName;
		yourself
%

!		Instance methods for 'RwAdoptAuditErrorNotification'

category: 'Handling'
method: RwAdoptAuditErrorNotification
defaultAction
 
	^ Error signal: self _errorMessage
%

category: 'accessing'
method: RwAdoptAuditErrorNotification
description

	^ description ifNil: [ '' ]
%

category: 'accessing'
method: RwAdoptAuditErrorNotification
description: aString

	description := aString
%

category: 'Handling'
method: RwAdoptAuditErrorNotification
methodErrorDo: methodBlock classErrorDo: classBlock traitErrorDo: traitBlock
	"helper method for use in exception handling block ... avoid isKindOf:"

	self subclassResponsibility: #methodErrorDo:classErrorDo:traitErrorDo:
%

category: 'accessing'
method: RwAdoptAuditErrorNotification
packageName

	^ packageName
%

category: 'accessing'
method: RwAdoptAuditErrorNotification
packageName: aString

	packageName := aString
%

category: 'accessing'
method: RwAdoptAuditErrorNotification
reason
	^reason
%

category: 'accessing'
method: RwAdoptAuditErrorNotification
reason: object
	reason := object
%

category: 'private'
method: RwAdoptAuditErrorNotification
_errorMessage

	self subclassResponsibility: #_errorMessage
%

! Class implementation for 'RwAdoptAuditClassErrorNotification'

!		Instance methods for 'RwAdoptAuditClassErrorNotification'

category: 'accessing'
method: RwAdoptAuditClassErrorNotification
className
	^className
%

category: 'accessing'
method: RwAdoptAuditClassErrorNotification
className: object
	className := object
%

category: 'accessing'
method: RwAdoptAuditClassErrorNotification
isClassExtension
	^isClassExtension
%

category: 'accessing'
method: RwAdoptAuditClassErrorNotification
isClassExtension: object
	isClassExtension := object
%

category: 'Handling'
method: RwAdoptAuditClassErrorNotification
methodErrorDo: methodBlock classErrorDo: classBlock traitErrorDo: traitBlock
	"helper method for use in exception handling block ... avoid isKindOf:"

	classBlock value
%

! Class implementation for 'RwAdoptClassCategoryPackageConventionViolationErrorNotification'

!		Class methods for 'RwAdoptClassCategoryPackageConventionViolationErrorNotification'

category: 'instance creation'
classmethod: RwAdoptClassCategoryPackageConventionViolationErrorNotification
classNamed: className classCategory: aClassCategory packageConvention: packageConvention intoPackageNamed: packageName
	^ self new
		className: className;
		category: aClassCategory;
		packageConvention: packageConvention;
		packageName: packageName;
		yourself
%

!		Instance methods for 'RwAdoptClassCategoryPackageConventionViolationErrorNotification'

category: 'accessing'
method: RwAdoptClassCategoryPackageConventionViolationErrorNotification
category
	^category
%

category: 'accessing'
method: RwAdoptClassCategoryPackageConventionViolationErrorNotification
category: object
	category := object
%

category: 'accessing'
method: RwAdoptClassCategoryPackageConventionViolationErrorNotification
packageConvention
	^packageConvention
%

category: 'accessing'
method: RwAdoptClassCategoryPackageConventionViolationErrorNotification
packageConvention: object
	packageConvention := object
%

category: 'private'
method: RwAdoptClassCategoryPackageConventionViolationErrorNotification
_errorMessage

	^ 'Unable to adopt the class ', self className printString, ' into the package ', self packageName printString, ' as it''s class category ', self category printString, ' violates the ', self packageConvention, ' package convention .'
%

! Class implementation for 'RwAdoptMissingClassErrorNotification'

!		Instance methods for 'RwAdoptMissingClassErrorNotification'

category: 'private'
method: RwAdoptMissingClassErrorNotification
_errorMessage

	| extensionMessage |
	extensionMessage := self isClassExtension
		ifTrue: [ ' extension ' ]
		ifFalse: [ ' ' ].
	^ 'Unable to adopt the class ', self className printString, ' into the', extensionMessage, 'package ', self packageName printString, ' as it is not present in the current user''s symbol list.'
%

! Class implementation for 'RwAdoptAuditMethodErrorNotification'

!		Class methods for 'RwAdoptAuditMethodErrorNotification'

category: 'instance creation'
classmethod: RwAdoptAuditMethodErrorNotification
method: methodSelector isMeta: isMeta inClassNamed: className isClassExtension: classExtension intoPackageNamed: packageName
	^ (self
		classNamed: className
		isClassExtension: classExtension
		intoPackageNamed: packageName)
		selector: methodSelector;
		isMetaclass: isMeta;
		yourself
%

category: 'instance creation'
classmethod: RwAdoptAuditMethodErrorNotification
method: methodSelector isMeta: isMeta inTraitNamed: traitName intoPackageNamed: packageName
	^ (self
		classNamed: traitName
		isClassExtension: false
		intoPackageNamed: packageName)
		isTrait: true;
		selector: methodSelector;
		isMetaclass: isMeta;
		yourself
%

!		Instance methods for 'RwAdoptAuditMethodErrorNotification'

category: 'accessing'
method: RwAdoptAuditMethodErrorNotification
className
	^className
%

category: 'accessing'
method: RwAdoptAuditMethodErrorNotification
className: object
	className := object
%

category: 'accessing'
method: RwAdoptAuditMethodErrorNotification
isClassExtension
	^isClassExtension
%

category: 'accessing'
method: RwAdoptAuditMethodErrorNotification
isClassExtension: object
	isClassExtension := object
%

category: 'accessing'
method: RwAdoptAuditMethodErrorNotification
isMetaclass

	^ isMetaclass
%

category: 'accessing'
method: RwAdoptAuditMethodErrorNotification
isMetaclass: aBoolean

	isMetaclass := aBoolean
%

category: 'accessing'
method: RwAdoptAuditMethodErrorNotification
isTrait
	^ isTrait ifNil: [ ^ false ]
%

category: 'accessing'
method: RwAdoptAuditMethodErrorNotification
isTrait: object
	isTrait := object
%

category: 'Handling'
method: RwAdoptAuditMethodErrorNotification
methodErrorDo: methodBlock classErrorDo: classBlock traitErrorDo: traitBlock
	"helper method for use in exception handling block ... avoid isKindOf:"

	self isTrait
		ifTrue: [ traitBlock value ]
		ifFalse: [ methodBlock value ]
%

category: 'accessing'
method: RwAdoptAuditMethodErrorNotification
methodPrintString

	^ self 
		className, 
		(self isMetaclass ifTrue: [ ' class >> ' ] ifFalse: [ ' >> ' ]),
		self selector
%

category: 'accessing'
method: RwAdoptAuditMethodErrorNotification
selector

	^ selector
%

category: 'accessing'
method: RwAdoptAuditMethodErrorNotification
selector: aString

	selector := aString
%

! Class implementation for 'RwAdoptMissingMethodErrorNotification'

!		Instance methods for 'RwAdoptMissingMethodErrorNotification'

category: 'private'
method: RwAdoptMissingMethodErrorNotification
_errorMessage
	| extensionMessage metaClassMessage typeMessage |
	metaClassMessage := self isMetaclass
		ifTrue: [ ' class << #' ]
		ifFalse: [ '  << #' ].
	extensionMessage := self isClassExtension
		ifTrue: [ ' extension ' ]
		ifFalse: [ ' ' ].
	typeMessage := self isTrait
		ifTrue: [ 'trait''s' ]
		ifFalse: [ 'class''s' ].
	^ 'Unable to adopt the method ' , self className , metaClassMessage
		, self selector asString , ' into the package ' , self packageName printString
		, '. The method is not present in the ' , typeMessage , ' method dictionary.'
%

! Class implementation for 'RwAuditMethodErrorNotification'

!		Instance methods for 'RwAuditMethodErrorNotification'

category: 'Handling'
method: RwAuditMethodErrorNotification
defaultAction
	"record audit error"

	^ true
%

category: 'private'
method: RwAuditMethodErrorNotification
_errorMessage
	| extensionMessage metaClassMessage typeMessage |
	metaClassMessage := self isMetaclass
		ifTrue: [ ' class << #' ]
		ifFalse: [ '  << #' ].
	extensionMessage := self isClassExtension
		ifTrue: [ ' extension ' ]
		ifFalse: [ ' ' ].
	typeMessage := self isTrait
		ifTrue: [ 'trait''s' ]
		ifFalse: [ 'class''s' ].
	^ self className , metaClassMessage , self selector asString
		, ' in the package ' , self packageName printString
		, ' is not present in the ' , typeMessage , ' method dictionary.'
%

! Class implementation for 'RwAdoptAuditTraitErrorNotification'

!		Class methods for 'RwAdoptAuditTraitErrorNotification'

category: 'instance creation'
classmethod: RwAdoptAuditTraitErrorNotification
traitNamed: traitName intoPackageNamed: packageName

	^ self new
		traitName: traitName;
		packageName: packageName;
		yourself
%

!		Instance methods for 'RwAdoptAuditTraitErrorNotification'

category: 'Handling'
method: RwAdoptAuditTraitErrorNotification
methodErrorDo: methodBlock classErrorDo: classBlock traitErrorDo: traitBlock
	"helper method for use in exception handling block ... avoid isKindOf:"

	traitBlock value
%

category: 'accessing'
method: RwAdoptAuditTraitErrorNotification
traitName
	^traitName
%

category: 'accessing'
method: RwAdoptAuditTraitErrorNotification
traitName: object
	traitName := object
%

! Class implementation for 'RwAdoptMissingTraitErrorNotification'

!		Instance methods for 'RwAdoptMissingTraitErrorNotification'

category: 'private'
method: RwAdoptMissingTraitErrorNotification
_errorMessage

	^ 'Unable to adopt the trait ', self traitName printString, ' into the package ', self packageName printString, ' as it is not present in the current user''s symbol list.'
%

! Class implementation for 'RwAdoptTraitCategoryPackageConventionViolationErrorNotification'

!		Class methods for 'RwAdoptTraitCategoryPackageConventionViolationErrorNotification'

category: 'instance creation'
classmethod: RwAdoptTraitCategoryPackageConventionViolationErrorNotification
traitNamed: traitName traitCategory: aTraitCategory packageConvention: packageConvention intoPackageNamed: packageName
	^ self new
		traitName: traitName;
		category: aTraitCategory;
		packageConvention: packageConvention;
		packageName: packageName;
		yourself
%

!		Instance methods for 'RwAdoptTraitCategoryPackageConventionViolationErrorNotification'

category: 'accessing'
method: RwAdoptTraitCategoryPackageConventionViolationErrorNotification
category
	^category
%

category: 'accessing'
method: RwAdoptTraitCategoryPackageConventionViolationErrorNotification
category: object
	category := object
%

category: 'accessing'
method: RwAdoptTraitCategoryPackageConventionViolationErrorNotification
packageConvention
	^packageConvention
%

category: 'accessing'
method: RwAdoptTraitCategoryPackageConventionViolationErrorNotification
packageConvention: object
	packageConvention := object
%

category: 'private'
method: RwAdoptTraitCategoryPackageConventionViolationErrorNotification
_errorMessage

	^ 'Unable to adopt the trait ', self traitName printString, ' into the package ', self packageName printString, ' as it''s class category ', self category printString, ' violates the ', self packageConvention, ' package convention .'
%

! Class implementation for 'RwAllowChangeRepositoryRevisionOnResolveNotification'

!		Class methods for 'RwAllowChangeRepositoryRevisionOnResolveNotification'

category: 'Instance creation'
classmethod: RwAllowChangeRepositoryRevisionOnResolveNotification
signal: aRwProjectLoadSpecificationV2
	"An exception of the type associated with the receiver is signaled."

	^ self new
		loadSpecification: aRwProjectLoadSpecificationV2;
		signal
%

!		Instance methods for 'RwAllowChangeRepositoryRevisionOnResolveNotification'

category: 'Handling'
method: RwAllowChangeRepositoryRevisionOnResolveNotification
defaultAction
	"By default don't allow revisions to be changed when resolving a load specification"

	^ false
%

category: 'accessing'
method: RwAllowChangeRepositoryRevisionOnResolveNotification
loadSpecification
	^loadSpecification
%

category: 'accessing'
method: RwAllowChangeRepositoryRevisionOnResolveNotification
loadSpecification: object
	loadSpecification := object
%

! Class implementation for 'RwAuditTraitErrorNotification'

!		Class methods for 'RwAuditTraitErrorNotification'

category: 'creation'
classmethod: RwAuditTraitErrorNotification
traitNamed: traitName intoPackageNamed: packageName
	^ self new
		traitName: traitName;
		packageName: packageName;
		yourself
%

!		Instance methods for 'RwAuditTraitErrorNotification'

category: 'Handling'
method: RwAuditTraitErrorNotification
defaultAction
 
	^ Error signal: self _errorMessage
%

category: 'accessing'
method: RwAuditTraitErrorNotification
description

	^ description ifNil: [ '' ]
%

category: 'accessing'
method: RwAuditTraitErrorNotification
description: aString

	description := aString
%

category: 'Handling'
method: RwAuditTraitErrorNotification
methodErrorDo: methodBlock traitErrorDo: traitBlock
	"helper method for use in exception handling block ... avoid isKindOf:"

	self subclassResponsibility: #methodErrorDo:traitErrorDo:
%

category: 'accessing'
method: RwAuditTraitErrorNotification
packageName
	^packageName
%

category: 'accessing'
method: RwAuditTraitErrorNotification
packageName: object
	packageName := object
%

category: 'accessing'
method: RwAuditTraitErrorNotification
reason
	^reason
%

category: 'accessing'
method: RwAuditTraitErrorNotification
reason: object
	reason := object
%

category: 'accessing'
method: RwAuditTraitErrorNotification
traitName
	^traitName
%

category: 'accessing'
method: RwAuditTraitErrorNotification
traitName: object
	traitName := object
%

category: 'private'
method: RwAuditTraitErrorNotification
_errorMessage

	self subclassResponsibility: #_errorMessage
%

! Class implementation for 'RwAuditTraitMethodErrorNotification'

!		Class methods for 'RwAuditTraitMethodErrorNotification'

category: 'creation'
classmethod: RwAuditTraitMethodErrorNotification
method: methodSelector isMeta: isMeta inTraitNamed: traitName intoPackageNamed: packageName
	^ (self traitNamed: traitName intoPackageNamed: packageName)
		selector: methodSelector;
		isMetaclass: isMeta;
		yourself
%

!		Instance methods for 'RwAuditTraitMethodErrorNotification'

category: 'Handling'
method: RwAuditTraitMethodErrorNotification
defaultAction
	"record audit error"
	^ true
%

category: 'accessing'
method: RwAuditTraitMethodErrorNotification
isMetaclass
	^isMetaclass
%

category: 'accessing'
method: RwAuditTraitMethodErrorNotification
isMetaclass: object
	isMetaclass := object
%

category: 'Handling'
method: RwAuditTraitMethodErrorNotification
methodErrorDo: methodBlock traitErrorDo: traitBlock
	"helper method for use in exception handling block ... avoid isKindOf:"

	methodBlock value
%

category: 'accessing'
method: RwAuditTraitMethodErrorNotification
methodPrintString

	^ self 
		traitName, 
		(self isMetaclass ifTrue: [ ' classTrait >> ' ] ifFalse: [ ' >> ' ]),
		self selector
%

category: 'accessing'
method: RwAuditTraitMethodErrorNotification
selector
	^selector
%

category: 'accessing'
method: RwAuditTraitMethodErrorNotification
selector: object
	selector := object
%

category: 'private'
method: RwAuditTraitMethodErrorNotification
_errorMessage
	^ 'The trait named ' , self traitName , ' is missing it''s loaded method for '
		, self methodPrintString
%

! Class implementation for 'RwCompileErrorCompilingMethodsForNewClassVersionNotification'

!		Instance methods for 'RwCompileErrorCompilingMethodsForNewClassVersionNotification'

category: 'accessing'
method: RwCompileErrorCompilingMethodsForNewClassVersionNotification
compileError
	^compileError
%

category: 'accessing'
method: RwCompileErrorCompilingMethodsForNewClassVersionNotification
compileError: object
	compileError := object
%

category: 'Handling'
method: RwCompileErrorCompilingMethodsForNewClassVersionNotification
defaultAction
 	"resume exception with true, to indicate that the method will be manually added with corrections after the load is completed"
	"do not handle or resume exception with false, to pass the compile error on up the stack"
	
	^self compileError pass
%

! Class implementation for 'RwDeleteClassFromSystemNotification'

!		Instance methods for 'RwDeleteClassFromSystemNotification'

category: 'accessing'
method: RwDeleteClassFromSystemNotification
candidateClass
	"class to be deleted from system, if receiver is #resumed: with true"

	^ candidateClass
%

category: 'accessing'
method: RwDeleteClassFromSystemNotification
candidateClass: aClassToBeDeleted

	candidateClass := aClassToBeDeleted
%

category: 'handling'
method: RwDeleteClassFromSystemNotification
defaultAction
	"delete class from system"

	^ true
%

! Class implementation for 'RwExecuteClassInitializeMethodsAfterLoadNotification'

!		Instance methods for 'RwExecuteClassInitializeMethodsAfterLoadNotification'

category: 'accessing'
method: RwExecuteClassInitializeMethodsAfterLoadNotification
candidateClass
	"class to which #initialize if receiver is #resumed: with true"

	^ candidateClass
%

category: 'accessing'
method: RwExecuteClassInitializeMethodsAfterLoadNotification
candidateClass: aClassToInitialize

	candidateClass := aClassToInitialize
%

category: 'handling'
method: RwExecuteClassInitializeMethodsAfterLoadNotification
defaultAction
	"perform class initialization"

	^ true
%

! Class implementation for 'RwExistingAssociationWithSameKeyNotification'

!		Instance methods for 'RwExistingAssociationWithSameKeyNotification'

category: 'handling'
method: RwExistingAssociationWithSameKeyNotification
defaultAction

	self error: self errorMessage
%

category: 'accessing'
method: RwExistingAssociationWithSameKeyNotification
errorMessage

   ^errorMessage
%

category: 'accessing'
method: RwExistingAssociationWithSameKeyNotification
errorMessage: anObject

   errorMessage := anObject
%

! Class implementation for 'RwExistingVisitorAddingExistingClassNotification'

!		Instance methods for 'RwExistingVisitorAddingExistingClassNotification'

category: 'accessing'
method: RwExistingVisitorAddingExistingClassNotification
classDefinition

	^ classDefinition
%

category: 'accessing'
method: RwExistingVisitorAddingExistingClassNotification
classDefinition: aClassDefinition

	classDefinition := aClassDefinition
%

category: 'handling'
method: RwExistingVisitorAddingExistingClassNotification
defaultAction

	loadedProject ifNil: [ ^ self error: 'Visitor adding a class ', classDefinition name printString, ' that already exists' ].
	self error: 
		'Visitor adding a class ', 
		classDefinition name printString, 
		' that already exists in the project ', 
		loadedProject name printString, 
		', but the project was not included in the load'
%

category: 'accessing'
method: RwExistingVisitorAddingExistingClassNotification
incomingPackage
	^incomingPackage
%

category: 'accessing'
method: RwExistingVisitorAddingExistingClassNotification
incomingPackage: object
	incomingPackage := object
%

category: 'accessing'
method: RwExistingVisitorAddingExistingClassNotification
incomingProject
	^incomingProject
%

category: 'accessing'
method: RwExistingVisitorAddingExistingClassNotification
incomingProject: object
	incomingProject := object
%

category: 'accessing'
method: RwExistingVisitorAddingExistingClassNotification
loadedClass
	^loadedClass
%

category: 'accessing'
method: RwExistingVisitorAddingExistingClassNotification
loadedClass: object
	loadedClass := object
%

category: 'accessing'
method: RwExistingVisitorAddingExistingClassNotification
loadedPackage
	^ loadedClass loadedPackage
%

category: 'accessing'
method: RwExistingVisitorAddingExistingClassNotification
loadedProject

	^ loadedProject
%

category: 'accessing'
method: RwExistingVisitorAddingExistingClassNotification
loadedProject: aLoadedProject

	loadedProject := aLoadedProject
%

category: 'accessing'
method: RwExistingVisitorAddingExistingClassNotification
theClass
	^theClass
%

category: 'accessing'
method: RwExistingVisitorAddingExistingClassNotification
theClass: object
	theClass := object
%

! Class implementation for 'RwExistingVisitorAddingExistingMethodNotification'

!		Instance methods for 'RwExistingVisitorAddingExistingMethodNotification'

category: 'handling'
method: RwExistingVisitorAddingExistingMethodNotification
defaultAction

	self error: 
		'Visitor adding a method ', 
		methodDefinition name printString, 
		' that already exists in the project ', 
		self loadedProject name printString, 
		', but the project was not included in the load'
%

category: 'accessing'
method: RwExistingVisitorAddingExistingMethodNotification
incomingPackage
	^incomingPackage
%

category: 'accessing'
method: RwExistingVisitorAddingExistingMethodNotification
incomingPackage: aPackageDefinition
	incomingPackage := aPackageDefinition
%

category: 'accessing'
method: RwExistingVisitorAddingExistingMethodNotification
incomingProject
	^incomingProject
%

category: 'accessing'
method: RwExistingVisitorAddingExistingMethodNotification
incomingProject: aProjectDefinition
	incomingProject := aProjectDefinition
%

category: 'accessing'
method: RwExistingVisitorAddingExistingMethodNotification
loadedMethod
	^loadedMethod
%

category: 'accessing'
method: RwExistingVisitorAddingExistingMethodNotification
loadedMethod: object
	loadedMethod := object
%

category: 'accessing'
method: RwExistingVisitorAddingExistingMethodNotification
loadedPackage
	^ loadedMethod loadedPackage
%

category: 'accessing'
method: RwExistingVisitorAddingExistingMethodNotification
loadedProject
	^ loadedMethod loadedProject
%

category: 'accessing'
method: RwExistingVisitorAddingExistingMethodNotification
methodDefinition
	^methodDefinition
%

category: 'accessing'
method: RwExistingVisitorAddingExistingMethodNotification
methodDefinition: object
	methodDefinition := object
%

category: 'accessing'
method: RwExistingVisitorAddingExistingMethodNotification
theClass
	^ self loadedMethod handle inClass
%

! Class implementation for 'RwExistingVisitorChangingPackageOwnershipNotification'

!		Instance methods for 'RwExistingVisitorChangingPackageOwnershipNotification'

category: 'handling'
method: RwExistingVisitorChangingPackageOwnershipNotification
defaultAction
	"move defintion to incoming project/package"

	^ true
%

category: 'accessing'
method: RwExistingVisitorChangingPackageOwnershipNotification
incomingPackage
	^incomingPackage
%

category: 'accessing'
method: RwExistingVisitorChangingPackageOwnershipNotification
incomingPackage: object
	incomingPackage := object
%

category: 'accessing'
method: RwExistingVisitorChangingPackageOwnershipNotification
incomingProject
	^incomingProject
%

category: 'accessing'
method: RwExistingVisitorChangingPackageOwnershipNotification
incomingProject: object
	incomingProject := object
%

category: 'accessing'
method: RwExistingVisitorChangingPackageOwnershipNotification
loadedClassOrMethodDefinition
	^loadedClassOrMethodDefinition
%

category: 'accessing'
method: RwExistingVisitorChangingPackageOwnershipNotification
loadedClassOrMethodDefinition: object
	loadedClassOrMethodDefinition := object
%

category: 'accessing'
method: RwExistingVisitorChangingPackageOwnershipNotification
loadedPackage
	^self loadedClassOrMethodDefinition loadedPackage
%

category: 'accessing'
method: RwExistingVisitorChangingPackageOwnershipNotification
loadedProject
	^self loadedClassOrMethodDefinition loadedProject
%

! Class implementation for 'RwInvalidCategoryProtocolConventionErrorNotification'

!		Instance methods for 'RwInvalidCategoryProtocolConventionErrorNotification'

category: 'Handling'
method: RwInvalidCategoryProtocolConventionErrorNotification
classCategoryNotificationDo: classCategoryBlock nonExtensionMethodNoficationDo: nonExtensionMethodBlock extensionMethodPackageMismatchNoficationDo: extensionMethodPackageMismatchBlock  extensionMethodNonExtensionProtocolNoficationDo: extensionMethodNonExtensionProtocolBlock
	"helper method for use in exception handling block ... avoid isKindOf:"

	
	self subclassResponsibility: #classCategoryNotificationDo:nonExtensionMethodNoficationDo:extensionMethodPackageMismatchNoficationDo:extensionMethodNonExtensionProtocolNoficationDo:
%

category: 'Handling'
method: RwInvalidCategoryProtocolConventionErrorNotification
defaultAction
 
	^ Error signal: self _errorMessage
%

category: 'accessing'
method: RwInvalidCategoryProtocolConventionErrorNotification
packageConvention

	^ packageConvention
%

category: 'accessing'
method: RwInvalidCategoryProtocolConventionErrorNotification
packageConvention: aString

	packageConvention := aString
%

category: 'accessing'
method: RwInvalidCategoryProtocolConventionErrorNotification
packageName

	^ packageName
%

category: 'accessing'
method: RwInvalidCategoryProtocolConventionErrorNotification
packageName: aString

	packageName := aString
%

category: 'private'
method: RwInvalidCategoryProtocolConventionErrorNotification
_errorMessage

	^ self subclassResponsibility: #_errorMessage
%

! Class implementation for 'RwInvalidClassCategoryConventionErrorNotification'

!		Class methods for 'RwInvalidClassCategoryConventionErrorNotification'

category: 'instance creation'
classmethod: RwInvalidClassCategoryConventionErrorNotification
signalWithClassDefinition: aClassDefinition packageName: packageName packageConvention: aString

	^ self new
			classDefinition: aClassDefinition;
			packageName:  packageName;
			packageConvention: aString;
			signal
%

!		Instance methods for 'RwInvalidClassCategoryConventionErrorNotification'

category: 'Handling'
method: RwInvalidClassCategoryConventionErrorNotification
classCategoryNotificationDo: classCategoryBlock nonExtensionMethodNoficationDo: nonExtensionMethodBlock extensionMethodPackageMismatchNoficationDo: extensionMethodPackageMismatchBlock  extensionMethodNonExtensionProtocolNoficationDo: extensionMethodNonExtensionProtocolBlock
	"class category does not match the package name"

	classCategoryBlock value
%

category: 'accessing'
method: RwInvalidClassCategoryConventionErrorNotification
classDefinition

	^ classDefinition
%

category: 'accessing'
method: RwInvalidClassCategoryConventionErrorNotification
classDefinition: aClassDefinition

	classDefinition := aClassDefinition
%

category: 'private'
method: RwInvalidClassCategoryConventionErrorNotification
_errorMessage

	^ 'The class category ', 
		self classDefinition category printString, 
		' for the class ', 
		self classDefinition name printString, 
		' violates the package convention ', 
		self packageConvention printString
%

! Class implementation for 'RwInvalidMethodProtocolConventionErrorNotification'

!		Class methods for 'RwInvalidMethodProtocolConventionErrorNotification'

category: 'instance creation'
classmethod: RwInvalidMethodProtocolConventionErrorNotification
signalWithMethodDefinition: aMethodDefinition className: className isMeta: isMeta packageName:  packageName packageConvention: aString

	^ self new
			methodDefinition: aMethodDefinition;
			className: className;
			isMeta: isMeta;
			packageName:  packageName;
			packageConvention: aString;
			signal
%

!		Instance methods for 'RwInvalidMethodProtocolConventionErrorNotification'

category: 'accessing'
method: RwInvalidMethodProtocolConventionErrorNotification
className

	^ className
%

category: 'accessing'
method: RwInvalidMethodProtocolConventionErrorNotification
className: aString

	className := aString
%

category: 'Handling'
method: RwInvalidMethodProtocolConventionErrorNotification
defaultAction
 
	^ Error signal: self _errorMessage
%

category: 'accessing'
method: RwInvalidMethodProtocolConventionErrorNotification
isMeta

	^ isMeta
%

category: 'accessing'
method: RwInvalidMethodProtocolConventionErrorNotification
isMeta: aBool

	isMeta := aBool
%

category: 'accessing'
method: RwInvalidMethodProtocolConventionErrorNotification
methodDefinition

	^ methodDefinition
%

category: 'accessing'
method: RwInvalidMethodProtocolConventionErrorNotification
methodDefinition: aMethodDef

	methodDefinition := aMethodDef
%

category: 'private'
method: RwInvalidMethodProtocolConventionErrorNotification
_errorMessage

	^ 'The method protocol ', 
		self methodDefinition protocol printString, 
		' for the method ', 
		self _methodPrintString printString, 
		' in the package ', 
		self packageName printString,
		' violates the package convention ', 
		self packageConvention printString, 
		'. '
%

category: 'private'
method: RwInvalidMethodProtocolConventionErrorNotification
_methodPrintString

	^ self className, (self isMeta ifTrue: [ ' class>>' ] ifFalse: [ '>>' ]), self methodDefinition selector
%

! Class implementation for 'RwExtensionProtocolExtensionMethodPackageMismatchErrorNotification'

!		Instance methods for 'RwExtensionProtocolExtensionMethodPackageMismatchErrorNotification'

category: 'Handling'
method: RwExtensionProtocolExtensionMethodPackageMismatchErrorNotification
classCategoryNotificationDo: classCategoryBlock nonExtensionMethodNoficationDo: nonExtensionMethodBlock extensionMethodPackageMismatchNoficationDo: extensionMethodPackageMismatchBlock  extensionMethodNonExtensionProtocolNoficationDo: extensionMethodNonExtensionProtocolBlock
	"extension method protocol does start with a *, but does not match the package name"

	extensionMethodPackageMismatchBlock value
%

category: 'private'
method: RwExtensionProtocolExtensionMethodPackageMismatchErrorNotification
_errorMessage

	^ super _errorMessage, 'The extension protocol does not match the package of the extension method.'
%

! Class implementation for 'RwExtensionProtocolNonExtensionMethodErrorNotification'

!		Instance methods for 'RwExtensionProtocolNonExtensionMethodErrorNotification'

category: 'Handling'
method: RwExtensionProtocolNonExtensionMethodErrorNotification
classCategoryNotificationDo: classCategoryBlock nonExtensionMethodNoficationDo: nonExtensionMethodBlock extensionMethodPackageMismatchNoficationDo: extensionMethodPackageMismatchBlock  extensionMethodNonExtensionProtocolNoficationDo: extensionMethodNonExtensionProtocolBlock
	"method protocol starts with a * for non-extension method"

	nonExtensionMethodBlock value
%

category: 'private'
method: RwExtensionProtocolNonExtensionMethodErrorNotification
_errorMessage

	^ super _errorMessage, 'The protocol should not start with a *, as the method is NOT an extension method.'
%

! Class implementation for 'RwNonExtensionProtocolExtensionMethodErrorNotification'

!		Instance methods for 'RwNonExtensionProtocolExtensionMethodErrorNotification'

category: 'Handling'
method: RwNonExtensionProtocolExtensionMethodErrorNotification
classCategoryNotificationDo: classCategoryBlock nonExtensionMethodNoficationDo: nonExtensionMethodBlock extensionMethodPackageMismatchNoficationDo: extensionMethodPackageMismatchBlock  extensionMethodNonExtensionProtocolNoficationDo: extensionMethodNonExtensionProtocolBlock
	"extension method protocol doesn't start with a *"

	extensionMethodNonExtensionProtocolBlock value
%

category: 'private'
method: RwNonExtensionProtocolExtensionMethodErrorNotification
_errorMessage

	^ super _errorMessage, 'The protocol should start with a *, as the method IS an extension method.'
%

! Class implementation for 'RwPerformingUnpackagedEditNotification'

!		Instance methods for 'RwPerformingUnpackagedEditNotification'

category: 'handling'
method: RwPerformingUnpackagedEditNotification
defaultAction

	^ self error: self errorMessage
%

category: 'accessing'
method: RwPerformingUnpackagedEditNotification
errorMessage

   ^self informMessage
%

category: 'accessing'
method: RwPerformingUnpackagedEditNotification
informMessage

   ^informMessage
%

category: 'accessing'
method: RwPerformingUnpackagedEditNotification
informMessage: anObject

   informMessage := anObject
%

category: 'signalling'
method: RwPerformingUnpackagedEditNotification
signal: aMessage

	self informMessage: aMessage.
	^ self signal
%

! Class implementation for 'RwUnreadPackagesErrorNotification'

!		Instance methods for 'RwUnreadPackagesErrorNotification'

category: 'handling'
method: RwUnreadPackagesErrorNotification
defaultAction

	self error: self errorMessage
%

category: 'accessing'
method: RwUnreadPackagesErrorNotification
errorMessage

   ^errorMessage
%

category: 'accessing'
method: RwUnreadPackagesErrorNotification
errorMessage: anObject

   errorMessage := anObject
%

category: 'accessing'
method: RwUnreadPackagesErrorNotification
unreadPackageNames
	^unreadPackageNames
%

category: 'accessing'
method: RwUnreadPackagesErrorNotification
unreadPackageNames: object
	unreadPackageNames := object
%

! Class implementation for 'CypressAbstractPackageFiler'

!		Class methods for 'CypressAbstractPackageFiler'

category: 'instance creation'
classmethod: CypressAbstractPackageFiler
forRepository: aCypressFileSystemRepository

	^self new
		initializeForRepository: aCypressFileSystemRepository;
		yourself.
%

!		Instance methods for 'CypressAbstractPackageFiler'

category: 'private'
method: CypressAbstractPackageFiler
fileUtils

	^CypressFileUtilities current
%

category: 'initializing - private'
method: CypressAbstractPackageFiler
initializeForRepository: aCypressFileSystemRepository

	repository := aCypressFileSystemRepository
%

category: 'accessing'
method: CypressAbstractPackageFiler
packageDirectory

	^packageDirectory
%

category: 'accessing'
method: CypressAbstractPackageFiler
packageDirectory: aDirectory

	packageDirectory := aDirectory
%

category: 'accessing'
method: CypressAbstractPackageFiler
packageStructure

	^packageStructure
%

category: 'accessing'
method: CypressAbstractPackageFiler
packageStructure: aPackageStructure

	packageStructure := aPackageStructure
%

category: 'accessing'
method: CypressAbstractPackageFiler
propertiesFileNameExtension

	^'.ston'
%

category: 'accessing'
method: CypressAbstractPackageFiler
propertiesFileNameExtensions

	^Array with: self propertiesFileNameExtension
%

category: 'accessing'
method: CypressAbstractPackageFiler
repository

	^repository
%

category: 'private'
method: CypressAbstractPackageFiler
string: aString endsWith: subString
	"Answer whether the last characters of aString are the same as subString."

	| expectedStart |
	expectedStart := aString size - subString size + 1 max: 1.
	^expectedStart
		= (aString indexOfSubCollection: subString startingAt: expectedStart)
%

! Class implementation for 'CypressAbstractFileoutWriter'

!		Instance methods for 'CypressAbstractFileoutWriter'

category: 'accessing'
method: CypressAbstractFileoutWriter
classesInDependencyOrder

	^(CypressGsGeneralDependencySorter
		on: self packageStructure classes
		dependsOn: [:candidate | candidate superclassName]
		dependent: [:candidate | candidate className]) inOrder
%

category: 'accessing'
method: CypressAbstractFileoutWriter
classesWithInitializers

	^self classesInDependencyOrder
		select: [:each | each classMethods anySatisfy: [:method | method selector = 'initialize']]
%

category: 'private'
method: CypressAbstractFileoutWriter
determinePackageDirectory

	^self fileUtils ensureDirectoryExists: self repository directoryPath
%

category: 'accessing'
method: CypressAbstractFileoutWriter
extensions

	^self packageStructure extensions
%

category: 'writing - private'
method: CypressAbstractFileoutWriter
fileOut: aString implementationsFrom: someClassStructures on: aStream

	someClassStructures
		do: [:each | self fileOutType: aString implementationOf: each on: aStream]
%

category: 'writing - private'
method: CypressAbstractFileoutWriter
fileOut: aString methods: someMethodStructures on: aStream

	someMethodStructures isEmpty ifTrue: [^self].
	self
		fileOut: aString methodsPreambleFor: someMethodStructures any classStructure on: aStream;
		fileOutMethods: someMethodStructures on: aStream
%

category: 'writing - private'
method: CypressAbstractFileoutWriter
fileOutClassDeclarationsOn: aStream

	self classesInDependencyOrder
		do: [:classStructure | self fileOutClassDeclaration: classStructure on: aStream]
%

category: 'writing - private'
method: CypressAbstractFileoutWriter
fileOutClassesOn: aStream

	self
		fileOutClassesPreambleOn: aStream;
		fileOutClassDeclarationsOn: aStream;
		fileOutClassImplementationsOn: aStream
%

category: 'writing - private'
method: CypressAbstractFileoutWriter
fileOutClassImplementationsOn: aStream

	self
		fileOut: 'Class Implementation'
		implementationsFrom: self classesInDependencyOrder
		on: aStream
%

category: 'writing - private'
method: CypressAbstractFileoutWriter
fileOutClassInitializersOn: aStream

	self fileOutClassInitializersPreambleOn: aStream.
	self classesWithInitializers do: [:each | self fileOutClassInitializerFor: each on: aStream].
	self fileOutClassInitializersPostambleOn: aStream.
%

category: 'writing - private'
method: CypressAbstractFileoutWriter
fileOutExtensionImplementationsOn: aStream
  | sortedExtensions |
  sortedExtensions := self extensions
    asSortedCollection: [ :a :b | a className <= b className ].
  self
    fileOut: 'Class Extension'
    implementationsFrom: sortedExtensions
    on: aStream
%

category: 'writing - private'
method: CypressAbstractFileoutWriter
fileOutExtensionsOn: aStream

	self
		fileOutExtensionsPreambleOn: aStream;
		fileOutExtensionImplementationsOn: aStream
%

category: 'writing - private'
method: CypressAbstractFileoutWriter
fileOutMethods: someMethodStructures on: aStream

	(someMethodStructures
		asSortedCollection: [:a :b | a selector <= b selector])
			do: [:methodStructure | self fileOutMethod: methodStructure on: aStream]
%

category: 'writing - private'
method: CypressAbstractFileoutWriter
fileOutPackageOn: aStream

	self
		fileOutPackagePreambleOn: aStream;
		fileOutClassesOn: aStream;
		fileOutExtensionsOn: aStream;
		fileOutClassInitializersOn: aStream;
		fileOutPackagePostambleOn: aStream
%

category: 'writing - private'
method: CypressAbstractFileoutWriter
fileOutType: aString implementationOf: classStructure on: aStream

	self
		fileOutPreambleType: aString
			for: classStructure
			on: aStream;
		fileOut: 'Class'
			methods: classStructure classMethods
			on: aStream;
		fileOut: 'Instance'
			methods: classStructure instanceMethods
			on: aStream
%

category: 'accessing'
method: CypressAbstractFileoutWriter
packageName

	^self packageStructure packageName
%

category: 'accessing'
method: CypressAbstractFileoutWriter
packageNameExtension

	^self subclassResponsibility: #packageNameExtension
%

category: 'writing'
method: CypressAbstractFileoutWriter
writePackageStructure

	CypressFileUtilities current
		writeStreamFor: self packageStructure packageName
				, self packageNameExtension
		in: self packageDirectory
		do: [:fileStream | self fileOutPackageOn: fileStream]
%

category: 'writing'
method: CypressAbstractFileoutWriter
writePackageStructure: aPackageStructure

	self
		packageStructure: aPackageStructure;
		packageDirectory: self determinePackageDirectory;
		writePackageStructure
%

! Class implementation for 'CypressSmalltalkFileoutWriter'

!		Instance methods for 'CypressSmalltalkFileoutWriter'

category: 'writing - private'
method: CypressSmalltalkFileoutWriter
fileOut: aString methodsPreambleFor: classStructure on: aStream

	self
		writeChunk: '" ------------------- ' , aString , ' methods for '
				, classStructure name , '"'
		on: aStream.
	aStream
		lf;
		lf
%

category: 'writing - private'
method: CypressSmalltalkFileoutWriter
fileOutClassDeclaration: classStructure on: aStream
	"This is the structure for VW/Pharo  class definitions. It may or may not be portable
	to all dialects that use chunk-format fileins. It does not attempt to handle VW
	namespaces at this time. Probably should use an XML fileout for that."

	aStream
		nextPutAll: classStructure superclassName;
		nextPutAll: ' subclass: #';
		nextPutAll: classStructure className;
		lf;
		nextPutAll: '	instanceVariableNames:  ''';
		nextPutAll: classStructure instanceVariablesString;
		nextPut: $';
		lf;
		nextPutAll: '	classVariableNames: ''';
		nextPutAll: classStructure classVariablesString;
		nextPut: $';
		lf;
		nextPutAll: '	poolDictionaries: ''';
		nextPutAll: classStructure poolDictionariesString;
		nextPut: $';
		lf;
		nextPutAll: '	category: ''';
		nextPutAll: classStructure category.
	self writeChunk: '''' on: aStream.
	aStream
		lf;
		lf;
		nextPutAll: classStructure className;
		nextPutAll: ' comment:';
		lf.
	self writeChunk: classStructure comment printString on: aStream.
	aStream
		lf;
		lf;
		nextPutAll: classStructure className;
		nextPutAll: ' class instanceVariableNames: ''';
		nextPutAll: classStructure classInstanceVariablesString.
	self writeChunk: '''' on: aStream.
	aStream
		lf;
		lf
%

category: 'writing - private'
method: CypressSmalltalkFileoutWriter
fileOutClassesPreambleOn: aStream

	self writeChunk: '" Class Declarations "' on: aStream.
	aStream
		lf;
		lf
%

category: 'writing - private'
method: CypressSmalltalkFileoutWriter
fileOutClassInitializerFor: classStructure on: aStream

	self writeChunk: classStructure className , ' initialize.' on: aStream.
	aStream lf
%

category: 'writing - private'
method: CypressSmalltalkFileoutWriter
fileOutClassInitializersPostambleOn: aStream

	aStream
		lf
%

category: 'writing - private'
method: CypressSmalltalkFileoutWriter
fileOutClassInitializersPreambleOn: aStream

	self writeChunk: '" Class initializers "' on: aStream.
	aStream
		lf;
		lf
%

category: 'writing - private'
method: CypressSmalltalkFileoutWriter
fileOutExtensionsPreambleOn: aStream

	self writeChunk: '" Class Extensions "' on: aStream.
	aStream
		lf;
		lf
%

category: 'writing - private'
method: CypressSmalltalkFileoutWriter
fileOutMethod: methodStructure on: aStream

	aStream nextPutAll: '!'.
	self
		writeChunk: methodStructure classStructure className
				, (methodStructure isMetaclass
						ifTrue: [' class methodsFor: ']
						ifFalse: [' methodsFor: '])
					, methodStructure category printString
		on: aStream.
	aStream lf.
	self
		writeChunk: methodStructure source on: aStream;
		writeChunk: ' ' on: aStream.
	aStream lf
%

category: 'writing - private'
method: CypressSmalltalkFileoutWriter
fileOutPackagePostambleOn: aStream

	aStream
		lf;
		lf.
	self writeChunk: '" End of Package: ' , self packageName , '"' on: aStream.
	aStream
		lf;
		lf;
		lf
%

category: 'writing - private'
method: CypressSmalltalkFileoutWriter
fileOutPackagePreambleOn: aStream

	self writeChunk: '" Package: ' , self packageName , '"' on: aStream.
	aStream
		lf;
		lf;
		lf
%

category: 'writing - private'
method: CypressSmalltalkFileoutWriter
fileOutPreambleType: aString for: classStructure on: aStream

	self writeChunk: '" ' , aString , ' for ' , classStructure name , '"'
		on: aStream.
	aStream
		lf;
		lf
%

category: 'accessing'
method: CypressSmalltalkFileoutWriter
packageNameExtension

	^'.st'
%

category: 'writing - private'
method: CypressSmalltalkFileoutWriter
writeChunk: aString on: aStream

	aString do: 
			[:each |
			aStream nextPut: each.
			each = $! ifTrue: [aStream nextPut: each]].
	aStream nextPut: $!
%

! Class implementation for 'CypressTopazFileoutWriter'

!		Instance methods for 'CypressTopazFileoutWriter'

category: 'writing - private'
method: CypressTopazFileoutWriter
fileOut: aString methodsPreambleFor: classStructure on: aStream

	aStream
		nextPutAll: '! ------------------- ', aString, ' methods for ', classStructure name; lf;
		lf
%

category: 'writing - private'
method: CypressTopazFileoutWriter
fileOutClassDeclaration: classStructure on: aStream
  aStream
    nextPutAll: 'doit';
    lf;
    nextPutAll: '(' , classStructure superclassName;
    lf.
  self
    writeClassTypeMessage: classStructure
    on: aStream
    hasInstanceVariables: [ aStream
        nextPutAll:
            '	instVarNames: #( ' , classStructure instanceVariablesString , ' )';
        lf ].
  aStream
    nextPutAll: '	classVars: #( ' , classStructure classVariablesString , ' )';
    lf;
    nextPutAll:
        '	classInstVars: #( ' , classStructure classInstanceVariablesString , ' )';
    lf;
    nextPutAll: '	poolDictionaries: #()';
    lf;
    nextPutAll: '	inDictionary: UserGlobals';
    lf;
    nextPutAll: '	options: #())';
    lf;
    nextPutAll: '		category: ' , classStructure category printString , ';';
    lf;
    nextPutAll: '		comment: ' , classStructure comment printString , ';';
    lf;
    nextPutAll: '		immediateInvariant.';
    lf;
    nextPutAll: 'true.';
    lf;
    nextPutAll: '%';
    lf;
    lf
%

category: 'writing - private'
method: CypressTopazFileoutWriter
fileOutClassesPreambleOn: aStream

	aStream
		nextPutAll: '! Class Declarations'; lf;
		lf
%

category: 'writing - private'
method: CypressTopazFileoutWriter
fileOutClassInitializerFor: classStructure on: aStream

	aStream
		nextPutAll: classStructure className, ' initialize.'; lf
%

category: 'writing - private'
method: CypressTopazFileoutWriter
fileOutClassInitializersPostambleOn: aStream

	aStream
                nextPutAll: 'true.'; lf;
		nextPutAll: '%'; lf;
		lf
%

category: 'writing - private'
method: CypressTopazFileoutWriter
fileOutClassInitializersPreambleOn: aStream

	aStream
		nextPutAll: '! Class initializers '; lf;
		lf;
		nextPutAll: 'doit'; lf
%

category: 'writing - private'
method: CypressTopazFileoutWriter
fileOutExtensionsPreambleOn: aStream

	aStream
		nextPutAll: '! Class Extensions'; lf;
		lf
%

category: 'writing - private'
method: CypressTopazFileoutWriter
fileOutMethod: methodStructure on: aStream

	aStream
		nextPutAll: 'category: ', methodStructure category printString; lf;
		nextPutAll: (methodStructure isMetaclass ifTrue: ['classmethod: '] ifFalse: ['method: ']), methodStructure classStructure className; lf;
		nextPutAll: methodStructure source.
	methodStructure source last = Character lf
		ifFalse: [aStream lf].
	aStream nextPutAll: '%'; lf;
		lf
%

category: 'writing - private'
method: CypressTopazFileoutWriter
fileOutPackagePostambleOn: aStream

	aStream
		lf;
		lf;
		nextPutAll: '! End of Package: ', self packageName; lf;
		lf;
		lf
%

category: 'writing - private'
method: CypressTopazFileoutWriter
fileOutPackagePreambleOn: aStream

	aStream
		nextPutAll: '! Package: ', self packageName; lf;
		lf;
		lf;
		nextPutAll: '! Remove existing behavior from package ', self packageName; lf;
		nextPutAll: '!!!! This can be cleaned up when some package functionality is moved to the base system.'; lf;
		lf;
		nextPutAll: 'doit'; lf;
		nextPutAll: '| packageName |'; lf;
		nextPutAll: 'packageName := ', self packageName printString, '.'; lf;
		nextPutAll: 'System myUserProfile symbolList do: [:symDict |'; lf;
		nextPutAll: '	symDict do: [:possibleClass |'; lf;
		nextPutAll: '			| toRemove |'; lf;
		nextPutAll: '		possibleClass isBehavior ifTrue: ['; lf;
		nextPutAll: '			{possibleClass. possibleClass class} do: [:aClass |'; lf;
		nextPutAll: '				aClass category = packageName'; lf;
		nextPutAll: '					ifTrue: ['; lf;
		nextPutAll: '							"*anythingbutpackagename[-anything]"'; lf;
		nextPutAll: '						toRemove := aClass categoryNames select: '; lf;
		nextPutAll: '										[:each |'; lf;
		nextPutAll: '										each isEmpty not and: ['; lf;
		nextPutAll: '											(each first = $* and: [(each size = (packageName size + 1) and: [(each findStringNoCase: packageName startingAt: 2) = 2])'; lf;
		nextPutAll: '														or: [each size > (packageName size + 1) and: [(each findStringNoCase: packageName startingAt: 2) = 2 and: [(each at: packageName size + 2) = $-]]]])'; lf;
		nextPutAll: '											or: [each first ~= $*]]]'; lf;
		nextPutAll: '					]'; lf;
		nextPutAll: '					ifFalse: ['; lf;
		nextPutAll: '							"*packagename[-anything]"'; lf;
		nextPutAll: '						toRemove := aClass categoryNames select: '; lf;
		nextPutAll: '										[:each |'; lf;
		nextPutAll: '										each isEmpty not and: ['; lf;
		nextPutAll: '											each first = $* and: [(each size = (packageName size + 1) and: [(each findStringNoCase: packageName startingAt: 2) = 2])'; lf;
		nextPutAll: '														or: [each size > (packageName size + 1) and: [(each findStringNoCase: packageName startingAt: 2) = 2 and: [(each at: packageName size + 2) = $-]]]]]]'; lf;
		nextPutAll: '					].'; lf;
		nextPutAll: '				toRemove do: [:each | aClass removeCategory: each].'; lf;
		nextPutAll: '			]'; lf;
		nextPutAll: '		]'; lf;
		nextPutAll: '	]'; lf;
		nextPutAll: '].'; lf;
                nextPutAll: 'true.'; lf;
		nextPutAll: '%'; lf;
		lf;
		lf
%

category: 'writing - private'
method: CypressTopazFileoutWriter
fileOutPreambleType: aString for: classStructure on: aStream

	aStream
		nextPutAll: '! ', aString, ' for ', classStructure name; lf;
		lf
%

category: 'accessing'
method: CypressTopazFileoutWriter
packageNameExtension

	^'.gs'
%

category: 'writing - private'
method: CypressTopazFileoutWriter
writeClassTypeMessage: classStructure on: aStream hasInstanceVariables: instanceVariableBlock
  | classType classTypeMessage hasInstanceVariables |
  hasInstanceVariables := true.
  classType := classStructure subclassType.
  classType = 'indexableSubclass'
    ifTrue: [ classTypeMessage := 'indexableSubclass: ' ]
    ifFalse: [ classType = 'byteSubclass'
        ifTrue: [ classTypeMessage := 'byteSubclass: '.
          hasInstanceVariables := false ]
        ifFalse: [ classType = ''
            ifTrue: [ classTypeMessage := 'subclass: ' ]
            ifFalse: [ self error: 'unknown subclass type: ' , classType ] ] ].
  aStream
    tab;
    nextPutAll: classTypeMessage , classStructure className asString printString;
    lf.
  hasInstanceVariables
    ifTrue: [ instanceVariableBlock value ]
%

! Class implementation for 'CypressAbstractPackageReader'

!		Instance methods for 'CypressAbstractPackageReader'

category: 'private'
method: CypressAbstractPackageReader
classStructureFrom: classPropertiesDict

	^(CypressClassStructure new)
		packageStructure: self packageStructure;
		isClassExtension: true;
		properties: classPropertiesDict;
		yourself
%

category: 'private'
method: CypressAbstractPackageReader
classStructureFrom: classPropertiesDict comment: classComment

	^(self classStructureFrom: classPropertiesDict)
		isClassExtension: false;
		comment: classComment;
		yourself
%

category: 'reading'
method: CypressAbstractPackageReader
isPropertiesFileDirectoryEntry: entry

	^self propertiesFileNameExtensions
		anySatisfy: [:each | self string: entry endsWith: '/properties' , each]
%

category: 'accessing'
method: CypressAbstractPackageReader
packageExtension

	^self packageStructure
		packageExtensionOr: [self repository packageExtension]
%

category: 'parsing'
method: CypressAbstractPackageReader
parseSelectorFrom: methodString

	| meth |
	^
	[meth := self
				_parseMethod: methodString
				category: #xyzzy
				using: GsSession currentSession symbolList
				environmentId: 0.
	meth class ~~ GsNMethod
		ifTrue: 
			["if error slot is nil, then the method wasn't compiled because of errors"
			(meth at: 2) == nil ifFalse: [^nil].
			meth := meth at: 1].
	meth selector asString]
			on: CompileError
			do: [:ex | ex return: '_____could_not_parse_selector_from_method_source_____']
%

category: 'reading'
method: CypressAbstractPackageReader
readClassCommentFromDirectoryEntries: entries

	self fileUtils readStreamFor: (entries
				detect: [:entry | self string: entry endsWith: '/README.md']
				ifNone: [^''])
		do: [:fileStream | ^fileStream contents]
%

category: 'reading'
method: CypressAbstractPackageReader
readClassPropertiesFromDirectoryEntries: entries

	self fileUtils readStreamFor: (entries
				detect: [:entry | self isPropertiesFileDirectoryEntry: entry]
				ifNone: [^Dictionary new])
		do: [:fileStream | ^CypressJsonParser parseStream: fileStream]
%

category: 'reading'
method: CypressAbstractPackageReader
readClassStructureFromEntry: classEntry

	| classDirectory classPropertiesDict classComment entries classStructure |
	classDirectory := classEntry.
	entries := self fileUtils directoryEntriesFrom: classDirectory.
	classPropertiesDict := self
				readClassPropertiesFromDirectoryEntries: entries.
	classComment := self readClassCommentFromDirectoryEntries: entries.
	classStructure := self classStructureFrom: classPropertiesDict
				comment: classComment.
	self readMethodStructureFor: classStructure in: entries.
	^classStructure
%

category: 'reading'
method: CypressAbstractPackageReader
readCypressFormatMethodStructureFrom: fileStream intoClassStructure: classStructure meta: isMeta methods: methods

	| notice category source selector |
	(fileStream peekFor: $")
		ifTrue: [fileStream nextLine]
		ifFalse: [self error: 'Method does not have valid Cypress format'].
	(fileStream match: 'notice: ')
		ifTrue: [notice := fileStream nextLine trimSeparators]
		ifFalse: [self error: 'Method does not have valid Cypress format'].
	(fileStream match: 'category: ')
		ifTrue: [category := fileStream nextLine trimSeparators]
		ifFalse: [self error: 'Method does not have valid Cypress format'].
	(fileStream peekFor: $")
		ifTrue: [fileStream nextLine]
		ifFalse: [self error: 'Method does not have valid Cypress format'].
	source := fileStream upToEnd.
	selector := self parseSelectorFrom: source passCompileError: true.
	methods at: selector
		put: ((CypressMethodStructure new)
				packageStructure: self packageStructure;
				classStructure: classStructure;
				name: selector;
				isMetaclass: isMeta;
				selector: selector;
				category: category;
				source: source;
				yourself)
%

category: 'reading'
method: CypressAbstractPackageReader
readExtensionClassStructureFromEntry: classEntry

	| classPropertiesDict entries classStructure |
	entries := self fileUtils directoryEntriesFrom: classEntry.
	classPropertiesDict := self
				readClassPropertiesFromDirectoryEntries: entries.
	classStructure := self classStructureFrom: classPropertiesDict.
	self readMethodStructureFor: classStructure in: entries.
	^classStructure
%

category: 'reading'
method: CypressAbstractPackageReader
readFileTreeFormatMethodStructureFrom: fileStream intoClassStructure: classStructure meta: isMeta methods: methods

	| category source selector |
	category := fileStream nextLine trimSeparators.
	source := fileStream upToEnd.
	selector := self parseSelectorFrom: source passCompileError: true.
	methods at: selector
		put: ((CypressMethodStructure new)
				packageStructure: self packageStructure;
				classStructure: classStructure;
				name: selector;
				isMetaclass: isMeta;
				selector: selector;
				category: category;
				source: source;
				yourself)
%

category: 'reading'
method: CypressAbstractPackageReader
readMethodStructureFor: classStructure in: entries

	entries do: 
			[:entry |
			| methods isMeta |
			methods := (isMeta := self string: entry endsWith: '/class')
						ifTrue: [classStructure classMethods]
						ifFalse: [classStructure instanceMethods].
			((self string: entry endsWith: '/instance')
				or: [self string: entry endsWith: '/class'])
					ifTrue: 
						[((self fileUtils directoryEntriesFrom: entry)
							select: [:each | self string: each endsWith: '.st']) do: 
									[:methodEntry |
									self fileUtils readStreamFor: methodEntry
										do: 
											[:fileStream |
											self
												readMethodStructureFrom: fileStream
												intoClassStructure: classStructure
												meta: isMeta
												methods: methods]]]]
%

category: 'reading'
method: CypressAbstractPackageReader
readMethodStructureFrom: fileStream intoClassStructure: classStructure meta: isMeta methods: methods

	self subclassResponsibility: #readMethodStructureFrom:intoClassStructure:meta:methods:
%

category: 'reading'
method: CypressAbstractPackageReader
readPackageStructure

	(self fileUtils directoryEntriesFrom: self packageDirectory) do: 
			[:entry |
			(self isPropertiesFileDirectoryEntry: entry)
				ifTrue: [self packageStructure properties: (self readPropertiesFile: entry)].
			(self string: entry endsWith: '.class')
				ifTrue: 
					[self packageStructure classes
						add: (self readClassStructureFromEntry: entry)].
			(self string: entry endsWith: '.extension')
				ifTrue: 
					[self packageStructure extensions
						add: (self readExtensionClassStructureFromEntry: entry)]]
%

category: 'reading'
method: CypressAbstractPackageReader
readPackageStructureForPackageNamed: packageName

	| structureName |
	structureName := packageName , self repository packageExtension.
	self
		packageStructure: (CypressPackageStructure named: structureName);
		packageDirectory: (self fileUtils directoryFromPath: structureName
					relativeTo: self repository directoryPath);
		readPackageStructure
%

category: 'reading'
method: CypressAbstractPackageReader
readPropertiesFile: entry

	self fileUtils
		readStreamFor: entry
		do: [:fileStream | ^CypressJsonParser parseStream: fileStream]
%

category: 'parsing'
method: CypressAbstractPackageReader
_parseMethod: source category: cat using: aSymbolList environmentId: anEnvironmentId
	"Compiles the method into disposable dictionaries, if possible.
	 Attempts auto-recompile for undefinedSymbols.
	 Returns the compiled method or signals a CompileError."

	| undefinedSymbolList undefinedSymbols |
	undefinedSymbols := SymbolDictionary new name: #UndefinedSymbols.
	undefinedSymbolList := SymbolList with: undefinedSymbols.
	^
	[UndefinedObject
		compileMethod: source
		dictionaries: aSymbolList
		category: cat
		intoMethodDict: GsMethodDictionary new
		intoCategories: GsMethodDictionary new
		environmentId: anEnvironmentId]
			onSynchronous: (Array with: CompileError with: CompileWarning)
			do: (Array with: 
						[:ex |
						| undefSymbol symbols |
						undefSymbol := true.
						symbols := Array new.
						ex errorDetails do: 
								[:errArray |
								(errArray atOrNil: 1) == 1031
									ifTrue: [symbols add: (errArray atOrNil: 5) asSymbol]
									ifFalse: [undefSymbol := false]].
						undefSymbol
							ifTrue: 
								["attempt auto-define of undefined symbols"
								symbols do: [:sym | undefinedSymbols at: sym put: nil].
								
								[^UndefinedObject
									compileMethod: source
									dictionaries: aSymbolList , undefinedSymbolList
									category: cat
									intoMethodDict: GsMethodDictionary new
									intoCategories: GsMethodDictionary new
									environmentId: anEnvironmentId]
										onException: CompileError
										do: [:exb | undefSymbol := false]].
						undefSymbol ifFalse: [ex outer]]
					with: [:ex | ex resume])
%

! Class implementation for 'CypressDoNothingPackageReader'

!		Instance methods for 'CypressDoNothingPackageReader'

category: 'reading'
method: CypressDoNothingPackageReader
readPackageStructure
%

! Class implementation for 'CypressFileTreeFormatPackageReader'

!		Instance methods for 'CypressFileTreeFormatPackageReader'

category: 'private'
method: CypressFileTreeFormatPackageReader
classStructureFrom: fileteeClassPropertiesDict comment: classComment
  | classPropertiesDict subclassType filetreeSubclassType |
  classPropertiesDict := fileteeClassPropertiesDict copy.
  filetreeSubclassType := classPropertiesDict at: 'type'.
  filetreeSubclassType = 'normal'
    ifTrue: [ subclassType := '' ]
    ifFalse: [ 
      filetreeSubclassType = 'variable'
        ifTrue: [ subclassType := 'indexableSubclass' ]
        ifFalse: [ 
          filetreeSubclassType = 'bytes'
            ifTrue: [ subclassType := 'byteSubclass' ]
            ifFalse: [ self error: 'unknown subclass type: ' , filetreeSubclassType printString ] ] ].
  classPropertiesDict at: '_gs_subclassType' put: subclassType.
  ^ super classStructureFrom: classPropertiesDict comment: classComment
%

category: 'accessing'
method: CypressFileTreeFormatPackageReader
propertiesFileNameExtension

	^'.json'
%

category: 'accessing'
method: CypressFileTreeFormatPackageReader
propertiesFileNameExtensions

	^Array
		with: super propertiesFileNameExtension
		with: self propertiesFileNameExtension
%

category: 'reading'
method: CypressFileTreeFormatPackageReader
readMethodStructureFrom: fileStream intoClassStructure: classStructure meta: isMeta methods: methods
	"Strict!"

	self
		readFileTreeFormatMethodStructureFrom: fileStream
		intoClassStructure: classStructure
		meta: isMeta
		methods: methods
%

! Class implementation for 'CypressFlexiblePackageReader'

!		Instance methods for 'CypressFlexiblePackageReader'

category: 'reading'
method: CypressFlexiblePackageReader
isPropertiesFileDirectoryEntry: entry
	"Expect .ston properties file, but tolerate .json if present."

	^(super isPropertiesFileDirectoryEntry: entry)
		or: [self string: entry endsWith: '/properties.json']
%

category: 'reading'
method: CypressFlexiblePackageReader
readMethodStructureFrom: fileStream intoClassStructure: classStructure meta: isMeta methods: methods
	"If the stream begins with a double quote, process it on the assumption it is a Cypress-format method.
	 Otherwise, treat it as a FileTree-format method."

	fileStream peek = $"
		ifTrue: 
			[self
				readCypressFormatMethodStructureFrom: fileStream
				intoClassStructure: classStructure
				meta: isMeta
				methods: methods]
		ifFalse: 
			[self
				readFileTreeFormatMethodStructureFrom: fileStream
				intoClassStructure: classStructure
				meta: isMeta
				methods: methods]
%

! Class implementation for 'CypressPackageReader'

!		Instance methods for 'CypressPackageReader'

category: 'reading'
method: CypressPackageReader
readMethodStructureFrom: fileStream intoClassStructure: classStructure meta: isMeta methods: methods
	"Strict!"

	self
		readCypressFormatMethodStructureFrom: fileStream
		intoClassStructure: classStructure
		meta: isMeta
		methods: methods
%

! Class implementation for 'CypressAbstractPackageWriter'

!		Class methods for 'CypressAbstractPackageWriter'

category: 'initialization'
classmethod: CypressAbstractPackageWriter
initializeSpecials
	"Valid binarySelector characters  '!' | '%' | '&' | '*' | '+' | ','' | '/' | '<' | '=' | '>' | '?' | '@' | '\' | '~' | '|' | '-'"

	| map |
	map := Dictionary new.
	map
		at: $! put: 'bang';
		at: $% put: 'percent';
		at: $& put: 'and';
		at: $* put: 'star';
		at: $+ put: 'plus';
		at: $, put: 'comma';
		at: $- put: 'minus';
		at: $/ put: 'slash';
		at: $< put: 'less';
		at: $= put: 'equals';
		at: $> put: 'more';
		at: $? put: 'wat';
		at: $@ put: 'at';
		at: $\ put: 'backslash';
		at: $| put: 'pipe';
		at: $~ put: 'tilde'.
	map keys do: [:key | map at: (map at: key) put: key].
	^map
%

category: 'accessing'
classmethod: CypressAbstractPackageWriter
specials

	^specials ifNil: [specials := self initializeSpecials]
%

!		Instance methods for 'CypressAbstractPackageWriter'

category: 'private'
method: CypressAbstractPackageWriter
determinePackageDirectory

	^self fileUtils ensureDirectoryExists: (self fileUtils
				directoryFromPath: self packageStructure name
				relativeTo: self repository directoryPath)
%

category: 'private'
method: CypressAbstractPackageWriter
directoryForDirectoryNamed: directoryNameOrPath

	^directoryNameOrPath = '.'
		ifTrue: [self fileUtils ensureDirectoryExists: self packageDirectory]
		ifFalse: [self subPackageFileDirectoryFor: directoryNameOrPath]
%

category: 'private'
method: CypressAbstractPackageWriter
fileNameForSelector: selector

	^selector last = $:
		ifTrue: [selector copyReplacing: $: with: $.]
		ifFalse: 
			[(selector first isLetter or: [selector first = $_])
				ifTrue: [selector]
				ifFalse: 
					[| specials output |
					specials := self class specials.
					output := WriteStreamPortable on: (String new: 100).
					output nextPut: $^.
					selector do: [:each | output nextPutAll: (specials at: each)]
						separatedBy: [output nextPut: $.].
					output contents]]
%

category: 'writing'
method: CypressAbstractPackageWriter
removeOldReplacingWithNew
  self fileUtils deleteAll: self packageDirectory.
  self writePropertiesFile.
  self writePackageStructure
%

category: 'private'
method: CypressAbstractPackageWriter
subPackageFileDirectoryFor: directoryNameOrPath

	| dir |
	dir := self fileUtils directoryFromPath: directoryNameOrPath
				relativeTo: self packageDirectory.
	self fileUtils ensureDirectoryExists: dir.
	^dir
%

category: 'writing'
method: CypressAbstractPackageWriter
writeClassComment: classStructure on: fileStream

	fileStream
		nextPutAll: (CypressObject normalizeLineEndingsOf: classStructure comment)
%

category: 'writing'
method: CypressAbstractPackageWriter
writeClassStructure: classStructure to: classPath

	self
		writeInDirectoryName: classPath
			fileName: 'README'
			extension: '.md'
			visit: [:fileStream | self writeClassComment: classStructure on: fileStream];
		writeInDirectoryName: classPath
			fileName: 'properties'
			extension: self propertiesFileNameExtension
			visit: [:fileStream | classStructure properties _writeCypressJsonOn: fileStream]
%

category: 'writing'
method: CypressAbstractPackageWriter
writeExtensionClassStructure: classStructure to: classPath

	self
		writeInDirectoryName: classPath
		fileName: 'properties'
		extension: self propertiesFileNameExtension
		visit: 
			[:fileStream |
			(Dictionary with: 'name' -> classStructure className)
				_writeCypressJsonOn: fileStream]
%

category: 'private'
method: CypressAbstractPackageWriter
writeInDirectoryName: directoryNameOrPath fileName: fileName extension: ext visit: visitBlock

	| directory |
	directory := self directoryForDirectoryNamed: directoryNameOrPath.
	self fileUtils
		writeStreamFor: fileName , ext
		in: directory
		do: [:fileStream | visitBlock value: fileStream]
%

category: 'writing'
method: CypressAbstractPackageWriter
writeMethodStructure: methodStructure onStream: fileStream

	self subclassResponsibility: #writeMethodStructure:onStream:
%

category: 'writing'
method: CypressAbstractPackageWriter
writeMethodStructure: methodStructure to: methodPath

	| filename |
	filename := self fileNameForSelector: methodStructure selector.
	self
		writeInDirectoryName: methodPath
		fileName: filename
		extension: '.st'
		visit: [:fileStream | self writeMethodStructure: methodStructure onStream: fileStream]
%

category: 'writing'
method: CypressAbstractPackageWriter
writePackageStructure

	self
		writePackageStructureClasses: self packageStructure classes
			isClassExtension: false;
		writePackageStructureClasses: self packageStructure extensions
			isClassExtension: true
%

category: 'writing'
method: CypressAbstractPackageWriter
writePackageStructure: aPackageStructure

	self
		packageStructure: aPackageStructure;
		packageDirectory: self determinePackageDirectory;
		removeOldReplacingWithNew
%

category: 'writing'
method: CypressAbstractPackageWriter
writePackageStructureClasses: classStructures isClassExtension: isClassExtension

	| classDirExtension |
	classDirExtension := isClassExtension
				ifTrue: ['.extension']
				ifFalse: ['.class'].
	classStructures do: 
			[:classStructure |
			| classPath instanceMethodPath classMethodPath |
			classPath := classStructure className , classDirExtension
						, self fileUtils pathNameDelimiter asString.
			isClassExtension
				ifTrue: [self writeExtensionClassStructure: classStructure to: classPath]
				ifFalse: [self writeClassStructure: classStructure to: classPath].
			instanceMethodPath := classPath , 'instance' , self fileUtils pathNameDelimiter asString.
			classStructure instanceMethods
				do: [:methodStructure | self writeMethodStructure: methodStructure to: instanceMethodPath].
			classMethodPath := classPath , 'class' , self fileUtils pathNameDelimiter asString.
			classStructure classMethods
				do: [:methodStructure | self writeMethodStructure: methodStructure to: classMethodPath]]
%

category: 'writing'
method: CypressAbstractPackageWriter
writePropertiesFile

	self
		writeInDirectoryName: '.'
		fileName: 'properties'
		extension: self propertiesFileNameExtension
		visit: [:fileStream | Dictionary new _writeCypressJsonOn: fileStream]
%

! Class implementation for 'CypressFileTreeFormatPackageWriter'

!		Instance methods for 'CypressFileTreeFormatPackageWriter'

category: 'private'
method: CypressFileTreeFormatPackageWriter
adjustClassPropertiesForFileTree: classPropertyDict
  | props classType |
  props := classPropertyDict copy.
  classType := (props at: '_gs_subclassType' ifAbsent: [  ])
    ifNil: [ 'normal' ]
    ifNotNil: [ :type | 
      props removeKey: '_gs_subclassType'.
      type = 'indexableSubclass'
        ifTrue: [ 'variable' ]
        ifFalse: [ 
          type = 'byteSubclass'
            ifTrue: [ 'bytes' ]
            ifFalse: [ self error: 'unknown subclass type: ' , type ] ] ].
  props at: 'type' put: classType.
  ^ props
%

category: 'accessing'
method: CypressFileTreeFormatPackageWriter
propertiesFileNameExtension
  ^ '.json'
%

category: 'writing'
method: CypressFileTreeFormatPackageWriter
removeOldReplacingWithNew

	self fileUtils deleteAll: self packageDirectory
		rejecting: 
			[:filename |
			"do not delete the monticello.meta directory to preserve existing Monticello meta data.
       Equivalent behavior to MCFileTreeRepository with Metadata property set to false."
			(self string: filename endsWith: 'monticello.meta')
				or: [ (self string: filename endsWith: '.filetree')
					or: [self string: filename endsWith: 'methodProperties.json']]].
	self writePropertiesFile.
	self writePackageStructure
%

category: 'writing'
method: CypressFileTreeFormatPackageWriter
writeClassStructure: classStructure to: classPath

	self
		writeInDirectoryName: classPath
			fileName: 'README'
			extension: '.md'
			visit: [:fileStream | self writeClassComment: classStructure on: fileStream];
		writeInDirectoryName: classPath
			fileName: 'properties'
			extension: self propertiesFileNameExtension
			visit: 
				[:fileStream |
				(self adjustClassPropertiesForFileTree: classStructure properties)
					_writeCypressJsonOn: fileStream]
%

category: 'writing'
method: CypressFileTreeFormatPackageWriter
writeExtensionClassStructure: classStructure to: classPath

	self
		writeInDirectoryName: classPath
		fileName: 'properties'
		extension: self propertiesFileNameExtension
		visit: 
			[:fileStream |
			(Dictionary with: 'name' -> classStructure className)
				_writeCypressJsonOn: fileStream]
%

category: 'writing'
method: CypressFileTreeFormatPackageWriter
writeMethodStructure: methodStructure onStream: fileStream

	fileStream
		nextPutAll: methodStructure category;
		lf;
		nextPutAll: (CypressObject normalizeLineEndingsOf: methodStructure source)
%

category: 'writing'
method: CypressFileTreeFormatPackageWriter
writePropertiesFile

	self
		writeInDirectoryName: '.'
		fileName: 'properties'
		extension: self propertiesFileNameExtension
		visit: [:fileStream | Dictionary new _writeCypressJsonOn: fileStream]
%

! Class implementation for 'CypressPackageWriter'

!		Instance methods for 'CypressPackageWriter'

category: 'accessing - private'
method: CypressPackageWriter
methodNoticeLine

	^self packageStructure properties
		at: 'copyrightLine'
		ifAbsent: [self repository copyrightProperty]
%

category: 'writing'
method: CypressPackageWriter
writeMethodStructure: methodStructure onStream: fileStream

	fileStream
		nextPutAll: '"';
		lf;
		nextPutAll: 'notice: ' , self methodNoticeLine;
		lf;
		nextPutAll: 'category: ' , methodStructure category;
		lf;
		nextPutAll: '"';
		lf;
		nextPutAll: (CypressObject normalizeLineEndingsOf: methodStructure source)
%

category: 'writing'
method: CypressPackageWriter
writePropertiesFile

	self
		writeInDirectoryName: '.'
		fileName: 'properties'
		extension: self propertiesFileNameExtension
		visit: [:fileStream | self repository properties _writeCypressJsonOn: fileStream]
%

! Class implementation for 'CypressStrictFileTreeFormatDoNothingPackageWriter'

!		Instance methods for 'CypressStrictFileTreeFormatDoNothingPackageWriter'

category: 'writing'
method: CypressStrictFileTreeFormatDoNothingPackageWriter
removeOldReplacingWithNew
	"Change nothing, since a Cypress writer has insufficient information
	 for preserving the FileTree details. Strictly read-only."
%

category: 'writing'
method: CypressStrictFileTreeFormatDoNothingPackageWriter
writePropertiesFile
	"Change nothing, since a Cypress writer has insufficient information
	 for preserving the FileTree details. Strictly read-only."
%

! Class implementation for 'CypressAbstractRepository'

!		Class methods for 'CypressAbstractRepository'

category: 'instance creation'
classmethod: CypressAbstractRepository
createOn: aUrl alias: aString
  ^ self onUrl: aUrl alias: aString
%

category: 'accessing'
classmethod: CypressAbstractRepository
defaultCopyrightNotice

	^DefaultCopyrightNotice
%

category: 'accessing'
classmethod: CypressAbstractRepository
defaultCopyrightNotice: aString

	DefaultCopyrightNotice := aString
%

category: 'initializing'
classmethod: CypressAbstractRepository
initialize

	self initializeDefaultCopyrightNotice
%

category: 'initializing'
classmethod: CypressAbstractRepository
initializeDefaultCopyrightNotice

	self defaultCopyrightNotice isNil ifFalse: [^self].
	self defaultCopyrightNotice: 'This work is protected by copyright. All rights reserved.'
%

category: 'instance creation'
classmethod: CypressAbstractRepository
onUrl: aUrl alias: aString

	^(aUrl repositoryClass new)
		initializeUrl: aUrl andAlias: aString;
		yourself
%

!		Instance methods for 'CypressAbstractRepository'

category: 'accessing properties'
method: CypressAbstractRepository
alias

	^properties 
		at: 'alias'
		ifAbsent: ['']
%

category: 'accessing properties'
method: CypressAbstractRepository
alias: aString

	properties 
		at: 'alias'
		put: aString
%

category: 'accessing properties'
method: CypressAbstractRepository
copyrightProperty

	^properties 
		at: '_cypress_copyright'
		ifAbsent: ['']
%

category: 'accessing properties'
method: CypressAbstractRepository
copyrightProperty: aString

	properties 
		at: '_cypress_copyright'
		put: aString
%

category: 'accessing'
method: CypressAbstractRepository
defaultCopyrightNotice

	^self class defaultCopyrightNotice
%

category: 'accessing'
method: CypressAbstractRepository
description

	^self alias
%

category: 'initializing - private'
method: CypressAbstractRepository
initialize

	self initializeDefaultRepositoryProperties.
	readerClass := CypressPackageReader.
	writerClass := CypressPackageWriter.
%

category: 'initializing - private'
method: CypressAbstractRepository
initializeDefaultCopyrightProperty

	self copyrightProperty: self defaultCopyrightNotice
%

category: 'initializing - private'
method: CypressAbstractRepository
initializeDefaultRepositoryProperties

	properties := Dictionary new.
	self initializeDefaultCopyrightProperty
%

category: 'initializing - private'
method: CypressAbstractRepository
initializeUrl: aUrl andAlias: aString

	self
		initialize;
		url: aUrl;
		alias: aString;
		validateUrl
%

category: 'accessing properties'
method: CypressAbstractRepository
packageExtension

	^properties 
		at: 'packageExtension'
		ifAbsent: ['.package']
%

category: 'printing'
method: CypressAbstractRepository
printDetailsOn: aStream

	aStream nextPutAll: self alias
%

category: 'printing'
method: CypressAbstractRepository
printOn: aStream

	aStream
		nextPutAll: self class name;
		nextPutAll: '('.
	self printDetailsOn: aStream.
	aStream nextPutAll: ')'
%

category: 'reading'
method: CypressAbstractRepository
reader

	^readerClass forRepository: self
%

category: 'reading'
method: CypressAbstractRepository
readPackageStructureForPackageNamed: packageName

	^(self reader)
		readPackageStructureForPackageNamed: packageName;
		packageStructure
%

category: 'accessing'
method: CypressAbstractRepository
url

	^url
%

category: 'accessing'
method: CypressAbstractRepository
url: aString

	url := aString
%

category: 'validating - private'
method: CypressAbstractRepository
validateUrl
	"At this level, there is nothing to check.
	 But different URLs denote different kinds of repositories, and
	 each kind of repository may have specific checks."
%

category: 'writing'
method: CypressAbstractRepository
writePackageStructure: aPackageStructure

	^self writer writePackageStructure: aPackageStructure
%

category: 'writing'
method: CypressAbstractRepository
writer

	^writerClass forRepository: self
%

! Class implementation for 'CypressAbstractFileoutRepository'

!		Class methods for 'CypressAbstractFileoutRepository'

category: 'instance creation'
classmethod: CypressAbstractFileoutRepository
on: aDirectory

	^self new
		initializeForDirectory: aDirectory;
		yourself.
%

!		Instance methods for 'CypressAbstractFileoutRepository'

category: 'accessing'
method: CypressAbstractFileoutRepository
description

	| desc |
	desc := super description.
	^desc notEmpty
		ifTrue: [desc]
		ifFalse: [self directoryPath]
%

category: 'accessing'
method: CypressAbstractFileoutRepository
directoryPath

	^directoryPath
%

category: 'initializing - private'
method: CypressAbstractFileoutRepository
directoryPath:  aString

	directoryPath := aString
%

category: 'initializing - private'
method: CypressAbstractFileoutRepository
ensureDirectoryPathExists

	self fileUtils ensureDirectoryExists: self directoryPath
%

category: 'accessing - private'
method: CypressAbstractFileoutRepository
fileUtils

	^CypressFileUtilities current
%

category: 'initializing - private'
method: CypressAbstractFileoutRepository
initializeCreationOn: aUrl alias: aString

	self
		initializeUrl: aUrl andAlias: aString;
		alias: aString
%

category: 'initializing - private'
method: CypressAbstractFileoutRepository
initializeForDirectory: aDirectory

	self initialize.
	self directoryPath: aDirectory.
	self directoryPath isEmpty ifTrue: [^self].	"Not really valid; not a very good idea."
	self ensureDirectoryPathExists.
	self initializeReaderAndWriterClasses.
%

category: 'initializing - private'
method: CypressAbstractFileoutRepository
initializeReaderAndWriterClasses
  self subclassResponsibility: #'initializeReaderAndWriterClasses'
%

category: 'initializing - private'
method: CypressAbstractFileoutRepository
initializeUrl: aUrl andAlias: aString

	super initializeUrl: aUrl andAlias: aString.
	self directoryPath: self url pathForDirectory.
	self ensureDirectoryPathExists.
	self initializeReaderAndWriterClasses.
%

category: 'printing'
method: CypressAbstractFileoutRepository
printDetailsOn: aStream

	self alias notEmpty
		ifTrue: 
			[aStream
				nextPutAll: self alias;
				nextPutAll: ': '].
	aStream nextPutAll: self url printString
%

category: 'validating - private'
method: CypressAbstractFileoutRepository
validateUrl
	"At this level, there is nothing to check.
	 But different URLs denote different kinds of repositories, and
	 each kind of repository may have specific checks."

	self url fileName isEmpty
		ifFalse: [self error: self printString, ' should not be used with URLs for file names (', self url fileName, ' in ', self url pathForDirectory, ')']
%

! Class implementation for 'CypressSmalltalkRepository'

!		Instance methods for 'CypressSmalltalkRepository'

category: 'initializing - private'
method: CypressSmalltalkRepository
initializeReaderAndWriterClasses

	readerClass := CypressDoNothingPackageReader.
	writerClass := CypressSmalltalkFileoutWriter.
%

! Class implementation for 'CypressTopazRepository'

!		Instance methods for 'CypressTopazRepository'

category: 'initializing - private'
method: CypressTopazRepository
initializeReaderAndWriterClasses

	readerClass := CypressDoNothingPackageReader.
	writerClass := CypressTopazFileoutWriter.
%

! Class implementation for 'CypressDictionaryRepository'

!		Class methods for 'CypressDictionaryRepository'

category: 'instance creation'
classmethod: CypressDictionaryRepository
on: aDictionary
  ^ self new
    initializeForDictionary: aDictionary;
    yourself
%

!		Instance methods for 'CypressDictionaryRepository'

category: 'accessing'
method: CypressDictionaryRepository
dictionary
  ^ dictionary
%

category: 'accessing'
method: CypressDictionaryRepository
dictionary: aDictionary
  dictionary := aDictionary
%

category: 'initializing - private'
method: CypressDictionaryRepository
initialize
  super initialize.
  readerClass := nil.
  writerClass := nil
%

category: 'initializing - private'
method: CypressDictionaryRepository
initializeForDictionary: aDictionary
  self initialize.
  self dictionary: aDictionary
%

category: 'accessing'
method: CypressDictionaryRepository
packageNames
  ^ self dictionary keys
%

category: 'reading'
method: CypressDictionaryRepository
readPackageStructureForPackageNamed: packageName
  ^ (self dictionary at: packageName) packageStructure
%

category: 'writing'
method: CypressDictionaryRepository
writePackageStructure: aPackageStructure
  ^ self dictionary at: aPackageStructure packageName put: aPackageStructure
%

! Class implementation for 'CypressFileSystemRepository'

!		Class methods for 'CypressFileSystemRepository'

category: 'instance creation'
classmethod: CypressFileSystemRepository
on: aDirectory

	^self new
		initializeForDirectory: aDirectory;
		yourself.
%

!		Instance methods for 'CypressFileSystemRepository'

category: 'accessing - properties'
method: CypressFileSystemRepository
codeFormatProperty

	^properties 
		at: '_gs_format'
		ifAbsent: ['Cypress']
%

category: 'updating properties'
method: CypressFileSystemRepository
codeFormatProperty: aString

	self validate: aString isOneOf: #('Cypress' 'FileTree' 'Flexible').
	properties 
		at: '_gs_format'
		put: aString
%

category: 'accessing'
method: CypressFileSystemRepository
description
  | desc |
  desc := super description.
  ^ desc notEmpty
    ifTrue: [ desc ]
    ifFalse: [ self url asString ]
%

category: 'accessing'
method: CypressFileSystemRepository
directoryPath

	^directoryPath
%

category: 'initializing - private'
method: CypressFileSystemRepository
directoryPath: aString
  | delim |
  delim := self fileUtils pathNameDelimiter.
  aString last = delim last
    ifTrue: [ directoryPath := aString ]
    ifFalse: [ directoryPath := aString , delim ]
%

category: 'testing - private'
method: CypressFileSystemRepository
doesRepositoryFileExist: fileName
	"Answer whether the named file exists at the repository level."

	^self fileUtils
		directoryExists: (self fileUtils
				directoryFromPath: fileName
				relativeTo: self directoryPath)
%

category: 'initializing - private'
method: CypressFileSystemRepository
ensureDirectoryPathExists

	self fileUtils ensureDirectoryExists: self directoryPath
%

category: 'accessing - private'
method: CypressFileSystemRepository
fileUtils

	^CypressFileUtilities current
%

category: 'initializing - private'
method: CypressFileSystemRepository
fixupMissingCopyrightProperty

	self copyrightProperty isEmpty ifFalse: [^self].
	self initializeDefaultCopyrightProperty.
%

category: 'initializing - private'
method: CypressFileSystemRepository
initializeCreationOn: aUrl alias: aString

	self
		initializeUrl: aUrl andAlias: aString;
		alias: aString;
		writePropertiesFile
%

category: 'initializing - private'
method: CypressFileSystemRepository
initializeDefaultRepositoryProperties

	super initializeDefaultRepositoryProperties.
	self
		codeFormatProperty: 'Cypress';
		strictCodeFormat: false.
%

category: 'initializing - private'
method: CypressFileSystemRepository
initializeForDirectory: aDirectory

	self initialize.
	self directoryPath: aDirectory.
	self directoryPath isEmpty ifTrue: [^self].	"Not really valid; not a very good idea."
	self ensureDirectoryPathExists.
	self readPropertiesFile.
	self fixupMissingCopyrightProperty.
	self initializeReaderAndWriterClasses.
%

category: 'initializing - private'
method: CypressFileSystemRepository
initializeForFileTreeRepository
  self initializeDefaultRepositoryProperties.
  self
    codeFormatProperty: 'FileTree';
    strictCodeFormat: true
%

category: 'initializing - private'
method: CypressFileSystemRepository
initializeReaderAndWriterClasses

	self isCodeFormatCypress
		ifTrue: 
			[self isCodeFormatStrict
				ifTrue: 
					[readerClass := CypressPackageReader.
					writerClass := CypressPackageWriter]
				ifFalse: 
					[readerClass := CypressFlexiblePackageReader.
					writerClass := CypressPackageWriter]]
		ifFalse: 
			[self isCodeFormatStrict
				ifTrue: 
					[readerClass := CypressFileTreeFormatPackageReader.
					writerClass := CypressStrictFileTreeFormatDoNothingPackageWriter]
				ifFalse: 
					[readerClass := CypressFlexiblePackageReader.
					writerClass := CypressFileTreeFormatPackageWriter]]
%

category: 'initializing - private'
method: CypressFileSystemRepository
initializeRepositoryDirectory
  self directoryPath: self url pathForDirectory.
  self ensureDirectoryPathExists
%

category: 'initializing - private'
method: CypressFileSystemRepository
initializeUrl: aUrl andAlias: aString
  super initializeUrl: aUrl andAlias: aString.
  self initializeRepositoryDirectory.
  self readPropertiesFile.
  self codeFormatProperty: self url codeFormat.
  self strictCodeFormat: self url isStrict.
  self fixupMissingCopyrightProperty.
  self initializeReaderAndWriterClasses
%

category: 'testing properties'
method: CypressFileSystemRepository
isCodeFormatCypress

	^self isCodeFormatProperty: 'Cypress'
%

category: 'testing properties'
method: CypressFileSystemRepository
isCodeFormatFileTree

	^self isCodeFormatProperty: 'FileTree'
%

category: 'testing properties'
method: CypressFileSystemRepository
isCodeFormatFlexiblyCypress

	^self isCodeFormatStrict not and: [self isCodeFormatCypress]
%

category: 'testing properties'
method: CypressFileSystemRepository
isCodeFormatFlexiblyFileTree

	^self isCodeFormatStrict not and: [self isCodeFormatFileTree]
%

category: 'testing properties - private'
method: CypressFileSystemRepository
isCodeFormatProperty: aString

	^(properties at: '_gs_format') equalsNoCase: aString
%

category: 'testing properties'
method: CypressFileSystemRepository
isCodeFormatStrict

	^(properties 
		at: '_gs_strict'
		ifAbsent: ['']) equalsNoCase: 'true'
%

category: 'testing properties'
method: CypressFileSystemRepository
isCodeFormatStrictlyCypress

	^self isCodeFormatStrict and: [self isCodeFormatCypress]
%

category: 'testing properties'
method: CypressFileSystemRepository
isCodeFormatStrictlyFileTree

	^self isCodeFormatStrict and: [self isCodeFormatFileTree]
%

category: 'accessing'
method: CypressFileSystemRepository
packageNames

	| extension extensionSize |
	extension := self packageExtension.
	extensionSize := extension size.
	^(self fileUtils
		directoryEntriesFrom: self directoryPath , '*' , extension) collect: 
				[:each |
				| localName |
				localName := self fileUtils localNameFrom: each.
				localName copyFrom: 1 to: localName size - extensionSize]
%

category: 'printing'
method: CypressFileSystemRepository
printDetailsOn: aStream
  self alias notEmpty
    ifTrue: [ aStream
        nextPutAll: self alias;
        nextPutAll: ': ' ].
  aStream nextPutAll: self url printString
%

category: 'accessing'
method: CypressFileSystemRepository
properties
  ^ properties
%

category: 'reading'
method: CypressFileSystemRepository
readPropertiesFile

	self readPropertiesFile: (#('properties.ston' 'properties.json' '.filetree')
				detect: [:each | self doesRepositoryFileExist: each]
				ifNone: [^self]).
%

category: 'reading'
method: CypressFileSystemRepository
readPropertiesFile: fileName
	"Expect 'properties.ston' for Cypress, but permit 'properties.json' in which case we assume
	 the format should be FileTree.

	 Supported properties are:
		_cypress_copyright	- the (optional, default) copyright notice for the whole repository
		_gs_format			- optional, determines which format will be used for writing packages (and reading, but ...)
							- either Cypress or FileTree (case-insensitive)
		_gs_strict			- optional, determines whether the reader strictly enforces the format
							- either true or false (case-insensitive)
		_gs_fileout			- optional, determines whether to also produce a *.gs fileout when writing a package
							- either true or false (case-insensitive)
	"

	fileName = '.filetree' ifTrue: [^self initializeForFileTreeRepository].
	self fileUtils
		readStreamFor: fileName
		in: self directoryPath
		do: [:fileStream | properties := CypressJsonParser parseStream: fileStream]
%

category: 'updating properties'
method: CypressFileSystemRepository
strictCodeFormat: aBoolean

	self strictCodeFormatProperty: aBoolean printString

%

category: 'updating properties - private'
method: CypressFileSystemRepository
strictCodeFormatProperty: aString

	self validate: aString isOneOf: #('true' 'false').
	properties 
		at: '_gs_strict'
		put: aString
%

category: 'updating properties - private'
method: CypressFileSystemRepository
validate: aString isOneOf: someStrings

	someStrings
		detect: [:each | aString equalsNoCase: each]
		ifNone: [self error: aString printString, ' must be one of ', someStrings printString].
%

category: 'validating - private'
method: CypressFileSystemRepository
validateUrl
	"At this level, there is nothing to check.
	 But different URLs denote different kinds of repositories, and
	 each kind of repository may have specific checks."

	self url fileName isEmpty
		ifFalse: [self error: self printString, ' should not be used with URLs for file names (', self url fileName, ' in ', self url pathForDirectory, ')']
%

category: 'writing'
method: CypressFileSystemRepository
writePropertiesFile

	self writePropertiesFile: (self isCodeFormatFileTree
				ifTrue: ['properties.json']
				ifFalse: ['properties.ston'])
%

category: 'writing'
method: CypressFileSystemRepository
writePropertiesFile: fileName

	self fileUtils
		writeStreamFor: fileName
		in: self directoryPath
		do: [:fileStream | properties _writeCypressJsonOn: fileStream]
%

! Class implementation for 'CypressFileSystemGitRepository'

!		Class methods for 'CypressFileSystemGitRepository'

category: 'accessing'
classmethod: CypressFileSystemGitRepository
gitRepositoryDir
  | path |
  path := (SessionTemps current at: #'Cypress_FileSystem_Git_Repository_Directory' otherwise: nil)
    ifNil: [
      path := (System gemEnvironmentVariable: 'GEMSTONE_GITDIR')
        ifNil: [ 
          CypressFileUtilities current workingDirectory
          , CypressFileUtilities current pathNameDelimiter , 'cypress-git-repos' ].
      SessionTemps current at: #'Cypress_FileSystem_Git_Repository_Directory' put: path ].
  ^path
%

category: 'accessing'
classmethod: CypressFileSystemGitRepository
gitRepositoryDir: directoryPath
  ^ SessionTemps current at: #'Cypress_FileSystem_Git_Repository_Directory' put: directoryPath
%

category: 'git commands'
classmethod: CypressFileSystemGitRepository
performOnServer: commandLine
  | result |
  result := self
    performOnServer: commandLine
    status: [ :performOnServerStatusArray | "Array of 5 elements: 
       raw status Integer, 
       child process status Integer (after WEXITSTATUS macro applied), 
       result String (or nil if operation failed) ,
       error string from script file write, fork, or result file read ,
       errno value, a SmallInteger from file write, fork, or file read"
      (performOnServerStatusArray at: 1) ~~ 0
        ifTrue: [ | message |
          message := 'performOnServer: ' , commandLine printString , ' stdout: '
            , (performOnServerStatusArray at: 3) printString
            , ' failed with status: '
            , (performOnServerStatusArray at: 1) printString , ' errno: '
            , (performOnServerStatusArray at: 5) printString , ' errStr: '
            , (performOnServerStatusArray at: 4) asString.
          self error: message ].
      performOnServerStatusArray at: 3 ].
  Transcript
    cr;
    show: commandLine printString;
    cr;
    show: result.
  ^ result
%

category: 'git commands'
classmethod: CypressFileSystemGitRepository
performOnServer: commandLine status: statusBlock
  | performOnServerStatusArray |
  performOnServerStatusArray := System _performOnServer: commandLine.
  ^ statusBlock value: performOnServerStatusArray
%

category: 'git commands'
classmethod: CypressFileSystemGitRepository
runGitCommand: argsArray in: gitRootPath

	| stream |
	stream := WriteStreamPortable on: (String new: 100).
	stream nextPutAll: 'cd ' , gitRootPath , '; git '.
	argsArray do: 
			[:arg |
			stream
				space;
				nextPutAll: arg].
	^self performOnServer: stream contents
%

!		Instance methods for 'CypressFileSystemGitRepository'

category: 'accessing'
method: CypressFileSystemGitRepository
currentBranch
  | result |
  result := self
    gitCommand: #('rev-parse' '--abbrev-ref' 'HEAD')
    in: self directoryPath.
  ^ result trimWhiteSpace
%

category: 'git querying'
method: CypressFileSystemGitRepository
gitCloneRepositoryAndCheckoutIn: aDirectoryName workingDirectory: workingDirectory
  "Do a clone on the remote repository and do a checkout on it to get the right branch. Complement the directory as well with the working directory."

  | gitDir branch |
  gitDir := workingDirectory , self fileUtils pathNameDelimiter
    , (aDirectoryName subStrings: '/') last.
  branch := self projectBranchOrTag.
  (self fileUtils directoryExists: gitDir)
    ifTrue: [ | targetDirBranch |
      self directoryPath: (self repositoryPath isEmpty
            ifTrue: [ gitDir ]
            ifFalse: [ gitDir , self fileUtils pathNameDelimiter , self repositoryPath ]).
      targetDirBranch := self currentBranch.
      targetDirBranch = branch
        ifFalse: [ self error: self class name asString
                ,
                  ' target directory already exists and is on another branch, cancelling clone and repository instanciation : '
                , gitDir ] ]
    ifFalse: [ self gitCommand: #('clone') , {'-b'.
              branch} , {remoteUrl.
              gitDir} in: workingDirectory.
      self directoryPath: (self repositoryPath isEmpty
            ifTrue: [ gitDir ]
            ifFalse: [ gitDir , self fileUtils pathNameDelimiter , self repositoryPath ]) ]
%

category: 'git querying'
method: CypressFileSystemGitRepository
gitCommand: aCommandString in: aDirectory
  ^ self class runGitCommand: aCommandString in: aDirectory
%

category: 'initializing - private'
method: CypressFileSystemGitRepository
initializeRepositoryDirectory
  self remoteUrl: self url httpsAccessString.
  self
    gitCloneRepositoryAndCheckoutIn: self projectPath
    workingDirectory: self class gitRepositoryDir.
  (self isGitRepository: self directoryPath)
    ifFalse: [ self error: 'This url is not a git repository' , self url printString ]
%

category: 'git querying'
method: CypressFileSystemGitRepository
isGitRepository: aDirectory
  "Check that we have a git repository"

  | gitPath |
  gitPath := self gitCommand: #('rev-parse' '--show-toplevel') in: aDirectory.
  (gitPath indexOfSubCollection: 'fatal:' startingAt: 1 ifAbsent: [ 0 ]) = 1
    ifTrue: [ ^ false ].
  ^ true
%

category: 'accessing'
method: CypressFileSystemGitRepository
projectBranchOrTag
  "right now only expect to work with branches"

  ^ self url projectBranchOrTag
%

category: 'accessing'
method: CypressFileSystemGitRepository
projectPath
  ^ self url projectPath
%

category: 'accessing'
method: CypressFileSystemGitRepository
remoteUrl

   ^remoteUrl
%

category: 'accessing'
method: CypressFileSystemGitRepository
remoteUrl: anObject

   remoteUrl := anObject
%

category: 'accessing'
method: CypressFileSystemGitRepository
repositoryPath
  ^ self url repositoryPath
%

category: 'validating - private'
method: CypressFileSystemGitRepository
validateUrl
  "At this level, there is nothing to check.
	 But different URLs denote different kinds of repositories, and
	 each kind of repository may have specific checks."

  (self url projectPath isEmpty or: [ self url projectBranchOrTag isEmpty ])
    ifTrue: [ self error: self printString , ' should not be used with non-git URLs.' ]
%

! Class implementation for 'CypressFileUtilities'

!		Class methods for 'CypressFileUtilities'

category: 'accessing'
classmethod: CypressFileUtilities
current

	^Current
%

category: 'utilities'
classmethod: CypressFileUtilities
deleteAll: aDirectory

	self subclassResponsibility: #deleteAll:
%

category: 'utilities'
classmethod: CypressFileUtilities
deleteAll: aDirectory rejecting: rejectBlock
  self subclassResponsibility: #'deleteAll:rejecting:'
%

category: 'utilities'
classmethod: CypressFileUtilities
directoryEntriesFrom: aDirectory

	self subclassResponsibility: #directoryEntriesFrom:
%

category: 'utilities'
classmethod: CypressFileUtilities
directoryExists: aDirectory

	self subclassResponsibility: #directoryExists:
%

category: 'unknown'
classmethod: CypressFileUtilities
directoryFileNamesAndContents: aDirectory

	self subclassResponsibility: #directoryFileNamesAndContents:
%

category: 'utilities'
classmethod: CypressFileUtilities
directoryFromPath: directoryPath relativeTo: aDirectory

	self subclassResponsibility: #directoryFromPath:relativeTo:
%

category: 'utilities'
classmethod: CypressFileUtilities
ensureDirectoryExists: aDirectory

	self subclassResponsibility: #ensureDirectoryExists:
%

category: 'initializating'
classmethod: CypressFileUtilities
install

	Current := self
%

category: 'utilities'
classmethod: CypressFileUtilities
localNameFrom: aDirectory

	self subclassResponsibility: #localNameFrom:
%

category: 'utilities'
classmethod: CypressFileUtilities
pathNameDelimiter

	self subclassResponsibility: #pathNameDelimiter
%

category: 'utilities'
classmethod: CypressFileUtilities
readStreamFor: filePath do: aOneArgBlock

	self subclassResponsibility: #readStreamFor:do:
%

category: 'utilities'
classmethod: CypressFileUtilities
readStreamFor: filePath in: aDirectory do: aOneArgBlock

	self subclassResponsibility: #readStreamFor:in:do:
%

category: 'utilities'
classmethod: CypressFileUtilities
workingDirectory

	self subclassResponsibility: #workingDirectory
%

category: 'utilities'
classmethod: CypressFileUtilities
writeStreamFor: filePath in: aDirectory do: aOneArgBlock

	self subclassResponsibility: #writeStreamFor:in:do:
%

! Class implementation for 'CypressGemStoneDirectoryUtilities'

!		Class methods for 'CypressGemStoneDirectoryUtilities'

category: 'utilities'
classmethod: CypressGemStoneDirectoryUtilities
deleteAll: aDirectory
  "Delete all the files and directories under the named directory.
	 Ensure we don't try to recursively delete . or .."

  self deleteAll: aDirectory rejecting: [ :filename | false ]
%

category: 'utilities'
classmethod: CypressGemStoneDirectoryUtilities
deleteAll: aDirectory rejecting: rejectBlock
	"Delete all the files and directories under the named directory.
       Reject file and directores in aDirectory that are rejected by rejectBlock.
       The rejectBlock is not used recursively.
       Ensure we don't try to recursively delete . or .."

	| filename isFile |
	(GsFile contentsAndTypesOfDirectory: aDirectory onClient: false)
		doWithIndex: 
			[:each :index |
			index odd
				ifTrue: [filename := each]
				ifFalse: 
					[isFile := each.
					isFile
						ifTrue: 
							[(rejectBlock value: filename)
								ifFalse: 
									[(rejectBlock value: filename) ifFalse: [GsFile removeServerFile: filename]]]
						ifFalse: 
							[(self endsWithSpecial: filename)
								ifFalse: 
									[(rejectBlock value: filename)
										ifFalse: 
											[self deleteAll: filename rejecting: rejectBlock.
											GsFile removeServerDirectory: filename]]]]]
%

category: 'utilities'
classmethod: CypressGemStoneDirectoryUtilities
directoryEntriesFrom: aDirectory
	"Answer fully qualified paths to the contents of aDirectory."

	^(GsFile contentsOfDirectory: aDirectory onClient: false) ifNil: [#()]
%

category: 'utilities'
classmethod: CypressGemStoneDirectoryUtilities
directoryExists: aDirectory

	"handle the case where GsFile class>>existsOnServer: returns nil"
	^ (GsFile existsOnServer: aDirectory) == true
%

category: 'utilities'
classmethod: CypressGemStoneDirectoryUtilities
directoryFileNamesAndContents: aDirectory
	"Walk the directory tree starting at aDirectory and
	 answer a map of the names of the files in the tree to
	 their contents (which work best when text)."

	| map |
	map := Dictionary new.
	self directoryFileNamesAndContents: aDirectory into: map.
	^map.
%

category: 'utilities'
classmethod: CypressGemStoneDirectoryUtilities
directoryFileNamesAndContents: aDirectory into: aDictionary
	"Walk the directory tree starting at aDirectory and
	 answer a map of the names of the files in the tree to
	 their contents (which work best when text)."

	| filename isFile |
	(GsFile contentsAndTypesOfDirectory: aDirectory onClient: false)
		doWithIndex: 
			[:each :index |
			index odd
				ifTrue: [filename := each]
				ifFalse: 
					[isFile := each.
					isFile
						ifTrue: 
							[| file |
							file := GsFile openReadOnServer: filename.
							file isNil
								ifFalse: 
									[aDictionary at: filename put: file contents.
									file close]]
						ifFalse: 
							[(self endsWithSpecial: filename)
								ifFalse: [self directoryFileNamesAndContents: filename into: aDictionary]]]]
%

category: 'utilities'
classmethod: CypressGemStoneDirectoryUtilities
directoryFromPath: directoryPath relativeTo: aDirectory

	| delimiter |
	delimiter := self pathNameDelimiter.
	^(aDirectory last = delimiter last
		or: [(directoryPath indexOfSubCollection: delimiter startingAt: 1 ifAbsent: [ 0 ]) = 1])
			ifTrue: [aDirectory , directoryPath]
			ifFalse: [aDirectory , delimiter , directoryPath]
%

category: 'private'
classmethod: CypressGemStoneDirectoryUtilities
endsWithSpecial: filename
	"Answer true if the given filename ends with any of the special sequences
	'/..' '/.' '\..' '\.', false otherwise."

	| filenameSize finalChars |
	filenameSize := filename size.
	finalChars := filename copyFrom: filenameSize - 1 to: filenameSize.
	finalChars = '/.' ifTrue: [^true].
	finalChars = '\.' ifTrue: [^true].
	finalChars := filename copyFrom: filenameSize - 2 to: filenameSize.
	finalChars = '/..' ifTrue: [^true].
	finalChars = '\..' ifTrue: [^true].
	^false
%

category: 'utilities'
classmethod: CypressGemStoneDirectoryUtilities
ensureDirectoryExists: aDirectory

	| lastSeparator |
	(GsFile existsOnServer: aDirectory) == true ifTrue: [^aDirectory].
	(GsFile createServerDirectory: aDirectory) ifNotNil: [^aDirectory].
	lastSeparator := aDirectory findLastSubString: self pathNameDelimiter startingAt: aDirectory size.
	lastSeparator <= 1 ifTrue: [self error: 'Cannot create directory'].
	self ensureDirectoryExists: (aDirectory copyFrom: 1 to: lastSeparator - 1).
	self ensureDirectoryExists: aDirectory.
%

category: 'initializating'
classmethod: CypressGemStoneDirectoryUtilities
initialize
	"self initialize"

	self install
%

category: 'utilities'
classmethod: CypressGemStoneDirectoryUtilities
localNameFrom: aDirectory

	| endOfPath |
	endOfPath := aDirectory findLastSubString: self pathNameDelimiter startingAt: aDirectory size.
	^aDirectory copyFrom: endOfPath + 1 to: aDirectory size
%

category: 'utilities'
classmethod: CypressGemStoneDirectoryUtilities
pathNameDelimiter

	^'/'
%

category: 'utilities'
classmethod: CypressGemStoneDirectoryUtilities
readStreamFor: filePath do: aOneArgBlock

	| file stream blockResult |
	GsFile serverErrorString.
	file := GsFile openReadOnServer: filePath.
	GsFile serverErrorString ifNotNil: [:errorMessage | self error: errorMessage].
	[stream := ReadStreamPortable on: (String withAll: file contents asByteArray decodeFromUTF8).
	blockResult := aOneArgBlock value: stream] ensure: [file close].
	^ blockResult
%

category: 'utilities'
classmethod: CypressGemStoneDirectoryUtilities
readStreamFor: filePath in: aDirectory do: aOneArgBlock

	^ self
		readStreamFor: (self directoryFromPath: filePath relativeTo: aDirectory)
		do: aOneArgBlock
%

category: 'utilities'
classmethod: CypressGemStoneDirectoryUtilities
workingDirectory

	^System gemEnvironmentVariable: 'PWD'
%

category: 'utilities'
classmethod: CypressGemStoneDirectoryUtilities
writeStreamFor: filePath in: aDirectory do: aOneArgBlock

	| file stream |
	GsFile serverErrorString.
	file := GsFile openWriteOnServer: (self directoryFromPath: filePath relativeTo: aDirectory).
	GsFile serverErrorString ifNotNil: [:errorMessage | self error: errorMessage].
	stream := WriteStreamPortable on: String new.
	[aOneArgBlock value: stream] ensure: [file nextPutAll: stream contents encodeAsUTF8; close]
%

! Class implementation for 'CypressGsGeneralDependencySorter'

!		Class methods for 'CypressGsGeneralDependencySorter'

category: 'instance creation'
classmethod: CypressGsGeneralDependencySorter
on: someCandidates dependsOn: aOneArgBlock dependent: anotherOneArgBlock
	"Create an instance of the receiver capable for sorting the dependencies of someCandidates.
	 aOneArgBlock is used to evaluate the key of the object depended on for a candidate.
	 anotherOneArgBlock is used to evaluate the key of the candidate itself."

	^self new
		initializeOn: someCandidates dependsOn: aOneArgBlock dependent: anotherOneArgBlock;
		yourself.
%

!		Instance methods for 'CypressGsGeneralDependencySorter'

category: 'sorting - private'
method: CypressGsGeneralDependencySorter
determineGraphRoots
  ^ dependencyGraphs
    selectAssociations: [ :each | (candidateAliasMap includesKey: each key) not ]
%

category: 'initializing - private'
method: CypressGsGeneralDependencySorter
initializeOn: someCandidates dependsOn: aOneArgBlock dependent: anotherOneArgBlock

	candidates := someCandidates.
	dependsOnConverter := aOneArgBlock.
	dependentConverter := anotherOneArgBlock.
	individualDependencyMap := Dictionary new.
	dependencyGraphs := Dictionary new.
	candidateAliasMap := Dictionary new
%

category: 'sorting'
method: CypressGsGeneralDependencySorter
inOrder
  | sorted sortedRoots |
  sorted := OrderedCollection new.
  self mapCandidatesIntoGraphs.
  sortedRoots := SortedCollection sortBlock: [ :a :b | a key <= b key ].
  self determineGraphRoots associationsDo: [ :assoc | sortedRoots add: assoc ].
  sortedRoots do: [ :assoc | self transcribeGraph: assoc value into: sorted ].
  ^ sorted
%

category: 'sorting - private'
method: CypressGsGeneralDependencySorter
mapCandidatesIntoGraphs

	| dependsOnKey dependentKey |
	candidates do: 
			[:each |
			| individualDependency |
			dependsOnKey := dependsOnConverter value: each.
			dependentKey := dependentConverter value: each.
			candidateAliasMap at: dependentKey put: each.
			individualDependencyMap at: dependsOnKey ifAbsentPut: [Dictionary new].
			individualDependencyMap at: dependentKey ifAbsentPut: [Dictionary new].
			individualDependency := individualDependencyMap
						associationAt: dependsOnKey.
			(dependencyGraphs includesKey: dependsOnKey)
				ifFalse: [dependencyGraphs add: individualDependency].
			individualDependency value
				add: (individualDependencyMap associationAt: dependentKey)]
%

category: 'sorting - private'
method: CypressGsGeneralDependencySorter
transcribeGraph: subtree into: sorted
  (subtree keys asSortedCollection: [ :a :b | a <= b ])
    do: [ :name | | subsubtree |
      subsubtree := subtree at: name.
      sorted add: (candidateAliasMap at: name).
      self transcribeGraph: subsubtree into: sorted ]
%

! Class implementation for 'CypressJsonParser'

!		Class methods for 'CypressJsonParser'

category: 'instance creation'
classmethod: CypressJsonParser
new

	CypressJsonError signal: 'Instantiate the parser with a stream.'
%

category: 'instance creation'
classmethod: CypressJsonParser
on: aStream
	^ self basicNew initializeOn: aStream
%

category: 'accessing'
classmethod: CypressJsonParser
parse: aString
	^ self parseStream: aString readStream
%

category: 'accessing'
classmethod: CypressJsonParser
parseStream: aStream
	^ (self on: aStream) parse
%

!		Instance methods for 'CypressJsonParser'

category: 'adding'
method: CypressJsonParser
addProperty: anAssociation to: anObject
	"Add the property anAssociation described with key and value to anObject. Subclasses might want to refine this implementation."
	
	^ anObject 
		add: anAssociation;
		yourself
%

category: 'adding'
method: CypressJsonParser
addValue: anObject to: aCollection
	"Add anObject to aCollection. Subclasses might want to refine this implementation."

	^ aCollection copyWith: anObject
%

category: 'creating'
method: CypressJsonParser
createArray
	"Create an empty collection. Subclasses might want to refine this implementation."

	^ Array new
%

category: 'creating'
method: CypressJsonParser
createFalse
	"Create the false literal. Subclasses might want to refine this implementation."
	
	^ false
%

category: 'creating'
method: CypressJsonParser
createNull
	"Create the null literal. Subclasses might want to refine this implementation."

	^ nil
%

category: 'creating'
method: CypressJsonParser
createObject
	"Create an empty object. Subclasses might want to refine this implementation."
	
	^ Dictionary new
%

category: 'creating'
method: CypressJsonParser
createProperty: aKey with: aValue
	"Create an empty attribute value pair. Subclasses might want to refine this implementation."
	
	^ aKey -> aValue
%

category: 'creating'
method: CypressJsonParser
createString: aString
	"Create a string literal. Subclasses might want to refine this implementation."

	^ aString
%

category: 'creating'
method: CypressJsonParser
createTrue
	"Create the true literal. Subclasses might want to refine this implementation."

	^ true
%

category: 'private'
method: CypressJsonParser
expect: aString
	"Expects aString and consume input, throw an error otherwise."

	^(self match: aString)
		ifFalse: [CypressJsonError signal: aString , ' expected']
%

category: 'initialization'
method: CypressJsonParser
initializeOn: aStream
	stream := aStream
%

category: 'private'
method: CypressJsonParser
match: aString
	"Tries to match aString, consume input and answer true if successful."
	
	| position |
	position := stream position.
	aString do: [ :each |
		(stream atEnd or: [ stream next ~= each ]) ifTrue: [ 
			stream position: position.
			^ false ] ].
	self whitespace.
	^ true
%

category: 'parsing'
method: CypressJsonParser
parse

	| result |
	result := self
				whitespace;
				parseValue.
	stream atEnd ifFalse: [CypressJsonError signal: 'end of input expected'].
	^result
%

category: 'parsing'
method: CypressJsonParser
parseArray

	| result |
	self expect: '['.
	result := self createArray.
	(self match: ']') ifTrue: [^result].
	[stream atEnd] whileFalse: 
			[result := self addValue: self parseValue to: result.
			(self match: ']') ifTrue: [^result].
			self expect: ','].
	CypressJsonError signal: 'end of array expected'
%

category: 'parsing-internal'
method: CypressJsonParser
parseCharacter
	| char |
	(char := stream next) = $\ 
		ifFalse: [ ^ char ].
	(char := stream next) = $" 
		ifTrue: [ ^ char ].
	char = $\
		ifTrue: [ ^ char ].
	char = $/
		ifTrue: [ ^ char ].
	char = $b
		ifTrue: [ ^ Character backspace ].
	char = $f
		ifTrue: [ ^ Character newPage ].
	char = $n
		ifTrue: [ ^ Character lf ].
	char = $r
		ifTrue: [ ^ Character cr ].
	char = $t
		ifTrue: [ ^ Character tab ].
	char = $u
		ifTrue: [ ^ self parseCharacterHex ].
	CypressJsonError signal: 'invalid escape character \' , (String with: char)
%

category: 'parsing-internal'
method: CypressJsonParser
parseCharacterHex
  | value |
  value := self parseCharacterHexDigit.
  3 timesRepeat: [ value := (value bitShift: 4) + self parseCharacterHexDigit ].
  ^ Character codePoint: value
%

category: 'parsing-internal'
method: CypressJsonParser
parseCharacterHexDigit
    | digit |
    stream atEnd
        ifFalse: [ 
            digit := stream next codePoint.
            (digit between: 48 and: 57)
                ifTrue: [ ^ digit - 48 ].	"$0"	"$9"
            (digit between: 65 and: 70)
                ifTrue: [ ^ digit - 55 ].	"$A"	"$F"
            (digit between: 97 and: 102)
                ifTrue: [ ^ digit - 87 ]	"$a"	"$f" ].
    CypressJsonError signal: 'hex-digit expected'
%

category: 'parsing-internal'
method: CypressJsonParser
parseNumber
	| negated number |
	negated := stream peek = $-.
	negated ifTrue: [ stream next ].
	number := self parseNumberInteger.
	(stream peek = $.) ifTrue: [
		stream next. 
		number := number + self parseNumberFraction ].
	(stream peek = $e or: [ stream peek = $E ]) ifTrue: [
		stream next.
		number := number * self parseNumberExponent ].
	negated ifTrue: [ number := number negated ].
	self whitespace.
	^ number
%

category: 'parsing-internal'
method: CypressJsonParser
parseNumberExponent
    | number negated |
    number := 0.
    negated := stream peek = $-.
    (negated or: [ stream peek = $+ ])
        ifTrue: [ stream next ].
    [ stream atEnd not and: [ stream peek isDigit ] ] whileTrue: [ number := 10 * number + (stream next codePoint - 48) ].
    negated
        ifTrue: [ number := number negated ].
    ^ 10 raisedTo: number
%

category: 'parsing-internal'
method: CypressJsonParser
parseNumberFraction
    | number power |
    number := 0.
    power := 1.0.
    [ stream atEnd not and: [ stream peek isDigit ] ]
        whileTrue: [ 
            number := 10 * number + (stream next codePoint - 48).
            power := power * 10.0 ].
    ^ number / power
%

category: 'parsing-internal'
method: CypressJsonParser
parseNumberInteger
    | number |
    number := 0.
    [ stream atEnd not and: [ stream peek isDigit ] ] whileTrue: [ number := 10 * number + (stream next codePoint - 48) ].
    ^ number
%

category: 'parsing'
method: CypressJsonParser
parseObject

	| result |
	self expect: '{'.
	result := self createObject.
	(self match: '}') ifTrue: [^result].
	[stream atEnd] whileFalse: 
			[result := self addProperty: self parseProperty to: result.
			(self match: '}') ifTrue: [^result].
			self expect: ','].
	CypressJsonError signal: 'end of object expected'
%

category: 'parsing-internal'
method: CypressJsonParser
parseProperty
	| name value |
	name := self parseString.
	self expect: ':'.
	value := self parseValue.
	^ self createProperty: name with: value.
%

category: 'parsing-internal'
method: CypressJsonParser
parseString
	| result |
	self expect: '"'.
	result := WriteStreamPortable on: String new.
	[ stream atEnd or: [ stream peek = $" ] ] 
		whileFalse: [ result nextPut: self parseCharacter ].
	^ self expect: '"'; createString: result contents
%

category: 'parsing'
method: CypressJsonParser
parseValue
	| char |
	stream atEnd ifFalse: [ 
		char := stream peek.
		char = ${
			ifTrue: [ ^ self parseObject ].
		char = $[
			ifTrue: [ ^ self parseArray ].
		char = $"
			ifTrue: [ ^ self parseString ].
		(char = $- or: [ char between: $0 and: $9 ])
			ifTrue: [ ^ self parseNumber ].
		(self match: 'true')
			ifTrue: [ ^ self createTrue ].
		(self match: 'false')
			ifTrue: [ ^ self createFalse ].
		(self match: 'null')
			ifTrue: [ ^ self createNull ] ].
	CypressJsonError signal: 'invalid input'
%

category: 'private'
method: CypressJsonParser
whitespace
	"Strip whitespaces from the input stream."

	[ stream atEnd not and: [ stream peek isSeparator ] ]
		whileTrue: [ stream next ]
%

! Class implementation for 'CypressObject'

!		Class methods for 'CypressObject'

category: 'miscellany'
classmethod: CypressObject
collection: aCollection gather: aOneArgBlock
	"Evaluate the block once for each element of aCollection. The block should answer a collection. 
	Answer an Array containing all elements of all the answered collections."

	| result |
	result := Array new.
	aCollection do: [:each | result addAll: (aOneArgBlock value: each)].
	^result
%

category: 'miscellany'
classmethod: CypressObject
elementsIn: sourceCollection butNotIn: exclusionCollection

	| exclusionSet |
	exclusionSet := exclusionCollection asSet.
	^sourceCollection reject: [:each | exclusionSet includes: each]
%

category: 'miscellany'
classmethod: CypressObject
elementsInBoth: collection1 and: collection2
	"Set intersection generalized to any collections."

	| temporarySet |
	temporarySet := collection2 asSet.
	^collection1 select: [:each | temporarySet includes: each]
%

category: 'converting'
classmethod: CypressObject
normalizeLineEndingsOf: aString
	"Answer a copy of aString with the line endings normalized to
	 correspond to the current platform, regardless of how they were
	 saved. For example, Squeak uses CR and would normalize with
	 #withSqueakLineEndings, for example.

	 GemStone Smalltalk uses the Unix line ending of LF."

	| cr lf inPos outPos outString newOutPos indexLF indexCR |
	cr := Character cr.
	indexCR := aString indexOf: cr startingAt: 1.
	indexCR = 0 ifTrue: [^aString].
	lf := Character lf.
	indexLF := aString indexOf: lf startingAt: 1.
	indexLF = 0 ifTrue: [^aString copyReplacing: cr with: lf].
	inPos := outPos := 1.
	outString := String new: aString size.
	
	["check if next CR is before next LF or if there are no more LF"
	(indexLF = 0 or: [indexCR < indexLF])
		ifTrue: 
			[newOutPos := outPos + 1 + indexCR - inPos.
			outString
				replaceFrom: outPos
				to: newOutPos - 2
				with: aString
				startingAt: inPos.
			outString at: newOutPos - 1 put: lf.
			outPos := newOutPos.
			1 + indexCR = indexLF
				ifTrue: 
					["Caught a CR-LF pair"
					inPos := 1 + indexLF.
					indexLF := aString indexOf: lf startingAt: inPos]
				ifFalse: [inPos := 1 + indexCR].
			indexCR := aString indexOf: cr startingAt: inPos]
		ifFalse: 
			[newOutPos := outPos + 1 + indexLF - inPos.
			outString
				replaceFrom: outPos
				to: newOutPos - 1
				with: aString
				startingAt: inPos.
			outPos := newOutPos.
			inPos := 1 + indexLF.
			indexLF := aString indexOf: lf startingAt: inPos].
	indexCR = 0]
			whileFalse.

	"no more CR line endings. copy the rest"
	newOutPos := outPos + (aString size - inPos + 1).
	outString
		replaceFrom: outPos
		to: newOutPos - 1
		with: aString
		startingAt: inPos.
	^outString copyFrom: 1 to: newOutPos - 1
%

!		Instance methods for 'CypressObject'

category: 'accessing'
method: CypressObject
allClasses

	| classes |
	classes := Array new.
	self symbolList
		do: [:dict | classes addAll: (dict select: [:each | each isBehavior])].
	^classes
%

category: 'private'
method: CypressObject
anyElementOf: aCollection ifEmpty: aBlock

	aCollection do: [:each | ^each].
	^aBlock value
%

category: 'accessing'
method: CypressObject
classesInPackageNamed: aString

	| packageName classes |
	packageName := aString asLowercase.
	classes := Array new.
	self symbolList do: 
			[:dict |
			classes
				addAll: (dict select: 
							[:each |
							each isBehavior and: 
									[| candidateName |
									candidateName := each category asLowercase.
									candidateName = packageName
										or: [(candidateName indexOfSubCollection: packageName , '-' startingAt: 1 ifAbsent: [ 0 ]) = 1]]])].
	^classes sortAscending: #('name')
%

category: 'miscellany'
method: CypressObject
collection: aCollection gather: aOneArgBlock
	"Evaluate the block once for each element of aCollection. The block should answer a collection. 
	Answer an Array containing all elements of all the answered collections."

	^self class collection: aCollection gather: aOneArgBlock
%

category: 'initializing'
method: CypressObject
defaultSymbolDictionaryName
  "Name of the SymbolDictionary where new classes should be installed"

  ^ #'UserGlobals'
%

category: 'sorting'
method: CypressObject
determineClassHierarchicalOrder: someClasses
	"Returns an ordered collection of the specified classes such that
	 hierarchical dependencies come first."
	"Not sure whether we ever get non-behaviors. 
	The previous, more complex, version of this method contained this filter."

	| order toBeOrdered processed aClass |
	toBeOrdered := (someClasses select: [:each | each isBehavior])
				asIdentitySet.
	order := OrderedCollection new.
	processed := IdentitySet new.
	[(aClass := self anyElementOf: toBeOrdered ifEmpty: [nil]) isNil]
		whileFalse: 
			[self
				orderBySuperclass: aClass
				from: toBeOrdered
				into: order
				ignoring: processed].
	^order
%

category: 'miscellany'
method: CypressObject
elementsIn: sourceCollection butNotIn: exclusionCollection

	^self class elementsIn: sourceCollection butNotIn: exclusionCollection
%

category: 'miscellany'
method: CypressObject
elementsInBoth: collection1 and: collection2
	"Set intersection generalized to any collections."

	^self class elementsInBoth: collection1 and: collection2
%

category: 'initializing'
method: CypressObject
initialize
	"Placeholder: #initialize is not defined by Object in GemStone Smalltalk."
%

category: 'converting'
method: CypressObject
normalizeLineEndingsOf: aString
	"Answer a copy of aString with the line endings normalized to
	 correspond to the current platform, regardless of how they were
	 saved. For example, Squeak uses CR and would normalize with
	 #withSqueakLineEndings, for example."

	^self class normalizeLineEndingsOf: aString.
%

category: 'private'
method: CypressObject
orderBySuperclass: aClass from: toBeOrdered into: order ignoring: processed
	"Private. Add to 'order', superclasses first, aClass and any of its superclasses 
	that appear in 'toBeOrdered' but do not appear in 'processed'.
	Remove from 'toBeOrdered' any class added to 'ordered'.
	Any class seen, add to 'processed' whether or not added to 'order'."

	| superclass |
	superclass := aClass superclass.
	superclass isNil | (processed includes: superclass)
		ifFalse: 
			[self
				orderBySuperclass: superclass
				from: toBeOrdered
				into: order
				ignoring: processed].
	processed add: aClass.
	(toBeOrdered includes: aClass)
		ifTrue: 
			[toBeOrdered remove: aClass.
			order add: aClass]
%

category: 'printing'
method: CypressObject
printDetailsOn: aStream
%

category: 'printing'
method: CypressObject
printOn: aStream

	| className |
	className := self class name.
	aStream
		nextPutAll: (className first isVowel ifTrue:[ 'an ' ] ifFalse:[ 'a ' ]);
		nextPutAll: className;
		nextPutAll: '('.
	self printDetailsOn: aStream.
	aStream nextPutAll: ')'.
%

category: 'accessing'
method: CypressObject
resolveGlobalNamed: aString

	^self resolveGlobalNamed: aString
		or: [CypressError signal: 'Could not resolve global named ' , aString printString]
%

category: 'accessing'
method: CypressObject
resolveGlobalNamed: aString or: aBlock

	^((System myUserProfile resolveSymbol: aString) ifNil: [^aBlock value])
		value
%

category: 'converting'
method: CypressObject
stringForVariables: variableList

	| stream |
	stream := WriteStreamPortable on: (String new: 100).
	variableList do: [:each | stream nextPutAll: each]
		separatedBy: [stream space].
	^stream contents
%

category: 'accessing'
method: CypressObject
symbolDictionaryForClassNamed: aString
  "Answer the SymbolDictionary containing the named class.
	 If there are multiple answers, answer the first.
	 If there are no answers (i.e., the class does not exist), put it in UserGlobals."

  ^ self
    symbolDictionaryForClassNamed: aString
    or: [ System myUserProfile objectNamed: self defaultSymbolDictionaryName ]
%

category: 'accessing'
method: CypressObject
symbolDictionaryForClassNamed: aString or: aBlock
	"Answer the SymbolDictionary containing the named class.
	 If there are multiple answers, answer the first.
	 If there are no answers (i.e., the class does not exist), answer
	 the result of evaluating aBlock."

	^self symbolList asArray
		detect: [:each | each anySatisfy: [:every | every isBehavior and: [every name asString = aString asString]]]
		ifNone: aBlock
%

category: 'accessing'
method: CypressObject
symbolList
  ^ System myUserProfile symbolList
%

! Class implementation for 'CypressAbstractPackageInformation'

!		Class methods for 'CypressAbstractPackageInformation'

category: 'Instance Creation'
classmethod: CypressAbstractPackageInformation
named: aString

	^self new
		initializeWithName: aString;
		yourself
%

!		Instance methods for 'CypressAbstractPackageInformation'

category: 'Initializing - private'
method: CypressAbstractPackageInformation
initialize
%

category: 'Initializing - private'
method: CypressAbstractPackageInformation
initializeWithName: aString

	self initialize.
	self name: aString
%

category: 'Testing'
method: CypressAbstractPackageInformation
isKnown

	^false
%

category: 'Accessing'
method: CypressAbstractPackageInformation
name

	^name
%

category: 'Updating'
method: CypressAbstractPackageInformation
name: aString

	name := aString
%

category: 'Printing'
method: CypressAbstractPackageInformation
printDetailsOn: aStream

	aStream nextPutAll: self name
%

category: 'Accessing'
method: CypressAbstractPackageInformation
repositories

	^#()
%

! Class implementation for 'CypressConflictingPackageInformation'

!		Class methods for 'CypressConflictingPackageInformation'

category: 'Instance Creation'
classmethod: CypressConflictingPackageInformation
fromUnknown: unknownPackageInformation conflictingWith: knownPackageInformation

	^(self named: unknownPackageInformation name)
		conflictsWith: knownPackageInformation;
		yourself.
%

!		Instance methods for 'CypressConflictingPackageInformation'

category: 'Accessing'
method: CypressConflictingPackageInformation
conflictsWith

	^conflictsWith
%

category: 'Updating'
method: CypressConflictingPackageInformation
conflictsWith: someCypressKnownPackageInformations

	conflictsWith := someCypressKnownPackageInformations
%

! Class implementation for 'CypressEclipsedPackageInformation'

!		Class methods for 'CypressEclipsedPackageInformation'

category: 'Instance Creation'
classmethod: CypressEclipsedPackageInformation
fromUnknown: unknownPackageInformation eclipsedBy: knownPackageInformation

	^(self named: unknownPackageInformation name)
		eclipsedBy: knownPackageInformation;
		yourself.
%

!		Instance methods for 'CypressEclipsedPackageInformation'

category: 'Accessing'
method: CypressEclipsedPackageInformation
eclipsedBy

	^eclipsedBy
%

category: 'Updating'
method: CypressEclipsedPackageInformation
eclipsedBy: aPackageInformation

	eclipsedBy := aPackageInformation
%

! Class implementation for 'CypressKnownPackageInformation'

!		Class methods for 'CypressKnownPackageInformation'

category: 'Instance Creation'
classmethod: CypressKnownPackageInformation
fromUnknown: aPackageInformation

	^self named: aPackageInformation name
%

!		Instance methods for 'CypressKnownPackageInformation'

category: 'Updating'
method: CypressKnownPackageInformation
addRepository: aRepository

	self repositories at: aRepository url put: aRepository.
	self updateDigestsFromImageAndRepository: aRepository.
%

category: 'Accessing - digests'
method: CypressKnownPackageInformation
determineDigestFromImage

	^self packageStructure digest
%

category: 'Accessing - digests'
method: CypressKnownPackageInformation
determineDigestFromRepository: aRepository

	^ (aRepository readPackageStructureForPackageNamed: self name) digest.
%

category: 'Accessing - digests'
method: CypressKnownPackageInformation
digestFor: source

	^self digestFor: source or: [nil]
%

category: 'Accessing - digests'
method: CypressKnownPackageInformation
digestFor: source or: aBlock

	^self digests at: source ifAbsent: aBlock
%

category: 'Accessing - digests'
method: CypressKnownPackageInformation
digests

	^digests
%

category: 'Initializing - private'
method: CypressKnownPackageInformation
digests: anIdentityDictionary
	"Key: Source of package definitions (#IMAGE or a Repository url)
	 Value: (e.g. MD5) Digest of the package's defintions or an empty string.
	 A nil digest means there are no definitions for the given source."

   digests := anIdentityDictionary
%

category: 'Accessing - digests'
method: CypressKnownPackageInformation
imageDigest

	^self digestFor: #IMAGE.
%

category: 'Initializing - private'
method: CypressKnownPackageInformation
initialize

	super initialize.
	self
		repositories: IdentityDictionary new;
		digests: IdentityDictionary new.
%

category: 'Testing'
method: CypressKnownPackageInformation
isKnown

	^true
%

category: 'Accessing - digests'
method: CypressKnownPackageInformation
packageStructure

	^CypressPackageStructure
		fromPackage: (CypressPackageDefinition named: self name)
%

category: 'Updating'
method: CypressKnownPackageInformation
removeRepository: aRepository

	self repositories removeKey: aRepository url ifAbsent: [].
	self digests removeKey: aRepository url ifAbsent: [].
	self updateDigestsFromImage.
%

category: 'Accessing'
method: CypressKnownPackageInformation
repositories

	^repositories
%

category: 'Initializing - private'
method: CypressKnownPackageInformation
repositories: anIdentityDictionary
	"Key: Repository url
	 Value: Repository"

	repositories := anIdentityDictionary
%

category: 'Accessing - digests'
method: CypressKnownPackageInformation
repositoryDigests

	^self repositories collect: [:each | self digestFor: each url]
%

category: 'Updating - digests'
method: CypressKnownPackageInformation
updateDigestsFromAllRepositories

	self repositories do: [:each | self updateDigestsFromRepository: each]
%

category: 'Updating - digests'
method: CypressKnownPackageInformation
updateDigestsFromImage

	self digests at: #IMAGE put: self determineDigestFromImage
%

category: 'Updating - digests'
method: CypressKnownPackageInformation
updateDigestsFromImageAndAllRepositories

	self
		updateDigestsFromImage;
		updateDigestsFromAllRepositories
%

category: 'Updating - digests'
method: CypressKnownPackageInformation
updateDigestsFromImageAndRepository: aRepository

	self
		updateDigestsFromImage;
		updateDigestsFromRepository: aRepository
%

category: 'Updating - digests'
method: CypressKnownPackageInformation
updateDigestsFromRepository: aRepository

	self digests at: aRepository url put: (self determineDigestFromRepository: aRepository).
%

category: 'Writing'
method: CypressKnownPackageInformation
writeChangesToAllRepositories

	| imageDigest changedDigests changedRepositories |
	self updateDigestsFromImageAndAllRepositories.
	imageDigest := self imageDigest.
	changedDigests := self repositoryDigests reject: [:each | each = imageDigest].
	changedRepositories := changedDigests keys collect: [:each | self repositories at: each].
	self writePackageToRepositories: changedRepositories.
%

category: 'Writing'
method: CypressKnownPackageInformation
writePackageToRepositories: someRepositories

	| packageStructure |
	packageStructure := self packageStructure.
	^someRepositories
		do: [:each | each writePackageStructure: packageStructure]
%

! Class implementation for 'CypressDefinition'

!		Instance methods for 'CypressDefinition'

category: 'comparing'
method: CypressDefinition
= aDefinition

	^(aDefinition isKindOf: CypressDefinition)
		and: [aDefinition description = self description]
%

category: 'loading'
method: CypressDefinition
actualClass

	self subclassResponsibility: #actualClass
%

category: 'visiting'
method: CypressDefinition
classDefinition: classBlock methodDefinition: methodBlock
	"default is noop"
%

category: 'accessing'
method: CypressDefinition
description
	self subclassResponsibility: #description
%

category: 'accessing'
method: CypressDefinition
details

	| stream |
	stream := WriteStreamPortable on: (String new: 100).
	self printDetailsOn: stream.
	^stream contents
%

category: 'comparing'
method: CypressDefinition
hash
    ^ self description hash
%

category: 'testing'
method: CypressDefinition
isSameRevisionAs: aDefinition
	^ self = aDefinition
%

category: 'loading'
method: CypressDefinition
loadClassDefinition
  self loadClassDefinition: self defaultSymbolDictionaryName
%

category: 'loading'
method: CypressDefinition
loadClassDefinition: aDefaultSymbolDictionaryName
  "default is to do nothing"
%

category: 'loading'
method: CypressDefinition
loadMethodDefinition
	"default is to do nothing"
%

category: 'loading'
method: CypressDefinition
postLoad
	"noop"
%

category: 'loading'
method: CypressDefinition
postLoadOver: aDefinition

	self postLoad
%

category: 'dependency'
method: CypressDefinition
provisions
	"Answer list of global names defined by this definition"

	^#()
%

category: 'dependency'
method: CypressDefinition
requirements
	"Answer list of global names required by this definition"

	^#()
%

category: 'loading'
method: CypressDefinition
unloadDefinition

	self subclassResponsibility: #unloadDefinition
%

! Class implementation for 'CypressClassDefinition'

!		Class methods for 'CypressClassDefinition'

category: 'instance creation'
classmethod: CypressClassDefinition
forClass: aClass

	| superclassname |
	superclassname := aClass superclass
				ifNil: ['nil']
				ifNotNil: [:sClass | sClass name].
	^self
		name: aClass name
		superclassName: superclassname
		category: aClass category
		instVarNames: aClass instVarNames
		classInstVarNames: aClass class instVarNames
		classVarNames: aClass classVarNames
		poolDictionaryNames: aClass sharedPools
		comment: aClass rwComment
		subclassType: (self subclassTypeOf: aClass)
%

category: 'private'
classmethod: CypressClassDefinition
subclassTypeOf: aClass
	"Answer a description of the argument to identify whether it is a regular class,
	 a byte subclass, or an indexable subclass."

	^(aClass isBytes and: [aClass superClass isBytes not])
		ifTrue: ['byteSubclass']
		ifFalse: 
			[(aClass isIndexable and: [aClass superClass isIndexable not])
				ifTrue: ['indexableSubclass']
				ifFalse: ['']]
%

!		Instance methods for 'CypressClassDefinition'

category: 'comparing'
method: CypressClassDefinition
= aDefinition
  ^ super = aDefinition
    and: [ 
      superclassName = aDefinition superclassName
        and: [ 
          category = aDefinition category
            and: [ 
              instVarNames = aDefinition instVarNames
                and: [ 
                  classInstVarNames = aDefinition classInstVarNames
                    and: [ 
                      classVarNames asSortedCollection = aDefinition classVarNames asSortedCollection
                        and: [ 
                          poolDictionaryNames = aDefinition poolDictionaryNames
                            and: [ comment = aDefinition comment ] ] ] ] ] ] ]
%

category: 'loading'
method: CypressClassDefinition
actualClass

	^self resolveGlobalNamed: self name
%

category: 'loading'
method: CypressClassDefinition
actualClassOrNil

	^self resolveGlobalNamed: self name or: [nil]
%

category: 'converting'
method: CypressClassDefinition
asCypressClassDefinition

	^self
%

category: 'accessing'
method: CypressClassDefinition
category

	^category
%

category: 'visiting'
method: CypressClassDefinition
classDefinition: classBlock methodDefinition: methodBlock

	classBlock value: self
%

category: 'accessing'
method: CypressClassDefinition
classDefinitionCreationString

	| stream symbolDict |
	stream := WriteStreamPortable on: (String new: 100).
	stream
		nextPutAll: '(CypressClassDefinition';
		lf;
		tab;
		nextPutAll: 'name: ' , self className printString;
		lf;
		tab;
		nextPutAll: 'superclassName: ' , self superclassName printString;
		lf;
		tab;
		nextPutAll: 'category: ' , self category printString;
		lf;
		tab;
		nextPutAll: 'instVarNames: #(' , self instanceVariablesString , ')';
		lf;
		tab;
		nextPutAll: 'classInstVarNames: #(' , self classInstanceVariablesString
					, ')';
		lf;
		tab;
		nextPutAll: 'classVarNames: #(' , self classVariablesString , ')';
		lf;
		tab;
		nextPutAll: 'poolDictionaryNames: #(' , self poolDictionariesString , ')';
		lf;
		tab;
		nextPutAll: 'comment: ' , self comment printString;
		lf;
		tab;
		nextPutAll: 'subclassType: ' , self subclassType printString , ')';
		lf;
		tab;
		tab;
		yourself.
	symbolDict := self symbolDictionaryForClassNamed: self className.
	self actualClassOrNil isNil
		ifTrue: 
			[stream
				nextPutAll: 'loadClassDefinition.';
				yourself]
		ifFalse: 
			[stream
				nextPutAll: 'loadClassDefinition: ' , symbolDict name asString printString
							, '.';
				yourself].
	^stream contents
%

category: 'private'
method: CypressClassDefinition
classInstanceVariablesString
  ^ self stringForVariables: self classInstVarNames
%

category: 'accessing'
method: CypressClassDefinition
classInstVarNames
  ^ classInstVarNames
%

category: 'accessing'
method: CypressClassDefinition
className

	^self name
%

category: 'loading'
method: CypressClassDefinition
classNeedingMigration: aClass
  "right now we will create classes without doing a migration ..."

  
%

category: 'private'
method: CypressClassDefinition
classVariablesString
  ^ self stringForVariables: self classVarNames asSortedCollection
%

category: 'accessing'
method: CypressClassDefinition
classVarNames
  ^ classVarNames sort
%

category: 'accessing'
method: CypressClassDefinition
comment

	^comment
%

category: 'loading'
method: CypressClassDefinition
createOrReviseByteClass
	"To be resolved:
		- the question of an 'environment' in which to create the class.
		- the question of which SymbolDictionary in which to create the class.
	 These are perhaps the same question."

	| superClass |
	superClass := self resolveGlobalNamed: self superclassName.
	^(superClass
		byteSubclass: self name
		classVars: (self classVarNames collect: [:each | each asSymbol])
		classInstVars: (self classInstVarNames collect: [:each | each asSymbol])
		poolDictionaries: self poolDictionaryList
		inDictionary: (self symbolDictionaryForClassNamed: self name)
		options: #())
			category: category;
			comment: self comment
%

category: 'loading'
method: CypressClassDefinition
createOrReviseIndexableClass
	"To be resolved:
		- the question of an 'environment' in which to create the class.
		- the question of which SymbolDictionary in which to create the class.
	 These are perhaps the same question."

	| superClass |
	superClass := self resolveGlobalNamed: self superclassName.
	^(superClass
		indexableSubclass: self name
		instVarNames: (self instVarNames collect: [:each | each asSymbol])
		classVars: (self classVarNames collect: [:each | each asSymbol])
		classInstVars: (self classInstVarNames collect: [:each | each asSymbol])
		poolDictionaries: self poolDictionaryList
		inDictionary: (self symbolDictionaryForClassNamed: self name)
		options: #())
			category: category;
			comment: self comment
%

category: 'loading'
method: CypressClassDefinition
createOrReviseRegularClass
	"To be resolved:
		- the question of an 'environment' in which to create the class.
		- the question of which SymbolDictionary in which to create the class.
	 These are perhaps the same question."

	| superClass |
	superClass := self resolveGlobalNamed: self superclassName.
	^(superClass
		subclass: self name
		instVarNames: (self instVarNames collect: [:each | each asSymbol])
		classVars: (self classVarNames collect: [:each | each asSymbol])
		classInstVars: (self classInstVarNames collect: [:each | each asSymbol])
		poolDictionaries: self poolDictionaryList
		inDictionary: (self symbolDictionaryForClassNamed: self name)
		options: #())
			category: category;
			comment: self comment
%

category: 'accessing'
method: CypressClassDefinition
defaultSymbolDictionaryName
  ^ defaultSymbolDictionaryName ifNil: [ super defaultSymbolDictionaryName ]
%

category: 'accessing'
method: CypressClassDefinition
defaultSymbolDictionaryName: aSymbol
  defaultSymbolDictionaryName := aSymbol
%

category: 'accessing'
method: CypressClassDefinition
description

	^ Array with: name
%

category: 'loading'
method: CypressClassDefinition
failedCompiledMethods: someCompiledMethods

	someCompiledMethods isEmpty ifTrue: [^self].
	self halt: 'not implemented yet'
%

category: 'accessing'
method: CypressClassDefinition
gs_constraints

	^gs_constraints ifNil: [ gs_constraints := #() ]
%

category: 'accessing'
method: CypressClassDefinition
gs_constraints: aCollection

	gs_constraints := aCollection
%

category: 'accessing'
method: CypressClassDefinition
gs_options

	^gs_options ifNil: [ gs_options := #() ]
%

category: 'accessing'
method: CypressClassDefinition
gs_options: aCollection

	gs_options := aCollection
%

category: 'accessing'
method: CypressClassDefinition
gs_reservedOop
	^ ''
%

category: 'comparing'
method: CypressClassDefinition
hash

	| hash |
	hash := name hash.
	hash := superclassName hash bitOr: hash.
	hash := (category ifNil: ['']) hash bitOr: hash.
	instVarNames , classInstVarNames, classVarNames, poolDictionaryNames
		do: [:vName | hash := vName hash bitOr: hash].
	^hash
%

category: 'private'
method: CypressClassDefinition
instanceVariablesString
    ^ self stringForVariables: self instVarNames
%

category: 'accessing'
method: CypressClassDefinition
instVarNames
  ^ instVarNames
%

category: 'testing'
method: CypressClassDefinition
isClassDefinition
  ^ true
%

category: 'testing'
method: CypressClassDefinition
isMethodDefinition
  ^ false
%

category: 'loading'
method: CypressClassDefinition
loadClassDefinition
  "Create a new version of the defined class. If the class already exists,
	 copy the behaviors and state from the old version."

  ^ self loadClassDefinition: self defaultSymbolDictionaryName
%

category: 'loading'
method: CypressClassDefinition
loadClassDefinition: aDefaultSymbolDictionaryName
	"Create a new version of the defined class. If the class already exists,
	 copy the behaviors and state from the old version."

	| newClass oldClass |
        self defaultSymbolDictionaryName: aDefaultSymbolDictionaryName.
	oldClass := self actualClassOrNil.
	newClass := self createOrReviseClass.
	(oldClass isNil or: [newClass == oldClass]) ifTrue: [^self].
	self classNeedingMigration: newClass.
	self
		recompileWithSubclassesFrom: oldClass
		to: newClass
		symbolList: System myUserProfile symbolList.
%

category: 'accessing'
method: CypressClassDefinition
name

	^name
%

category: 'initialization'
method: CypressClassDefinition
name: aClassName superclassName: aSuperclassName category: aCategory instVarNames: someInstanceVariableNames classInstVarNames: someClassInstanceVariableNames classVarNames: someClassVariableNames poolDictionaryNames: somePoolDictionaryNames comment: aComment subclassType: aSubclassType

	name := aClassName.
	superclassName := aSuperclassName.
	category := aCategory.
	instVarNames := someInstanceVariableNames.
	classInstVarNames := someClassInstanceVariableNames.
	classVarNames := someClassVariableNames.
	poolDictionaryNames := somePoolDictionaryNames.
	comment := aComment.
	subclassType := aSubclassType asString
%

category: 'initialization'
method: CypressClassDefinition
name: aClassName superclassName: aSuperclassName category: aCategory instVarNames: someInstanceVariableNames 
	classInstVarNames: someClassInstanceVariableNames classVarNames: someClassVariableNames 
	poolDictionaryNames: somePoolDictionaryNames gs_options: someGs_options gs_constraints: someGs_constraints
	comment: aComment subclassType: aSubclassType

	name := aClassName.
	superclassName := aSuperclassName.
	category := aCategory.
	instVarNames := someInstanceVariableNames.
	classInstVarNames := someClassInstanceVariableNames.
	classVarNames := someClassVariableNames.
	poolDictionaryNames := somePoolDictionaryNames.
	gs_options := someGs_options.
	gs_constraints := someGs_constraints.
	comment := aComment.
	subclassType := aSubclassType asString
%

category: 'loading'
method: CypressClassDefinition
poolDictionariesForNames: pdNames
  | ar existingDict symList sharedPool |
  ar := Array new.
  symList := System myUserProfile symbolList.
  pdNames
    do: [ :poolName | 
      existingDict := symList objectNamed: poolName.
      existingDict
        ifNil: [ 
          | pool |
          pool := SymbolDictionary new.
          pool name: poolName asSymbol.
          ar add: pool ]
        ifNotNil: [ 
          (existingDict isKindOf: SymbolDictionary)
            ifTrue: [ ar add: existingDict ]
            ifFalse: [ 
              sharedPool ifNil: [ sharedPool := symList objectNamed: #'SharedPool' ].
              ((existingDict isKindOf: Class)
                and: [ existingDict isSubclassOf: sharedPool ])
                ifTrue: [ 
                  | cvars pName |
                  ar add: (cvars := existingDict _createClassVarsDict).
                  pName := poolName asSymbol.	"only change dictionary name if needed , to avoid SecurityError"
                  cvars name ~~ pName
                    ifTrue: [ cvars name: pName ] ] ] ] ].
  ^ ar
%

category: 'private'
method: CypressClassDefinition
poolDictionariesString
  ^ self stringForVariables: self poolDictionaryNames
%

category: 'loading'
method: CypressClassDefinition
poolDictionaryList

  ^ self poolDictionariesForNames: self poolDictionaryNames
%

category: 'accessing'
method: CypressClassDefinition
poolDictionaryNames

	^poolDictionaryNames
%

category: 'printString'
method: CypressClassDefinition
printDetailsOn: aStream

	aStream nextPutAll: self name
%

category: 'dependency'
method: CypressClassDefinition
provisions
	"Answer list of global names defined by this definition"

	^{ self name }
%

category: 'loading'
method: CypressClassDefinition
recompileWithSubclassesFrom: oldClass to: newClass symbolList: aSymbolList

	| olds news removedClassVariables removedSharedPools organizer subclasses newSubclass |
	olds := oldClass _classVars ifNil: [#()] ifNotNil: [:vars | vars keys].
	news := newClass _classVars ifNil: [#()] ifNotNil: [:vars | vars keys].
	removedClassVariables := self elementsIn: olds butNotIn: news.
	removedSharedPools := self elementsIn: oldClass sharedPools
				butNotIn: newClass sharedPools.
	self failedCompiledMethods: (newClass
				_copyMethodsAndVariablesFrom: oldClass
				except: 
					{$V.
					removedClassVariables.
					$P.
					removedSharedPools}
				dictionaries: aSymbolList).
	organizer := ClassOrganizer new.
	subclasses := organizer subclassesOf: oldClass.


	"Do this -after- #subclassesOf:, which has the side effect of replacing the new
	  class with the old class in the organizer"
	organizer addClass: newClass.

	"Iterate over all the first-level subclasses of the old class to create new subclasses"
	subclasses do: 
			[:oldSubclass |
			newSubclass := 
					[oldSubclass definition evaluateInContext: nil symbolList: aSymbolList]
							on: Error
							do: [:ex | ex return: nil].
			(newSubclass notNil and: [newSubclass ~~ oldSubclass])
				ifTrue: 
					[self
						classNeedingMigration: newSubclass;
						recompileWithSubclassesFrom: oldSubclass
							to: newSubclass
							symbolList: aSymbolList]]
%

category: 'dependency'
method: CypressClassDefinition
requirements
	"Answer list of global names required by this definition"

  self superclassName = 'nil'
    ifTrue: [ ^ #() ].
  ^{self superclassName}
%

category: 'accessing'
method: CypressClassDefinition
subclassType

	^subclassType
%

category: 'accessing'
method: CypressClassDefinition
superclassName

	^superclassName
%

category: 'loading'
method: CypressClassDefinition
unloadDefinition
	"GemStone could hold multiple definitions of the same class name.
	 Ignore aliased references.
	 Unload only the first one resolved.
	 It is an error if there is not at least one SymbolDictionary holding a
	 class with that name."

	| dictionarySymbolPair |
	dictionarySymbolPair := ((System myUserProfile symbolList
				dictionariesAndSymbolsOf: self actualClass)
					select: [:each | each last = self name asSymbol]) first.
	dictionarySymbolPair first removeKey: dictionarySymbolPair last
%

! Class implementation for 'CypressMethodDefinition'

!		Class methods for 'CypressMethodDefinition'

category: 'instance creation'
classmethod: CypressMethodDefinition
className: aName classIsMeta: isMetaclass selector: aSelector category: aCategory source: aSource

	^self new
		className: aName asString
		classIsMeta: isMetaclass
		selector: aSelector asString
		category: aCategory asString
		source: (self normalizeLineEndingsOf: aSource)
%

category: 'instance creation'
classmethod: CypressMethodDefinition
forMethod: aGsNMethod

	| behavior selector |
	behavior := aGsNMethod inClass.
	selector := aGsNMethod selector.
	^self new
		className: behavior theNonMetaClass name asString
		classIsMeta: behavior isMeta
		selector: selector asString
		category: (behavior categoryOfSelector: selector) asString
		source: (self normalizeLineEndingsOf: aGsNMethod sourceString asString)
%

!		Instance methods for 'CypressMethodDefinition'

category: 'comparing'
method: CypressMethodDefinition
= aDefinition
    ^ super = aDefinition
        and: [ aDefinition source = self source
                and: [ aDefinition category = self category ] ]
%

category: 'loading'
method: CypressMethodDefinition
actualClass

  ^ self theNonMetaClass
    ifNotNil: [:cls |
      self classIsMeta
        ifTrue: [ cls class ]
        ifFalse: [ cls  ] ].
%

category: 'converting'
method: CypressMethodDefinition
asCypressMethodDefinition

	^self
%

category: 'accessing'
method: CypressMethodDefinition
category

	^category
%

category: 'visiting'
method: CypressMethodDefinition
classDefinition: classBlock methodDefinition: methodBlock

	methodBlock value: self
%

category: 'accessing'
method: CypressMethodDefinition
classIsMeta

	^classIsMeta
%

category: 'accessing'
method: CypressMethodDefinition
className

	^className
%

category: 'initialization'
method: CypressMethodDefinition
className: aName classIsMeta: isMetaclass selector: aSelector category: aCategory source: aSource

	className := aName.
	classIsMeta := isMetaclass.
	selector := aSelector.
	category := aCategory.
	source := self normalizeLineEndingsOf: aSource
%

category: 'accessing'
method: CypressMethodDefinition
description
	^ Array	
		with: className
		with: selector
		with: classIsMeta
%

category: 'comparing'
method: CypressMethodDefinition
hash

	| hash |
	hash := classIsMeta asString hash.
	hash := source hash bitOr: hash.
	hash := category hash bitOr: hash.
	hash := className hash bitOr: hash.
	^hash
%

category: 'visiting'
method: CypressMethodDefinition
instanceMethod: instanceBlock classMethod: classBlock

	^(self classIsMeta
		ifTrue: [ classBlock ]
		ifFalse: [ instanceBlock ]) value: self
%

category: 'testing'
method: CypressMethodDefinition
isClassDefinition
  ^ false
%

category: 'testing'
method: CypressMethodDefinition
isInitializer
	^ self selector = 'initialize' and: [self classIsMeta]
%

category: 'testing'
method: CypressMethodDefinition
isMethodDefinition
  ^ true
%

category: 'loading'
method: CypressMethodDefinition
loadMethodDefinition

	self actualClass
		compileMethod: self source
		dictionaries: System myUserProfile symbolList
		category: self category
		environmentId: 0
%

category: 'loading'
method: CypressMethodDefinition
postLoadOver: aDefinition

	super postLoadOver: aDefinition.
	(self isInitializer
		and: [ aDefinition isNil or: [ self source ~= aDefinition source ]]) 
			ifTrue: [ self theNonMetaClass initialize ].
%

category: 'printing'
method: CypressMethodDefinition
printDetailsOn: aStream

	aStream
		nextPutAll: self className;
		nextPutAll: (self classIsMeta ifTrue: [' class'] ifFalse: ['']);
		nextPutAll: '>>';
		nextPutAll: self selector.
%

category: 'dependency'
method: CypressMethodDefinition
requirements
	"Answer list of global names required by this definition"

	^{self className}
%

category: 'accessing'
method: CypressMethodDefinition
selector

	^selector
%

category: 'accessing'
method: CypressMethodDefinition
source

	^source
%

category: 'loading'
method: CypressMethodDefinition
theNonMetaClass

	^self resolveGlobalNamed: self className or: []
%

category: 'loading'
method: CypressMethodDefinition
unloadDefinition

  self actualClass ifNotNil: [:cl | cl removeSelector: self selector asSymbol ].
%

! Class implementation for 'RwCypressMethodDefinition'

!		Instance methods for 'RwCypressMethodDefinition'

category: 'accessing'
method: RwCypressMethodDefinition
isExtensionMethod

	^ isExtensionMethod ifNil: [ isExtensionMethod := false ]
%

category: 'accessing'
method: RwCypressMethodDefinition
isExtensionMethod: anObject

   isExtensionMethod := anObject
%

! Class implementation for 'CypressDefinitionIndex'

!		Class methods for 'CypressDefinitionIndex'

category: 'instance creation'
classmethod: CypressDefinitionIndex
definitions: aCollection
	^ self new addAll: aCollection
%

!		Instance methods for 'CypressDefinitionIndex'

category: 'adding'
method: CypressDefinitionIndex
add: aDefinition
	^ self definitionMap at: aDefinition description put: aDefinition
%

category: 'adding'
method: CypressDefinitionIndex
addAll: aCollection
	aCollection do: [:ea | self add: ea]
%

category: 'querying'
method: CypressDefinitionIndex
definitionLike: aDefinition ifPresent: foundBlock ifAbsent: errorBlock
	| definition |
	definition := self definitionMap at: aDefinition description ifAbsent: [].
	^ definition
		ifNil: errorBlock
		ifNotNil: [foundBlock value: definition]
%

category: 'accessing'
method: CypressDefinitionIndex
definitionMap
	definitionMap ifNil: [ definitionMap := Dictionary new ].
	^ definitionMap
%

category: 'accessing'
method: CypressDefinitionIndex
definitions
	^self definitionMap values
%

category: 'removing'
method: CypressDefinitionIndex
remove: aDefinition
	self definitionMap removeKey: aDefinition description ifAbsent: []
%

! Class implementation for 'CypressDependencySorter'

!		Instance methods for 'CypressDependencySorter'

category: 'building'
method: CypressDependencySorter
add: aPatchOperation
	| requirements |
	requirements := self unresolvedRequirementsFor: aPatchOperation.
	requirements isEmpty
		ifTrue: [self addToOrder: aPatchOperation]
		ifFalse: [self addRequirements: requirements for: aPatchOperation].
	^ aPatchOperation
%

category: 'building'
method: CypressDependencySorter
addAll: aCollection
	aCollection do: [:aPatchOperation | self add: aPatchOperation ]
%

category: 'private'
method: CypressDependencySorter
addExternalProvisions: aCollection

	(self elementsInBoth: aCollection and: self externalRequirements)
		do: [:globalName | self addProvision: globalName]
%

category: 'private'
method: CypressDependencySorter
addProvision: aGlobalName
	| newlySatisfied |
	self provided add: aGlobalName.
	newlySatisfied := self required removeKey: aGlobalName ifAbsent: [#()].
	self addAll: newlySatisfied.
%

category: 'private'
method: CypressDependencySorter
addRequirement: globalName for: aPatchOperation
	(self itemsRequiring: globalName) add: aPatchOperation
%

category: 'private'
method: CypressDependencySorter
addRequirements: aCollection for: aPatchOperation
	aCollection do: [:globalName | self addRequirement: globalName for: aPatchOperation]
%

category: 'private'
method: CypressDependencySorter
addToOrder: aPatchOperation
	self orderedItems add: aPatchOperation.
	aPatchOperation provisions do: [:globalName | self addProvision: globalName ].
%

category: 'accessing'
method: CypressDependencySorter
externalRequirements

	| unloaded providedByUnloaded |
	unloaded := self itemsWithMissingRequirements.
	providedByUnloaded := (self collection: unloaded
				gather: [:e | e provisions]) asSet.
	^self required keys
		reject: [:globalName | providedByUnloaded includes: globalName]
%

category: 'private'
method: CypressDependencySorter
itemsRequiring: globalName
	^ self required at: globalName ifAbsentPut: [Set new]
%

category: 'accessing'
method: CypressDependencySorter
itemsWithMissingRequirements
	| patchOperations |
	patchOperations := Set new.
	self required values do: [:aSetOfPatchOperations | patchOperations addAll: aSetOfPatchOperations ].
	^ patchOperations
%

category: 'accessing'
method: CypressDependencySorter
orderedItems
	"ordered list of patch operations"

	orderedItems ifNil: [ orderedItems := OrderedCollection new ].
	^orderedItems
%

category: 'accessing'
method: CypressDependencySorter
provided
	"set of global names provided by definitions already loaded"

	provided ifNil: [ provided := Set new ].
	^provided
%

category: 'accessing'
method: CypressDependencySorter
required
	"dictionary of required global name mapped to list of definitions that require the global"

	required ifNil: [ required := Dictionary new ].
	^required
%

category: 'private'
method: CypressDependencySorter
unresolvedRequirementsFor: aPatchOperation
	"Answer a list of global names that are required by <aPatchOperation>, but not 
	 provided by patchOperations that have already been processed"

	^self elementsIn: aPatchOperation requirements butNotIn: self provided
%

! Class implementation for 'CypressEnvironmentDependencySorter'

!		Instance methods for 'CypressEnvironmentDependencySorter'

category: 'building'
method: CypressEnvironmentDependencySorter
add: aPatchOperation
  | requirements |
  requirements := self unresolvedRequirementsFor: aPatchOperation.
  requirements removeIfPresent: 'nil'.
  requirements removeIfPresent: nil.
  requirements isEmpty
    ifTrue: [ self addToOrder: aPatchOperation ]
    ifFalse: [ self addRequirements: requirements for: aPatchOperation ].
  ^ aPatchOperation
%

! Class implementation for 'CypressLoader'

!		Class methods for 'CypressLoader'

category: 'accessing'
classmethod: CypressLoader
defaultSymbolDictionaryName
  "Name of the SymbolDictionary where new classes should be installed"

  ^ (SessionTemps current 
      at: #'Cypress_Loader_Default_Symbol_Dictionary_Name' 
      ifAbsent: [] ) 
        ifNil: [
          System myUserProfile userId = 'SystemUser'
          ifTrue: [ #Globals ]
          ifFalse: [ #'UserGlobals' ] ]
%

category: 'accessing'
classmethod: CypressLoader
defaultSymbolDictionaryName: aSymbol
  SessionTemps current 
      at: #'Cypress_Loader_Default_Symbol_Dictionary_Name'
      put: aSymbol
%

category: 'unloading'
classmethod: CypressLoader
unloadSnapshot: aSnapshot
  ^ self new
    unloadSnapshot: aSnapshot;
    load
%

category: 'loading'
classmethod: CypressLoader
updatePackage: aPackage defaultSymbolDictionaryName: defaultSymbolDictionaryName withSnapshot: aSnapshot
  "Answer the loader used to apply the update."

  ^ self new
    defaultSymbolDictionaryName: defaultSymbolDictionaryName;
    updatePackage: aPackage withSnapshot: aSnapshot;
    load
%

category: 'loading'
classmethod: CypressLoader
updatePackage: aPackage withSnapshot: aSnapshot
  "Answer the loader used to apply the update."

  ^ self
    updatePackage: aPackage
    defaultSymbolDictionaryName: nil
    withSnapshot: aSnapshot
%

!		Instance methods for 'CypressLoader'

category: 'updating'
method: CypressLoader
addFailedPatchOperation: aPatchOperation

	self errors add: aPatchOperation
%

category: 'accessing'
method: CypressLoader
additions

	additions ifNil: [ additions := OrderedCollection new ].
	^additions
%

category: 'loading'
method: CypressLoader
analyze
  self
    analyzeRemovalOfAdditions;
    analyzeAdditions;
    analyzeRemovals
%

category: 'loading'
method: CypressLoader
analyzeAdditions

	| sorter |
	sorter := CypressDependencySorter new 
		addAll: self additions;
		addExternalProvisions: self provisions;
		yourself.
	additions := sorter orderedItems.
	requirements := sorter externalRequirements.
	unloadable := sorter required.
%

category: 'loading'
method: CypressLoader
analyzeRemovalOfAdditions
  "if there is an addition and a removal for the same definition, the addition wins ... needed when loading multiple packages and a defintion has been moved from one package to another --- see atomic loads for Metacello"

  | index |
  index := CypressDefinitionIndex
    definitions: (self additions collect: [ :each | each definition ]).
  self removals
    removeAllSuchThat: [ :removal | 
      (index
        definitionLike: removal definition
        ifPresent: [ :additionDefinition | self obsoletions at: additionDefinition description put: removal definition ]
        ifAbsent: [  ]) notNil ]
%

category: 'loading'
method: CypressLoader
analyzeRemovals

	| sorter |
	sorter := CypressDependencySorter new 
		addAll: self removals;
		yourself.
	removals := sorter orderedItems reverse.
%

category: 'applying'
method: CypressLoader
applyAddition: aCypressPatchOperation

	self additions add: aCypressPatchOperation
%

category: 'applying'
method: CypressLoader
applyModification: aCypressPatchOperation
  self additions add: aCypressPatchOperation.
  self obsoletions
    at: aCypressPatchOperation modification description
    put: aCypressPatchOperation obsoletion
%

category: 'applying'
method: CypressLoader
applyRemoval: aCypressPatchOperation

	self removals add: aCypressPatchOperation
%

category: 'loading'
method: CypressLoader
attemptInitialLoad
  ^ self attemptInitialLoad: true
%

category: 'loading'
method: CypressLoader
attemptInitialLoad: doUnloads

	self
		resetErrors;
		notifyOnFailedPatchOperations;
		loadAdditions: self additions .
  doUnloads ifTrue:[ self unloadRemovals: self removals].
%

category: 'accessing'
method: CypressLoader
defaultSymbolDictionaryName
  ^ defaultSymbolDictionaryName ifNil: [ self class defaultSymbolDictionaryName ]
%

category: 'accessing'
method: CypressLoader
defaultSymbolDictionaryName: aSymbol
  defaultSymbolDictionaryName := aSymbol
%

category: 'loading'
method: CypressLoader
errorOnFailedPatchOperations

	exceptionClass := CypressLoaderError.
%

category: 'accessing'
method: CypressLoader
errors
	errors ifNil: [self resetErrors].
	^errors
%

category: 'loading'
method: CypressLoader
handleCompileError: aCompileError from: aPatchOperation

	| undefinedSymbolErrors otherErrors |
	undefinedSymbolErrors := aCompileError errorDetails
				select: [:each | each first = 1031].
	otherErrors := aCompileError errorDetails
				reject: [:each | each first = 1031].
	undefinedSymbolErrors do: [:each | self requirements add: each last].
	aCompileError pass
%

category: 'loading'
method: CypressLoader
handlePatchOperation: aPatchOperation failure: anException
	"Signal the loader exception appropriate to the current phase.
	 Note that a handler may suppress the #addFailedPatchOperation: by
	 sending #return or #return: to the resignaled exception. Otherwise,
	 resumption from a resumable resignalled exception will continue through
	 this method."

	(exceptionClass patchOperation: aPatchOperation exception: anException) signal.
	self addFailedPatchOperation: aPatchOperation.
%

category: 'loading'
method: CypressLoader
load
  ^self load: true
%

category: 'loading'
method: CypressLoader
load: doUnloads
	self analyze .
  doUnloads ifTrue:[ self reportUnloadableDefinitions ].
	self attemptInitialLoad: doUnloads  ;
		retryFailedLoads;
		postLoad.
%

category: 'loading'
method: CypressLoader
loadAdditions: somePatchOperations
	"Load class definitions first, then method definitions."

	somePatchOperations
		do: [:each | self loadClassDefinition: each];
		do: [:each | self loadMethodDefinition: each].
%

category: 'operations'
method: CypressLoader
loadClassDefinition: aPatchOperation

	[ aPatchOperation loadClassDefinition: self defaultSymbolDictionaryName ]
		on: Error
		do: [:ex | self handlePatchOperation: aPatchOperation failure: ex].
%

category: 'operations'
method: CypressLoader
loadMethodDefinition: aPatchOperation

	
	[[aPatchOperation loadMethodDefinition]
		on: CompileError
		do: [:ex | self handleCompileError: ex from: aPatchOperation]]
			on: Error
			do: [:ex | self handlePatchOperation: aPatchOperation failure: ex]
%

category: 'accessing'
method: CypressLoader
methodAdditions

	^#()
%

category: 'loading'
method: CypressLoader
notifyOnFailedPatchOperations

	exceptionClass := CypressLoaderErrorNotification.
%

category: 'accessing'
method: CypressLoader
obsoletions
  obsoletions ifNil: [ obsoletions := Dictionary new ].
  ^ obsoletions
%

category: 'loading'
method: CypressLoader
postLoad
	"This is where the obsoletion is taken into account ..."

	self additions do: [:each | self postLoad: each].
%

category: 'operations'
method: CypressLoader
postLoad: aPatchOperation

	[aPatchOperation postLoadDefinition]
		on: Error
		do: [:ex | self handlePatchOperation: aPatchOperation failure: ex].
%

category: 'accessing'
method: CypressLoader
provisions
	^ provisions ifNil: [provisions := (self allClasses collect: [:cl | cl name asString]) asSet ]
%

category: 'accessing'
method: CypressLoader
removals

	removals ifNil: [ removals := OrderedCollection new ].
	^removals
%

category: 'loading'
method: CypressLoader
reportUnloadableDefinitions

	self unloadable isEmpty ifTrue: [^self].
	(CypressLoaderMissingClasses missingRequirementsMap: unloadable) signal.
%

category: 'accessing'
method: CypressLoader
requirements

	^requirements
%

category: 'loading'
method: CypressLoader
resetErrors

	errors := OrderedCollection new.
%

category: 'loading'
method: CypressLoader
retryFailedLoads
	"In case any of the failed loads were resolved by subsequent
	 patch operations after the initial attempt or by editting of the
	 failed patch operations by exception handling during the notification
	 phase (initial attempt)."

	| failed |
	failed := self errors.
	self
		resetErrors;
		errorOnFailedPatchOperations;
		loadAdditions: (self elementsInBoth: self additions and: failed);
		unloadRemovals: (self elementsInBoth: self removals and: failed)
%

category: 'accessing'
method: CypressLoader
unloadable

	unloadable ifNil: [ unloadable := OrderedCollection new ].
	^unloadable
%

category: 'operations'
method: CypressLoader
unloadDefinition: aPatchOperation

	[aPatchOperation unloadDefinition]
		on: Error
		do: [:ex | self handlePatchOperation: aPatchOperation failure: ex].
%

category: 'loading'
method: CypressLoader
unloadRemovals: somePatchOperations
	"Removals need to be done after adding classes and methods."

	somePatchOperations
		do: [:each | self unloadDefinition: each].
%

category: 'unloading'
method: CypressLoader
unloadSnapshot: aSnapshot
  |  patch |
  patch := CypressSnapshot empty patchRelativeToBase: aSnapshot.
  patch applyTo: self
%

category: 'loading'
method: CypressLoader
updatePackage: aPackage withSnapshot: aSnapshot

	| patch snapshot |
	snapshot := aPackage snapshot.
	patch := aSnapshot patchRelativeToBase: snapshot.
	patch applyTo: self.
	snapshot definitions do: [:ea | self provisions addAll: ea provisions]
%

! Class implementation for 'CypressEnvironmentLoader'

!		Instance methods for 'CypressEnvironmentLoader'

category: 'accessing'
method: CypressEnvironmentLoader
allClasses
  | classes |
  classes := Array new.
  self defaultSymbolList
    do: [ :dict | classes addAll: (dict select: [ :each | each isBehavior ]) ].
  ^ classes
%

category: 'loading'
method: CypressEnvironmentLoader
analyzeAdditions
  | sorter |
  sorter := CypressEnvironmentDependencySorter new
    addAll: self additions;
    addExternalProvisions: self provisions;
    yourself.
  additions := sorter orderedItems.
  requirements := sorter externalRequirements.
  unloadable := sorter required
%

category: 'loading'
method: CypressEnvironmentLoader
analyzeRemovals
  | sorter |
  sorter := CypressEnvironmentDependencySorter new
    addAll: self removals;
    yourself.
  removals := sorter orderedItems reverse
%

category: 'accessing'
method: CypressEnvironmentLoader
compilationSymbolList
  ^ compilationSymbolList
    ifNil: [ compilationSymbolList := self defaultSymbolList ]
%

category: 'accessing'
method: CypressEnvironmentLoader
compilationSymbolList: anObject

   compilationSymbolList := anObject
%

category: 'accessing'
method: CypressEnvironmentLoader
defaultEnvironmentId
  ^ defaultEnvironmentId ifNil: [ defaultEnvironmentId := 0 ]
%

category: 'accessing'
method: CypressEnvironmentLoader
defaultEnvironmentId: anObject

   defaultEnvironmentId := anObject
%

category: 'accessing'
method: CypressEnvironmentLoader
defaultSymbolList
  ^ System myUserProfile symbolList
%

category: 'operations'
method: CypressEnvironmentLoader
loadClassDefinition: aPatchOperation
  [ 
  aPatchOperation
    loadClassDefinition: self defaultSymbolDictionaryName
    environmentLoader: self ]
    on: Error
    do: [ :ex | self handlePatchOperation: aPatchOperation failure: ex ]
%

category: 'operations'
method: CypressEnvironmentLoader
loadMethodDefinition: aPatchOperation
  [ 
  [ 
  aPatchOperation
    loadMethodDefinition: self lookupSymbolList
    environmentLoader: self ]
    on: CompileError
    do: [ :ex | self handleCompileError: ex from: aPatchOperation ] ]
    on: Error
    do: [ :ex | self handlePatchOperation: aPatchOperation failure: ex ]
%

category: 'accessing'
method: CypressEnvironmentLoader
lookupSymbolList
  ^ lookupSymbolList ifNil: [ lookupSymbolList := self defaultSymbolList ]
%

category: 'accessing'
method: CypressEnvironmentLoader
lookupSymbolList: anObject

   lookupSymbolList := anObject
%

category: 'operations'
method: CypressEnvironmentLoader
postLoad: aPatchOperation
  [ 
  aPatchOperation
    postLoadDefinition: lookupSymbolList
    environmentId: self defaultEnvironmentId ]
    on: Error
    do: [ :ex | self handlePatchOperation: aPatchOperation failure: ex ]
%

! Class implementation for 'CypressPackageDefinition'

!		Class methods for 'CypressPackageDefinition'

category: 'instance creation'
classmethod: CypressPackageDefinition
named: aString

	^self new
		name: aString;
		yourself.
%

!		Instance methods for 'CypressPackageDefinition'

category: 'comparing'
method: CypressPackageDefinition
= other
	^ other species = self species and: [other name sameAs: name]
%

category: 'snapshotting'
method: CypressPackageDefinition
addClass: aClass toDefinitions: definitions

	definitions add: (CypressClassDefinition forClass: aClass)
%

category: 'snapshotting'
method: CypressPackageDefinition
addExtensionMethodsFromClass: aClass toMap: classMap

	| defs map |
	defs := classMap at: aClass theNonMetaClass
				ifAbsent: [OrderedCollection new].
	map := Dictionary new.
	aClass categorysDo: 
			[:category :selectors |
			(category asLowercase
				indexOfSubCollection: '*' , self basePackageName asLowercase startingAt: 1 ifAbsent: [ 0 ]) = 1
				ifTrue: [map at: category put: selectors asSortedCollection]].
	map keys asSortedCollection do: 
			[:category |
			(map at: category) do: 
					[:selector |
					defs add: (CypressMethodDefinition
								forMethod: (aClass compiledMethodAt: selector))]].
	defs notEmpty ifTrue: [classMap at: aClass theNonMetaClass put: defs]
%

category: 'snapshotting'
method: CypressPackageDefinition
addMethodsFromClass: aClass toDefinitions: definitions
	"Add only those methods which are not extensions from other packages."

	(((aClass methodDictForEnv: 0)
		reject: [:each | (each inClass categoryOfSelector: each selector) first = $*])
			asSortedCollection: [:a :b | a selector <= b selector])
			do: [:method | definitions add: (CypressMethodDefinition forMethod: method)]
%

category: 'accessing'
method: CypressPackageDefinition
basePackageName
  "package name may have a platform/branch extension, when comparing against category/protocol names, extension is ignored"

  | nm index |
  nm := self name.
  index := nm indexOfSubCollection: '.' startingAt: 1.
  index = 0
    ifTrue: [ ^ nm ].
  ^ nm copyFrom: 1 to: index - 1
%

category: 'accessing'
method: CypressPackageDefinition
classes
  ^ self classesInPackageNamed: self basePackageName
%

category: 'comparing'
method: CypressPackageDefinition
hash
  ^ name hash
%

category: 'accessing'
method: CypressPackageDefinition
name
	^ name
%

category: 'accessing'
method: CypressPackageDefinition
name: aString
	name := aString
%

category: 'printing'
method: CypressPackageDefinition
printDetailsOn: aStream

	aStream nextPutAll: name
%

category: 'snapshotting'
method: CypressPackageDefinition
snapshot

	| classDefinitions methodDefinitions classMap |
	classDefinitions := OrderedCollection new.
	methodDefinitions := OrderedCollection new.
	(self determineClassHierarchicalOrder: self classes) do: 
			[:cls |
			self
				addClass: cls toDefinitions: classDefinitions;
				addMethodsFromClass: cls toDefinitions: methodDefinitions;
				addMethodsFromClass: cls class toDefinitions: methodDefinitions].
	classMap := Dictionary new.
	self allClasses do: 
			[:each |
			self
				addExtensionMethodsFromClass: each toMap: classMap;
				addExtensionMethodsFromClass: each class toMap: classMap].
	(self determineClassHierarchicalOrder: classMap keys)
		do: [:aClass | methodDefinitions addAll: (classMap at: aClass)].
	^CypressSnapshot definitions: classDefinitions, methodDefinitions
%

! Class implementation for 'CypressEnvironmentPackageDefinition'

!		Instance methods for 'CypressEnvironmentPackageDefinition'

category: 'accessing'
method: CypressEnvironmentPackageDefinition
lookupSymbolList

   ^lookupSymbolList
%

category: 'accessing'
method: CypressEnvironmentPackageDefinition
lookupSymbolList: anObject

   lookupSymbolList := anObject
%

category: 'accessing'
method: CypressEnvironmentPackageDefinition
symbolList
  lookupSymbolList ifNil: [ ^ super symbolList ].
  ^ self lookupSymbolList
%

! Class implementation for 'CypressPackageInformation'

!		Class methods for 'CypressPackageInformation'

category: 'instance creation'
classmethod: CypressPackageInformation
named: aString repository: aCypressRepository
	"Answer an instance of the receiver representing the named package.
	 If the package was saved in a Repository, load up the saved details."

	^self new
		initializeFromName: aString andRepository: aCypressRepository;
		yourself
%

category: 'instance creation'
classmethod: CypressPackageInformation
new

	^super new
		initialize;
		yourself
%

!		Instance methods for 'CypressPackageInformation'

category: 'updating - type'
method: CypressPackageInformation
beConflictedWith: somePackageNames
	"Be designated as representing the prefix of one or more Known Package names."

	type := 'Conflicted Name'.
	competingPackageNames := somePackageNames sortAscending.
	advice := 'Conflicts with the packages named ', self competingPackageNamesString
%

category: 'updating - type'
method: CypressPackageInformation
beKnown
	"Be known to represent a real package."

	type := 'Known Package'.
	advice := ''.
	competingPackageNames := #()
%

category: 'updating - type'
method: CypressPackageInformation
beQualifiedNameOf: somePackageNames
	"Be designated as qualifying a Known Package name and therefore not eligible as a package name."

	type := 'Qualified Name'.
	competingPackageNames := somePackageNames sortAscending.
	advice := 'Qualifies the package named ', self competingPackageNamesString
%

category: 'updating - type'
method: CypressPackageInformation
beUnknown
	"Be designated as possibly representing a package, but not known to do so."

	type := 'Unknown'.
	advice := ''.
	competingPackageNames := #()
%

category: 'accessing'
method: CypressPackageInformation
changesCount

	^changesCount
%

category: 'accessing'
method: CypressPackageInformation
changesCount: anInteger

	changesCount := anInteger
%

category: 'accessing'
method: CypressPackageInformation
changesStatus

	^self hasChanges
		ifTrue: [' (' , self changesCount printString , ')']
		ifFalse: ['']
%

category: 'accessing'
method: CypressPackageInformation
classCount

	^self imageCounts first
%

category: 'accessing'
method: CypressPackageInformation
competingPackageNames

	^competingPackageNames
%

category: 'accessing'
method: CypressPackageInformation
competingPackageNamesString

	| stream |
	stream := WriteStreamPortable on: (String new: 100).
	self competingPackageNames
		do: [:each | stream nextPutAll: each printString]
		separatedBy: [stream nextPutAll: ', '].
	^stream contents
%

category: 'accessing'
method: CypressPackageInformation
description

	self isKnown ifTrue: [^self savedLocation].
	self isUnknown ifTrue: [^' <unknown>'].
	^' <', advice, '>'
%

category: 'accessing'
method: CypressPackageInformation
determinedChangesCount

	| notInImage notInSaved |
	notInImage := self savedDefinitions
				reject: [:each | self imageDefinitions includes: each].
	notInSaved := self imageDefinitions
		reject: [:each | self savedDefinitions includes: each].
	^notInImage size + notInSaved size
%

category: 'testing'
method: CypressPackageInformation
hasChanges

	^self changesCount > 0
%

category: 'accessing'
method: CypressPackageInformation
imageCounts

	^imageCounts
%

category: 'accessing'
method: CypressPackageInformation
imageCounts: someIntegers
	"A pair: the number of classes and number of methods"

	imageCounts := someIntegers
%

category: 'accessing'
method: CypressPackageInformation
imageDefinitionCounts

	| classCount methodCount |
	classCount := methodCount := 0.
	self imageDefinitions do: 
			[:each |
			each classDefinition: [:classDefinition | classCount := classCount + 1]
				methodDefinition: [:methodDefinition | methodCount := methodCount + 1]].
	^Array with: classCount with: methodCount
%

category: 'accessing'
method: CypressPackageInformation
imageDefinitions

	^imageDefinitions
%

category: 'accessing'
method: CypressPackageInformation
imageDefinitions: someCypressDefinitions

	imageDefinitions := someCypressDefinitions
%

category: 'accessing'
method: CypressPackageInformation
imageDefinitionsStatus

	^self classCount printString , '/' , self methodCount printString
%

category: 'initializing'
method: CypressPackageInformation
initialize

	self
		beUnknown;
		name: '';
		imageDefinitions: #();
		savedDefinitions: #();
		savedLocation: '';
		repositoryDescription: '';
		imageCounts: #(0 0);
		changesCount: 0
%

category: 'initializing'
method: CypressPackageInformation
initializeFromName: aString andRepository: aCypressRepositoryOrNil

	self name: aString.
	aCypressRepositoryOrNil isNil ifTrue: [^self].
	self updateKnownPackageRepository: aCypressRepositoryOrNil
%

category: 'testing - type'
method: CypressPackageInformation
isConflicted

	^type = 'Conflicted Name'
%

category: 'testing - type'
method: CypressPackageInformation
isKnown

	^type = 'Known Package'
%

category: 'testing - type'
method: CypressPackageInformation
isQualifiedName

	^type = 'Qualified Name'
%

category: 'testing - type'
method: CypressPackageInformation
isUnknown

	^type = 'Unknown'
%

category: 'accessing'
method: CypressPackageInformation
methodCount

	^self imageCounts last
%

category: 'accessing'
method: CypressPackageInformation
name

	^name
%

category: 'accessing'
method: CypressPackageInformation
name: aString

	name := aString
%

category: 'printing'
method: CypressPackageInformation
printDetailsOn: aStream

	aStream
		nextPutAll: self name;
		nextPutAll: ' - ';
		nextPutAll: self description
%

category: 'updating'
method: CypressPackageInformation
readDefinitionsFromRepository

	^(self repository reader readPackageStructureForPackageNamed: self name)
		packageStructure snapshot
		definitions
%

category: 'updating'
method: CypressPackageInformation
refresh

	self isKnown ifFalse: [^self].
	self
		updateImageDefinitions;
		updateSavedDefinitions;
		updateChangesCount.
%

category: 'accessing'
method: CypressPackageInformation
repository

	^repository
%

category: 'accessing'
method: CypressPackageInformation
repository: aCypressFileSystemRepository

	repository := aCypressFileSystemRepository
%

category: 'unknown'
method: CypressPackageInformation
repositoryDescription

	^repositoryDescription
%

category: 'unknown'
method: CypressPackageInformation
repositoryDescription: aString

	repositoryDescription := aString
%

category: 'accessing'
method: CypressPackageInformation
savedDefinitions

	^savedDefinitions
%

category: 'accessing'
method: CypressPackageInformation
savedDefinitions: someCypressDefinitions

	savedDefinitions := someCypressDefinitions
%

category: 'accessing'
method: CypressPackageInformation
savedLocation

	^savedLocation
%

category: 'accessing'
method: CypressPackageInformation
savedLocation: aDirectory

	savedLocation := aDirectory
%

category: 'accessing'
method: CypressPackageInformation
status

	| changes |
	(changes := self changesStatus) isEmpty ifTrue: [^self imageDefinitionsStatus].
	^self imageDefinitionsStatus, changes
%

category: 'updating'
method: CypressPackageInformation
updateChangesCount
	"Must be applied after the image definitions and saved definitions are updated."

	self changesCount: self determinedChangesCount
%

category: 'updating'
method: CypressPackageInformation
updateImageDefinitions

	self
		imageDefinitions: (CypressPackageDefinition named: self name) snapshot
					definitions;
		imageCounts: self imageDefinitionCounts
%

category: 'updating'
method: CypressPackageInformation
updateKnownPackageRepository: aCypressRepository
	"Update the receiver to reflect it being a known package."

	self
		beKnown;
		updateRepository: aCypressRepository;
		refresh.
%

category: 'updating'
method: CypressPackageInformation
updateRepository: aCypressRepository

	self
		repository: aCypressRepository;
		repositoryDescription: self repository description;
		savedLocation: self repository directoryPath
%

category: 'updating'
method: CypressPackageInformation
updateSavedDefinitions

	self savedDefinitions: self readDefinitionsFromRepository
%

! Class implementation for 'CypressPatch'

!		Class methods for 'CypressPatch'

category: 'instance creation'
classmethod: CypressPatch
fromBase: baseSnapshot toTarget: targetSnapshot
	^ (self new)
		fromBase: baseSnapshot
		toTarget: targetSnapshot
%

!		Instance methods for 'CypressPatch'

category: 'applying'
method: CypressPatch
applyTo: aCypressLoader
	operations do: [:ea | ea applyTo: aCypressLoader].
%

category: 'initialization'
method: CypressPatch
fromBase: baseSnapshot toTarget: targetSnapshot
	| base target |	
	operations := OrderedCollection new.
	base := CypressDefinitionIndex definitions: baseSnapshot definitions.
	target := CypressDefinitionIndex definitions: targetSnapshot definitions.
	
	target definitions do:
		[:t |
		base
			definitionLike: t
			ifPresent: [:b | (b isSameRevisionAs: t) ifFalse: [operations add: (CypressModification of: b to: t)]]
			ifAbsent: [operations add: (CypressAddition of: t)]].
		
	base definitions do:
		[:b |
		target
			definitionLike: b
			ifPresent: [:t | ]
			ifAbsent: [operations add: (CypressRemoval of: b)]]
%

category: 'accessing'
method: CypressPatch
operations

	^operations
%

! Class implementation for 'CypressPatchOperation'

!		Instance methods for 'CypressPatchOperation'

category: 'comparing'
method: CypressPatchOperation
= aPatchOperation
	^aPatchOperation isKindOf: self class
%

category: 'applying'
method: CypressPatchOperation
applyTo: aCypressLoader

	self subclassResponsibility: #applyTo:
%

category: 'accessing'
method: CypressPatchOperation
definition
  "answer the primary definition associated with the operation"

  self subclassResponsibility: #'definition'
%

category: 'accessing'
method: CypressPatchOperation
description

	self subclassResponsibility: #description
%

category: 'comparing'
method: CypressPatchOperation
hash
    ^ self description hash
%

category: 'loading'
method: CypressPatchOperation
loadClassDefinition
  self loadClassDefinition: self defaultSymbolDictionaryName
%

category: 'loading'
method: CypressPatchOperation
loadClassDefinition: aDefaultSymbolDictionaryName
  self subclassResponsibility: #'loadClassDefinition'
%

category: 'loading'
method: CypressPatchOperation
loadMethodDefinition

	self subclassResponsibility: #loadMethodDefinition
%

category: 'loading'
method: CypressPatchOperation
postLoadDefinition

	self subclassResponsibility: #postLoadDefinition
%

category: 'printing'
method: CypressPatchOperation
printDetailsOn: aStream

	aStream nextPutAll: self description.
%

category: 'dependency'
method: CypressPatchOperation
provisions
	"Answer list of global names defined by this definition"

	self subclassResponsibility: #provisions
%

category: 'dependency'
method: CypressPatchOperation
requirements
	"Answer list of global names required by this definition"

	self subclassResponsibility: #requirements
%

category: 'loading'
method: CypressPatchOperation
unloadDefinition

	CypressError signal: 'inappropriate to send #unloadDefinition to an addition or modification operation'
%

! Class implementation for 'CypressAddition'

!		Class methods for 'CypressAddition'

category: 'instance creation'
classmethod: CypressAddition
of: aDefinition
	^ self new definition: aDefinition
%

!		Instance methods for 'CypressAddition'

category: 'comparing'
method: CypressAddition
= aPatchOperation
	^(super = aPatchOperation) and: [self definition = aPatchOperation definition]
%

category: 'applying'
method: CypressAddition
applyTo: aCypressLoader

	aCypressLoader applyAddition: self
%

category: 'accessing'
method: CypressAddition
definition

	^definition
%

category: 'initialization'
method: CypressAddition
definition: aDefinition

	definition := aDefinition
%

category: 'accessing'
method: CypressAddition
description
    ^ 'add: ' , self definition printString
%

category: 'comparing'
method: CypressAddition
hash
  ^ super hash bitXor: definition hash
%

category: 'loading'
method: CypressAddition
loadClassDefinition: aDefaultSymbolDictionaryName
  self definition loadClassDefinition: aDefaultSymbolDictionaryName
%

category: 'loading'
method: CypressAddition
loadMethodDefinition
  self definition loadMethodDefinition
%

category: 'loading'
method: CypressAddition
postLoadDefinition
	self definition postLoadOver: nil
%

category: 'dependency'
method: CypressAddition
provisions
	"Answer list of global names defined by this definition"

	^self definition provisions
%

category: 'dependency'
method: CypressAddition
requirements
	"Answer list of global names required by this definition"

	^self definition requirements
%

! Class implementation for 'CypressModification'

!		Class methods for 'CypressModification'

category: 'instance creation'
classmethod: CypressModification
of: base to: target
	^ self new base: base target: target
%

!		Instance methods for 'CypressModification'

category: 'initialization'
method: CypressModification
= aPatchOperation
	^(super = aPatchOperation) and: [self obsoletion = aPatchOperation obsoletion and: [ self modification = aPatchOperation modification]]
%

category: 'applying'
method: CypressModification
applyTo: aCypressLoader

	aCypressLoader applyModification: self
%

category: 'initialization'
method: CypressModification
base: base target: target

	obsoletion := base.
	modification := target.
%

category: 'accessing'
method: CypressModification
definition
  "answer the primary definition associated with the operation"

  ^ self modification
%

category: 'accessing'
method: CypressModification
description
    ^ 'modify from: ' , self obsoletion printString , ' to: ' , self modification printString
%

category: 'comparing'
method: CypressModification
hash
  ^ (super hash bitXor: modification hash) bitXor: obsoletion hash
%

category: 'loading'
method: CypressModification
loadClassDefinition: aDefaultSymbolDictionaryName
  self modification loadClassDefinition: aDefaultSymbolDictionaryName
%

category: 'loading'
method: CypressModification
loadMethodDefinition

	self modification loadMethodDefinition.
%

category: 'accessing'
method: CypressModification
modification

	^modification
%

category: 'accessing'
method: CypressModification
obsoletion

	^obsoletion
%

category: 'loading'
method: CypressModification
postLoadDefinition
	self modification postLoadOver: self obsoletion
%

category: 'dependency'
method: CypressModification
provisions
	"Answer list of global names defined by this definition"

	^self modification provisions
%

category: 'dependency'
method: CypressModification
requirements
	"Answer list of global names required by this definition"

	^self modification requirements
%

! Class implementation for 'CypressRemoval'

!		Class methods for 'CypressRemoval'

category: 'instance creation'
classmethod: CypressRemoval
of: aDefinition
	^ self new definition: aDefinition
%

!		Instance methods for 'CypressRemoval'

category: 'comparing'
method: CypressRemoval
= aPatchOperation
	^(super = aPatchOperation) and: [self definition = aPatchOperation definition]
%

category: 'applying'
method: CypressRemoval
applyTo: aCypressLoader

	aCypressLoader applyRemoval: self
%

category: 'accessing'
method: CypressRemoval
definition

	^definition
%

category: 'initialization'
method: CypressRemoval
definition: aDefinition

	definition := aDefinition
%

category: 'accessing'
method: CypressRemoval
description

	^'remove: ', self definition printString
%

category: 'comparing'
method: CypressRemoval
hash
  ^ super hash bitXor: definition hash
%

category: 'loading'
method: CypressRemoval
loadClassDefinition: aDefaultSymbolDictionaryName
  CypressError
    signal: 'inappropriate to send #loadClassDefinition to a removal operation'
%

category: 'loading'
method: CypressRemoval
loadMethodDefinition
	
	CypressError signal: 'inappropriate to send #loadMethodDefinition to a removal operation'
%

category: 'loading'
method: CypressRemoval
postLoadDefinition
	
	CypressError signal: 'inappropriate to send #postLoadDefinition to a removal operation'
%

category: 'dependency'
method: CypressRemoval
provisions
	"Answer list of global names defined by this definition"

	^#()
%

category: 'dependency'
method: CypressRemoval
requirements
	"Answer list of global names required by this definition"

	^#()
%

category: 'loading'
method: CypressRemoval
unloadDefinition

	self definition unloadDefinition.
%

! Class implementation for 'CypressSnapshot'

!		Class methods for 'CypressSnapshot'

category: 'instance creation'
classmethod: CypressSnapshot
definitions: aDefinitions

	^(self new) definitions: aDefinitions
%

category: 'instance creation'
classmethod: CypressSnapshot
empty

  ^self definitions: #()
%

!		Instance methods for 'CypressSnapshot'

category: 'comparing'
method: CypressSnapshot
= other
	^ definitions asArray = other definitions asArray
%

category: 'enumerating'
method: CypressSnapshot
classDefinitions: classBlock methodDefinitions: methodBlock

	self definitions do: [:definition |
		definition classDefinition: classBlock methodDefinition: methodBlock]
%

category: 'accessing'
method: CypressSnapshot
definitions

	^definitions
%

category: 'accessing'
method: CypressSnapshot
definitions: aDefinitions

	definitions := aDefinitions
%

category: 'comparing'
method: CypressSnapshot
hash
  ^ definitions asArray hash
%

category: 'patching'
method: CypressSnapshot
patchRelativeToBase: aSnapshot
	^ CypressPatch fromBase: aSnapshot toTarget: self
%

category: 'unloading'
method: CypressSnapshot
unload

  ^CypressLoader unloadSnapshot: self
%

category: 'loading'
method: CypressSnapshot
updatePackage: aPackage
  "Answer the loader used to apply the update."

  ^ self updatePackage: aPackage defaultSymbolDictionaryName: nil
%

category: 'loading'
method: CypressSnapshot
updatePackage: aPackage defaultSymbolDictionaryName: defaultSymbolDictionaryName
  "Answer the loader used to apply the update."

  ^ CypressLoader
    updatePackage: aPackage
    defaultSymbolDictionaryName: defaultSymbolDictionaryName
    withSnapshot: self
%

! Class implementation for 'CypressStructure'

!		Class methods for 'CypressStructure'

category: 'instance creation'
classmethod: CypressStructure
named: aString

	^(self new)
		name: aString;
		yourself
%

!		Instance methods for 'CypressStructure'

category: 'accessing'
method: CypressStructure
name

	^name
%

category: 'accessing'
method: CypressStructure
name: aString 

	name := aString
%

category: 'accessing'
method: CypressStructure
packageStructure
	^packageStructure
%

category: 'accessing'
method: CypressStructure
packageStructure: aCypressPackageStructure
	packageStructure := aCypressPackageStructure
%

category: 'printing'
method: CypressStructure
printDetailsOn: aStream

	aStream nextPutAll: self name.
%

category: 'accessing'
method: CypressStructure
properties

	properties ifNil: [ properties := Dictionary new ].
	^properties
%

category: 'accessing'
method: CypressStructure
properties: aDictionary

	properties := aDictionary
%

! Class implementation for 'CypressClassStructure'

!		Class methods for 'CypressClassStructure'

category: 'instance creation'
classmethod: CypressClassStructure
fromClassDefinition: classDefinition

	^self new
		fromClassDefinition: classDefinition;
		yourself
%

!		Instance methods for 'CypressClassStructure'

category: 'converting'
method: CypressClassStructure
asCypressClassDefinition

	self isClassExtension ifTrue: [^CypressError signal: 'Extensions cannot have class definitions'].
	^CypressClassDefinition new
		name: self className
		superclassName: self superclassName
		category: self category
		instVarNames: self instanceVariableNames
		classInstVarNames: self classInstanceVariableNames
		classVarNames: self classVariableNames
		poolDictionaryNames: self poolDictionaryNames
		gs_options: self gs_options
		gs_constraints: self gs_constraints
		comment: self comment
		subclassType: self subclassType
%

category: 'accessing'
method: CypressClassStructure
category

	^self properties
		at: 'category'
		ifAbsent: [self packageStructure packageName]
%

category: 'accessing'
method: CypressClassStructure
category: aString

	^self properties at: 'category' put: aString
%

category: 'accessing'
method: CypressClassStructure
classInstanceVariableNames

	^self properties at: 'classinstvars' ifAbsent: [#()]
%

category: 'accessing'
method: CypressClassStructure
classInstanceVariableNames: someStrings

	^self properties at: 'classinstvars' put: someStrings
%

category: 'converting'
method: CypressClassStructure
classInstanceVariablesString
  ^ self stringForVariables: self classInstanceVariableNames
%

category: 'querying'
method: CypressClassStructure
classMethodNamed: methodName

	^self classMethods
		at: methodName
		ifAbsentPut: [CypressMethodStructure named: methodName]
%

category: 'accessing'
method: CypressClassStructure
classMethods

	classMethods ifNil: [ classMethods := Dictionary new ].
	^classMethods
%

category: 'accessing'
method: CypressClassStructure
className

	^self name
%

category: 'accessing'
method: CypressClassStructure
classVariableNames

	^self properties at: 'classvars' ifAbsent: [#()]
%

category: 'accessing'
method: CypressClassStructure
classVariableNames: someStrings

	^self properties at: 'classvars' put: someStrings
%

category: 'converting'
method: CypressClassStructure
classVariablesString
  ^ self stringForVariables: self classVariableNames asSortedCollection
%

category: 'accessing'
method: CypressClassStructure
comment

	comment ifNil: [ comment := '' ].
	^comment
%

category: 'accessing'
method: CypressClassStructure
comment: aString

	comment := aString
%

category: 'initialization'
method: CypressClassStructure
fromClassDefinition: classDefinition

	self
		isClassExtension: false;
		name: classDefinition name;
		category: classDefinition category;
		comment: classDefinition comment;
		superclassName: classDefinition superclassName;
		instanceVariableNames: classDefinition instVarNames;
		classInstanceVariableNames: classDefinition classInstVarNames;
		classVariableNames: classDefinition classVarNames;
		poolDictionaryNames: classDefinition poolDictionaryNames;
		subclassType: classDefinition subclassType;
		gs_options: classDefinition gs_options;
		gs_constraints: classDefinition gs_constraints
%

category: 'accessing'
method: CypressClassStructure
gs_constraints

	^self properties at: 'gs_constraints' ifAbsent: [#()]
%

category: 'accessing'
method: CypressClassStructure
gs_constraints: anConstraintsArray

	^self properties at: 'gs_constraints' put: anConstraintsArray
%

category: 'accessing'
method: CypressClassStructure
gs_options

	^self properties at: 'gs_options' ifAbsent: [#()]
%

category: 'accessing'
method: CypressClassStructure
gs_options: anOptionsArray

	^self properties at: 'gs_options' put: anOptionsArray
%

category: 'accessing'
method: CypressClassStructure
gs_reservedOop
	^ ''
%

category: 'querying'
method: CypressClassStructure
instanceMethodNamed: methodName

	^self instanceMethods
		at: methodName 
		ifAbsentPut: [CypressMethodStructure named: methodName]
%

category: 'accessing'
method: CypressClassStructure
instanceMethods

	instanceMethods ifNil: [ instanceMethods := Dictionary new ].
	^instanceMethods
%

category: 'accessing'
method: CypressClassStructure
instanceVariableNames

	^self properties at: 'instvars' ifAbsent: [#()]
%

category: 'accessing'
method: CypressClassStructure
instanceVariableNames: someStrings

	^self properties at: 'instvars' put: someStrings
%

category: 'converting'
method: CypressClassStructure
instanceVariablesString

	^self stringForVariables: self instanceVariableNames
%

category: 'accessing'
method: CypressClassStructure
isClassExtension

        isClassExtension ifNil: [ isClassExtension := true ].
        ^isClassExtension
%

category: 'accessing'
method: CypressClassStructure
isClassExtension: aBoolean

	isClassExtension := aBoolean
%

category: 'accessing'
method: CypressClassStructure
name

	^self properties at: 'name'
%

category: 'accessing'
method: CypressClassStructure
name: aString

	self properties at: 'name' put: aString
%

category: 'converting'
method: CypressClassStructure
poolDictionariesString
  ^ self stringForVariables: self poolDictionaryNames
%

category: 'accessing'
method: CypressClassStructure
poolDictionaryNames

	^self properties at: 'pools' ifAbsent: [#()]
%

category: 'accessing'
method: CypressClassStructure
poolDictionaryNames: someStrings

	^self properties at: 'pools' put: someStrings
%

category: 'accessing'
method: CypressClassStructure
subclassType

	^self properties at: '_gs_subclassType' ifAbsent: ['']
%

category: 'accessing'
method: CypressClassStructure
subclassType: aString

	aString isEmpty
		ifTrue: [self properties removeKey: '_gs_subclassType' ifAbsent: []]
		ifFalse: [self properties at: '_gs_subclassType' put: aString]
%

category: 'accessing'
method: CypressClassStructure
superclassName

	^self properties at: 'super'
%

category: 'accessing'
method: CypressClassStructure
superclassName: aString

	^self properties at: 'super' put: aString
%

! Class implementation for 'CypressMethodStructure'

!		Class methods for 'CypressMethodStructure'

category: 'instance creation'
classmethod: CypressMethodStructure
fromMethodDefinition: methodDefinition

	^self new
		fromMethodDefinition: methodDefinition;
		yourself
%

!		Instance methods for 'CypressMethodStructure'

category: 'converting'
method: CypressMethodStructure
asCypressMethodDefinition
	"Try to coerce Unicode source to simple Strings when possible."

	^CypressMethodDefinition 
        	className: self classStructure className
		classIsMeta: self isMetaclass
		selector: self selector
		category: self category
		source: self source asString
%

category: 'accessing'
method: CypressMethodStructure
category

	^self properties at: 'category'
%

category: 'accessing'
method: CypressMethodStructure
category: aString

	self properties at: 'category' put: aString
%

category: 'accessing'
method: CypressMethodStructure
classStructure
	^classStructure
%

category: 'accessing'
method: CypressMethodStructure
classStructure: aCypressClassStructure
	classStructure := aCypressClassStructure
%

category: 'initialization'
method: CypressMethodStructure
fromMethodDefinition: methodDefinition

	self isMetaclass: methodDefinition classIsMeta.
	self selector: methodDefinition selector.
	self category: methodDefinition category.
	self source: methodDefinition source.
%

category: 'accessing'
method: CypressMethodStructure
isMetaclass

	isMetaclass ifNil: [ isMetaclass := false ].
	^isMetaclass
%

category: 'accessing'
method: CypressMethodStructure
isMetaclass: aBoolean
	isMetaclass := aBoolean
%

category: 'accessing'
method: CypressMethodStructure
selector

	| stream |
	stream := WriteStreamPortable on: (String new: 100).
	self name
		do: [:chara | stream nextPut: (chara = $. ifTrue: [$:] ifFalse: [chara])].
	^stream contents
%

category: 'accessing'
method: CypressMethodStructure
selector: aString

	| stream |
	stream := WriteStreamPortable on: (String new: 100).
	aString
		do: [:chara | stream nextPut: (chara = $: ifTrue: [$.] ifFalse: [chara])].
	name := stream contents
%

category: 'accessing'
method: CypressMethodStructure
source

	^source
%

category: 'accessing'
method: CypressMethodStructure
source: aString

	source := aString
%

! Class implementation for 'RwCypressMethodStructure'

!		Instance methods for 'RwCypressMethodStructure'

category: 'converting'
method: RwCypressMethodStructure
asCypressMethodDefinition

	"Try to coerce Unicode source to simple Strings when possible."

	^ RwCypressMethodDefinition
		className: self classStructure className
		classIsMeta: self isMetaclass
		selector: self selector
		category: self category
		source: self source asString
%

category: 'initialization'
method: RwCypressMethodStructure
fromRwClassMethodDefinition: methodDefinition
  self isMetaclass: true.
  self fromRwMethodDefinition: methodDefinition
%

category: 'initialization'
method: RwCypressMethodStructure
fromRwInstanceMethodDefinition: methodDefinition
  self isMetaclass: false.
  self fromRwMethodDefinition: methodDefinition
%

category: 'initialization'
method: RwCypressMethodStructure
fromRwMethodDefinition: methodDefinition
  self selector: methodDefinition selector asString.
  self category: (methodDefinition properties at: #'protocol').
  self source: methodDefinition source
%

! Class implementation for 'CypressPackageStructure'

!		Class methods for 'CypressPackageStructure'

category: 'instance creation'
classmethod: CypressPackageStructure
fromPackage: aCypressPackageDefinition

	^(self new) 
		fromPackage: aCypressPackageDefinition;
		yourself
%

category: 'instance creation'
classmethod: CypressPackageStructure
name: aPackageNameString from: classDefinitions classMap: classMap
  ^ self new
    name: aPackageNameString from: classDefinitions classMap: classMap;
    yourself
%

!		Instance methods for 'CypressPackageStructure'

category: 'accessing'
method: CypressPackageStructure
classes

	classes ifNil: [ classes := OrderedCollection new ].
	^classes
%

category: 'accessing'
method: CypressPackageStructure
extensions

	extensions ifNil: [ extensions := OrderedCollection new ].
	^extensions
%

category: 'initialization'
method: CypressPackageStructure
fromPackage: aCypressPackageDefinition
  | snapshot classMap classDefinitions |
  snapshot := aCypressPackageDefinition snapshot.
  classDefinitions := OrderedCollection new.
  classMap := Dictionary new.
  snapshot definitions
    do: [ :definition | 
      definition
        classDefinition: [ :classDefinition | classDefinitions add: classDefinition ]
        methodDefinition: [ :methodDefinition | 
          (classMap at: methodDefinition className ifAbsentPut: [ Set new ])
            add: methodDefinition ] ].
  self
    name: aCypressPackageDefinition name , self packageExtension
    from: classDefinitions
    classMap: classMap
%

category: 'initialization'
method: CypressPackageStructure
name: aString from: classDefinitions classMap: classMap

	| classStructure |
	name := aString.
	properties := Dictionary new.
	classDefinitions do: [:classDefinition |
		classStructure := (CypressClassStructure fromClassDefinition: classDefinition)
			packageStructure: self.
		(classMap removeKey: classDefinition className ifAbsent: [#()]) do: [:methodDefinition | | methodStructure |
			methodStructure := (CypressMethodStructure fromMethodDefinition: methodDefinition)
				packageStructure: self;
				classStructure: classStructure.
			(methodDefinition
				instanceMethod: [:instanceMethod | classStructure instanceMethods ] 
				classMethod: [:classMethod | classStructure classMethods ])
					at: methodDefinition selector
					put: methodStructure ].
		self classes add: classStructure ].
	classMap keysAndValuesDo: [:className :methods |
		classStructure := (CypressClassStructure named: className)
			isClassExtension: true;
			packageStructure: self.
		methods do: [:methodDefinition | | methodStructure |
			methodStructure := (CypressMethodStructure fromMethodDefinition: methodDefinition)
				packageStructure: self;
				classStructure: classStructure.
			(methodDefinition
				instanceMethod: [:instanceMethod | classStructure instanceMethods ] 
				classMethod: [:classMethod | classStructure classMethods ])
					at: methodDefinition selector
					put: methodStructure ].
		self extensions add: classStructure ].
%

category: 'accessing'
method: CypressPackageStructure
packageExtension

	^self packageExtensionOr: ['.package' ]
%

category: 'accessing'
method: CypressPackageStructure
packageExtensionOr: aBlock

	^self properties at: 'extension' ifAbsent: aBlock
%

category: 'accessing'
method: CypressPackageStructure
packageName

	| extension extensionSize stopIndex |
	extension := self packageExtension.
	extensionSize := extension size.
	stopIndex :=  extensionSize < self name size
		ifTrue: [
			self name
					indexOfSubCollection: extension
					startingAt: self name size - extensionSize + 1
					ifAbsent: [ self name size + 1 ] ]
		ifFalse: [  self name size + 1 ].
	^self name copyFrom: 1 to: stopIndex - 1
%

category: 'accessing'
method: CypressPackageStructure
packageStructure
	^self
%

category: 'snapshotting'
method: CypressPackageStructure
snapshot
	| definitions |
	definitions := OrderedCollection new.
	self classes do: [:classStructure |
        	definitions add: classStructure asCypressClassDefinition.
                (classStructure instanceMethods asSortedCollection: [:a :b | a selector <= b selector]) do: [:methodStructure |
			definitions add: methodStructure asCypressMethodDefinition ].
                (classStructure classMethods asSortedCollection: [:a :b | a selector <= b selector]) do: [:methodStructure |
			definitions add: methodStructure asCypressMethodDefinition ]].
	self extensions do: [:classStructure |
                (classStructure instanceMethods asSortedCollection: [:a :b | a selector <= b selector]) do: [:methodStructure |
			definitions add: methodStructure asCypressMethodDefinition ].
                (classStructure classMethods asSortedCollection: [:a :b | a selector <= b selector]) do: [:methodStructure |
			definitions add: methodStructure asCypressMethodDefinition ]].
	^ CypressSnapshot definitions: definitions
%

! Class implementation for 'RwCypressPackageStructure'

!		Instance methods for 'RwCypressPackageStructure'

category: 'initialization'
method: RwCypressPackageStructure
fromPackage: aRwPackageDefinition

	| classStructure |
	aRwPackageDefinition classDefinitions
		do: [ :classDefinition | 
			classStructure := (CypressClassStructure fromClassDefinition: classDefinition)
				packageStructure: self.
			classDefinition instanceMethodDefinitions
				do: [ :methodDefinition | 
					| methodStructure |
					methodStructure := RwCypressMethodStructure new
						fromRwInstanceMethodDefinition: methodDefinition;
						packageStructure: self;
						classStructure: classStructure.
					classStructure instanceMethods
						at: methodDefinition selector
						put: methodStructure ].
			classDefinition classMethodDefinitions
				do: [ :methodDefinition | 
					| methodStructure |
					methodStructure := RwCypressMethodStructure new
						fromRwClassMethodDefinition: methodDefinition;
						packageStructure: self;
						classStructure: classStructure.
					classStructure classMethods
						at: methodDefinition selector
						put: methodStructure ].
			self classes add: classStructure ].
	aRwPackageDefinition classExtensions
		do: [ :extensionDefinition | 
			classStructure := (CypressClassStructure named: extensionDefinition name)
				isClassExtension: true;
				packageStructure: self.
			extensionDefinition instanceMethodDefinitions
				do: [ :methodDefinition | 
					| methodStructure |
					methodStructure := RwCypressMethodStructure new
						fromRwInstanceMethodDefinition: methodDefinition;
						packageStructure: self;
						classStructure: classStructure.
					classStructure instanceMethods
						at: methodDefinition selector
						put: methodStructure ].
			extensionDefinition classMethodDefinitions
				do: [ :methodDefinition | 
					| methodStructure |
					methodStructure := RwCypressMethodStructure new
						fromRwClassMethodDefinition: methodDefinition;
						packageStructure: self;
						classStructure: classStructure.
					classStructure classMethods
						at: methodDefinition selector
						put: methodStructure ].
			self extensions add: classStructure ].
	name := aRwPackageDefinition key , self packageExtension.
	properties := Dictionary new
%

category: 'initialization'
method: RwCypressPackageStructure
fromSnapshot: snapshot
  | classMap classDefinitions |
  classDefinitions := OrderedCollection new.
  classMap := Dictionary new.
  snapshot
    do: [ :definition | 
      definition
        classDefinition: [ :classDefinition | classDefinitions add: classDefinition ]
        methodDefinition: [ :methodDefinition | 
          (classMap at: methodDefinition className ifAbsentPut: [ Set new ])
            add: methodDefinition ] ].
  self name: self name from: classDefinitions classMap: classMap
%

category: 'snapshotting'
method: RwCypressPackageStructure
rwSnapshot

	| rwPackageDefinition |
	rwPackageDefinition := RwPackageDefinition new
		properties:
			(Dictionary new
				at: 'name' put: self packageName;
				yourself).
	self classes
		do: [ :classStructure | 
			| rwClassDef |
			rwClassDef := RwClassDefinition fromCypressClassStructure: classStructure.
			rwPackageDefinition addClassDefinition: rwClassDef ].
	self extensions
		do: [ :classStructure | 
			| rwClassExtensionDef |
			rwClassExtensionDef := RwClassExtensionDefinition
				newForClassNamed: classStructure className.
			(classStructure instanceMethods
				asSortedCollection: [ :a :b | a selector <= b selector ])
				do: [ :methodStructure | 
					rwClassExtensionDef
						addInstanceMethodDefinition:
							(self _methodDefinitionClass fromCypressMethod: methodStructure) ].
			(classStructure classMethods
				asSortedCollection: [ :a :b | a selector <= b selector ])
				do: [ :methodStructure | 
					rwClassExtensionDef
						addClassMethodDefinition:
							(self _methodDefinitionClass fromCypressMethod: methodStructure) ].
			rwPackageDefinition addClassExtensionDefinition: rwClassExtensionDef ].
	^ rwPackageDefinition
%

category: 'snapshotting'
method: RwCypressPackageStructure
snapshot

	| definitions |
	definitions := OrderedCollection new.
	self classes
		do: [ :classStructure | 
			definitions add: classStructure asCypressClassDefinition.
			(classStructure instanceMethods
				asSortedCollection: [ :a :b | a selector <= b selector ])
				do: [ :methodStructure | definitions add: methodStructure asCypressMethodDefinition ].
			(classStructure classMethods
				asSortedCollection: [ :a :b | a selector <= b selector ])
				do: [ :methodStructure | definitions add: methodStructure asCypressMethodDefinition ] ].
	self extensions
		do: [ :classStructure | 
			(classStructure instanceMethods
				asSortedCollection: [ :a :b | a selector <= b selector ])
				do: [ :methodStructure | 
					| mdef |
					mdef := methodStructure asCypressMethodDefinition.
					mdef isExtensionMethod: true.
					definitions add: mdef ].
			(classStructure classMethods
				asSortedCollection: [ :a :b | a selector <= b selector ])
				do: [ :methodStructure | 
					| mdef |
					mdef := methodStructure asCypressMethodDefinition.
					mdef isExtensionMethod: true.
					definitions add: mdef ] ].
	^ CypressSnapshot definitions: definitions
%

! Class implementation for 'CypressPackageComparator'

!		Class methods for 'CypressPackageComparator'

category: 'instance creation'
classmethod: CypressPackageComparator
comparingPackageNamed: packageName fromDirectory: aDirectory

	^(self new)
		comparingPackageNamed: packageName fromDirectory: aDirectory;
		yourself
%

category: 'instance creation'
classmethod: CypressPackageComparator
new

	^super new
		initialize;
		yourself
%

!		Instance methods for 'CypressPackageComparator'

category: 'comparing - private'
method: CypressPackageComparator
add: aDefinition to: aDictionary

	aDefinition
		classDefinition: [:classDefinition | self addClassDefinition: classDefinition to: aDictionary]
		methodDefinition: [:methodDefinition | self addMethodDefinition: methodDefinition to: aDictionary]
%

category: 'comparing - private'
method: CypressPackageComparator
addClassDefinition: classDefinition to: aDictionary

	(aDictionary at: classDefinition className ifAbsentPut: [Dictionary new])
		at: 'class category' put: classDefinition category;
		at: 'class comment' put: classDefinition comment;
		at: 'class definition' put: classDefinition classDefinitionString.
%

category: 'comparing - private'
method: CypressPackageComparator
addMethodDefinition: methodDefinition to: aDictionary

	((aDictionary at: methodDefinition className ifAbsentPut: [Dictionary new])
		at: (methodDefinition classIsMeta
				ifTrue: ['class methods']
				ifFalse: ['instance methods'])
		ifAbsentPut: [Dictionary new]) at: methodDefinition selector
			put: methodDefinition category -> methodDefinition source
%

category: 'comparing - private'
method: CypressPackageComparator
applyAddition: aCypressAddition

	self add: aCypressAddition definition to: self currentAdditions
%

category: 'comparing - private'
method: CypressPackageComparator
applyModification: aCypressModification

	self
		add: aCypressModification modification to: self currentAdditions;
		add: aCypressModification obsoletion to: self currentRemovals.
%

category: 'comparing - private'
method: CypressPackageComparator
applyRemoval: aCypressRemoval

	self add: aCypressRemoval definition to: self currentRemovals.
%

category: 'comparing'
method: CypressPackageComparator
compare

	diskSnapshots keys do: [:packageName |
		self resetCurrentForPackage: packageName.
		self currentPatchOperations do: [:each | each applyTo: self].
	].
	self resetCurrentForPackage: nil.
%

category: 'initializing'
method: CypressPackageComparator
comparingPackages: someNames fromDirectory: aDirectory

	(directoryPackageMap at: aDirectory ifAbsentPut: [OrderedCollection new])
		addAll: someNames.
	someNames do: 
			[:packageName |
			| reader modTime modTimestamp |
			reader := (CypressFileSystemRepository on: aDirectory) reader
						readPackageStructureForPackageNamed: packageName.
			diskSnapshots at: packageName put: reader packageStructure snapshot.
			modTime := System
						performOnServer: 'stat --printf=%y ' , reader packageDirectory.
			modTimestamp := (modTime indexOfSubCollection: 'stat:' startingAt: 1 ifAbsent: [ 0 ]) = 1
						ifTrue: [nil]
						ifFalse: [self dateAndTimeFromUnixFormatString: modTime].
			diskTimestamps at: packageName put: modTimestamp.
			imageSnapshots at: packageName
				put: (CypressPackageDefinition named: packageName) snapshot]
%

category: 'comparing - private'
method: CypressPackageComparator
currentAdditions

	currentAdditions ifNil: [self updateCurrentAdditionsAndRemovals].
	^currentAdditions
%

category: 'comparing - private'
method: CypressPackageComparator
currentDiskSnapshot

	^diskSnapshots at: currentPackageName
%

category: 'comparing - private'
method: CypressPackageComparator
currentImageSnapshot

	^imageSnapshots at: currentPackageName
%

category: 'comparing - private'
method: CypressPackageComparator
currentPatchOperations

	^(CypressPatch fromBase: self currentDiskSnapshot toTarget: self currentImageSnapshot) operations.
%

category: 'comparing - private'
method: CypressPackageComparator
currentRemovals

	currentRemovals ifNil: [self updateCurrentAdditionsAndRemovals].
	^currentRemovals
%

category: 'initializing - private'
method: CypressPackageComparator
dateAndTimeFromUnixFormatString: aString
	"YYYY-MM-DDTHH:MM:SS +HHMM
	 Examples:
		| string |
		string := '2013-06-20 14:47:55.40271592140198 -0700'.
		(DateAndTimeANSI fromUnixFormatString: string) printString = '2013-06-20T14:47:55.40271592140198-07:00'.
	"

	| stream sign positionBias |
	stream := ReadStreamPortable on: aString.
	sign := aString at: aString size - 4.
	positionBias := stream class isLegacyStreamImplementation
				ifTrue: [1]
				ifFalse: [0].
	^DateAndTime
		year: (stream next: 4) asNumber
		month: (stream
				next;
				next: 2) asNumber
		day: (stream
				next;
				next: 2) asNumber
		hour: (stream
				next;
				next: 2) asNumber
		minute: (stream
				next;
				next: 2) asNumber
		second: (stream
				next;
				next: aString size - 6 - stream position + positionBias) asNumber
		offset: (Duration
				days: 0
				hours: (stream
						next;
						next;
						next: 2) asNumber
						* (sign == $- ifTrue: [-1] ifFalse: [1])
				minutes: (stream next: 2) asNumber
				seconds: 0)
%

category: 'comparing'
method: CypressPackageComparator
getDifferences

	self compare.
	^self snapshotDifferences
%

category: 'initializing - private'
method: CypressPackageComparator
initialize

	directoryPackageMap := Dictionary new.
	diskTimestamps := Dictionary new.
	diskSnapshots := Dictionary new.
	imageSnapshots := Dictionary new.
	snapshotDifferences := Dictionary new
		at: 'newer' put: (Dictionary with: 'Finished at' -> DateAndTime now);
		at: 'older' put: (Dictionary with: 'Finished at' -> DateAndTime now);
		yourself.
%

category: 'comparing - private'
method: CypressPackageComparator
resetCurrentForPackage: aStringOrNil

	currentPackageName := aStringOrNil.
	currentAdditions := nil.
	currentRemovals := nil.
%

category: 'accessing'
method: CypressPackageComparator
snapshotDifferences

	^snapshotDifferences
%

category: 'comparing - private'
method: CypressPackageComparator
updateCurrentAdditionsAndRemovals

	| oldTimestamp |
	currentAdditions := (snapshotDifferences at: 'newer')
				at: currentPackageName
				ifAbsentPut: [Dictionary new].
	oldTimestamp := (diskTimestamps at: currentPackageName) ifNil: [^self].
	currentRemovals := (snapshotDifferences at: 'older')
				at: currentPackageName
				ifAbsentPut: [Dictionary with: 'Timestamp' -> oldTimestamp printString].
%

! Class implementation for 'CypressPackageManager'

!		Class methods for 'CypressPackageManager'

category: 'instance creation'
classmethod: CypressPackageManager
new

	^super new
		initialize;
		yourself
%

category: 'accessing'
classmethod: CypressPackageManager
packageNamePermutationsFor: aString
	"Answer the variations on possible package names from the specified string.
	 Each hyphen may possibly separate the package name from a suffix."

	| names |
	names := OrderedCollection new.
	aString doWithIndex: 
			[:each :index |
			(each = $- and: [index > 1])
				ifTrue: [names add: (aString copyFrom: 1 to: index - 1)]].
	aString last ~= $- ifTrue: [names add: aString].
	^names
%

category: 'accessing'
classmethod: CypressPackageManager
potentialPackageNames
	"Answer a list of 'package names' from classes and methods.
	 The class category is the package name, if the class is in a package at all.
	 The method category begins with an asterisk (*) before the package name,
	 but can be continued with other details (e.g., *PackageName-accessing).
	 This version does NOT recognize method category suffixes."

	| classCategories methodCategories |
	classCategories := Set new.
	methodCategories := Set new.
	System myUserProfile symbolList do: 
			[:dict |
			dict do: 
					[:aClass |
					aClass isBehavior and: 
							[classCategories addAll: (self packageNamePermutationsFor: aClass category).
							aClass categorysDo: 
									[:cat :method |
									cat first = $*
										ifTrue: 
											[methodCategories
												addAll: (self packageNamePermutationsFor: (cat copyFrom: 2 to: cat size))]].
							false]]].
	^(Set new)
		addAll: classCategories;
		addAll: methodCategories;
		removeIfPresent: 'User Classes';
		removeIfPresent: 'Kernel';
		sortAscending
%

!		Instance methods for 'CypressPackageManager'

category: 'comparing'
method: CypressPackageManager
compareDefinitionsFromConflictedPackageInformation: aCypressPackageInformation

	| badDefinitions expectedDefinitions |
	badDefinitions := (CypressPackageStructure
				fromPackage: (CypressPackageDefinition
						named: aCypressPackageInformation name))
					snapshot definitions
				asSet.
	expectedDefinitions := OrderedCollection new.
	aCypressPackageInformation competingPackageNames do: 
			[:each |
			expectedDefinitions
				addAll: (CypressPackageStructure
						fromPackage: (CypressPackageDefinition named: each)) snapshot
						definitions].
	expectedDefinitions do: [:each | badDefinitions remove: each ifAbsent: []].
	^(badDefinitions collect: [:each | each printString]) sortAscending
%

category: 'comparing'
method: CypressPackageManager
comparePackageFrom: aCypressPackageInformation

	^self comparePackagesFrom: (Array with: aCypressPackageInformation)
%

category: 'updating - private'
method: CypressPackageManager
determineKnownPackages

	^(packageInformationList select: [:each | each repository notNil])
		inject: Dictionary new
		into: 
			[:dict :each |
			dict
				at: each name put: each savedLocation;
				yourself]
%

category: 'initializing - private'
method: CypressPackageManager
initialize

	self refreshPackageInformation.
%

category: 'initializing - private'
method: CypressPackageManager
initializeConflictingPackageNames

	| conflictingPackages |
	conflictingPackages := Dictionary new.
	packageInformationList do: 
			[:each |
			conflictingPackages at: each
				put: (knownPackages keys select: 
							[:knownName |
							knownName ~= each name
								and: [(knownName indexOfSubCollection: each name , '-' startingAt: 1 ifAbsent: [ 0 ]) = 1]])].
	conflictingPackages := conflictingPackages reject: [:each | each isEmpty].
	conflictingPackages
		keysAndValuesDo: [:package :conflicts | package beConflictedWith: conflicts]
%

category: 'initializing - private'
method: CypressPackageManager
initializeKnownPackages

	knownPackages := (System myUserProfile objectNamed: #KnownCypressPackages)
				ifNil: [Dictionary new]
%

category: 'initializing - private'
method: CypressPackageManager
initializeKnownRepositories

	knownRepositories := Dictionary new.
	knownPackages asSet
		do: [:each | self repositoryOn: each]
%

category: 'initializing - private'
method: CypressPackageManager
initializePackageInformationList

	| allInterestingNames |
	allInterestingNames := Set new
		addAll: self potentialPackageNames;
		addAll: knownPackages keys;
		sortAscending.
	packageInformationList := allInterestingNames collect: 
					[:each |
					| directory repo |
					directory := knownPackages at: each ifAbsent: [nil].
					repo := directory ifNotNil: [self repositoryOn: directory].
					CypressPackageInformation named: each repository: repo]
%

category: 'initializing - private'
method: CypressPackageManager
initializeQualifiedPackageNames

	| qualifiedPackages |
	qualifiedPackages := Dictionary new.
	packageInformationList do: 
			[:each |
			qualifiedPackages at: each
				put: (knownPackages keys select: 
							[:knownName |
							knownName ~= each name
								and: [(each name indexOfSubCollection: knownName , '-' startingAt: 1 ifAbsent: [ 0 ]) = 1]])].
	qualifiedPackages := qualifiedPackages reject: [:each | each isEmpty].
	qualifiedPackages
		keysAndValuesDo: [:package :baseNames | package beQualifiedNameOf: baseNames]
%

category: 'updating'
method: CypressPackageManager
loadPackageFrom: aCypressPackageInformation

	| summary loader |
	loader := (CypressSnapshot definitions: aCypressPackageInformation savedDefinitions)
				updatePackage: (CypressPackageDefinition named: aCypressPackageInformation name).
	summary := Dictionary new.

	loader unloadable notEmpty
		ifTrue: [summary at: 'Unloadable' put: (loader unloadable collect: [:each | each printString])].
	loader errors notEmpty
		ifTrue: [summary at: 'Errors' put: (loader errors collect: [:each | each printString])].
	loader requirements notEmpty
		ifTrue: [summary at: 'Missing Requirements' put: loader requirements asArray].

	^summary
%

category: 'updating'
method: CypressPackageManager
lookForLoadedPackagesIn: aDirectory
	"Update any of the packages in the image which have a Cypress file out in
	 the specified directory to reflect the path where the package has theoretically
	 been saved."

	self lookForLoadedPackagesInRepository: (self repositoryOn: aDirectory).
	^nil
%

category: 'updating'
method: CypressPackageManager
lookForLoadedPackagesInRepository: aCypressRepository
	"Update any of the packages in the image which have a Cypress file out in
	 the specified directory to reflect the path where the package has theoretically
	 been saved."

	| packageNames |
	packageNames := aCypressRepository packageNames.
	(self packageInformationList
		select: [:each | packageNames includes: each name])
			do: [:each | each updateKnownPackageRepository: aCypressRepository].
	self saveKnownPackages.
	^nil
%

category: 'updating'
method: CypressPackageManager
lookForUnloadedPackagesIn: aDirectory
	"Load any package names from aDirectory as known packages.
	 This does not load the package contents."

	self lookForUnloadedPackagesInRepository: (self repositoryOn: aDirectory).
	^nil
%

category: 'updating'
method: CypressPackageManager
lookForUnloadedPackagesInRepository: aCypressRepository
	"Add known packages for any Cypress file outs in the specified directory."

	| packageNames existingPackageNames |
	packageNames := aCypressRepository packageNames.
	(self packageInformationList
		select: [:each | packageNames includes: each name])
			do: [:each | each updateKnownPackageRepository: aCypressRepository].
	existingPackageNames := self packageInformationList
				collect: [:each | each name].
	(packageNames reject: [:each | existingPackageNames includes: each])
		do: 
			[:each |
			self packageInformationList
				add: (CypressPackageInformation named: each repository: aCypressRepository)].
	self saveKnownPackages.
	^nil
%

category: 'accessing'
method: CypressPackageManager
packageInformationList

	^packageInformationList
%

category: 'accessing'
method: CypressPackageManager
potentialPackageNames

	^self class potentialPackageNames
%

category: 'accessing'
method: CypressPackageManager
refreshedPackageInformationList

	self refreshPackageInformation.
	^self packageInformationList.
%

category: 'updating'
method: CypressPackageManager
refreshPackageInformation

	self
		initializeKnownPackages;
		initializeKnownRepositories;
		initializePackageInformationList;
		initializeConflictingPackageNames;
		initializeQualifiedPackageNames
%

category: 'initializing - private'
method: CypressPackageManager
repositoryOn: aDirectory

	^knownRepositories
		at: aDirectory
		ifAbsentPut: [CypressFileSystemRepository on: aDirectory].
%

category: 'updating - private'
method: CypressPackageManager
saveKnownPackages

	self updateKnownPackages.
	((System myUserProfile resolveSymbol: #KnownCypressPackages)
		ifNil: 
			[(System myUserProfile objectNamed: #UserGlobals)
				addAssociation: #KnownCypressPackages -> Dictionary new])
			value: knownPackages
%

category: 'updating - private'
method: CypressPackageManager
updateKnownPackages

	knownPackages := self determineKnownPackages
%

category: 'updating'
method: CypressPackageManager
updateSavedLocation: aDirectory for: aCypressPackageInformation
	"Update the specified package to reflect the path and repository where the
	 package should be saved."

	aCypressPackageInformation
		updateKnownPackageRepository: (self repositoryOn: aDirectory).
	self saveKnownPackages.
	^nil
%

category: 'writing - private'
method: CypressPackageManager
writeCypressPackageToDiskFrom: aCypressPackageInformation

	| packageStructure |
	packageStructure := CypressPackageStructure
				fromPackage: (CypressPackageDefinition
						named: aCypressPackageInformation name).
	aCypressPackageInformation repository writer
		writePackageStructure: packageStructure
%

category: 'writing'
method: CypressPackageManager
writePackagesToDiskFrom: someCypressPackageInformations

	| packageStructure |
	^someCypressPackageInformations do: 
			[:each |
			packageStructure := CypressPackageStructure
						fromPackage: (CypressPackageDefinition named: each name).
			each repository writer writePackageStructure: packageStructure.
			each refresh.
			self saveKnownPackages]
%

category: 'writing - private'
method: CypressPackageManager
writePackageStructure: packageStructure to: aCypressRepository

	aCypressRepository writer writePackageStructure: packageStructure
%

category: 'writing'
method: CypressPackageManager
writePackageToDiskFrom: aCypressPackageInformation

	^self writePackagesToDiskFrom: (Array with: aCypressPackageInformation)
%

! Class implementation for 'CypressPackageManager2'

!		Class methods for 'CypressPackageManager2'

category: 'Instance Creation'
classmethod: CypressPackageManager2
create

	^self new
		initializeFromImage;
		yourself.
%

category: 'Initializing'
classmethod: CypressPackageManager2
initialize

	self savedPackageManagers: IdentityDictionary new
%

category: 'Accessing'
classmethod: CypressPackageManager2
named: aKey
	"Answer the Package Manager previously saved under aKey.
	 It is an error if there was not one saved under that key."

	^self
		named: aKey
		or: [self error: 'No previously saved Package Manager under the key ', aKey printString]
%

category: 'Accessing'
classmethod: CypressPackageManager2
named: aKey or: aBlock
	"Answer the Package Manager previously saved under aKey.
	 Answer the result of evaluating aBlock, if there was not one saved under that key."

	^self savedPackageManagers at: aKey ifAbsent: aBlock
%

category: 'Instance Creation'
classmethod: CypressPackageManager2
new

	^super new
		initialize;
		yourself.
%

category: 'Accessing - private'
classmethod: CypressPackageManager2
packageNamePermutationsFor: aString
	"Answer the variations on possible package names from the specified string.
	 Each hyphen may possibly separate the package name from a suffix."

	| names |
	names := OrderedCollection new.
	aString doWithIndex: 
			[:each :index |
			(each = $- and: [index > 1])
				ifTrue: [names add: (aString copyFrom: 1 to: index - 1)]].
	aString last ~= $- ifTrue: [names add: aString].
	^names
%

category: 'Accessing - private'
classmethod: CypressPackageManager2
potentialPackageNames
	"Answer a list of 'package names' from classes and methods.
	 The class category is the package name, if the class is in a package at all.
	 The method category begins with an asterisk (*) before the package name,
	 but can be continued with other details (e.g., *PackageName-accessing).
	 This version does NOT recognize method category suffixes."

	| classCategories methodCategories |
	classCategories := Set new.
	methodCategories := Set new.
	System myUserProfile symbolList do: 
			[:dict |
			dict do: 
					[:aClass |
					aClass isBehavior and: 
							[classCategories addAll: (self packageNamePermutationsFor: aClass category).
							aClass categorysDo: 
									[:cat :method |
									cat first = $*
										ifTrue: 
											[methodCategories
												addAll: (self packageNamePermutationsFor: (cat copyFrom: 2 to: cat size))]].
							false]]].
	^(Set new)
		addAll: classCategories;
		addAll: methodCategories;
		removeIfPresent: 'User Classes';
		removeIfPresent: 'Kernel';
		sortAscending
%

category: 'Updating'
classmethod: CypressPackageManager2
removePackageManagerSavedAs: aKey
	"Remove the Package Manager previously saved under aKey, if there was one.
	 Answer it or nil if there was not one saved under that key."

	^self savedPackageManagers removeKey: aKey ifAbsent: []
%

category: 'Accessing'
classmethod: CypressPackageManager2
savedPackageManagers

	^SavedPackageManagers
%

category: 'Initializing - private'
classmethod: CypressPackageManager2
savedPackageManagers: anIdentityDictionary

	SavedPackageManagers := anIdentityDictionary
%

!		Instance methods for 'CypressPackageManager2'

category: 'Updating'
method: CypressPackageManager2
addRepository: aRepository to: aKnownPackageInformation

	aKnownPackageInformation addRepository: aRepository.
%

category: 'Updating'
method: CypressPackageManager2
addUnknownPackageNamed: aString

	self packageInformationList
		at: aString
		put: (CypressUnknownPackageInformation named: aString).
%

category: 'Querying'
method: CypressPackageManager2
allResolvedPackageReferences
  | resolved |
  resolved := OrderedCollection new.
  self knownRepositories
    keysAndValuesDo: [ :repoUrl :repo | 
      repo packageNames
        do: [ :packageName | resolved add: (CypressResolvedReference name: packageName repository: repo) ] ].
  ^ resolved asSortedCollection asArray
%

category: 'Updating'
method: CypressPackageManager2
assignRepository: aRepository to: aPackageInformation

	self assignRepository: aRepository toAll: (Array with: aPackageInformation)
%

category: 'Updating'
method: CypressPackageManager2
assignRepository: aRepository toAll: somePackageInformations
	"Assign to those having no repository information and add to those with.
	 Those without a repository need to be converted to Known Package Information instances."

	self knownRepositories at: aRepository url put: aRepository.
	(somePackageInformations reject: [:each | each isKnown])
		do: [:each | self addRepository: aRepository to: (self convertToKnown: each)].
	(somePackageInformations select: [:each | each isKnown])
		do: [:each | self addRepository: aRepository to: each].
%

category: 'Updating'
method: CypressPackageManager2
convert: anUnknownPackageInformation toConflictingWith: aKnownPackageInformation

	| conflicting |
	conflicting := CypressConflictingPackageInformation
				fromUnknown: anUnknownPackageInformation
				conflictingWith: aKnownPackageInformation.
	self replace: anUnknownPackageInformation with: conflicting.
	^conflicting
%

category: 'Updating'
method: CypressPackageManager2
convert: anUnknownPackageInformation toEclipsedBy: aKnownPackageInformation

	| eclipsed |
	eclipsed := CypressEclipsedPackageInformation
				fromUnknown: anUnknownPackageInformation
				eclipsedBy: aKnownPackageInformation.
	self replace: anUnknownPackageInformation with: eclipsed.
	^eclipsed
%

category: 'Updating'
method: CypressPackageManager2
convertToKnown: aPackageInformation

	| known |
	known := CypressKnownPackageInformation fromUnknown: aPackageInformation.
	self replace: aPackageInformation with: known.
	(self findPackagesEclipsedBy: known) do: [:each | self convert: each toEclipsedBy: known].
	(self findPackagesConflictingWith: known) do: [:each | self convert: each toConflictingWith: known].
	^known.
%

category: 'Updating'
method: CypressPackageManager2
createRepositoryNamed: aName under: aDirectory alias: aString schema: schemaName

	^CypressFileSystemRepository createOn: (CypressUrl
				absoluteFromText: schemaName
						, (CypressFileUtilities current directoryFromPath: aName
								relativeTo: aDirectory)
							, '/')
		alias: aString
%

category: 'Accessing - private'
method: CypressPackageManager2
findPackagesConflictingWith: aKnownPackageInformation

	^self packageInformationList select: 
			[:each |
			aKnownPackageInformation name ~= each name and: 
					[(aKnownPackageInformation name indexOfSubCollection: each name , '-' startingAt: 1 ifAbsent: [ 0 ]) = 1]]
%

category: 'Accessing - private'
method: CypressPackageManager2
findPackagesEclipsedBy: aKnownPackageInformation

	^self packageInformationList select: 
			[:each |
			aKnownPackageInformation name ~= each name and: 
					[(each name indexOfSubCollection: aKnownPackageInformation name , '-' startingAt: 1 ifAbsent: [ 0 ]) = 1]]
%

category: 'Initializing - private'
method: CypressPackageManager2
initialize

	self
		knownRepositories: Dictionary new;
		packageInformationList: Dictionary new
%

category: 'Initializing - private'
method: CypressPackageManager2
initializeFromImage

	self initializePackageInformationList.
%

category: 'Initializing - private'
method: CypressPackageManager2
initializePackageInformationList

	self
		packageInformationList: (self potentialPackageNames
				inject: Dictionary new
				into: 
					[:dict :each |
					dict
						at: each put: (CypressUnknownPackageInformation named: each);
						yourself])
%

category: 'Accessing'
method: CypressPackageManager2
knownRepositories

	^knownRepositories
%

category: 'Updating'
method: CypressPackageManager2
knownRepositories: someNamedRepositories

	knownRepositories := someNamedRepositories
%

category: 'Loading'
method: CypressPackageManager2
loadPackageFrom: aKnownPackageInformation defaultSymbolDictionaryName: defaultSymbolDictionaryNameOrNil inRepository: aRepository
  | snapshot summary loader |
  snapshot := (aRepository
    readPackageStructureForPackageNamed: aKnownPackageInformation name) snapshot.
  loader := snapshot
    updatePackage:
      (CypressPackageDefinition named: aKnownPackageInformation name)
    defaultSymbolDictionaryName: defaultSymbolDictionaryNameOrNil.
  summary := Dictionary new.
  loader unloadable notEmpty
    ifTrue: [ 
      summary
        at: 'Unloadable'
        put: (loader unloadable collect: [ :each | each printString ]) ].
  loader errors notEmpty
    ifTrue: [ summary at: 'Errors' put: (loader errors collect: [ :each | each printString ]) ].
  loader requirements notEmpty
    ifTrue: [ summary at: 'Missing Requirements' put: loader requirements asArray ].
  ^ summary
%

category: 'Loading'
method: CypressPackageManager2
loadPackageFrom: aKnownPackageInformation inRepository: aRepository
  ^ self
    loadPackageFrom: aKnownPackageInformation
    defaultSymbolDictionaryName: nil
    inRepository: aRepository
%

category: 'Updating'
method: CypressPackageManager2
lookForPackagesInRepository: aRepository
	"Find the packages in the repository and update the list
	 of package information accordingly."

	| packageNames inImage exImage |
	packageNames := aRepository packageNames.
	inImage := self packageInformationList asArray select: [:each | packageNames includes: each name].
	exImage := packageNames reject: [:each | self packageInformationList anySatisfy: [:info | info name = each]].
	exImage := exImage collect: [:each | CypressUnknownPackageInformation named: each].

	self assignRepository: aRepository toAll: inImage, exImage
%

category: 'Accessing'
method: CypressPackageManager2
packageInformationList

	^packageInformationList
%

category: 'Updating'
method: CypressPackageManager2
packageInformationList: someNamedPackageInformations

	packageInformationList := someNamedPackageInformations
%

category: 'Accessing'
method: CypressPackageManager2
packageInformationNamed: aString

	^self packageInformationNamed: aString
		or: [self error: 'No package information for ' , aString printString]
%

category: 'Accessing'
method: CypressPackageManager2
packageInformationNamed: aString or: aBlock

	^self packageInformationList
		at: aString
		ifAbsent: aBlock.
%

category: 'Accessing - private'
method: CypressPackageManager2
potentialPackageNames

	^self class potentialPackageNames
%

category: 'Updating'
method: CypressPackageManager2
replace: oldPackageInformation with: newPackageInformation

	self packageInformationList
		at: oldPackageInformation name
		put: newPackageInformation.
%

category: 'Initializing - private'
method: CypressPackageManager2
repositoryOn: url alias: aString
	"Answer a repository instance for the specified URL.
	 The characteristics will come from the properties file at the URL location,
	 or will default according to the schema, if there is no properties file."

	^self knownRepositories
		at: url
		ifAbsentPut: [CypressAbstractRepository onUrl: url alias: aString].
%

category: 'Updating'
method: CypressPackageManager2
saveAs: aKey
	"Save the receiver in the class' collection of named managers
	 under the specified key.
	 It will quietly replace anything already under that key."


	self savedPackageManagers at: aKey put: self.
%

category: 'Accessing - private'
method: CypressPackageManager2
savedPackageManagers

	^self class savedPackageManagers
%

category: 'Writing'
method: CypressPackageManager2
writeChangesToAllRepositoriesFor: aPackageInformation

	aPackageInformation writeChangesToAllRepositories.
%

! Class implementation for 'CypressPackageManager3'

!		Class methods for 'CypressPackageManager3'

category: 'testing'
classmethod: CypressPackageManager3
isPackageLoaded: aPackageName

  ^ (CypressPackageDefinition named: aPackageName) snapshot definitions isEmpty not
%

category: 'instance creation'
classmethod: CypressPackageManager3
new
  ^self basicNew initialize
%

!		Instance methods for 'CypressPackageManager3'

category: 'Updating'
method: CypressPackageManager3
addRepository: aRepository
  self knownRepositories at: aRepository url asString put: aRepository
%

category: 'Updating'
method: CypressPackageManager3
addResolvedReference: resolvedReference
  self resolvedPackageReferences add: resolvedReference
%

category: 'Querying'
method: CypressPackageManager3
allResolvedPackageReferences
  | resolved |
  resolved := OrderedCollection new.
  self knownRepositories
    keysAndValuesDo: [ :repoUrl :repo | 
      repo packageNames
        do: [ :packageName | resolved add: (CypressResolvedReference name: packageName repository: repo) ] ].
  ^ resolved asSortedCollection asArray
%

category: 'initialization'
method: CypressPackageManager3
defaultSymbolDictionaryName

  ^defaultSymbolDictionaryName
%

category: 'initialization'
method: CypressPackageManager3
defaultSymbolDictionaryName: aStringOrNil

  defaultSymbolDictionaryName := aStringOrNil
%

category: 'Updating'
method: CypressPackageManager3
initialize
  self
    knownRepositories: Dictionary new;
    resolvedPackageReferences: OrderedCollection new;
    yourself
%

category: 'Accessing'
method: CypressPackageManager3
knownRepositories

   ^knownRepositories
%

category: 'Accessing'
method: CypressPackageManager3
knownRepositories: anObject

   knownRepositories := anObject
%

category: 'loading'
method: CypressPackageManager3
loadResolvedReference: resolvedReference
  | cypressLoader package repository snapshot |
  cypressLoader := CypressLoader new.
  cypressLoader defaultSymbolDictionaryName: self defaultSymbolDictionaryName.
  package := resolvedReference packageDefinition.
  repository := resolvedReference repository.
  snapshot := (repository
    readPackageStructureForPackageNamed: resolvedReference name) snapshot.
  cypressLoader updatePackage: package withSnapshot: snapshot.
  cypressLoader load.
  cypressLoader unloadable notEmpty
    ifTrue: [ self error: 'Unloadable definitions' ].
  cypressLoader errors notEmpty
    ifTrue: [ self error: 'Load errors' ].
  cypressLoader requirements notEmpty
    ifTrue: [ self error: 'Missing Requirements' ]
%

category: 'loading'
method: CypressPackageManager3
loadResolvedReferences
  | cypressLoader |
  cypressLoader := CypressLoader new.
  cypressLoader defaultSymbolDictionaryName: self defaultSymbolDictionaryName.
  self resolvedPackageReferences
    do: [ :resolvedReference | | package repository snapshot |
      package := resolvedReference packageDefinition.
      repository := resolvedReference repository.
      snapshot := (repository
        readPackageStructureForPackageNamed: resolvedReference name) snapshot.
      cypressLoader updatePackage: package withSnapshot: snapshot ].
  cypressLoader load.
  cypressLoader unloadable notEmpty
    ifTrue: [ self error: 'Unloadable definitions' ].
  cypressLoader errors notEmpty
    ifTrue: [ self error: 'Load errors' ].
  cypressLoader requirements notEmpty
    ifTrue: [ self error: 'Missing Requirements' ]
%

category: 'Accessing'
method: CypressPackageManager3
resolvedPackageReferences
  ^ resolvedPackageReferences
%

category: 'Accessing'
method: CypressPackageManager3
resolvedPackageReferences: anObject
  resolvedPackageReferences := anObject
%

category: 'Unloading'
method: CypressPackageManager3
unloadPackage: aPackage

  | loader summary |
  loader := (CypressPackageDefinition named: aPackage name) snapshot
              unload.
  summary := Dictionary new.
  loader unloadable notEmpty
    ifTrue: [ 
      summary
        at: 'Unloadable'
        put: (loader unloadable collect: [ :each | each printString ]) ].
  loader errors notEmpty
    ifTrue: [ summary at: 'Errors' put: (loader errors collect: [ :each | each printString ]) ].
  loader requirements notEmpty
    ifTrue: [ summary at: 'Missing Requirements' put: loader requirements asArray ].
  ^ summary
%

category: 'Unloading'
method: CypressPackageManager3
unloadPackageNamed: aPackageName
  ^ self unloadPackage: (CypressPackageDefinition named: aPackageName)
%

! Class implementation for 'CypressEnvironmentPackageManager'

!		Instance methods for 'CypressEnvironmentPackageManager'

category: 'accessing'
method: CypressEnvironmentPackageManager
compilationSymbolList
  ^ compilationSymbolList
    ifNil: [ compilationSymbolList := self defaultSymbolList ]
%

category: 'accessing'
method: CypressEnvironmentPackageManager
compilationSymbolList: anObject

   compilationSymbolList := anObject
%

category: 'accessing'
method: CypressEnvironmentPackageManager
defaultEnvironmentId

   ^defaultEnvironmentId
%

category: 'accessing'
method: CypressEnvironmentPackageManager
defaultEnvironmentId: anObject

   defaultEnvironmentId := anObject
%

category: 'accessing'
method: CypressEnvironmentPackageManager
defaultSymbolList

   ^defaultSymbolList
%

category: 'accessing'
method: CypressEnvironmentPackageManager
defaultSymbolList: anObject

   defaultSymbolList := anObject
%

category: 'loading'
method: CypressEnvironmentPackageManager
loadResolvedReferences
  | cypressLoader |
  cypressLoader := CypressEnvironmentLoader new.
  cypressLoader
    defaultSymbolDictionaryName: self defaultSymbolDictionaryName;
    compilationSymbolList: self compilationSymbolList;
    lookupSymbolList: self lookupSymbolList;
    defaultEnvironmentId: self defaultEnvironmentId.
  self resolvedPackageReferences
    do: [ :resolvedReference | 
      | package repository snapshot |
      package := resolvedReference packageDefinition.
      repository := resolvedReference repository.
      snapshot := (repository
        readPackageStructureForPackageNamed: resolvedReference name) snapshot.
      cypressLoader updatePackage: package withSnapshot: snapshot ].
  cypressLoader load.
  cypressLoader unloadable notEmpty
    ifTrue: [ self error: 'Unloadable definitions' ].
  cypressLoader errors notEmpty
    ifTrue: [ self error: 'Load errors' ].
  cypressLoader requirements notEmpty
    ifTrue: [ self error: 'Missing Requirements' ]
%

category: 'loading'
method: CypressEnvironmentPackageManager
loadResolvedReferences: fileNames
  | cypressLoader doUnloads |
  cypressLoader := CypressEnvironmentLoader new.
  cypressLoader
    defaultSymbolDictionaryName: self defaultSymbolDictionaryName;
    compilationSymbolList: self compilationSymbolList;
    lookupSymbolList: self lookupSymbolList;
    defaultEnvironmentId: self defaultEnvironmentId.
  self resolvedPackageReferences
    do: [ :resolvedReference | 
      | package repository snapshot |
      package := resolvedReference packageDefinition.
      repository := resolvedReference repository.
      snapshot := (repository
        readPackageStructureForPackageNamed: resolvedReference name
        files: fileNames ) snapshot.
      cypressLoader updatePackage: package withSnapshot: snapshot ].
  doUnloads := false .
  cypressLoader load: doUnloads .
  doUnloads ifTrue:[ cypressLoader unloadable notEmpty
      ifTrue: [ self error: 'Unloadable definitions' ]].
  cypressLoader errors notEmpty
    ifTrue: [ self error: 'Load errors' ].
  doUnloads ifTrue:[ cypressLoader requirements notEmpty
      ifTrue: [ self error: 'Missing Requirements' ]].
%

category: 'accessing'
method: CypressEnvironmentPackageManager
lookupSymbolList
  ^ lookupSymbolList ifNil: [ lookupSymbolList := self defaultSymbolList ]
%

category: 'accessing'
method: CypressEnvironmentPackageManager
lookupSymbolList: anObject

   lookupSymbolList := anObject
%

! Class implementation for 'CypressPackageStringComparator'

!		Class methods for 'CypressPackageStringComparator'

category: 'instance creation'
classmethod: CypressPackageStringComparator
comparingPackageNamed: packageName fromDirectory: aDirectory

	^(self new)
		comparingPackageNamed: packageName fromDirectory: aDirectory;
		yourself
%

category: 'instance creation'
classmethod: CypressPackageStringComparator
forCypress

	^(self new)
		comparingPackages: #('Cypress-Definitions' 'Cypress-Mocks' 'Cypress-Structure' 'Cypress-Tests' 'Cypress-GemStoneFileServer' 'Cypress-Comparison')
			fromDirectory: '/opt/git/CypressReferenceImplementation/';
		yourself
%

category: 'instance creation'
classmethod: CypressPackageStringComparator
new

	^super new
		initialize;
		yourself
%

!		Instance methods for 'CypressPackageStringComparator'

category: 'comparing - private'
method: CypressPackageStringComparator
addAddition: aCypressModification to: aCollection
  aCypressModification definition
    classDefinition: [ :classDefinition | self addClassAddition: aCypressModification to: aCollection ]
    methodDefinition: [ :methodDefinition | self addMethodAddition: aCypressModification to: aCollection ]
%

category: 'comparing - private'
method: CypressPackageStringComparator
addClassAddition: aCypressModification to: aCollection
  aCollection
    add:
      {(aCypressModification definition details).
      #'addition'.
      #'class'.
      (aCypressModification definition classDefinitionString)}
%

category: 'comparing - private'
method: CypressPackageStringComparator
addClassModification: aCypressModification to: aCollection
  aCollection
    add:
      {(aCypressModification modification details).
      #'modification'.
      #'class'.
      (aCypressModification obsoletion classDefinitionString).
      (aCypressModification modification classDefinitionString)}
%

category: 'comparing - private'
method: CypressPackageStringComparator
addClassRemoval: aCypressModification to: aCollection
  aCollection
    add:
      {(aCypressModification definition details).
      #'removal'.
      #'class'.
      (aCypressModification definition classDefinitionString)}
%

category: 'comparing - private'
method: CypressPackageStringComparator
addMethodAddition: aCypressModification to: aCollection
  aCollection
    add:
      {(aCypressModification definition details).
      #'addition'.
      #'method'.
      (aCypressModification definition source)}
%

category: 'comparing - private'
method: CypressPackageStringComparator
addMethodModification: aCypressModification to: aCollection
  aCollection
    add:
      {(aCypressModification modification details).
      #'modification'.
      #'method'.
      (aCypressModification obsoletion source).
      (aCypressModification modification source)}
%

category: 'comparing - private'
method: CypressPackageStringComparator
addMethodRemoval: aCypressModification to: aCollection
  aCollection
    add:
      {(aCypressModification definition details).
      #'removal'.
      #'method'.
      (aCypressModification definition source)}
%

category: 'comparing - private'
method: CypressPackageStringComparator
addModification: aCypressModification to: aCollection
  aCypressModification modification
    classDefinition: [ :classDefinition | self addClassModification: aCypressModification to: aCollection ]
    methodDefinition: [ :methodDefinition | self addMethodModification: aCypressModification to: aCollection ]
%

category: 'comparing - private'
method: CypressPackageStringComparator
addRemoval: aCypressModification to: aCollection
  aCypressModification definition
    classDefinition: [ :classDefinition | self addClassRemoval: aCypressModification to: aCollection ]
    methodDefinition: [ :methodDefinition | self addMethodRemoval: aCypressModification to: aCollection ]
%

category: 'comparing - private'
method: CypressPackageStringComparator
applyAddition: aCypressAddition
  self addAddition: aCypressAddition to: self currentOperations
%

category: 'comparing - private'
method: CypressPackageStringComparator
applyModification: aCypressModification
  self addModification: aCypressModification to: self currentOperations
%

category: 'comparing - private'
method: CypressPackageStringComparator
applyRemoval: aCypressRemoval
  self addRemoval: aCypressRemoval to: self currentOperations
%

category: 'comparing'
method: CypressPackageStringComparator
compare

	diskSnapshots keys do: [:packageName |
		self resetCurrentForPackage: packageName.
		self currentPatchOperations do: [:each | each applyTo: self].
	].
	self resetCurrentForPackage: nil.
%

category: 'initializing'
method: CypressPackageStringComparator
comparingPackages: someNames fromDirectory: aDirectory
  (directoryPackageMap at: aDirectory ifAbsentPut: [ OrderedCollection new ])
    addAll: someNames.
  someNames
    do: [ :packageName | 
      | reader |
      reader := (CypressFileSystemRepository on: aDirectory) reader
        readPackageStructureForPackageNamed: packageName.
      diskSnapshots at: packageName put: reader packageStructure snapshot.
      imageSnapshots
        at: packageName
        put: (CypressPackageDefinition named: packageName) snapshot ]
%

category: 'comparing - private'
method: CypressPackageStringComparator
currentDiskSnapshot

	^diskSnapshots at: currentPackageName
%

category: 'comparing - private'
method: CypressPackageStringComparator
currentImageSnapshot

	^imageSnapshots at: currentPackageName
%

category: 'comparing - private'
method: CypressPackageStringComparator
currentOperations
  (self dynamicInstVarAt: #'currentOperations')
    ifNil: [ self updateCurrentOperations ].
  ^ self dynamicInstVarAt: #'currentOperations'
%

category: 'comparing - private'
method: CypressPackageStringComparator
currentOperations: aDictionary
  self dynamicInstVarAt: #'currentOperations' put: aDictionary
%

category: 'comparing - private'
method: CypressPackageStringComparator
currentPatchOperations

	^(CypressPatch fromBase: self currentDiskSnapshot toTarget: self currentImageSnapshot) operations.
%

category: 'comparing'
method: CypressPackageStringComparator
getDifferences

	self compare.
	^self snapshotDifferences
%

category: 'initializing - private'
method: CypressPackageStringComparator
initialize
  directoryPackageMap := Dictionary new.
  diskTimestamps := Dictionary new.
  diskSnapshots := Dictionary new.
  imageSnapshots := Dictionary new.
  snapshotDifferences := Dictionary new
    at: 'operations' put: Dictionary new;
    yourself
%

category: 'comparing - private'
method: CypressPackageStringComparator
resetCurrentForPackage: aStringOrNil
  currentPackageName := aStringOrNil.
  self currentOperations: nil
%

category: 'accessing'
method: CypressPackageStringComparator
snapshotDifferences

	^snapshotDifferences
%

category: 'comparing - private'
method: CypressPackageStringComparator
updateCurrentOperations
  self
    currentOperations:
      ((snapshotDifferences at: 'operations')
        at: currentPackageName
        ifAbsentPut: [ OrderedCollection new ])
%

! Class implementation for 'CypressReference'

!		Class methods for 'CypressReference'

category: 'instance creation'
classmethod: CypressReference
name: aString
  ^ self basicNew initializeName: aString
%

category: 'instance creation'
classmethod: CypressReference
new
  self error: 'Use #name: to initialize the receiver.'
%

!		Instance methods for 'CypressReference'

category: 'comparing'
method: CypressReference
= aReference
	^ self class = aReference class and: [ self name = aReference name ]
%

category: 'comparing'
method: CypressReference
hash
	^ self name hash
%

category: 'initialization'
method: CypressReference
initializeName: aString
	name := aString
%

category: 'private'
method: CypressReference
matches: aResolvedReference
  "Answer true if the receiver matches aResolvedReference."

  self subclassResponsibility: #'matches:'
%

category: 'accessing'
method: CypressReference
name
	"Answer the name of this reference."
	
	^ name
%

category: 'accessing'
method: CypressReference
packageName
  "Answer the package name."

  self subclassResponsibility: #'packageName'
%

category: 'printing'
method: CypressReference
printOn: aStream
  aStream
    nextPutAll: self class name;
    nextPutAll: ' name: ';
    print: self name
%

category: 'querying'
method: CypressReference
resolveAllWith: aPackageManager
  "Answer a sorted collection of all resolved references within aGofer."

  ^ aPackageManager allResolvedPackageReferences
    select: [ :each | self matches: each ]
%

! Class implementation for 'CypressPackageReference'

!		Instance methods for 'CypressPackageReference'

category: 'accessing'
method: CypressPackageReference
branch
	"Answer the branch of the receiver."
	
	^ branch
%

category: 'initialization'
method: CypressPackageReference
initializeName: aString
	super initializeName: aString.
	self parseName: aString
%

category: 'private'
method: CypressPackageReference
matches: aResolvedReference
  ^ self name = aResolvedReference name
%

category: 'accessing'
method: CypressPackageReference
packageDefinition
  "For in-image packages, only the base package name is used (no branch)"

  ^ CypressPackageDefinition named: self packageName
%

category: 'accessing'
method: CypressPackageReference
packageName
  "Answer the package of the receiver."

  ^ package
%

category: 'initialization'
method: CypressPackageReference
parseName: aString
  | basicName index |
  basicName := aString.
  index := basicName indexOfSubCollection: '.' startingAt: 1.
  index = 0
    ifTrue: [ 
      package := basicName.
      branch := '' ]
    ifFalse: [ 
      package := basicName copyFrom: 1 to: index - 1.
      branch := basicName copyFrom: index to: basicName size ]
%

! Class implementation for 'CypressResolvedReference'

!		Class methods for 'CypressResolvedReference'

category: 'instance creation'
classmethod: CypressResolvedReference
name: aString repository: aRepository
	^ self basicNew initializeName: aString repository: aRepository
%

!		Instance methods for 'CypressResolvedReference'

category: 'comparing'
method: CypressResolvedReference
<= aResolvedReference
  ^ self name <= aResolvedReference name
%

category: 'initialization'
method: CypressResolvedReference
initializeName: aString repository: aRepository
	self initializeName: aString.
	repository := aRepository
%

category: 'accessing'
method: CypressResolvedReference
repository
	"Answer the repository of the receiver."
	
	^ repository
%

! Class implementation for 'CypressUrl'

!		Class methods for 'CypressUrl'

category: 'instance creation'
classmethod: CypressUrl
absoluteFromFileNameOrUrlString: aString
	"Return a URL from and handle Strings without schemes
	as local relative FileUrls instead of defaulting to a HttpUrl
	as absoluteFromText: does."

	^(CypressUrl schemeNameForString: aString)
		ifNil: [CypressFileUrl workingDirectory newFromRelativeText: aString]
		ifNotNil: [CypressUrl absoluteFromText: aString]
%

category: 'instance creation'
classmethod: CypressUrl
absoluteFromText: aString
	"Return a URL from a string and handle
	a String without a scheme as a HttpUrl."

	"CypressUrl absoluteFromText: 'http://chaos.resnet.gatech.edu:8000/docs/java/index.html?A%20query%20#part'" 
	"CypressUrl absoluteFromText: 'msw://chaos.resnet.gatech.edu:9000/testbook?top'"
	"CypressUrl absoluteFromText: 'telnet:chaos.resnet.gatech.edu'"
	"CypressUrl absoluteFromText: 'file:/etc/passwd'"

	| remainder index scheme fragment newUrl |
	"trim surrounding whitespace"
	remainder := aString trimSeparators.

	"extract the fragment, if any"
	index := remainder indexOf: $#.
	index > 0 ifTrue: [
		fragment := remainder copyFrom: index + 1 to: remainder size.
		remainder := remainder copyFrom: 1 to: index - 1].

	"choose class based on the scheme name, and let that class do the bulk of the parsing"
	scheme := self schemeNameForString: remainder.
	newUrl := (self urlClassForScheme: scheme) new privateInitializeFromText: remainder.
	newUrl privateFragment: fragment.
	^newUrl
%

category: 'parsing'
classmethod: CypressUrl
combine: baseURL withRelative: relURL 
	"Take two URL as string form, combine them and return the corresponding URL in string form"

	^((self absoluteFromText: baseURL) newFromRelativeText: relURL) asString
%

category: 'instance creation'
classmethod: CypressUrl
for: aString
	"Return a URL from a string and handle
	a String without a scheme as a HttpUrl."

	^self absoluteFromText: aString
%

category: 'encoding'
classmethod: CypressUrl
isCharacterSafeForHttp: aChar
	"Answer whether a character is 'safe', or needs to be escaped when used, eg, in a URL."

	^aChar codePoint < 128
		and: [aChar isAlphaNumeric or: ['.-_' includes: aChar]]
%

category: 'constants'
classmethod: CypressUrl
schemeName
	"When searching for a class to handle a particular scheme, make sure that Url classes never match by default. This is so that abstract Url classes e.g. HierarchicalUrl can be iterated over, but will not be selected"

	^ nil.
%

category: 'parsing'
classmethod: CypressUrl
schemeNameForString: aString
	"Get the scheme name from a string, or return nil if it's not specified. 
	Used in internal parsing routines - an outsider may as well use asUrl. 
	Return scheme in lowercases."
	
	"Url schemeNameForString: 'http://www.yahoo.com'"
	"Url schemeNameForString: '/etc/passwed'"
	"Url schemeNameForString: '/etc/testing:1.2.3'"

	| index schemeName |
	index := aString indexOf: $: ifAbsent: [^ nil].
	schemeName := aString copyFrom: 1 to: index - 1.
	(schemeName allSatisfy: [:each | each isLetter]) ifFalse: [^ nil].
	^ schemeName asLowercase
%

category: 'parsing'
classmethod: CypressUrl
urlClassForScheme: scheme

	| allSubclasses |
	allSubclasses := self userId = System myUserProfile userId
		ifTrue: [ ClassOrganizer new allSubclassesOf: self ]
		ifFalse: [ (ClassOrganizer newWithRoot: self forUserId: self userId) allSubclassesOf: self ].
	^allSubclasses detect: [:urlClass | urlClass schemeName = scheme]
		ifNone: [CypressGenericUrl]
%

category: 'encoding'
classmethod: CypressUrl
writeWithHttpEscapes: aCollection on: aStream
	"Write the given string or Utf8 on the stream with 'dangerous' characters 
	escaped to their %XX form, for use in HTTP transactions.
	Note that Utf8s containing code points over 128 will not work properly here."

	aCollection do: 
			[:each |
			| char |
			char := each asCharacter.
			(self isCharacterSafeForHttp: char)
				ifTrue: [aStream nextPut: char]
				ifFalse: 
					[| int |
					aStream nextPut: $%.
					int := each asInteger.
					int // 16 printOn: aStream base: 16 showRadix: false.
					int \\ 16 printOn: aStream base: 16 showRadix: false]]
%

!		Instance methods for 'CypressUrl'

category: 'downloading'
method: CypressUrl
activate
	"spawn an external handler for this URL"
	
%

category: 'converting'
method: CypressUrl
asString

	^self printString
%

category: 'converting'
method: CypressUrl
asURI
	^self asString asURI
%

category: 'converting'
method: CypressUrl
asUrl
	^self
%

category: 'converting'
method: CypressUrl
asUrlRelativeTo: aUrl
	^self
%

category: 'accessing'
method: CypressUrl
authority
	^''
%

category: 'encoding'
method: CypressUrl
decodeHttpEscapesOf: aString
	"decode string including %XX form
	 (adapted from Pharo 2.0)"

	| unescaped pos sourceSize |
	unescaped := ReadWriteStreamPortable on: String new.
	pos := 1.
	sourceSize := aString size.
	[pos > sourceSize] whileFalse: 
			[| char |
			char := aString at: pos.
			(char = $% and: [pos + 2 <= sourceSize])
				ifTrue: 
					[| asciiVal |
					asciiVal := ((aString at: pos + 1) asUppercase digitValueInRadix: 16) * 16
								+ ((aString at: pos + 2) asUppercase digitValueInRadix: 16).
					asciiVal > 255 ifTrue: [^aString].
					unescaped nextPut: (Character withValue: asciiVal).
					pos := pos + 3]
				ifFalse: 
					[char = $+
						ifTrue: [unescaped nextPut: Character space]
						ifFalse: [unescaped nextPut: char].
					pos := pos + 1]].
	^unescaped contents
%

category: 'converting'
method: CypressUrl
downloadUrl
	^self asString
%

category: 'fragment'
method: CypressUrl
fragment
	^fragment
%

category: 'downloading'
method: CypressUrl
hasContents
	"whether this URL can download contents to be displayed; if not, it fundamentally requires an outside application to deal with it.  For example, mailto: and telnet: urls"
	^false
%

category: 'parsing'
method: CypressUrl
newFromRelativeText: aString
	"return a URL relative to the current one, given by aString.  For instance, if self is 'http://host/dir/file', and aString is '/dir2/file2', then the return will be a Url for 'http://host/dir2/file2'"

	"if the scheme is the same, or not specified, then use the same class"

	| newSchemeName remainder fragmentStart newFragment newUrl bare |

	bare := aString trimSeparators.
	newSchemeName := CypressUrl schemeNameForString: bare.
	(newSchemeName notNil and: [ newSchemeName ~= self schemeName ]) ifTrue: [
		"different scheme -- start from scratch"
		^CypressUrl absoluteFromText: aString ].

	remainder := bare.

	"remove the fragment, if any"
	fragmentStart := remainder indexOf: $#.
	fragmentStart > 0 ifTrue: [
		newFragment := remainder copyFrom: fragmentStart+1 to: remainder size. 
		remainder := remainder copyFrom: 1 to: fragmentStart-1].

	"remove the scheme name"
	newSchemeName ifNotNil: [
		remainder := remainder copyFrom: (newSchemeName size + 2) to: remainder size ].

	"create and initialize the new url"
	newUrl := self class new privateInitializeFromText: remainder  relativeTo: self.


	"set the fragment"
	newUrl privateFragment: newFragment.


	^newUrl
%

category: 'printing'
method: CypressUrl
printOn: aStream

	^self subclassResponsibility: #printOn:
%

category: 'fragment'
method: CypressUrl
privateFragment: aString
	fragment := aString
%

category: 'parsing'
method: CypressUrl
privateInitializeFromText: aString

	^self subclassResponsibility: #privateInitializeFromText:
%

category: 'parsing'
method: CypressUrl
privateInitializeFromText: aString relativeTo: aUrl
	"initialize from the given string, as a relative URL.  aString will have had the scheme name removed, if it was present to begin with.  If it was, then the scheme name was the same as the receiver's scheme name"

	"by default, just do regular initialization"
	^self privateInitializeFromText: aString
%

category: 'classification'
method: CypressUrl
scheme
	"return a string with the scheme of this URL.  For instance, HTTP"

	^self subclassResponsibility: #scheme
%

category: 'classification'
method: CypressUrl
schemeName
	"return a lowercase string with the scheme of this URL.  For instance, 'http'"

	^self subclassResponsibility: #schemeName
%

category: 'fragment'
method: CypressUrl
withFragment: newFragment
	"return a URL which is the same except that it has a different fragment"
	^self copy privateFragment: newFragment; yourself
%

category: 'fragment'
method: CypressUrl
withoutFragment
	"return a URL which is identical to the receiver except that it has no fragment associated with it"
	^self withFragment: nil
%

category: 'encoding'
method: CypressUrl
writeWithHttpEscapes: aCollection on: aStream

	self class writeWithHttpEscapes: aCollection on: aStream
%

! Class implementation for 'CypressFileUrl'

!		Class methods for 'CypressFileUrl'

category: 'instance creation'
classmethod: CypressFileUrl
absoluteFromText: aString
	"Method that can be called explicitly to create a FileUrl."

	^self new privateInitializeFromText: aString
%

category: 'instance creation'
classmethod: CypressFileUrl
host: aHost pathParts: aCollectionOfPathParts isAbsolute: aBoolean
	"Create a FileUrl."

	^self new host: aHost pathParts: aCollectionOfPathParts isAbsolute: aBoolean
%

category: 'instance creation'
classmethod: CypressFileUrl
pathParts: aCollectionOfPathParts
	"Create a FileUrl."

	^self host: nil pathParts: aCollectionOfPathParts isAbsolute: true
%

category: 'instance creation'
classmethod: CypressFileUrl
pathParts: aCollectionOfPathParts isAbsolute: aBoolean
	"Create a FileUrl."

	^self host: nil pathParts: aCollectionOfPathParts isAbsolute: aBoolean
%

category: 'constants'
classmethod: CypressFileUrl
schemeName
	^'file'
%

category: 'instance creation'
classmethod: CypressFileUrl
workingDirectory

	^self absoluteFromText: CypressFileUtilities current workingDirectory
%

!		Instance methods for 'CypressFileUrl'

category: 'downloading'
method: CypressFileUrl
default
	"Answer a new URL with the receiver's path relative to the current working directory."
	
	self privateInitializeFromText: self pathString relativeTo: self class workingDirectory.
%

category: 'accessing'
method: CypressFileUrl
fileName
	"Return the last part of the path,
	most often a filename but can also be a directory."

	^self path last
%

category: 'testing'
method: CypressFileUrl
firstPartIsDriveLetter
	"Return true if the first part of the path is a letter
	followed by a $: like 'C:' "
	
	| firstPart |
	path isEmpty ifTrue: [^false].
	firstPart := path first.
	^firstPart size = 2 and: [
		firstPart first isLetter
			and: [firstPart last = $:]]
%

category: 'downloading'
method: CypressFileUrl
hasContents
	^true
%

category: 'accessing'
method: CypressFileUrl
host
	"Return the host name, either 'localhost', '', or a fully qualified domain name."
	
	^host ifNil: ['']
%

category: 'accessing'
method: CypressFileUrl
host: hostName
	"Set the host name, either 'localhost', '', or a fully qualified domain name."
	
	host := hostName
%

category: 'private-initialization'
method: CypressFileUrl
host: aHostString pathParts: aCollection isAbsolute: aBoolean

	host := aHostString.
	path := aCollection.
	isAbsolute := aBoolean
%

category: 'private-initialization'
method: CypressFileUrl
initializeFromPathString: aPathString
	"<aPathString> is a file path as a String.
	We construct a path collection using various heuristics."

	| pathString hasDriveLetter |
	pathString := aPathString.
	pathString isEmpty ifTrue: [pathString := '/'].
	"Copy without empty string preceeding first / or between duplicated /s."
	path := ((pathString subStrings: '/') copyWithout: '')
				collect: [:token | self decodeHttpEscapesOf: token].

	"A path like 'C:' refers in practice to 'c:/'"
	(pathString last = $/
		or: [(hasDriveLetter := self firstPartIsDriveLetter) and: [path size = 1]])
			ifTrue: [path add: ''].

	"Decide if we are absolute by checking for leading $/ or
	beginning with drive letter. Smarts for other OSes?"
	self isAbsolute: ((pathString at: 1) = $/
				or: [hasDriveLetter ifNil: [self firstPartIsDriveLetter]])
%

category: 'accessing'
method: CypressFileUrl
isAbsolute
	"Should the path be considered absolute to
	the filesystem instead of relative to the default directory?"
 
	^isAbsolute
%

category: 'accessing'
method: CypressFileUrl
isAbsolute: aBoolean
	"Set if the path should be considered absolute to
	the filesystem instead of relative to the default directory."

	isAbsolute := aBoolean
%

category: 'accessing'
method: CypressFileUrl
path
	"Return an ordered collection of the path elements."
	
	^path
%

category: 'accessing'
method: CypressFileUrl
path: aCollection
	"Set the collection of path elements."

	path := aCollection
%

category: 'paths'
method: CypressFileUrl
pathDirString
	"Path to directory as url, using slash as delimiter.
	Filename is left out."

	| s |
	s := WriteStreamPortable on: (String new: 100).
	isAbsolute ifTrue: [s nextPut: $/].
	1 to: self path size - 1
		do: 
			[:ii |
			s
				nextPutAll: (path at: ii);
				nextPut: $/].
	^s contents
%

category: 'paths'
method: CypressFileUrl
pathForDirectory
	"Path using local file system's pathname delimiter.
	DOS paths with drive letters should not
	be prepended with a delimiter even though
	they are absolute. Filename is left out."

	| delimiter s |
	delimiter := CypressFileUtilities current pathNameDelimiter.
	s := WriteStreamPortable on: (String new: 100).
	(self isAbsolute and: [self firstPartIsDriveLetter not])
		ifTrue: [s nextPutAll: delimiter].
	1 to: self path size - 1
		do: 
			[:ii |
			s
				nextPutAll: (path at: ii);
				nextPutAll: delimiter].
	^s contents
%

category: 'paths'
method: CypressFileUrl
pathForFile
  ^ self pathString
%

category: 'private-initialization'
method: CypressFileUrl
pathParts: aCollection isAbsolute: aBoolean

	^self host: nil pathParts: aCollection isAbsolute: aBoolean
%

category: 'paths'
method: CypressFileUrl
pathString
	"Path as it appears in a URL with $/ as delimiter."

	| s first |
	s := WriteStreamPortable on: (String new: 100).

	"isAbsolute ifTrue:[ s nextPut: $/ ]."
	first := true.
	self path do: 
			[:p |
			first ifFalse: [s nextPut: $/].
			first := false.
			self writeWithHttpEscapes: p on: s].
	^s contents
%

category: 'copying'
method: CypressFileUrl
postCopy
	"Be sure not to share the path with the copy."

	super postCopy.
	path := path copy
%

category: 'printing'
method: CypressFileUrl
printOn: aStream
	"Return the FileUrl according to RFC3986
		'file:'['//'<host>]<path>#<fragment>
	Note that <host> being '' is equivalent to 'localhost' and is not printed."

	aStream
		nextPutAll: self schemeName;
		nextPut: $:.

	"File URLs with hosts (which are fairly useless) cannot be relative."
	host isEmpty
		ifFalse: 
			[isAbsolute
				ifFalse: 
					[aStream nextPutAll: '<ErroneousURL>'.
					^nil].
			aStream
				nextPutAll: '//';
				nextPutAll: host].
	isAbsolute ifTrue: [aStream nextPut: $/].
	aStream nextPutAll: self pathString.
	fragment
		ifNotNil: 
			[aStream nextPut: $#.
			self writeWithHttpEscapes: fragment on: aStream]
%

category: 'private-initialization'
method: CypressFileUrl
privateInitializeFromText: aString
	"Calculate host and path from a file URL in String format.
	Some malformed formats are allowed and interpreted by guessing."

	| schemeName pathString bare i |
	bare := aString trimSeparators.
	schemeName := CypressUrl schemeNameForString: bare.
	(schemeName isNil or: [schemeName ~= self schemeName])
		ifTrue: 
			[host := ''.
			pathString := bare]
		ifFalse: 
			["First remove schemeName and colon"
			bare := bare copyFrom: schemeName size + 2 to: bare size.
			"A proper file URL then has two slashes before host,
			A malformed URL is interpreted as using syntax file:<path>."
			(bare indexOfSubCollection: '//' startingAt: 1 ifAbsent: [ 0 ]) = 1
				ifTrue: 
					[i := bare indexOf: $/ startingAt: 3.
					i = 0
						ifTrue: 
							[host := bare copyFrom: 3 to: bare size.
							pathString := '']
						ifFalse: 
							[host := bare copyFrom: 3 to: i - 1.
							pathString := bare copyFrom: host size + 3 to: bare size]]
				ifFalse: 
					[host := ''.
					pathString := bare]].
	self initializeFromPathString: pathString
%

category: 'private-initialization'
method: CypressFileUrl
privateInitializeFromText: pathString relativeTo: aUrl
	"<pathString> should be a filesystem path.
	This url is adjusted to be aUrl + the path."

	| newPath |
	self host: aUrl host.
	self initializeFromPathString: pathString.
	self isAbsolute: aUrl isAbsolute.
	newPath := aUrl path copy.
	newPath removeLast.	"empty string that says its a directory"
	path do: 
			[:token |
			(token ~= '..' and: [token ~= '.'])
				ifTrue: [newPath addLast: (self decodeHttpEscapesOf: token)].
			token = '..'
				ifTrue: 
					[newPath isEmpty
						ifFalse: [newPath last = '..' ifFalse: [newPath removeLast]]]
			"token = '.' do nothing"].
	path := newPath
%

category: 'classification'
method: CypressFileUrl
scheme
	^self class schemeName
%

category: 'classification'
method: CypressFileUrl
schemeName
	^self class schemeName
%

! Class implementation for 'CypressAbstractFileUrl'

!		Class methods for 'CypressAbstractFileUrl'

category: 'instance creation'
classmethod: CypressAbstractFileUrl
absoluteFromText: aString
	"Return a URL from a string and handle
	a String without a scheme as a FileUrl."

	"Url absoluteFromText: 'http://chaos.resnet.gatech.edu:8000/docs/java/index.html?A%20query%20#part'" 
	"Url absoluteFromText: 'msw://chaos.resnet.gatech.edu:9000/testbook?top'"
	"Url absoluteFromText: 'telnet:chaos.resnet.gatech.edu'"
	"Url absoluteFromText: 'file:/etc/passwd'"

	| remainder index scheme fragment newUrl |
	"trim surrounding whitespace"
	remainder := aString trimSeparators.

	"extract the fragment, if any"
	index := remainder indexOf: $#.
	index > 0 ifTrue: [
		fragment := remainder copyFrom: index + 1 to: remainder size.
		remainder := remainder copyFrom: 1 to: index - 1].

	"choose class based on the scheme name, and let that class do the bulk of the parsing"
	scheme := self schemeNameForString: remainder.
	newUrl := (self urlClassForScheme: scheme) new privateInitializeFromText: remainder.
	newUrl privateFragment: fragment.
	^newUrl
%

category: 'parsing'
classmethod: CypressAbstractFileUrl
urlClassForScheme: scheme

	scheme isNil ifTrue: [^CypressFileUrl].
	^super urlClassForScheme: scheme
%

!		Instance methods for 'CypressAbstractFileUrl'

category: 'accessing'
method: CypressAbstractFileUrl
codeFormat

	^self subclassResponsibility: #codeFormat.
%

category: 'private'
method: CypressAbstractFileUrl
fileUtils
  ^ CypressFileUtilities current
%

category: 'testing'
method: CypressAbstractFileUrl
isStrict

	^self subclassResponsibility: #isStrict.
%

category: 'accessing'
method: CypressAbstractFileUrl
repositoryClass

	^CypressFileSystemRepository
%

! Class implementation for 'CypressCypressFileUrl'

!		Class methods for 'CypressCypressFileUrl'

category: 'constants'
classmethod: CypressCypressFileUrl
schemeName

	^'cypress'
%

!		Instance methods for 'CypressCypressFileUrl'

category: 'accessing'
method: CypressCypressFileUrl
codeFormat

	^'Cypress'
%

category: 'testing'
method: CypressCypressFileUrl
isStrict

	^true
%

! Class implementation for 'CypressFileTreeFormatFileUrl'

!		Class methods for 'CypressFileTreeFormatFileUrl'

category: 'constants'
classmethod: CypressFileTreeFormatFileUrl
schemeName

	^'cypressft'
%

!		Instance methods for 'CypressFileTreeFormatFileUrl'

category: 'accessing'
method: CypressFileTreeFormatFileUrl
codeFormat

	^'FileTree'
%

category: 'testing'
method: CypressFileTreeFormatFileUrl
isStrict

	^false
%

! Class implementation for 'CypressFileTreeReadOnlyFileUrl'

!		Class methods for 'CypressFileTreeReadOnlyFileUrl'

category: 'constants'
classmethod: CypressFileTreeReadOnlyFileUrl
schemeName

	^'cypressfiletree'
%

!		Instance methods for 'CypressFileTreeReadOnlyFileUrl'

category: 'accessing'
method: CypressFileTreeReadOnlyFileUrl
codeFormat

	^'FileTree'
%

category: 'testing'
method: CypressFileTreeReadOnlyFileUrl
isStrict

	^true
%

! Class implementation for 'CypressGitFileUrl'

!		Class methods for 'CypressGitFileUrl'

category: 'constants'
classmethod: CypressGitFileUrl
schemeName
  "A gitcypress url with a host is the target for a remote. All other parameters are optional.
	Parameters are:
		dir : the directory inside the repository where the target MC packages are.
		branch : the git branch to fetch.
		protocol: the user name part to add to the ssh Url, default to git, but can also be https (which implies read only access).
		readOnly : is the repository read only? If present, reduce the history to a minimum (and change the GUI).
	Alternative url syntax:
		gitcypress://github.com/dalehenrich/filetree:pharo5.0_dev/repository
	with:
		host : github.com
		project : dalehenrich/filetree
		branch : pharo5.0_dev
		dir : repository
"

  ^ 'gitcypress'
%

!		Instance methods for 'CypressGitFileUrl'

category: 'accessing'
method: CypressGitFileUrl
codeFormat

	^'Cypress'
%

category: 'printing'
method: CypressGitFileUrl
httpsAccessString
  ^ 'https://' , self host , self projectPath , '.git'
%

category: 'private-initialization'
method: CypressGitFileUrl
initializeFromPathString: aPathString
  | projectDelim repoDelimIndex branchOrTagDelimIndex |
  projectBranchOrTag := repositoryPath := nil.
  projectDelim := aPathString indexOf: $/ startingAt: 2.
  repoDelimIndex := aPathString indexOf: $/ startingAt: projectDelim + 1.
  (branchOrTagDelimIndex := aPathString indexOf: $:) == 0
    ifTrue: [ repoDelimIndex == 0
        ifTrue: [ self projectPath: aPathString ]
        ifFalse: [ self projectPath: (aPathString copyFrom: 1 to: repoDelimIndex - 1).
          self
            repositoryPath:
              (aPathString copyFrom: repoDelimIndex + 1 to: aPathString size) ] ]
    ifFalse: [ self projectPath: (aPathString copyFrom: 1 to: branchOrTagDelimIndex - 1).
      repoDelimIndex == 0
        ifTrue: [ projectBranchOrTag := aPathString
            copyFrom: branchOrTagDelimIndex + 1
            to: aPathString size ]
        ifFalse: [ self projectPath: (aPathString copyFrom: 1 to: branchOrTagDelimIndex - 1).
          self parseBranchOrTagField: [ :pv :rp | projectBranchOrTag := pv.
              self repositoryPath: rp ] pathString: aPathString
          branchOrTagDelimIndex: branchOrTagDelimIndex ] ]
%

category: 'testing'
method: CypressGitFileUrl
isStrict

	^true
%

category: 'private-initialization'
method: CypressGitFileUrl
parseBranchOrTagField: parseBlock pathString: aPathString branchOrTagDelimIndex: branchOrTagDelimIndex
  | strm done escaped repoDelimIndex |
  strm := WriteStream on: String new.
  repoDelimIndex := branchOrTagDelimIndex + 1.
  escaped := done := false.
  [ done ] whileFalse: [ | char |
      repoDelimIndex > aPathString size
        ifTrue: [ done := true ]
        ifFalse: [ char := aPathString at: repoDelimIndex.
          char == $\
            ifTrue: [ escaped
                ifTrue: [ "$\ not legal in branch name ... literally ignored"
                  escaped := false ]
                ifFalse: [ escaped := true ] ]
            ifFalse: [ char == $/
                ifTrue: [ escaped
                    ifFalse: [ done := true ] ].
              done
                ifFalse: [ strm nextPut: char ].
              escaped := false ].
          repoDelimIndex := repoDelimIndex + 1 ] ].
  repoDelimIndex := repoDelimIndex - 1.
  parseBlock
    value: strm contents
    value: (aPathString copyFrom: repoDelimIndex + 1 to: aPathString size)
%

category: 'printing'
method: CypressGitFileUrl
printOn: aStream

	aStream nextPutAll: self schemeName , '://' , self host.
	aStream
		nextPutAll: self projectPath;
		nextPut: $:.
	self projectBranchOrTag do: 
			[:char |
			char = $/ ifTrue: [aStream nextPut: $\].
			aStream nextPut: char].
	aStream
		nextPut: $/;
		nextPutAll: self repositoryPath
%

category: 'accessing'
method: CypressGitFileUrl
projectBranchOrTag
  ^ projectBranchOrTag ifNil: [ 'master' ]
%

category: 'accessing'
method: CypressGitFileUrl
projectBranchOrTag: anObject

   projectBranchOrTag := anObject
%

category: 'accessing'
method: CypressGitFileUrl
projectPath

   ^projectPath
%

category: 'accessing'
method: CypressGitFileUrl
projectPath: aString
  aString last = self fileUtils pathNameDelimiter last
    ifTrue: [ projectPath := aString copyFrom: 1 to: aString size - 1 ]
    ifFalse: [ projectPath := aString ]
%

category: 'accessing'
method: CypressGitFileUrl
repositoryClass
  ^ CypressFileSystemGitRepository
%

category: 'accessing'
method: CypressGitFileUrl
repositoryPath
  ^ repositoryPath ifNil: [ '' ]
%

category: 'accessing'
method: CypressGitFileUrl
repositoryPath: aString
  (aString size > 0
    and: [ aString last = self fileUtils pathNameDelimiter last ])
    ifTrue: [ repositoryPath := aString copyFrom: 1 to: aString size - 1 ]
    ifFalse: [ repositoryPath := aString ]
%

! Class implementation for 'CypressGitFileTreeUrl'

!		Class methods for 'CypressGitFileTreeUrl'

category: 'constants'
classmethod: CypressGitFileTreeUrl
schemeName
  "A gitfiletree url with a host is the target for a remote. All other parameters are optional.
	Parameters are:
		dir : the directory inside the repository where the target MC packages are.
		branch : the git branch to fetch.
		protocol: the user name part to add to the ssh Url, default to git, but can also be https (which implies read only access).
		readOnly : is the repository read only? If present, reduce the history to a minimum (and change the GUI).
	Alternative url syntax:
		gitfiletree://github.com/dalehenrich/filetree:pharo5.0_dev/repository
	with:
		host : github.com
		project : dalehenrich/filetree
		branch : pharo5.0_dev
		dir : repository
"

  ^ 'gitfiletree'
%

!		Instance methods for 'CypressGitFileTreeUrl'

category: 'accessing'
method: CypressGitFileTreeUrl
codeFormat

	^'FileTree'
%

category: 'testing'
method: CypressGitFileTreeUrl
isStrict

	^false
%

! Class implementation for 'CypressLaxFileUrl'

!		Class methods for 'CypressLaxFileUrl'

category: 'constants'
classmethod: CypressLaxFileUrl
schemeName

	^'cypresslax'
%

!		Instance methods for 'CypressLaxFileUrl'

category: 'accessing'
method: CypressLaxFileUrl
codeFormat

	^'Cypress'
%

category: 'testing'
method: CypressLaxFileUrl
isStrict

	^false
%

! Class implementation for 'CypressSmalltalkUrl'

!		Class methods for 'CypressSmalltalkUrl'

category: 'constants'
classmethod: CypressSmalltalkUrl
schemeName

	^'chunk'
%

!		Instance methods for 'CypressSmalltalkUrl'

category: 'accessing'
method: CypressSmalltalkUrl
codeFormat

	^'Chunk'
%

category: 'testing'
method: CypressSmalltalkUrl
isStrict

	^true
%

category: 'accessing'
method: CypressSmalltalkUrl
repositoryClass

	^CypressSmalltalkRepository
%

! Class implementation for 'CypressTopazUrl'

!		Class methods for 'CypressTopazUrl'

category: 'constants'
classmethod: CypressTopazUrl
schemeName

	^'topaz'
%

!		Instance methods for 'CypressTopazUrl'

category: 'accessing'
method: CypressTopazUrl
codeFormat

	^'Topaz'
%

category: 'testing'
method: CypressTopazUrl
isStrict

	^true
%

category: 'accessing'
method: CypressTopazUrl
repositoryClass

	^CypressTopazRepository
%

! Class implementation for 'CypressGenericUrl'

!		Class methods for 'CypressGenericUrl'

category: 'parsing'
classmethod: CypressGenericUrl
absoluteFromText: aString

	| schemeName locator |
	schemeName := CypressUrl schemeNameForString: aString.
	schemeName ifNil: [^self schemeName: 'xnoscheme' locator: aString].
	locator := aString copyFrom: schemeName size + 2 to: aString size.
	^self schemeName: schemeName locator: locator
%

category: 'instance creation'
classmethod: CypressGenericUrl
schemeName: schemeName  locator: locator
	^self new schemeName: schemeName  locator: locator
%

!		Instance methods for 'CypressGenericUrl'

category: 'access'
method: CypressGenericUrl
locator
	^locator
%

category: 'printing'
method: CypressGenericUrl
printOn: aStream
	
	self schemeName ifNotNil: [
		aStream nextPutAll: self schemeName; nextPut: $:].
	
	aStream nextPutAll: self locator.

	self fragment ifNotNil: [
		aStream nextPut: $#; nextPutAll: self fragment].
%

category: 'parsing'
method: CypressGenericUrl
privateInitializeFromText: aString

	schemeName := CypressUrl schemeNameForString: aString.
	locator := schemeName
				ifNil: [aString]
				ifNotNil: [aString copyFrom: schemeName size + 2 to: aString size]
%

category: 'parsing'
method: CypressGenericUrl
privateInitializeFromText: aString relativeTo: aUrl
	schemeName := aUrl schemeName.
	locator := aString.
%

category: 'classification'
method: CypressGenericUrl
scheme
	^ self schemeName.
%

category: 'access'
method: CypressGenericUrl
schemeName
	^schemeName
%

category: 'private'
method: CypressGenericUrl
schemeName: schemeName0  locator: locator0
	schemeName := schemeName0.
	locator := locator0.
%

! Class implementation for 'CypressBrowserUrl'

!		Class methods for 'CypressBrowserUrl'

category: 'constants'
classmethod: CypressBrowserUrl
schemeName

	^'browser'
%

!		Instance methods for 'CypressBrowserUrl'

category: 'downloading'
method: CypressBrowserUrl
hasContents

	^true
%

! Class implementation for 'CypressMailtoUrl'

!		Class methods for 'CypressMailtoUrl'

category: 'constants'
classmethod: CypressMailtoUrl
schemeName

	^ 'mailto'
%

! Class implementation for 'CypressHierarchicalUrl'

!		Class methods for 'CypressHierarchicalUrl'

category: 'instance creation'
classmethod: CypressHierarchicalUrl
schemeName: schemeName  authority: authority  path: path  query: query
	^self new schemeName: schemeName  authority: authority  path: path  query: query
%

!		Instance methods for 'CypressHierarchicalUrl'

category: 'access'
method: CypressHierarchicalUrl
authority
	^authority
%

category: 'access'
method: CypressHierarchicalUrl
fileName
	"Return the last part of the path,
	most often a filename but does not need to be."

	^self path last
%

category: 'printing'
method: CypressHierarchicalUrl
fullPath

	| ans |
	ans := WriteStreamPortable on: String new.
	path do: 
			[:pathElem |
			ans nextPut: $/.
			self writeWithHttpEscapes: pathElem on: ans].
	self query isNil
		ifFalse: 
			[ans nextPut: $?.
			ans nextPutAll: self query].
	self fragment isNil
		ifFalse: 
			[ans nextPut: $#.
			self writeWithHttpEscapes: self fragment on: ans].
	^ans contents
%

category: 'downloading'
method: CypressHierarchicalUrl
hasContents
	"most of these do...."
	^true
%

category: 'access'
method: CypressHierarchicalUrl
isAbsolute
	
	path size > 0 ifFalse: [^ false].
	(path at: 1) size > 0 ifFalse: [^ false].
	^ ((path at: 1) at: 1) ~~ $.
%

category: 'access'
method: CypressHierarchicalUrl
password
	"http://user:pword@foo.com' asUrl password"
	^password
%

category: 'access'
method: CypressHierarchicalUrl
path
	"return a collection of the decoded path elements, as strings"
	^path
%

category: 'access'
method: CypressHierarchicalUrl
path: aCollection
	"Set the collection of path elements."

	path := aCollection
%

category: 'access'
method: CypressHierarchicalUrl
port
	^port
%

category: 'copying'
method: CypressHierarchicalUrl
postCopy
	"Be sure not to share the path with the copy"

	super postCopy.
	path := path copy
%

category: 'printing'
method: CypressHierarchicalUrl
printOn: aStream

	aStream nextPutAll: self schemeName.
	aStream nextPutAll: '://'.
	self username
		ifNotNil: 
			[self writeWithHttpEscapes: self username on: aStream.
			self password
				ifNotNil: 
					[aStream nextPutAll: ':'.
					self writeWithHttpEscapes: self password on: aStream].
			aStream nextPutAll: '@'].
	aStream nextPutAll: self authority.
	port
		ifNotNil: 
			[aStream
				nextPut: $:;
				nextPutAll: port printString].
	path do: 
			[:pathElem |
			aStream nextPut: $/.
			self writeWithHttpEscapes: pathElem on: aStream].
	self query isNil
		ifFalse: 
			[aStream nextPut: $?.
			aStream nextPutAll: self query].
	self fragment isNil
		ifFalse: 
			[aStream nextPut: $#.
			self writeWithHttpEscapes: self fragment on: aStream]
%

category: 'parsing'
method: CypressHierarchicalUrl
privateInitializeFromText: aString
	| remainder ind specifiedSchemeName |
	remainder := aString.
	schemeName
		ifNil: 
			[specifiedSchemeName := CypressUrl schemeNameForString: remainder.
			specifiedSchemeName
				ifNotNil: 
					[schemeName := specifiedSchemeName.
					remainder := remainder copyFrom: schemeName size + 2 to: remainder size].
			schemeName
				ifNil: 
					["assume HTTP"
					schemeName := 'http']].

	"remove leading // if it's there"
	(remainder indexOfSubCollection: '//' startingAt: 1 ifAbsent: [ 0 ]) = 1
		ifTrue: [remainder := remainder copyFrom: 3 to: remainder size].

	"get the query"
	ind := remainder indexOf: $?.
	ind > 0
		ifTrue: 
			[query := remainder copyFrom: ind + 1 to: remainder size.
			remainder := remainder copyFrom: 1 to: ind - 1].

	"get the authority"
	ind := remainder indexOf: $/.
	ind > 0
		ifTrue: 
			[ind = 1
				ifTrue: [authority := '']
				ifFalse: 
					[authority := remainder copyFrom: 1 to: ind - 1.
					remainder := remainder copyFrom: ind + 1 to: remainder size]]
		ifFalse: 
			[authority := remainder.
			remainder := ''].

	"extract the username+password"
	ind := authority indexOf: $@.
	ind > 0
		ifTrue: 
			[username := authority copyFrom: 1 to: ind - 1.
			authority := authority copyFrom: ind + 1 to: authority size.
			ind := username indexOf: $:.
			ind > 0
				ifTrue: 
					[password := (self
								decodeHttpEscapesOf: (username copyFrom: ind + 1 to: username size))
									asByteArray decodeFromUTF8
								asString.
					username := username copyFrom: 1 to: ind - 1]
				ifFalse: [password := nil].
			username := (self decodeHttpEscapesOf: username) asByteArray
						decodeFromUTF8 asString].

	"Extract the port"
	(authority includes: $:)
		ifTrue: 
			[| lastColonIndex portString |
			lastColonIndex := authority findLast: [:c | c = $:].
			portString := authority copyFrom: lastColonIndex + 1 to: authority size.
			(portString size > 0) 
				ifTrue: [ 
					(portString allSatisfy: [:each | each isDigit])
						ifTrue: 
							[port := Integer fromString: portString.
							port > 65535 ifTrue: [self error: 'Invalid port number']]
						ifFalse: [self error: 'Invalid port number']].
			authority := authority copyFrom: 1 to: lastColonIndex - 1].

	"get the path"
	path := self privateParsePath: remainder relativeTo: #()
%

category: 'parsing'
method: CypressHierarchicalUrl
privateInitializeFromText: aString relativeTo: aUrl

	| remainder ind basePath |
	remainder := aString.
	"set the scheme"
	schemeName := aUrl schemeName.

	"a leading // means the authority is specified, meaning it is absolute"
	(remainder indexOfSubCollection: '//' startingAt: 1 ifAbsent: [ 0 ]) = 1
		ifTrue: [^self privateInitializeFromText: aString].

	"otherwise, use the same authority"
	authority := aUrl authority.
	port := aUrl port.
	username := aUrl username.
	password := aUrl password.

	"get the query"
	ind := remainder indexOf: $?.
	ind > 0
		ifTrue: 
			[query := remainder copyFrom: ind + 1 to: remainder size.
			remainder := remainder copyFrom: 1 to: ind - 1].

	"get the path"
	(remainder indexOfSubCollection: '/' startingAt: 1 ifAbsent: [ 0 ]) = 1
		ifTrue: [basePath := #()]
		ifFalse: [basePath := aUrl path].
	path := self privateParsePath: remainder relativeTo: basePath
%

category: 'parsing'
method: CypressHierarchicalUrl
privateParsePath: remainder relativeTo: basePath

	| nextTok s parsedPath |
	s := remainder readStream.
	parsedPath := OrderedCollection new.
	parsedPath addAll: basePath.
	parsedPath isEmpty ifFalse: [parsedPath removeLast].
	
	[s peek = $/ ifTrue: [s next].
	nextTok := WriteStreamPortable on: String new.
	[s atEnd or: [s peek = $/]] whileFalse: [nextTok nextPut: s next].
	nextTok := self decodeHttpEscapesOf: nextTok contents.
	nextTok = '..'
		ifTrue: [parsedPath size > 0 ifTrue: [parsedPath removeLast]]
		ifFalse: [nextTok ~= '.' ifTrue: [parsedPath add: nextTok]].
	s atEnd]
			whileFalse.
	parsedPath isEmpty ifTrue: [parsedPath add: ''].
	^parsedPath
%

category: 'access'
method: CypressHierarchicalUrl
query
	"return the query, the part after any ?.  Any %XY's have already been decoded.  If there wasno query part, nil is returned (it is possible to also have an empty query"
	^query 
%

category: 'classification'
method: CypressHierarchicalUrl
scheme
	^ self schemeName.
%

category: 'access'
method: CypressHierarchicalUrl
schemeName
	^schemeName
%

category: 'private'
method: CypressHierarchicalUrl
schemeName: schemeName0  authority: authority0  path: path0  query: query0
	"initialize a new instance"
	schemeName := schemeName0.
	authority := authority0.
	path := path0.
	query := query0.
%

category: 'access'
method: CypressHierarchicalUrl
username
	"http://user:pword@foo.com' asUrl username"
	^username
%

! Class implementation for 'CypressFtpUrl'

!		Class methods for 'CypressFtpUrl'

category: 'constants'
classmethod: CypressFtpUrl
schemeName

	^ 'ftp'.
%

! Class implementation for 'CypressHttpUrl'

!		Class methods for 'CypressHttpUrl'

category: 'constants'
classmethod: CypressHttpUrl
schemeName

	^ 'http'.
%

! Class implementation for 'CypressHttpsUrl'

!		Class methods for 'CypressHttpsUrl'

category: 'constants'
classmethod: CypressHttpsUrl
schemeName

	^ 'https'.
%

! Class implementation for 'CypressVersionReference'

!		Class methods for 'CypressVersionReference'

category: 'instance creation'
classmethod: CypressVersionReference
name: aString

	^(self basicNew)
		initializeName: aString;
		yourself
%

category: 'instance creation'
classmethod: CypressVersionReference
new

	self error: 'Use #name: to initialize the receiver.'
%

!		Instance methods for 'CypressVersionReference'

category: 'comparing'
method: CypressVersionReference
= aReference

	^self class = aReference class
		and: [self name = aReference name]
%

category: 'accessing'
method: CypressVersionReference
author
	"Answer the author of the receiver."
	
	^ author
%

category: 'accessing'
method: CypressVersionReference
branch
	"Answer the branch of the receiver."
	
	^ branch
%

category: 'comparing'
method: CypressVersionReference
hash

	^self name hash
%

category: 'initialization'
method: CypressVersionReference
initializeName: aString

	name := aString.
	self parseName: aString
%

category: 'private'
method: CypressVersionReference
matches: aResolvedReference
	^ self name = aResolvedReference name
%

category: 'accessing'
method: CypressVersionReference
name
	"Answer the name of this reference."
	
	^ name
%

category: 'accessing'
method: CypressVersionReference
packageName
	"Answer the package of the receiver."

	^ package
%

category: 'initialization'
method: CypressVersionReference
parseName: aString

	| basicName lastDotIndex packageDotIndex lastMinusIndex |
	basicName := (aString isEmpty
				or: [aString last isDigit or: [(aString includes: $() not]])
					ifTrue: [aString]
					ifFalse: 
						["up to last (, but not if there's a . after it"
						| parenIndex dotIndex |
						parenIndex := 0.
						dotIndex := 0.
						aString size to: 1
							by: -1
							do: 
								[:i |
								| c |
								c := aString at: i.
								(c = $. and: [dotIndex = 0])
									ifTrue: 
										[dotIndex := i.
										parenIndex := 0].
								(c = $( and: [parenIndex = 0]) ifTrue: [parenIndex := i]].
						aString copyFrom: 1 to: parenIndex - 1].
	lastMinusIndex := 0.
	lastDotIndex := 0.
	basicName size to: 1
		by: -1
		do: 
			[:i |
			| c |
			c := basicName at: i.
			(c = $- and: [lastMinusIndex = 0]) ifTrue: [lastMinusIndex := i].
			(c = $. and: [lastDotIndex = 0]) ifTrue: [lastDotIndex := i]].
	lastMinusIndex = 0 ifTrue: [lastMinusIndex := basicName size + 1].
	package := basicName copyFrom: 1 to: lastMinusIndex - 1.
	branch := ''.
	packageDotIndex := package indexOf: $..
	packageDotIndex > 0
		ifTrue: 
			[branch := package copyFrom: packageDotIndex + 1 to: package size.
			package := package copyFrom: 1 to: packageDotIndex - 1].
	author := lastMinusIndex = 0
				ifTrue: ['']
				ifFalse: 
					[lastDotIndex < lastMinusIndex ifTrue: [lastDotIndex := basicName size + 1].
					basicName copyFrom: lastMinusIndex + 1 to: lastDotIndex - 1].

	"if basicName is of the form anything-something.number, you'll get number.
If it contains no hyphen, or no period after the last hyphen, you get nothing"
	versionNumber := (basicName indexOf: $-) = 0
				ifTrue: [0]
				ifFalse: 
					[| index lastIndex char |
					index := lastIndex := basicName size.
					char := basicName at: index.
					[char = $. | (char = $-)] whileFalse: 
							[index := index - 1.
							char := basicName at: index].
					char = $-
						ifTrue: [0	"No period after last hyphen."]
						ifFalse: 
							[| numberString |
							numberString := basicName copyFrom: index + 1 to: lastIndex.
							(numberString notEmpty
								and: [numberString allSatisfy: [:each | each isDigit]])
									ifTrue: [numberString asInteger]
									ifFalse: [0]]]
%

category: 'printing'
method: CypressVersionReference
printOn: aStream

	super printOn: aStream.
	aStream nextPutAll: ' name: '.
	self name printOn: aStream
%

category: 'accessing'
method: CypressVersionReference
versionNumber
	"Answer the version of the receiver."

	^ versionNumber
%

! Class implementation for 'GsInteraction'

!		Instance methods for 'GsInteraction'

category: 'accessing'
method: GsInteraction
defaultActionBlock
  defaultActionBlock
    ifNil: [ 
      ^ [ :interactionRequest | 
      Transcript cr; show: self printString.
      nil ] ].
  ^ defaultActionBlock
%

category: 'accessing'
method: GsInteraction
defaultActionBlock: anObject

   "Modify the value of the instance variable 'defaultActionBlock'."
   defaultActionBlock := anObject
%

category: 'interacting'
method: GsInteraction
defaultActionFor: anInteractionRequest
  ^ self defaultActionBlock value: anInteractionRequest
%

category: 'interacting'
method: GsInteraction
interactWith: anObject
  "opportunity for double dispatch:

     interactWithChoice:
     interactWithConfirm:
     interactWithInform:
     interactWithInspect:
     interactWithMultiLineText:
     interactWithText:
  "

  self subclassResponsibility
%

category: 'printing'
method: GsInteraction
printLabel
  ^ ''
%

category: 'printing'
method: GsInteraction
printOn: aStream
  aStream nextPutAll: self class name asString , '(' , self printLabel , ')'
%

category: 'interacting'
method: GsInteraction
signal
  ^ GsInteractionRequest signal: self
%

! Class implementation for 'GsChoiceInteraction'

!		Class methods for 'GsChoiceInteraction'

category: 'instance creation'
classmethod: GsChoiceInteraction
labels: anArray
	^ self
		prompt: nil
		labels: anArray
		values: anArray
		lines: #()
%

category: 'instance creation'
classmethod: GsChoiceInteraction
labels: labelArray lines: lineArray
	^ self
		prompt: nil
		labels: labelArray
		values: labelArray
		lines: lineArray
%

category: 'instance creation'
classmethod: GsChoiceInteraction
prompt: aString labels: labelArray values: valueArray
	^ self
		prompt: aString
		labels: labelArray
		 values: valueArray
		lines: #()
%

category: 'instance creation'
classmethod: GsChoiceInteraction
prompt: aString labels: labelArray values: valueArray lines: lineArray
  ^ self new
    prompt: aString;
    labels: labelArray;
    values: valueArray;
    lines: lineArray;
    yourself
%

!		Instance methods for 'GsChoiceInteraction'

category: 'interacting'
method: GsChoiceInteraction
interactWith: anObject
  "opportunity for double dispatch:

     interactWithChoice:
     interactWithConfirm:
     interactWithInform:
     interactWithMultiLineText:
     interactWithText:
  "

  ^ anObject interactWithChoice: self
%

category: 'accessing'
method: GsChoiceInteraction
labels

   "Return the value of the instance variable 'labels'."
   ^labels
%

category: 'accessing'
method: GsChoiceInteraction
labels: anObject

   "Modify the value of the instance variable 'labels'."
   labels := anObject
%

category: 'accessing'
method: GsChoiceInteraction
lines

   "Return the value of the instance variable 'lines'."
   ^lines
%

category: 'accessing'
method: GsChoiceInteraction
lines: anObject

   "Modify the value of the instance variable 'lines'."
   lines := anObject
%

category: 'printing'
method: GsChoiceInteraction
printLabel
  ^ self prompt
%

category: 'accessing'
method: GsChoiceInteraction
prompt

   "Return the value of the instance variable 'prompt'."
   ^prompt
%

category: 'accessing'
method: GsChoiceInteraction
prompt: aString
  prompt := aString copyWrappedTo: 80
%

category: 'choice'
method: GsChoiceInteraction
select: anIndex
  ^ self values at: anIndex
%

category: 'choice'
method: GsChoiceInteraction
select: anIndex for: anInteractionRequest
  anInteractionRequest response: (self values at: anIndex)
%

category: 'accessing'
method: GsChoiceInteraction
values

   "Return the value of the instance variable 'values'."
   ^values
%

category: 'accessing'
method: GsChoiceInteraction
values: anObject

   "Modify the value of the instance variable 'values'."
   values := anObject
%

! Class implementation for 'GsConfirmInteraction'

!		Class methods for 'GsConfirmInteraction'

category: 'instance creation'
classmethod: GsConfirmInteraction
prompt: prompt
  ^ self prompt: prompt confirm: 'Ok'
%

category: 'instance creation'
classmethod: GsConfirmInteraction
prompt: prompt confirm: confirm
  ^ self prompt: prompt confirm: confirm cancel: 'Cancel'
%

category: 'instance creation'
classmethod: GsConfirmInteraction
prompt: prompt confirm: confirm cancel: cancel
  ^ self new
    prompt: prompt;
    confirm: confirm;
    cancel: cancel
%

category: 'instance creation'
classmethod: GsConfirmInteraction
prompt: prompt confirm: confirm cancel: cancel abort: abort
  "on confirm return true, on cancel return false on abort return nil"

  ^ self new
    prompt: prompt;
    confirm: confirm;
    cancel: cancel;
    abort: abort
%

!		Instance methods for 'GsConfirmInteraction'

category: 'accessing'
method: GsConfirmInteraction
abort
  ^ abort
%

category: 'accessing'
method: GsConfirmInteraction
abort: anObject
  abort := anObject
%

category: 'confirm'
method: GsConfirmInteraction
abortFor: anInteractionRequest
  anInteractionRequest response: self abortResponse
%

category: 'confirm'
method: GsConfirmInteraction
abortResponse
  ^ nil
%

category: 'accessing'
method: GsConfirmInteraction
cancel
  ^ cancel
%

category: 'accessing'
method: GsConfirmInteraction
cancel: anObject
	cancel := anObject
%

category: 'confirm'
method: GsConfirmInteraction
cancelFor: anInteractionRequest
  anInteractionRequest response: self cancelResponse
%

category: 'confirm'
method: GsConfirmInteraction
cancelResponse
  ^ false
%

category: 'accessing'
method: GsConfirmInteraction
confirm
	^ confirm
%

category: 'accessing'
method: GsConfirmInteraction
confirm: anObject
	confirm := anObject
%

category: 'accessing'
method: GsConfirmInteraction
defaultActionBlock
  defaultActionBlock
    ifNil: [ 
      ^ [ :interactionRequest | 
      Transcript cr; show: self printString.
      self cancelResponse ] ].
  ^ defaultActionBlock
%

category: 'interacting'
method: GsConfirmInteraction
interactWith: anObject
  "opportunity for double dispatch:

     interactWithChoice:
     interactWithConfirm:
     interactWithInform:
     interactWithMultiLineText:
     interactWithText:
  "

  ^ anObject interactWithConfirm: self
%

category: 'confirm'
method: GsConfirmInteraction
ok
  ^ true
%

category: 'confirm'
method: GsConfirmInteraction
okFor: anInteractionRequest
  anInteractionRequest response: self okResponse
%

category: 'confirm'
method: GsConfirmInteraction
okResponse
  ^ true
%

category: 'printing'
method: GsConfirmInteraction
printLabel
  ^ self prompt
%

category: 'accessing'
method: GsConfirmInteraction
prompt
	^ prompt
%

category: 'accessing'
method: GsConfirmInteraction
prompt: aString
  prompt := aString copyWrappedTo: 80
%

! Class implementation for 'GsNotifyInteraction'

!		Instance methods for 'GsNotifyInteraction'

category: 'accessing'
method: GsNotifyInteraction
defaultActionBlock
  "notify answers ok by default, while confirm answers fals by default"

  defaultActionBlock
    ifNil: [ 
      ^ [ :interactionRequest | 
      Transcript cr; show: self printString.
      self okResponse ] ].
  ^ defaultActionBlock
%

! Class implementation for 'GsInformInteraction'

!		Class methods for 'GsInformInteraction'

category: 'instance creation'
classmethod: GsInformInteraction
message: aString
  ^ self new
    message: aString;
    yourself
%

!		Instance methods for 'GsInformInteraction'

category: 'interacting'
method: GsInformInteraction
interactWith: anObject
  "opportunity for double dispatch:

     interactWithChoice:
     interactWithConfirm:
     interactWithInform:
     interactWithMultiLineText:
     interactWithText:
  "

  ^ anObject interactWithInform: self
%

category: 'accessing'
method: GsInformInteraction
message

   "Return the value of the instance variable 'message'."
   ^message
%

category: 'accessing'
method: GsInformInteraction
message: aString
  message := aString copyWrappedTo: 80
%

category: 'printing'
method: GsInformInteraction
printLabel
  ^ self message
%

! Class implementation for 'GsInspectInteraction'

!		Class methods for 'GsInspectInteraction'

category: 'instance creation'
classmethod: GsInspectInteraction
theObject: anObject
  ^ self new
    theObject: anObject;
    yourself
%

!		Instance methods for 'GsInspectInteraction'

category: 'accessing'
method: GsInspectInteraction
defaultActionBlock
  defaultActionBlock
    ifNil: [ 
      ^ [ :interactionRequest | 
      Transcript cr; show: self printString.
      self theObject ] ].
  ^ defaultActionBlock
%

category: 'interacting'
method: GsInspectInteraction
interactWith: anObject
  "opportunity for double dispatch:

     interactWithChoice:
     interactWithConfirm:
     interactWithInform:
     interactWithInspect:
     interactWithMultiLineText:
     interactWithText:
  "

  ^ anObject interactWithInspect: self
%

category: 'printing'
method: GsInspectInteraction
printLabel
  ^ self theObject printString
%

category: 'accessing'
method: GsInspectInteraction
theObject

   "Return the value of the instance variable 'theObject'."
   ^theObject
%

category: 'accessing'
method: GsInspectInteraction
theObject: anObject

   "Modify the value of the instance variable 'theObject'."
   theObject := anObject
%

! Class implementation for 'GsExploreInteraction'

!		Instance methods for 'GsExploreInteraction'

category: 'interacting'
method: GsExploreInteraction
interactWith: anObject
  "opportunity for double dispatch:

     interactWithChoice:
     interactWithConfirm:
     interactWithInform:
     interactWithInspect:
     interactWithMultiLineText:
     interactWithText:
  "

  ^ anObject interactWithExplore: self
%

! Class implementation for 'GsTextInteraction'

!		Class methods for 'GsTextInteraction'

category: 'instance creation'
classmethod: GsTextInteraction
prompt: aString
  ^ self prompt: aString template: ''
%

category: 'instance creation'
classmethod: GsTextInteraction
prompt: promptString template: templateString
  ^ self new
    prompt: promptString;
    template: templateString;
    yourself
%

category: 'instance creation'
classmethod: GsTextInteraction
requestPassword: aString
  ^ self new
    requestPassword: aString;
    yourself
%

!		Instance methods for 'GsTextInteraction'

category: 'accessing'
method: GsTextInteraction
defaultActionBlock
  defaultActionBlock
    ifNil: [ 
      ^ [ :interactionRequest | 
      Transcript cr; show: self printString.
      '' ] ].
  ^ defaultActionBlock
%

category: 'interacting'
method: GsTextInteraction
interactWith: anObject
  "opportunity for double dispatch:

     interactWithChoice:
     interactWithConfirm:
     interactWithInform:
     interactWithMultiLineText:
     interactWithText:
  "

  ^ anObject interactWithText: self
%

category: 'printing'
method: GsTextInteraction
printLabel
  ^ self prompt
%

category: 'accessing'
method: GsTextInteraction
prompt

   "Return the value of the instance variable 'prompt'."
   ^prompt
%

category: 'accessing'
method: GsTextInteraction
prompt: aString
  prompt := aString copyWrappedTo: 80
%

category: 'accessing'
method: GsTextInteraction
requestPassword

   requestPassword ifNil: [ requestPassword := false ].
   ^requestPassword
%

category: 'accessing'
method: GsTextInteraction
requestPassword: aString

   prompt := aString.
   requestPassword := true
%

category: 'accessing'
method: GsTextInteraction
template
  template ifNil: [ template := '' ].
  ^ template
%

category: 'accessing'
method: GsTextInteraction
template: anObject

   "Modify the value of the instance variable 'template'."
   template := anObject
%

! Class implementation for 'GsMultiLineTextInteraction'

!		Instance methods for 'GsMultiLineTextInteraction'

category: 'interacting'
method: GsMultiLineTextInteraction
interactWith: anObject
  "opportunity for double dispatch:

     interactWithChoice:
     interactWithConfirm:
     interactWithInform:
     interactWithMultiLineText:
     interactWithText:
  "

  ^ anObject interactWithMultiLineText: self
%

! Class implementation for 'GsInteractionHandler'

!		Instance methods for 'GsInteractionHandler'

category: 'accessing'
method: GsInteractionHandler
choiceBlock
  choiceBlock ifNil: [ ^ self defaultBlock ].
  ^ choiceBlock
%

category: 'accessing'
method: GsInteractionHandler
choiceBlock: anObject

   "Modify the value of the instance variable 'choiceBlock'."
   choiceBlock := anObject
%

category: 'accessing'
method: GsInteractionHandler
confirmBlock
  confirmBlock ifNil: [ ^ self defaultBlock ].
  ^ confirmBlock
%

category: 'accessing'
method: GsInteractionHandler
confirmBlock: anObject

   "Modify the value of the instance variable 'confirmBlock'."
   confirmBlock := anObject
%

category: 'accessing'
method: GsInteractionHandler
defaultBlock
  defaultBlock
    ifNil: [ 
      defaultBlock := [ :interaction | 
      self
        error:
          'No handler defined for ' , interaction class name asString , ' interaction.' ] ].
  ^ defaultBlock
%

category: 'accessing'
method: GsInteractionHandler
defaultBlock: anObject

   "Modify the value of the instance variable 'defaultBlock'."
   defaultBlock := anObject
%

category: 'accessing'
method: GsInteractionHandler
informBlock
  informBlock ifNil: [ ^ self defaultBlock ].
  ^ informBlock
%

category: 'accessing'
method: GsInteractionHandler
informBlock: anObject

   "Modify the value of the instance variable 'informBlock'."
   informBlock := anObject
%

category: 'accessing'
method: GsInteractionHandler
inspectBlock
  inspectBlock ifNil: [ ^ self defaultBlock ].
  ^ inspectBlock
%

category: 'accessing'
method: GsInteractionHandler
inspectBlock: anObject

   "Modify the value of the instance variable 'inspectBlock'."
   inspectBlock := anObject
%

category: 'interactions'
method: GsInteractionHandler
interactWithChoice: interaction
  ^ self choiceBlock value: interaction
%

category: 'interactions'
method: GsInteractionHandler
interactWithConfirm: interaction
  ^ self confirmBlock value: interaction
%

category: 'interactions'
method: GsInteractionHandler
interactWithExplore: interaction
  ^ self interactWithInspect: interaction
%

category: 'interactions'
method: GsInteractionHandler
interactWithInform: interaction
  ^ self informBlock value: interaction
%

category: 'interactions'
method: GsInteractionHandler
interactWithInspect: interaction
  ^ self inspectBlock value: interaction
%

category: 'interactions'
method: GsInteractionHandler
interactWithMultiLineText: interaction
  ^ self multiLineTextBlock value: interaction
%

category: 'interactions'
method: GsInteractionHandler
interactWithText: interaction
  ^ self textBlock value: interaction
%

category: 'accessing'
method: GsInteractionHandler
multiLineTextBlock
  multiLineTextBlock ifNil: [ ^ self defaultBlock ].
  ^ multiLineTextBlock
%

category: 'accessing'
method: GsInteractionHandler
multiLineTextBlock: anObject

   "Modify the value of the instance variable 'multiLineTextBlock'."
   multiLineTextBlock := anObject
%

category: 'accessing'
method: GsInteractionHandler
textBlock
  textBlock ifNil: [ ^ self defaultBlock ].
  ^ textBlock
%

category: 'accessing'
method: GsInteractionHandler
textBlock: anObject

   "Modify the value of the instance variable 'textBlock'."
   textBlock := anObject
%

! Class implementation for 'GsTonelOrderedDictionary'

!		Class methods for 'GsTonelOrderedDictionary'

category: 'instance creation'
classmethod: GsTonelOrderedDictionary
new
	^ self new: 3
%

category: 'instance creation'
classmethod: GsTonelOrderedDictionary
new: anInteger
	^ self basicNew initialize: anInteger; yourself
%

category: 'instance creation'
classmethod: GsTonelOrderedDictionary
withAll: aDictionary
	^ (self new: aDictionary size)
		addAll: aDictionary;
		yourself
%

!		Instance methods for 'GsTonelOrderedDictionary'

category: 'accessing'
method: GsTonelOrderedDictionary
add: anAssociation
	self at: anAssociation key put: anAssociation value.
	^ anAssociation
%

category: 'adding'
method: GsTonelOrderedDictionary
addAll: aDictionary
	aDictionary keysAndValuesDo: [ :key :value | self at: key put: value ].
	^ aDictionary
%

category: 'enumerating'
method: GsTonelOrderedDictionary
associationsDo: aBlock
	self keysAndValuesDo: [ :key :value | aBlock value: key -> value ]
%

category: 'accessing'
method: GsTonelOrderedDictionary
at: aKey
	"Answer the value associated with aKey. Raise an exception, if no such key is defined."

	^ self at: aKey ifAbsent: [ self errorKeyNotFound ]
%

category: 'accessing'
method: GsTonelOrderedDictionary
at: aKey ifAbsent: aBlock
	"Answer the value associated with aKey. Evaluate aBlock, if no such key is defined."

	| index |
	index := self findIndexFor: aKey.
	^ index = 0
		ifFalse: [ values at: index ]
		ifTrue: [ aBlock value ]
%

category: 'accessing'
method: GsTonelOrderedDictionary
at: aKey ifAbsentPut: aBlock
	"Answer the value associated with aKey. Evaluate aBlock, if no such key is defined and store the return value."

	| index |
	index := self findIndexFor: aKey.
	^ index = 0
		ifFalse: [ values at: index ]
		ifTrue: [ self privateAt: aKey put: aBlock value ]
%

category: 'accessing'
method: GsTonelOrderedDictionary
at: aKey ifPresent: aBlock
	"Lookup aKey in the receiver. If it is present, answer the value of evaluating the given block with the value associated with the key. Otherwise, answer nil."

	| index |
	index := self findIndexFor: aKey.
	^ index = 0 ifFalse: [ aBlock value: (values at: index) ]
%

category: 'accessing'
method: GsTonelOrderedDictionary
at: aKey put: aValue
	"Set the value of aKey to be aValue."

	| index |
	index := self findIndexFor: aKey.
	^ index = 0
		ifFalse: [ values at: index put: aValue ]
		ifTrue: [ self privateAt: aKey put: aValue ]
%

category: 'enumerating'
method: GsTonelOrderedDictionary
do: aBlock
	1 to: size do: [ :index | aBlock value: (values at: index) ]
%

category: 'private'
method: GsTonelOrderedDictionary
errorKeyNotFound
	self error: 'Key not found'
%

category: 'private'
method: GsTonelOrderedDictionary
findIndexFor: aKey
	1 to: size do: [ :index |
		(keys at: index) = aKey
			ifTrue: [ ^ index ] ].
	^ 0
%

category: 'private'
method: GsTonelOrderedDictionary
grow
	| newKeys newValues |
	newKeys := Array new: 2 * size.
	newValues := Array new: 2 * size.
	1 to: size do: [ :index |
		newKeys at: index put: (keys at: index).
		newValues at: index put: (values at: index) ].
	keys := newKeys.
	values := newValues
%

category: 'testing'
method: GsTonelOrderedDictionary
includesKey: aKey
	"Answer whether the receiver has a key equal to aKey."

	^ (self findIndexFor: aKey) ~= 0
%

category: 'initialization'
method: GsTonelOrderedDictionary
initialize: anInteger
  size := 0.
  keys := Array new: anInteger.
  values := Array new: anInteger
%

category: 'testing'
method: GsTonelOrderedDictionary
isCollection
	^ true
%

category: 'testing'
method: GsTonelOrderedDictionary
isEmpty
	^ size == 0
%

category: 'enumerating'
method: GsTonelOrderedDictionary
keys
	^ keys copyFrom: 1 to: size
%

category: 'enumerating'
method: GsTonelOrderedDictionary
keysAndValuesDo: aBlock
	1 to: size do: [ :index | aBlock value: (keys at: index) value: (values at: index) ]
%

category: 'enumerating'
method: GsTonelOrderedDictionary
keysDo: aBlock
	1 to: size do: [ :each | aBlock value: (keys at: each) ]
%

category: 'copying'
method: GsTonelOrderedDictionary
postCopy
	super postCopy.
	keys := keys copy.
	values := values copy
%

category: 'printing'
method: GsTonelOrderedDictionary
printOn: aStream
	super printOn: aStream.
	
	aStream nextPut: $(.
	self size <= 100
		ifTrue: [
			| first |
			first := true.
			self keysAndValuesDo: [ :key :value |
				"keysAndValuesDo:separatedBy: would be nice"
				first
					ifTrue: [ first := false ]
					ifFalse: [ aStream space ].
				aStream
					print: key;
					nextPutAll: '->';				
					print: value ] ]
		ifFalse: [
			aStream
				nextPutAll: 'size ';
				print: self size ].
	aStream nextPut: $)	
%

category: 'private'
method: GsTonelOrderedDictionary
privateAt: aKey put: aValue
	size = keys size ifTrue: [ self grow ].
	keys at: (size := size + 1) put: aKey.
	^ values at: size put: aValue
%

category: 'private'
method: GsTonelOrderedDictionary
removeIndex: index
	| value |
	value := values at: index.
	index to: size - 1 do:
			[ :i | 
			keys at: i put: (keys at: i + 1).
			values at: i put: (values at: i + 1) ].
	keys at: size put: nil.
	values at: size put: nil.
	size := size - 1.
	^ value
%

category: 'accessing'
method: GsTonelOrderedDictionary
removeKey: aKey
	"Remove aKey from the receiver, raise an exception if the element is missing."

	^ self removeKey: aKey ifAbsent: [ self errorKeyNotFound ]
%

category: 'accessing'
method: GsTonelOrderedDictionary
removeKey: aKey ifAbsent: aBlock
	"Remove aKey from the receiver, evaluate aBlock if the element is missing."

	| index |
	index := self findIndexFor: aKey.
	index = 0 ifTrue: [ ^ aBlock value ].
	^ self removeIndex: index
%

category: 'accessing'
method: GsTonelOrderedDictionary
size
	^ size
%

category: 'ston'
method: GsTonelOrderedDictionary
stonOn: stonWriter
	"Instances of STON mapClass will be encoded directly, without a class tag.
	Other (sub)classes will be encoded with a class tag and will use a map representation. "
	
    stonWriter encodeMap: self
%

category: 'enumerating'
method: GsTonelOrderedDictionary
values
	^ values copyFrom: 1 to: size
%

category: 'filetree'
method: GsTonelOrderedDictionary
_writeCypressJsonOn: fileStream
	"Private method which may be removed in a future GemStone version."

	self _writeCypressJsonOn: fileStream indent: 0
%

category: 'filetree'
method: GsTonelOrderedDictionary
_writeCypressJsonOn: aStream indent: startIndent
	"Private method which may be removed in a future GemStone version."

	| indent cnt |
	indent := startIndent.
	aStream nextPutAll: '{'.
	cnt := 0.
	indent := indent + 1.
	self keys do: 
			[:key |
			| value |
			value := self at: key.
			cnt := cnt + 1.
			aStream lf.
			indent timesRepeat: [aStream tab].
			key _writeCypressJsonOn: aStream indent: indent.
			aStream nextPutAll: ' : '.
			value _writeCypressJsonOn: aStream indent: indent.
			cnt < size
				ifTrue: 
					[aStream nextPutAll: ',' ]].
	self size > 0
		ifTrue: [ aStream lf ]
		ifFalse: [ aStream space ].
	aStream nextPutAll: '}'
%

! Class implementation for 'RBParser'

!		Class methods for 'RBParser'

category: 'instance creation'
classmethod: RBParser
new

	^self basicNew initialize
%

category: 'accessing'
classmethod: RBParser
parseExpression: aString 
	^self parseExpression: aString onError: nil
%

category: 'accessing'
classmethod: RBParser
parseExpression: aString onError: aBlock 
	| node parser |
	parser := self new.
	parser errorBlock: aBlock.
	parser initializeParserWith: aString.
	node := parser parseExpression: aString.
	^(node statements size == 1 and: [node temporaries isEmpty]) 
		ifTrue: [node statements first]
		ifFalse: [node]
%

category: 'accessing'
classmethod: RBParser
parseMethod: aString 
	^self parseMethod: aString onError: nil
%

category: 'accessing'
classmethod: RBParser
parseMethod: aString onError: aBlock 
	| parser |
	parser := self new.
	parser errorBlock: aBlock.
	parser initializeParserWith: aString.
	^parser parseMethod: aString
%

category: 'parsing'
classmethod: RBParser
parseMethodPattern: aString 
	| parser |
	parser := self new.
	parser errorBlock: [:error :position | ^nil].
	parser initializeParserWith: aString.
	^parser parseMessagePattern selector
%

category: 'accessing'
classmethod: RBParser
parseRewriteExpression: aString 
	^self parseRewriteExpression: aString onError: nil
%

category: 'accessing'
classmethod: RBParser
parseRewriteExpression: aString onError: aBlock 
	^RBPatternParser parseExpression: aString onError: aBlock
%

category: 'accessing'
classmethod: RBParser
parseRewriteMethod: aString 
	^self parseRewriteMethod: aString onError: nil
%

category: 'accessing'
classmethod: RBParser
parseRewriteMethod: aString onError: aBlock 
	^RBPatternParser parseMethod: aString onError: aBlock
%

category: 'accessing'
classmethod: RBParser
parseWorkspace: aString
	^ self parseWorkspace: aString onError: nil
%

category: 'accessing'
classmethod: RBParser
parseWorkspace: aString onError: aBlock
	| parser |
	parser := self new.
	parser errorBlock: aBlock.
	parser initializeParserWith: aString.
	^ parser parseWorkspace: aString
%

!		Instance methods for 'RBParser'

category: 'private'
method: RBParser
addCommentsTo: aNode
	aNode comments: aNode comments , comments.
	comments := OrderedCollection new
%

category: 'private-classes'
method: RBParser
arrayNodeClass
	^ RBArrayNode
%

category: 'private-classes'
method: RBParser
assignmentNodeClass
	^ RBAssignmentNode
%

category: 'testing'
method: RBParser
atEnd
	^currentToken class == RBToken
%

category: 'private-classes'
method: RBParser
blockNodeClass
	^ RBBlockNode
%

category: 'private-classes'
method: RBParser
cascadeNodeClass
	^ RBCascadeNode
%

category: 'error handling'
method: RBParser
errorBlock
	^errorBlock isNil ifTrue: [[:message :position | ]] ifFalse: [errorBlock]
%

category: 'accessing'
method: RBParser
errorBlock: aBlock 
	errorBlock := aBlock.
	scanner notNil ifTrue: [scanner errorBlock: aBlock]
%

category: 'error handling'
method: RBParser
errorPosition
	^currentToken start
%

category: 'initialize-release'
method: RBParser
initialize
	comments := OrderedCollection new
%

category: 'accessing'
method: RBParser
initializeParserWith: aString 
	source := aString.
	self scanner: (self scannerClass on: aString readStreamPortable
				errorBlock: self errorBlock)
%

category: 'private-classes'
method: RBParser
literalArrayNodeClass
	^ RBLiteralArrayNode
%

category: 'private-classes'
method: RBParser
literalNodeClass
	^ RBLiteralNode
%

category: 'private-classes'
method: RBParser
messageNodeClass
	^ RBMessageNode
%

category: 'private-classes'
method: RBParser
methodNodeClass
	^ RBMethodNode
%

category: 'private'
method: RBParser
nextToken
	^nextToken isNil ifTrue: [nextToken := scanner next] ifFalse: [nextToken]
%

category: 'private-parsing'
method: RBParser
parseArgs
	| args |
	args := OrderedCollection new.
	[currentToken isIdentifier] whileTrue: [args add: self parseVariableNode].
	^args
%

category: 'private-parsing'
method: RBParser
parseArray
  | position node |
  position := currentToken start.
  self step.
  (currentToken isSpecial and: [ currentToken value = $: ])
    ifTrue: [ ^self parseQueryBlock: position ].
  node := self arrayNodeClass new.
  node left: position.
  self parseStatementList: false into: node.
  (currentToken isSpecial and: [ currentToken value = $} ])
    ifFalse: [ self parserError: 'expected }' ].
  node right: currentToken start.
  self step.
  ^ node
%

category: 'private-parsing'
method: RBParser
parseAssignment
	"Need one token lookahead to see if we have a ':='. This method could 
	make it possible to assign the literals true, false and nil."

	| node position |
	(currentToken isIdentifier and: [self nextToken isAssignment]) 
		ifFalse: [^self parseCascadeMessage].
	node := self parseVariableNode.
	position := currentToken start.
	self step.
	^self assignmentNodeClass 
		variable: node
		value: self parseAssignment
		position: position
%

category: 'private-parsing'
method: RBParser
parseBinaryMessage
	| node |
	node := self parseUnaryMessage.
	
	[currentToken isLiteralToken ifTrue: [self patchNegativeLiteral].
	currentToken isBinary] 
			whileTrue: [node := self parseBinaryMessageWith: node].
	^node
%

category: 'private-parsing'
method: RBParser
parseBinaryMessageWith: aNode 
	| binaryToken |
	binaryToken := currentToken.
	self step.
	^self messageNodeClass 
		receiver: aNode
		selectorParts: (Array with: binaryToken)
		arguments: (Array with: self parseUnaryMessage)
%

category: 'private-parsing'
method: RBParser
parseBinaryPattern
	| binaryToken node args |
	currentToken isBinary
		ifFalse: [self parserError: 'Message pattern expected'].
	binaryToken := currentToken.
	self step.
	args := Array with: self parseVariableNode.
	node := self methodNodeClass
		selectorParts: (Array with: binaryToken)
		arguments: args.
	node comments: node comments , args last comments.
	args last comments: nil.
	^node
%

category: 'private-parsing'
method: RBParser
parseBinaryPragma
	| binaryToken |
	currentToken isBinary 
		ifFalse: [ self parserError: 'Message pattern expected' ].
	binaryToken := currentToken.
	self step.
	^ self pragmaNodeClass
		selectorParts: (Array with: binaryToken)
		arguments: (Array with: self parsePragmaLiteral)
%

category: 'private-parsing'
method: RBParser
parseBlock
	| position node |
	position := currentToken start.
	self step.
	node := self blockNodeClass new. 
	self parseBlockArgsInto: node.
	node left: position.
	node body: (self parseStatements: false).
	(currentToken isSpecial and: [currentToken value = $]])
		ifFalse: [self parserError: ''']'' expected'].
	node right: currentToken start.
	self step.
	^node
%

category: 'private-parsing'
method: RBParser
parseBlockArgsInto: node 
	| verticalBar args colons |
	args := OrderedCollection new: 2.
	colons := OrderedCollection new: 2.
	verticalBar := false.
	[currentToken isSpecial and: [currentToken value = $:]] whileTrue: 
			[colons add: currentToken start.
			self step.	":"
			verticalBar := true.
			args add: self parseVariableNode].
	verticalBar 
		ifTrue: 
			[currentToken isBinary 
				ifTrue: 
					[node bar: currentToken start.
					currentToken value = #| 
						ifTrue: [self step]
						ifFalse: 
							[currentToken value = #'||' 
								ifTrue: 
									["Hack the current token to be the start 
									of temps bar"

									currentToken
										value: #|;
										start: currentToken start + 1]
								ifFalse: [self parserError: '''|'' expected']]]
				ifFalse: 
					[(currentToken isSpecial and: [currentToken value = $]]) 
						ifFalse: [self parserError: '''|'' expected']]].
	node
		arguments: args;
		colons: colons.
	^node
%

category: 'private-parsing'
method: RBParser
parseCascadeMessage
	| node receiver messages semicolons |
	node := self parseKeywordMessage.
	(currentToken isSpecial 
		and: [currentToken value = $; and: [node isMessage]]) ifFalse: [^node].
	receiver := node receiver.
	messages := OrderedCollection new: 3.
	semicolons := OrderedCollection new: 3.
	messages add: node.
	[currentToken isSpecial and: [currentToken value = $;]] whileTrue: 
			[semicolons add: currentToken start.
			self step.
			messages add: (currentToken isIdentifier 
						ifTrue: [self parseUnaryMessageWith: receiver]
						ifFalse: 
							[currentToken isKeyword 
								ifTrue: [self parseKeywordMessageWith: receiver]
								ifFalse: 
									[| temp |
									currentToken isLiteralToken ifTrue: [self patchNegativeLiteral].
									currentToken isBinary ifFalse: [self parserError: 'Message expected'].
									temp := self parseBinaryMessageWith: receiver.
									temp == receiver ifTrue: [self parserError: 'Message expected'].
									temp]])].
	^self cascadeNodeClass messages: messages semicolons: semicolons
%

category: 'accessing'
method: RBParser
parseExpression: aString 
	| node |
	node := self parseStatements: false.
	(RBMethodNode selector: #noMethod body: node) source: aString.	"Make the sequence node have a method node as its parent"
	self atEnd ifFalse: [self parserError: 'Unknown input at end'].
	^node
%

category: 'private-parsing'
method: RBParser
parseKeywordMessage
	^self parseKeywordMessageWith: self parseBinaryMessage
%

category: 'private-parsing'
method: RBParser
parseKeywordMessageWith: node 
	| args isKeyword keywords |
	args := OrderedCollection new: 3.
	keywords := OrderedCollection new: 3.
	isKeyword := false.
	[currentToken isKeyword] whileTrue: 
			[keywords add: currentToken.
			self step.
			args add: self parseBinaryMessage.
			isKeyword := true].
	^isKeyword 
		ifTrue: 
			[self messageNodeClass 
				receiver: node
				selectorParts: keywords
				arguments: args]
		ifFalse: [node]
%

category: 'private-parsing'
method: RBParser
parseKeywordPattern
	| keywords args node |
	keywords := OrderedCollection new.
	args := OrderedCollection new.
	[currentToken isKeyword]
		whileTrue:
			[keywords add: currentToken.
			self step.
			args add: self parseVariableNode].
	node := self methodNodeClass
		selectorParts: keywords
		arguments: args.
	node comments: (node comments, args last comments).
	args last comments: nil.
	^node
%

category: 'private-parsing'
method: RBParser
parseKeywordPragma
	| keywords arguments |
	keywords := OrderedCollection new: 2.
	arguments := OrderedCollection new: 2.
	[ currentToken isKeyword ] whileTrue: [
		keywords addLast: currentToken.
		self step.
		arguments addLast: self parsePragmaLiteral ].
	^ self pragmaNodeClass selectorParts: keywords arguments: arguments
%

category: 'private-parsing'
method: RBParser
parseLiteralArray
	| stream start stop |
	start := currentToken start.
	stream := WriteStreamPortable on: Array new.
	self step.
	[self atEnd or: [currentToken isSpecial and: [currentToken value = $)]]] 
		whileFalse: [stream nextPut: self parseLiteralArrayObject].
	(currentToken isSpecial and: [currentToken value = $)]) 
		ifFalse: [self parserError: ''')'' expected'].
	stop := currentToken stop.
	self step.
	^self literalArrayNodeClass 
		startPosition: start
		contents: stream contents
		stopPosition: stop
		isByteArray: false
%

category: 'private-parsing'
method: RBParser
parseLiteralArrayObject
	currentToken isSpecial 
		ifTrue: 
			[currentToken value = $( ifTrue: [^self parseLiteralArray].
			"currentToken value == $[ ifTrue: [^self parseLiteralByteArray]"].
	currentToken isLiteralArrayToken 
		ifTrue: 
			[^currentToken isForByteArray 
				ifTrue: [self parseLiteralByteArray]
				ifFalse: [self parseLiteralArray]].
	currentToken isLiteralToken ifFalse: [self patchLiteralArrayToken].
	^self parsePrimitiveLiteral
%

category: 'private-parsing'
method: RBParser
parseLiteralByteArray
	| stream start stop |
	start := currentToken start.
	stream := WriteStreamPortable on: Array new.
	self step.
	[self atEnd or: [currentToken isSpecial and: [currentToken value = $]]]] 
		whileFalse: [stream nextPut: self parseLiteralByteArrayObject].
	(currentToken isSpecial and: [currentToken value = $]]) 
		ifFalse: [self parserError: ''']'' expected'].
	stop := currentToken stop.
	self step.
	^self literalArrayNodeClass 
		startPosition: start
		contents: stream contents
		stopPosition: stop
		isByteArray: true
%

category: 'private-parsing'
method: RBParser
parseLiteralByteArrayObject
	(currentToken isLiteralToken and: 
			[currentToken value _isInteger and: [currentToken value between: 0 and: 255]]) 
		ifFalse: [self parserError: 'Expecting 8-bit integer'].
	^self parsePrimitiveLiteral
%

category: 'private-parsing'
method: RBParser
parseMessagePattern
	currentToken isLiteralToken ifTrue: [self patchLiteralMessage].
	^currentToken isIdentifier 
		ifTrue: [self parseUnaryPattern]
		ifFalse: 
			[currentToken isKeyword 
				ifTrue: [self parseKeywordPattern]
				ifFalse: [self parseBinaryPattern]]
%

category: 'private-parsing'
method: RBParser
parseMethod
	| methodNode | 
	methodNode := self parseMessagePattern.
	self parsePragmas.
	self addCommentsTo: methodNode.
	methodNode body: (self parseStatements: true).
	pragmas isNil
		ifFalse: [ methodNode pragmas: pragmas ].
	^methodNode
%

category: 'accessing'
method: RBParser
parseMethod: aString 
	| node |
	node := self parseMethod.
	self atEnd ifFalse: [self parserError: 'Unknown input at end'].
	node source: aString.
	^node
%

category: 'private-parsing'
method: RBParser
parseNegatedNumber
	| token |
	(self nextToken isLiteral not or: [ self nextToken realValue isNumber not ])
		ifTrue: [ self parserError: 'only numbers may be negated' ].
	token := RBLiteralToken value: self nextToken realValue negated start: currentToken start stop: nextToken stop.
	self step; step.
	^ self literalNodeClass literalToken: token
%

category: 'private-parsing'
method: RBParser
parseParenthesizedExpression
	| leftParen node |
	leftParen := currentToken start.
	self step.
	node := self parseAssignment.
	^(currentToken isSpecial and: [currentToken value = $)])
		ifTrue: 
			[node addParenthesis: (leftParen to: currentToken start).
			self step.
			node]
		ifFalse: [self parserError: ''')'' expected']
%

category: 'private-parsing'
method: RBParser
parsePragma
  ^ currentToken isIdentifier
    ifTrue: [ 
      currentToken value = 'protected'
        ifTrue: [ self parseProtectedPragma ]
        ifFalse: [ self parseUnaryPragma ] ]
    ifFalse: [ 
      currentToken isKeyword
        ifTrue: [ self parseKeywordPragma ]
        ifFalse: [ self parseBinaryPragma ] ]
%

category: 'private-parsing'
method: RBParser
parsePragmaLiteral
	^ self parseLiteralArrayObject
%

category: 'private-parsing'
method: RBParser
parsePragmas
	| pragma start |
	[ currentToken isBinary and: [ currentToken value = #< ] ] whileTrue: [
		start := currentToken start.
		self step.
		pragma := self parsePragma.
		(currentToken isBinary and: [ currentToken value = #> ]) 
			ifFalse: [ self parserError: '''>'' expected' ].
		pragma left: start; right: currentToken start.
		pragmas isNil
			ifTrue: [ pragmas := OrderedCollection new ].
		pragmas addLast: pragma.
		self step ]
%

category: 'private-parsing'
method: RBParser
parsePrimitiveIdentifier
	| token node |
	token := currentToken.
	self step.
	node := self variableNodeClass identifierToken: token.
	self addCommentsTo: node.
	^node
%

category: 'private-parsing'
method: RBParser
parsePrimitiveLiteral
	| token |
	token := currentToken.
	self step.
	^self literalNodeClass literalToken: token
%

category: 'private-parsing'
method: RBParser
parsePrimitiveObject
	currentToken isIdentifier ifTrue: [^self parsePrimitiveIdentifier].
	(currentToken isLiteralToken and: [currentToken isMultiKeyword not]) 
		ifTrue: [^self parsePrimitiveLiteral].
	currentToken isLiteralArrayToken 
		ifTrue: 
			[^currentToken isForByteArray 
				ifTrue: [self parseLiteralByteArray]
				ifFalse: [self parseLiteralArray]].
	currentToken isSpecial 
		ifTrue: 
			[currentToken value = $[ ifTrue: [^self parseBlock].
			currentToken value = $( ifTrue: [^self parseParenthesizedExpression].
			currentToken value = ${ ifTrue: [^self parseArray]].
	(currentToken isBinary and: [ currentToken value = #- ]) 
		ifTrue: [ ^self parseNegatedNumber ].
	self parserError: 'Variable expected'
%

category: 'private-parsing'
method: RBParser
parseProtectedPragma
  "encoutered 'protected' as first token in pragma"

  self step.
  currentToken isKeyword
    ifFalse: [ ^ self pragmaNodeClass selectorParts: (Array with: 'protected') arguments: #() ].
  ^ self parseKeywordPragma
    isProtected: true;
    yourself
%

category: 'private-parsing'
method: RBParser
parseQueryBlock: startPosition
  | position node |
  position := startPosition.
  node := self queryBlockNodeClass new.
  self parseBlockArgsInto: node.
  node left: position.
  node body: (self parseStatements: false).
  (currentToken isSpecial and: [ currentToken value = $} ])
    ifFalse: [ self parserError: '''}'' expected' ].
  node right: currentToken start.
  self step.
  ^ node
%

category: 'error handling'
method: RBParser
parserError: aString 
	"Evaluate the block. If it returns raise an error"

	self errorBlock value: aString value: self errorPosition.
	self error: aString
%

category: 'private-parsing'
method: RBParser
parseStatementList: pragmaBoolean into: sequenceNode 
	| statements return periods returnPosition node |
	return := false.
	statements := OrderedCollection new.
	periods := OrderedCollection new.
	self addCommentsTo: sequenceNode.
	pragmaBoolean ifTrue: [self parsePragmas].
	[currentToken isSpecial and: [currentToken value = $.]] whileTrue: 
		[periods add: currentToken start.
		self step].
	[self atEnd 
		or: [currentToken isSpecial and: ['])}' includes: currentToken value]]] 
			whileFalse: 
				[return ifTrue: [self parserError: 'End of statement list encounted'].
				(currentToken isSpecial and: [currentToken value = $^]) 
					ifTrue: 
						[returnPosition := currentToken start.
						self step.
						node := self returnNodeClass return: returnPosition
									value: self parseAssignment.
						statements add: node.
						return := true]
					ifFalse: 
						[node := self parseAssignment.
						statements add: node].
				(currentToken isSpecial and: [currentToken value = $.]) 
					ifTrue: 
						[periods add: currentToken start.
						self step.
						self addCommentsTo: node]
					ifFalse: [return := true].
				[currentToken isSpecial and: [currentToken value = $.]] whileTrue: 
					[periods add: currentToken start.
					self step]].
	statements notEmpty ifTrue: [self addCommentsTo: statements last].
	sequenceNode
		statements: statements;
		periods: periods.
	^sequenceNode
%

category: 'private-parsing'
method: RBParser
parseStatements: pragmaBoolean 
	| args leftBar rightBar |
	args := #().
	leftBar := rightBar := nil.
	currentToken isBinary 
		ifTrue: 
			[currentToken value = #| 
				ifTrue: 
					[leftBar := currentToken start.
					self step.
					args := self parseArgs.
					(currentToken isBinary and: [currentToken value = #|]) 
						ifFalse: [self parserError: '''|'' expected'].
					rightBar := currentToken start.
					self step]
				ifFalse: 
					[currentToken value = #'||' 
						ifTrue: 
							[rightBar := (leftBar := currentToken start) + 1.
							self step]]].
	^self parseStatementList: pragmaBoolean
		into: (self sequenceNodeClass 
				leftBar: leftBar
				temporaries: args
				rightBar: rightBar)
%

category: 'private-parsing'
method: RBParser
parseUnaryMessage
	| node |
	node := self parsePrimitiveObject.
	self addCommentsTo: node.
	[currentToken isLiteralToken ifTrue: [self patchLiteralMessage].
	currentToken isIdentifier] 
			whileTrue: [node := self parseUnaryMessageWith: node].
	self addCommentsTo: node.
	^node
%

category: 'private-parsing'
method: RBParser
parseUnaryMessageWith: aNode 
	| selector |
	selector := currentToken.
	self step.
	^self messageNodeClass 
		receiver: aNode
		selectorParts: (Array with: selector)
		arguments: #()
%

category: 'private-parsing'
method: RBParser
parseUnaryPattern
	| selector |
	selector := currentToken.
	self step.
	^self methodNodeClass selectorParts: (Array with: selector) arguments: #()
%

category: 'private-parsing'
method: RBParser
parseUnaryPragma
	| selector |
	selector := currentToken.
	self step.
	^ self pragmaNodeClass selectorParts: (Array with: selector) arguments: #()
%

category: 'private-parsing'
method: RBParser
parseVariableNode
	currentToken isIdentifier 
		ifFalse: [self parserError: 'Variable name expected'].
	^self parsePrimitiveIdentifier
%

category: 'accessing'
method: RBParser
parseWorkspace
	| workspaceNode args leftBar rightBar |
	workspaceNode := self workspaceNodeClass new.
	(currentToken notNil and: [ currentToken comments notNil ])
		ifTrue: [ 
			comments addAll: currentToken comments.
			currentToken comments: nil ].
	self addCommentsTo: workspaceNode.
	args := #().
	leftBar := rightBar := nil.
	currentToken isBinary
		ifTrue: [ 
			currentToken value = #'|'
				ifTrue: [ 
					leftBar := currentToken start.
					self step.
					args := self parseArgs.
					(currentToken isBinary and: [ currentToken value = #'|' ])
						ifFalse: [ self parserError: '''|'' expected' ].
					rightBar := currentToken start.
					self step ]
				ifFalse: [ 
					currentToken value = #'||'
						ifTrue: [ 
							rightBar := (leftBar := currentToken start) + 1.
							self step ] ] ].
	workspaceNode
		body:
			(self
				parseWorkspaceStatementList: workspaceNode
				into:
					(self sequenceNodeClass leftBar: leftBar temporaries: args rightBar: rightBar)).
	^ workspaceNode
%

category: 'accessing'
method: RBParser
parseWorkspace: aString
	| node |
	node := self parseWorkspace.
	self atEnd
		ifFalse: [ self parserError: 'Unknown input at end' ].
	node source: aString.
	^ node
%

category: 'accessing'
method: RBParser
parseWorkspaceStatementList: workspaceNode into: aSequenceNode
	| statements return periods returnPosition node |
	return := false.
	statements := OrderedCollection new.
	periods := OrderedCollection new.
	self addCommentsTo: aSequenceNode.
	[ currentToken isSpecial and: [ currentToken value = $. ] ]
		whileTrue: [ 
			periods add: currentToken start.
			self step ].
	[ 
	self atEnd
		or: [ currentToken isSpecial and: [ '])}' includes: currentToken value ] ] ]
		whileFalse: [ 
			return
				ifTrue: [ self parserError: 'End of statement list encounted' ].
			(currentToken isSpecial and: [ currentToken value = $^ ])
				ifTrue: [ 
					returnPosition := currentToken start.
					self step.
					node := self returnNodeClass
						return: returnPosition
						value: self parseAssignment.
					statements add: node.
					return := true ]
				ifFalse: [ 
					node := self parseAssignment.
					statements add: node ].
			(currentToken isSpecial and: [ currentToken value = $. ])
				ifTrue: [ 
					periods add: currentToken start.
					self step.
					self addCommentsTo: node ]
				ifFalse: [ return := true ].
			[ currentToken isSpecial and: [ currentToken value = $. ] ]
				whileTrue: [ 
					periods add: currentToken start.
					self step ] ].
	self addCommentsTo: workspaceNode.
	aSequenceNode
		statements: statements;
		periods: periods.
	^ aSequenceNode
%

category: 'private'
method: RBParser
patchLiteralArrayToken
	(currentToken isIdentifier and: 
			[self nextToken isAssignment 
				and: [currentToken stop + 1 = self nextToken start]]) 
		ifTrue: 
			[currentToken := RBLiteralToken 
						value: (currentToken value , ':') asSymbol
						start: currentToken start
						stop: self nextToken start.
			nextToken := RBLiteralToken 
						value: #=
						start: nextToken stop
						stop: nextToken stop.
			^self].
	currentToken isAssignment 
		ifTrue: 
			[currentToken := RBLiteralToken 
						value: #':'
						start: currentToken start
						stop: currentToken start.
			nextToken := RBLiteralToken 
						value: #=
						start: currentToken stop
						stop: currentToken stop.
			^self].
	currentToken isSpecial 
		ifTrue: 
			[currentToken := RBLiteralToken 
						value: (String with: currentToken value) asSymbol
						start: currentToken start
						stop: currentToken stop.
			^self].
	(currentToken isIdentifier and: [currentToken value includes: $.]) 
		ifTrue: 
			[currentToken := RBLiteralToken 
						value: currentToken value
						start: currentToken start
						stop: currentToken stop.
			^self].
	(currentToken isIdentifier 
		or: [currentToken isBinary or: [currentToken isKeyword]]) 
			ifFalse: [^self parserError: 'Invalid token'].
	currentToken := RBLiteralToken 
				value: currentToken value asSymbol
				start: currentToken start
				stop: currentToken stop
%

category: 'private'
method: RBParser
patchLiteralMessage
	currentToken value == true 
		ifTrue: 
			[^currentToken := RBIdentifierToken value: 'true' start: currentToken start].
	currentToken value == false 
		ifTrue: 
			[^currentToken := RBIdentifierToken value: 'false' start: currentToken start].
	currentToken value == nil 
		ifTrue: 
			[^currentToken := RBIdentifierToken value: 'nil' start: currentToken start]
%

category: 'private'
method: RBParser
patchNegativeLiteral
	"Handle the special negative number case for binary message sends."

	currentToken value isNumber 
		ifFalse: [^self].
	currentToken value <= 0 ifFalse: [^self].
	currentToken value = 0 
		ifTrue: 
			[(source notNil and: 
					[source notEmpty 
						and: [(source at: (currentToken start min: source size)) = $-]]) 
				ifFalse: [^self]].
	nextToken := currentToken.
	currentToken := RBBinarySelectorToken value: #- start: nextToken start.
	nextToken value: nextToken value negated.
	(nextToken isKindOf: RBNumberLiteralToken) 
		ifTrue: 
			[nextToken source: (nextToken source copyFrom: 2 to: nextToken source size)].
	nextToken start: nextToken start + 1
%

category: 'private-classes'
method: RBParser
pragmaNodeClass
	^ RBPragmaNode
%

category: 'private-classes'
method: RBParser
queryBlockNodeClass
  ^ RBQueryBlockNode
%

category: 'private-classes'
method: RBParser
returnNodeClass
	^ RBReturnNode
%

category: 'initialize-release'
method: RBParser
scanner: aScanner 
	scanner := aScanner.
	pragmas := nil.
	self initialize.
	self step
%

category: 'accessing'
method: RBParser
scannerClass
	^RBScanner
%

category: 'private-classes'
method: RBParser
sequenceNodeClass
	^ RBSequenceNode
%

category: 'private'
method: RBParser
step
	(currentToken notNil and: [currentToken comments notNil]) 
		ifTrue: [comments addAll: currentToken comments].
	nextToken notNil 
		ifTrue: 
			[currentToken := nextToken.
			nextToken := nil]
		ifFalse: [currentToken := scanner next]
%

category: 'private-classes'
method: RBParser
variableNodeClass
	^ RBVariableNode
%

category: 'private-classes'
method: RBParser
workspaceNodeClass
	^ RBWorkspaceNode
%

! Class implementation for 'RBPatternParser'

!		Instance methods for 'RBPatternParser'

category: 'private-classes'
method: RBPatternParser
messageNodeClass
	^RBPatternMessageNode
%

category: 'private-classes'
method: RBPatternParser
methodNodeClass
	^RBPatternMethodNode
%

category: 'private-parsing'
method: RBPatternParser
parseLiteralByteArrayObject
	| node |
	(currentToken isIdentifier and: [currentToken isPatternVariable]) 
		ifTrue: 
			[node := self variableNodeClass identifierToken: currentToken.
			node isLiteralNode 
				ifTrue: 
					[self step.
					^node]].
	^super parseLiteralByteArrayObject
%

category: 'private-parsing'
method: RBPatternParser
parsePatternBlock: aClass 
	| position node |
	position := currentToken start.
	self step.
	node := self parseBlockArgsInto: aClass new.
	node left: position.
	node body: (self parseStatements: false).
	(currentToken isSpecial and: [currentToken value = $}]) 
		ifFalse: [self parserError: '''}'' expected'].
	node right: currentToken start.
	self step.
	^node
%

category: 'private-parsing'
method: RBPatternParser
parsePragmaLiteral
  | node |
  currentToken isPatternBlock
    ifTrue: [ ^ self parsePatternBlock: RBPatternBlockNode ].
  (currentToken isIdentifier and: [ currentToken isPatternVariable ])
    ifTrue: [ 
      node := self variableNodeClass identifierToken: currentToken.
      node isLiteralNode
        ifFalse: [ self error: 'Literal pattern expected' ].
      self step.
      currentToken isPatternBlock
        ifTrue: [ 
          node := (self parsePatternBlock: RBPatternWrapperBlockNode)
            wrappedNode: node;
            yourself ].
      ^ node ].
  ^ super parsePragmaLiteral
%

category: 'private-parsing'
method: RBPatternParser
parsePrimitiveLiteral
	| node |
	(currentToken isIdentifier and: [currentToken isPatternVariable]) 
		ifTrue: 
			[node := self variableNodeClass identifierToken: currentToken.
			node isLiteralNode 
				ifTrue: 
					[self step.
					^node].
			currentToken := RBLiteralToken 
						value: currentToken value asSymbol
						start: currentToken start
						stop: currentToken stop].
	^super parsePrimitiveLiteral
%

category: 'private-parsing'
method: RBPatternParser
parsePrimitiveObject
	currentToken isPatternBlock 
		ifTrue: [^self parsePatternBlock: RBPatternBlockNode].
	^super parsePrimitiveObject
%

category: 'private-parsing'
method: RBPatternParser
parseUnaryMessage
	| node |
	node := self parsePrimitiveObject.
	self addCommentsTo: node.
	
	[currentToken isLiteralToken ifTrue: [self patchLiteralMessage].
	currentToken isPatternBlock 
		ifTrue: 
			[node := (self parsePatternBlock: RBPatternWrapperBlockNode)
						wrappedNode: node;
						yourself].
	currentToken isIdentifier] 
			whileTrue: [node := self parseUnaryMessageWith: node].
	self addCommentsTo: node.
	^node
%

category: 'private'
method: RBPatternParser
patchLiteralArrayToken
	(currentToken isIdentifier and: [currentToken isPatternVariable]) 
		ifTrue: [^self].
	super patchLiteralArrayToken
%

category: 'private-classes'
method: RBPatternParser
pragmaNodeClass
	^RBPatternPragmaNode
%

category: 'accessing'
method: RBPatternParser
scannerClass
	^RBPatternScanner
%

category: 'private-classes'
method: RBPatternParser
variableNodeClass
	^RBPatternVariableNode
%

! Class implementation for 'RBTonelParser'

!		Instance methods for 'RBTonelParser'

category: 'accessing'
method: RBTonelParser
currentToken

	^currentToken
%

category: 'private-parsing'
method: RBTonelParser
parseTonelKeywordPattern
	" do not process $[ token .. caller will do the right thing"

	| keywords args node continue |
	keywords := OrderedCollection new.
	args := OrderedCollection new.
	continue := true.
	[  continue and: [ currentToken isKeyword ]  ]
		whileTrue:
			[keywords add: currentToken.
			continue := (self peekTonelFor: #special value: $[) not.
			continue ifTrue: [ self step ].
			args add: self parseTonelVariableNode].
	node := self methodNodeClass
		selectorParts: keywords
		arguments: args.
	node comments: (node comments, args last comments).
	args last comments: nil.
	^node
%

category: 'private-parsing'
method: RBTonelParser
parseTonelMessagePattern

	currentToken isLiteralToken ifTrue: [self patchTonelLiteralMessage].
	^ currentToken isIdentifier 
		ifTrue: [ self parseTonelUnaryPattern]
		ifFalse: 
			[currentToken isKeyword 
				ifTrue: [self parseTonelKeywordPattern]
				ifFalse: [self parseTonelBinaryPattern] ]
%

category: 'private-parsing'
method: RBTonelParser
parseTonelPragmas
	| pragma start |
	[ currentToken isBinary and: [ currentToken value = #< ] ] whileTrue: [
		start := currentToken start.
		self step.
		pragma := self parsePragma.
		(currentToken isBinary and: [ currentToken value = #> ]) 
			ifFalse: [ self parserError: '''>'' expected' ].
		pragma left: start; right: currentToken start.
		pragmas isNil
			ifTrue: [ pragmas := OrderedCollection new ].
		pragmas addLast: pragma.
		self step ]
%

category: 'private-parsing'
method: RBTonelParser
parseTonelPrimitiveIdentifier
	| token node |
	token := currentToken.
	(self peekTonelFor: #special value: $[)
		ifFalse: [ self step ].
	node := self variableNodeClass identifierToken: token.
	self addCommentsTo: node.
	^node
%

category: 'private-parsing'
method: RBTonelParser
parseTonelStatementList: pragmaBoolean into: sequenceNode 
	| statements return periods returnPosition node |
	return := false.
	statements := OrderedCollection new.
	periods := OrderedCollection new.
	self addCommentsTo: sequenceNode.
	pragmaBoolean ifTrue: [self parsePragmas].
	[currentToken isSpecial and: [currentToken value = $.]] whileTrue: 
		[periods add: currentToken start.
		self step].
	[self atEnd 
		or: [currentToken isSpecial and: ['])}' includes: currentToken value]]] 
			whileFalse: 
				[return ifTrue: [self parserError: 'End of statement list encounted'].
				(currentToken isSpecial and: [currentToken value = $^]) 
					ifTrue: 
						[returnPosition := currentToken start.
						self step.
						node := self returnNodeClass return: returnPosition
									value: self parseAssignment.
						statements add: node.
						return := true]
					ifFalse: 
						[node := self parseAssignment.
						statements add: node].
				(currentToken isSpecial and: [currentToken value = $.]) 
					ifTrue: 
						[periods add: currentToken start.
						self step.
						self addCommentsTo: node]
					ifFalse: [return := true].
				[currentToken isSpecial and: [currentToken value = $.]] whileTrue: 
					[periods add: currentToken start.
					self step]].
	statements notEmpty ifTrue: [self addCommentsTo: statements last].
	sequenceNode
		statements: statements;
		periods: periods.
	^sequenceNode
%

category: 'private-parsing'
method: RBTonelParser
parseTonelStatements: pragmaBoolean 
	| args leftBar rightBar |
	args := #().
	leftBar := rightBar := nil.
	currentToken isBinary 
		ifTrue: 
			[currentToken value = #| 
				ifTrue: 
					[leftBar := currentToken start.
					self step.
					args := self parseArgs.
					(currentToken isBinary and: [currentToken value = #|]) 
						ifFalse: [self parserError: '''|'' expected'].
					rightBar := currentToken start.
					self step]
				ifFalse: 
					[currentToken value = #'||' 
						ifTrue: 
							[rightBar := (leftBar := currentToken start) + 1.
							self step]]].
	^self parseTonelStatementList: pragmaBoolean
		into: (self sequenceNodeClass 
				leftBar: leftBar
				temporaries: args
				rightBar: rightBar)
%

category: 'private-parsing'
method: RBTonelParser
parseTonelUnaryPattern
	"only used when parsing the tonel method selector line"

	| selector |
	selector := currentToken.
	^self methodNodeClass selectorParts: (Array with: selector) arguments: #()
%

category: 'private-parsing'
method: RBTonelParser
parseTonelVariableNode
	currentToken isIdentifier 
		ifFalse: [self parserError: 'Variable name expected'].
	^self parseTonelPrimitiveIdentifier
%

category: 'private-parsing'
method: RBTonelParser
peekTonelFor: characterType value: characterValue

	^ self scanner peekTonelFor: characterType value: characterValue
%

category: 'accessing'
method: RBTonelParser
scanner

	^scanner
%

category: 'accessing'
method: RBTonelParser
scannerClass
	^RBTonelScanner
%

category: 'testing'
method: RBTonelParser
tonelMethodBodyTerminationToken
	^ currentToken isSpecial and: [ currentToken value = $] ]
%

category: 'private'
method: RBTonelParser
tonelStep
	"only used when parsing the tonel method selector line"

	(currentToken notNil and: [currentToken comments notNil]) 
		ifTrue: [comments addAll: currentToken comments].
	nextToken notNil 
		ifTrue: 
			[currentToken := nextToken.
			nextToken := nil]
		ifFalse: [currentToken := scanner tonelNext]
%

! Class implementation for 'RBParseTreeRule'

!		Class methods for 'RBParseTreeRule'

category: 'instance creation'
classmethod: RBParseTreeRule
methodSearch: aString 
	^(self new)
		methodSearchString: aString;
		yourself
%

category: 'instance creation'
classmethod: RBParseTreeRule
new

	^self basicNew initialize
%

category: 'instance creation'
classmethod: RBParseTreeRule
search: aString 
	^(self new)
		searchString: aString;
		yourself
%

!		Instance methods for 'RBParseTreeRule'

category: 'matching'
method: RBParseTreeRule
canMatch: aProgramNode 
	^true
%

category: 'private'
method: RBParseTreeRule
context
	^owner context
%

category: 'matching'
method: RBParseTreeRule
foundMatchFor: aProgramNode
	^aProgramNode
%

category: 'initialize-release'
method: RBParseTreeRule
initialize
%

category: 'initialize-release'
method: RBParseTreeRule
methodSearchString: aString 
	searchTree := RBParser parseRewriteMethod: aString
%

category: 'initialize-release'
method: RBParseTreeRule
owner: aParseTreeSearcher
	owner := aParseTreeSearcher
%

category: 'matching'
method: RBParseTreeRule
performOn: aProgramNode 
	self context empty.
	^((searchTree match: aProgramNode inContext: self context) 
		and: [self canMatch: aProgramNode]) 
			ifTrue: 
				[owner recusivelySearchInContext.
				self foundMatchFor: aProgramNode]
			ifFalse: [nil]
%

category: 'initialize-release'
method: RBParseTreeRule
searchString: aString 
	searchTree := RBParser parseRewriteExpression: aString
%

category: 'accessing'
method: RBParseTreeRule
sentMessages
	^searchTree sentMessages
%

! Class implementation for 'RBReplaceRule'

!		Instance methods for 'RBReplaceRule'

category: 'matching'
method: RBReplaceRule
canMatch: aProgramNode 
	^verificationBlock value: aProgramNode
%

category: 'matching'
method: RBReplaceRule
foundMatchFor: aProgramNode 
	self subclassResponsibility
%

category: 'initialize-release'
method: RBReplaceRule
initialize
	super initialize.
	verificationBlock := [:aNode | true]
%

category: 'matching'
method: RBReplaceRule
replace: aProgramNode with: newNode 
	aProgramNode replaceMethodSource: newNode
%

! Class implementation for 'RBBlockReplaceRule'

!		Class methods for 'RBBlockReplaceRule'

category: 'instance creation'
classmethod: RBBlockReplaceRule
searchFor: searchString replaceWith: replaceBlock 
	^self new searchFor: searchString replaceWith: replaceBlock
%

category: 'instance creation'
classmethod: RBBlockReplaceRule
searchFor: searchString replaceWith: replaceBlock when: aBlock 
	^self new 
		searchFor: searchString
		replaceWith: replaceBlock
		when: aBlock
%

category: 'instance creation'
classmethod: RBBlockReplaceRule
searchForMethod: searchString replaceWith: replaceBlock 
	^self new searchForMethod: searchString replaceWith: replaceBlock
%

category: 'instance creation'
classmethod: RBBlockReplaceRule
searchForMethod: searchString replaceWith: replaceBlock when: aBlock 
	^self new 
		searchForMethod: searchString
		replaceWith: replaceBlock
		when: aBlock
%

category: 'instance creation'
classmethod: RBBlockReplaceRule
searchForTree: aRBProgramNode replaceWith: replaceBlock 
	^self new searchForTree: aRBProgramNode replaceWith: replaceBlock
%

category: 'instance creation'
classmethod: RBBlockReplaceRule
searchForTree: aRBProgramNode replaceWith: replaceBlock when: aBlock 
	^self new 
		searchForTree: aRBProgramNode
		replaceWith: replaceBlock
		when: aBlock
%

!		Instance methods for 'RBBlockReplaceRule'

category: 'matching'
method: RBBlockReplaceRule
foundMatchFor: aProgramNode 
	| newNode |
	newNode := replaceBlock value: aProgramNode.
	aProgramNode replaceMethodSource: newNode.
	^newNode
%

category: 'initialize-release'
method: RBBlockReplaceRule
initialize
	super initialize.
	replaceBlock := [:aNode | aNode]
%

category: 'initialize-release'
method: RBBlockReplaceRule
searchFor: searchString replaceWith: aBlock 
	self searchString: searchString.
	replaceBlock := aBlock
%

category: 'initialize-release'
method: RBBlockReplaceRule
searchFor: searchString replaceWith: replBlock when: verifyBlock 
	self searchFor: searchString replaceWith: replBlock.
	verificationBlock := verifyBlock
%

category: 'initialize-release'
method: RBBlockReplaceRule
searchForMethod: searchString replaceWith: aBlock 
	self methodSearchString: searchString.
	replaceBlock := aBlock
%

category: 'initialize-release'
method: RBBlockReplaceRule
searchForMethod: searchString replaceWith: replBlock when: verifyBlock 
	self searchForMethod: searchString replaceWith: replBlock.
	verificationBlock := verifyBlock
%

category: 'initialize-release'
method: RBBlockReplaceRule
searchForTree: aBRProgramNode replaceWith: aBlock 
	searchTree := aBRProgramNode.
	replaceBlock := aBlock
%

category: 'initialize-release'
method: RBBlockReplaceRule
searchForTree: aBRProgramNode replaceWith: replBlock when: verifyBlock 
	self searchForTree: aBRProgramNode replaceWith: replBlock.
	verificationBlock := verifyBlock
%

! Class implementation for 'RBStringReplaceRule'

!		Class methods for 'RBStringReplaceRule'

category: 'instance creation'
classmethod: RBStringReplaceRule
searchFor: searchString replaceWith: replaceString 
	^self new searchFor: searchString replaceWith: replaceString
%

category: 'instance creation'
classmethod: RBStringReplaceRule
searchFor: searchString replaceWith: replaceString when: aBlock 
	^self new 
		searchFor: searchString
		replaceWith: replaceString
		when: aBlock
%

category: 'instance creation'
classmethod: RBStringReplaceRule
searchForMethod: searchString replaceWith: replaceString 
	^(self new)
		searchForMethod: searchString replaceWith: replaceString;
		yourself
%

category: 'instance creation'
classmethod: RBStringReplaceRule
searchForMethod: searchString replaceWith: replaceString when: aBlock 
	^self new 
		searchForMethod: searchString
		replaceWith: replaceString
		when: aBlock
%

category: 'instance creation'
classmethod: RBStringReplaceRule
searchForTree: aRBProgramNode replaceWith: replaceString 
	^self new searchForTree: aRBProgramNode replaceWith: replaceString
%

category: 'instance creation'
classmethod: RBStringReplaceRule
searchForTree: aRBProgramNode replaceWith: replaceString when: aBlock 
	^self new 
		searchForTree: aRBProgramNode
		replaceWith: replaceString
		when: aBlock
%

!		Instance methods for 'RBStringReplaceRule'

category: 'matching'
method: RBStringReplaceRule
foundMatchFor: aProgramNode 
	| newNode |
	newNode := replaceTree copyInContext: self context.
	aProgramNode replaceMethodSource: newNode.
	newNode copyCommentsFrom: aProgramNode.
	^newNode
%

category: 'initialize-release'
method: RBStringReplaceRule
methodReplaceString: replaceString 
	replaceTree := RBParser parseRewriteMethod: replaceString
%

category: 'initialize-release'
method: RBStringReplaceRule
replaceString: replaceString 
	replaceTree := RBParser parseRewriteExpression: replaceString.
	searchTree isSequence = replaceTree isSequence 
		ifFalse: 
			[searchTree isSequence 
				ifTrue: [replaceTree := RBSequenceNode statements: (Array with: replaceTree)]
				ifFalse: [searchTree := RBSequenceNode statements: (Array with: searchTree)]]
%

category: 'initialize-release'
method: RBStringReplaceRule
searchFor: searchString replaceWith: replaceString 
	self searchString: searchString.
	self replaceString: replaceString
%

category: 'initialize-release'
method: RBStringReplaceRule
searchFor: searchString replaceWith: replaceString when: aBlock 
	self searchFor: searchString replaceWith: replaceString.
	verificationBlock := aBlock
%

category: 'initialize-release'
method: RBStringReplaceRule
searchForMethod: searchString replaceWith: replaceString 
	self methodSearchString: searchString.
	self methodReplaceString: replaceString
%

category: 'initialize-release'
method: RBStringReplaceRule
searchForMethod: searchString replaceWith: replaceString when: aBlock 
	self searchForMethod: searchString replaceWith: replaceString.
	verificationBlock := aBlock
%

category: 'initialize-release'
method: RBStringReplaceRule
searchForTree: aBRProgramNode replaceWith: replaceNode 
	searchTree := aBRProgramNode.
	replaceTree := replaceNode
%

category: 'initialize-release'
method: RBStringReplaceRule
searchForTree: aBRProgramNode replaceWith: replaceString when: aBlock 
	self searchForTree: aBRProgramNode replaceWith: replaceString.
	verificationBlock := aBlock
%

! Class implementation for 'RBSearchRule'

!		Class methods for 'RBSearchRule'

category: 'instance creation'
classmethod: RBSearchRule
searchFor: aString thenDo: aBlock 
	^self new searchFor: aString thenDo: aBlock
%

category: 'instance creation'
classmethod: RBSearchRule
searchForMethod: aString thenDo: aBlock 
	^self new searchForMethod: aString thenDo: aBlock
%

category: 'instance creation'
classmethod: RBSearchRule
searchForTree: aBRProgramNode thenDo: aBlock 
	^self new searchForTree: aBRProgramNode thenDo: aBlock
%

!		Instance methods for 'RBSearchRule'

category: 'testing'
method: RBSearchRule
canMatch: aProgramNode 
	owner answer: (answerBlock value: aProgramNode value: owner answer).
	^true
%

category: 'initialize-release'
method: RBSearchRule
searchFor: aString thenDo: aBlock 
	self searchString: aString.
	answerBlock := aBlock
%

category: 'initialize-release'
method: RBSearchRule
searchForMethod: aString thenDo: aBlock 
	self methodSearchString: aString.
	answerBlock := aBlock
%

category: 'initialize-release'
method: RBSearchRule
searchForTree: aBRProgramNode thenDo: aBlock 
	searchTree := aBRProgramNode.
	answerBlock := aBlock
%

! Class implementation for 'RBProgramNode'

!		Class methods for 'RBProgramNode'

category: 'accessing'
classmethod: RBProgramNode
formatterClass
  ^ FormatterClass isNil
    ifTrue: [ RBConfigurableFormatter ]
    ifFalse: [ ^ Rowan globalNamed: FormatterClass name ]
%

category: 'accessing'
classmethod: RBProgramNode
formatterClass: aClass 
	FormatterClass := aClass
%

category: 'instance creation'
classmethod: RBProgramNode
new

	^self basicNew initialize
%

category: 'accessing'
classmethod: RBProgramNode
optimizedSelectors
	^ #( and: caseOf: caseOf:otherwise: ifFalse: ifFalse:ifTrue: ifNil: ifNil:ifNotNil: ifNotNil: ifNotNil:ifNil: ifTrue: ifTrue:ifFalse: or: to:by:do: to:do: whileFalse whileFalse: whileTrue whileTrue: )
%

!		Instance methods for 'RBProgramNode'

category: 'visitor'
method: RBProgramNode
acceptVisitor: aProgramNodeVisitor 
	self subclassResponsibility
%

category: 'replacing'
method: RBProgramNode
addReplacement: aStringReplacement
	parent isNil ifTrue: [^self].
	parent addReplacement: aStringReplacement
%

category: 'accessing'
method: RBProgramNode
allArgumentVariables
	| children |
	children := self children.
	children isEmpty ifTrue: [^#()].
	^children inject: OrderedCollection new
		into: 
			[:vars :each | 
			vars
				addAll: each allArgumentVariables;
				yourself]
%

category: 'iterating'
method: RBProgramNode
allChildren
	| children |
	children := OrderedCollection new.
	self nodesDo: [ :each | children addLast: each ].
	^ children
%

category: 'accessing'
method: RBProgramNode
allDefinedVariables
	| children |
	children := self children.
	children isEmpty ifTrue: [^#()].
	^children inject: OrderedCollection new
		into: 
			[:vars :each | 
			vars
				addAll: each allDefinedVariables;
				yourself]
%

category: 'accessing'
method: RBProgramNode
allTemporaryVariables
	| children |
	children := self children.
	children isEmpty ifTrue: [^#()].
	^children inject: OrderedCollection new
		into: 
			[:vars :each | 
			vars
				addAll: each allTemporaryVariables;
				yourself]
%

category: 'accessing'
method: RBProgramNode
asReturn
	"Change the current node to a return node."

	parent isNil 
		ifTrue: [self error: 'Cannot change to a return without a parent node.'].
	parent isSequence 
		ifFalse: [self error: 'Parent node must be a sequence node.'].
	(parent isLast: self) ifFalse: [self error: 'Return node must be last.'].
	^parent addReturn
%

category: 'testing'
method: RBProgramNode
assigns: aVariableName 
	^self children anySatisfy: [:each | each assigns: aVariableName]
%

category: 'querying'
method: RBProgramNode
bestNodeFor: anInterval 
	| selectedChildren |
	(self intersectsInterval: anInterval) ifFalse: [^nil].
	(self containedBy: anInterval) ifTrue: [^self].
	selectedChildren := self children 
				select: [:each | each intersectsInterval: anInterval].
	^selectedChildren size == 1 
		ifTrue: [selectedChildren first bestNodeFor: anInterval]
		ifFalse: [self]
%

category: 'accessing'
method: RBProgramNode
blockVariables
	^parent isNil ifTrue: [#()] ifFalse: [parent blockVariables]
%

category: 'testing-matching'
method: RBProgramNode
canMatchMethod: aCompiledMethod 
	^self sentMessages allSatisfy: 
			[:each | 
			(self class optimizedSelectors includes: each) 
				or: [aCompiledMethod refersToLiteral: each]]
%

category: 'meta variable-accessing'
method: RBProgramNode
cascadeListCharacter
	^$;
%

category: 'accessing'
method: RBProgramNode
children
	^#()
%

category: 'replacing'
method: RBProgramNode
clearReplacements
	parent isNil ifTrue: [^self].
	parent clearReplacements
%

category: 'enumeration'
method: RBProgramNode
collect: aBlock 
	"Hacked to fit collection protocols"

	^aBlock value: self
%

category: 'accessing'
method: RBProgramNode
comments
	"Answer the comments of the receiving parse tree node as intervals of starting and ending indices."
	
	^ comments isNil ifTrue: [ #() ] ifFalse: [ comments ]
%

category: 'accessing'
method: RBProgramNode
comments: aCollection
	comments := aCollection
%

category: 'testing'
method: RBProgramNode
containedBy: anInterval 
	^anInterval first <= self start and: [anInterval last >= self stop]
%

category: 'testing'
method: RBProgramNode
containsReturn
	^self children anySatisfy: [:each | each containsReturn]
%

category: 'copying'
method: RBProgramNode
copyCommentsFrom: aNode 
	"Add all comments from aNode to us. If we already have the comment, then don't add it."

	| newComments |
	newComments := OrderedCollection new.
	aNode nodesDo: [:each | newComments addAll: each comments].
	self nodesDo: 
			[:each | 
			each comments do: [:comment | newComments remove: comment ifAbsent: []]].
	newComments isEmpty ifTrue: [^self].
	newComments := newComments asSortedCollection: [:a :b | a first < b first].
	self comments: newComments
%

category: 'matching'
method: RBProgramNode
copyInContext: aDictionary
	^ self copy
%

category: 'matching'
method: RBProgramNode
copyList: matchNodes inContext: aDictionary 
	| newNodes |
	newNodes := OrderedCollection new.
	matchNodes do: 
			[:each | 
			| object |
			object := each copyInContext: aDictionary.
			newNodes addAll: object].
	^newNodes
%

category: 'testing'
method: RBProgramNode
defines: aName
	^false
%

category: 'testing'
method: RBProgramNode
directlyUses: aNode
	^true
%

category: 'enumeration'
method: RBProgramNode
do: aBlock 
	"Hacked to fit collection protocols"

	aBlock value: self
%

category: 'comparing'
method: RBProgramNode
equalTo: aNode exceptForVariables: variableNameCollection 
	| dictionary |
	dictionary := Dictionary new.
	(self equalTo: aNode withMapping: dictionary) ifFalse: [^false].
	dictionary keysAndValuesDo: 
			[:key :value | 
			(key = value or: [variableNameCollection includes: key]) ifFalse: [^false]].
	^true
%

category: 'comparing'
method: RBProgramNode
equalTo: aNode withMapping: aDictionary 
	^self = aNode
%

category: 'testing'
method: RBProgramNode
evaluatedFirst: aNode 
	self children do: 
			[:each | 
			each == aNode ifTrue: [^true].
			each isImmediateNode ifFalse: [^false]].
	^false
%

category: 'accessing'
method: RBProgramNode
formattedCode
	^ self formatterClass new format: self
%

category: 'accessing'
method: RBProgramNode
formatterClass
	^ self class formatterClass
%

category: 'comparing'
method: RBProgramNode
hashForCollection: aCollection
	^ aCollection isEmpty ifTrue: [ 0 ] ifFalse: [ aCollection first hash ]
%

category: 'testing'
method: RBProgramNode
hasMultipleReturns
	| count |
	count := 0.
	self nodesDo: [:each | each isReturn ifTrue: [count := count + 1]].
	^count > 1
%

category: 'properties'
method: RBProgramNode
hasProperty: aKey
	"Test if the property aKey is present."
	
	^ properties notNil and: [ properties includesKey: aKey ]
%

category: 'initialize release'
method: RBProgramNode
initialize
%

category: 'testing'
method: RBProgramNode
intersectsInterval: anInterval 
	^(anInterval first between: self start and: self stop) 
		or: [self start between: anInterval first and: anInterval last]
%

category: 'testing'
method: RBProgramNode
isArray
	^ false
%

category: 'testing'
method: RBProgramNode
isAssignment
	^false
%

category: 'testing'
method: RBProgramNode
isBlock
	^false
%

category: 'testing'
method: RBProgramNode
isCascade
	^false
%

category: 'testing'
method: RBProgramNode
isDirectlyUsed
	"This node is directly used as an argument, receiver, or part of an assignment."

	^parent isNil ifTrue: [false] ifFalse: [parent directlyUses: self]
%

category: 'testing'
method: RBProgramNode
isEvaluatedFirst
	"Return true if we are the first thing evaluated in this statement."

	^parent isNil or: [parent isSequence or: [parent evaluatedFirst: self]]
%

category: 'deprecated'
method: RBProgramNode
isImmediate
	^self isImmediateNode
%

category: 'testing'
method: RBProgramNode
isImmediateNode
	^false
%

category: 'testing'
method: RBProgramNode
isLast: aNode 
	| children |
	children := self children.
	^children notEmpty and: [children last == aNode]
%

category: 'testing-matching'
method: RBProgramNode
isList
	^false
%

category: 'deprecated'
method: RBProgramNode
isLiteral
	^self isLiteralNode
%

category: 'testing'
method: RBProgramNode
isLiteralArray
	^false
%

category: 'testing'
method: RBProgramNode
isLiteralNode
	^false
%

category: 'testing'
method: RBProgramNode
isMessage
	^false
%

category: 'testing'
method: RBProgramNode
isMethod
	^false
%

category: 'testing-matching'
method: RBProgramNode
isPatternNode
	^false
%

category: 'testing'
method: RBProgramNode
isPragma
	^false
%

category: 'testing'
method: RBProgramNode
isReturn
	^false
%

category: 'testing'
method: RBProgramNode
isSequence
	^false
%

category: 'testing'
method: RBProgramNode
isUsed
	"Answer true if this node could be used as part of another expression. For example, you could use the 
	result of this node as a receiver of a message, an argument, the right part of an assignment, or the 
	return value of a block. This differs from isDirectlyUsed in that it is conservative since it also includes 
	return values of blocks."

	^parent isNil ifTrue: [false] ifFalse: [parent uses: self]
%

category: 'testing'
method: RBProgramNode
isValue
	^false
%

category: 'testing'
method: RBProgramNode
isVariable
	^false
%

category: 'testing'
method: RBProgramNode
isWorkspace
	^ false
%

category: 'testing'
method: RBProgramNode
lastIsReturn
	^self isReturn
%

category: 'meta variable-accessing'
method: RBProgramNode
listCharacter
	^$@
%

category: 'meta variable-accessing'
method: RBProgramNode
literalCharacter
	^$#
%

category: 'accessing'
method: RBProgramNode
mappingFor: aNode
	| method |
	method := self methodNode.
	method isNil ifTrue: [^aNode].
	^method mappingFor: aNode
%

category: 'matching'
method: RBProgramNode
match: aNode inContext: aDictionary 
	^ self = aNode
%

category: 'matching'
method: RBProgramNode
matchList: matchNodes against: programNodes inContext: aDictionary 
	^self
		matchList: matchNodes
		index: 1
		against: programNodes
		index: 1
		inContext: aDictionary
%

category: 'matching'
method: RBProgramNode
matchList: matchNodes index: matchIndex against: programNodes index: programIndex inContext: aDictionary 
	| node currentIndex currentDictionary nodes |
	matchNodes size < matchIndex ifTrue: [^programNodes size < programIndex].
	node := matchNodes at: matchIndex.
	node isList 
		ifTrue: 
			[currentIndex := programIndex - 1.
			
			[currentDictionary := aDictionary copy.
			programNodes size < currentIndex or: 
					[nodes := programNodes copyFrom: programIndex to: currentIndex.
					(currentDictionary at: node ifAbsentPut: [nodes]) = nodes and: 
							[(self 
								matchList: matchNodes
								index: matchIndex + 1
								against: programNodes
								index: currentIndex + 1
								inContext: currentDictionary) 
									ifTrue: 
										[currentDictionary 
											keysAndValuesDo: [:key :value | aDictionary at: key put: value].
										^true].
							false]]] 
					whileFalse: [currentIndex := currentIndex + 1].
			^false].
	programNodes size < programIndex ifTrue: [^false].
	(node match: (programNodes at: programIndex) inContext: aDictionary) 
		ifFalse: [^false].
	^self 
		matchList: matchNodes
		index: matchIndex + 1
		against: programNodes
		index: programIndex + 1
		inContext: aDictionary
%

category: 'accessing'
method: RBProgramNode
methodComments
	^self comments
%

category: 'accessing'
method: RBProgramNode
methodNode
	^parent isNil ifTrue: [nil] ifFalse: [parent methodNode]
%

category: 'accessing'
method: RBProgramNode
newSource
	^self formattedCode
%

category: 'iterating'
method: RBProgramNode
nodesDo: aBlock 
	aBlock value: self.
	self children do: [ :each | each nodesDo: aBlock ]
%

category: 'accessing'
method: RBProgramNode
parent
	^parent
%

category: 'accessing'
method: RBProgramNode
parent: aRBProgramNode 
	parent := aRBProgramNode
%

category: 'accessing'
method: RBProgramNode
parents
	^ parent isNil
		ifTrue: [ OrderedCollection with: self ]
		ifFalse: [ 
			parent parents
				addLast: self;
				yourself ]
%

category: 'copying'
method: RBProgramNode
postCopy
	super postCopy.
	properties := properties copy
%

category: 'accessing'
method: RBProgramNode
precedence
	^6
%

category: 'printing'
method: RBProgramNode
printOn: aStream 
	aStream
		nextPutAll: self class name;
		nextPut: $(;
		nextPutAll: self formattedCode;
		nextPut: $)
%

category: 'properties'
method: RBProgramNode
propertyAt: aKey
	"Answer the property value associated with aKey."
	
	^ self propertyAt: aKey ifAbsent: [ self error: 'Property not found' ]
%

category: 'properties'
method: RBProgramNode
propertyAt: aKey ifAbsent: aBlock
	"Answer the property value associated with aKey or, if aKey isn't found, answer the result of evaluating aBlock."
	
	^ properties isNil
		ifTrue: [ aBlock value ]
		ifFalse: [ properties at: aKey ifAbsent: aBlock ]
%

category: 'properties'
method: RBProgramNode
propertyAt: aKey ifAbsentPut: aBlock
	"Answer the property associated with aKey or, if aKey isn't found store the result of evaluating aBlock as new value."
	
	^ self propertyAt: aKey ifAbsent: [ self propertyAt: aKey put: aBlock value ]
%

category: 'properties'
method: RBProgramNode
propertyAt: aKey put: anObject
	"Set the property at aKey to be anObject. If aKey is not found, create a new entry for aKey and set is value to anObject. Answer anObject."

	^ (properties ifNil: [ properties := RBSmallDictionary new: 1 ])
		at: aKey put: anObject
%

category: 'testing-matching'
method: RBProgramNode
recurseInto
	^false
%

category: 'meta variable-accessing'
method: RBProgramNode
recurseIntoCharacter
	^$`
%

category: 'testing'
method: RBProgramNode
references: aVariableName 
	^self children anySatisfy: [:each | each references: aVariableName]
%

category: 'replacing'
method: RBProgramNode
removeDeadCode
	self children do: [:each | each removeDeadCode]
%

category: 'properties'
method: RBProgramNode
removeProperty: aKey
	"Remove the property with aKey. Answer the property or raise an error if aKey isn't found."
	
	^ self removeProperty: aKey ifAbsent: [ self error: 'Property not found' ].
%

category: 'properties'
method: RBProgramNode
removeProperty: aKey ifAbsent: aBlock
	"Remove the property with aKey. Answer the value or, if aKey isn't found, answer the result of evaluating aBlock."
	
	| answer |
	properties isNil ifTrue: [ ^ aBlock value ].
	answer := properties removeKey: aKey ifAbsent: aBlock.
	properties isEmpty ifTrue: [ properties := nil ].
	^ answer
%

category: 'replacing'
method: RBProgramNode
replaceMethodSource: aNode 
	"We are being replaced with aNode -- if possible try to perform an in place edit of the source."

	| method |
	method := self methodNode.
	method notNil ifTrue: [method map: self to: aNode].
	aNode parent: self parent.
	[self replaceSourceWith: aNode] on: Error
		do: 
			[:ex | 
			self clearReplacements.
			ex return]
%

category: 'replacing'
method: RBProgramNode
replaceNode: aNode withNode: anotherNode 
	self error: 'I don''t store other nodes'
%

category: 'private-replacing'
method: RBProgramNode
replaceSourceFrom: aNode
	self == aNode
		ifFalse: [ self clearReplacements ]
%

category: 'private-replacing'
method: RBProgramNode
replaceSourceWith: aNode 
	aNode replaceSourceFrom: self
%

category: 'replacing'
method: RBProgramNode
replaceWith: aNode 
	parent isNil ifTrue: [self error: 'This node doesn''t have a parent'].
	self replaceMethodSource: aNode.
	parent replaceNode: self withNode: aNode
%

category: 'querying'
method: RBProgramNode
selfMessages
	| searcher |
	searcher := RBParseTreeSearcher new.
	searcher matches: 'self `@msg: ``@args'
		do: 
			[:aNode :answer | 
			answer
				add: aNode selector;
				yourself].
	^searcher executeTree: self initialAnswer: Set new
%

category: 'accessing'
method: RBProgramNode
sentMessages
	^ self children
		inject: Set new
		into: [ :messages :each | 
			messages
				addAll: each sentMessages;
				yourself ]
%

category: 'enumeration'
method: RBProgramNode
size
	"Hacked to fit collection protocols"

	^1
%

category: 'accessing'
method: RBProgramNode
source
	^parent notNil ifTrue: [parent source] ifFalse: [nil]
%

category: 'accessing'
method: RBProgramNode
sourceInterval
	^self start to: self stop
%

category: 'accessing'
method: RBProgramNode
start
	self subclassResponsibility
%

category: 'meta variable-accessing'
method: RBProgramNode
statementCharacter
	^$.
%

category: 'accessing'
method: RBProgramNode
statementComments
	| statementComments |
	statementComments := OrderedCollection withAll: self comments.
	self children do: [:each | statementComments addAll: each statementComments].
	^statementComments asSortedCollection: [:a :b | a first < b first]
%

category: 'querying'
method: RBProgramNode
statementNode
	"Return your topmost node that is contained by a sequence node."

	(parent isNil or: [parent isSequence]) ifTrue: [^self].
	^parent statementNode
%

category: 'accessing'
method: RBProgramNode
stop
	self subclassResponsibility
%

category: 'querying'
method: RBProgramNode
superMessages
	| searcher |
	searcher := RBParseTreeSearcher new.
	searcher matches: 'super `@msg: ``@args'
		do: 
			[:aNode :answer | 
			answer
				add: aNode selector;
				yourself].
	^searcher executeTree: self initialAnswer: Set new
%

category: 'accessing'
method: RBProgramNode
temporaryVariables
	^parent isNil ifTrue: [#()] ifFalse: [parent temporaryVariables]
%

category: 'testing'
method: RBProgramNode
uses: aNode
	^true
%

category: 'querying'
method: RBProgramNode
whichNodeIsContainedBy: anInterval 
	| selectedChildren |
	(self intersectsInterval: anInterval) ifFalse: [^nil].
	(self containedBy: anInterval) ifTrue: [^self].
	selectedChildren := self children 
				select: [:each | each intersectsInterval: anInterval].
	^selectedChildren size == 1 
		ifTrue: [selectedChildren first whichNodeIsContainedBy: anInterval]
		ifFalse: [nil]
%

category: 'querying'
method: RBProgramNode
whoDefines: aName 
	^(self defines: aName) 
		ifTrue: [self]
		ifFalse: [parent notNil ifTrue: [parent whoDefines: aName] ifFalse: [nil]]
%

! Class implementation for 'RBMethodNode'

!		Class methods for 'RBMethodNode'

category: 'instance creation'
classmethod: RBMethodNode
selector: aSymbol arguments: variableNodes body: aSequenceNode 
	^(self new)
		arguments: variableNodes;
		selector: aSymbol;
		body: aSequenceNode;
		yourself
%

category: 'instance creation'
classmethod: RBMethodNode
selector: aSymbol body: aSequenceNode 
	^self 
		selector: aSymbol
		arguments: #()
		body: aSequenceNode
%

category: 'instance creation'
classmethod: RBMethodNode
selectorParts: tokenCollection arguments: variableNodes 
	^(self new)
		selectorParts: tokenCollection arguments: variableNodes;
		yourself
%

!		Instance methods for 'RBMethodNode'

category: 'comparing'
method: RBMethodNode
= anObject 
	self == anObject ifTrue: [ ^ true ].
	self class = anObject class ifFalse: [ ^ false ].
	(self selector = anObject selector
		and: [ self pragmas size = anObject pragmas size
		and: [ self body = anObject body ] ])
			ifFalse: [ ^ false ].
	self arguments with: anObject arguments do: [ :first :second |
		first = second 
			ifFalse: [ ^ false ] ].
	self pragmas with: anObject pragmas do: [ :first :second |
		first = second 
			ifFalse: [ ^ false ] ].
	^ true
%

category: 'visitor'
method: RBMethodNode
acceptVisitor: aProgramNodeVisitor 
	^aProgramNodeVisitor acceptMethodNode: self
%

category: 'accessing'
method: RBMethodNode
addNode: aNode
	^ body addNode: aNode
%

category: 'replacing'
method: RBMethodNode
addReplacement: aStringReplacement 
	replacements isNil ifTrue: [^self].
	replacements add: aStringReplacement
%

category: 'accessing'
method: RBMethodNode
addReturn
	^ body addReturn
%

category: 'accessing'
method: RBMethodNode
addSelfReturn
	^ body addSelfReturn
%

category: 'accessing'
method: RBMethodNode
allArgumentVariables
	^(self argumentNames asOrderedCollection)
		addAll: super allArgumentVariables;
		yourself
%

category: 'accessing'
method: RBMethodNode
allDefinedVariables
	^(self argumentNames asOrderedCollection)
		addAll: super allDefinedVariables;
		yourself
%

category: 'accessing'
method: RBMethodNode
argumentNames
	^self arguments collect: [:each | each name]
%

category: 'accessing'
method: RBMethodNode
arguments
	^arguments
%

category: 'accessing'
method: RBMethodNode
arguments: variableNodes 
	arguments := variableNodes.
	arguments do: [:each | each parent: self]
%

category: 'accessing'
method: RBMethodNode
body
	^body
%

category: 'accessing'
method: RBMethodNode
body: stmtsNode 
	body := stmtsNode.
	body parent: self
%

category: 'private'
method: RBMethodNode
buildSelector
	| selectorStream |
	selectorStream := WriteStreamPortable on: String new.
	selectorParts do: [:each | selectorStream nextPutAll: each value].
	^selectorStream contents asSymbol
%

category: 'private-replacing'
method: RBMethodNode
changeSourceSelectors: oldSelectorParts arguments: oldArguments
	"If this is the same number of arguments, we try a one to one replacement of selector parts and arguments. If this is not the case try to rewrite the signature as a whole, what unfortunately drops the comments within the signature."
	
	[ (oldSelectorParts size = selectorParts size and: [ oldArguments size = arguments size ])
		ifTrue: [
			oldSelectorParts with: selectorParts do: [ :old :new | 
				self addReplacement: (RBStringReplacement 
					replaceFrom: old start
					to: old stop
					with: new value) ].
			oldArguments with: arguments do: [ :old :new | 
				self addReplacement: (RBStringReplacement 
					replaceFrom: old start
					to: old stop
					with: new name) ] ]
		ifFalse: [
			self addReplacement: (RBStringReplacement
				replaceFrom: oldSelectorParts first start
				to: (oldArguments notEmpty
					ifTrue: [ oldArguments last stop ]
					ifFalse: [ oldSelectorParts last stop ])
				with: (String streamContents: [ :stream |
					selectorParts keysAndValuesDo: [ :index :part |
						index = 1 ifFalse: [ stream space ].
						stream nextPutAll: part value.
						index <= arguments size
							ifTrue: [ stream space; nextPutAll: (arguments at: index) name ] ] ])) ] ]
		on: Error
		do: [ :ex | ex return ]
%

category: 'accessing'
method: RBMethodNode
children
	^ OrderedCollection new
		addAll: self arguments;
		addAll: self pragmas;
		add: self body;
		yourself
%

category: 'replacing'
method: RBMethodNode
clearReplacements
	replacements := nil
%

category: 'matching'
method: RBMethodNode
copyInContext: aDictionary
	^ self class new
		selectorParts: (self selectorParts collect: [ :each | each copy removePositions ]);
		arguments: (self arguments collect: [ :each | each copyInContext: aDictionary ]);
		pragmas: (self pragmas isEmpty
			ifTrue: [ aDictionary at: '-pragmas-' ifAbsent: [ #() ] ]
			ifFalse: [ self copyList: self pragmas inContext: aDictionary ]);
		body: (self body copyInContext: aDictionary);
		source: (aDictionary at: '-source-' ifAbsentPut: [ self source ]);
		yourself
%

category: 'testing'
method: RBMethodNode
defines: aName 
	^arguments anySatisfy: [:each | each name = aName]
%

category: 'comparing'
method: RBMethodNode
equalTo: anObject withMapping: aDictionary 
	self class = anObject class ifFalse: [ ^ false ].
	(self selector = anObject selector
		and: [ self pragmas size = anObject pragmas size
		and: [ self body equalTo: anObject body withMapping: aDictionary ] ]) 
			ifFalse: [ ^ false ].
	self arguments with: anObject arguments do: [ :first :second |
		(first equalTo: second	withMapping: aDictionary)
			ifFalse: [ ^ false ].
		aDictionary removeKey: first name ].
	self pragmas with: anObject pragmas do: [ :first :second |
		(first equalTo: second	withMapping: aDictionary) 
			ifFalse: [ ^ false ] ].
	^ true
%

category: 'comparing'
method: RBMethodNode
hash
	^ ((self selector hash bitXor: (self hashForCollection: self arguments)) bitXor: (self hashForCollection: self pragmas)) bitXor: self body hash
%

category: 'initialize-release'
method: RBMethodNode
initialize
	replacements := SortedCollection sortBlock: 
					[:a :b | 
					a startPosition < b startPosition 
						or: [a startPosition = b startPosition and: [a stopPosition < b stopPosition]]].
	nodeReplacements := IdentityDictionary new
%

category: 'testing'
method: RBMethodNode
isLast: aNode 
	^body isLast: aNode
%

category: 'testing'
method: RBMethodNode
isMethod
	^true
%

category: 'testing'
method: RBMethodNode
isPrimitive
	^ self pragmas anySatisfy: [ :each | each isPrimitive ]
%

category: 'testing'
method: RBMethodNode
lastIsReturn
	^body lastIsReturn
%

category: 'replacing'
method: RBMethodNode
map: oldNode to: newNode 
	nodeReplacements at: oldNode put: newNode
%

category: 'replacing'
method: RBMethodNode
mappingFor: oldNode 
	^nodeReplacements at: oldNode ifAbsent: [oldNode]
%

category: 'matching'
method: RBMethodNode
match: aNode inContext: aDictionary 
	self class = aNode class ifFalse: [ ^ false ].
	aDictionary at: '-source-' put: aNode source.
	self selector = aNode selector ifFalse: [ ^ false ].
	^ (self matchList: arguments against: aNode arguments inContext: aDictionary)
		and: [ (self matchPragmas: self pragmas against: aNode pragmas inContext: aDictionary)
		and: [ body match: aNode body inContext: aDictionary ] ]
%

category: 'matching'
method: RBMethodNode
matchPragmas: matchNodes against: pragmaNodes inContext: aDictionary
	matchNodes isEmpty ifTrue: [ 
		aDictionary at: '-pragmas-' put: pragmaNodes.
		^ true ].
	^ matchNodes allSatisfy: [ :matchNode |
		pragmaNodes anySatisfy: [ :pragmaNode |
			matchNode match: pragmaNode inContext: aDictionary ] ]
%

category: 'accessing'
method: RBMethodNode
methodComments
	| methodComments |
	methodComments := OrderedCollection withAll: self comments.
	arguments do: [:each | methodComments addAll: each comments].
	^methodComments asSortedCollection: [:a :b | a first < b first]
%

category: 'accessing'
method: RBMethodNode
methodNode
	^self
%

category: 'accessing'
method: RBMethodNode
newSource
	replacements isNil ifTrue: [^self formattedCode].
	^[self reformatSource] on: Error do: [:ex | ex return: self formattedCode]
%

category: 'accessing'
method: RBMethodNode
numArgs
	^self selector numArgs
%

category: 'copying'
method: RBMethodNode
postCopy
	super postCopy.
	self arguments: (self arguments collect: [ :each | each copy ]).
	self pragmas: (self pragmas collect: [ :each | each copy ]).
	self body: self body copy
%

category: 'accessing'
method: RBMethodNode
pragmas
	^ pragmas ifNil: [ #() ]
%

category: 'accessing'
method: RBMethodNode
pragmas: aCollection
	pragmas := aCollection.
	pragmas do: [ :each | each parent: self ]
%

category: 'accessing'
method: RBMethodNode
primitiveSources
	^ self pragmas collect: [ :each | self source copyFrom: each first to: each last ]
%

category: 'printing'
method: RBMethodNode
printOn: aStream 
	aStream nextPutAll: self formattedCode
%

category: 'testing'
method: RBMethodNode
references: aVariableName 
	^body references: aVariableName
%

category: 'private'
method: RBMethodNode
reformatSource
	| stream newSource newTree |
	stream := WriteStreamPortable on: String new.
	stream
		nextPutAll: (source
			copyFrom: (replacements
				inject: 1
				into: [ :sum :each | 
					stream
						nextPutAll: (source copyFrom: sum to: each startPosition - 1);
						nextPutAll: (each string).
					each stopPosition + 1 ])
			to: source size).
	newSource := stream contents.
	newTree := RBParser 
		parseMethod: newSource 
		onError: [ :msg :pos | ^ self formattedCode ].
	self = newTree
		ifFalse: [ ^ self formattedCode ].
	^ newSource
%

category: 'accessing'
method: RBMethodNode
renameSelector: newSelector andArguments: varNodeCollection 
	| oldSelectorParts oldArguments |
	oldSelectorParts := selectorParts.
	oldArguments := arguments.
	self
		arguments: varNodeCollection;
		selector: newSelector.
	self changeSourceSelectors: oldSelectorParts arguments: oldArguments
%

category: 'replacing'
method: RBMethodNode
replaceNode: aNode withNode: anotherNode 
	aNode == body ifTrue: [self body: anotherNode].
	self arguments: (arguments 
				collect: [:each | each == aNode ifTrue: [anotherNode] ifFalse: [each]])
%

category: 'accessing'
method: RBMethodNode
selector
	^selector isNil
		ifTrue: [selector := self buildSelector]
		ifFalse: [selector]
%

category: 'accessing'
method: RBMethodNode
selector: aSelector 
	| keywords numArgs |
	keywords := aSelector keywords.
	numArgs := aSelector numArgs.
	numArgs == arguments size 
		ifFalse: 
			[self 
				error: 'Attempting to assign selector with wrong number of arguments.'].
	selectorParts := numArgs == 0 
				ifTrue: [Array with: (RBIdentifierToken value: keywords first start: nil)]
				ifFalse: 
					[keywords first last = $: 
						ifTrue: [keywords collect: [:each | RBKeywordToken value: each start: nil]]
						ifFalse: [Array with: (RBBinarySelectorToken value: aSelector start: nil)]].
	selector := aSelector asSymbol
%

category: 'private'
method: RBMethodNode
selectorParts
	^selectorParts
%

category: 'private'
method: RBMethodNode
selectorParts: tokenCollection 
	selectorParts := tokenCollection
%

category: 'initialize-release'
method: RBMethodNode
selectorParts: tokenCollection arguments: variableNodes 
	selectorParts := tokenCollection.
	self arguments: variableNodes
%

category: 'accessing'
method: RBMethodNode
source
	^source
%

category: 'accessing'
method: RBMethodNode
source: anObject
	source := anObject
%

category: 'accessing'
method: RBMethodNode
start
	^1
%

category: 'accessing'
method: RBMethodNode
stop
	^source size
%

category: 'testing'
method: RBMethodNode
uses: aNode 
	^body == aNode and: [aNode lastIsReturn]
%

! Class implementation for 'RBPatternMethodNode'

!		Class methods for 'RBPatternMethodNode'

category: 'instance creation'
classmethod: RBPatternMethodNode
selectorParts: tokenCollection arguments: variableNodes 
	^(tokenCollection anySatisfy: [:each | each isPatternVariable]) 
		ifTrue: [super selectorParts: tokenCollection arguments: variableNodes]
		ifFalse: 
			[RBMethodNode selectorParts: tokenCollection arguments: variableNodes]
%

!		Instance methods for 'RBPatternMethodNode'

category: 'matching'
method: RBPatternMethodNode
copyInContext: aDictionary 
	| selectors |
	selectors := self isSelectorList 
		ifTrue: [ (aDictionary at: selectorParts first value) keywords ]
		ifFalse: [ self selectorParts collect: [ :each | aDictionary at: each value ] ].
	^ RBMethodNode new
		selectorParts: (selectors collect: [ :each | 
			(each last = $: ifTrue: [ RBKeywordToken ] ifFalse: [ RBIdentifierToken ]) 
				value: each start: nil ]);
		arguments: (self copyList: self arguments inContext: aDictionary);
		pragmas: (self pragmas isEmpty
			ifTrue: [ aDictionary at: '-pragmas-' ifAbsent: [ #() ] ]
			ifFalse: [ self copyList: self pragmas inContext: aDictionary ]);
		body: (self body copyInContext: aDictionary);
		source: (aDictionary at: '-source-');
		yourself
%

category: 'testing-matching'
method: RBPatternMethodNode
isPatternNode
	^true
%

category: 'testing'
method: RBPatternMethodNode
isSelectorList
	^isList
%

category: 'matching'
method: RBPatternMethodNode
match: aNode inContext: aDictionary 
	aNode class = self matchingClass 
		ifFalse: [ ^ false ].
	aDictionary at: '-source-' put: aNode source.
	self isSelectorList ifTrue: [
		^ (aDictionary at: selectorParts first value ifAbsentPut: [ aNode selector ]) = aNode selector
			and: [ (aDictionary at: arguments first ifAbsentPut: [ aNode arguments ]) = aNode arguments
			and: [ (self matchPragmas: self pragmas against: aNode pragmas inContext: aDictionary)
			and: [ body match: aNode body inContext: aDictionary ] ] ] ].
	^(self matchArgumentsAgainst: aNode inContext: aDictionary) 
		and: [ (self matchPragmas: self pragmas against: aNode pragmas inContext: aDictionary)
		and: [ body match: aNode body inContext: aDictionary ] ]
%

category: 'matching'
method: RBPatternMethodNode
matchArgumentsAgainst: aNode inContext: aDictionary 
	self arguments size = aNode arguments size
		ifFalse: [ ^ false ].
	(self matchSelectorAgainst: aNode inContext: aDictionary) 
		ifFalse: [ ^ false ].
	self arguments with: aNode arguments do: [ :first :second |
		(first match: second inContext: aDictionary) 
			ifFalse: [ ^ false ] ].
	^ true
%

category: 'private'
method: RBPatternMethodNode
matchingClass
	^RBMethodNode
%

category: 'matching'
method: RBPatternMethodNode
matchSelectorAgainst: aNode inContext: aDictionary 
	self selectorParts with: aNode selectorParts do: [ :first :second |
		| keyword |
		keyword := aDictionary
			at: first value
			ifAbsentPut: [ 
				first isPatternVariable 
					ifTrue: [ second value ]
					ifFalse: [ first value ] ].
		keyword = second value 
			ifFalse: [ ^ false ] ].
	^ true
%

category: 'initialize-release'
method: RBPatternMethodNode
selectorParts: tokenCollection arguments: variableNodes 
	super selectorParts: tokenCollection arguments: variableNodes.
	isList := (tokenCollection first value at: 2) == self listCharacter
%

! Class implementation for 'RBPragmaNode'

!		Class methods for 'RBPragmaNode'

category: 'instance creation'
classmethod: RBPragmaNode
selectorParts: keywordTokens arguments: valueNodes 
	^ self new selectorParts: keywordTokens arguments: valueNodes
%

!		Instance methods for 'RBPragmaNode'

category: 'comparing'
method: RBPragmaNode
= anObject
  self == anObject
    ifTrue: [ ^ true ].
  self class = anObject class
    ifFalse: [ ^ false ].
  self selector = anObject selector
    ifFalse: [ ^ false ].
  1 to: self arguments size do: [ :i | 
    (self arguments at: i) = (anObject arguments at: i)
      ifFalse: [ ^ false ] ].
  self isProtected == anObject isProtected
    ifFalse: [ ^ false ].
  ^ true
%

category: 'visitor'
method: RBPragmaNode
acceptVisitor: aProgramNodeVisitor 
	^ aProgramNodeVisitor acceptPragmaNode: self
%

category: 'accessing'
method: RBPragmaNode
arguments
	^ arguments ifNil: [ #() ]
%

category: 'accessing'
method: RBPragmaNode
arguments: aLiteralCollection 
	arguments := aLiteralCollection.
	arguments do: [ :each | each parent: self ]
%

category: 'private'
method: RBPragmaNode
buildSelector
	| selectorStream |
	selectorStream := WriteStreamPortable on: String new.
	selectorParts do: [ :each | selectorStream nextPutAll: each value ].
	^ selectorStream contents asSymbol
%

category: 'accessing'
method: RBPragmaNode
children
	^ self arguments
%

category: 'matching'
method: RBPragmaNode
copyInContext: aDictionary 
	^ self class new
		selectorParts: (self selectorParts collect: [ :each | each copy removePositions ]);
		arguments: (self arguments collect: [ :each | each copyInContext: aDictionary ]);
		yourself
%

category: 'comparing'
method: RBPragmaNode
equalTo: anObject withMapping: aDictionary 
	self class = anObject class ifFalse: [ ^ false ].
	self selector = anObject selector ifFalse: [ ^ false ].
	self arguments with: anObject arguments do: [ :first :second |
		(first equalTo: second withMapping: aDictionary) 
			ifFalse: [ ^ false ] ].
	^ true
%

category: 'comparing'
method: RBPragmaNode
hash
	^ self selector hash bitXor: (self hashForCollection: self arguments)
%

category: 'testing'
method: RBPragmaNode
isBinary
	^ (self isUnary or: [self isKeyword]) not
%

category: 'testing'
method: RBPragmaNode
isKeyword
	^ selectorParts first value last = $:
%

category: 'testing'
method: RBPragmaNode
isPragma
	^ true
%

category: 'testing'
method: RBPragmaNode
isPrimitive
	^ #(primitive: primitive:error: primitive:error:module: primitive:module: primitive:module:error:) includes: self selector
%

category: 'testing'
method: RBPragmaNode
isProtected
  isProtected ifNil: [ ^ false ].
  ^ isProtected
%

category: 'testing'
method: RBPragmaNode
isProtected: aBool
  isProtected := aBool
%

category: 'testing'
method: RBPragmaNode
isProtectedPrimitive
  ^ self isProtected and: [ self isPrimitive ]
%

category: 'testing'
method: RBPragmaNode
isUnary
	^ arguments isEmpty
%

category: 'accessing-token'
method: RBPragmaNode
left
	^ left
%

category: 'accessing-token'
method: RBPragmaNode
left: anInteger
	left := anInteger
%

category: 'matching'
method: RBPragmaNode
match: aNode inContext: aDictionary 
	aNode class = self class
		ifFalse: [ ^ false ].
	self selector = aNode selector
		ifFalse: [ ^ false ].
	self arguments with: aNode arguments do: [ :first :second |
		(first match: second inContext: aDictionary)
			ifFalse: [ ^ false ] ].
	^ true
%

category: 'accessing'
method: RBPragmaNode
numArgs
	^ self selector numArgs
%

category: 'copying'
method: RBPragmaNode
postCopy
	super postCopy.
	self arguments: (self arguments collect: [ :each | each copy ])
%

category: 'replacing'
method: RBPragmaNode
replaceNode: aNode withNode: anotherNode 
	self arguments: (arguments collect: [ :each | 
		each == aNode 
			ifTrue: [ anotherNode ]
			ifFalse: [ each ] ])
%

category: 'accessing-token'
method: RBPragmaNode
right
	^ right
%

category: 'accessing-token'
method: RBPragmaNode
right: anInteger
	right := anInteger
%

category: 'accessing'
method: RBPragmaNode
selector
	^ selector ifNil: [ selector := self buildSelector ]
%

category: 'accessing'
method: RBPragmaNode
selector: aSelector 
	| keywords numArgs |
	keywords := aSelector keywords.
	numArgs := aSelector numArgs.
	numArgs == arguments size 
		ifFalse: 
			[self 
				error: 'Attempting to assign selector with wrong number of arguments.'].
	selectorParts := numArgs == 0 
				ifTrue: [Array with: (RBIdentifierToken value: keywords first start: nil)]
				ifFalse: 
					[keywords first last = $: 
						ifTrue: [keywords collect: [:each | RBKeywordToken value: each start: nil]]
						ifFalse: [Array with: (RBBinarySelectorToken value: aSelector start: nil)]].
	selector := aSelector asSymbol
%

category: 'private'
method: RBPragmaNode
selectorParts
	^ selectorParts
%

category: 'private'
method: RBPragmaNode
selectorParts: tokenCollection 
	selectorParts := tokenCollection
%

category: 'initialization'
method: RBPragmaNode
selectorParts: keywordTokens arguments: valueNodes 
	self selectorParts: keywordTokens.
	self arguments: valueNodes
%

category: 'accessing'
method: RBPragmaNode
sentMessages
	^ super sentMessages
		add: self selector;
		yourself
%

category: 'accessing'
method: RBPragmaNode
start
	^ left
%

category: 'accessing'
method: RBPragmaNode
stop
	^ right
%

! Class implementation for 'RBPatternPragmaNode'

!		Class methods for 'RBPatternPragmaNode'

category: 'instance creation'
classmethod: RBPatternPragmaNode
selectorParts: keywordTokens arguments: valueNodes 
	^ (keywordTokens anySatisfy: [ :each | each isPatternVariable ]) 
		ifTrue: [ super selectorParts: keywordTokens arguments: valueNodes ]
		ifFalse: [ RBPragmaNode selectorParts: keywordTokens arguments: valueNodes ]
%

!		Instance methods for 'RBPatternPragmaNode'

category: 'matching'
method: RBPatternPragmaNode
copyInContext: aDictionary 
	| selectors |
	selectors := self isSelectorList 
		ifTrue: [ (aDictionary at: selectorParts first value) keywords ]
		ifFalse: [ self selectorParts collect: [ :each | aDictionary at: each value ] ].
	^ RBPragmaNode new
		selectorParts: (selectors collect: [ :each | 
			(each last = $: ifTrue: [ RBKeywordToken ] ifFalse: [ RBIdentifierToken ]) 
				value: each start: nil ]);
		arguments: (self copyList: self arguments inContext: aDictionary);
		yourself
%

category: 'testing-matching'
method: RBPatternPragmaNode
isPatternNode
	^ true
%

category: 'testing-matching'
method: RBPatternPragmaNode
isSelectorList
	^ isList
%

category: 'matching'
method: RBPatternPragmaNode
match: aNode inContext: aDictionary
	aNode class = self matchingClass
		ifFalse: [ ^ false ].
	self isSelectorList ifTrue: [
		^ (aDictionary at: selectorParts first value ifAbsentPut: [ aNode selector ]) = aNode selector
			and: [ (aDictionary at: arguments first ifAbsentPut: [ aNode arguments ]) = aNode arguments ] ].
	^ self matchArgumentsAgainst: aNode inContext: aDictionary
%

category: 'matching'
method: RBPatternPragmaNode
matchArgumentsAgainst: aNode inContext: aDictionary 
	self arguments size = aNode arguments size
		ifFalse: [ ^ false ].
	(self matchSelectorAgainst: aNode inContext: aDictionary) 
		ifFalse: [ ^ false ].
	self arguments with: aNode arguments do: [ :first :second |
		(first match: second inContext: aDictionary) 
			ifFalse: [ ^ false ] ].
	^ true
%

category: 'private'
method: RBPatternPragmaNode
matchingClass
	^ RBPragmaNode
%

category: 'matching'
method: RBPatternPragmaNode
matchSelectorAgainst: aNode inContext: aDictionary 
	self selectorParts with: aNode selectorParts do: [ :first :second |
		| keyword |
		keyword := aDictionary
			at: first value
			ifAbsentPut: [ 
				first isPatternVariable 
					ifTrue: [ second value ]
					ifFalse: [ first value ] ].
		keyword = second value 
			ifFalse: [ ^ false ] ].
	^ true
%

category: 'initialization'
method: RBPatternPragmaNode
selectorParts: keywordTokens arguments: valueNodes 
	super selectorParts: keywordTokens arguments: valueNodes.
	isList := (keywordTokens first value at: 2) == self listCharacter
%

category: 'accessing'
method: RBPatternPragmaNode
sentMessages
	^ super sentMessages
		remove: self selector ifAbsent: [ ];
		yourself
%

! Class implementation for 'RBReturnNode'

!		Class methods for 'RBReturnNode'

category: 'instance creation'
classmethod: RBReturnNode
return: returnInteger value: aValueNode 
	^self new return: returnInteger value: aValueNode
%

category: 'instance creation'
classmethod: RBReturnNode
value: aNode
	^self return: nil value: aNode
%

!		Instance methods for 'RBReturnNode'

category: 'comparing'
method: RBReturnNode
= anObject 
	self == anObject ifTrue: [^true].
	self class = anObject class ifFalse: [^false].
	^self value = anObject value
%

category: 'visitor'
method: RBReturnNode
acceptVisitor: aProgramNodeVisitor 
	^aProgramNodeVisitor acceptReturnNode: self
%

category: 'accessing'
method: RBReturnNode
children
	^Array with: value
%

category: 'testing'
method: RBReturnNode
containsReturn
	^true
%

category: 'matching'
method: RBReturnNode
copyInContext: aDictionary 
	^ self class new
		value: (self value copyInContext: aDictionary);
		yourself
%

category: 'comparing'
method: RBReturnNode
equalTo: anObject withMapping: aDictionary 
	^self class = anObject class 
		and: [self value equalTo: anObject value withMapping: aDictionary]
%

category: 'comparing'
method: RBReturnNode
hash
	^self value hash
%

category: 'testing'
method: RBReturnNode
isReturn
	^true
%

category: 'matching'
method: RBReturnNode
match: aNode inContext: aDictionary 
	aNode class = self class ifFalse: [^false].
	^value match: aNode value inContext: aDictionary
%

category: 'copying'
method: RBReturnNode
postCopy
	super postCopy.
	self value: self value copy
%

category: 'replacing'
method: RBReturnNode
replaceNode: aNode withNode: anotherNode 
	value == aNode ifTrue: [self value: anotherNode]
%

category: 'accessing-token'
method: RBReturnNode
return
	^ return
%

category: 'accessing-token'
method: RBReturnNode
return: anInteger
	return := anInteger
%

category: 'initialize-release'
method: RBReturnNode
return: returnInteger value: aValueNode 
	return := returnInteger.
	self value: aValueNode
%

category: 'accessing'
method: RBReturnNode
start
	^return
%

category: 'accessing'
method: RBReturnNode
stop
	^value stop
%

category: 'accessing'
method: RBReturnNode
value
	^value
%

category: 'accessing'
method: RBReturnNode
value: valueNode 
	value := valueNode.
	value parent: self
%

! Class implementation for 'RBSequenceNode'

!		Class methods for 'RBSequenceNode'

category: 'instance creation'
classmethod: RBSequenceNode
leftBar: leftInteger temporaries: variableNodes rightBar: rightInteger 
	^(self new)
		leftBar: leftInteger
			temporaries: variableNodes
			rightBar: rightInteger;
		yourself
%

category: 'instance creation'
classmethod: RBSequenceNode
statements: statementNodes 
	^self temporaries: #() statements: statementNodes
%

category: 'instance creation'
classmethod: RBSequenceNode
temporaries: variableNodes statements: statementNodes 
	^(self new)
		temporaries: variableNodes;
		statements: statementNodes;
		yourself
%

!		Instance methods for 'RBSequenceNode'

category: 'comparing'
method: RBSequenceNode
= anObject 
	"Can't send = to the temporaries and statements collection since they might change from arrays to OCs"

	self == anObject ifTrue: [^true].
	self class = anObject class ifFalse: [^false].
	self temporaries size = anObject temporaries size ifFalse: [^false].
	1 to: self temporaries size
		do: 
			[:i | 
			(self temporaries at: i) = (anObject temporaries at: i) ifFalse: [^false]].
	self statements size = anObject statements size ifFalse: [^false].
	1 to: self statements size
		do: [:i | (self statements at: i) = (anObject statements at: i) ifFalse: [^false]].
	^true
%

category: 'visitor'
method: RBSequenceNode
acceptVisitor: aProgramNodeVisitor 
	^aProgramNodeVisitor acceptSequenceNode: self
%

category: 'adding nodes'
method: RBSequenceNode
addNode: aNode
	aNode parent: self.
	(statements notEmpty and: [ statements last isReturn ])
		ifTrue: [ self error: 'Cannot add statement after return node' ].
	statements := statements asOrderedCollection
		add: aNode;
		yourself.
	^ aNode
%

category: 'adding nodes'
method: RBSequenceNode
addNode: aNode before: anotherNode
	| index |
	index := self indexOfNode: anotherNode.
	index = 0
		ifTrue: [ ^ self addNode: aNode ].
	statements := statements asOrderedCollection
		add: aNode beforeIndex: index;
		yourself.
	aNode parent: self.
	^ aNode
%

category: 'adding nodes'
method: RBSequenceNode
addNodeFirst: aNode
	aNode parent: self.
	statements := statements asOrderedCollection
		addFirst: aNode;
		yourself.
	^ aNode
%

category: 'adding nodes'
method: RBSequenceNode
addNodes: aCollection
	aCollection do: [ :each | each parent: self ].
	(statements notEmpty and: [ statements last isReturn ])
		ifTrue: [ self error: 'Cannot add statement after return node' ].
	statements := statements asOrderedCollection
		addAll: aCollection;
		yourself.
	^ aCollection
%

category: 'adding nodes'
method: RBSequenceNode
addNodes: aCollection before: anotherNode
	aCollection do: [ :each | self addNode: each before: anotherNode ].
	^ aCollection
%

category: 'adding nodes'
method: RBSequenceNode
addNodesFirst: aCollection
	aCollection do: [ :each | each parent: self ].
	statements := statements asOrderedCollection
		addAllFirst: aCollection;
		yourself.
	^ aCollection
%

category: 'accessing'
method: RBSequenceNode
addReturn
	| node |
	statements isEmpty
		ifTrue: [ ^ nil ].
	statements last isReturn
		ifTrue: [ ^ statements last ].
	node := RBReturnNode value: statements last.
	statements at: statements size put: node.
	node parent: self.
	^ node
%

category: 'adding nodes'
method: RBSequenceNode
addSelfReturn
	| node |
	self lastIsReturn
		ifTrue: [ ^ self statements last ].
	node := RBReturnNode value: (RBVariableNode named: 'self').
	^ self addNode: node
%

category: 'adding nodes'
method: RBSequenceNode
addTemporariesNamed: aCollection
	^ aCollection collect: [ :each | self addTemporaryNamed: each ]
%

category: 'adding nodes'
method: RBSequenceNode
addTemporaryNamed: aString 
	| variableNode |
	variableNode := RBVariableNode named: aString.
	variableNode parent: self.
	temporaries := temporaries copyWith: variableNode.
	^ variableNode
%

category: 'accessing'
method: RBSequenceNode
allDefinedVariables
	^(self temporaryNames asOrderedCollection)
		addAll: super allDefinedVariables;
		yourself
%

category: 'accessing'
method: RBSequenceNode
allTemporaryVariables
	^(self temporaryNames asOrderedCollection)
		addAll: super allTemporaryVariables;
		yourself
%

category: 'querying'
method: RBSequenceNode
bestNodeFor: anInterval 
	| node |
	node := super bestNodeFor: anInterval.
	node == self 
		ifTrue: 
			[(temporaries isEmpty and: [statements size == 1]) 
				ifTrue: [^statements first]].
	^node
%

category: 'accessing'
method: RBSequenceNode
children
	^(OrderedCollection new)
		addAll: self temporaries;
		addAll: self statements;
		yourself
%

category: 'matching'
method: RBSequenceNode
copyInContext: aDictionary 
	^ self class new
		temporaries: (self copyList: self temporaries inContext: aDictionary);
		statements: (self copyList: self statements inContext: aDictionary);
		yourself
%

category: 'testing'
method: RBSequenceNode
defines: aName 
	^temporaries anySatisfy: [:each | each name = aName]
%

category: 'testing'
method: RBSequenceNode
directlyUses: aNode 
	^false
%

category: 'comparing'
method: RBSequenceNode
equalTo: anObject withMapping: aDictionary 
	self class = anObject class ifFalse: [^false].
	self statements size = anObject statements size ifFalse: [^false].
	1 to: self statements size
		do: 
			[:i | 
			((self statements at: i) equalTo: (anObject statements at: i)
				withMapping: aDictionary) ifFalse: [^false]].
	aDictionary values asSet size = aDictionary size ifFalse: [^false].	"Not a one-to-one mapping"
	self temporaries
		do: [:each | aDictionary removeKey: each name ifAbsent: []].
	^true
%

category: 'comparing'
method: RBSequenceNode
hash
	^ (self hashForCollection: self temporaries) bitXor: (self hashForCollection: self statements)
%

category: 'private'
method: RBSequenceNode
indexOfNode: aNode 
	"Try to find the node by first looking for ==, and then for ="

	^(1 to: statements size) detect: [:each | (statements at: each) == aNode]
		ifNone: [statements indexOf: aNode]
%

category: 'initialize-release'
method: RBSequenceNode
initialize
	super initialize.
	periods := statements := temporaries := #()
%

category: 'testing'
method: RBSequenceNode
isLast: aNode 
	| last |
	statements isEmpty ifTrue: [^false].
	last := statements last.
	^last == aNode or: 
			[last isMessage and: 
					[(#(#ifTrue:ifFalse: #ifFalse:ifTrue:) includes: last selector) 
						and: [last arguments anySatisfy: [:each | each isLast: aNode]]]]
%

category: 'testing'
method: RBSequenceNode
isSequence
	^true
%

category: 'testing'
method: RBSequenceNode
lastIsReturn
	^statements notEmpty and: [statements last lastIsReturn]
%

category: 'accessing-token'
method: RBSequenceNode
leftBar
	^ leftBar
%

category: 'accessing-token'
method: RBSequenceNode
leftBar: anInteger
	leftBar := anInteger
%

category: 'initialize-release'
method: RBSequenceNode
leftBar: leftInteger temporaries: variableNodes rightBar: rightInteger 
	leftBar := leftInteger.
	self temporaries: variableNodes.
	rightBar := rightInteger
%

category: 'matching'
method: RBSequenceNode
match: aNode inContext: aDictionary 
	self class = aNode class ifFalse: [^false].
	^(self 
		matchList: temporaries
		against: aNode temporaries
		inContext: aDictionary) and: 
				[self 
					matchList: statements
					against: aNode statements
					inContext: aDictionary]
%

category: 'accessing'
method: RBSequenceNode
methodComments
	| methodComments |
	methodComments := OrderedCollection withAll: self comments.
	temporaries do: [:each | methodComments addAll: each comments].
	(parent notNil and: [parent isBlock]) 
		ifTrue: [parent arguments do: [:each | methodComments addAll: each comments]].
	^methodComments asSortedCollection: [:a :b | a first < b first]
%

category: 'accessing-token'
method: RBSequenceNode
periods
	^ periods
%

category: 'accessing-token'
method: RBSequenceNode
periods: anArray
	periods := anArray
%

category: 'copying'
method: RBSequenceNode
postCopy
	super postCopy.
	self temporaries: (self temporaries collect: [ :each | each copy ]).
	self statements: (self statements collect: [ :each | each copy ])
%

category: 'testing'
method: RBSequenceNode
references: aVariableName 
	^statements anySatisfy: [:each | each references: aVariableName]
%

category: 'replacing'
method: RBSequenceNode
removeDeadCode
	(self isUsed ifTrue: [statements size - 1] ifFalse: [statements size]) 
		to: 1
		by: -1
		do: 
			[:i | 
			(statements at: i) isImmediateNode 
				ifTrue: 
					[self clearReplacements.
					statements removeAtIndex: i]].
	super removeDeadCode
%

category: 'replacing'
method: RBSequenceNode
removeNode: aNode
	self replaceNode: aNode withNodes: #()
%

category: 'accessing'
method: RBSequenceNode
removeTemporaryNamed: aName 
	temporaries := temporaries reject: [:each | each name = aName]
%

category: 'replacing'
method: RBSequenceNode
replaceNode: aNode withNode: anotherNode 
	self statements: (statements 
				collect: [:each | each == aNode ifTrue: [anotherNode] ifFalse: [each]]).
	self temporaries: (temporaries 
				collect: [:each | each == aNode ifTrue: [anotherNode] ifFalse: [each]])
%

category: 'replacing'
method: RBSequenceNode
replaceNode: aNode withNodes: aCollection 
	| index newStatements |
	self clearReplacements.
	index := self indexOfNode: aNode.
	newStatements := OrderedCollection new: statements size + aCollection size.
	1 to: index - 1 do: [:i | newStatements add: (statements at: i)].
	newStatements addAll: aCollection.
	index + 1 to: statements size
		do: [:i | newStatements add: (statements at: i)].
	aCollection do: [:each | each parent: self].
	statements := newStatements
%

category: 'accessing-token'
method: RBSequenceNode
rightBar
	^ rightBar
%

category: 'accessing-token'
method: RBSequenceNode
rightBar: anInteger
	rightBar := anInteger
%

category: 'accessing'
method: RBSequenceNode
start
	^leftBar isNil 
		ifTrue: [statements isEmpty ifTrue: [1] ifFalse: [statements first start]]
		ifFalse: [leftBar]
%

category: 'accessing'
method: RBSequenceNode
statements
	^statements
%

category: 'accessing'
method: RBSequenceNode
statements: stmtCollection 
	statements := stmtCollection.
	statements do: [:each | each parent: self]
%

category: 'accessing'
method: RBSequenceNode
stop
	^(periods isEmpty ifTrue: [0] ifFalse: [periods last]) 
		max: (statements isEmpty ifTrue: [0] ifFalse: [statements last stop])
%

category: 'accessing'
method: RBSequenceNode
temporaries
	^temporaries
%

category: 'accessing'
method: RBSequenceNode
temporaries: tempCollection 
	temporaries := tempCollection.
	temporaries do: [:each | each parent: self]
%

category: 'accessing'
method: RBSequenceNode
temporaryNames
	^temporaries collect: [:each | each name]
%

category: 'accessing'
method: RBSequenceNode
temporaryVariables
	^(super temporaryVariables asOrderedCollection)
		addAll: self temporaryNames;
		yourself
%

category: 'testing'
method: RBSequenceNode
uses: aNode 
	statements isEmpty ifTrue: [^false].
	aNode == statements last ifFalse: [^false].
	^self isUsed
%

category: 'querying'
method: RBSequenceNode
whichNodeIsContainedBy: anInterval 
	| node |
	node := super whichNodeIsContainedBy: anInterval.
	node == self 
		ifTrue: 
			[(temporaries isEmpty and: [statements size == 1]) 
				ifTrue: [^statements first]].
	^node
%

! Class implementation for 'RBValueNode'

!		Instance methods for 'RBValueNode'

category: 'accessing'
method: RBValueNode
addParenthesis: anInterval 
	parentheses isNil ifTrue: [parentheses := OrderedCollection new: 1].
	parentheses add: anInterval
%

category: 'testing'
method: RBValueNode
containedBy: anInterval 
	^anInterval first <= self startWithoutParentheses 
		and: [anInterval last >= self stopWithoutParentheses]
%

category: 'testing'
method: RBValueNode
hasParentheses
	^self parentheses notEmpty
%

category: 'testing'
method: RBValueNode
isValue
	^true
%

category: 'testing'
method: RBValueNode
needsParenthesis
	^self subclassResponsibility
%

category: 'accessing'
method: RBValueNode
parentheses
	^parentheses isNil ifTrue: [#()] ifFalse: [parentheses]
%

category: 'accessing'
method: RBValueNode
start
	^parentheses isNil 
		ifTrue: [self startWithoutParentheses]
		ifFalse: [parentheses last first]
%

category: 'accessing'
method: RBValueNode
startWithoutParentheses
	^self subclassResponsibility
%

category: 'accessing'
method: RBValueNode
stop
	^parentheses isNil
		ifTrue: [self stopWithoutParentheses]
		ifFalse: [parentheses last last]
%

category: 'accessing'
method: RBValueNode
stopWithoutParentheses
	^self subclassResponsibility
%

! Class implementation for 'RBArrayNode'

!		Class methods for 'RBArrayNode'

category: 'instance creation'
classmethod: RBArrayNode
statements: statements
	^ self new statements: statements
%

!		Instance methods for 'RBArrayNode'

category: 'comparing'
method: RBArrayNode
= anObject 
	self == anObject ifTrue: [ ^ true ].
	self class = anObject class ifFalse: [ ^ false ].
	self statements size = anObject statements size ifFalse: [ ^ false ].
	1 to: self statements size do: [ :i | 
		(self statements at: i) = (anObject statements at: i) 
			ifFalse: [ ^ false ] ].
	^ true
%

category: 'visitor'
method: RBArrayNode
acceptVisitor: aProgramNodeVisitor
	^ aProgramNodeVisitor acceptArrayNode: self
%

category: 'adding nodes'
method: RBArrayNode
addNode: aNode
	statements := statements asOrderedCollection
		add: aNode;
		yourself.
	aNode parent: self.
	^ aNode
%

category: 'adding nodes'
method: RBArrayNode
addNode: aNode before: anotherNode 
	| index |
	aNode isReturn 
		ifTrue: [ self error: 'Cannot add return node' ].
	index := self indexOfNode: anotherNode.
	index = 0 ifTrue: [ ^ self addNode: aNode ].
	statements := statements asOrderedCollection
		add: aNode beforeIndex: index;
		yourself.
	aNode parent: self.
	^ aNode
%

category: 'adding nodes'
method: RBArrayNode
addNodeFirst: aNode
	statements := statements asOrderedCollection
		addFirst: aNode;
		yourself.
	aNode parent: self.
	^ aNode
%

category: 'adding nodes'
method: RBArrayNode
addNodes: aCollection
	statements := statements asOrderedCollection
		addAll: aCollection;
		yourself.
	aCollection do: [ :each | each parent: self ].
	^ aCollection
%

category: 'adding nodes'
method: RBArrayNode
addNodes: aCollection before: anotherNode 
	aCollection do: [ :each | self addNode: each before: anotherNode ].
	^ aCollection
%

category: 'adding nodes'
method: RBArrayNode
addNodesFirst: aCollection
	statements := statements asOrderedCollection
		addAllFirst: aCollection;
		yourself.
	aCollection do: [ :each | each parent: self ].
	^ aCollection
%

category: 'accessing'
method: RBArrayNode
children
	^ self statements
%

category: 'matching'
method: RBArrayNode
copyInContext: aDictionary 
	^ self class statements: (self copyList: self statements inContext: aDictionary)
%

category: 'comparing'
method: RBArrayNode
equalTo: anObject withMapping: aDictionary 
	self class = anObject class 
		ifFalse: [ ^ false ].
	self statements size = anObject statements size 
		ifFalse: [ ^ false ].
	self statements with: anObject statements do: [ :first :second |
		(first equalTo: second withMapping: aDictionary)
			ifFalse: [ ^ false ] ].
	aDictionary values asSet size = aDictionary size 
		ifFalse: [ ^ false ].
	^ true
%

category: 'comparing'
method: RBArrayNode
hash
	^ self hashForCollection: self statements
%

category: 'private'
method: RBArrayNode
indexOfNode: aNode 
	"Try to find the node by first looking for ==, and then for ="

	^ (1 to: statements size) 
		detect: [ :each | (statements at: each) == aNode ]
		ifNone: [ statements indexOf: aNode ]
%

category: 'initialize-release'
method: RBArrayNode
initialize
	super initialize.
	statements := periods := #()
%

category: 'testing'
method: RBArrayNode
isArray
	^ true
%

category: 'testing'
method: RBArrayNode
lastIsReturn
	statements isEmpty ifTrue:[ ^false ].
	^statements last lastIsReturn
%

category: 'accessing-token'
method: RBArrayNode
left
	^ left
%

category: 'accessing-token'
method: RBArrayNode
left: anInteger
	left := anInteger
%

category: 'matching'
method: RBArrayNode
match: aNode inContext: aDictionary 
	aNode class = self class ifFalse: [ ^ false ].
	^ self matchList: statements against: aNode statements inContext: aDictionary
%

category: 'testing'
method: RBArrayNode
needsParenthesis
	^ false
%

category: 'accessing-token'
method: RBArrayNode
periods
	^ periods
%

category: 'accessing-token'
method: RBArrayNode
periods: anArray
	periods := anArray
%

category: 'copying'
method: RBArrayNode
postCopy
	super postCopy.
	self statements: (self statements collect: [ :each | each copy ])
%

category: 'accessing'
method: RBArrayNode
precedence
	^0
%

category: 'testing'
method: RBArrayNode
references: aVariableName 
	^ statements anySatisfy: [ :each | each references: aVariableName ]
%

category: 'replacing'
method: RBArrayNode
replaceNode: oldNode  withNode: newNode
	self statements: (statements collect: [ :statement |
		statement == oldNode 
			ifTrue: [ newNode ]
			ifFalse: [ statement ] ])
%

category: 'accessing-token'
method: RBArrayNode
right
	^ right
%

category: 'accessing-token'
method: RBArrayNode
right: anInteger
	right := anInteger
%

category: 'accessing'
method: RBArrayNode
startWithoutParentheses 
	^ left
%

category: 'accessing'
method: RBArrayNode
statementComments
	^self comments
%

category: 'accessing'
method: RBArrayNode
statements
	^statements
%

category: 'accessing'
method: RBArrayNode
statements: statements0 
	statements := statements0.
	statements do: [:statement | statement parent: self]
%

category: 'accessing'
method: RBArrayNode
stopWithoutParentheses 
	^ right
%

category: 'testing'
method: RBArrayNode
uses: aNode 
	^ (statements anySatisfy: [ :each | each == aNode ]) or: [ self isUsed ]
%

! Class implementation for 'RBAssignmentNode'

!		Class methods for 'RBAssignmentNode'

category: 'instance creation'
classmethod: RBAssignmentNode
variable: aVariableNode value: aValueNode 
	^self 
		variable: aVariableNode
		value: aValueNode
		position: nil
%

category: 'instance creation'
classmethod: RBAssignmentNode
variable: aVariableNode value: aValueNode position: anInteger 
	^(self new)
		variable: aVariableNode
			value: aValueNode
			position: anInteger;
		yourself
%

!		Instance methods for 'RBAssignmentNode'

category: 'comparing'
method: RBAssignmentNode
= anObject 
	self == anObject ifTrue: [^true].
	self class = anObject class ifFalse: [^false].
	^self variable = anObject variable and: [self value = anObject value]
%

category: 'visitor'
method: RBAssignmentNode
acceptVisitor: aProgramNodeVisitor 
	^aProgramNodeVisitor acceptAssignmentNode: self
%

category: 'accessing-token'
method: RBAssignmentNode
assignment
	^ assignment
%

category: 'accessing-token'
method: RBAssignmentNode
assignment: anInteger
	assignment := anInteger
%

category: 'accessing'
method: RBAssignmentNode
assignmentOperator
	^ (self assignmentPosition notNil and: [ self source notNil and: [ (self source at: self assignmentPosition ifAbsent: [ nil ]) = $_ ] ])
		ifTrue: [ '_' ]
		ifFalse: [ ':=' ]
%

category: 'accessing'
method: RBAssignmentNode
assignmentPosition
	^ assignment
%

category: 'testing'
method: RBAssignmentNode
assigns: aVariableName 
	^variable name = aVariableName or: [value assigns: aVariableName]
%

category: 'querying'
method: RBAssignmentNode
bestNodeFor: anInterval 
	(self intersectsInterval: anInterval) ifFalse: [^nil].
	(self containedBy: anInterval) ifTrue: [^self].
	assignment isNil ifTrue: [^super bestNodeFor: anInterval].
	((anInterval first between: assignment and: assignment + 1) 
		or: [assignment between: anInterval first and: anInterval last]) 
			ifTrue: [^self].
	self children do: 
			[:each | 
			| node |
			node := each bestNodeFor: anInterval.
			node notNil ifTrue: [^node]]
%

category: 'accessing'
method: RBAssignmentNode
children
	^Array with: value with: variable
%

category: 'matching'
method: RBAssignmentNode
copyInContext: aDictionary 
	^ self class new
		variable: (self variable copyInContext: aDictionary);
		value: (self value copyInContext: aDictionary);
		yourself
%

category: 'testing'
method: RBAssignmentNode
directlyUses: aNode 
	^aNode = value ifTrue: [true] ifFalse: [self isDirectlyUsed]
%

category: 'comparing'
method: RBAssignmentNode
equalTo: anObject withMapping: aDictionary 
	^self class = anObject class and: 
			[(self variable equalTo: anObject variable withMapping: aDictionary) 
				and: [self value equalTo: anObject value withMapping: aDictionary]]
%

category: 'comparing'
method: RBAssignmentNode
hash
	^self variable hash bitXor: self value hash
%

category: 'testing'
method: RBAssignmentNode
isAssignment
	^true
%

category: 'matching'
method: RBAssignmentNode
match: aNode inContext: aDictionary 
	aNode class = self class ifFalse: [^false].
	^(variable match: aNode variable inContext: aDictionary)
		and: [value match: aNode value inContext: aDictionary]
%

category: 'testing'
method: RBAssignmentNode
needsParenthesis
	^parent isNil 
		ifTrue: [false]
		ifFalse: [self precedence > parent precedence]
%

category: 'copying'
method: RBAssignmentNode
postCopy
	super postCopy.
	self variable: self variable copy.
	self value: self value copy
%

category: 'accessing'
method: RBAssignmentNode
precedence
	^5
%

category: 'replacing'
method: RBAssignmentNode
replaceNode: aNode withNode: anotherNode 
	value == aNode ifTrue: [self value: anotherNode].
	variable == aNode ifTrue: [self variable: anotherNode]
%

category: 'replacing'
method: RBAssignmentNode
replaceSourceWith: aNode 
	"Check if we need to convert the assignment. Also check if we are being replaced with a setter message send. If so, create the replacements to edit the original source."

	(aNode isAssignment and: [ aNode assignmentOperator ~= self assignmentOperator ]) ifTrue: [
		self addReplacement: (RBStringReplacement 
			replaceFrom: self assignmentPosition
			to: self assignmentPosition + self assignmentOperator size - 1
			with: aNode assignmentOperator).
		(aNode variable = variable and: [ aNode value = value ])
			ifTrue: [ ^ self ] ].
	aNode isMessage ifFalse: [^super replaceSourceWith: aNode].
	aNode receiver isVariable ifFalse: [^super replaceSourceWith: aNode].
	aNode numArgs = 1 ifFalse: [^super replaceSourceWith: aNode].
	(self mappingFor: self value) = aNode arguments first 
		ifFalse: [^super replaceSourceWith: aNode].
	(self value hasParentheses not 
		and: [aNode arguments first precedence >= aNode precedence]) 
			ifTrue: 
				[self
					addReplacement: (RBStringReplacement 
								replaceFrom: self value start
								to: self value start - 1
								with: '(');
					addReplacement: (RBStringReplacement 
								replaceFrom: self value stop + 1
								to: self value stop
								with: ')')].
	self addReplacement: (RBStringReplacement 
				replaceFrom: self variable start
				to: self assignmentPosition + 1
				with: aNode receiver name , ' ' , aNode selector)
%

category: 'accessing'
method: RBAssignmentNode
startWithoutParentheses
	^variable start
%

category: 'accessing'
method: RBAssignmentNode
stopWithoutParentheses
	^value stop
%

category: 'testing'
method: RBAssignmentNode
uses: aNode 
	^aNode = value ifTrue: [true] ifFalse: [self isUsed]
%

category: 'accessing'
method: RBAssignmentNode
value
	^value
%

category: 'accessing'
method: RBAssignmentNode
value: aValueNode 
	value := aValueNode.
	value parent: self
%

category: 'accessing'
method: RBAssignmentNode
variable
	^variable
%

category: 'accessing'
method: RBAssignmentNode
variable: varNode 
	variable := varNode.
	variable parent: self
%

category: 'initialize-release'
method: RBAssignmentNode
variable: aVariableNode value: aValueNode position: anInteger 
	self variable: aVariableNode.
	self value: aValueNode.
	assignment := anInteger
%

! Class implementation for 'RBBlockNode'

!		Class methods for 'RBBlockNode'

category: 'instance creation'
classmethod: RBBlockNode
arguments: argNodes body: sequenceNode 
	^(self new)
		arguments: argNodes;
		body: sequenceNode;
		yourself
%

category: 'instance creation'
classmethod: RBBlockNode
body: sequenceNode 
	^self arguments: #() body: sequenceNode
%

!		Instance methods for 'RBBlockNode'

category: 'comparing'
method: RBBlockNode
= anObject 
	self == anObject ifTrue: [^true].
	self class = anObject class ifFalse: [^false].
	self body = anObject body ifFalse: [^false].
	self arguments size = anObject arguments size ifFalse: [^false].
	1 to: self arguments size
		do: [:i | (self arguments at: i) = (anObject arguments at: i) ifFalse: [^false]].
	^true
%

category: 'visitor'
method: RBBlockNode
acceptVisitor: aProgramNodeVisitor 
	^aProgramNodeVisitor acceptBlockNode: self
%

category: 'accessing'
method: RBBlockNode
allArgumentVariables
	^(self argumentNames asOrderedCollection)
		addAll: super allArgumentVariables;
		yourself
%

category: 'accessing'
method: RBBlockNode
allDefinedVariables
	^(self argumentNames asOrderedCollection)
		addAll: super allDefinedVariables;
		yourself
%

category: 'accessing'
method: RBBlockNode
argumentNames
	^self arguments collect: [:each | each name]
%

category: 'accessing'
method: RBBlockNode
arguments
	^arguments
%

category: 'accessing'
method: RBBlockNode
arguments: argCollection 
	arguments := argCollection.
	arguments do: [:each | each parent: self]
%

category: 'accessing-token'
method: RBBlockNode
bar
	^ bar
%

category: 'accessing-token'
method: RBBlockNode
bar: anInteger
	bar := anInteger
%

category: 'accessing'
method: RBBlockNode
blockVariables
	| vars |
	vars := super blockVariables asOrderedCollection.
	vars addAll: self argumentNames.
	^vars
%

category: 'accessing'
method: RBBlockNode
body
	^body
%

category: 'accessing'
method: RBBlockNode
body: stmtsNode 
	body := stmtsNode.
	body parent: self
%

category: 'accessing'
method: RBBlockNode
children
	^self arguments copyWith: self body
%

category: 'accessing-token'
method: RBBlockNode
colons
	^ colons
%

category: 'accessing-token'
method: RBBlockNode
colons: anArray 
	colons := anArray
%

category: 'matching'
method: RBBlockNode
copyInContext: aDictionary 
	^ self class new
		arguments: (self copyList: self arguments inContext: aDictionary);
		body: (self body copyInContext: aDictionary);
		yourself
%

category: 'testing'
method: RBBlockNode
defines: aName 
	^arguments anySatisfy: [:each | each name = aName]
%

category: 'testing'
method: RBBlockNode
directlyUses: aNode 
	^false
%

category: 'comparing'
method: RBBlockNode
equalTo: anObject withMapping: aDictionary 
	self class = anObject class ifFalse: [^false].
	self arguments size = anObject arguments size ifFalse: [^false].
	1 to: self arguments size
		do: 
			[:i | 
			((self arguments at: i) equalTo: (anObject arguments at: i)
				withMapping: aDictionary) ifFalse: [^false]].
	(self body equalTo: anObject body withMapping: aDictionary)
		ifFalse: [^false].
	self arguments do: [:each | aDictionary removeKey: each name].
	^true
%

category: 'comparing'
method: RBBlockNode
hash
	^ (self hashForCollection: self arguments) bitXor: self body hash
%

category: 'testing'
method: RBBlockNode
isBlock
	^true
%

category: 'testing'
method: RBBlockNode
isImmediateNode
	^true
%

category: 'testing'
method: RBBlockNode
isLast: aNode 
	^body isLast: aNode
%

category: 'accessing-token'
method: RBBlockNode
left
	^ left
%

category: 'accessing-token'
method: RBBlockNode
left: anInteger
	left := anInteger
%

category: 'matching'
method: RBBlockNode
match: aNode inContext: aDictionary 
	aNode class = self class ifFalse: [^false].
	^(self 
		matchList: arguments
		against: aNode arguments
		inContext: aDictionary) 
			and: [body match: aNode body inContext: aDictionary]
%

category: 'testing'
method: RBBlockNode
needsParenthesis
	^false
%

category: 'copying'
method: RBBlockNode
postCopy
	super postCopy.
	self arguments: (self arguments collect: [ :each | each copy ]).
	self body: self body copy
%

category: 'accessing'
method: RBBlockNode
precedence
	^0
%

category: 'testing'
method: RBBlockNode
references: aVariableName 
	^body references: aVariableName
%

category: 'replacing'
method: RBBlockNode
replaceNode: aNode withNode: anotherNode 
	body == aNode ifTrue: [self body: anotherNode].
	self arguments: (arguments 
				collect: [:each | each == aNode ifTrue: [anotherNode] ifFalse: [each]])
%

category: 'accessing-token'
method: RBBlockNode
right
	^ right
%

category: 'accessing-token'
method: RBBlockNode
right: anInteger
	right := anInteger
%

category: 'accessing'
method: RBBlockNode
startWithoutParentheses
	^left
%

category: 'accessing'
method: RBBlockNode
statementComments
	^self comments
%

category: 'accessing'
method: RBBlockNode
stopWithoutParentheses
	^right
%

category: 'testing'
method: RBBlockNode
uses: aNode 
	aNode = body ifFalse: [^false].
	^parent isMessage 
		ifTrue: 
			[(#(#ifTrue:ifFalse: #ifTrue: #ifFalse: #ifFalse:ifTrue:) 
				includes: parent selector) not 
				or: [parent isUsed]]
		ifFalse: [self isUsed]
%

! Class implementation for 'RBPatternBlockNode'

!		Instance methods for 'RBPatternBlockNode'

category: 'visitor'
method: RBPatternBlockNode
acceptVisitor: aProgramNodeVisitor 
	^aProgramNodeVisitor acceptPatternBlockNode: self
%

category: 'matching'
method: RBPatternBlockNode
addArgumentWithNameBasedOn: aString to: aRBBlockNode 
	| name index vars |
	name := aString.
	vars := aRBBlockNode allDefinedVariables.
	index := 0.
	[vars includes: name] whileTrue: 
			[index := index + 1.
			name := name , index printString].
	aRBBlockNode 
		arguments: (aRBBlockNode arguments copyWith: (RBVariableNode named: name))
%

category: 'matching'
method: RBPatternBlockNode
constructLookupNodeFor: aString in: aRBBlockNode 
	| argumentNode |
	argumentNode := RBLiteralNode literalToken: (RBLiteralToken 
						value: aString
						start: nil
						stop: nil).
	^RBMessageNode 
		receiver: (RBVariableNode named: 'self')
		selector: #lookupMatchFor:in:
		arguments: (Array with: argumentNode with: aRBBlockNode arguments last)
%

category: 'matching'
method: RBPatternBlockNode
copyInContext: aDictionary 
	^ self replacingBlock value: aDictionary
%

category: 'matching'
method: RBPatternBlockNode
createBlockFor: aRBBlockNode
  | source |
  self replacePatternNodesIn: aRBBlockNode.
  source := aRBBlockNode formattedCode.
  ^ (source
    _compileInContext: self
    symbolList: GsSession currentSession symbolList
    oldLitVars: nil
    environmentId: 0) _executeInContext: self
%

category: 'matching'
method: RBPatternBlockNode
createMatchingBlock
	| newBlock |
	self arguments size > 2 
		ifTrue: 
			[self 
				error: 'Search blocks can only contain arguments for the node and matching dictionary'].
	newBlock := RBBlockNode arguments: arguments body: body.
	newBlock arguments isEmpty 
		ifTrue: [self addArgumentWithNameBasedOn: 'aNode' to: newBlock].
	newBlock arguments size = 1 
		ifTrue: [self addArgumentWithNameBasedOn: 'aDictionary' to: newBlock].
	^self createBlockFor: newBlock
%

category: 'matching'
method: RBPatternBlockNode
createReplacingBlock
	| newBlock |
	self arguments size > 1 
		ifTrue: 
			[self 
				error: 'Replace blocks can only contain an argument for the matching dictionary'].
	newBlock := RBBlockNode arguments: arguments body: body.
	self arguments isEmpty 
		ifTrue: [self addArgumentWithNameBasedOn: 'aDictionary' to: newBlock].
	^self createBlockFor: newBlock
%

category: 'matching'
method: RBPatternBlockNode
lookupMatchFor: aString in: aDictionary 
	^aDictionary at: aString
		ifAbsent: 
			[| variableNode |
			variableNode := RBPatternVariableNode named: aString.
			aDictionary at: variableNode ifAbsent: [nil]]
%

category: 'matching'
method: RBPatternBlockNode
match: aNode inContext: aDictionary 
	^self matchingBlock value: aNode value: aDictionary
%

category: 'matching'
method: RBPatternBlockNode
matchingBlock
	^valueBlock isNil 
		ifTrue: [valueBlock := self createMatchingBlock]
		ifFalse: [valueBlock]
%

category: 'matching'
method: RBPatternBlockNode
replacePatternNodesIn: aRBBlockNode 
	aRBBlockNode body nodesDo: 
			[:each | 
			(each isVariable and: [each isPatternNode]) 
				ifTrue: 
					[each 
						replaceWith: (self constructLookupNodeFor: each name in: aRBBlockNode)]]
%

category: 'matching'
method: RBPatternBlockNode
replacingBlock
	^valueBlock isNil 
		ifTrue: [valueBlock := self createReplacingBlock]
		ifFalse: [valueBlock]
%

category: 'accessing'
method: RBPatternBlockNode
sentMessages
	^ OrderedCollection new
%

! Class implementation for 'RBPatternWrapperBlockNode'

!		Instance methods for 'RBPatternWrapperBlockNode'

category: 'visitor'
method: RBPatternWrapperBlockNode
acceptVisitor: aProgramNodeVisitor 
	^aProgramNodeVisitor acceptPatternWrapperBlockNode: self
%

category: 'matching'
method: RBPatternWrapperBlockNode
copyInContext: aDictionary 
	"I don't know what this would mean, so ignore it."

	^ wrappedNode copyInContext: aDictionary
%

category: 'matching'
method: RBPatternWrapperBlockNode
match: aNode inContext: aDictionary 
	(wrappedNode match: aNode inContext: aDictionary) ifFalse: [^false].
	^super match: aNode inContext: aDictionary
%

category: 'accessing'
method: RBPatternWrapperBlockNode
precedence
	^1
%

category: 'accessing'
method: RBPatternWrapperBlockNode
wrappedNode
	^wrappedNode
%

category: 'accessing'
method: RBPatternWrapperBlockNode
wrappedNode: aRBProgramNode 
	wrappedNode := aRBProgramNode.
	aRBProgramNode parent: self
%

! Class implementation for 'RBQueryBlockNode'

!		Instance methods for 'RBQueryBlockNode'

category: 'visitor'
method: RBQueryBlockNode
acceptVisitor: aProgramNodeVisitor
  ^ aProgramNodeVisitor acceptQueryBlockNode: self
%

! Class implementation for 'RBCascadeNode'

!		Class methods for 'RBCascadeNode'

category: 'instance creation'
classmethod: RBCascadeNode
messages: messageNodes 
	^self new messages: messageNodes
%

category: 'instance creation'
classmethod: RBCascadeNode
messages: messageNodes semicolons: integerCollection 
	^self new messages: messageNodes semicolons: integerCollection
%

!		Instance methods for 'RBCascadeNode'

category: 'comparing'
method: RBCascadeNode
= anObject 
	self == anObject ifTrue: [^true].
	self class = anObject class ifFalse: [^false].
	self messages size = anObject messages size ifFalse: [^false].
	1 to: self messages size
		do: [:i | (self messages at: i) = (anObject messages at: i) ifFalse: [^false]].
	^true
%

category: 'visitor'
method: RBCascadeNode
acceptVisitor: aProgramNodeVisitor 
	^aProgramNodeVisitor acceptCascadeNode: self
%

category: 'querying'
method: RBCascadeNode
bestNodeFor: anInterval 
	| selectedChildren |
	(self intersectsInterval: anInterval) ifFalse: [^nil].
	(self containedBy: anInterval) ifTrue: [^self].
	messages 
		reverseDo: [:each | (each containedBy: anInterval) ifTrue: [^each]].
	selectedChildren := (messages 
				collect: [:each | each bestNodeFor: anInterval]) 
					reject: [:each | each isNil].
	^selectedChildren detect: [:each | true] ifNone: [nil]
%

category: 'accessing'
method: RBCascadeNode
children
	^self messages
%

category: 'matching'
method: RBCascadeNode
copyInContext: aDictionary 
	^ self class new
		messages: (self copyList: self messages inContext: aDictionary);
		yourself
%

category: 'testing'
method: RBCascadeNode
directlyUses: aNode 
	^messages last = aNode and: [self isDirectlyUsed]
%

category: 'comparing'
method: RBCascadeNode
equalTo: anObject withMapping: aDictionary 
	self class = anObject class ifFalse: [^false].
	self messages size = anObject messages size ifFalse: [^false].
	1 to: self messages size
		do: 
			[:i | 
			((self messages at: i) equalTo: (anObject messages at: i)
				withMapping: aDictionary) ifFalse: [^false]].
	^true
%

category: 'comparing'
method: RBCascadeNode
hash
	^ self hashForCollection: self messages
%

category: 'testing'
method: RBCascadeNode
isCascade
	^true
%

category: 'matching'
method: RBCascadeNode
match: aNode inContext: aDictionary 
	aNode class = self class ifFalse: [^false].
	^self 
		matchList: messages
		against: aNode messages
		inContext: aDictionary
%

category: 'accessing'
method: RBCascadeNode
messages
	^messages
%

category: 'accessing'
method: RBCascadeNode
messages: messageNodeCollection 
	messages := messageNodeCollection.
	messages do: [:each | each parent: self]
%

category: 'initialize-release'
method: RBCascadeNode
messages: messageNodes semicolons: integerCollection 
	self messages: messageNodes.
	semicolons := integerCollection
%

category: 'testing'
method: RBCascadeNode
needsParenthesis
	^parent isNil 
		ifTrue: [false]
		ifFalse: [self precedence > parent precedence]
%

category: 'copying'
method: RBCascadeNode
postCopy
	super postCopy.
	self messages: (self messages collect: [ :each | each copy ])
%

category: 'accessing'
method: RBCascadeNode
precedence
	^4
%

category: 'accessing'
method: RBCascadeNode
receiver
	^self messages first receiver
%

category: 'replacing'
method: RBCascadeNode
replaceNode: aNode withNode: anotherNode 
	self messages: (messages 
				collect: [:each | each == aNode ifTrue: [anotherNode] ifFalse: [each]])
%

category: 'accessing-token'
method: RBCascadeNode
semicolons
	^ semicolons
%

category: 'accessing-token'
method: RBCascadeNode
semicolons: anArray
	semicolons := anArray
%

category: 'accessing'
method: RBCascadeNode
startWithoutParentheses
	^messages first start
%

category: 'accessing'
method: RBCascadeNode
statementComments
	| statementComments |
	statementComments := OrderedCollection withAll: self comments.
	statementComments addAll: messages first receiver statementComments.
	messages do: 
			[:each | 
			each arguments 
				do: [:arg | statementComments addAll: arg statementComments]].
	^statementComments asSortedCollection: [:a :b | a first < b first]
%

category: 'accessing'
method: RBCascadeNode
stopWithoutParentheses
	^messages last stop
%

category: 'testing'
method: RBCascadeNode
uses: aNode 
	^messages last = aNode and: [self isUsed]
%

category: 'querying'
method: RBCascadeNode
whichNodeIsContainedBy: anInterval 
	| selectedChildren |
	(self intersectsInterval: anInterval) ifFalse: [^nil].
	(self containedBy: anInterval) ifTrue: [^self].
	messages 
		reverseDo: [:each | (each containedBy: anInterval) ifTrue: [^each]].
	selectedChildren := (messages 
				collect: [:each | each whichNodeIsContainedBy: anInterval]) 
					reject: [:each | each isNil].
	^selectedChildren detect: [:each | true] ifNone: [nil]
%

! Class implementation for 'RBLiteralNode'

!		Class methods for 'RBLiteralNode'

category: 'instance creation'
classmethod: RBLiteralNode
literalToken: aLiteralToken 
	^(aLiteralToken realValue class == Array 
		or: [aLiteralToken realValue class == ByteArray]) 
			ifTrue: 
				[RBLiteralArrayNode 
					startPosition: aLiteralToken start
					contents: (aLiteralToken value asArray 
							collect: [:each | RBLiteralNode literalToken: each])
					stopPosition: aLiteralToken stop
					isByteArray: aLiteralToken value class ~~ Array]
			ifFalse: [RBLiteralValueNode literalToken: aLiteralToken]
%

category: 'instance creation'
classmethod: RBLiteralNode
value: aValue 
	^((aValue class == Array or: [aValue class == ByteArray]) 
		ifTrue: [RBLiteralArrayNode]
		ifFalse: [RBLiteralValueNode]) value: aValue
%

!		Instance methods for 'RBLiteralNode'

category: 'comparing'
method: RBLiteralNode
= anObject 
	self == anObject ifTrue: [^true].
	^self class = anObject class
%

category: 'comparing'
method: RBLiteralNode
hash
	^self value hash
%

category: 'testing'
method: RBLiteralNode
isImmediateNode
	^true
%

category: 'testing'
method: RBLiteralNode
isLiteralNode
	^true
%

category: 'testing'
method: RBLiteralNode
needsParenthesis
	^false
%

category: 'accessing'
method: RBLiteralNode
precedence
	^0
%

category: 'private-replacing'
method: RBLiteralNode
replaceSourceFrom: aNode 
	self addReplacement: (RBStringReplacement 
				replaceFrom: aNode start
				to: aNode stop
				with: self formattedCode)
%

category: 'private-replacing'
method: RBLiteralNode
replaceSourceWith: aNode 
	self addReplacement: (RBStringReplacement 
				replaceFrom: self start
				to: self stop
				with: aNode formattedCode)
%

category: 'accessing'
method: RBLiteralNode
value
	^self subclassResponsibility
%

! Class implementation for 'RBLiteralArrayNode'

!		Class methods for 'RBLiteralArrayNode'

category: 'instance creation'
classmethod: RBLiteralArrayNode
startPosition: startInteger contents: anArray stopPosition: stopInteger isByteArray: aBoolean 
	^(self new)
		startPosition: startInteger
			contents: anArray
			stopPosition: stopInteger
			isByteArray: aBoolean;
		yourself
%

category: 'instance creation'
classmethod: RBLiteralArrayNode
value: aValue 
	^(self new)
		startPosition: nil
			contents: (aValue asArray collect: [:each | RBLiteralNode value: each])
			stopPosition: nil
			isByteArray: aValue class ~~ Array;
		yourself
%

!		Instance methods for 'RBLiteralArrayNode'

category: 'comparing'
method: RBLiteralArrayNode
= anObject 
	super = anObject ifFalse: [^false].
	self isForByteArray = anObject isForByteArray ifFalse: [^false].
	self contents size = anObject contents size ifFalse: [^false].
	1 to: self contents size
		do: [:i | (self contents at: i) = (anObject contents at: i) ifFalse: [^false]].
	^true
%

category: 'visitor'
method: RBLiteralArrayNode
acceptVisitor: aProgramNodeVisitor 
	^aProgramNodeVisitor acceptLiteralArrayNode: self
%

category: 'accessing'
method: RBLiteralArrayNode
children
	^contents
%

category: 'accessing'
method: RBLiteralArrayNode
contents
	^contents
%

category: 'initialize-release'
method: RBLiteralArrayNode
contents: aRBLiteralNodeCollection 
	contents := aRBLiteralNodeCollection.
	contents do: [:each | each parent: self]
%

category: 'matching'
method: RBLiteralArrayNode
copyInContext: aDictionary 
	^ self class 
		startPosition: nil
		contents: (self copyList: self contents inContext: aDictionary)
		stopPosition: nil
		isByteArray: isByteArray
%

category: 'comparing'
method: RBLiteralArrayNode
equalTo: anObject withMapping: aDictionary 
	self class = anObject class ifFalse: [^false].
	self isForByteArray = anObject isForByteArray ifFalse: [^false].
	self contents size = anObject contents size ifFalse: [^false].
	1 to: self contents size
		do: 
			[:i | 
			((self contents at: i) equalTo: (anObject contents at: i)
				withMapping: aDictionary) ifFalse: [^false]].
	^true
%

category: 'testing'
method: RBLiteralArrayNode
isForByteArray
	^isByteArray
%

category: 'testing'
method: RBLiteralArrayNode
isLiteralArray
	^true
%

category: 'matching'
method: RBLiteralArrayNode
match: aNode inContext: aDictionary 
	aNode class = self class ifFalse: [^false].
	self isForByteArray = aNode isForByteArray ifFalse: [^false].
	^self 
		matchList: contents
		against: aNode contents
		inContext: aDictionary
%

category: 'copying'
method: RBLiteralArrayNode
postCopy
	super postCopy.
	self contents: (self contents collect: [ :each | each copy ])
%

category: 'replacing'
method: RBLiteralArrayNode
replaceNode: aNode withNode: anotherNode 
	self contents: (contents 
				collect: [:each | each == aNode ifTrue: [anotherNode] ifFalse: [each]])
%

category: 'private-replacing'
method: RBLiteralArrayNode
replaceSourceWith: aNode 
	(self class = aNode class and: 
			[self isForByteArray = aNode isForByteArray 
				and: [self contents size = aNode contents size]]) 
		ifFalse: [^super replaceSourceWith: aNode].
	1 to: self contents size
		do: 
			[:i | 
			(self contents at: i) = (aNode contents at: i) 
				ifFalse: [(self contents at: i) replaceSourceWith: (aNode contents at: i)]]
%

category: 'initialize-release'
method: RBLiteralArrayNode
startPosition: startInteger contents: anArray stopPosition: stopInteger isByteArray: aBoolean 
	start := startInteger.
	self contents: anArray.
	stop := stopInteger.
	isByteArray := aBoolean
%

category: 'accessing'
method: RBLiteralArrayNode
startWithoutParentheses
	^start
%

category: 'accessing'
method: RBLiteralArrayNode
stopWithoutParentheses
	^stop
%

category: 'accessing'
method: RBLiteralArrayNode
value
	| array |
	array := (isByteArray ifTrue: [ByteArray] ifFalse: [Array]) 
				new: contents size.
	1 to: contents size
		do: [:each | array at: each put: (contents at: each) value].
	^array
%

! Class implementation for 'RBLiteralValueNode'

!		Class methods for 'RBLiteralValueNode'

category: 'instance creation'
classmethod: RBLiteralValueNode
literalToken: aLiteralToken 
	^(self new)
		literalToken: aLiteralToken;
		yourself
%

category: 'instance creation'
classmethod: RBLiteralValueNode
value: aValue 
	^self literalToken: (RBLiteralToken value: aValue)
%

!		Instance methods for 'RBLiteralValueNode'

category: 'comparing'
method: RBLiteralValueNode
= anObject 
	^ super = anObject 
		and: [ self value = anObject value 
		and: [ self value species = anObject value species ] ]
%

category: 'visitor'
method: RBLiteralValueNode
acceptVisitor: aProgramNodeVisitor 
	^aProgramNodeVisitor acceptLiteralNode: self
%

category: 'matching'
method: RBLiteralValueNode
copyInContext: aDictionary
	^ self class literalToken: self token copy removePositions
%

category: 'initialize-release'
method: RBLiteralValueNode
literalToken: aLiteralToken 
	token := aLiteralToken
%

category: 'accessing'
method: RBLiteralValueNode
startWithoutParentheses
	^token start
%

category: 'accessing'
method: RBLiteralValueNode
stopWithoutParentheses
	^token stop
%

category: 'accessing'
method: RBLiteralValueNode
token
	^token
%

category: 'accessing'
method: RBLiteralValueNode
value
	^token realValue
%

! Class implementation for 'RBMessageNode'

!		Class methods for 'RBMessageNode'

category: 'instance creation'
classmethod: RBMessageNode
receiver: aValueNode selector: aSymbol 
	^self 
		receiver: aValueNode
		selector: aSymbol
		arguments: #()
%

category: 'instance creation'
classmethod: RBMessageNode
receiver: aValueNode selector: aSymbol arguments: valueNodes 
	^(self new)
		receiver: aValueNode;
		arguments: valueNodes;
		selector: aSymbol;
		yourself
%

category: 'instance creation'
classmethod: RBMessageNode
receiver: aValueNode selectorParts: keywordTokens arguments: valueNodes 
	^(self new)
		receiver: aValueNode
			selectorParts: keywordTokens
			arguments: valueNodes;
		yourself
%

!		Instance methods for 'RBMessageNode'

category: 'comparing'
method: RBMessageNode
= anObject 
	self == anObject ifTrue: [^true].
	self class = anObject class ifFalse: [^false].
	(self receiver = anObject receiver 
		and: [self selector = anObject selector]) ifFalse: [^false].
	1 to: self arguments size
		do: [:i | (self arguments at: i) = (anObject arguments at: i) ifFalse: [^false]].
	^true
%

category: 'visitor'
method: RBMessageNode
acceptVisitor: aProgramNodeVisitor 
	^aProgramNodeVisitor acceptMessageNode: self
%

category: 'accessing'
method: RBMessageNode
arguments
	^arguments isNil ifTrue: [#()] ifFalse: [arguments]
%

category: 'accessing'
method: RBMessageNode
arguments: argCollection 
	arguments := argCollection.
	arguments do: [:each | each parent: self]
%

category: 'querying'
method: RBMessageNode
bestNodeFor: anInterval 
	(self intersectsInterval: anInterval) ifFalse: [^nil].
	(self containedBy: anInterval) ifTrue: [^self].
	selectorParts do: 
			[:each | 
			((anInterval first between: each start and: each stop) 
				or: [each start between: anInterval first and: anInterval last]) 
					ifTrue: [^self]].
	self children do: 
			[:each | 
			| node |
			node := each bestNodeFor: anInterval.
			node notNil ifTrue: [^node]]
%

category: 'private'
method: RBMessageNode
buildSelector
	| selectorStream |
	selectorStream := WriteStreamPortable on: String new.
	selectorParts do: [ :each | selectorStream nextPutAll: each value ].
	^ selectorStream contents asSymbol
%

category: 'accessing'
method: RBMessageNode
children
	^(OrderedCollection with: self receiver)
		addAll: self arguments;
		yourself
%

category: 'matching'
method: RBMessageNode
copyInContext: aDictionary 
	^ self class new
		receiver: (self receiver copyInContext: aDictionary);
		selectorParts: (self selectorParts collect: [ :each | each copy removePositions ]);
		arguments: (self arguments collect: [ :each | each copyInContext: aDictionary ]);
		yourself
%

category: 'comparing'
method: RBMessageNode
equalTo: anObject withMapping: aDictionary 
	self class = anObject class ifFalse: [^false].
	((self receiver equalTo: anObject receiver withMapping: aDictionary)
		and: [self selector = anObject selector]) ifFalse: [^false].
	1 to: self arguments size
		do: 
			[:i | 
			((self arguments at: i) equalTo: (anObject arguments at: i)
				withMapping: aDictionary) ifFalse: [^false]].
	^true
%

category: 'comparing'
method: RBMessageNode
hash
	^ (self receiver hash bitXor: self selector hash) bitXor: (self hashForCollection: self arguments)
%

category: 'testing'
method: RBMessageNode
isBinary
	^(self isUnary or: [self isKeyword]) not
%

category: 'testing'
method: RBMessageNode
isCascaded
	^parent notNil and: [parent isCascade]
%

category: 'private-replacing'
method: RBMessageNode
isContainmentReplacement: aNode 
	^(self mappingFor: self receiver) = aNode 
		or: [self arguments anySatisfy: [:each | (self mappingFor: each) = aNode]]
%

category: 'testing'
method: RBMessageNode
isFirstCascaded
	^self isCascaded and: [parent messages first == self]
%

category: 'testing'
method: RBMessageNode
isKeyword
	^selectorParts first value last = $:
%

category: 'testing'
method: RBMessageNode
isMessage
	^true
%

category: 'testing'
method: RBMessageNode
isSelfSend
	^ self receiver isVariable and: [ self receiver name = 'self' ]
%

category: 'testing'
method: RBMessageNode
isSuperSend
	^ self receiver isVariable and: [ self receiver name = 'super' ]
%

category: 'testing'
method: RBMessageNode
isUnary
	^arguments isEmpty
%

category: 'testing'
method: RBMessageNode
lastIsReturn
	^ (#(#ifTrue:ifFalse: #ifFalse:ifTrue: #ifNil:ifNotNil: #ifNotNil:ifNil:) includes: self selector)
		and: [ arguments first isBlock and: [ arguments first body lastIsReturn 
		and: [ arguments last isBlock and: [ arguments last body lastIsReturn ] ] ] ]
%

category: 'matching'
method: RBMessageNode
match: aNode inContext: aDictionary 
	aNode class = self class ifFalse: [^false].
	self selector = aNode selector ifFalse: [^false].
	(receiver match: aNode receiver inContext: aDictionary) ifFalse: [^false].
	1 to: arguments size
		do: 
			[:i | 
			((arguments at: i) match: (aNode arguments at: i) inContext: aDictionary)
				ifFalse: [^false]].
	^true
%

category: 'testing'
method: RBMessageNode
needsParenthesis
	^parent isNil 
		ifTrue: [false]
		ifFalse: 
			[self precedence > parent precedence 
				or: [self precedence = parent precedence and: [self isUnary not]]]
%

category: 'accessing'
method: RBMessageNode
numArgs
	^self selector numArgs
%

category: 'copying'
method: RBMessageNode
postCopy
	super postCopy.
	self receiver: self receiver copy.
	self arguments: (self arguments collect: [ :each | each copy ])
%

category: 'accessing'
method: RBMessageNode
precedence
	^self isUnary 
		ifTrue: [1]
		ifFalse: [self isKeyword ifTrue: [3] ifFalse: [2]]
%

category: 'accessing'
method: RBMessageNode
receiver
	^receiver
%

category: 'accessing'
method: RBMessageNode
receiver: aValueNode 
	receiver := aValueNode.
	receiver parent: self
%

category: 'initialize-release'
method: RBMessageNode
receiver: aValueNode selectorParts: keywordTokens arguments: valueNodes 
	self receiver: aValueNode.
	selectorParts := keywordTokens.
	self arguments: valueNodes
%

category: 'accessing'
method: RBMessageNode
renameSelector: newSelector andArguments: varNodeCollection 
	self
		arguments: varNodeCollection;
		selector: newSelector
%

category: 'private-replacing'
method: RBMessageNode
replaceContainmentSourceWith: aNode 
	| originalNode needsParenthesis |
	needsParenthesis := aNode hasParentheses not and: [aNode needsParenthesis].
	originalNode := (self mappingFor: self receiver) = aNode 
				ifTrue: [self receiver]
				ifFalse: [self arguments detect: [:each | (self mappingFor: each) = aNode]].
	self
		addReplacement: (RBStringReplacement 
					replaceFrom: self start
					to: originalNode start - 1
					with: (needsParenthesis ifTrue: ['('] ifFalse: ['']));
		addReplacement: (RBStringReplacement 
					replaceFrom: originalNode stop + 1
					to: self stop
					with: (needsParenthesis ifTrue: [')'] ifFalse: ['']))
%

category: 'replacing'
method: RBMessageNode
replaceNode: aNode withNode: anotherNode 
	"If we're inside a cascade node and are changing the receiver, change all the receivers"

	receiver == aNode 
		ifTrue: 
			[self receiver: anotherNode.
			(parent notNil and: [parent isCascade]) 
				ifTrue: [parent messages do: [:each | each receiver: anotherNode]]].
	self arguments: (arguments 
				collect: [:each | each == aNode ifTrue: [anotherNode] ifFalse: [each]])
%

category: 'private-replacing'
method: RBMessageNode
replaceSourceWith: aNode 
	(self isContainmentReplacement: aNode) 
		ifTrue: [^self replaceContainmentSourceWith: aNode].
	aNode isMessage ifFalse: [^super replaceSourceWith: aNode].
	^self replaceSourceWithMessageNode: aNode
%

category: 'private-replacing'
method: RBMessageNode
replaceSourceWithMessageNode: aNode 
	| isBinaryToKeyword |
	self numArgs = aNode numArgs ifFalse: [^super replaceSourceWith: aNode].
	self arguments with: aNode arguments
		do: [:old :new | (self mappingFor: old) = new ifFalse: [^super replaceSourceWith: aNode]].
	(self mappingFor: self receiver) = aNode receiver 
		ifFalse:
			[(self receiver isVariable and: [aNode receiver isVariable])
				ifFalse:
					[^super replaceSourceWith: aNode].
			self addReplacement:
				(RBStringReplacement
					replaceFrom: self receiver start
					to: self receiver stop
					with: aNode receiver name)].
	(isBinaryToKeyword := self isBinary and: [aNode isKeyword]) 
		ifTrue: 
			[(self hasParentheses not and: [self parent precedence <= aNode precedence]) 
				ifTrue: 
					[self
						addReplacement: (RBStringReplacement 
									replaceFrom: self start
									to: self start - 1
									with: '(');
						addReplacement: (RBStringReplacement 
									replaceFrom: self stop + 1
									to: self stop
									with: ')')]].
	self selectorParts with: aNode selectorParts
		do: 
			[:old :new | 
			old value ~= new value 
				ifTrue: 
					[self addReplacement: (RBStringReplacement 
								replaceFrom: old start
								to: old stop
								with: ((isBinaryToKeyword 
										and: [(self source at: old start - 1) isSqueakSeparator not]) 
											ifTrue: [' ' , new value]
											ifFalse: [new value]))]]
%

category: 'accessing'
method: RBMessageNode
selector
	^selector isNil
		ifTrue: [selector := self buildSelector]
		ifFalse: [selector]
%

category: 'accessing'
method: RBMessageNode
selector: aSelector 
	| keywords numArgs |
	keywords := aSelector keywords.
	numArgs := aSelector numArgs.
	numArgs == arguments size 
		ifFalse: 
			[self 
				error: 'Attempting to assign selector with wrong number of arguments.'].
	selectorParts := numArgs == 0 
				ifTrue: [Array with: (RBIdentifierToken value: keywords first start: nil)]
				ifFalse: 
					[keywords first last = $: 
						ifTrue: [keywords collect: [:each | RBKeywordToken value: each start: nil]]
						ifFalse: [Array with: (RBBinarySelectorToken value: aSelector start: nil)]].
	selector := aSelector asSymbol
%

category: 'private'
method: RBMessageNode
selectorParts
	^ selectorParts
%

category: 'private'
method: RBMessageNode
selectorParts: tokenCollection 
	selectorParts := tokenCollection
%

category: 'accessing'
method: RBMessageNode
sentMessages
	^ super sentMessages
		add: self selector;
		yourself
%

category: 'accessing'
method: RBMessageNode
startWithoutParentheses
	^receiver start
%

category: 'accessing'
method: RBMessageNode
stopWithoutParentheses
	^arguments isEmpty 
		ifTrue: [selectorParts first stop]
		ifFalse: [arguments last stop]
%

! Class implementation for 'RBPatternMessageNode'

!		Class methods for 'RBPatternMessageNode'

category: 'instance creation'
classmethod: RBPatternMessageNode
receiver: aValueNode selectorParts: keywordTokens arguments: valueNodes 
	^(keywordTokens anySatisfy: [:each | each isPatternVariable]) 
		ifTrue: 
			[super 
				receiver: aValueNode
				selectorParts: keywordTokens
				arguments: valueNodes]
		ifFalse: 
			[RBMessageNode 
				receiver: aValueNode
				selectorParts: keywordTokens
				arguments: valueNodes]
%

!		Instance methods for 'RBPatternMessageNode'

category: 'matching'
method: RBPatternMessageNode
copyInContext: aDictionary 
	| selectors |
	self isList 
		ifTrue: [ ^ aDictionary at: self ].
	selectors := self isSelectorList 
		ifTrue: [ (aDictionary at: selectorParts first value) keywords ]
		ifFalse: [ self selectorParts collect: [ :each | aDictionary at: each value ] ].
	^ RBMessageNode new
		receiver: (self receiver copyInContext: aDictionary);
		selectorParts: (selectors collect: [ :each | 
			(each last = $: ifTrue: [ RBKeywordToken ] ifFalse: [ RBIdentifierToken ]) 
				value: each start: nil ]);
		arguments: (self copyList: self arguments inContext: aDictionary);
		yourself
%

category: 'testing-matching'
method: RBPatternMessageNode
isList
	^isCascadeList and: [parent notNil and: [parent isCascade]]
%

category: 'testing-matching'
method: RBPatternMessageNode
isPatternNode
	^true
%

category: 'testing-matching'
method: RBPatternMessageNode
isSelectorList
	^isList
%

category: 'matching'
method: RBPatternMessageNode
match: aNode inContext: aDictionary 
	aNode class == self matchingClass ifFalse: [^false].
	(receiver match: aNode receiver inContext: aDictionary) ifFalse: [^false].
	self isSelectorList 
		ifTrue: 
			[^(aDictionary at: selectorParts first value ifAbsentPut: [aNode selector]) 
				== aNode selector and: 
						[(aDictionary at: arguments first ifAbsentPut: [aNode arguments]) 
							= aNode arguments]].
	^self matchArgumentsAgainst: aNode inContext: aDictionary
%

category: 'matching'
method: RBPatternMessageNode
matchArgumentsAgainst: aNode inContext: aDictionary 
	self arguments size = aNode arguments size
		ifFalse: [ ^ false ].
	(self matchSelectorAgainst: aNode inContext: aDictionary) 
		ifFalse: [ ^ false ].
	self arguments with: aNode arguments do: [ :first :second |
		(first match: second inContext: aDictionary) 
			ifFalse: [ ^ false ] ].
	^ true
%

category: 'private'
method: RBPatternMessageNode
matchingClass
	^RBMessageNode
%

category: 'matching'
method: RBPatternMessageNode
matchSelectorAgainst: aNode inContext: aDictionary 
	self selectorParts with: aNode selectorParts do: [ :first :second |
		| keyword |
		keyword := aDictionary
			at: first value
			ifAbsentPut: [ 
				first isPatternVariable 
					ifTrue: [ second value ]
					ifFalse: [ first value ] ].
		keyword = second value 
			ifFalse: [ ^ false ] ].
	^ true
%

category: 'initialize-release'
method: RBPatternMessageNode
receiver: aValueNode selectorParts: keywordTokens arguments: valueNodes 
	| message |
	super 
		receiver: aValueNode
		selectorParts: keywordTokens
		arguments: valueNodes.
	isCascadeList := isList := false.
	message := keywordTokens first value.
	2 to: message size
		do: 
			[:i | 
			| character |
			character := message at: i.
			character == self listCharacter 
				ifTrue: [isList := true]
				ifFalse: 
					[character == self cascadeListCharacter 
						ifTrue: [isCascadeList := true]
						ifFalse: [^self]]]
%

category: 'accessing'
method: RBPatternMessageNode
sentMessages
	^ super sentMessages
		remove: self selector ifAbsent: [ ];
		yourself
%

! Class implementation for 'RBVariableNode'

!		Class methods for 'RBVariableNode'

category: 'instance creation'
classmethod: RBVariableNode
identifierToken: anIdentifierToken 
	^(self new)
		identifierToken: anIdentifierToken;
		yourself
%

category: 'instance creation'
classmethod: RBVariableNode
named: aString 
	^self identifierToken: (RBIdentifierToken value: aString start: 0)
%

!		Instance methods for 'RBVariableNode'

category: 'comparing'
method: RBVariableNode
= anObject 
	self == anObject ifTrue: [^true].
	self class = anObject class ifFalse: [^false].
	^self name = anObject name
%

category: 'visitor'
method: RBVariableNode
acceptVisitor: aProgramNodeVisitor 
	^aProgramNodeVisitor acceptVariableNode: self
%

category: 'matching'
method: RBVariableNode
copyInContext: aDictionary 
	^ self class identifierToken: token copy removePositions
%

category: 'comparing'
method: RBVariableNode
equalTo: anObject withMapping: aDictionary 
	^self class = anObject class and: 
			[(aDictionary at: self name ifAbsentPut: [anObject name]) = anObject name]
%

category: 'comparing'
method: RBVariableNode
hash
	^self name hash
%

category: 'initialize-release'
method: RBVariableNode
identifierToken: anIdentifierToken 
	token := anIdentifierToken
%

category: 'testing'
method: RBVariableNode
isImmediateNode
	^true
%

category: 'testing'
method: RBVariableNode
isRead
	^ self isWrite not and: [ self isUsed ]
%

category: 'testing'
method: RBVariableNode
isVariable
	^true
%

category: 'testing'
method: RBVariableNode
isWrite
	^ self parent notNil and: [ self parent isAssignment and: [ self parent variable == self ] ]
%

category: 'accessing'
method: RBVariableNode
name
	^token value
%

category: 'testing'
method: RBVariableNode
needsParenthesis
	^false
%

category: 'accessing'
method: RBVariableNode
precedence
	^0
%

category: 'testing'
method: RBVariableNode
references: aVariableName 
	^self name = aVariableName
%

category: 'replacing'
method: RBVariableNode
replaceSourceFrom: aNode 
	self addReplacement: (RBStringReplacement 
				replaceFrom: aNode start
				to: aNode stop
				with: self name)
%

category: 'replacing'
method: RBVariableNode
replaceSourceWith: aNode
	self addReplacement: (RBStringReplacement 
				replaceFrom: self start
				to: self stop
				with: aNode formattedCode)
%

category: 'accessing'
method: RBVariableNode
startWithoutParentheses
	^token start
%

category: 'accessing'
method: RBVariableNode
stopWithoutParentheses
	^token stop
%

category: 'accessing'
method: RBVariableNode
token
	^ token
%

! Class implementation for 'RBPatternVariableNode'

!		Class methods for 'RBPatternVariableNode'

category: 'instance creation'
classmethod: RBPatternVariableNode
identifierToken: anIdentifierToken 
	^anIdentifierToken isPatternVariable 
		ifTrue: [super identifierToken: anIdentifierToken]
		ifFalse: [RBVariableNode identifierToken: anIdentifierToken]
%

!		Instance methods for 'RBPatternVariableNode'

category: 'matching'
method: RBPatternVariableNode
copyInContext: aDictionary 
	^ (aDictionary at: self) copy
%

category: 'initialize-release'
method: RBPatternVariableNode
identifierToken: anIdentifierToken 
	super identifierToken: anIdentifierToken.
	self initializePatternVariables
%

category: 'initialize-release'
method: RBPatternVariableNode
initializePatternVariables
	| name |
	name := self name.
	isAnything := isList := isLiteral := isStatement := recurseInto := false.
	2 to: name size
		do: 
			[:i | 
			| character |
			character := name at: i.
			character == self listCharacter 
				ifTrue: [isAnything := isList := true]
				ifFalse: 
					[character == self literalCharacter 
						ifTrue: [isLiteral := true]
						ifFalse: 
							[character == self statementCharacter 
								ifTrue: [isStatement := true]
								ifFalse: 
									[character == self recurseIntoCharacter 
										ifTrue: [recurseInto := true]
										ifFalse: [^self]]]]]
%

category: 'testing-matching'
method: RBPatternVariableNode
isAnything
	^isAnything
%

category: 'testing-matching'
method: RBPatternVariableNode
isList
	^isList
%

category: 'testing-matching'
method: RBPatternVariableNode
isLiteralNode
	^isLiteral
%

category: 'testing-matching'
method: RBPatternVariableNode
isPatternNode
	^true
%

category: 'testing-matching'
method: RBPatternVariableNode
isStatement
	^isStatement
%

category: 'matching'
method: RBPatternVariableNode
match: aNode inContext: aDictionary 
	self isAnything 
		ifTrue: [^(aDictionary at: self ifAbsentPut: [aNode]) = aNode].
	self isLiteralNode ifTrue: [^self matchLiteral: aNode inContext: aDictionary].
	self isStatement 
		ifTrue: [^self matchStatement: aNode inContext: aDictionary].
	aNode class == self matchingClass ifFalse: [^false].
	^(aDictionary at: self ifAbsentPut: [aNode]) = aNode
%

category: 'private'
method: RBPatternVariableNode
matchingClass
	^RBVariableNode
%

category: 'matching'
method: RBPatternVariableNode
matchLiteral: aNode inContext: aDictionary 
	^aNode isLiteralNode
		and: [(aDictionary at: self ifAbsentPut: [aNode]) = aNode]
%

category: 'matching'
method: RBPatternVariableNode
matchStatement: aNode inContext: aDictionary 
	(aNode parent notNil and: [aNode parent isSequence]) ifFalse: [^false].
	^(aDictionary at: self ifAbsentPut: [aNode]) = aNode
%

category: 'accessing'
method: RBPatternVariableNode
parent: aBRProgramNode 
	"Fix the case where '``@node' should match a single node, not a sequence node."

	super parent: aBRProgramNode.
	parent isSequence 
		ifTrue: 
			[(self isStatement or: [parent temporaries includes: self]) 
				ifFalse: [isList := false]]
%

category: 'testing-matching'
method: RBPatternVariableNode
recurseInto
	^recurseInto
%

! Class implementation for 'RBWorkspaceNode'

!		Instance methods for 'RBWorkspaceNode'

category: 'comparing'
method: RBWorkspaceNode
= anObject
	self == anObject
		ifTrue: [ ^ true ].
	self class = anObject class
		ifFalse: [ ^ false ].
	self comments = anObject comments
		ifFalse: [ ^ false ].
	self body = anObject body
		ifFalse: [ ^ false ].
	^ true
%

category: 'visitor'
method: RBWorkspaceNode
acceptVisitor: aProgramNodeVisitor
	^ aProgramNodeVisitor acceptWorkspaceNode: self
%

category: 'accessing'
method: RBWorkspaceNode
addNode: aNode
	^ body addNode: aNode
%

category: 'accessing'
method: RBWorkspaceNode
body
	body ifNil: [ body := OrderedCollection new ].
	^ body
%

category: 'accessing'
method: RBWorkspaceNode
body: stmtsNode
	body := stmtsNode.
	body parent: self
%

category: 'accessing'
method: RBWorkspaceNode
children
	^ OrderedCollection new
		add: self body;
		yourself
%

category: 'comparing'
method: RBWorkspaceNode
hash
	^ (self hashForCollection: self comments) bitXor: self body hash
%

category: 'testing'
method: RBWorkspaceNode
isWorkspace
	^ true
%

category: 'accessing'
method: RBWorkspaceNode
methodNode
	^ self
%

category: 'copying'
method: RBWorkspaceNode
postCopy
	super postCopy.
	self body: self body copy
%

category: 'printing'
method: RBWorkspaceNode
printOn: aStream
	aStream nextPutAll: self formattedCode
%

category: 'accessing'
method: RBWorkspaceNode
source
	^ source
%

category: 'accessing'
method: RBWorkspaceNode
source: anObject
	source := anObject
%

category: 'accessing'
method: RBWorkspaceNode
start
	^ 1
%

category: 'accessing'
method: RBWorkspaceNode
stop
	^ source size
%

! Class implementation for 'RBProgramNodeVisitor'

!		Class methods for 'RBProgramNodeVisitor'

category: 'instance creation'
classmethod: RBProgramNodeVisitor
new

	^self basicNew initialize
%

!		Instance methods for 'RBProgramNodeVisitor'

category: 'visitor-double dispatching'
method: RBProgramNodeVisitor
acceptArrayNode: anArrayNode 
	anArrayNode children do: [:each | self visitNode: each]
%

category: 'visitor-double dispatching'
method: RBProgramNodeVisitor
acceptAssignmentNode: anAssignmentNode 
	self visitNode: anAssignmentNode variable.
	self visitNode: anAssignmentNode value
%

category: 'visitor-double dispatching'
method: RBProgramNodeVisitor
acceptBlockNode: aBlockNode 
	self visitArguments: aBlockNode arguments.
	self visitNode: aBlockNode body
%

category: 'visitor-double dispatching'
method: RBProgramNodeVisitor
acceptCascadeNode: aCascadeNode 
	aCascadeNode messages do: [:each | self visitNode: each]
%

category: 'visitor-double dispatching'
method: RBProgramNodeVisitor
acceptLiteralArrayNode: aRBLiteralArrayNode 
	aRBLiteralArrayNode contents do: [:each | self visitNode: each]
%

category: 'visitor-double dispatching'
method: RBProgramNodeVisitor
acceptLiteralNode: aLiteralNode
%

category: 'visitor-double dispatching'
method: RBProgramNodeVisitor
acceptMessageNode: aMessageNode 
	(aMessageNode isCascaded not or: [aMessageNode isFirstCascaded]) 
		ifTrue: [self visitNode: aMessageNode receiver].
	aMessageNode arguments do: [:each | self visitNode: each]
%

category: 'visitor-double dispatching'
method: RBProgramNodeVisitor
acceptMethodNode: aMethodNode 
	self visitArguments: aMethodNode arguments.
	aMethodNode pragmas
		do: [ :each | self visitNode: each ].
	self visitNode: aMethodNode body
%

category: 'visitor-double dispatching'
method: RBProgramNodeVisitor
acceptPatternBlockNode: aRBPatternBlockNode 
	self visitArguments: aRBPatternBlockNode arguments.
	self visitNode: aRBPatternBlockNode body
%

category: 'visitor-double dispatching'
method: RBProgramNodeVisitor
acceptPatternWrapperBlockNode: aRBPatternWrapperBlockNode 
	self visitNode: aRBPatternWrapperBlockNode wrappedNode.
	self visitArguments: aRBPatternWrapperBlockNode arguments.
	self visitNode: aRBPatternWrapperBlockNode body
%

category: 'visitor-double dispatching'
method: RBProgramNodeVisitor
acceptPragmaNode: aPragmaNode
	aPragmaNode arguments do: [ :each | self visitNode: each ]
%

category: 'visitor-double dispatching'
method: RBProgramNodeVisitor
acceptQueryBlockNode: aBlockNode
  self visitArguments: aBlockNode arguments.
  self visitNode: aBlockNode body
%

category: 'visitor-double dispatching'
method: RBProgramNodeVisitor
acceptReturnNode: aReturnNode 
	self visitNode: aReturnNode value
%

category: 'visitor-double dispatching'
method: RBProgramNodeVisitor
acceptSequenceNode: aSequenceNode 
	self visitArguments: aSequenceNode temporaries.
	aSequenceNode statements do: [:each | self visitNode: each]
%

category: 'visitor-double dispatching'
method: RBProgramNodeVisitor
acceptVariableNode: aVariableNode
%

category: 'initialize release'
method: RBProgramNodeVisitor
initialize
%

category: 'visiting'
method: RBProgramNodeVisitor
visitArgument: each 
	"Here to allow subclasses to detect arguments or temporaries."

	^self visitNode: each
%

category: 'visiting'
method: RBProgramNodeVisitor
visitArguments: aNodeCollection 
	^aNodeCollection do: [:each | self visitArgument: each]
%

category: 'visiting'
method: RBProgramNodeVisitor
visitNode: aNode 
	^aNode acceptVisitor: self
%

! Class implementation for 'RBConfigurableFormatter'

!		Class methods for 'RBConfigurableFormatter'

category: 'accessing'
classmethod: RBConfigurableFormatter
cascadedMessageInsideParentheses
	^ CascadedMessageInsideParentheses
%

category: 'accessing'
classmethod: RBConfigurableFormatter
cascadedMessageInsideParentheses: aBoolean
	CascadedMessageInsideParentheses := aBoolean
%

category: 'public'
classmethod: RBConfigurableFormatter
format: aParseTree 
	^self format: aParseTree withIndents: 0
%

category: 'public'
classmethod: RBConfigurableFormatter
format: aParseTree withIndents: anInteger 
	^ self new
		indent: anInteger;
		format: aParseTree
%

category: 'accessing'
classmethod: RBConfigurableFormatter
formatCommentWithStatements
	^ FormatCommentWithStatements
%

category: 'accessing'
classmethod: RBConfigurableFormatter
formatCommentWithStatements: aBoolean
	FormatCommentWithStatements := aBoolean
%

category: 'accessing'
classmethod: RBConfigurableFormatter
indentsForKeywords
	^ IndentsForKeywords
%

category: 'accessing'
classmethod: RBConfigurableFormatter
indentsForKeywords: anInteger
	IndentsForKeywords := anInteger
%

category: 'accessing'
classmethod: RBConfigurableFormatter
indentString
	^ IndentString
%

category: 'accessing'
classmethod: RBConfigurableFormatter
indentString: aString
	IndentString := aString
%

category: 'initialization'
classmethod: RBConfigurableFormatter
initialize
  InQueryBlock := false.
  CascadedMessageInsideParentheses := false.
  FormatCommentWithStatements := true.
  IndentString := '	'.
  IndentsForKeywords := 1.
  KeepBlockInMessage := true.
  LineUpBlockBrackets := false.
  MaxLineLength := 80.
  MethodSignatureOnMultipleLines := false.
  MinimumNewLinesBetweenStatements := 1.
  MultiLineMessages := #(#'ifTrue:ifFalse:' #'ifFalse:ifTrue:' #'ifTrue:' #'ifFalse:' #'on:do:' #'ensure:' #'ifCurtailed:').
  NewLineAfterCascade := true.
  NewLineBeforeFirstCascade := true.
  NewLineBeforeFirstKeyword := false.
  NewLinesAfterMethodComment := 2.
  NewLinesAfterMethodPattern := 1.
  NewLinesAfterTemporaries := 1.
  NumberOfArgumentsForMultiLine := 4.
  OneLineMessages := #(#'to:' #'to:do:' #'to:by:' #'to:by:do:').
  PeriodsAtEndOfBlock := false.
  PeriodsAtEndOfMethod := false.
  RetainBlankLinesBetweenStatements := true.
  StringFollowingReturn := ' '.
  StringInsideBlocks := ' '.
  StringInsideParentheses := ''.
  TraditionalBinaryPrecedence := #(#($| $& $?) #($= $~ $< $>) #($- $+) #($* $/ $% $\) #($@)).
  UseTraditionalBinaryPrecedenceForParentheses := true
%

category: 'accessing'
classmethod: RBConfigurableFormatter
keepBlockInMessage
	^ KeepBlockInMessage
%

category: 'accessing'
classmethod: RBConfigurableFormatter
keepBlockInMessage: aBoolean
	KeepBlockInMessage := aBoolean
%

category: 'accessing'
classmethod: RBConfigurableFormatter
lineUpBlockBrackets
	^ LineUpBlockBrackets
%

category: 'accessing'
classmethod: RBConfigurableFormatter
lineUpBlockBrackets: aBoolean
	LineUpBlockBrackets := aBoolean
%

category: 'accessing'
classmethod: RBConfigurableFormatter
maxLineLength
	^ MaxLineLength
%

category: 'accessing'
classmethod: RBConfigurableFormatter
maxLineLength: anInteger
	MaxLineLength := anInteger
%

category: 'accessing'
classmethod: RBConfigurableFormatter
methodSignatureOnMultipleLines
	^ MethodSignatureOnMultipleLines
%

category: 'accessing'
classmethod: RBConfigurableFormatter
methodSignatureOnMultipleLines: aBoolean
	MethodSignatureOnMultipleLines := aBoolean
%

category: 'accessing'
classmethod: RBConfigurableFormatter
minimumNewLinesBetweenStatements
	^ MinimumNewLinesBetweenStatements
%

category: 'accessing'
classmethod: RBConfigurableFormatter
minimumNewLinesBetweenStatements: anInteger
	MinimumNewLinesBetweenStatements := anInteger
%

category: 'accessing'
classmethod: RBConfigurableFormatter
newLineAfterCascade
	^ NewLineAfterCascade
%

category: 'accessing'
classmethod: RBConfigurableFormatter
newLineAfterCascade: aBoolean
	NewLineAfterCascade := aBoolean
%

category: 'accessing'
classmethod: RBConfigurableFormatter
newLineBeforeFirstCascade
	^ NewLineBeforeFirstCascade
%

category: 'accessing'
classmethod: RBConfigurableFormatter
newLineBeforeFirstCascade: aBoolean
	NewLineBeforeFirstCascade := aBoolean
%

category: 'accessing'
classmethod: RBConfigurableFormatter
newLineBeforeFirstKeyword
	^ NewLineBeforeFirstKeyword
%

category: 'accessing'
classmethod: RBConfigurableFormatter
newLineBeforeFirstKeyword: aBoolean
	NewLineBeforeFirstKeyword := aBoolean
%

category: 'accessing'
classmethod: RBConfigurableFormatter
newLinesAfterMethodComment
	^ NewLinesAfterMethodComment
%

category: 'accessing'
classmethod: RBConfigurableFormatter
newLinesAfterMethodComment: anInteger
	NewLinesAfterMethodComment := anInteger
%

category: 'accessing'
classmethod: RBConfigurableFormatter
newLinesAfterMethodPattern
	^ NewLinesAfterMethodPattern
%

category: 'accessing'
classmethod: RBConfigurableFormatter
newLinesAfterMethodPattern: anInteger
	NewLinesAfterMethodPattern := anInteger
%

category: 'accessing'
classmethod: RBConfigurableFormatter
newLinesAfterTemporaries
	^ NewLinesAfterTemporaries
%

category: 'accessing'
classmethod: RBConfigurableFormatter
newLinesAfterTemporaries: anInteger
	NewLinesAfterTemporaries := anInteger
%

category: 'accessing'
classmethod: RBConfigurableFormatter
numberOfArgumentsForMultiLine
	^ NumberOfArgumentsForMultiLine
%

category: 'accessing'
classmethod: RBConfigurableFormatter
numberOfArgumentsForMultiLine: anInteger
	NumberOfArgumentsForMultiLine := anInteger
%

category: 'accessing'
classmethod: RBConfigurableFormatter
periodsAsTerminators
	^ PeriodsAtEndOfBlock and: [ PeriodsAtEndOfMethod ]
%

category: 'accessing'
classmethod: RBConfigurableFormatter
periodsAsTerminators: aBoolean
	PeriodsAtEndOfBlock := aBoolean.
	PeriodsAtEndOfMethod := aBoolean
%

category: 'accessing'
classmethod: RBConfigurableFormatter
periodsAtEndOfBlock
	^ PeriodsAtEndOfBlock
%

category: 'accessing'
classmethod: RBConfigurableFormatter
periodsAtEndOfBlock: aBoolean
	PeriodsAtEndOfBlock := aBoolean
%

category: 'accessing'
classmethod: RBConfigurableFormatter
periodsAtEndOfMethod
	^ PeriodsAtEndOfMethod
%

category: 'accessing'
classmethod: RBConfigurableFormatter
periodsAtEndOfMethod: aBoolean
	PeriodsAtEndOfMethod := aBoolean
%

category: 'accessing'
classmethod: RBConfigurableFormatter
retainBlankLinesBetweenStatements
	^ RetainBlankLinesBetweenStatements
%

category: 'accessing'
classmethod: RBConfigurableFormatter
retainBlankLinesBetweenStatements: aBoolean
	RetainBlankLinesBetweenStatements := aBoolean
%

category: 'accessing'
classmethod: RBConfigurableFormatter
stringFollowingReturn
	^ StringFollowingReturn
%

category: 'accessing'
classmethod: RBConfigurableFormatter
stringFollowingReturn: aString
	StringFollowingReturn := aString
%

category: 'accessing'
classmethod: RBConfigurableFormatter
stringInsideBlocks
	^ StringInsideBlocks
%

category: 'accessing'
classmethod: RBConfigurableFormatter
stringInsideBlocks: aString
	StringInsideBlocks := aString
%

category: 'accessing'
classmethod: RBConfigurableFormatter
stringInsideParentheses
	^ StringInsideParentheses
%

category: 'accessing'
classmethod: RBConfigurableFormatter
stringInsideParentheses: aString
	StringInsideParentheses := aString
%

category: 'accessing'
classmethod: RBConfigurableFormatter
useTraditionalBinaryPrecedenceForParentheses
	^ UseTraditionalBinaryPrecedenceForParentheses
%

category: 'accessing'
classmethod: RBConfigurableFormatter
useTraditionalBinaryPrecedenceForParentheses: aBoolean
	UseTraditionalBinaryPrecedenceForParentheses := aBoolean
%

!		Instance methods for 'RBConfigurableFormatter'

category: 'visitor-double dispatching'
method: RBConfigurableFormatter
acceptArrayNode: anArrayNode
	self bracketWith: '{}' around: [ self formatArray: anArrayNode ]
%

category: 'visitor-double dispatching'
method: RBConfigurableFormatter
acceptAssignmentNode: anAssignmentNode 
	self visitNode: anAssignmentNode variable.
	codeStream space; nextPutAll: anAssignmentNode assignmentOperator; space.
	self visitNode: anAssignmentNode value
%

category: 'visitor-double dispatching'
method: RBConfigurableFormatter
acceptBlockNode: aBlockNode
	self bracketWith: '[]' around: [self formatBlock: aBlockNode]
%

category: 'visitor-double dispatching'
method: RBConfigurableFormatter
acceptCascadeNode: aCascadeNode 
	self visitNode: aCascadeNode receiver.
	self indentAround: 
			[NewLineBeforeFirstCascade ifTrue: [self newLine] ifFalse: [self space].
			aCascadeNode messages do: 
					[:each | 
					self indentAround: 
							[self 
								formatSelectorAndArguments: each
								firstSeparator: []
								restSeparator: ((self isMultiLineMessage: each) 
										ifTrue: [[self newLine]]
										ifFalse: [[self space]])]]
				separatedBy: 
					[codeStream nextPut: $;.
					NewLineAfterCascade ifTrue: [self newLine] ifFalse: [self space]]]
%

category: 'visitor-double dispatching'
method: RBConfigurableFormatter
acceptLiteralArrayNode: aRBArrayLiteralNode 
	| brackets |
	codeStream nextPut: $#.
	brackets := aRBArrayLiteralNode isForByteArray 
				ifTrue: ['[]']
				ifFalse: ['()'].
	self bracketWith: brackets
		around: 
			[aRBArrayLiteralNode contents do: [:each | self visitNode: each]
				separatedBy: [self space]]
%

category: 'visitor-double dispatching'
method: RBConfigurableFormatter
acceptLiteralNode: aLiteralNode 
	self writeString: aLiteralNode token rbStoreString
%

category: 'visitor-double dispatching'
method: RBConfigurableFormatter
acceptMessageNode: aMessageNode 
	self visitNode: aMessageNode receiver.
	self formatSelectorAndArguments: aMessageNode
%

category: 'visitor-double dispatching'
method: RBConfigurableFormatter
acceptMethodNode: aMethodNode 
	self formatMethodPatternFor: aMethodNode.
	self formatMethodBodyFor: aMethodNode
%

category: 'visitor-double dispatching'
method: RBConfigurableFormatter
acceptPatternBlockNode: aRBPatternBlockNode 
	codeStream nextPut: $`.
	self 
		bracketWith: '{}' 
		around: [self formatBlock: aRBPatternBlockNode]
%

category: 'visitor-double dispatching'
method: RBConfigurableFormatter
acceptPatternWrapperBlockNode: aRBPatternWrapperBlockNode
	self visitNode: aRBPatternWrapperBlockNode wrappedNode.
	codeStream nextPut: $`.
	self 
		bracketWith: '{}' 
		around: [self formatBlock: aRBPatternWrapperBlockNode]
%

category: 'visitor-double dispatching'
method: RBConfigurableFormatter
acceptPragmaNode: aPragmaNode
  codeStream nextPut: $<.
  aPragmaNode isProtected
    ifTrue: [ codeStream nextPutAll: 'protected ' ].
  self
    formatSelectorAndArguments: aPragmaNode
    firstSeparator: [ 
      aPragmaNode selector isInfix
        ifTrue: [ self space ] ]
    restSeparator: [ self space ].
  codeStream nextPut: $>
%

category: 'visitor-double dispatching'
method: RBConfigurableFormatter
acceptQueryBlockNode: aBlockNode
  self
    bracketWith: '{}'
    around: [ 
      [ 
      "query blocks are not nested"
      InQueryBlock := true.
      self formatBlock: aBlockNode ]
        ensure: [ InQueryBlock := false ] ]
%

category: 'visitor-double dispatching'
method: RBConfigurableFormatter
acceptReturnNode: aReturnNode 
	codeStream
		nextPut: $^;
		nextPutAll: StringFollowingReturn.
	self visitNode: aReturnNode value
%

category: 'visitor-double dispatching'
method: RBConfigurableFormatter
acceptSequenceNode: aSequenceNode 
	self formatTemporariesFor: aSequenceNode.
	self formatSequenceCommentsFor: aSequenceNode.
	self formatSequenceNodeStatementsFor: aSequenceNode
%

category: 'visitor-double dispatching'
method: RBConfigurableFormatter
acceptVariableNode: aVariableNode 
	codeStream nextPutAll: aVariableNode name
%

category: 'visitor-double dispatching'
method: RBConfigurableFormatter
acceptWorkspaceNode: aWorkspaceNode
	self
		indentAround: [ 
			self formatMethodCommentFor: aWorkspaceNode.
			self visitNode: aWorkspaceNode body ]
%

category: 'private'
method: RBConfigurableFormatter
addNewLinesBeforeStatementStartingAt: anInteger 
	| newLines |
	newLines := MinimumNewLinesBetweenStatements 
				max: (RetainBlankLinesBetweenStatements 
						ifTrue: [self newLinesBeforeStartingAt: anInteger]
						ifFalse: [0]).
	newLines = 0 ifTrue: [self space] ifFalse: [self newLines: newLines]
%

category: 'private'
method: RBConfigurableFormatter
bracketWith: bracketString around: aBlock 
	bracketString isEmpty ifTrue: [^aBlock value].
	codeStream nextPut: bracketString first.
	^aBlock ensure: [codeStream nextPut: bracketString last]
%

category: 'private'
method: RBConfigurableFormatter
currentLineLength
	^codeStream position - lineStart
%

category: 'public interface'
method: RBConfigurableFormatter
format: aParseTree 
	originalSource := aParseTree source.
	self visitNode: aParseTree.
	^codeStream contents
%

category: 'private-formatting'
method: RBConfigurableFormatter
formatArray: anArrayNode
	self formatSequenceCommentsFor: anArrayNode.
	self formatSequenceNodeStatementsFor: anArrayNode
%

category: 'private-formatting'
method: RBConfigurableFormatter
formatBlock: aBlockNode
	(LineUpBlockBrackets and: [ self willBeMultiline: aBlockNode body ])
		ifTrue: [ self newLine ]
		ifFalse: [ codeStream nextPutAll: StringInsideBlocks ].
	self formatBlockArgumentsFor: aBlockNode.
	(self willBeMultiline: aBlockNode body)
		ifTrue: [ self newLine ].
	self visitNode: aBlockNode body.
	(LineUpBlockBrackets and: [ self willBeMultiline: aBlockNode body ])
		ifTrue: [ self newLine ]
		ifFalse: [ codeStream nextPutAll: StringInsideBlocks ]
%

category: 'private-formatting'
method: RBConfigurableFormatter
formatBlockArgumentsFor: aBlockNode
	aBlockNode arguments isEmpty
		ifTrue: [ ^ self ].
	aBlockNode arguments
		do: [ :each | 
			codeStream nextPut: $:.
			self visitNode: each.
			FormatCommentWithStatements
				ifTrue: [ self formatCommentsFor: each ].
			self space ].
	codeStream nextPutAll: '| '
%

category: 'private-formatting'
method: RBConfigurableFormatter
formatCommentsFor: aNode 
	originalSource isNil ifTrue: [^self].
	aNode comments do: 
			[:each | 
			codeStream
				space;
				nextPutAll: (originalSource copyFrom: each first to: each last)]
%

category: 'private-formatting'
method: RBConfigurableFormatter
formatMethodBodyFor: aMethodNode 
	self
		indentAround: 
			[self newLines: NewLinesAfterMethodPattern.
			self formatMethodCommentFor: aMethodNode.
			self formatPragmasFor: aMethodNode.
			self visitNode: aMethodNode body]
%

category: 'private-formatting'
method: RBConfigurableFormatter
formatMethodCommentFor: aMethodNode
	originalSource isNil ifTrue: [^self].
	(FormatCommentWithStatements
		ifTrue: [aMethodNode methodComments]
		ifFalse: [aMethodNode comments])
		do:
			[:each | 
			codeStream
				nextPutAll:
					(originalSource
						copyFrom: each first
						to: each last).
			self newLines: NewLinesAfterMethodComment]
%

category: 'private-formatting'
method: RBConfigurableFormatter
formatMethodPatternFor: aMethodNode 
	aMethodNode arguments isEmpty
		ifTrue: [codeStream nextPutAll: aMethodNode selector]
		ifFalse: 
			[self
				with: aMethodNode selectorParts
				and: aMethodNode arguments
				do: 
					[:key :arg | 
					codeStream nextPutAll: key value.
					self space.
					self visitNode: arg]
				separatedBy: 
					[MethodSignatureOnMultipleLines
						ifTrue: [self newLine]
						ifFalse: [self space]]]
%

category: 'private-formatting'
method: RBConfigurableFormatter
formatPragmasFor: aMethodNode
	aMethodNode pragmas do: [ :each | self visitNode: each; newLine ]
%

category: 'private-formatting'
method: RBConfigurableFormatter
formatSelectorAndArguments: aMessageNode
	| newLineBetweenArguments |
	newLineBetweenArguments := self isMultiLineMessage: aMessageNode.
	self
		indent:
			(newLineBetweenArguments
				ifTrue: [ IndentsForKeywords ]
				ifFalse: [ 0 ])
		around: [ 
			self
				formatSelectorAndArguments: aMessageNode
				firstSeparator:
					((newLineBetweenArguments or: [ NewLineBeforeFirstKeyword ])
						ifTrue: [ [ self newLine ] ]
						ifFalse: [ [ self space ] ])
				restSeparator:
					(newLineBetweenArguments
						ifTrue: [ [ self newLine ] ]
						ifFalse: [ [ self space ] ]) ]
%

category: 'private-formatting'
method: RBConfigurableFormatter
formatSelectorAndArguments: aMessageNode firstSeparator: firstBlock restSeparator: restBlock
	| separatorBlock |
	separatorBlock := firstBlock.
	aMessageNode isUnary
		ifTrue: [ 
			(self isLineTooLong: aMessageNode selector)
				ifTrue: [ self newLine ]
				ifFalse: [ separatorBlock value ].
			codeStream nextPutAll: aMessageNode selector ]
		ifFalse: [ 
			aMessageNode selectorParts
				with: aMessageNode arguments
				do: [ :selector :argument | 
					(self isLineTooLong: selector value)
						ifTrue: [ self newLine ]
						ifFalse: [ separatorBlock value ].
					separatorBlock := restBlock.
					self
						indentAround: [ 
							codeStream nextPutAll: selector value.
							(KeepBlockInMessage and: [ argument isBlock ])
								ifTrue: [ 
									self
										space;
										visitNode: argument ]
								ifFalse: [ 
									((self willBeMultiline: argument) or: [ self isLineTooLong: (self formattedSourceFor: argument) ])
										ifTrue: [ self newLine ]
										ifFalse: [ self space ].
									self visitNode: argument ] ] ] ]
%

category: 'private-formatting'
method: RBConfigurableFormatter
formatSequenceCommentsFor: aSequenceNode
	originalSource isNil ifTrue: [^self].
	aSequenceNode comments
		do:
			[:each | 
			codeStream
				nextPutAll:
					(originalSource
						copyFrom: each first
						to: each last).
			self newLine]
%

category: 'private-formatting'
method: RBConfigurableFormatter
formatSequenceNodeStatementsFor: aSequenceNode 
	| statements |
	statements := aSequenceNode statements.
	statements isEmpty ifTrue: [^self].
	1 to: statements size
		do: 
			[:i | 
			self visitNode: (statements at: i).
			(i < statements size or: 
					[| parent |
					(parent := aSequenceNode parent) ifNil: [self class periodsAsTerminators]
						ifNotNil: 
							[ 
							parent isBlock 
								ifTrue: [self class periodsAtEndOfBlock]
								ifFalse: [self class periodsAtEndOfMethod]]]) 
				ifTrue: [codeStream nextPut: $.].
			self formatStatementCommentsFor: (statements at: i).
			i < statements size 
				ifTrue: 
					[self addNewLinesBeforeStatementStartingAt: (statements at: i + 1) start]]
%

category: 'private-formatting'
method: RBConfigurableFormatter
formatStatementCommentsFor: aStatementNode
	originalSource isNil ifTrue: [^self].
	FormatCommentWithStatements ifFalse: [^self].
	aStatementNode statementComments
		do:
			[:each | 
			codeStream
				tab;
				nextPutAll:
						(originalSource
								copyFrom: each first
								to: each last)]
%

category: 'private'
method: RBConfigurableFormatter
formattedSourceFor: aNode 
	^lookaheadCode at: aNode
		ifAbsentPut: [self class format: aNode withIndents: indent]
%

category: 'private'
method: RBConfigurableFormatter
formatTemporariesFor: aSequenceNode
	aSequenceNode temporaries isEmpty ifTrue: [^self].
	self
		bracketWith: '|'
		around:
			[self space.
			aSequenceNode temporaries
				do:
					[:each | 
					self visitNode: each.
					FormatCommentWithStatements ifTrue: [self formatCommentsFor: each].
					self space]].
	self newLines: NewLinesAfterTemporaries
%

category: 'initialize-release'
method: RBConfigurableFormatter
indent: anInteger
	indent := anInteger
%

category: 'private'
method: RBConfigurableFormatter
indent: anInteger around: aBlock 
	indent := indent + anInteger.
	^aBlock ensure: [indent := indent - anInteger]
%

category: 'private'
method: RBConfigurableFormatter
indentAround: aBlock 
	self indent: 1 around: aBlock
%

category: 'initialize-release'
method: RBConfigurableFormatter
initialize
	super initialize.
	lineStart := 0.
	indent := 0.
	lookaheadCode := IdentityDictionary new.
	codeStream := WriteStreamPortable on: String new
%

category: 'private'
method: RBConfigurableFormatter
isLineTooLong: aString 
	^ self currentLineLength + (aString indexOf: Character lf ifAbsent: [ aString size ]) >= MaxLineLength
%

category: 'private-formatting'
method: RBConfigurableFormatter
isMultiLineMessage: aMessageNode
	| messageStream |
	(MultiLineMessages includes: aMessageNode selector)
		ifTrue: [ ^ true ].
	(OneLineMessages includes: aMessageNode selector)
		ifTrue: [ ^ false ].
	(NumberOfArgumentsForMultiLine <= aMessageNode arguments size)
		ifTrue: [ ^ true ].
	(aMessageNode arguments 
		anySatisfy: [ :each | self indent: IndentsForKeywords + 1 around: [ self willBeMultiline: each ] ]) 
		ifTrue: [ ^ true ].
	aMessageNode isUnary
		ifTrue: [ ^ self isLineTooLong: aMessageNode selector ].
	messageStream := WriteStreamPortable on: String new.
	self  with: aMessageNode selectorParts and: aMessageNode arguments 
		do: [ :sel :arg | messageStream nextPutAll: sel value; space; nextPutAll: (self formattedSourceFor: arg) ]
		separatedBy: [ messageStream space ].
	^ self isLineTooLong: messageStream contents
%

category: 'private'
method: RBConfigurableFormatter
needsParenthesisFor: aNode
  | parent grandparent |
  aNode isValue
    ifFalse: [ ^ false ].
  parent := aNode parent ifNil: [ ^ false ].
  (CascadedMessageInsideParentheses
    and: [ aNode isMessage and: [ parent isMessage and: [ parent receiver == aNode ] ] ])
    ifTrue: [ 
      grandparent := parent parent.
      (grandparent notNil and: [ grandparent isCascade ])
        ifTrue: [ ^ true ] ].
  InQueryBlock
    ifTrue: [ 
      aNode isVariable
        ifTrue: [ 
          (aNode token isPath
            and: [ 
              parent isMessage
                and: [ parent receiver == aNode and: [ aNode parent selector == #'&' ] ] ])
            ifTrue: [ ^ true ] ] ].
  aNode precedence < parent precedence
    ifTrue: [ ^ false ].
  (aNode isAssignment and: [ parent isAssignment ])
    ifTrue: [ ^ false ].
  (aNode isAssignment and: [ aNode isCascade ])
    ifTrue: [ ^ true ].
  aNode precedence = 0
    ifTrue: [ ^ false ].
  aNode isMessage
    ifFalse: [ ^ true ].
  aNode precedence = parent precedence
    ifFalse: [ ^ true ].
  aNode isUnary
    ifTrue: [ ^ false ].
  aNode isKeyword
    ifTrue: [ ^ true ].
  parent receiver == aNode
    ifFalse: [ ^ true ].
  InQueryBlock
    ifTrue: [ ^ aNode receiver isMessage not and: [ aNode selector ~~ #'&' ] ].
  ^ UseTraditionalBinaryPrecedenceForParentheses
    and: [ self precedenceOf: parent selector greaterThan: aNode selector ]
%

category: 'private'
method: RBConfigurableFormatter
newLine
	self newLines: 1
%

category: 'private'
method: RBConfigurableFormatter
newLines: anInteger 
	anInteger + IndentString size = 0 ifTrue: [codeStream space].
	anInteger timesRepeat: [codeStream lf].
	lineStart := codeStream position.
	indent timesRepeat: [codeStream nextPutAll: IndentString]
%

category: 'private'
method: RBConfigurableFormatter
newLinesBeforeStartingAt: anIndex 
	| count cr lf index char |
	(anIndex isNil or: [anIndex > originalSource size]) ifTrue: [^0].
	cr := Character codePoint: 13.
	lf := Character codePoint: 10.
	count := 0.
	index := anIndex - 1.
	[index > 0 and: [(char := originalSource at: index) isSeparator]] 
		whileTrue: 
			[char == lf 
				ifTrue: 
					[count := count + 1.
					(originalSource at: (index - 1 max: 1)) == cr ifTrue: [index := index - 1]].
			char == cr ifTrue: [count := count + 1].
			index := index - 1].
	^count
%

category: 'private'
method: RBConfigurableFormatter
precedenceOf: parentSelector greaterThan: childSelector 
	"Put parenthesis around things that are preceived to have 'lower' precedence. For example, 'a + b * c' 
	-> '(a + b) * c' but 'a * b + c' -> 'a * b + c'"

	| childIndex parentIndex |
	childIndex := 0.
	parentIndex := 0.
	1 to: TraditionalBinaryPrecedence size
		do: 
			[:i | 
			((TraditionalBinaryPrecedence at: i) includes: parentSelector first) 
				ifTrue: [parentIndex := i].
			((TraditionalBinaryPrecedence at: i) includes: childSelector first) 
				ifTrue: [childIndex := i]].
	^childIndex < parentIndex
%

category: 'private'
method: RBConfigurableFormatter
space
	codeStream space
%

category: 'visiting'
method: RBConfigurableFormatter
visitNode: aNode
	| needsParenthesis |
	(lookaheadCode includesKey: aNode)
		ifTrue: [^self writeString: (lookaheadCode at: aNode)].
	needsParenthesis := self needsParenthesisFor: aNode.
	self
		bracketWith:
			(needsParenthesis
				ifTrue: ['()']
				ifFalse: [''])
		around:
			[needsParenthesis ifTrue: [codeStream nextPutAll: StringInsideParentheses].
			super visitNode: aNode.
			(FormatCommentWithStatements or: [aNode isMethod or: [aNode isSequence]])
				ifFalse: [self formatCommentsFor: aNode].
			needsParenthesis
				ifTrue: [codeStream nextPutAll: StringInsideParentheses]]
%

category: 'private'
method: RBConfigurableFormatter
willBeMultiline: aNode 
	^(self formattedSourceFor: aNode) includes: Character lf
%

category: 'utility'
method: RBConfigurableFormatter
with: firstCollection and: secondCollection do: aBlock separatedBy: separatorBlock 
	firstCollection isEmpty ifTrue: [^self].
	aBlock
		value: firstCollection first
		value: secondCollection first.
	2
		to: firstCollection size
		do: 
			[:i | 
			separatorBlock value.
			aBlock
				value: (firstCollection at: i)
				value: (secondCollection at: i)]
%

category: 'private'
method: RBConfigurableFormatter
writeString: aString 
	| index |
	index := aString lastIndexOf: Character lf startingAt: aString size ifAbsent: [0].
	codeStream nextPutAll: aString.
	index > 0 
		ifTrue: [lineStart := codeStream position - (aString size - index)]
%

! Class implementation for 'RBFormatter'

!		Instance methods for 'RBFormatter'

category: 'visitor-double dispatching'
method: RBFormatter
acceptArrayNode: anArrayNode
	codeStream nextPut: ${.
	anArrayNode statements isEmpty ifFalse: [
		anArrayNode statements size > 1
			ifTrue: [
				self indent: 1 while: [
					self indent.
					self formatStatementsFor: anArrayNode ].
				self indent ]
			ifFalse: [ self formatStatementsFor: anArrayNode ] ].
	codeStream nextPut: $}
%

category: 'visitor-double dispatching'
method: RBFormatter
acceptAssignmentNode: anAssignmentNode 
	self indent: 2
		while: 
			[self visitNode: anAssignmentNode variable.
			codeStream space; nextPutAll: anAssignmentNode assignmentOperator; space.
			self visitNode: anAssignmentNode value]
%

category: 'visitor-double dispatching'
method: RBFormatter
acceptBlockNode: aBlockNode 
	self 
		acceptBlockNode: aBlockNode
		startBlockString: '['
		endBlockString: ']'
%

category: 'visitor-double dispatching'
method: RBFormatter
acceptBlockNode: aBlockNode startBlockString: startBlockString endBlockString: endBlockString 
	| seqNode multiline formattedBody formatter |
	seqNode := aBlockNode body.
	formatter := (self copy)
				lineStart: 0;
				yourself.
	formattedBody := formatter format: seqNode.
	multiline := self lineLength + formattedBody size > self maxLineSize 
				or: [formatter isMultiLine].
	multiline ifTrue: [self indent].
	codeStream nextPutAll: startBlockString.
	aBlockNode arguments do: 
			[:each | 
			codeStream nextPut: $:.
			self visitNode: each.
			codeStream nextPut: $ ].
	aBlockNode arguments notEmpty 
		ifTrue: 
			[codeStream nextPutAll: '| '.
			multiline ifTrue: [self indent]].
	codeStream
		nextPutAll: formattedBody;
		nextPutAll: endBlockString
%

category: 'visitor-double dispatching'
method: RBFormatter
acceptCascadeNode: aCascadeNode 
	| messages |
	messages := aCascadeNode messages.
	self visitNode: messages first receiver.
	self indentWhile: 
			[self 
				for: messages
				do: 
					[:each | 
					self
						indent;
						indentWhile: [self formatMessage: each cascade: true]]
				separatedBy: [codeStream nextPut: $;]]
%

category: 'visitor-double dispatching'
method: RBFormatter
acceptLiteralArrayNode: aRBArrayLiteralNode 
	codeStream nextPutAll: (aRBArrayLiteralNode isForByteArray 
				ifTrue: ['#[']
				ifFalse: ['#(']).
	self 
		for: aRBArrayLiteralNode contents
		do: [:each | self visitNode: each]
		separatedBy: [codeStream nextPut: $ ].
	codeStream 
		nextPut: (aRBArrayLiteralNode isForByteArray ifTrue: [$]] ifFalse: [$)])
%

category: 'visitor-double dispatching'
method: RBFormatter
acceptLiteralNode: aLiteralNode 
	aLiteralNode token rbStoreOn: codeStream
%

category: 'visitor-double dispatching'
method: RBFormatter
acceptMessageNode: aMessageNode 
	| newFormatter code |
	newFormatter := self copy.
	code := newFormatter format: aMessageNode receiver.
	codeStream nextPutAll: code.
	codeStream nextPut: $ .
	newFormatter isMultiLine
		ifTrue: [lineStart := codeStream position - newFormatter lastLineLength].
	self indent: (newFormatter isMultiLine ifTrue: [2] ifFalse: [1])
		while: [self formatMessage: aMessageNode cascade: false]
%

category: 'visitor-double dispatching'
method: RBFormatter
acceptMethodNode: aMethodNode 
	self formatMethodPatternFor: aMethodNode.
	self indentWhile: [
		self formatMethodCommentFor: aMethodNode indentBefore: true.
		self indent.
		self formatPragmasFor: aMethodNode.
		aMethodNode body statements notEmpty 
			ifTrue: [ self visitNode: aMethodNode body ] ]
%

category: 'visitor-double dispatching'
method: RBFormatter
acceptPatternBlockNode: aRBPatternBlockNode 
	self 
		acceptBlockNode: aRBPatternBlockNode
		startBlockString: '`{'
		endBlockString: '}'
%

category: 'visitor-double dispatching'
method: RBFormatter
acceptPatternWrapperBlockNode: aRBPatternWrapperBlockNode 
	self visitNode: aRBPatternWrapperBlockNode wrappedNode.
	self 
		acceptBlockNode: aRBPatternWrapperBlockNode
		startBlockString: '`{'
		endBlockString: '}'
%

category: 'visitor-double dispatching'
method: RBFormatter
acceptPragmaNode: aPragmaNode
  codeStream nextPut: $<.
  aPragmaNode isProtected
    ifTrue: [ codeStream nextPutAll: 'protected ' ].
  aPragmaNode selector isInfix
    ifTrue: [ codeStream nextPut: $  ].
  self formatMessage: aPragmaNode cascade: false.
  codeStream nextPut: $>
%

category: 'visitor-double dispatching'
method: RBFormatter
acceptQueryBlockNode: aBlockNode
  [ 
  inQueryBlock := true.
  self
    acceptQueryBlockNode: aBlockNode
    startBlockString: '{'
    endBlockString: '}' ]
    ensure: [ inQueryBlock := false ]
%

category: 'visitor-double dispatching'
method: RBFormatter
acceptQueryBlockNode: aBlockNode startBlockString: startBlockString endBlockString: endBlockString
  | seqNode multiline formattedBody formatter |
  seqNode := aBlockNode body.
  formatter := self copy
    lineStart: 0;
    yourself.
  formattedBody := formatter format: seqNode.
  multiline := self lineLength + formattedBody size > self maxLineSize
    or: [ formatter isMultiLine ].
  multiline
    ifTrue: [ self indent ].
  codeStream nextPutAll: startBlockString.
  aBlockNode arguments
    do: [ :each | 
      codeStream nextPut: $:.
      self visitNode: each.
      codeStream nextPut: $  ].
  aBlockNode arguments notEmpty
    ifTrue: [ 
      codeStream nextPutAll: '| '.
      multiline
        ifTrue: [ self indent ] ].
  codeStream
    nextPutAll: formattedBody;
    nextPutAll: endBlockString
%

category: 'visitor-double dispatching'
method: RBFormatter
acceptReturnNode: aReturnNode 
	codeStream nextPut: $^.
	self visitNode: aReturnNode value
%

category: 'visitor-double dispatching'
method: RBFormatter
acceptSequenceNode: aSequenceNode 
	self formatMethodCommentFor: aSequenceNode indentBefore: false.
	self formatTemporariesFor: aSequenceNode.
	self formatStatementsFor: aSequenceNode
%

category: 'visitor-double dispatching'
method: RBFormatter
acceptVariableNode: aVariableNode 
	codeStream nextPutAll: aVariableNode name
%

category: 'accessing'
method: RBFormatter
firstLineLength
	^firstLineLength isNil
		ifTrue: [codeStream position]
		ifFalse: [firstLineLength]
%

category: 'private'
method: RBFormatter
for: aValue do: doBlock separatedBy: separatorBlock 
	"This is implemented here since IBM Smalltalk doesn't implement a do:separatedBy: method"

	aValue isEmpty ifTrue: [^self].
	1 to: aValue size - 1
		do: 
			[:i | 
			doBlock value: (aValue at: i).
			separatorBlock value].
	doBlock value: aValue last
%

category: 'accessing'
method: RBFormatter
format: aNode 
	self visitNode: aNode.
	^codeStream contents
%

category: 'private-formatting'
method: RBFormatter
formatMessage: aMessageNode cascade: cascadeBoolean 
	| selectorParts arguments multiLine formattedArgs indentFirst firstArgLength length |
	selectorParts := aMessageNode selectorParts.
	arguments := aMessageNode arguments.
	formattedArgs := OrderedCollection new.
	multiLine := aMessageNode selector numArgs > self maximumArgumentsPerLine.
	length := aMessageNode selector size + arguments size + 1.
	firstArgLength := 0.
	self indentWhile: 
			[1 to: arguments size
				do: 
					[:i | 
					| formatter string |
					formatter := (self copy)
								lineStart: (selectorParts at: i) length negated;
								yourself.
					string := formatter format: (arguments at: i).
					formattedArgs add: string.
					i == 1 ifTrue: [firstArgLength := formatter firstLineLength].
					length := length + string size.
					multiLine := multiLine or: [formatter isMultiLine]]].
	multiLine := multiLine or: [length + self lineLength > self maxLineSize].
	indentFirst := cascadeBoolean not and: 
					[multiLine and: 
							[(self startMessageSendOnNewLine: aMessageNode) or: 
									[self lineLength + selectorParts first length + 2 + firstArgLength 
										> self maxLineSize]]].
	indentFirst ifTrue: [self indent].
	self 
		formatMessageSelector: selectorParts
		withArguments: formattedArgs
		multiline: multiLine
%

category: 'private-formatting'
method: RBFormatter
formatMessageSelector: selectorParts withArguments: formattedArgs multiline: multiLine 
	formattedArgs isEmpty 
		ifTrue: [codeStream nextPutAll: selectorParts first value]
		ifFalse: 
			[1 to: formattedArgs size
				do: 
					[:i | 
					(i ~= 1 and: [ multiLine not ])
						ifTrue: [codeStream nextPut: $ ].
					codeStream 
						nextPutAll: (selectorParts at: i) value;
						nextPut: $ ;
						nextPutAll: (formattedArgs at: i).
					(multiLine and: [i < formattedArgs size]) ifTrue: [self indent]]]
%

category: 'private-formatting'
method: RBFormatter
formatMethodCommentFor: aNode indentBefore: aBoolean 
	| source |
	source := aNode source.
	source isNil ifTrue: [^self].
	aNode methodComments do: 
			[:each | 
			aBoolean ifTrue: [self indent].
			codeStream
				nextPutAll: (aNode source copyFrom: each first to: each last);
				lf.
			aBoolean ifFalse: [self indent]]
%

category: 'private-formatting'
method: RBFormatter
formatMethodPatternFor: aMethodNode 
	| selectorParts arguments |
	selectorParts := aMethodNode selectorParts.
	arguments := aMethodNode arguments.
	arguments isEmpty 
		ifTrue: [codeStream nextPutAll: selectorParts first value]
		ifFalse: 
			[selectorParts with: arguments
				do: 
					[:selector :arg | 
					codeStream
						nextPutAll: selector value;
						nextPut: $ .
					self visitArgument: arg.
					codeStream nextPut: $ ]]
%

category: 'private-formatting'
method: RBFormatter
formatPragmasFor: aNode
	aNode pragmas do: [ :each | self visitNode: each; indent ]
%

category: 'private-formatting'
method: RBFormatter
formatStatementCommentFor: aNode 
	| source |
	source := aNode source.
	source isNil ifTrue: [^self].
	aNode statementComments do: 
			[:each | 
			| crs |
			crs := self newLinesFor: source startingAt: each first.
			(crs - 1 max: 0) timesRepeat: [codeStream lf].
			crs == 0 ifTrue: [codeStream tab] ifFalse: [self indent].
			codeStream nextPutAll: (source copyFrom: each first to: each last)]
%

category: 'private-formatting'
method: RBFormatter
formatStatementsFor: aSequenceNode 
	| statements |
	statements := aSequenceNode statements.
	statements isEmpty ifTrue: [^self].
	1 to: statements size - 1
		do: 
			[:i | 
			self visitNode: (statements at: i).
			codeStream nextPut: $..
			self formatStatementCommentFor: (statements at: i).
			self indent].
	self visitNode: statements last.
	self formatStatementCommentFor: statements last
%

category: 'private-formatting'
method: RBFormatter
formatTemporariesFor: aSequenceNode 
	| temps |
	temps := aSequenceNode temporaries.
	temps isEmpty ifTrue: [^self].
	codeStream nextPutAll: '| '.
	temps do: 
			[:each | 
			self visitArgument: each.
			codeStream nextPut: $ ].
	codeStream nextPut: $|.
	self indent
%

category: 'private'
method: RBFormatter
indent
	firstLineLength isNil ifTrue: [firstLineLength := codeStream position].
	codeStream lf.
	tabs timesRepeat: [codeStream tab].
	lineStart := codeStream position
%

category: 'private'
method: RBFormatter
indent: anInteger while: aBlock 
	tabs := tabs + anInteger.
	aBlock value.
	tabs := tabs - anInteger
%

category: 'private'
method: RBFormatter
indentWhile: aBlock 
	self indent: 1 while: aBlock
%

category: 'initialize-release'
method: RBFormatter
initialize
  super initialize.
  codeStream := WriteStreamPortable on: String new.
  tabs := 0.
  lineStart := 0.
  inQueryBlock := false
%

category: 'accessing'
method: RBFormatter
isMultiLine
	^firstLineLength notNil
%

category: 'accessing'
method: RBFormatter
lastLineLength
	^codeStream position - (lineStart max: 0)
%

category: 'private'
method: RBFormatter
lineLength
	^codeStream position - lineStart
%

category: 'private'
method: RBFormatter
lineStart: aPosition 
	lineStart := aPosition
%

category: 'private'
method: RBFormatter
maximumArgumentsPerLine
	^2
%

category: 'private'
method: RBFormatter
maxLineSize
	^75
%

category: 'private'
method: RBFormatter
needsParenthesisFor: aNode
  | parent grandparent |
  aNode isValue
    ifFalse: [ ^ false ].
  parent := aNode parent ifNil: [ ^ false ].
  (aNode isMessage and: [ parent isMessage and: [ parent receiver == aNode ] ])
    ifTrue: [ 
      grandparent := parent parent.
      (grandparent notNil and: [ grandparent isCascade ])
        ifTrue: [ ^ true ] ].
  inQueryBlock
    ifTrue: [ 
      aNode isLiteralNode
        ifTrue: [ 
          (parent isMessage
            and: [ parent receiver == aNode and: [ aNode parent selector == #'&' ] ])
            ifTrue: [ ^ true ] ].
      aNode isVariable
        ifTrue: [ 
          (aNode token isPath
            and: [ 
              parent isMessage
                and: [ parent receiver == aNode and: [ aNode parent selector == #'&' ] ] ])
            ifTrue: [ ^ true ] ] ].
  aNode precedence < parent precedence
    ifTrue: [ ^ false ].
  (aNode isAssignment and: [ parent isAssignment ])
    ifTrue: [ ^ false ].
  (aNode isAssignment and: [ aNode isCascade ])
    ifTrue: [ ^ true ].
  aNode precedence = 0
    ifTrue: [ ^ false ].
  aNode isMessage
    ifFalse: [ ^ true ].
  aNode precedence = parent precedence
    ifFalse: [ ^ true ].
  aNode isUnary
    ifTrue: [ ^ false ].
  aNode isKeyword
    ifTrue: [ ^ true ].
  parent receiver == aNode
    ifFalse: [ ^ true ].
  inQueryBlock
    ifTrue: [ ^ aNode receiver isMessage not and: [ aNode selector ~~ #'&' ] ].
  ^ self precedenceOf: parent selector greaterThan: aNode selector
%

category: 'private-formatting'
method: RBFormatter
newLinesFor: aString startingAt: anIndex 
	| count cr lf index char |
	cr := Character codePoint: 13.
	lf := Character codePoint: 10.
	count := 0.
	index := anIndex - 1.
	[index > 0 and: 
			[char := aString at: index.
			char isSeparator]] 
		whileTrue: 
			[char == lf 
				ifTrue: 
					[count := count + 1.
					(aString at: (index - 1 max: 1)) == cr ifTrue: [index := index - 1]].
			char == cr ifTrue: [count := count + 1].
			index := index - 1].
	^count
%

category: 'copying'
method: RBFormatter
postCopy
	super postCopy.
	lineStart := self lineLength negated.
	codeStream := WriteStreamPortable on: String new.
	firstLineLength := nil
%

category: 'private'
method: RBFormatter
precedenceOf: parentSelector greaterThan: childSelector 
	"Put parenthesis around things that are preceived to have 'lower' precedence. For example, 'a + b * c' 
	-> '(a + b) * c' but 'a * b + c' -> 'a * b + c'"

	| childIndex parentIndex operators |
	operators := #(#($| $& $?) #($= $~ $< $>) #($- $+) #($* $/ $% $\) #($@)).
	childIndex := 0.
	parentIndex := 0.
	1 to: operators size
		do: 
			[:i | 
			((operators at: i) includes: parentSelector first) 
				ifTrue: [parentIndex := i].
			((operators at: i) includes: childSelector first) 
				ifTrue: [childIndex := i]].
	^childIndex < parentIndex
%

category: 'private'
method: RBFormatter
selectorsToLeaveOnLine
	^#(#to:do: #to:by: #to:by:do:)
%

category: 'private'
method: RBFormatter
selectorsToStartOnNewLine
	^#(#ifTrue:ifFalse: #ifFalse:ifTrue: #ifTrue: #ifFalse:)
%

category: 'testing'
method: RBFormatter
startMessageSendOnNewLine: aMessageNode 
	(self selectorsToStartOnNewLine includes: aMessageNode selector) 
		ifTrue: [^true].
	(self selectorsToLeaveOnLine includes: aMessageNode selector) 
		ifTrue: [^false].
	^aMessageNode selector numArgs > self maximumArgumentsPerLine
%

category: 'visiting'
method: RBFormatter
visitNode: aNode
  | parenthesis |
  parenthesis := self needsParenthesisFor: aNode.
  parenthesis
    ifTrue: [ codeStream nextPut: $( ].
  aNode acceptVisitor: self.
  parenthesis
    ifTrue: [ codeStream nextPut: $) ]
%

! Class implementation for 'RBParseTreeSearcher'

!		Class methods for 'RBParseTreeSearcher'

category: 'private'
classmethod: RBParseTreeSearcher
buildSelectorString: aSelector 
	| stream keywords |
	aSelector numArgs = 0 ifTrue: [^aSelector].
	stream := WriteStreamPortable on: String new.
	keywords := aSelector keywords.
	1 to: keywords size
		do: 
			[:i | 
			stream
				nextPutAll: (keywords at: i);
				nextPutAll: ' ``@arg';
				nextPutAll: i printString;
				nextPut: $ ].
	^stream contents
%

category: 'private'
classmethod: RBParseTreeSearcher
buildSelectorTree: aSelector 
	aSelector isEmpty ifTrue: [^nil].
	^RBParser parseRewriteExpression: '``@receiver ' 
				, (self buildSelectorString: aSelector)
		onError: [:err :pos | ^nil]
%

category: 'private'
classmethod: RBParseTreeSearcher
buildTree: aString method: aBoolean 
	^aBoolean 
		ifTrue: [RBParser parseRewriteMethod: aString]
		ifFalse: [RBParser parseRewriteExpression: aString]
%

category: 'instance creation'
classmethod: RBParseTreeSearcher
getterMethod: aVarName 
	^(self new)
		matchesMethod: '`method ^' , aVarName do: [:aNode :ans | aNode selector];
		yourself
%

category: 'instance creation'
classmethod: RBParseTreeSearcher
justSendsSuper
	^ self new
		matchesAnyMethodOf: #(
			'`@method: `@args ^ super `@method: `@args' 
			'`@method: `@args super `@method: `@args')
		do: [ :node :answer | true ];
		yourself
%

category: 'instance creation'
classmethod: RBParseTreeSearcher
returnSetterMethod: aVarName 
	^(self new)
		matchesMethod: '`method: `Arg ^' , aVarName , ' := `Arg'
			do: [:aNode :ans | aNode selector];
		yourself
%

category: 'instance creation'
classmethod: RBParseTreeSearcher
setterMethod: aVarName 
	^(self new)
		matchesAnyMethodOf: (Array with: '`method: `Arg ' , aVarName , ' := `Arg'
					with: '`method: `Arg ^' , aVarName , ' := `Arg')
			do: [:aNode :ans | aNode selector];
		yourself
%

category: 'accessing'
classmethod: RBParseTreeSearcher
treeMatching: aString in: aParseTree 
	(self new)
		matches: aString do: [:aNode :answer | ^aNode];
		executeTree: aParseTree.
	^nil
%

category: 'accessing'
classmethod: RBParseTreeSearcher
treeMatchingStatements: aString in: aParseTree 
	| notifier tree |
	notifier := self new.
	tree := RBParser parseExpression: aString.
	tree isSequence 
		ifFalse: [tree := RBSequenceNode statements: (Array with: tree)].
	tree temporaries: (Array with: (RBPatternVariableNode named: '`@temps')).
	tree addNodeFirst: (RBPatternVariableNode named: '`@.S1').
	tree lastIsReturn 
		ifFalse: [tree addNode: (RBPatternVariableNode named: '`@.S2')].
	notifier matchesTree: tree
		do: [:aNode :answer | ^RBParser parseExpression: aString].
	notifier executeTree: aParseTree.
	^nil
%

!		Instance methods for 'RBParseTreeSearcher'

category: 'accessing'
method: RBParseTreeSearcher
addArgumentRule: aParseTreeRule 
	argumentSearches add: aParseTreeRule.
	aParseTreeRule owner: self
%

category: 'accessing'
method: RBParseTreeSearcher
addArgumentRules: ruleCollection 
	ruleCollection do: [:each | self addArgumentRule: each]
%

category: 'accessing'
method: RBParseTreeSearcher
addRule: aParseTreeRule 
	searches add: aParseTreeRule.
	aParseTreeRule owner: self
%

category: 'accessing'
method: RBParseTreeSearcher
addRules: ruleCollection 
	ruleCollection do: [:each | self addRule: each]
%

category: 'accessing'
method: RBParseTreeSearcher
answer
	^answer
%

category: 'initialize-release'
method: RBParseTreeSearcher
answer: anObject
	answer := anObject
%

category: 'testing'
method: RBParseTreeSearcher
canMatchMethod: aCompiledMethod
	| actualMessages |
	self messages isEmpty
		ifTrue: [ ^ true ].
	actualMessages := aCompiledMethod messages.
	^ self messages 
		anySatisfy: [ :each | actualMessages includes: each ]
%

category: 'accessing'
method: RBParseTreeSearcher
context
	^context
%

category: 'accessing'
method: RBParseTreeSearcher
executeMethod: aParseTree initialAnswer: anObject 
	answer := anObject.
	searches detect: [:each | (each performOn: aParseTree) notNil] ifNone: [].
	^answer
%

category: 'accessing'
method: RBParseTreeSearcher
executeTree: aParseTree 
	"Save our current context, in case someone is performing another search inside a match."

	| oldContext |
	oldContext := context.
	context := RBSmallDictionary new.
	self visitNode: aParseTree.
	context := oldContext.
	^answer
%

category: 'accessing'
method: RBParseTreeSearcher
executeTree: aParseTree initialAnswer: aValue 
	answer := aValue.
	^self executeTree: aParseTree
%

category: 'private'
method: RBParseTreeSearcher
foundMatch
%

category: 'testing'
method: RBParseTreeSearcher
hasRules
	^searches notEmpty
%

category: 'initialize-release'
method: RBParseTreeSearcher
initialize
	super initialize.
	context := RBSmallDictionary new.
	searches := OrderedCollection new.
	argumentSearches := OrderedCollection new: 0.
	answer := nil
%

category: 'private'
method: RBParseTreeSearcher
lookForMoreMatchesInContext: oldContext 
	oldContext keysAndValuesDo: 
			[:key :value | 
			(key isString not and: [key recurseInto]) 
				ifTrue: [value do: [:each | self visitNode: each]]]
%

category: 'searching'
method: RBParseTreeSearcher
matches: aString do: aBlock 
	self addRule: (RBSearchRule searchFor: aString thenDo: aBlock)
%

category: 'searching'
method: RBParseTreeSearcher
matchesAnyArgumentOf: stringCollection do: aBlock 
	stringCollection do: [:each | self matchesArgument: each do: aBlock]
%

category: 'searching'
method: RBParseTreeSearcher
matchesAnyMethodOf: aStringCollection do: aBlock 
	aStringCollection do: [:each | self matchesMethod: each do: aBlock]
%

category: 'searching'
method: RBParseTreeSearcher
matchesAnyOf: aStringCollection do: aBlock 
	aStringCollection do: [:each | self matches: each do: aBlock]
%

category: 'searching'
method: RBParseTreeSearcher
matchesAnyTreeOf: treeCollection do: aBlock 
	treeCollection do: [:each | self matchesTree: each do: aBlock]
%

category: 'searching'
method: RBParseTreeSearcher
matchesArgument: aString do: aBlock 
	self addArgumentRule: (RBSearchRule searchFor: aString thenDo: aBlock)
%

category: 'searching'
method: RBParseTreeSearcher
matchesArgumentTree: aBRProgramNode do: aBlock 
	self 
		addArgumentRule: (RBSearchRule searchForTree: aBRProgramNode thenDo: aBlock)
%

category: 'searching'
method: RBParseTreeSearcher
matchesMethod: aString do: aBlock 
	self addRule: (RBSearchRule searchForMethod: aString thenDo: aBlock)
%

category: 'searching'
method: RBParseTreeSearcher
matchesTree: aBRProgramNode do: aBlock 
	self addRule: (RBSearchRule searchForTree: aBRProgramNode thenDo: aBlock)
%

category: 'accessing'
method: RBParseTreeSearcher
messages
	messages notNil ifTrue: [^messages].
	argumentSearches notEmpty ifTrue: [^messages := #()].
	messages := Set new.
	searches do: 
			[:each | 
			| searchMessages |
			searchMessages := each sentMessages.
			RBProgramNode optimizedSelectors 
				do: [:sel | searchMessages remove: sel ifAbsent: []].
			searchMessages isEmpty ifTrue: [^messages := #()].
			messages addAll: searchMessages].
	^messages := messages asArray
%

category: 'private'
method: RBParseTreeSearcher
performSearches: aSearchCollection on: aNode 
	| value |
	1 to: aSearchCollection size
		do: 
			[:i | 
			value := (aSearchCollection at: i) performOn: aNode.
			value notNil 
				ifTrue: 
					[self foundMatch.
					^value]].
	^nil
%

category: 'private'
method: RBParseTreeSearcher
recusivelySearchInContext
	"We need to save the matched context since the other searches might overwrite it."

	| oldContext |
	oldContext := context.
	context := RBSmallDictionary new.
	self lookForMoreMatchesInContext: oldContext.
	context := oldContext
%

category: 'visiting'
method: RBParseTreeSearcher
visitArgument: aNode 
	| value |
	value := self performSearches: argumentSearches on: aNode.
	^value isNil 
		ifTrue: 
			[aNode acceptVisitor: self.
			aNode]
		ifFalse: [value]
%

category: 'visiting'
method: RBParseTreeSearcher
visitNode: aNode 
	| value |
	value := self performSearches: searches on: aNode.
	^value isNil 
		ifTrue: 
			[aNode acceptVisitor: self.
			aNode]
		ifFalse: [value]
%

! Class implementation for 'RBParseTreeRewriter'

!		Class methods for 'RBParseTreeRewriter'

category: 'instance creation'
classmethod: RBParseTreeRewriter
removeTemporaryNamed: aName 
	| rewriteRule |
	rewriteRule := self new.
	rewriteRule replace: '| `@temps1 ' , aName , ' `@temps2 | ``@.Statements'
		with: '| `@temps1  `@temps2 | ``@.Statements'.
	^rewriteRule
%

category: 'instance creation'
classmethod: RBParseTreeRewriter
rename: varName to: newVarName 
	| rewriteRule |
	rewriteRule := self new.
	rewriteRule
		replace: varName with: newVarName;
		replaceArgument: varName with: newVarName.
	^rewriteRule
%

category: 'instance creation'
classmethod: RBParseTreeRewriter
rename: varName to: newVarName handler: aBlock 
	"Rename varName to newVarName, evaluating aBlock if there is a 
	temporary variable with the same name as newVarName. This 
	does not change temporary variables with varName."

	| rewriteRule |
	rewriteRule := self new.
	rewriteRule
		replace: varName with: newVarName;
		replaceArgument: newVarName
			withValueFrom: 
				[:aNode | 
				aBlock value.
				aNode].
	^rewriteRule
%

category: 'accessing'
classmethod: RBParseTreeRewriter
replace: code with: newCode in: aParseTree 
	^(self 
		replace: code
		with: newCode
		method: false)
		executeTree: aParseTree;
		tree
%

category: 'accessing'
classmethod: RBParseTreeRewriter
replace: code with: newCode in: aParseTree onInterval: anInterval 
	| rewriteRule |
	rewriteRule := self new.
	^rewriteRule
		replace: code
			with: newCode
			when: [:aNode | aNode intersectsInterval: anInterval];
		executeTree: aParseTree;
		tree
%

category: 'instance creation'
classmethod: RBParseTreeRewriter
replace: code with: newCode method: aBoolean 
	| rewriteRule |
	rewriteRule := self new.
	aBoolean 
		ifTrue: [rewriteRule replaceMethod: code with: newCode]
		ifFalse: [rewriteRule replace: code with: newCode].
	^rewriteRule
%

category: 'instance creation'
classmethod: RBParseTreeRewriter
replaceLiteral: literal with: newLiteral 
	| rewriteRule |
	rewriteRule := self new.
	rewriteRule replaceTree: (RBLiteralNode value: literal)
		withTree: (RBLiteralNode value: newLiteral).
	^rewriteRule
%

category: 'accessing'
classmethod: RBParseTreeRewriter
replaceStatements: code with: newCode in: aParseTree onInterval: anInterval 
	| tree replaceStmt |
	tree := self buildTree: code method: false.
	tree isSequence 
		ifFalse: [tree := RBSequenceNode statements: (Array with: tree)].
	tree temporaries: (Array with: (RBPatternVariableNode named: '`@temps')).
	tree addNodeFirst: (RBPatternVariableNode named: '`@.S1').
	tree lastIsReturn 
		ifTrue: [replaceStmt := '| `@temps | `@.S1. ^' , newCode]
		ifFalse: 
			[tree addNode: (RBPatternVariableNode named: '`@.S2').
			replaceStmt := '| `@temps | `@.S1. ' , newCode , '. `@.S2'].
	^self 
		replace: tree formattedCode
		with: replaceStmt
		in: aParseTree
		onInterval: anInterval
%

category: 'instance creation'
classmethod: RBParseTreeRewriter
variable: aVarName getter: getMethod setter: setMethod 
	^self 
		variable: aVarName
		getter: getMethod
		setter: setMethod
		receiver: 'self'
%

category: 'instance creation'
classmethod: RBParseTreeRewriter
variable: aVarName getter: getMethod setter: setMethod receiver: aString 
	| rewriteRule |
	rewriteRule := self new.
	rewriteRule
		replace: aVarName , ' := ``@object'
			with: aString , ' ' , setMethod , ' ``@object';
		replace: aVarName with: aString , ' ' , getMethod.
	^rewriteRule
%

!		Instance methods for 'RBParseTreeRewriter'

category: 'visitor-double dispatching'
method: RBParseTreeRewriter
acceptArrayNode: anArrayNode
	anArrayNode statements: (anArrayNode statements 
				collect: [:each | self visitNode: each])
%

category: 'visitor-double dispatching'
method: RBParseTreeRewriter
acceptAssignmentNode: anAssignmentNode 
	anAssignmentNode variable: (self visitNode: anAssignmentNode variable).
	anAssignmentNode value: (self visitNode: anAssignmentNode value)
%

category: 'visitor-double dispatching'
method: RBParseTreeRewriter
acceptBlockNode: aBlockNode 
	aBlockNode arguments: (self visitArguments: aBlockNode arguments).
	aBlockNode body: (self visitNode: aBlockNode body)
%

category: 'visitor-double dispatching'
method: RBParseTreeRewriter
acceptCascadeNode: aCascadeNode 
	| newMessages notFound |
	newMessages := OrderedCollection new: aCascadeNode messages size.
	notFound := OrderedCollection new: aCascadeNode messages size.
	aCascadeNode messages do: 
			[:each | 
			| newNode |
			newNode := self performSearches: searches on: each.
			newNode isNil 
				ifTrue: 
					[newNode := each.
					notFound add: newNode].
			newNode isMessage 
				ifTrue: [newMessages add: newNode]
				ifFalse: 
					[newNode isCascade 
						ifTrue: [newMessages addAll: newNode messages]
						ifFalse: 
							[Transcript
								show: 'Cannot replace message node inside of cascaded node with non-message node.';
								cr.
							newMessages add: each]]].
	notFound size = aCascadeNode messages size 
		ifTrue: 
			[| receiver |
			receiver := self visitNode: aCascadeNode messages first receiver.
			newMessages do: [:each | each receiver: receiver]].
	notFound 
		do: [:each | each arguments: (each arguments collect: [:arg | self visitNode: arg])].
	aCascadeNode messages: newMessages
%

category: 'visitor-double dispatching'
method: RBParseTreeRewriter
acceptLiteralArrayNode: aRBArrayLiteralNode 
	aRBArrayLiteralNode contents: (aRBArrayLiteralNode contents 
				collect: [:each | self visitNode: each])
%

category: 'visitor-double dispatching'
method: RBParseTreeRewriter
acceptMessageNode: aMessageNode 
	aMessageNode receiver: (self visitNode: aMessageNode receiver).
	aMessageNode 
		arguments: (aMessageNode arguments collect: [:each | self visitNode: each])
%

category: 'visitor-double dispatching'
method: RBParseTreeRewriter
acceptMethodNode: aMethodNode 
	aMethodNode arguments: (self visitArguments: aMethodNode arguments).
	aMethodNode pragmas: (aMethodNode pragmas 
		collect: [:each | self visitNode: each]).
	aMethodNode body: (self visitNode: aMethodNode body)
%

category: 'visitor-double dispatching'
method: RBParseTreeRewriter
acceptPragmaNode: aPragmaNode 
	aPragmaNode arguments: (aPragmaNode arguments collect: [:each | self visitNode: each])
%

category: 'visitor-double dispatching'
method: RBParseTreeRewriter
acceptReturnNode: aReturnNode 
	aReturnNode value: (self visitNode: aReturnNode value)
%

category: 'visitor-double dispatching'
method: RBParseTreeRewriter
acceptSequenceNode: aSequenceNode 
	aSequenceNode 
		temporaries: (self visitArguments: aSequenceNode temporaries).
	aSequenceNode statements: (aSequenceNode statements 
				collect: [:each | self visitNode: each])
%

category: 'accessing'
method: RBParseTreeRewriter
executeTree: aParseTree 
	| oldContext |
	oldContext := context.
	context := RBSmallDictionary new.
	answer := false.
	tree := self visitNode: aParseTree.
	context := oldContext.
	^answer
%

category: 'private'
method: RBParseTreeRewriter
foundMatch
	answer := true
%

category: 'private'
method: RBParseTreeRewriter
lookForMoreMatchesInContext: oldContext 
	oldContext keysAndValuesDo: 
			[:key :value | 
			(key isString not and: [key recurseInto]) 
				ifTrue: 
					[oldContext at: key put: (value collect: [:each | self visitNode: each])]]
%

category: 'replacing'
method: RBParseTreeRewriter
replace: searchString with: replaceString 
	self addRule: (RBStringReplaceRule searchFor: searchString
				replaceWith: replaceString)
%

category: 'replacing'
method: RBParseTreeRewriter
replace: searchString with: replaceString when: aBlock 
	self addRule: (RBStringReplaceRule 
				searchFor: searchString
				replaceWith: replaceString
				when: aBlock)
%

category: 'replacing'
method: RBParseTreeRewriter
replace: searchString withValueFrom: replaceBlock 
	self addRule: (RBBlockReplaceRule searchFor: searchString
				replaceWith: replaceBlock)
%

category: 'replacing'
method: RBParseTreeRewriter
replace: searchString withValueFrom: replaceBlock when: conditionBlock 
	self addRule: (RBBlockReplaceRule 
				searchFor: searchString
				replaceWith: replaceBlock
				when: conditionBlock)
%

category: 'replacing'
method: RBParseTreeRewriter
replaceArgument: searchString with: replaceString 
	self addArgumentRule: (RBStringReplaceRule searchFor: searchString
				replaceWith: replaceString)
%

category: 'replacing'
method: RBParseTreeRewriter
replaceArgument: searchString with: replaceString when: aBlock 
	self addArgumentRule: (RBStringReplaceRule 
				searchFor: searchString
				replaceWith: replaceString
				when: aBlock)
%

category: 'replacing'
method: RBParseTreeRewriter
replaceArgument: searchString withValueFrom: replaceBlock 
	self addArgumentRule: (RBBlockReplaceRule searchFor: searchString
				replaceWith: replaceBlock)
%

category: 'replacing'
method: RBParseTreeRewriter
replaceArgument: searchString withValueFrom: replaceBlock when: conditionBlock 
	self addArgumentRule: (RBBlockReplaceRule 
				searchFor: searchString
				replaceWith: replaceBlock
				when: conditionBlock)
%

category: 'replacing'
method: RBParseTreeRewriter
replaceMethod: searchString with: replaceString 
	self addRule: (RBStringReplaceRule searchForMethod: searchString
				replaceWith: replaceString)
%

category: 'replacing'
method: RBParseTreeRewriter
replaceMethod: searchString with: replaceString when: aBlock 
	self addRule: (RBStringReplaceRule 
				searchForMethod: searchString
				replaceWith: replaceString
				when: aBlock)
%

category: 'replacing'
method: RBParseTreeRewriter
replaceMethod: searchString withValueFrom: replaceBlock 
	self addRule: (RBBlockReplaceRule searchForMethod: searchString
				replaceWith: replaceBlock)
%

category: 'replacing'
method: RBParseTreeRewriter
replaceMethod: searchString withValueFrom: replaceBlock when: conditionBlock 
	self addRule: (RBBlockReplaceRule 
				searchForMethod: searchString
				replaceWith: replaceBlock
				when: conditionBlock)
%

category: 'replacing'
method: RBParseTreeRewriter
replaceTree: searchTree withTree: replaceTree 
	self addRule: (RBStringReplaceRule searchForTree: searchTree
				replaceWith: replaceTree)
%

category: 'replacing'
method: RBParseTreeRewriter
replaceTree: searchTree withTree: replaceTree when: aBlock 
	self addRule: (RBStringReplaceRule 
				searchForTree: searchTree
				replaceWith: replaceTree
				when: aBlock)
%

category: 'accessing'
method: RBParseTreeRewriter
tree
	^tree
%

category: 'visiting'
method: RBParseTreeRewriter
visitArguments: aNodeCollection 
	^aNodeCollection collect: [:each | self visitArgument: each]
%

! Class implementation for 'RBReadBeforeWrittenTester'

!		Class methods for 'RBReadBeforeWrittenTester'

category: 'accessing'
classmethod: RBReadBeforeWrittenTester
isVariable: aString readBeforeWrittenIn: aBRProgramNode 
	^(self isVariable: aString writtenBeforeReadIn: aBRProgramNode) not
%

category: 'accessing'
classmethod: RBReadBeforeWrittenTester
isVariable: aString writtenBeforeReadIn: aBRProgramNode 
	^(self readBeforeWritten: (Array with: aString) in: aBRProgramNode) 
		isEmpty
%

category: 'accessing'
classmethod: RBReadBeforeWrittenTester
readBeforeWritten: varNames in: aParseTree 
	^(self new)
		checkNewTemps: false;
		initializeVars: varNames;
		executeTree: aParseTree;
		read
%

category: 'accessing'
classmethod: RBReadBeforeWrittenTester
variablesReadBeforeWrittenIn: aParseTree 
	^(self new)
		executeTree: aParseTree;
		read
%

!		Instance methods for 'RBReadBeforeWrittenTester'

category: 'visitor-double dispatching'
method: RBReadBeforeWrittenTester
acceptAssignmentNode: anAssignmentNode 
	self visitNode: anAssignmentNode value.
	self variableWritten: anAssignmentNode
%

category: 'visitor-double dispatching'
method: RBReadBeforeWrittenTester
acceptBlockNode: aBlockNode 
	self processBlock: aBlockNode
%

category: 'visitor-double dispatching'
method: RBReadBeforeWrittenTester
acceptMessageNode: aMessageNode 
	((#(#whileTrue: #whileFalse: #whileTrue #whileFalse) 
		includes: aMessageNode selector) and: [aMessageNode receiver isBlock]) 
		ifTrue: [self executeTree: aMessageNode receiver body]
		ifFalse: 
			[(aMessageNode isCascaded not or: [aMessageNode isFirstCascaded]) 
				ifTrue: [self visitNode: aMessageNode receiver]].
	((#(#ifTrue:ifFalse: #ifFalse:ifTrue:) includes: aMessageNode selector) 
		and: [aMessageNode arguments allSatisfy: [:each | each isBlock]]) 
			ifTrue: [^self processIfTrueIfFalse: aMessageNode].
	aMessageNode arguments do: [:each | self visitNode: each]
%

category: 'visitor-double dispatching'
method: RBReadBeforeWrittenTester
acceptSequenceNode: aSequenceNode 
	self processStatementNode: aSequenceNode
%

category: 'visitor-double dispatching'
method: RBReadBeforeWrittenTester
acceptVariableNode: aVariableNode 
	self variableRead: aVariableNode
%

category: 'initialize-release'
method: RBReadBeforeWrittenTester
checkNewTemps: aBoolean 
	checkNewTemps := aBoolean
%

category: 'private'
method: RBReadBeforeWrittenTester
copyDictionary: aDictionary 
	"We could send aDictionary the copy message, but that doesn't copy the associations."

	| newDictionary |
	newDictionary := Dictionary new: aDictionary size.
	aDictionary keysAndValuesDo: [ :key :value | newDictionary at: key put: value ].
	^ newDictionary
%

category: 'private'
method: RBReadBeforeWrittenTester
createScope
	scopeStack add: (self copyDictionary: scopeStack last)
%

category: 'private'
method: RBReadBeforeWrittenTester
currentScope
	^scopeStack last
%

category: 'accessing'
method: RBReadBeforeWrittenTester
executeTree: aParseTree 
	^self visitNode: aParseTree
%

category: 'initialize-release'
method: RBReadBeforeWrittenTester
initialize
	super initialize.
	scopeStack := OrderedCollection with: Dictionary new.
	read := Set new.
	checkNewTemps := true
%

category: 'initialize-release'
method: RBReadBeforeWrittenTester
initializeVars: varNames 
	varNames do: [:each | self currentScope at: each put: nil]
%

category: 'private'
method: RBReadBeforeWrittenTester
processBlock: aNode 
	| newScope |
	self createScope.
	self executeTree: aNode body.
	newScope := self removeScope.
	newScope keysAndValuesDo: 
			[:key :value | 
			(value == true and: [(self currentScope at: key) isNil]) 
				ifTrue: [self currentScope at: key put: value]]
%

category: 'private'
method: RBReadBeforeWrittenTester
processIfTrueIfFalse: aNode 
	| trueScope falseScope |
	self createScope.
	self executeTree: aNode arguments first body.
	trueScope := self removeScope.
	self createScope.
	self executeTree: aNode arguments last body.
	falseScope := self removeScope.
	self currentScope keysAndValuesDo: 
			[:key :value | 
			value isNil 
				ifTrue: 
					[(trueScope at: key) == (falseScope at: key) 
						ifTrue: [self currentScope at: key put: (trueScope at: key)]
						ifFalse: 
							[((trueScope at: key) == true or: [(falseScope at: key) == true]) 
								ifTrue: [self currentScope at: key put: true]]]]
%

category: 'private'
method: RBReadBeforeWrittenTester
processStatementNode: aNode 
	| temps |
	(checkNewTemps not or: [aNode temporaries isEmpty]) 
		ifTrue: 
			[aNode statements do: [:each | self executeTree: each].
			^self].
	self createScope.
	temps := aNode temporaries collect: [:each | each name].
	self initializeVars: temps.
	aNode statements do: [:each | self executeTree: each].
	self removeScope keysAndValuesDo: 
			[:key :value | 
			(temps includes: key) 
				ifTrue: [value == true ifTrue: [read add: key]]
				ifFalse: 
					[(self currentScope at: key) isNil 
						ifTrue: [self currentScope at: key put: value]]]
%

category: 'accessing'
method: RBReadBeforeWrittenTester
read
	self currentScope
		keysAndValuesDo: [:key :value | value == true ifTrue: [read add: key]].
	^read
%

category: 'private'
method: RBReadBeforeWrittenTester
removeScope
	^scopeStack removeLast
%

category: 'private'
method: RBReadBeforeWrittenTester
variableRead: aNode 
	(self currentScope includesKey: aNode name) 
		ifTrue: 
			[(self currentScope at: aNode name) isNil 
				ifTrue: [self currentScope at: aNode name put: true]]
%

category: 'private'
method: RBReadBeforeWrittenTester
variableWritten: aNode 
	(self currentScope includesKey: aNode variable name) 
		ifTrue: 
			[(self currentScope at: aNode variable name) isNil 
				ifTrue: [self currentScope at: aNode variable name put: false]]
%

! Class implementation for 'RBScanner'

!		Class methods for 'RBScanner'

category: 'accessing'
classmethod: RBScanner
classificationTable
	classificationTable isNil 
		ifTrue: [ self initializeClassificationTable ].
	^ classificationTable
%

category: 'class initialization'
classmethod: RBScanner
initialize
	self initializeClassificationTable
%

category: 'class initialization'
classmethod: RBScanner
initializeChars: characters to: aSymbol 
	characters do: [:c | classificationTable at: c asInteger put: aSymbol]
%

category: 'class initialization'
classmethod: RBScanner
initializeClassificationTable
  PatternVariableCharacter := $`.
  classificationTable := Array new: 255.
  self
    initializeChars: (((0 to: 255) collect: [ :v | Character codePoint: v ]) select: [ :each | each isLetter ])
    to: #'alphabetic'.
  self initializeUnderscore.
  self initializeChars: '01234567890' to: #'digit'.
  self initializeChars: '!%&*+,-/<=>?@\~|' to: #'binary'.
  classificationTable at: 177 put: #'binary'.	"plus-or-minus"
  classificationTable at: 183 put: #'binary'.	"centered dot"
  classificationTable at: 215 put: #'binary'.	"times"
  classificationTable at: 247 put: #'binary'.	"divide"
  self initializeChars: '().:;[]{}^' to: #'special'.
  self
    initializeChars:
      (((1 to: 255) collect: [ :v | Character codePoint: v ]) select: [ :each | each isSeparator ])
    to: #'separator'
%

category: 'class initialization'
classmethod: RBScanner
initializeUnderscore
  self classificationTable
    at: $_ asInteger
    put: #'alphabetic' 
"
      ((Scanner isLiteralSymbol: '_')
        ifTrue: [ #'alphabetic' ]
        ifFalse: [ #'special' ])
"
%

category: 'testing'
classmethod: RBScanner
isSelector: aSymbol 
	| scanner token |
	scanner := self basicNew.
	scanner on: aSymbol asString readStreamPortable.
	scanner step.
	token := scanner scanAnySymbol.
	token isLiteralToken ifFalse: [^false].
	token value isEmpty ifTrue: [^false].
	^scanner atEnd
%

category: 'testing'
classmethod: RBScanner
isVariable: aString 
	| scanner token |
	scanner := self on: aString readStreamPortable errorBlock: [:s :p | ^false].
	token := scanner next.
	token isIdentifier ifFalse: [^false].
	(token start = 1 and: [token stop = aString size]) ifFalse: [^false].
	^(aString includes: $.) not
%

category: 'instance creation'
classmethod: RBScanner
new
  ^ super new
%

category: 'instance creation'
classmethod: RBScanner
on: aStream 
	| str |
	str := self new on: aStream.
	str
		step;
		stripSeparators.
	^str
%

category: 'instance creation'
classmethod: RBScanner
on: aStream errorBlock: aBlock 
	| str |
	str := self new on: aStream.
	str
		errorBlock: aBlock;
		step;
		stripSeparators.
	^str
%

category: 'accessing'
classmethod: RBScanner
patternVariableCharacter
	^ PatternVariableCharacter
%

!		Instance methods for 'RBScanner'

category: 'testing'
method: RBScanner
atEnd
	^characterType = #eof
%

category: 'private'
method: RBScanner
classify: aCharacter 
	| index |
	aCharacter isNil ifTrue: [^nil].
	index := aCharacter asInteger.
	index == 0 ifTrue: [^#separator].
	index > 255 
		ifTrue: 
			[^aCharacter isLetter 
				ifTrue: [#alphabetic]
				ifFalse: [aCharacter isSqueakSeparator ifTrue: [#separator] ifFalse: [nil]]].
	^classificationTable at: index
%

category: 'accessing'
method: RBScanner
contents
	| contentsStream |
	contentsStream := WriteStreamPortable on: String new.
	[ self atEnd ]
		whileFalse: [ contentsStream nextPut: self next ].
	^ contentsStream contents
%

category: 'error handling'
method: RBScanner
errorBlock
	^errorBlock isNil ifTrue: [[:message :position | ]] ifFalse: [errorBlock]
%

category: 'accessing'
method: RBScanner
errorBlock: aBlock 
	errorBlock := aBlock
%

category: 'error handling'
method: RBScanner
errorPosition
	^stream position
%

category: 'accessing'
method: RBScanner
flush
%

category: 'accessing'
method: RBScanner
getComments
	| oldComments |
	comments isEmpty ifTrue: [^nil].
	oldComments := comments.
	comments := OrderedCollection new: 1.
	^oldComments
%

category: 'testing'
method: RBScanner
isReadable
	^true
%

category: 'testing'
method: RBScanner
isWritable
	^false
%

category: 'accessing'
method: RBScanner
next
	| token |
	buffer reset.
	tokenStart := stream position.
	token := characterType = #eof 
				ifTrue: 
					[RBToken start: tokenStart + 1	"The EOF token should occur after the end of input"]
				ifFalse: [self scanToken].
	self stripSeparators.
	token comments: self getComments.
	^token
%

category: 'accessing'
method: RBScanner
nextPut: anObject 
	"Provide an error notification that the receiver does not
	implement this message."

	self shouldNotImplement
%

category: 'initialize-release'
method: RBScanner
on: aStream 
	buffer := WriteStreamPortable on: String new.
	stream := aStream.
	classificationTable := self class classificationTable.
	comments := OrderedCollection new
%

category: 'private'
method: RBScanner
previousStepPosition
	^characterType = #eof 
		ifTrue: [stream position]
		ifFalse: [stream position - 1]
%

category: 'private-scanning'
method: RBScanner
scanAnySymbol
	characterType = #alphabetic ifTrue: [^self scanSymbol].
	characterType = #binary ifTrue: [^self scanBinary: RBLiteralToken].
	^RBToken new
%

category: 'private-scanning'
method: RBScanner
scanBinary: aClass 
	| val |
	buffer nextPut: currentCharacter.
	self step.
	[ characterType = #binary ] whileTrue: 
		[ buffer nextPut: currentCharacter.
		self step ].
	val := buffer contents.
	val := val asSymbol.
	^aClass value: val start: tokenStart
%

category: 'private-scanning'
method: RBScanner
scanIdentifierOrKeyword
  | name |
  self scanName.
  [ 
  currentCharacter = $.
    and: [ 'abcdefghijklmnopqrstuvwxyz*|#' includes: stream peek ] ]
    whileTrue: [ 
      buffer nextPut: currentCharacter.
      self step.
      self scanPathName.
      name := buffer contents.
      ^ RBPathToken value: name start: tokenStart ].
  (currentCharacter = $: and: [ stream peek ~= $= ])
    ifTrue: [ ^ self scanKeyword ].
  name := buffer contents.
  name = '_'
    ifTrue: [ ^ RBShortAssignmentToken start: tokenStart ].
  name = 'true'
    ifTrue: [ ^ RBLiteralToken value: true start: tokenStart stop: self previousStepPosition ].
  name = 'false'
    ifTrue: [ ^ RBLiteralToken value: false start: tokenStart stop: self previousStepPosition ].
  name = 'nil'
    ifTrue: [ ^ RBLiteralToken value: nil start: tokenStart stop: self previousStepPosition ].
  ^ RBIdentifierToken value: name start: tokenStart
%

category: 'private-scanning'
method: RBScanner
scanKeyword
	| outputPosition inputPosition name |
	[currentCharacter = $:] whileTrue: 
			[buffer nextPut: currentCharacter.
			outputPosition := buffer position.
			inputPosition := stream position.
			self step.	":"
			[characterType = #alphabetic] whileTrue: [self scanName]].
	buffer position: outputPosition.
	stream position: inputPosition.
	self step.
	name := buffer contents.
	^(name occurrencesOf: $:) == 1 
		ifTrue: [RBKeywordToken value: name start: tokenStart]
		ifFalse: 
			[RBMultiKeywordLiteralToken 
				value: name asSymbol
				start: tokenStart
				stop: tokenStart + name size - 1]
%

category: 'private-scanning'
method: RBScanner
scanLiteral
	self step.
	self stripSeparators.
	characterType = #alphabetic 
		ifTrue: [ ^ self scanSymbol ].
	characterType = #binary 
		ifTrue: [ ^ (self scanBinary: RBLiteralToken) stop: self previousStepPosition ].
	currentCharacter = $' 
		ifTrue: [ ^ self scanStringSymbol ].
	(currentCharacter = $( or: [ currentCharacter = $[ ]) 
		ifTrue: [ ^ self scanLiteralArrayToken].
	"Accept some strange literals like '#1', '# species' and '##species:'"
	characterType = #digit
		ifTrue: [ ^ self scanNumber ].
	currentCharacter = $#
		ifTrue: [ ^ self scanLiteral ].
	self scannerError: 'Expecting a literal type'
%

category: 'private-scanning'
method: RBScanner
scanLiteralArrayToken
	| token |
	token := RBLiteralArrayToken 
				value: (String with: $# with: currentCharacter)
				start: tokenStart.
	self step.
	^token
%

category: 'private-scanning'
method: RBScanner
scanLiteralCharacter
	| token |
	self step.	"$"
	token := RBLiteralToken 
				value: currentCharacter
				start: tokenStart
				stop: stream position.
	self step.	"char"
	^token
%

category: 'private-scanning'
method: RBScanner
scanLiteralString
	self step.
	
	[currentCharacter isNil 
		ifTrue: [self scannerError: 'Unmatched '' in string literal.'].
	currentCharacter = $' and: [self step ~= $']] 
			whileFalse: 
				[buffer nextPut: currentCharacter.
				self step].
	^RBLiteralToken 
		value: buffer contents
		start: tokenStart
		stop: self previousStepPosition
%

category: 'private-scanning'
method: RBScanner
scanName
	[characterType = #alphabetic or: [characterType = #digit]] whileTrue: 
			[buffer nextPut: currentCharacter.
			self step]
%

category: 'error handling'
method: RBScanner
scannerError: aString 
	"Evaluate the block. If it returns raise an error"

	self errorBlock value: aString value: self errorPosition.
	self error: aString
%

category: 'private-scanning'
method: RBScanner
scanNumber
	| start number stop string |
	start := stream position.
	stream position: start - 1.
	number := Number rwFromStream: stream.
	stop := stream position.
	stream position: start - 1.
	string := stream next: stop - start + 1.
	stream position: stop.
	self step.
	^RBNumberLiteralToken 
		value: number
		start: start
		stop: stop
		source: string
%

category: 'private-scanning'
method: RBScanner
scanPathName
  [ 
  (characterType = #'alphabetic' or: [ characterType = #'digit' ])
    or: [ 
      ((currentCharacter = $. or: [ currentCharacter = $| ])
        and: [ 'abcdefghijklmnopqrstuvwxyz' includes: stream peek ])
        or: [ 
          (currentCharacter = $. and: [ stream peek = $* ])
            or: [ currentCharacter = $* and: [ stream peek = $. ] ] ] ] ]
    whileTrue: [ 
      buffer nextPut: currentCharacter.
      self step ]
%

category: 'private-scanning'
method: RBScanner
scanPatternVariable
	buffer nextPut: currentCharacter.
	self step.
	currentCharacter = ${ 
		ifTrue: 
			[self step.
			^RBPatternBlockToken value: '`{' start: tokenStart].
	[characterType = #alphabetic] whileFalse: 
			[characterType = #eof 
				ifTrue: [self scannerError: 'Meta variable expected'].
			buffer nextPut: currentCharacter.
			self step].
	^self scanIdentifierOrKeyword
%

category: 'private-scanning'
method: RBScanner
scanSpecialCharacter
	| character |
	currentCharacter = $: 
		ifTrue: 
			[self step.
			^currentCharacter = $= 
				ifTrue: 
					[self step.
					RBAssignmentToken start: tokenStart]
				ifFalse: [RBSpecialCharacterToken value: $: start: tokenStart]].
	currentCharacter = $_ ifTrue:
		[ self step.  ^RBShortAssignmentToken start: tokenStart ].
	character := currentCharacter.
	self step.
	^RBSpecialCharacterToken value: character start: tokenStart
%

category: 'private-scanning'
method: RBScanner
scanStringSymbol
	| literalToken |
	literalToken := self scanLiteralString.
	literalToken value: literalToken value asSymbol.
	^literalToken
%

category: 'private-scanning'
method: RBScanner
scanSymbol
	[ characterType = #alphabetic or: [ currentCharacter = $: ] ] whileTrue: [
		self scanName.
		currentCharacter = $: ifTrue: [
			buffer nextPut: $:.
			self step ] ].
	^ RBLiteralToken 
		value: buffer contents asSymbol
		start: tokenStart
		stop: self previousStepPosition
%

category: 'accessing'
method: RBScanner
scanToken
	"fast-n-ugly. Don't write stuff like this. Has been found to cause cancer in laboratory rats. Basically a 
	case statement. Didn't use Dictionary because lookup is pretty slow."

	characterType = #alphabetic ifTrue: [^self scanIdentifierOrKeyword].
	(characterType = #digit 
		or: [currentCharacter = $- and: [(self classify: stream peek) = #digit]]) 
			ifTrue: [^self scanNumber].
	characterType = #binary ifTrue: [^self scanBinary: RBBinarySelectorToken].
	characterType = #special ifTrue: [^self scanSpecialCharacter].
	currentCharacter = $' ifTrue: [^self scanLiteralString].
	currentCharacter = $# ifTrue: [^self scanLiteral].
	currentCharacter = $$ ifTrue: [^self scanLiteralCharacter].
	^self scannerError: 'Unknown character'
%

category: 'private'
method: RBScanner
step
	stream atEnd 
		ifTrue: 
			[characterType := #eof.
			^currentCharacter := nil].
	currentCharacter := stream next.
	characterType := self classify: currentCharacter.
	^currentCharacter
%

category: 'private-scanning'
method: RBScanner
stripComment
	| start stop |
	start := stream position.
	[self step = $"] whileFalse: 
			[characterType = #eof
				ifTrue: [self scannerError: 'Unmatched " in comment.']].
	stop := stream position.
	self step.
	comments add: (start to: stop)
%

category: 'private-scanning'
method: RBScanner
stripSeparators
	
	[[characterType = #separator] whileTrue: [self step].
	currentCharacter = $"] 
			whileTrue: [self stripComment]
%

! Class implementation for 'RBPatternScanner'

!		Class methods for 'RBPatternScanner'

category: 'class initialization'
classmethod: RBPatternScanner
initialize
  "force initialization on load"

  "self initialize"

  super initialize
%

!		Instance methods for 'RBPatternScanner'

category: 'accessing'
method: RBPatternScanner
scanToken
	currentCharacter = PatternVariableCharacter 
		ifTrue: [^self scanPatternVariable].
	currentCharacter = $} ifTrue: [^self scanSpecialCharacter].
	^super scanToken
%

! Class implementation for 'RBTonelScanner'

!		Instance methods for 'RBTonelScanner'

category: 'private'
method: RBTonelScanner
peekTonelFor: aCharacterType value: aCharacterValue

	^ currentCharacter = aCharacterValue and: [ characterType =  aCharacterType ]
%

category: 'error handling'
method: RBTonelScanner
stream
	^stream
%

category: 'accessing'
method: RBTonelScanner
tonelNext
	"only used when parsing the tonel method selector line"

	| token |
(characterType == #special and: [currentCharacter = $[ ])
	ifFalse: [ 
		 characterType ~~ #eof
			ifTrue: [ self error: 'Cannot parse Tonel method body. Missing ''[''.' ] ].
	buffer reset.
	tokenStart := stream position.
	token := characterType = #eof 
				ifTrue: 
					[RBToken start: tokenStart + 1	"The EOF token should occur after the end of input"]
				ifFalse: [self scanToken].
	self stripSeparators.
"don't read comments"
	false ifTrue: [ token comments: self getComments ].
"skip the $[ and get next token"
	^self next
%

! Class implementation for 'RBSmallDictionary'

!		Class methods for 'RBSmallDictionary'

category: 'instance creation'
classmethod: RBSmallDictionary
new
	^ self new: 2
%

category: 'instance creation'
classmethod: RBSmallDictionary
new: anInteger 
	^ self basicNew initialize: anInteger
%

!		Instance methods for 'RBSmallDictionary'

category: 'accessing'
method: RBSmallDictionary
at: aKey
	"Answer the value associated with aKey. Raise an exception, if no such key is defined."

	^ self at: aKey ifAbsent: [ self errorKeyNotFound ]
%

category: 'accessing'
method: RBSmallDictionary
at: aKey ifAbsent: aBlock
	"Answer the value associated with aKey. Evaluate aBlock, if no such key is defined."

	| index |
	index := self findIndexFor: aKey.
	^ index = 0
		ifFalse: [ values at: index ]
		ifTrue: [ aBlock value ]
%

category: 'accessing'
method: RBSmallDictionary
at: aKey ifAbsentPut: aBlock
	"Answer the value associated with aKey. Evaluate aBlock, if no such key is defined and store the return value."

	| index |
	index := self findIndexFor: aKey.
	^ index = 0
		ifFalse: [ values at: index ]
		ifTrue: [ self privateAt: aKey put: aBlock value ]
%

category: 'accessing'
method: RBSmallDictionary
at: aKey put: aValue
	"Set the value of aKey to be aValue."

	| index |
	index := self findIndexFor: aKey.
	^ index = 0
		ifFalse: [ values at: index put: aValue ]
		ifTrue: [ self privateAt: aKey put: aValue ]
%

category: 'accessing'
method: RBSmallDictionary
empty
	tally := 0
%

category: 'private'
method: RBSmallDictionary
errorKeyNotFound
	self error: 'Key not found'
%

category: 'private'
method: RBSmallDictionary
findIndexFor: aKey
	1 to: tally do: [ :index |
		(keys at: index) = aKey
			ifTrue: [ ^ index ] ].
	^ 0
%

category: 'private'
method: RBSmallDictionary
grow
	| newKeys newValues |
	newKeys := Array new: 2 * tally.
	newValues := Array new: 2 * tally.
	1 to: tally do: [ :index |
		newKeys at: index put: (keys at: index).
		newValues at: index put: (values at: index) ].
	keys := newKeys.
	values := newValues
%

category: 'testing'
method: RBSmallDictionary
includesKey: aKey
	"Answer whether the receiver has a key equal to aKey."

	^ (self findIndexFor: aKey) ~= 0
%

category: 'initialization'
method: RBSmallDictionary
initialize: anInteger
	tally := 0.
	keys := Array new: anInteger.
	values := Array new: anInteger
%

category: 'testing'
method: RBSmallDictionary
isEmpty
	^ tally == 0
%

category: 'accessing'
method: RBSmallDictionary
keys
	^ keys copyFrom: 1 to: tally
%

category: 'enumerating'
method: RBSmallDictionary
keysAndValuesDo: aBlock
	1 to: tally do: [ :index | aBlock value: (keys at: index) value: (values at: index) ]
%

category: 'enumerating'
method: RBSmallDictionary
keysDo: aBlock
	1 to: tally do: [ :each | aBlock value: (keys at: each) ]
%

category: 'copying'
method: RBSmallDictionary
postCopy
	super postCopy.
	keys := keys copy.
	values := values copy
%

category: 'private'
method: RBSmallDictionary
privateAt: aKey put: aValue
	tally = keys size ifTrue: [ self grow ].
	keys at: (tally := tally + 1) put: aKey.
	^ values at: tally put: aValue
%

category: 'removing'
method: RBSmallDictionary
removeKey: aKey
	"Remove aKey from the receiver, raise an exception if the element is missing."

	^ self removeKey: aKey ifAbsent: [ self errorKeyNotFound ]
%

category: 'removing'
method: RBSmallDictionary
removeKey: aKey ifAbsent: aBlock
	"Remove aKey from the receiver, evaluate aBlock if the element is missing."

	| index value |
	index := self findIndexFor: aKey.
	index = 0 ifTrue: [ ^ aBlock value ].
	value := values at: index.
	index to: tally - 1 do: [ :i |
		keys at: i put: (keys at: i + 1).
		values at: i put: (values at: i + 1) ].
	keys at: tally put: nil.
	values at: tally put: nil.
	tally := tally - 1.
	^ value
%

category: 'accessing'
method: RBSmallDictionary
size
	^ tally
%

category: 'accessing'
method: RBSmallDictionary
values
	^ values copyFrom: 1 to: tally
%

category: 'enumerating'
method: RBSmallDictionary
valuesDo: aBlock
	1 to: tally do: [ :index | aBlock value: (values at: index) ]
%

! Class implementation for 'RBStringReplacement'

!		Class methods for 'RBStringReplacement'

category: 'instance creation'
classmethod: RBStringReplacement
replaceFrom: startInteger to: stopInteger with: aString 
	^(self new)
		startPosition: startInteger;
		stopPosition: stopInteger;
		string: aString;
		yourself
%

!		Instance methods for 'RBStringReplacement'

category: 'accessing'
method: RBStringReplacement
startPosition
	^startPosition
%

category: 'initialize-release'
method: RBStringReplacement
startPosition: anInteger 
	startPosition := anInteger
%

category: 'accessing'
method: RBStringReplacement
stopPosition
	^stopPosition
%

category: 'initialize-release'
method: RBStringReplacement
stopPosition: anInteger 
	stopPosition := anInteger
%

category: 'accessing'
method: RBStringReplacement
string
	^string
%

category: 'initialize-release'
method: RBStringReplacement
string: aString 
	string := aString
%

! Class implementation for 'RBToken'

!		Class methods for 'RBToken'

category: 'instance creation'
classmethod: RBToken
start: anInterval 
	^self new start: anInterval
%

!		Instance methods for 'RBToken'

category: 'accessing'
method: RBToken
comments
	^comments
%

category: 'accessing'
method: RBToken
comments: anObject
	comments := anObject
%

category: 'testing'
method: RBToken
isAssignment
	^false
%

category: 'testing'
method: RBToken
isBinary
	^false
%

category: 'testing'
method: RBToken
isIdentifier
	^false
%

category: 'testing'
method: RBToken
isKeyword
	^false
%

category: 'testing'
method: RBToken
isLiteral
	^self isLiteralToken
%

category: 'testing'
method: RBToken
isLiteralArrayToken
	^false
%

category: 'testing'
method: RBToken
isLiteralToken
	^false
%

category: 'testing'
method: RBToken
isPath
  ^ false
%

category: 'testing'
method: RBToken
isPatternBlock
	^false
%

category: 'testing'
method: RBToken
isPatternVariable
	^false
%

category: 'testing'
method: RBToken
isSpecial
	^false
%

category: 'accessing'
method: RBToken
length
	^self subclassResponsibility
%

category: 'printing'
method: RBToken
printOn: aStream 
	aStream
		nextPut: $ ;
		nextPutAll: self class name
%

category: 'printing'
method: RBToken
rbStoreString

"Returns a string that, when evaluated, will recreate a copy of the
 receiver.  The default is to use storeOn: to create the description."

| stream str |
str := String new.
stream := WriteStreamPortable on: str.
self rbStoreOn: stream.
^str
%

category: 'accessing'
method: RBToken
removePositions
	sourcePointer := nil
%

category: 'accessing'
method: RBToken
start
	^ sourcePointer ifNil: [ 0 ]
%

category: 'initialize-release'
method: RBToken
start: anInteger 
	sourcePointer := anInteger
%

category: 'accessing'
method: RBToken
stop
	^ sourcePointer isNil 
		ifTrue: [ -1 ]
		ifFalse: [ self start + self length - 1 ]
%

! Class implementation for 'RBAssignmentToken'

!		Instance methods for 'RBAssignmentToken'

category: 'testing'
method: RBAssignmentToken
isAssignment
	^true
%

category: 'private'
method: RBAssignmentToken
length
	^2
%

! Class implementation for 'RBShortAssignmentToken'

!		Instance methods for 'RBShortAssignmentToken'

category: 'private'
method: RBShortAssignmentToken
length
	^ 1
%

! Class implementation for 'RBValueToken'

!		Class methods for 'RBValueToken'

category: 'instance creation'
classmethod: RBValueToken
value: aString start: anInteger 
	^self new value: aString start: anInteger
%

!		Instance methods for 'RBValueToken'

category: 'private'
method: RBValueToken
length
	^value size
%

category: 'printing'
method: RBValueToken
printOn: aStream
	super printOn: aStream.
	aStream nextPut: $(.
	value printOn: aStream.
	aStream nextPutAll: ')'
%

category: 'accessing'
method: RBValueToken
value
	^value
%

category: 'accessing'
method: RBValueToken
value: anObject
	value := anObject
%

category: 'initialize-release'
method: RBValueToken
value: aString start: anInteger 
	value := aString.
	sourcePointer := anInteger
%

! Class implementation for 'RBBinarySelectorToken'

!		Instance methods for 'RBBinarySelectorToken'

category: 'testing'
method: RBBinarySelectorToken
isBinary
	^true
%

! Class implementation for 'RBIdentifierToken'

!		Instance methods for 'RBIdentifierToken'

category: 'testing'
method: RBIdentifierToken
isIdentifier
	^true
%

category: 'testing'
method: RBIdentifierToken
isPatternVariable
	^value first = RBScanner patternVariableCharacter
%

! Class implementation for 'RBPathToken'

!		Instance methods for 'RBPathToken'

category: 'testing'
method: RBPathToken
isPath
  ^ true
%

! Class implementation for 'RBKeywordToken'

!		Instance methods for 'RBKeywordToken'

category: 'testing'
method: RBKeywordToken
isKeyword
	^true
%

category: 'testing'
method: RBKeywordToken
isPatternVariable
	^value first = RBScanner patternVariableCharacter
%

! Class implementation for 'RBLiteralArrayToken'

!		Instance methods for 'RBLiteralArrayToken'

category: 'testing'
method: RBLiteralArrayToken
isForByteArray
	^value last = $[
%

category: 'testing'
method: RBLiteralArrayToken
isLiteralArrayToken
	^true
%

! Class implementation for 'RBLiteralToken'

!		Class methods for 'RBLiteralToken'

category: 'instance creation'
classmethod: RBLiteralToken
value: anObject 
	| literal |
	literal := anObject class == Array 
				ifTrue: [anObject collect: [:each | self value: each]]
				ifFalse: [anObject].
	^self 
		value: literal
		start: nil
		stop: nil
%

category: 'instance creation'
classmethod: RBLiteralToken
value: aString start: anInteger stop: stopInteger 
	^(self new)
		value: aString
			start: anInteger
			stop: stopInteger;
		yourself
%

!		Instance methods for 'RBLiteralToken'

category: 'testing'
method: RBLiteralToken
isLiteralToken
	^true
%

category: 'testing'
method: RBLiteralToken
isMultiKeyword
	^false
%

category: 'private'
method: RBLiteralToken
length
	^stopPosition - self start + 1
%

category: 'printing'
method: RBLiteralToken
rbStoreOn: aStream
    value isSymbol
        ifTrue: [ 
            aStream nextPut: $#.
            value asString printOn: aStream.
            ^ self ].
    value class == Character
        ifTrue: [ 
            aStream
                nextPut: $$;
                nextPut: value.
            ^ self ].
    value rbStoreOn: aStream
%

category: 'accessing'
method: RBLiteralToken
realValue
	^value
%

category: 'accessing'
method: RBLiteralToken
stop: anObject 
	stopPosition := anObject
%

category: 'initialize-release'
method: RBLiteralToken
value: aString start: anInteger stop: stopInteger 
	value := aString.
	sourcePointer := anInteger.
	stopPosition := stopInteger
%

! Class implementation for 'RBMultiKeywordLiteralToken'

!		Instance methods for 'RBMultiKeywordLiteralToken'

category: 'testing'
method: RBMultiKeywordLiteralToken
isMultiKeyword
	^true
%

! Class implementation for 'RBNumberLiteralToken'

!		Class methods for 'RBNumberLiteralToken'

category: 'instance creation'
classmethod: RBNumberLiteralToken
value: aNumber start: anInteger stop: stopInteger source: sourceString 
	^(self 
		value: aNumber
		start: anInteger
		stop: stopInteger)
		source: sourceString;
		yourself
%

!		Instance methods for 'RBNumberLiteralToken'

category: 'printing'
method: RBNumberLiteralToken
rbStoreOn: aStream 
	aStream nextPutAll: source
%

category: 'accessing'
method: RBNumberLiteralToken
source
	^source
%

category: 'initialize-release'
method: RBNumberLiteralToken
source: aString 
	source := aString
%

! Class implementation for 'RBPatternBlockToken'

!		Instance methods for 'RBPatternBlockToken'

category: 'testing'
method: RBPatternBlockToken
isPatternBlock
	^true
%

! Class implementation for 'RBSpecialCharacterToken'

!		Instance methods for 'RBSpecialCharacterToken'

category: 'testing'
method: RBSpecialCharacterToken
isSpecial
	^true
%

category: 'private'
method: RBSpecialCharacterToken
length
	^1
%

! Class implementation for 'Rowan'

!		Class methods for 'Rowan'

category: 'public client services'
classmethod: Rowan
answeringServiceClass

	^ self platform answeringServiceClass
%

category: 'public'
classmethod: Rowan
automaticClassInitializationBlackList

	"Answer list of project names for which automatic class initialiation should be disabled."

	^ self platform automaticClassInitializationBlackList
%

category: 'public client services'
classmethod: Rowan
browserServiceClass

	^ self platform browserServiceClass
%

category: 'public client services'
classmethod: Rowan
classServiceClass

	^ self platform classServiceClass
%

category: 'public tools'
classmethod: Rowan
classTools

	^ self platform classTools
%

category: 'public'
classmethod: Rowan
clearAutomaticClassInitializationBlackList

	"Clear list of project names for which automatic class initialiation should be disabled."

	^ self platform clearAutomaticClassInitializationBlackList
%

category: 'public'
classmethod: Rowan
clearDefaultAutomaticClassInitializationBlackList

	"Clear default list of project names for which automatic class initialiation should be disabled.
		Individual users may override the black list."

	^ self platform clearAutomaticClassInitializationBlackList_default
%

category: 'public client services'
classmethod: Rowan
commandResultClass

	^ self platform commandResultClass
%

category: 'public'
classmethod: Rowan
configuration

	^configuration
%

category: 'public'
classmethod: Rowan
defaultAutomaticClassInitializationBlackList

	"Answer default list of project names for which automatic class initialiation should be disabled.
		Individual users may override the black list."

	^ self platform automaticClassInitializationBlackList_default
%

category: 'public tools'
classmethod: Rowan
gitTools

	^ self platform gitTools
%

category: 'public'
classmethod: Rowan
globalNamed: aName

	"Answer a global object with the given name.  If no object with the given name is found, returns nil."

	^ self platform globalNamed: aName
%

category: 'private'
classmethod: Rowan
image
	"Private to the Cypress system."

	^self platform image
%

category: 'public client services'
classmethod: Rowan
jadeServerClassNamed: className

	^ self platform jadeServerClassNamed: className
%

category: 'public client services'
classmethod: Rowan
loggingServiceClass

	^ self platform loggingServiceClass
%

category: 'public client services'
classmethod: Rowan
methodServiceClass

	^ self platform methodServiceClass
%

category: 'public'
classmethod: Rowan
packageNames

	"Return list of package names"

	^ self image packageNames
%

category: 'public client services'
classmethod: Rowan
packageServiceClass

	^ self platform packageServiceClass
%

category: 'public tools'
classmethod: Rowan
packageTools

	^self platform packageTools
%

category: 'private'
classmethod: Rowan
platform

	^ RwPlatform current
%

category: 'public'
classmethod: Rowan
platformConditionalAttributes

	"Return list of platform-specific conditional attributes for use by components"

	^ self platform platformConditionalAttributes
%

category: 'public'
classmethod: Rowan
projectNamed: aName

	"Answer a project with the given name.  If no project with the given name is found, signals error."

	^ self 
		projectNamed: aName 
			ifPresent: [:loadedProject | loadedProject ]
			ifAbsent: [ self error: 'The project ', aName printString, ' was not found' ]
%

category: 'public'
classmethod: Rowan
projectNamed: aName ifAbsent: absentBlock

	"Lookup a project with the given name, if found return the project. if not found evaluate the <absentBlock>."

	^ self 
		projectNamed: aName 
			ifPresent: [:loadedProject | loadedProject ]
			ifAbsent: absentBlock
%

category: 'public'
classmethod: Rowan
projectNamed: aName ifPresent: presentBlock

	"Lookup a project with the given name, if found evaluate the <presentBlock>. if not found return nil."

	^ self 
		projectNamed: aName 
			ifPresent: presentBlock
			ifAbsent: []
%

category: 'public'
classmethod: Rowan
projectNamed: aName ifPresent: presentBlock ifAbsent: absentBlock

	"Lookup a project with the given name, if found evaluate the <presentBlock>, if not evaluate the <absentBlock.."

	^ self platform 
		projectNamed: aName 
			ifPresent: presentBlock 
			ifAbsent: absentBlock
%

category: 'public'
classmethod: Rowan
projectNames

	"Return list of project names"

	^ self image projectNames
%

category: 'public'
classmethod: Rowan
projects
	"Return list of projects"

	^ self projectNames collect: [ :projectName | self projectNamed: projectName ]
%

category: 'public client services'
classmethod: Rowan
projectServiceClass

	^ self platform projectServiceClass
%

category: 'public tools'
classmethod: Rowan
projectTools

	^self platform projectTools
%

category: 'public client services'
classmethod: Rowan
serviceClass

	^ self platform serviceClass
%

category: 'public'
classmethod: Rowan
unpackagedName
	"Answer the name used for projects and packages that are not in a package ... unpackaged projects and packages are where pacakge things go by default."

	^ '(NONE)'
%

category: 'public'
classmethod: Rowan
unpackagedPackagePrefix
	"Answer the prefix used for naming unpackaged packages"

	^ self unpackagedProjectName , '-'
%

category: 'public'
classmethod: Rowan
unpackagedProjectName
	"Answer the name of the unpackaged project that manages unpackaged things"

	^ 'UnPackaged'
%

category: 'public'
classmethod: Rowan
version
	^ (self projectNamed: 'Rowan') projectVersion
		ifNil: [ RwSemanticVersionNumber fromString: self versionString ]
%

category: 'public'
classmethod: Rowan
versionString
	^ '3.5.0'
%

! Class implementation for 'RowanGsGeneralDependencySorter'

!		Class methods for 'RowanGsGeneralDependencySorter'

category: 'instance creation'
classmethod: RowanGsGeneralDependencySorter
on: someCandidates dependsOn: aOneArgBlock dependent: anotherOneArgBlock
	"Create an instance of the receiver capable for sorting the dependencies of someCandidates.
	 aOneArgBlock is used to evaluate the key of the object depended on for a candidate.
	 anotherOneArgBlock is used to evaluate the key of the candidate itself."

	^self new
		initializeOn: someCandidates dependsOn: aOneArgBlock dependent: anotherOneArgBlock;
		yourself.
%

!		Instance methods for 'RowanGsGeneralDependencySorter'

category: 'sorting - private'
method: RowanGsGeneralDependencySorter
determineGraphRoots
  ^ dependencyGraphs
    selectAssociations: [ :each | (candidateAliasMap includesKey: each key) not ]
%

category: 'initializing - private'
method: RowanGsGeneralDependencySorter
initializeOn: someCandidates dependsOn: aOneArgBlock dependent: anotherOneArgBlock

	candidates := someCandidates.
	dependsOnConverter := aOneArgBlock.
	dependentConverter := anotherOneArgBlock.
	individualDependencyMap := Dictionary new.
	dependencyGraphs := Dictionary new.
	candidateAliasMap := Dictionary new
%

category: 'sorting'
method: RowanGsGeneralDependencySorter
inOrder
  | sorted sortedRoots |
  sorted := OrderedCollection new.
  self mapCandidatesIntoGraphs.
  sortedRoots := SortedCollection sortBlock: [ :a :b | a key <= b key ].
  self determineGraphRoots associationsDo: [ :assoc | sortedRoots add: assoc ].
  sortedRoots do: [ :assoc | self transcribeGraph: assoc value into: sorted ].
  ^ sorted
%

category: 'sorting - private'
method: RowanGsGeneralDependencySorter
mapCandidatesIntoGraphs

	| dependsOnKey dependentKey |
	candidates do: 
			[:each |
			| individualDependency |
			dependsOnKey := dependsOnConverter value: each.
			dependentKey := dependentConverter value: each.
			candidateAliasMap at: dependentKey put: each.
			individualDependencyMap at: dependsOnKey ifAbsentPut: [Dictionary new].
			individualDependencyMap at: dependentKey ifAbsentPut: [Dictionary new].
			individualDependency := individualDependencyMap
						associationAt: dependsOnKey.
			(dependencyGraphs includesKey: dependsOnKey)
				ifFalse: [dependencyGraphs add: individualDependency].
			individualDependency value
				add: (individualDependencyMap associationAt: dependentKey)]
%

category: 'sorting - private'
method: RowanGsGeneralDependencySorter
transcribeGraph: subtree into: sorted
  (subtree keys asSortedCollection: [ :a :b | a <= b ])
    do: [ :name | | subsubtree |
      subsubtree := subtree at: name.
      sorted add: (candidateAliasMap at: name).
      self transcribeGraph: subsubtree into: sorted ]
%

! Class implementation for 'RowanInterface'

!		Class methods for 'RowanInterface'

category: 'instance creation'
classmethod: RowanInterface
newNamed: aName

	^ self new
		initializeForName: aName;
		yourself
%

!		Instance methods for 'RowanInterface'

category: 'accessing'
method: RowanInterface
classes

	| classes |
	classes := IdentitySet new.
	classes
		addAll: self extendedClasses;
		addAll: self definedClasses.
	^ classes
%

category: 'accessing'
method: RowanInterface
definedClasses

	^ self subclassResponsibility: #'definedClasses'
%

category: 'accessing'
method: RowanInterface
extendedClasses

	^ self subclassResponsibility: #'extendedClasses'
%

category: 'initialization'
method: RowanInterface
initializeForName: aName

	name := aName
%

category: 'accessing'
method: RowanInterface
name

	^ name
%

category: 'printing'
method: RowanInterface
printOn: aStream
	super printOn: aStream.
	self name
		ifNotNil: [:aString |
			aStream
				nextPutAll: ' for ';
				nextPutAll:  aString ]
%

category: 'accessing'
method: RowanInterface
project

	^ RwProject newNamed: self _loadedProject name
%

category: 'private'
method: RowanInterface
_loadedProject

	^ self subclassResponsibility: #'_loadedProject'
%

category: 'private'
method: RowanInterface
_projectTools

	^ Rowan projectTools
%

! Class implementation for 'RwAbstractProject'

!		Instance methods for 'RwAbstractProject'

category: 'properties'
method: RwAbstractProject
comment

	^ self _concreteProject comment
%

category: 'accessing'
method: RwAbstractProject
componentNamed: componentName
	^ self _concreteProject componentNamed: componentName
%

category: 'accessing'
method: RwAbstractProject
componentNames
	"list of component names from the load specification used to load the project "

	^ self _concreteProject componentNames
%

category: 'accessing'
method: RwAbstractProject
customConditionalAttributes
	"Answer the customConditionalAttributes that would be used to load the project"
	^ self _concreteProject customConditionalAttributes
%

category: 'transitions'
method: RwAbstractProject
defined
	self subclassResponsibility: #'defined'
%

category: 'accessing'
method: RwAbstractProject
diskUrl
	^ self _concreteProject diskUrl
%

category: 'accessing'
method: RwAbstractProject
gemstoneDefaultMethodEnv
	^ self _concreteProject gemstoneDefaultMethodEnv
%

category: 'accessing'
method: RwAbstractProject
gemstoneDefaultMethodEnvForUser: userId
	^ self _concreteProject gemstoneDefaultMethodEnvForUser: userId
%

category: 'accessing'
method: RwAbstractProject
gemstoneDefaultSymbolDictName
	^ self _concreteProject gemstoneDefaultSymbolDictName
%

category: 'accessing'
method: RwAbstractProject
gemstoneDefaultSymbolDictNameForUser: userId
	^ self _concreteProject gemstoneDefaultSymbolDictNameForUser: userId
%

category: 'accessing'
method: RwAbstractProject
gemstoneDefaultUseSessionMethodsForExtensions
	^ self _concreteProject gemstoneDefaultUseSessionMethodsForExtensions
%

category: 'accessing'
method: RwAbstractProject
gemstoneDefaultUseSessionMethodsForExtensionsForUser: userId
	^ self _concreteProject
		gemstoneDefaultUseSessionMethodsForExtensionsForUser: userId
%

category: 'querying'
method: RwAbstractProject
gemstoneMethodEnvForPackageNamed: packageName

	^ self _concreteProject gemstoneMethodEnvForPackageNamed: packageName
%

category: 'querying'
method: RwAbstractProject
gemstoneMethodEnvForPackageNamed: packageName forUser: userId
	^ self _concreteProject
		gemstoneMethodEnvForPackageNamed: packageName
		forUser: userId
%

category: 'querying'
method: RwAbstractProject
gemstoneSymbolDictNameForPackageNamed: packageName

	^ self _concreteProject gemstoneSymbolDictNameForPackageNamed: packageName
%

category: 'querying'
method: RwAbstractProject
gemstoneSymbolDictNameForPackageNamed: packageName forUser: userId
	^ self _concreteProject
		gemstoneSymbolDictNameForPackageNamed: packageName
		forUser: userId
%

category: 'querying'
method: RwAbstractProject
gemstoneUseSessionMethodsForExtensionsForPackageNamed: packageName
	^ self _concreteProject
		gemstoneUseSessionMethodsForExtensionsForPackageNamed: packageName
%

category: 'querying'
method: RwAbstractProject
gemstoneUseSessionMethodsForExtensionsForPackageNamed: packageName forUser: userId
	^ self _concreteProject
		gemstoneUseSessionMethodsForExtensionsForPackageNamed: packageName
		forUser: userId
%

category: 'accessing'
method: RwAbstractProject
gitRoot
	^ self _concreteProject gitRoot
%

category: 'accessing'
method: RwAbstractProject
gitUrl
	^ self _concreteProject gitUrl
%

category: 'accessing'
method: RwAbstractProject
loadSpecification
	^ self _concreteProject loadSpecification
%

category: 'accessing'
method: RwAbstractProject
packageConvention
	^ self _concreteProject packageConvention
%

category: 'accessing'
method: RwAbstractProject
packageNames
	^self _concreteProject packageNames
%

category: 'accessing'
method: RwAbstractProject
platformConditionalAttributes
	"Answer the platformConditionalAttributes that would be used to load the project"
	^ self _concreteProject platformConditionalAttributes
%

category: 'accessing'
method: RwAbstractProject
project

	^ self
%

category: 'accessing'
method: RwAbstractProject
projectAlias
	^ self loadSpecification projectAlias
%

category: 'accessing'
method: RwAbstractProject
projectName
	^ self name
%

category: 'accessing'
method: RwAbstractProject
projectsHome
	"projects home specifies the disk location where projects cloned/created by the receiver will be located."

	^ self _concreteProject projectsHome
%

category: 'accessing'
method: RwAbstractProject
projectsHome: aProjectHomeReferenceOrString
	self _concreteProject projectsHome: aProjectHomeReferenceOrString
%

category: 'accessing'
method: RwAbstractProject
projectVersion
	^ self _concreteProject projectVersion
%

category: 'accessing'
method: RwAbstractProject
readOnlyDiskUrl
	^ self _concreteProject readOnlyDiskUrl
%

category: 'accessing'
method: RwAbstractProject
relativeRepositoryRoot
	"return the repository root relative to the git repository root ... not applicable to non-git (svn, etc.) repositories"

	^ self loadSpecification relativeRepositoryRoot
%

category: 'accessing'
method: RwAbstractProject
remote

	^ self _concreteProject remote
%

category: 'querying'
method: RwAbstractProject
requiredProjectNames
	^ self _concreteProject requiredProjectNames
%

category: 'private'
method: RwAbstractProject
_concreteProject
	self subclassResponsibility: #'_concreteProject'
%

! Class implementation for 'RwAbstractUnloadedProject'

!		Instance methods for 'RwAbstractUnloadedProject'

category: 'accessing'
method: RwAbstractUnloadedProject
comment: aString
	self _concreteProject comment: aString
%

category: 'accessing'
method: RwAbstractUnloadedProject
diskUrl: aString
	self loadSpecification diskUrl: aString
%

category: 'accessing'
method: RwAbstractUnloadedProject
gemstoneSetDefaultMethodEnvForUser: userId to: env
	self _concreteProject gemstoneSetDefaultMethodEnvForUser: userId to: env
%

category: 'accessing'
method: RwAbstractUnloadedProject
gemstoneSetDefaultMethodEnvTo: env
	self _concreteProject gemstoneSetDefaultMethodEnvTo: env
%

category: 'accessing'
method: RwAbstractUnloadedProject
gemstoneSetDefaultSymbolDictNameForUser: userId to: symbolDictName
	self _concreteProject gemstoneSetDefaultSymbolDictNameForUser: userId to: symbolDictName
%

category: 'accessing'
method: RwAbstractUnloadedProject
gemstoneSetDefaultSymbolDictNameTo: symbolDictName
	self _concreteProject gemstoneSetDefaultSymbolDictNameTo: symbolDictName
%

category: 'accessing'
method: RwAbstractUnloadedProject
gemstoneSetDefaultUseSessionMethodsForExtensionsForUser: userId to: aBool
	self _concreteProject gemstoneSetDefaultUseSessionMethodsForExtensionsForUser: userId to: aBool
%

category: 'accessing'
method: RwAbstractUnloadedProject
gemstoneSetDefaultUseSessionMethodsForExtensionsTo: aBool
	self _concreteProject gemstoneSetDefaultUseSessionMethodsForExtensionsTo: aBool
%

category: 'accessing'
method: RwAbstractUnloadedProject
gemstoneSetMethodEnv: env forPackageNamed: packageName
	self _concreteProject gemstoneSetMethodEnv: env forPackageNamed: packageName
%

category: 'accessing'
method: RwAbstractUnloadedProject
gemstoneSetMethodEnvForUser: userId to: env forPackageNamed: packageName
	self _concreteProject
		gemstoneSetMethodEnvForUser: userId
		to: env
		forPackageNamed: packageName
%

category: 'accessing'
method: RwAbstractUnloadedProject
gemstoneSetSymbolDictName: symbolDictName forPackageNamed: packageName
	self _concreteProject
		gemstoneSetSymbolDictName: symbolDictName
		forPackageNamed: packageName
%

category: 'accessing'
method: RwAbstractUnloadedProject
gemstoneSetSymbolDictNameForUser: userId to: symbolDictName forPackageNamed: packageName
	self _concreteProject
		gemstoneSetSymbolDictNameForUser: userId
		to: symbolDictName
		forPackageNamed: packageName
%

category: 'accessing'
method: RwAbstractUnloadedProject
gemstoneSetUseSessionMethodsForExtensions: userId to: aBool
	self _concreteProject
		gemstoneSetUseSessionMethodsForExtensions: userId
		to: aBool
%

category: 'accessing'
method: RwAbstractUnloadedProject
gemstoneSetUseSessionMethodsForExtensionsForUser: userId to: aBool forPackageNamed: packageName
	self _concreteProject
		gemstoneSetUseSessionMethodsForExtensionsForUser: userId
		to: aBool
		forPackageNamed: packageName
%

category: 'accessing'
method: RwAbstractUnloadedProject
gitUrl: aString
	self _concreteProject gitUrl: aString
%

category: 'transitions'
method: RwAbstractUnloadedProject
load
	"
		load only the receiver into the image. Required projects for the receiver are only loaded if they are 
			not already present in the image.

		To explicitly load the receiver AND required projects, construct a project set containing projects to 
			be loaded and send #load to the project set.
	"

	^ self _concreteProject load
%

category: 'accessing'
method: RwAbstractUnloadedProject
packageConvention
	^ self _concreteProject packageConvention
%

category: 'accessing'
method: RwAbstractUnloadedProject
packageFormat: aString
	^ self _concreteProject packageFormat: aString
%

category: 'actions'
method: RwAbstractUnloadedProject
packages
	^ self _concreteProject packages
%

category: 'actions'
method: RwAbstractUnloadedProject
packages: aPackageDictionary
	self _concreteProject packages: aPackageDictionary
%

category: 'accessing'
method: RwAbstractUnloadedProject
projectVersion: aStringOrVersion
	^ self _concreteProject projectVersion: aStringOrVersion
%

category: 'accessing'
method: RwAbstractUnloadedProject
readOnlyDiskUrl: aString
	self _concreteProject readOnlyDiskUrl: aString
%

category: 'accessing'
method: RwAbstractUnloadedProject
relativeRepositoryRoot: aRelativePathString
	"specify the repository root relative to the git repository root ... not applicable to non-git (svn, etc.) repositories"

	self loadSpecification relativeRepositoryRoot: aRelativePathString
%

category: 'accessing'
method: RwAbstractUnloadedProject
repositoryResolutionPolicy
	^ self loadSpecification repositoryResolutionPolicy
%

category: 'accessing'
method: RwAbstractUnloadedProject
repositoryResolutionPolicy: aSymbolOrNil
	self loadSpecification repositoryResolutionPolicy: aSymbolOrNil
%

category: 'accessing'
method: RwAbstractUnloadedProject
specComponentNames: anArray
	self loadSpecification componentNames: anArray
%

category: 'accessing'
method: RwAbstractUnloadedProject
specName
	^ self loadSpecification specName
%

category: 'querying'
method: RwAbstractUnloadedProject
subcomponentsOf: componentName
	"list of direct subcomponents of the given <componentName> ...includes package groups"

	^ self subcomponentsOf: componentName ifNone: [ ^ {} ]
%

category: 'querying'
method: RwAbstractUnloadedProject
subcomponentsOf: componentName attributes: attributes ifNone: noneBlock
	| subcomponents |
	subcomponents := self _projectComponents
		subcomponentsOf: componentName
		matchBlock: [ :aComponent | aComponent matchesAttributes: attributes ]
		ifNone: [ ^ noneBlock value ].
	subcomponents isEmpty
		ifTrue: [ ^ noneBlock value ].
	^ subcomponents
%

category: 'querying'
method: RwAbstractUnloadedProject
subcomponentsOf: componentName ifNone: noneBlock
	"list of direct subcomponents of the given <componentName> ...includes package groups"

	| subcomponents |
	subcomponents := self _projectComponents
		subcomponentsOf: componentName
		matchBlock: [ :aComponent | 
			"match all components"
			true ]
		ifNone: [ ^ noneBlock value ].
	subcomponents isEmpty
		ifTrue: [ ^ noneBlock value ].
	^ subcomponents
%

category: 'testing'
method: RwAbstractUnloadedProject
useGit

	^self _concreteProject useGit
%

category: 'private'
method: RwAbstractUnloadedProject
_concreteProject
	^ concreteProject
%

category: 'private'
method: RwAbstractUnloadedProject
_concreteProject: aResolvedProject
	concreteProject := aResolvedProject
%

category: 'private'
method: RwAbstractUnloadedProject
_projectComponents
	^ self _concreteProject _projectComponents
%

category: 'private'
method: RwAbstractUnloadedProject
_projectDefinition
	^ self _concreteProject _projectDefinition
%

category: 'private'
method: RwAbstractUnloadedProject
_projectRepository
	^ self _concreteProject _projectRepository
%

category: 'private'
method: RwAbstractUnloadedProject
_projectSpecification
	^ self _concreteProject _projectSpecification
%

! Class implementation for 'RwDefinedProject'

!		Class methods for 'RwDefinedProject'

category: 'instance creation'
classmethod: RwDefinedProject
fromResolvedProject: aResolvedProject
	^ (self newNamed: aResolvedProject name)
		_concreteProject: aResolvedProject _concreteProject;
		yourself
%

category: 'instance creation'
classmethod: RwDefinedProject
newNamed: aName
	"Create a new project that uses Rowan v3 project spec and component classes"

	^ self new
		initializeForName: aName;
		_concreteProject;
		yourself
%

category: 'instance creation'
classmethod: RwDefinedProject
newV2Named: aName
	"Create a new project that uses project spec and component classes that are compatible with Rowan v2"

	^ self new
		initializeForName: aName;
		_concreteProjectV2;
		yourself
%

category: 'instance creation'
classmethod: RwDefinedProject
newV4Named: aName
	"Create a new project that uses project spec and component classes that are compatible with Rowan v4"

	^ self new
		initializeForName: aName;
		_concreteProjectV4;
		yourself
%

!		Instance methods for 'RwDefinedProject'

category: 'components'
method: RwDefinedProject
addComponentNamed: componentName toComponentNamed: toComponentName
	"add existing component named componentName to component named toComponentName"

	^ self _concreteProject
		addComponentNamed: componentName
		toComponentNamed: toComponentName
%

category: 'accessing'
method: RwDefinedProject
addComponentNames: anArray
	"add to the existing component names"

	^ self _concreteProject addComponentNames: anArray
%

category: 'components'
method: RwDefinedProject
addComponentOrPackageGroup: aComponentOrPackageGroup toComponentNamed: toComponentName
	"add existing component to component named toComponentName"

	self _concreteProject
		addComponentOrPackageGroup: aComponentOrPackageGroup
		toComponentNamed: toComponentName
%

category: 'component structure'
method: RwDefinedProject
addComponentStructureFor: componentBasename startingAtComponentNamed: toComponentName pathNameArray: pathNameArray conditionPathArray: conditionPathArray
	"
	<pathNameArray> and <conditionPathArray> should be of equal size. The 
		<pathNameArray> lists the names of the directories that will be created 
		on demand starting in the parent directory of the <toComponentName> 
		component. <conditionPathArray> lists the conditions that will be used 
		when creating the subcomponent at each level. If the condition is an Array
		a platform subcomponent will be created, otherwise a subcomponent
		will be created. The name of each subcomponent formed using 
		<componentBasename> and the directory path based on the <pathNameArray>.
		The name of the first subcomponent created will be added to the component
		names of the <toComponentName> component.

	Return the last component created.
	"

	^ self
		addComponentStructureFor: componentBasename
		startingAtComponentNamed: toComponentName
		pathNameArray: pathNameArray
		conditionPathArray: conditionPathArray
		comment: ''
%

category: 'component structure'
method: RwDefinedProject
addComponentStructureFor: componentBasename startingAtComponentNamed: toComponentName pathNameArray: pathNameArray conditionPathArray: conditionPathArray comment: aString
	"
	<pathNameArray> and <conditionPathArray> should be of equal size. The 
		<pathNameArray> lists the names of the directories that will be created 
		on demand starting in the parent directory of the <toComponentName> 
		component. <conditionPathArray> lists the conditions that will be used 
		when creating the subcomponent at each level. If the condition is an Array
		a platform subcomponent will be created, otherwise a subcomponent
		will be created. The name of each subcomponent formed using 
		<componentBasename> and the directory path based on the <pathNameArray>.
		The name of the first subcomponent created will be added to the component
		names of the <toComponentName> component.

	Return the last component created.
	"

	^ self _concreteProject
		addComponentStructureFor: componentBasename
		startingAtComponentNamed: toComponentName
		pathNameArray: pathNameArray
		conditionPathArray: conditionPathArray
		comment: aString
%

category: 'accessing'
method: RwDefinedProject
addCustomConditionalAttributes: anArray
	"add to the existing custom conditional attributes"

	^ self _concreteProject addCustomConditionalAttributes: anArray
%

category: 'components'
method: RwDefinedProject
addLoadComponentNamed: componentName
	"add a new instance of RwLoadComponent to the project components and add the componentName
		to the load spec (i.e., it will be loaded when the load spec is loaded)"

	^ self addLoadComponentNamed: componentName comment: ''
%

category: 'components'
method: RwDefinedProject
addLoadComponentNamed: componentName comment: aString
	"add a new instance of RwLoadComponent to the project components and add the componentName
		to the load spec (i.e., it will be loaded when the load spec is loaded)"

	^ self _concreteProject addLoadComponentNamed: componentName comment: aString
%

category: 'components'
method: RwDefinedProject
addPackageGroupNamed: aComponentName condition: condition comment: aString
	^ self _concreteProject
		addPackageGroupNamed: aComponentName
		condition: condition
		comment: aString
%

category: 'component structure'
method: RwDefinedProject
addPackageGroupStructureFor: componentBasename startingAtComponentNamed: toComponentName pathNameArray: pathNameArray conditionPathArray: conditionPathArray comment: aString
	"
	<pathNameArray> and <conditionPathArray> should be of equal size. The 
		<pathNameArray> lists the names of the directories that will be created 
		on demand starting in the parent directory of the <toComponentName> 
		component. <conditionPathArray> lists the conditions that will be used 
		when creating the package group at each level. The name of each
		package group is formed using  <componentBasename> and the directory
		path based on the <pathNameArray>. The name of the first pacakge 
		group created will be added to the component names of the 
		<toComponentName> component.

	Return the last component created.
	"

	^ self _concreteProject
		addPackageGroupStructureFor: componentBasename
		startingAtComponentNamed: toComponentName
		pathNameArray: pathNameArray
		conditionPathArray: conditionPathArray
		comment: aString
%

category: 'accessing'
method: RwDefinedProject
addPackageNamed: packageName
	"the package is expected to already be present in a component - used when reading packages from disk"

	^ self _concreteProject addPackageNamed: packageName
%

category: 'accessing'
method: RwDefinedProject
addPackageNamed: packageName toComponentNamed: componentName
	^ self _concreteProject
		addPackageNamed: packageName
		toComponentNamed: componentName
%

category: 'accessing'
method: RwDefinedProject
addPackageNamed: packageName toComponentNamed: componentName gemstoneDefaultSymbolDictionaryForUser: aSymbolDictAssoc
	^ self _concreteProject
		addPackageNamed: packageName
		toComponentNamed: componentName
		gemstoneDefaultSymbolDictionaryForUser: aSymbolDictAssoc
%

category: 'accessing'
method: RwDefinedProject
addPackagesNamed: packageNames toComponentNamed: componentName
	^ self _concreteProject
		addPackagesNamed: packageNames
		toComponentNamed: componentName
%

category: 'components'
method: RwDefinedProject
addPlatformSubcomponentNamed: componentName condition: condition comment: aString
	^ self _concreteProject
		addPlatformSubcomponentNamed: componentName
		condition: condition
		comment: aString
%

category: 'components'
method: RwDefinedProject
addPlatformSubcomponentNamed: componentName condition: condition comment: aString toComponentNamed: toComponentName
	"Add the named subcomponent with the given condition to the named project and add the new component to the toComponentName component"

	^ self _concreteProject
		addPlatformSubcomponentNamed: componentName
		condition: condition
		comment: aString
		toComponentNamed: toComponentName
%

category: 'components'
method: RwDefinedProject
addPlatformSubcomponentNamed: componentName condition: condition toComponentNamed: toComponentName
	"Add the named subcomponent with the given condition to the named project and add the new component to the toComponentName component"

	^ self
		addPlatformSubcomponentNamed: componentName
		condition: condition
		comment: ''
		toComponentNamed: toComponentName
%

category: 'accessing'
method: RwDefinedProject
addPostloadDoitName: doitName withSource: doitSource toComponentNamed: aComponentName
	^ self _concreteProject
		addPostloadDoitName: doitName
		withSource: doitSource
		toComponentNamed: aComponentName
%

category: 'accessing'
method: RwDefinedProject
addPreloadDoitName: doitName withSource: doitSource toComponentNamed: aComponentName
	^ self _concreteProject
		addPreloadDoitName: doitName
		withSource: doitSource
		toComponentNamed: aComponentName
%

category: 'accessing'
method: RwDefinedProject
addProjectNamed: projectName toComponentNamed: toComponentName
	^ self _concreteProject
		addProjectNamed: projectName
		toComponentNamed: toComponentName
%

category: 'accessing'
method: RwDefinedProject
addRawPackageNamed: packageName
	^ self _concreteProject addRawPackageNamed: packageName
%

category: 'components'
method: RwDefinedProject
addSubcomponentNamed: componentName condition: condition
	^ self _concreteProject
		addSubcomponentNamed: componentName
		condition: condition
%

category: 'components'
method: RwDefinedProject
addSubcomponentNamed: componentName condition: condition comment: aString
	^ self _concreteProject
		addSubcomponentNamed: componentName
		condition: condition
		comment: aString
%

category: 'components'
method: RwDefinedProject
addSubcomponentNamed: componentName condition: condition comment: aString toComponentNamed: toComponentName
	"Add the named subcomponent with the given condition to the named project and add the new component to the toComponentName component"

	^ self _concreteProject
		addSubcomponentNamed: componentName
		condition: condition
		comment: aString
		toComponentNamed: toComponentName
%

category: 'components'
method: RwDefinedProject
addSubcomponentNamed: componentName condition: condition toComponentNamed: toComponentName
	"Add the named subcomponent with the given condition to the named project and add the new component to the toComponentName component"

	^ self addSubcomponentNamed: componentName condition: condition comment: '' toComponentNamed: toComponentName
%

category: 'component structure'
method: RwDefinedProject
addSubcomponentStructureFor: componentBasename startingAtComponentNamed: toComponentName conditionPathArray: conditionPathArray
	"
	PREFERRED method for adding subcomponent structure following the convention that the directory names reflect the condition names.

	When adding platform component structure, where the condition is an Array instead of a String, use 
		addComponentStructureFor:startingAtComponentNamed:pathNameArray:conditionPathArray:.

	Return the last component created.
	"

	^ self 
		addSubcomponentStructureFor: componentBasename
		startingAtComponentNamed: toComponentName
		conditionPathArray: conditionPathArray
		comment: ''
%

category: 'component structure'
method: RwDefinedProject
addSubcomponentStructureFor: componentBasename startingAtComponentNamed: toComponentName conditionPathArray: conditionPathArray comment: aString
	"
	PREFERRED method for adding subcomponent structure following the convention that the directory names reflect the condition names.

	When adding platform component structure, where the condition is an Array instead of a String, use 
		addComponentStructureFor:startingAtComponentNamed:pathNameArray:conditionPathArray:comment:.

	Return the last component created.
	"

	^ self _concreteProject
		addSubcomponentStructureFor: componentBasename
		startingAtComponentNamed: toComponentName
		conditionPathArray: conditionPathArray
		comment: aString
%

category: 'components'
method: RwDefinedProject
addTopLevelComponentNamed: componentName
	"add a new instance of RwLoadComponent to the project components (it will NOT be loaded when the load spec is loaded, however it is a candidate to be used by a load spec)"

	^ self addTopLevelComponentNamed: componentName comment: ''
%

category: 'components'
method: RwDefinedProject
addTopLevelComponentNamed: componentName comment: aString
	"add a new instance of RwLoadComponent to the project components (it will NOT be loaded when the load spec is loaded, however it is a candidate to be used by a load spec)"

	^ self _concreteProject addTopLevelComponentNamed: componentName comment: aString
%

category: 'accessing'
method: RwDefinedProject
componentNamed: aComponentName ifAbsent: absentBlock
	^ self _concreteProject componentNamed: aComponentName ifAbsent: absentBlock
%

category: 'accessing'
method: RwDefinedProject
componentNames: anArray
	^ self _concreteProject componentNames: anArray
%

category: 'accessing'
method: RwDefinedProject
componentOrPackageGroupNamed: componentName
	^ self _concreteProject componentOrPackageGroupNamed: componentName
%

category: 'accessing'
method: RwDefinedProject
componentOrPackageGroupNamed: aComponentName ifAbsent: absentBlock
	^ self _concreteProject componentOrPackageGroupNamed: aComponentName ifAbsent: absentBlock
%

category: 'accessing'
method: RwDefinedProject
componentsPath: aString
	self _projectSpecification componentsPath: aString
%

category: 'accessing'
method: RwDefinedProject
customConditionalAttributes: anArray
	self loadSpecification customConditionalAttributes: anArray
%

category: 'transitions'
method: RwDefinedProject
defined
	^ self
%

category: 'testing'
method: RwDefinedProject
isStrict
	^ self _concreteProject isStrict
%

category: 'accessing'
method: RwDefinedProject
loadSpecification

	^ self _concreteProject loadSpecification
%

category: 'accessing'
method: RwDefinedProject
moveClassExtensionNamed: aClassName fromPackageNamed: fromPackageName toPackageNamed: toPackageName
	^ self _concreteProject
		moveClassExtensionNamed: aClassName
		fromPackageNamed: fromPackageName
		toPackageNamed: toPackageName
%

category: 'accessing'
method: RwDefinedProject
moveClassNamed: aClassName toPackageNamed: aPackageName
	^ self _concreteProject moveClassNamed: aClassName toPackageNamed: aPackageName
%

category: 'accessing'
method: RwDefinedProject
movePackageNamed: aPackageName toComponentNamed: aComponentName
	^ self _concreteProject
		movePackageNamed: aPackageName
		toComponentNamed: aComponentName
%

category: 'accessing'
method: RwDefinedProject
packageConvention: aString
	"
		RowanHybrid	- [default] Class category is package name, method protocol with leading $* is case insensitive package name
		Monticello		- Class category is package name, method protocol with leading $* begins with case insensitive package name
		Rowan			- Class category and method protocol are not overloaded with packaging information
	"

	self _projectSpecification packageConvention: aString
%

category: 'components'
method: RwDefinedProject
packageGroupNamed: componentName
	^ self _concreteProject packageGroupNamed: componentName
%

category: 'components'
method: RwDefinedProject
packageGroupNames
	^ self _projectComponents packageGroupNames
%

category: 'accessing'
method: RwDefinedProject
packageNamed: aString
	^ self _concreteProject packageNamed: aString
%

category: 'accessing'
method: RwDefinedProject
packageNamed: aString ifAbsent: absentBlock
	^ self _concreteProject packageNamed: aString ifAbsent: absentBlock
%

category: 'accessing'
method: RwDefinedProject
packagesPath: aString
	self _projectSpecification packagesPath: aString
%

category: 'accessing'
method: RwDefinedProject
projectAlias: aString
	^ self _concreteProject projectAlias: aString
%

category: 'accessing'
method: RwDefinedProject
projectsPath: aString
	self _projectSpecification projectsPath: aString
%

category: 'accessing'
method: RwDefinedProject
projectSpecFile: relativePathString
	^ self _concreteProject projectSpecFile: relativePathString
%

category: 'accessing'
method: RwDefinedProject
projectSpecPath: aStringOrNil
	"nil value indicates projectSpec file is in repository root directory"

	self _projectSpecification projectSpecPath: aStringOrNil
%

category: 'accessing'
method: RwDefinedProject
projectsRoot
	^ self _concreteProject projectsRoot
%

category: 'accessing'
method: RwDefinedProject
removeComponentNamed: aComponentName
	^ self _concreteProject removeComponentNamed: aComponentName
%

category: 'accessing'
method: RwDefinedProject
removeComponentNames: anArray
	"remove from the existing component names"

	^ self _concreteProject removeComponentNames: anArray
%

category: 'accessing'
method: RwDefinedProject
removeCustomConditionalAttributes: anArray
	"remove from the existing custom conditional attributes"

	^ self _concreteProject removeCustomConditionalAttributes: anArray
%

category: 'accessing'
method: RwDefinedProject
removePackageGroupNamed: aComponentName
	^ self _concreteProject removePackageGroupNamed: aComponentName
%

category: 'accessing'
method: RwDefinedProject
removePackageNamed: packageName
	^ self _concreteProject removePackageNamed: packageName
%

category: 'accessing'
method: RwDefinedProject
removePackageNamed: packageName fromComponentNamed: componentName
	^ self _concreteProject
		removePackageNamed: packageName
		fromComponentNamed: componentName
%

category: 'accessing'
method: RwDefinedProject
renameComponentNamed: aComponentPath to: aComponentName
	"change the basename of aComponentPath to <baseName>, i.e., the path is not changed"

	^ self _concreteProject renameComponentNamed: aComponentPath to: aComponentName
%

category: 'component structure'
method: RwDefinedProject
renameComponentStructureFor: componentNamePath to: baseName startingAtComponentNamed: startingComponentName
	"
		Renames the component structure for the component named <componentNamePath> starting at <startingComponentName>. 
		Each component with the same basename as <componentNamePath> will be renamed with a new baseName. After the structure
		rename is complete, all references to renamed components will be changed. If an existing component is encountered with the same
		name along the path, the rename process will stop at that point.
	"

	^ self _concreteProject
		renameComponentStructureFor: componentNamePath
		to: baseName
		startingAtComponentNamed: startingComponentName
%

category: 'accessing'
method: RwDefinedProject
renamePackageGroupNamed: aComponentPath to: aComponentName
	^ self _concreteProject renamePackageGroupNamed: aComponentPath to: aComponentName
%

category: 'accessing'
method: RwDefinedProject
renamePackageNamed: packageName to: newPackageName
	^ self _concreteProject renamePackageNamed: packageName to: newPackageName
%

category: 'accessing'
method: RwDefinedProject
repoType: aSymbol
	"#disk, #git or #none"

	self _concreteProject repoType: aSymbol
%

category: 'transitions'
method: RwDefinedProject
resolveProject
	^ RwResolvedFromDefinedProject fromDefinedProject: self
%

category: 'transitions'
method: RwDefinedProject
resolveStrict
	^ RwResolvedFromDefinedProject fromStrictDefinedProject: self
%

category: 'accessing'
method: RwDefinedProject
revision: aString
	self loadSpecification revision: aString
%

category: 'accessing'
method: RwDefinedProject
specName: aString
	self loadSpecification specName: aString
%

category: 'accessing'
method: RwDefinedProject
specsPath: aString
	self _projectSpecification specsPath: aString
%

category: 'private'
method: RwDefinedProject
_concreteProject
	"Create a new project that uses Rowan v3 project spec and component classes"

	^ concreteProject
		ifNil: [ 
			concreteProject := RwResolvedProjectV2 new
				projectName: self name;
				yourself ]
%

category: 'private'
method: RwDefinedProject
_concreteProjectV2
	"Create a new project that uses project spec and component classes that are compatible with Rowan v2"

	^ concreteProject
		ifNil: [ 
			concreteProject := RwResolvedProjectV2 newV2
				projectName: self name;
				yourself ]
%

category: 'private'
method: RwDefinedProject
_concreteProjectV4
	"Create a new project that uses project spec and component classes that are compatible with Rowan v4"

	^ concreteProject
		ifNil: [ 
			concreteProject := RwResolvedProjectV2 newV4
				projectName: self name;
				yourself ]
%

category: 'private'
method: RwDefinedProject
_gemstoneAllUsersName
	^ self _concreteProject _gemstoneAllUsersName
%

category: 'accessing'
method: RwDefinedProject
_validate: conditionalAttributes
	^ self _concreteProject _validate: conditionalAttributes
%

! Class implementation for 'RwDefinedFromResolvedProject'

!		Class methods for 'RwDefinedFromResolvedProject'

category: 'instance creation'
classmethod: RwDefinedFromResolvedProject
fromLoadedProject: aLoadedProject
	^ (self newNamed: aLoadedProject name)
		_concreteProject: aLoadedProject _concreteProject asDefinition;
		yourself
%

!		Instance methods for 'RwDefinedFromResolvedProject'

category: 'accessing'
method: RwDefinedFromResolvedProject
componentsRoot
	^ self _concreteProject componentsRoot
%

category: 'actions'
method: RwDefinedFromResolvedProject
export
	^ self _concreteProject export
%

category: 'actions'
method: RwDefinedFromResolvedProject
exportComponents
	^ self _concreteProject exportComponents
%

category: 'actions'
method: RwDefinedFromResolvedProject
exportLoadSpecification
	^ self _concreteProject exportLoadSpecification
%

category: 'actions'
method: RwDefinedFromResolvedProject
exportPackages
	^ self _concreteProject exportPackages
%

category: 'actions'
method: RwDefinedFromResolvedProject
exportPackages: diskProjectSetDefinition packagesRoot: packagesRoot packageFormat: packageFormat packageConvention: packageConvention
	^ self _concreteProject
		exportPackages: diskProjectSetDefinition
		packagesRoot: packagesRoot
		packageFormat: packageFormat
		packageConvention: packageConvention
%

category: 'actions'
method: RwDefinedFromResolvedProject
exportProjects
	^ self _concreteProject exportProjects
%

category: 'actions'
method: RwDefinedFromResolvedProject
exportProjectSpecification
	^ self _concreteProject exportProjectSpecification
%

category: 'actions'
method: RwDefinedFromResolvedProject
exportTopazFormatTo: filePath
	^ self
		exportTopazFormatTo: filePath
		logClassCreation: false
		excludeClassInitializers: false
		excludeRemoveAllMethods: false
%

category: 'actions'
method: RwDefinedFromResolvedProject
exportTopazFormatTo: filePath logClassCreation: logClassCreation excludeClassInitializers: excludeClassInitializers excludeRemoveAllMethods: excludeRemoveAllMethods
	^ self _concreteProject
		exportTopazFormatTo: filePath
		logClassCreation: logClassCreation
		excludeClassInitializers: excludeClassInitializers
		excludeRemoveAllMethods: excludeRemoveAllMethods
%

category: 'actions'
method: RwDefinedFromResolvedProject
exportTopazFormatTo: filePath logClassCreation: logClassCreation excludeClassInitializers: excludeClassInitializers excludeRemoveAllMethods: excludeRemoveAllMethods topazFileHeader: header
	^ self _concreteProject
		exportTopazFormatTo: filePath
		logClassCreation: logClassCreation
		excludeClassInitializers: excludeClassInitializers
		excludeRemoveAllMethods: excludeRemoveAllMethods
		topazFileHeader: header
%

category: 'transitions'
method: RwDefinedFromResolvedProject
loadProjectSet
	"
		refresh the contents of the receiver from disk and create a project set that includes project definitions of
			required projects, also read from disk. Then load the entire project set.
	"

	^ self _concreteProject loadProjectSet
%

category: 'accessing'
method: RwDefinedFromResolvedProject
packagesRoot
	^ self _concreteProject packagesRoot
%

category: 'accessing'
method: RwDefinedFromResolvedProject
projectRoots
	^ self _concreteProject projectRoots
%

category: 'accessing'
method: RwDefinedFromResolvedProject
projectsRoot
	^ self _concreteProject projectsRoot
%

category: 'transitions'
method: RwDefinedFromResolvedProject
read
	"return a RwDefinedProject with definitions read from disk"

	self _concreteProject read
%

category: 'transitions'
method: RwDefinedFromResolvedProject
read: platformConditionalAttributes
	"return a RwDefinedProject with definitions read from disk ... the reciever will match the definitions on disk based on the current load specification"

	self _concreteProject read: platformConditionalAttributes
%

category: 'transitions'
method: RwDefinedFromResolvedProject
readProjectComponentNames: componentNames
	"refresh the contents of the receiver ... the reciever will match the definitions on disk based on the current load specification"

	"return the receiver with a new set of definitions read from disk"

	self _concreteProject readProjectComponentNames: componentNames
%

category: 'transitions'
method: RwDefinedFromResolvedProject
readProjectComponentNames: componentNames customConditionalAttributes: customConditionalAttributes platformConditionalAttributes: platformConditionalAttributes
	"refresh the contents of the receiver ... the reciever will match the definitions on disk based on the current load specification"

	"return the receiver with a new set of definitions read from disk"

	self _concreteProject
		readProjectComponentNames: componentNames
		customConditionalAttributes: customConditionalAttributes
		platformConditionalAttributes: platformConditionalAttributes
%

category: 'transitions'
method: RwDefinedFromResolvedProject
readProjectSet
	"refresh the contents of the receiver ... the reciever will match the definitions on disk based on the current load specification"

	"return a project definition set that will contain the project definition along with any dependent project definitions"

	self _concreteProject readProjectSet
%

category: 'transitions'
method: RwDefinedFromResolvedProject
readProjectSet: customConditionalAttributes platformConditionalAttributes: platformConditionalAttributes
	"refresh the contents of the receiver ... the reciever will match the definitions on disk based on the current load specification"

	"return a project definition set that will contain the project definition along with any dependent project definitions"

	^ self _concreteProject readProjectSet: customConditionalAttributes platformConditionalAttributes: platformConditionalAttributes
%

category: 'accessing'
method: RwDefinedFromResolvedProject
repository
	^ self _concreteProject repository
%

category: 'accessing'
method: RwDefinedFromResolvedProject
repositoryRoot
	^ self _concreteProject repositoryRoot
%

category: 'accessing'
method: RwDefinedFromResolvedProject
revision
	^ self _concreteProject revision
%

category: 'accessing'
method: RwDefinedFromResolvedProject
revision: aString
	self _concreteProject revision: aString
%

category: 'accessing'
method: RwDefinedFromResolvedProject
specsRoot
	^ self _concreteProject specsRoot
%

category: 'transitions'
method: RwDefinedFromResolvedProject
write

	self _concreteProject
		export;
		exportLoadSpecification
%

category: 'accessing'
method: RwDefinedFromResolvedProject
_projectDefinitionPlatformConditionalAttributes
	"Answer theplatformConditionalAttributes that will be used to load the project"

	^ self _concreteProject _projectDefinitionPlatformConditionalAttributes
%

! Class implementation for 'RwResolvedProject'

!		Class methods for 'RwResolvedProject'

category: 'instance creation'
classmethod: RwResolvedProject
fromDefinedProject: aDefinedProject
	| theProject |
	theProject :=  aDefinedProject _concreteProject.
	theProject _basicResolve.
	^ (self newNamed: aDefinedProject name)
		_concreteProject: theProject;
		yourself
%

category: 'instance creation'
classmethod: RwResolvedProject
fromStrictDefinedProject: aDefinedProject
	| createBlock oldPolicy |
	createBlock := [ 
	(self newNamed: aDefinedProject name)
		_concreteProject: aDefinedProject _concreteProject resolveProject;
		yourself ].
	aDefinedProject isStrict
		ifTrue: [ ^ createBlock value ].
	oldPolicy := aDefinedProject repositoryResolutionPolicy.
	[ 
	aDefinedProject repositoryResolutionPolicy: #'strict'.
	^ createBlock value ]
		ensure: [ aDefinedProject repositoryResolutionPolicy: oldPolicy ]
%

category: 'instance creation'
classmethod: RwResolvedProject
projectFromUrl: loadSpecUrl
	| loadSpec resolvedProject |
	loadSpec := RwSpecification fromUrl: loadSpecUrl.
	resolvedProject := loadSpec resolveProject.
	^ (self newNamed: resolvedProject name)
		_concreteProject: resolvedProject resolveProject;
		yourself
%

category: 'instance creation'
classmethod: RwResolvedProject
projectFromUrl: loadSpecUrl diskUrl: urlString
	| loadSpec resolvedProject |
	loadSpec := (RwSpecification fromUrl: loadSpecUrl)
		diskUrl: urlString;
		projectsHome: urlString asRwUrl pathString asFileReference parent;
		yourself.
	resolvedProject := loadSpec resolveProject.
	^ (self newNamed: resolvedProject name)
		_concreteProject: resolvedProject resolveProject;
		yourself
%

category: 'instance creation'
classmethod: RwResolvedProject
projectFromUrl: loadSpecUrl gitUrl: urlString
	| loadSpec resolvedProject |
	loadSpec := (RwSpecification fromUrl: loadSpecUrl)
		gitUrl: urlString;
		projectsHome: urlString asRwUrl pathString asFileReference parent;
		yourself.
	resolvedProject := loadSpec resolveProject.
	^ (self newNamed: resolvedProject name)
		_concreteProject: resolvedProject resolveProject;
		yourself
%

category: 'instance creation'
classmethod: RwResolvedProject
projectFromUrl: loadSpecUrl projectsHome: projectsHome
	| loadSpec resolvedProject |
	loadSpec := (RwSpecification fromUrl: loadSpecUrl)
		projectsHome: projectsHome;
		yourself.
	resolvedProject := loadSpec resolveProject.
	^ (self newNamed: resolvedProject name)
		_concreteProject: resolvedProject resolveProject;
		yourself
%

category: 'instance creation'
classmethod: RwResolvedProject
projectFromUrl: loadSpecUrl projectsHome: projectsHome componentNames: componentNames
	| loadSpec resolvedProject |
	loadSpec := (RwSpecification fromUrl: loadSpecUrl)
		projectsHome: projectsHome;
		componentNames: componentNames;
		yourself.
	resolvedProject := loadSpec resolveProject.
	^ (self newNamed: resolvedProject name)
		_concreteProject: resolvedProject resolveProject;
		yourself
%

category: 'instance creation'
classmethod: RwResolvedProject
projectFromUrl: loadSpecUrl projectsHome: projectsHome componentNames: componentNames customConditionalAttributes: customConditionalAttributes
	| loadSpec resolvedProject |
	loadSpec := (RwSpecification fromUrl: loadSpecUrl)
		projectsHome: projectsHome;
		componentNames: componentNames;
		customConditionalAttributes: customConditionalAttributes;
		yourself.
	resolvedProject := loadSpec resolveProject.
	^ (self newNamed: resolvedProject name)
		_concreteProject: resolvedProject resolveProject;
		yourself
%

category: 'instance creation'
classmethod: RwResolvedProject
projectFromUrl: loadSpecUrl projectsHome: projectsHome customConditionalAttributes: customConditionalAttributes
	| loadSpec resolvedProject |
	loadSpec := (RwSpecification fromUrl: loadSpecUrl)
		projectsHome: projectsHome;
		customConditionalAttributes: customConditionalAttributes;
		yourself.
	resolvedProject := loadSpec resolveProject.
	^ (self newNamed: resolvedProject name)
		_concreteProject: resolvedProject resolveProject;
		yourself
%

category: 'instance creation'
classmethod: RwResolvedProject
projectFromUrl: loadSpecUrl projectsHome: projectsHome customConditionalAttributes: customConditionalAttributes platformConditionalAttributes: platformConditionalAttributes
	| loadSpec resolvedProject |
	loadSpec := (RwSpecification fromUrl: loadSpecUrl)
		projectsHome: projectsHome;
		yourself.
	loadSpec addCustomConditionalAttributes: customConditionalAttributes.
	resolvedProject := loadSpec resolveProject.
	resolvedProject read: platformConditionalAttributes.
	^ (self newNamed: resolvedProject name)
		_concreteProject: resolvedProject resolveProject;
		yourself
%

category: 'instance creation'
classmethod: RwResolvedProject
projectFromUrl: loadSpecUrl readOnlyDiskUrl: urlString
	| loadSpec resolvedProject |
	loadSpec := (RwSpecification fromUrl: loadSpecUrl)
		readOnlyDiskUrl: urlString;
		projectsHome: urlString asRwUrl pathString asFileReference parent;
		yourself.
	resolvedProject := loadSpec resolveProject.
	^ (self newNamed: resolvedProject name)
		_concreteProject: resolvedProject resolveProject;
		yourself
%

!		Instance methods for 'RwResolvedProject'

category: 'testing'
method: RwResolvedProject
canCommit
	^ self _concreteProject canCommit
%

category: 'actions'
method: RwResolvedProject
checkout: revision
	^ self _concreteProject checkout: revision
%

category: 'actions'
method: RwResolvedProject
commit: message
	"commit the repository associated with receiver ..."

	^ self _concreteProject commit: message
%

category: 'querying'
method: RwResolvedProject
commitId

	^ self _concreteProject commitId
%

category: 'querying'
method: RwResolvedProject
commitLog: logLimit
	^ self _concreteProject commitLog: logLimit
%

category: 'accessing'
method: RwResolvedProject
componentsRoot
	^ self _concreteProject componentsRoot
%

category: 'transitions'
method: RwResolvedProject
defined
	^ RwDefinedFromResolvedProject fromLoadedProject: self
%

category: 'actions'
method: RwResolvedProject
export
	^ self _concreteProject export
%

category: 'actions'
method: RwResolvedProject
exportComponents
	^ self _concreteProject exportComponents
%

category: 'actions'
method: RwResolvedProject
exportLoadSpecification
	^ self _concreteProject exportLoadSpecification
%

category: 'actions'
method: RwResolvedProject
exportPackages
	^ self _concreteProject exportPackages
%

category: 'actions'
method: RwResolvedProject
exportPackages: diskProjectSetDefinition packagesRoot: packagesRoot packageFormat: packageFormat packageConvention: packageConvention
	^ self _concreteProject
		exportPackages: diskProjectSetDefinition
		packagesRoot: packagesRoot
		packageFormat: packageFormat
		packageConvention: packageConvention
%

category: 'actions'
method: RwResolvedProject
exportProjects
	^ self _concreteProject exportProjects
%

category: 'actions'
method: RwResolvedProject
exportProjectSpecification
	^ self _concreteProject exportProjectSpecification
%

category: 'actions'
method: RwResolvedProject
exportTopazFormatTo: filePath
	^ self
		exportTopazFormatTo: filePath
		logClassCreation: false
		excludeClassInitializers: false
		excludeRemoveAllMethods: false
%

category: 'actions'
method: RwResolvedProject
exportTopazFormatTo: filePath logClassCreation: logClassCreation excludeClassInitializers: excludeClassInitializers excludeRemoveAllMethods: excludeRemoveAllMethods
	^ self _concreteProject
		exportTopazFormatTo: filePath
		logClassCreation: logClassCreation
		excludeClassInitializers: excludeClassInitializers
		excludeRemoveAllMethods: excludeRemoveAllMethods
%

category: 'actions'
method: RwResolvedProject
exportTopazFormatTo: filePath logClassCreation: logClassCreation excludeClassInitializers: excludeClassInitializers excludeRemoveAllMethods: excludeRemoveAllMethods topazFileHeader: header
	^ self _concreteProject
		exportTopazFormatTo: filePath
		logClassCreation: logClassCreation
		excludeClassInitializers: excludeClassInitializers
		excludeRemoveAllMethods: excludeRemoveAllMethods
		topazFileHeader: header
%

category: 'accessing'
method: RwResolvedProject
packagesRoot
	^ self _concreteProject packagesRoot
%

category: 'accessing'
method: RwResolvedProject
projectRoots
	^ self _concreteProject projectRoots
%

category: 'accessing'
method: RwResolvedProject
projectsRoot
	^ self _concreteProject projectsRoot
%

category: 'transitions'
method: RwResolvedProject
read
	"return a RwDefinedProject with definitions read from disk"

	self _concreteProject read
%

category: 'transitions'
method: RwResolvedProject
read: platformConditionalAttributes
	"return a RwDefinedProject with definitions read from disk ... the reciever will match the definitions on disk based on the current load specification"

	self _concreteProject read: platformConditionalAttributes
%

category: 'actions'
method: RwResolvedProject
readPackageNames: packageNames
	^ self _concreteProject readPackageNames: packageNames
%

category: 'actions'
method: RwResolvedProject
readPackageNamesBlock: packageNamesBlock
	^ self _concreteProject readPackageNamesBlock: packageNamesBlock
%

category: 'transitions'
method: RwResolvedProject
readProjectComponentNames: componentNames
	"refresh the contents of the receiver ... the reciever will match the definitions on disk based on the current load specification"

	"return the receiver with a new set of definitions read from disk"

	self _concreteProject readProjectComponentNames: componentNames
%

category: 'transitions'
method: RwResolvedProject
readProjectComponentNames: componentNames customConditionalAttributes: customConditionalAttributes platformConditionalAttributes: platformConditionalAttributes
	"refresh the contents of the receiver ... the reciever will match the definitions on disk based on the current load specification"

	"return the receiver with a new set of definitions read from disk"

	self _concreteProject
		readProjectComponentNames: componentNames
		customConditionalAttributes: customConditionalAttributes
		platformConditionalAttributes: platformConditionalAttributes
%

category: 'transitions'
method: RwResolvedProject
readProjectSet
	"refresh the contents of the receiver ... the reciever will match the definitions on disk based on the current load specification"

	"return a project definition set that will contain the project definition along with any dependent project definitions"

	self _concreteProject readProjectSet
%

category: 'actions'
method: RwResolvedProject
readProjectSet: customConditionalAttributes
	"refresh the contents of the receiver ... use customConditionalAttributes to determine which components will be loaded"

	"return a project definition set that will contain the project definition along with any dependent project definitions"

	self _concreteProject readProjectSet: customConditionalAttributes
%

category: 'transitions'
method: RwResolvedProject
readProjectSet: customConditionalAttributes platformConditionalAttributes: platformConditionalAttributes
	"refresh the contents of the receiver ... the reciever will match the definitions on disk based on the current load specification"

	"return a project definition set that will contain the project definition along with any dependent project definitions"

	^ self _concreteProject readProjectSet: customConditionalAttributes platformConditionalAttributes: platformConditionalAttributes
%

category: 'accessing'
method: RwResolvedProject
repository
	^ self _concreteProject repository
%

category: 'accessing'
method: RwResolvedProject
repositoryRoot
	^ self _concreteProject repositoryRoot
%

category: 'transitions'
method: RwResolvedProject
resolveProject
	^ self
%

category: 'accessing'
method: RwResolvedProject
revision
	^ self _concreteProject revision
%

category: 'accessing'
method: RwResolvedProject
revision: aString
	self _concreteProject revision: aString
%

category: 'accessing'
method: RwResolvedProject
specsRoot
	^ self _concreteProject specsRoot
%

category: 'transitions'
method: RwResolvedProject
write

	self _concreteProject
		export;
		exportLoadSpecification
%

category: 'accessing'
method: RwResolvedProject
_projectDefinitionPlatformConditionalAttributes
	"Answer theplatformConditionalAttributes that will be used to load the project"

	^ self _concreteProject _projectDefinitionPlatformConditionalAttributes
%

! Class implementation for 'RwResolvedFromDefinedProject'

!		Instance methods for 'RwResolvedFromDefinedProject'

category: 'accessing'
method: RwResolvedFromDefinedProject
componentsPath: aString
	self _projectSpecification componentsPath: aString
%

category: 'transitions'
method: RwResolvedFromDefinedProject
load
	^ self
		error:
			'Projects resoved from a defined project are not guaranteed to produce the same loaded state as loaded from disk (via a load spec). Use loadAsDefined to force the project to be loaded AS DEFINED or loadFromSpec to load from disk and ignored the defined project state'
%

category: 'transitions'
method: RwResolvedFromDefinedProject
loadAsDefined
	"
		The project is loaded exactly as defined, i.e., the packages present in the defined project will be
			loaded into the image exactly as is, without applying any of the conditions defined in the 
			project's components and without regard to the disk-based definitions. If a project is 'loaded 
			as defined', a subsequent reload of the loaded project will reload the disk-based definitions 
			(components and packages).
	"

	^ self _concreteProject load
%

category: 'transitions'
method: RwResolvedFromDefinedProject
loadFromSpec
	"
		The project is loaded as defined on disk and the in-memory project definition is ignored.
	"

	^ self _concreteProject loadSpecification resolveProject load
%

category: 'transitions'
method: RwResolvedFromDefinedProject
loadProjectSet
	"
		refresh the contents of the receiver from disk and create a project set that includes project definitions of
			required projects, also read from disk. Then load the entire project set.
	"

	^ self _concreteProject loadProjectSet
%

category: 'accessing'
method: RwResolvedFromDefinedProject
packageNamed: aString
	^ self _concreteProject packageNamed: aString
%

category: 'accessing'
method: RwResolvedFromDefinedProject
packagesPath: aString
	self _projectSpecification packagesPath: aString
%

category: 'accessing'
method: RwResolvedFromDefinedProject
projectsPath: aString
	self _projectSpecification projectsPath: aString
%

category: 'accessing'
method: RwResolvedFromDefinedProject
projectSpecFile: relativePathString
	^ self _concreteProject projectSpecFile: relativePathString
%

category: 'accessing'
method: RwResolvedFromDefinedProject
projectSpecPath: aStringOrNil
	"nil value indicates projectSpec file is in repository root directory"

	self _projectSpecification projectSpecPath: aStringOrNil
%

category: 'accessing'
method: RwResolvedFromDefinedProject
specsPath: aString
	self _projectSpecification specsPath: aString
%

! Class implementation for 'RwProject'

!		Instance methods for 'RwProject'

category: 'components'
method: RwProject
addLoadComponentNamed: componentName
	"add a new instance of RwLoadComponent to the project components and add the componentName
		to the load spec (i.e., it will be loaded when the load spec is loaded)"

	^ self addLoadComponentNamed: componentName comment: ''
%

category: 'components'
method: RwProject
addLoadComponentNamed: componentName comment: aString
	"add a new instance of RwLoadComponent to the project components and add the componentName
		to the load spec (i.e., it will be loaded when the load spec is loaded)"

	| projectDefinition component |
	projectDefinition := self defined.
	component := projectDefinition
		addLoadComponentNamed: componentName
		comment: aString.
	projectDefinition load.
	^ component
%

category: 'components'
method: RwProject
addSubcomponentNamed: componentName condition: condition comment: aString toComponentNamed: toComponentName
	"Add the named subcomponent with the given condition to the named project and add the new component to the toComponentName component"

	"since we are working with a loaded project here, adding a component 
		with a condition, implies that the condition should be applied to the load specification, 
		thus causing the new component to be loaded"

	| projectDefinition component conditionals |
	projectDefinition := self defined.
	component := projectDefinition
		addSubcomponentNamed: componentName
		condition: condition
		comment: aString
		toComponentNamed: toComponentName.
	conditionals := projectDefinition customConditionalAttributes copy.
	conditionals add: condition.
	projectDefinition customConditionalAttributes: conditionals asSet asArray.
	projectDefinition load.
	^ component
%

category: 'components'
method: RwProject
addSubcomponentNamed: componentName condition: condition toComponentNamed: toComponentName
	"Add the named subcomponent with the given condition to the named project and add the new component to the toComponentName component"

	^ self
		addSubcomponentNamed: componentName
		condition: condition
		comment: ''
		toComponentNamed: toComponentName
%

category: 'querying'
method: RwProject
allClassNamesFor: componentNameOrArrayOfNames
	| loadedClassNames |
	loadedClassNames := Set new.
	(self allPackageNamesIn: componentNameOrArrayOfNames)
		do: [ :packageName | 
			(self packageNamed: packageName ifAbsent: [  ])
				ifNotNil: [ :loadedPackage | 
					loadedClassNames
						addAll: loadedPackage definedClassNames;
						addAll: loadedPackage extendedClassNames ] ].
	^ loadedClassNames
%

category: 'querying'
method: RwProject
allPackageNamesIn: componentNameOrArrayOfNames
	^ self _loadedProject allPackageNamesIn: componentNameOrArrayOfNames
%

category: 'actions'
method: RwProject
asDefinition

	^ self _loadedProject asDefinition
%

category: 'repository conversion'
method: RwProject
asReadOnlyRepositoryWithCommitId: aCommitId
	"convert the existing repository definition to read only ... no change to repository root"

	self _concreteProject asReadOnlyRepositoryWithCommitId: aCommitId
%

category: 'actions'
method: RwProject
audit
	"run audit on the receiver"

	^ self _loadedProject audit
%

category: 'actions'
method: RwProject
auditOn: logStreamOrNil
	"run audit on the receiver"

	^ self _loadedProject auditOn: logStreamOrNil
%

category: 'properties'
method: RwProject
canCommit

	^ self _loadedProject canCommit
%

category: 'actions'
method: RwProject
checkout: revision
	^ self _loadedProject checkout: revision
%

category: 'actions'
method: RwProject
commit: message
	"commit the repository associated with receiver ..."

	^ self _loadedProject commit: message
%

category: 'querying'
method: RwProject
commitId

	^ self _loadedProject commitId
%

category: 'querying'
method: RwProject
commitId: aString

	^ self _loadedProject commitId: aString
%

category: 'querying'
method: RwProject
commitLog: logLimit

	^ self _loadedProject commitLog: logLimit
%

category: 'querying'
method: RwProject
componentForPackageNamed: packageName
	"Answer nil if no component found"

	^ self _loadedProject componentForPackageNamed: packageName
%

category: 'components'
method: RwProject
componentOrPackageGroupNamed: componentName
	^ self _loadedComponents componentOrPackageGroupNamed: componentName
%

category: 'accessing'
method: RwProject
componentsRoot
	^ self _loadedProject componentsRoot
%

category: 'accessing'
method: RwProject
currentBranchName

	| rootPath |
	self useGit
		ifFalse: [ ^ '' ].
	rootPath := self repositoryRootPath.
	rootPath ifNil: [ ^ '' ].
	^ Rowan gitTools gitBranchNameIn:rootPath
%

category: 'transitions'
method: RwProject
defined
	^ RwDefinedFromResolvedProject fromLoadedProject: self
%

category: 'accessing'
method: RwProject
definedClasses

	^ self _projectTools query classesForProjectNamed: self name
%

category: 'testing'
method: RwProject
existsOnDisk

	^ Rowan image 
		loadedProjectNamed: self name 
			ifPresent: [:loadedProject |
				self repositoryRoot
					ifNil: [ false ]
					ifNotNil: [:fileRef | fileRef exists ] ]
			ifAbsent: [ false ]
%

category: 'accessing'
method: RwProject
extendedClasses

	^ self _projectTools query classExtensionsForProjectNamed: self name
%

category: 'git support'
method: RwProject
gitCheckout: branchOrSha
	"git checkout a branch or sha"

	^ Rowan gitTools gitcheckoutIn: self repositoryRoot with: branchOrSha
%

category: 'git support'
method: RwProject
gitCommit: commitComment
	"git checkout a branch or sha"

	^ self _loadedProject resolvedProject commit: commitComment
%

category: 'git support'
method: RwProject
gitCreateBranch: branchName
	"git create a new branch"

	^ Rowan gitTools gitcheckoutIn: self repositoryRoot with: ' -b ', branchName
%

category: 'git support'
method: RwProject
gitLog: logLimit
	"return `git log` report"

	^ Rowan gitTools gitlogtool: 'HEAD' limit: logLimit gitRepoDirectory: self repositoryRoot pathString
%

category: 'git support'
method: RwProject
gitPullRemote: remoteName branch: branchName
	"git pull remote and branch name"

	^ Rowan gitTools
		gitpullIn: self repositoryRoot pathString
		remote: remoteName
		branch: branchName
%

category: 'git support'
method: RwProject
gitPushRemote: remoteName branch: branchName
	"git push remote and branch name"

	^ Rowan gitTools
		gitpushIn: self repositoryRoot pathString
		remote: remoteName
		branch: branchName
%

category: 'git support'
method: RwProject
gitShortStatus
	"`git status --short` returns an empty string if there is nothing to commit"

	^ Rowan gitTools gitstatusIn: self repositoryRoot pathString with: '--short'
%

category: 'git support'
method: RwProject
gitStatus
	"return standard `git status` report"

	^ Rowan gitTools gitstatusIn: self repositoryRoot pathString with: ''
%

category: 'testing'
method: RwProject
isDirty
	"a project is dirty if it has changes that are not written to disk, or it's packages 
		have changes that are not written to  disk."

	^ self _loadedProject isDirty
%

category: 'testing'
method: RwProject
isLoaded
	^ self _loadedProjectIfPresent: [ true ] ifAbsent: [ false ]
%

category: 'properties'
method: RwProject
loadedCommitId

	^ self _loadedProject loadedCommitId
%

category: 'querying'
method: RwProject
loadedComponentNames
	"list of defined components in the components"

	^ self _loadedComponents componentNames
%

category: 'actions'
method: RwProject
loadedLoadSpecifications
	"Return an RwLoadSpecSet containing the receiver and all load specs for required projects, based on the 
		load spec associated with the loaded project (no disk read performed)"

	^ (RwLoadSpecSet
		withAll: (self requiredProjects collect: [ :each | each loadSpecification ]))
		addLoadSpec: self loadSpecification;
		yourself
%

category: 'querying'
method: RwProject
loadedSubcomponentsOf: componentName
	"list of direct subcomponents of the given <componentName> ...includes package groups"

	^ self loadedSubcomponentsOf: componentName ifNone: [ ^ {} ]
%

category: 'querying'
method: RwProject
loadedSubcomponentsOf: componentName attributes: attributes ifNone: noneBlock
	^ self _loadedProject
		subcomponentsOf: componentName
		attributes: attributes
		ifNone: noneBlock
%

category: 'querying'
method: RwProject
loadedSubcomponentsOf: componentName ifNone: noneBlock
	"list of direct subcomponents of the given <componentName> ...includes package groups"

	^ self _loadedProject subcomponentsOf: componentName ifNone: noneBlock
%

category: 'actions'
method: RwProject
loadProjectSet
	"
		refresh the contents of the receiver from disk and create a project set that includes project definitions of
			required projects, also read from disk. Then load the entire project set.
	"

	^ self _loadedProject loadProjectSet
%

category: 'accessing'
method: RwProject
loadSpecification
	^ self _loadedProject loadSpecification copy
%

category: 'components'
method: RwProject
packageGroupNamed: componentName
	^ self _loadedComponents packageGroupNamed: componentName
%

category: 'components'
method: RwProject
packageGroupNames
	^ self _loadedComponents packageGroupNames
%

category: 'querying'
method: RwProject
packageNamed: aString
	^ self
		packageNamed: aString
		ifAbsent: [ self error: 'Package named: ' , aString printString , ' does not exist.' ]
%

category: 'querying'
method: RwProject
packageNamed: aString ifAbsent: absentBlock
	^ self packages
		detect: [ :package | package name = aString ]
		ifNone: absentBlock
%

category: 'accessing'
method: RwProject
packages

	^ self packageNames collect: [ :packageName | RwPackage newNamed: packageName ]
%

category: 'accessing'
method: RwProject
packagesRoot
	^ self _concreteProject packagesRoot
%

category: 'accessing'
method: RwProject
projectRoots
	^ self _concreteProject projectRoots
%

category: 'accessing'
method: RwProject
projectsRoot
	^ self _concreteProject projectsRoot
%

category: 'accessing'
method: RwProject
projectUrl

	"Return the projectUrl used to clone the project"

	^ self _loadedProject projectUrl
%

category: 'actions'
method: RwProject
reload
	"
		Load the receiver AND required projects from disk ... the load specs are not reread from disk, only the pacakges are reread.
		If you want to reread the specs from disk, then use (note that if you did not use default projects home for original load, you 
		will have to set the projectsHome for each spec to the original value):
			self loadSpecification resolve load
	"

	^ self loadedLoadSpecifications read load
%

category: 'accessing'
method: RwProject
repositoryRoot
	^ self _concreteProject repositoryRoot
%

category: 'properties'
method: RwProject
repositoryRootPath

	^ self repositoryRoot pathString
%

category: 'actions'
method: RwProject
revert
	"
		read and reload just the receiver from disk using the loaded load specs. Required projects for the receiver 
			are only loaded if they are not already present in the image.

		To revert the receiver AND required projects, use reload.
	"


	^ self _loadedProject read load
%

category: 'actions'
method: RwProject
revert: instanceMigrator
	"
		read and reload just the receiver from disk using the loaded load specs. Required projects for the receiver 
			are only loaded if they are not already present in the image.

		To revert the receiver AND required projects, use reload.

		Use the specifiied instanceMigrator
	"

	"should replace places where a projectSet was created for the receiver"

	^ self _loadedProject load: instanceMigrator
%

category: 'properties'
method: RwProject
revision
	^ self _concreteProject revision
%

category: 'actions'
method: RwProject
testSuite
	^ Rowan projectTools test testSuiteForProjectNamed: self name
%

category: 'actions'
method: RwProject
unload
	"unload the loaded project (if present) from the image"

	^ self
		_loadedProjectIfPresent: [ :loadedProject | loadedProject unload ]
		ifAbsent: [  ]
%

category: 'accessing'
method: RwProject
updateLoadSpecWithRepositoryRoot: aLoadSpec
	"preserve the current repositoryRoot in aLoadSpec ... aLoadSpec should not explicitly attached to loaded project"

	self _loadedProject updateLoadSpecWithRepositoryRoot: aLoadSpec
%

category: 'testing'
method: RwProject
useGit

	^self _loadedProject useGit
%

category: 'private'
method: RwProject
_concreteProject
	^ Rowan image loadedProjectNamed: self name
%

category: 'private'
method: RwProject
_loadedComponents
	^ self _loadedProject loadedComponentDefinitions
%

category: 'private'
method: RwProject
_loadedProject

	^ Rowan image loadedProjectNamed: self name
%

category: 'private'
method: RwProject
_loadedProjectIfPresent: presentBlock ifAbsent: absentBlock

	^ Rowan image
		loadedProjectNamed: self name
		ifPresent: presentBlock
		ifAbsent: absentBlock
%

category: 'accessing'
method: RwProject
_projectDefinitionPlatformConditionalAttributes
	"Answer the projectDefinitionPlatformConditionalAttributes used to load the project"

	^ self _loadedProject _projectDefinitionPlatformConditionalAttributes
%

category: 'accessing'
method: RwProject
_projectDefinitionPlatformConditionalAttributes: platformConditionalAttributes
	"Answer the projectDefinitionPlatformConditionalAttributes used to load the project"

	^ self _loadedProject _projectDefinitionPlatformConditionalAttributes: platformConditionalAttributes
%

category: 'private'
method: RwProject
_projectRepository
	^ self _loadedProject handle _projectRepository
%

category: 'private'
method: RwProject
_requiredProjectNamesForLoadedProject: visitedSet
	^ self _concreteProject _requiredProjectNamesForLoadedProject: visitedSet
%

category: 'private'
method: RwProject
_specification

	^ self _loadedProject specification
%

! Class implementation for 'RwPackage'

!		Instance methods for 'RwPackage'

category: 'accessing'
method: RwPackage
definedClasses

"	^ self _packageTools query classesForPackageNamed: self name"

	^ self error: 'not yet implemented'
%

category: 'accessing'
method: RwPackage
definedClassNames
	^ self _loadedPackage loadedClasses keys asSet
%

category: 'accessing'
method: RwPackage
definedTraitNames
	^ self _loadedPackage loadedTraits keys asSet
%

category: 'accessing'
method: RwPackage
definedTraits
	^ self error: 'not yet implemented'
%

category: 'accessing'
method: RwPackage
extendedClasses

"	^ self _packageTools query classExtensionsForPackageNamed: self name"

	^ self error: 'not yet implemented'
%

category: 'accessing'
method: RwPackage
extendedClassNames
	^ self _loadedPackage loadedClassExtensions keys asSet
%

category: 'testing'
method: RwPackage
isDirty
	"a project is dirty if it has changes that are not written to disk, or it's packages 
		have changes that are not written to  disk."

	^ self _loadedPackage isDirty
%

category: 'testing'
method: RwPackage
isEmpty

	^ self _loadedPackage isEmpty
%

category: 'accessing'
method: RwPackage
project
	^ RwProject newNamed: self _loadedProject name
%

category: 'private'
method: RwPackage
_loadedPackage

	^ Rowan image loadedPackageNamed: self name
%

category: 'private'
method: RwPackage
_loadedProject

	^ self _loadedPackage loadedProject
%

! Class implementation for 'RwAbstractComponent'

!		Class methods for 'RwAbstractComponent'

category: 'instance creation'
classmethod: RwAbstractComponent
fromComponentsDirectory: componentsDirectory named: componentName
	| component url |
	url := 'file:' , (componentsDirectory / componentName , 'ston') pathString.
	component := self fromUrl: url.
	component _readDoitsFrom: componentsDirectory.
	component _validateDoits.
	^ component
%

category: 'instance creation'
classmethod: RwAbstractComponent
fromFile: filePath
	filePath asFileReference
		readStreamDo: [ :fileStream | 
			| stream |
			Rowan projectTools trace trace: '--- reading component ' , filePath asString.
			stream := ZnBufferedReadStream on: fileStream.	"wrap with buffered stream to bypass https://github.com/GemTalk/FileSystemGs/issues/9"
			^ self _readStonFrom: stream ]
%

category: 'instance creation'
classmethod: RwAbstractComponent
fromUrl: specNameOrUrl

	"self fromUrl: 'file:/home/dhenrich/rogue/_homes/rogue/_home/shared/repos/RowanSample9/rowan/components/Default.ston'"

	| url |
	url := specNameOrUrl asRwUrl.
	url scheme isNil
		ifTrue: [ self error: 'scheme must be file: or https:' ].
	url scheme = 'file'
		ifTrue: [ ^ self fromFile: url pathForFile ].
	url scheme asString = 'https'
		ifTrue: [ 
self error: 'not yet supported'.
"
			| client response |
			GsSecureSocket disableCertificateVerificationOnClient.
			client := (Rowan globalNamed: 'ZnClient') new.
			response := client
				beOneShot;
				enforceHttpSuccess: true;
				get: url.
			^ self _readStonFrom: response decodeFromUTF8
" ].
	self error: 'Unknown scheme: ' , url scheme printString
%

category: 'instance creation'
classmethod: RwAbstractComponent
new

	^self basicNew initialize
%

category: 'instance creation'
classmethod: RwAbstractComponent
newNamed: aName

	^ self new
		name: aName;
		yourself
%

category: 'accessing'
classmethod: RwAbstractComponent
orderedDictionaryClass
	^ Rowan platform orderedDictionaryClass
%

category: 'version pattern matching'
classmethod: RwAbstractComponent
_platformPatternMatcherFor: pattern
	" Returns an instance of RwAbstractConfigurationPlatformAttributeMatcher:
		RwStringConfigurationPlatformAttributeMatcher,
		RwGemStoneVersionConfigurationPlatformAttributeMatcher,
		or RwGemStoneVersionRangeConfigurationPlatformAttributeMatcher
	"

	| versionPattern gsVersion1 gsVersion2 |
	(pattern beginsWith: 'gs')
		ifFalse: [ 
			"simple equality match"
			^ RwStringConfigurationPlatformAttributeMatcher new
				pattern: pattern;
				patternMatchBlock: [ :a :b | a = b ];
				yourself ].	"GemStone version pattern"
	versionPattern := (pattern copyFrom: 3 to: pattern size) substrings: '.'.
	(versionPattern last beginsWith: '[')
		ifTrue: [ 
			| vpSize rangePattern dashIndex |
			"range pattern"
			vpSize := versionPattern size.
			gsVersion1 := RwGemStoneVersionNumber new: vpSize.
			1 to: vpSize - 1 do: [ :index | gsVersion1 at: index put: (versionPattern at: index) asInteger ].
			gsVersion1 at: vpSize put: 0.
			rangePattern := (versionPattern at: vpSize) trimBoth.
			((rangePattern at: 1) = $[ and: [ (rangePattern at: rangePattern size) = $] ])
				ifFalse: [ 
					self
						error:
							'Poorly formed GemStone version range pattern ' , rangePattern printString
								, ' in ' , pattern printString ].
			rangePattern := rangePattern copyFrom: 2 to: rangePattern size - 1.
			dashIndex := rangePattern indexOf: $-.
			dashIndex <= 1
				ifTrue: [ 
					self
						error:
							'Invalid version range pattern missing range begin' , rangePattern printString
								, ' in ' , pattern printString ].
			gsVersion1
				at: vpSize
				put: (rangePattern copyFrom: 1 to: dashIndex - 1) asInteger.
			dashIndex = rangePattern size
				ifTrue: [ 
					"open range"
					gsVersion2 := gsVersion1 copyFrom: 1 to: gsVersion1 size - 1.
					gsVersion2 at: gsVersion2 size put: (gsVersion2 at: gsVersion2 size) + 1.
					^ RwGemStoneVersionRangeConfigurationPlatformAttributeMatcher new
						pattern: gsVersion1;
						pattern2: gsVersion2;
						patternMatchBlock: [ :a :b :c | a <= b & (b < c) ];
						yourself ]
				ifFalse: [ 
					"closed range"
					gsVersion2 := gsVersion1 copy.
					gsVersion2
						at: vpSize
						put:
							(rangePattern copyFrom: dashIndex + 1 to: rangePattern size) asInteger + 1.
					^ RwGemStoneVersionRangeConfigurationPlatformAttributeMatcher new
						pattern: gsVersion1;
						pattern2: gsVersion2;
						patternMatchBlock: [ :a :b :c | a <= b & (b < c) ];
						yourself ] ].
	versionPattern last = 'x'
		ifTrue: [ 
			" 'gs', <gemstone-version-number> , '.x'"
			"match all values in x field"
			gsVersion1 := ((pattern copyFrom: 3 to: pattern size - 2) , '.0')
				asRwGemStoneVersionNumber.
			gsVersion2 := gsVersion1 copyFrom: 1 to: gsVersion1 size - 1.
			gsVersion2 at: gsVersion2 size put: (gsVersion2 at: gsVersion2 size) + 1.
			^ RwGemStoneVersionRangeConfigurationPlatformAttributeMatcher new
				pattern: gsVersion1;
				pattern2: gsVersion2;
				patternMatchBlock: [ :a :b :c | a <= b & (b < c) ];
				yourself ]
		ifFalse: [ 
			"specific version number match, use ="
			^ RwGemStoneVersionConfigurationPlatformAttributeMatcher new
				pattern: (pattern copyFrom: 3 to: pattern size) asRwGemStoneVersionNumber;
				patternMatchBlock: [ :a :b | a = b ];
				yourself ]
%

category: 'private'
classmethod: RwAbstractComponent
_readStonFrom: stream
	| reader component |
	(reader := STONReader on: stream) allowComplexMapKeys: true.
	component := reader next
		initializeForImport;
		yourself.
	component validate.	"validate when reading from disk, since hand editting could create inconsistencies"
	^ component
%

!		Instance methods for 'RwAbstractComponent'

category: 'comparing'
method: RwAbstractComponent
= aRwProjectLoadComponentV2
	(aRwProjectLoadComponentV2 isKindOf: self class)
		ifFalse: [ ^ false ].
	^ (((self name = aRwProjectLoadComponentV2 name
		and: [ self comment = aRwProjectLoadComponentV2 comment ])
		and: [ self projectName = aRwProjectLoadComponentV2 projectName])
		and: [ self packageNames = aRwProjectLoadComponentV2 packageNames ])
		and: [ self componentNames = aRwProjectLoadComponentV2 componentNames ]
%

category: 'accessing'
method: RwAbstractComponent
addComponentNamed: aComponentName
	"avoid duplicates and keep the list sorted"

	| cn |
	cn := self componentNames.	" returns copy, so cannot add directly to result"
	cn add: aComponentName.
	componentNames := cn asSet asArray sort
%

category: 'accessing'
method: RwAbstractComponent
addComponentNames: aComponentNames
	"add component names"

	| cn |
	cn := self componentNames.	" returns copy, so cannot add directly to result"
	cn addAll: aComponentNames.
	componentNames := cn asSet asArray sort
%

category: 'accessing'
method: RwAbstractComponent
addPackageNames: aPackageNames
	"add packages to default conditional/group if applicable"

	| pn |
	pn := self packageNames.	" returns copy, so cannot add directly to result"
	pn addAll: aPackageNames.
	packageNames := pn asSet asArray sort
%

category: 'accessing'
method: RwAbstractComponent
basename
	^ (self name subStrings: $/) last
%

category: 'accessing'
method: RwAbstractComponent
comment

   ^comment
%

category: 'initialization'
method: RwAbstractComponent
comment: anObject

   comment := anObject
%

category: 'accessing'
method: RwAbstractComponent
componentNames

	^ componentNames copy
%

category: 'ston'
method: RwAbstractComponent
excludedInstVars
	"restore full #instVarNamesInOrderForSton - no exclusions (see super implementation)"

	^ #( #projectName )
%

category: 'exporting'
method: RwAbstractComponent
exportToUrl: directoryUrl
	^ self copy initializeForExport
		_exportToUrl: directoryUrl;
		yourself
%

category: 'initialization'
method: RwAbstractComponent
initialize
	comment := ''.
	packageNames := {}.
	componentNames := {}
%

category: 'initialization'
method: RwAbstractComponent
initializeForExport
	"if spec is to be exported, clear out any of the fields that represent state that should 
	not be shared"

	projectName := nil
%

category: 'initialization'
method: RwAbstractComponent
initializeForImport
	"if spec has been imported, clear out any of the fields that represent state that should 
	not be shared"

	projectName := nil
%

category: 'ston'
method: RwAbstractComponent
instVarNamesInOrderForSton

	^ self class allInstVarNames
%

category: 'accessing'
method: RwAbstractComponent
label

   ^self basename
%

category: 'matching'
method: RwAbstractComponent
matchesAttributes: attributes
	self conditionalPropertyMatchers
		keysAndValuesDo: [ :platformMatchers :ignored | ^ self _platformAttributeMatchIn: platformMatchers for: attributes ]
%

category: 'accessing'
method: RwAbstractComponent
name

   ^name
%

category: 'initialization'
method: RwAbstractComponent
name: anObject

   name := anObject
%

category: 'accessing'
method: RwAbstractComponent
packageNames

	^ packageNames copy
%

category: 'copying'
method: RwAbstractComponent
postCopy
	super postCopy.
	componentNames := componentNames copy.
	packageNames := packageNames copy
%

category: 'printing'
method: RwAbstractComponent
printOn: aStream
	super printOn: aStream.
	aStream
		space;
		nextPutAll: name.
	projectName ifNotNil: [ aStream nextPutAll: ' for project ' , projectName ]
%

category: 'accessing'
method: RwAbstractComponent
projectName

   ^projectName
%

category: 'initialization'
method: RwAbstractComponent
projectName: anObject
	"The name of the load spec in the projects directory that is used to resolve/load the project"

	projectName := anObject
%

category: 'accessing'
method: RwAbstractComponent
projectNames
	^ #()
%

category: 'accessing'
method: RwAbstractComponent
referencePath
	^ Path from: self name
%

category: 'accessing'
method: RwAbstractComponent
removeComponentNamed: aComponentName
	| cn |
	cn := self componentNames.
	cn remove: aComponentName ifAbsent: [  ].
	componentNames := cn asSet asArray sort
%

category: 'accessing'
method: RwAbstractComponent
removePackageNamed: aPackageName
	| pn |
	pn := self packageNames.	" returns copy, so cannot add directly to result"
	pn remove: aPackageName ifAbsent: [  ].
	packageNames := pn asSet asArray sort
%

category: 'accessing'
method: RwAbstractComponent
renameTo: newComponentName in: aResolvedProject

	self subclassResponsibility: #renameTo:in:
%

category: 'ston'
method: RwAbstractComponent
stonOn: stonWriter
	| instanceVariableNames allInstanceVariableNames |
	instanceVariableNames := self instVarNamesInOrderForSton
		reject: [ :iv | self excludedInstVars includes: iv ].
	allInstanceVariableNames := self class allInstVarNames.
	stonWriter
		writeObject: self
		streamMap: [ :dictionary | 
			instanceVariableNames
				do: [ :each | 
					(self instVarAt: (allInstanceVariableNames indexOf: each asSymbol))
						ifNotNil: [ :value | dictionary at: each asSymbol put: value ]
						ifNil: [ 
							self stonShouldWriteNilInstVars
								ifTrue: [ dictionary at: each asSymbol put: nil ] ] ] ]
%

category: 'validation'
method: RwAbstractComponent
validate
	"ensure that the data structures within the receiver contain valid information:
		1. only packages defined in the receiver may be referenced in the reciever
		2. platform implementation is responsible for validating platform structures"

	self subclassResponsitility: #'validate'
%

category: 'dispatching'
method: RwAbstractComponent
_addToResolvedProjectComponents: aRwResolvedProjectComponentsV2
	"dispatch to _addActiveComponent: or _addPackageGroup: as appropriate"

	self subclassResponsibility: #'_addToResolvedProjectComponents:'
%

category: 'exporting'
method: RwAbstractComponent
_exportToUrl: directoryUrl
	| url |
	url := directoryUrl asRwUrl.
	url schemeName = 'file'
		ifTrue: [ 
			| fileRef |
			fileRef := url pathForDirectory asFileReference / self name , 'ston'.
			fileRef parent ensureCreateDirectory.
			fileRef
				writeStreamDo: [ :stream | 
					| string |
					string := STON toStringPretty: self.
					stream 
						truncate;
						nextPutAll: string.
					^ self ] ].
	url schemeName = 'memory'
		ifTrue: [ 
			FileSystem currentMemoryFileSystem workingDirectory / url pathForDirectory
				/ self name , 'ston'
				writeStreamDo: [ :stream | 
					| string |
					string := STON toStringPretty: self.
					stream 
						truncate;
						nextPutAll: string.
					^ self ] ].
	^ nil	"otherwise a noop"
%

category: 'matching'
method: RwAbstractComponent
_platformAttributeMatchIn: platformMatchersList for: attributes
	platformMatchersList
		do: [ :platformPatternMatcher | 
			attributes
				do: [ :anObject | 
					(platformPatternMatcher match: anObject)
						ifTrue: [ ^ true ] ] ].
	^ false
%

category: 'private'
method: RwAbstractComponent
_platformPatternMatcherFor: pattern
	^ self class _platformPatternMatcherFor: pattern
%

category: 'doits'
method: RwAbstractComponent
_readDoitsFrom: componentsRoot
	"noop"
%

category: 'validation'
method: RwAbstractComponent
_validateDoits
	"noop"
%

category: 'validation'
method: RwAbstractComponent
_validatedPackageNames
	"answer the validated set of package names"

	^ self packageNames asSet
%

! Class implementation for 'RwAbstractActiveComponent'

!		Class methods for 'RwAbstractActiveComponent'

category: 'private'
classmethod: RwAbstractActiveComponent
_gemstoneSupportedPackagePropertyNames
	^ #('methodEnv' 'symbolDictName' 'useSessionMethodsForExtensions')
%

!		Instance methods for 'RwAbstractActiveComponent'

category: 'comparing'
method: RwAbstractActiveComponent
= aRwProjectLoadComponentV2
	super = aRwProjectLoadComponentV2
		ifFalse: [ ^ false ].
	^ (((self conditionalPackageMapSpecs
		= aRwProjectLoadComponentV2 conditionalPackageMapSpecs
		and: [ self doitDict = aRwProjectLoadComponentV2 doitDict ])
		and: [ self projectNames = aRwProjectLoadComponentV2 projectNames ])
		and: [ self postloadDoitName = aRwProjectLoadComponentV2 postloadDoitName ])
		and: [ self preloadDoitName = aRwProjectLoadComponentV2 preloadDoitName ]
%

category: 'accessing'
method: RwAbstractActiveComponent
addProjectNamed: aProjectName
	| pn |
	pn := self projectNames.	" returns copy, so cannot add directly to result"
	pn add: aProjectName.
	projectNames := pn asSet asArray sort
%

category: 'accessing'
method: RwAbstractActiveComponent
conditionalPackageMapSpecs

	^ conditionalPackageMapSpecs ifNil: [ conditionalPackageMapSpecs := Dictionary new ]
%

category: 'accessing'
method: RwAbstractActiveComponent
conditionalPackageMapSpecsAtGemStoneUserId: userId andPackageName: packageName setMethodEnvTo: env
	| dict |
	dict := (((self conditionalPackageMapSpecs
		at: 'gemstone'
		ifAbsentPut: [ Dictionary new ]) at: userId ifAbsentPut: [ Dictionary new ])
		at: #'packageNameToPlatformPropertiesMap'
		ifAbsentPut: [ Dictionary new ])
		at: packageName
		ifAbsentPut: [ Dictionary new ].
	env
		ifNil: [ dict removeKey: 'methodEnv' ifAbsent: [  ] ]
		ifNotNil: [ dict at: 'methodEnv' put: env ]
%

category: 'accessing'
method: RwAbstractActiveComponent
conditionalPackageMapSpecsAtGemStoneUserId: userId andPackageName: packageName setSymbolDictNameTo: symbolDictName
	| dict |
	dict := (((self conditionalPackageMapSpecs
		at: 'gemstone'
		ifAbsentPut: [ Dictionary new ]) at: userId ifAbsentPut: [ Dictionary new ])
		at: #'packageNameToPlatformPropertiesMap'
		ifAbsentPut: [ Dictionary new ])
		at: packageName
		ifAbsentPut: [ Dictionary new ].
	symbolDictName
		ifNil: [ dict removeKey: 'symbolDictName' ifAbsent: [  ] ]
		ifNotNil: [ dict at: 'symbolDictName' put: symbolDictName asString ]
%

category: 'accessing'
method: RwAbstractActiveComponent
conditionalPackageMapSpecsAtGemStoneUserId: userId andPackageName: packageName setUseSessionMethodsForExtensions: aBool
	| dict |
	dict := (((self conditionalPackageMapSpecs
		at: 'gemstone'
		ifAbsentPut: [ Dictionary new ]) at: userId ifAbsentPut: [ Dictionary new ])
		at: #'packageNameToPlatformPropertiesMap'
		ifAbsentPut: [ Dictionary new ])
		at: packageName
		ifAbsentPut: [ Dictionary new ].
	aBool
		ifNil: [ dict removeKey: 'useSessionMethodsForExtensions' ifAbsent: [  ] ]
		ifNotNil: [ dict at: 'useSessionMethodsForExtensions' put: aBool ]
%

category: 'private'
method: RwAbstractActiveComponent
conditionalPropertyMatchers
	self subclassResponsibility: #'conditionalPropertyMatchers'
%

category: 'accessing'
method: RwAbstractActiveComponent
doitDict
	^doitDict
%

category: 'accessing'
method: RwAbstractActiveComponent
doitDict: object
	doitDict := object
%

category: 'doits'
method: RwAbstractActiveComponent
executePostloadDoit
	self postloadDoitName
		ifNotNil: [ (self doitDict at: self postloadDoitName) evaluate ]
%

category: 'doits'
method: RwAbstractActiveComponent
executePreloadDoit
	self preloadDoitName
		ifNotNil: [ (self doitDict at: self preloadDoitName) evaluate ]
%

category: 'exporting'
method: RwAbstractActiveComponent
exportDoitsToUrl: directoryUrl
	| doitsRoot url |
	url := directoryUrl asRwUrl.
	url schemeName = 'file'
		ifTrue: [ 
			doitsRoot := url pathForDirectory asFileReference.
			{(self preloadDoitName).
			(self postloadDoitName)}
				do: [ :doitName | 
					doitName
						ifNotNil: [ 
							(self doitDict at: doitName ifAbsent: [  ])
								ifNotNil: [ :doitString | 
									| fileRef |
									fileRef := doitsRoot / doitName , 'st'.
									fileRef exists
										ifFalse: [ fileRef ensureCreateFile ].
									fileRef
										writeStreamDo: [ :fileStream | fileStream truncate; nextPutAll: doitString ] ] ] ] ]
		ifFalse: [ self error: 'unsupported url scheme ' , url schemeName printString ]
%

category: 'exporting'
method: RwAbstractActiveComponent
exportToUrl: directoryUrl
	self exportDoitsToUrl: directoryUrl.
	^ super exportToUrl: directoryUrl
%

category: 'testing'
method: RwAbstractActiveComponent
hasDoits
	^ preloadDoitName notNil or: [ postloadDoitName notNil ]
%

category: 'comparing'
method: RwAbstractActiveComponent
hash
	| hashValue |
	hashValue := self name hash.
	hashValue := hashValue bitXor: self comment hash.
	hashValue := hashValue bitXor: self conditionalPackageMapSpecs hash.
	hashValue := hashValue bitXor: self packageNames hash.
	^ hashValue bitXor: self componentNames hash
%

category: 'initialization'
method: RwAbstractActiveComponent
initialize
	super initialize.
	doitDict := Dictionary new.
	projectNames := {}
%

category: 'initialization'
method: RwAbstractActiveComponent
initializeForExport
	"if spec is to be exported, clear out any of the fields that represent state that should 
	not be shared"

	"for export, the keys in the dictionaries of the structures need to be put into canonical order"

	super initializeForExport.
	doitDict := nil.
	conditionalPackageMapSpecs
		ifNotNil: [ 
			conditionalPackageMapSpecs isEmpty
				ifTrue: [ 
					"don't export this field if it is empty ..."
					conditionalPackageMapSpecs := nil ]
				ifFalse: [ 
					| orderedConditionalPackageMapSpecs |
					orderedConditionalPackageMapSpecs := self class orderedDictionaryClass new.
					(conditionalPackageMapSpecs keys asSortedCollection: [ :a :b | a <= b ])
						do: [ :platformName | 
							| orderedPlatformMap platformMap |
							platformMap := conditionalPackageMapSpecs at: platformName.
							orderedPlatformMap := platformName = 'gemstone'
								ifTrue: [ self _canonicalizeGemStonePackageMapSpecs: platformMap ]
								ifFalse: [ self error: 'Unknown platform name ' , platformName printString ].
							orderedPlatformMap isEmpty
								ifFalse: [ orderedConditionalPackageMapSpecs at: platformName put: orderedPlatformMap ] ].
					conditionalPackageMapSpecs := orderedConditionalPackageMapSpecs ] ]
%

category: 'ston'
method: RwAbstractActiveComponent
instVarNamesInOrderForSton
	^ #(#'name' #'preloadDoitName' #'postloadDoitName' #'projectNames' #'componentNames' #'packageNames' #'conditionalPackageMapSpecs' #'comment')
%

category: 'accessing'
method: RwAbstractActiveComponent
packageNamesForConditionalAttributes: conditionalAttributes
	"Answer the collection of package names defined in the receiver."

	| allDefinedPackageNames matchers |
	allDefinedPackageNames := Set new.
	matchers := self conditionalPropertyMatchers.
	conditionalAttributes
		do: [ :anObject | 
			matchers
				keysAndValuesDo: [ :ar :ignored | 
					ar
						do: [ :matcher | 
							(matcher match: anObject)
								ifTrue: [ allDefinedPackageNames addAll: self packageNames ] ] ] ].
	^ allDefinedPackageNames
%

category: 'copying'
method: RwAbstractActiveComponent
postCopy
	super postCopy.
	projectNames := projectNames copy.
	doitDict := doitDict copy.
	conditionalPackageMapSpecs
		ifNotNil: [ 
			| packageMapSpecsCopy |
			packageMapSpecsCopy := conditionalPackageMapSpecs copy.
			conditionalPackageMapSpecs
				keysAndValuesDo: [ :platformName :userMap | 
					platformName = 'gemstone'
						ifTrue: [ 
							| userMapCopy |
							userMapCopy := userMap copy.
							packageMapSpecsCopy at: platformName put: userMapCopy.
							userMap
								keysAndValuesDo: [ :userName :attributeMap | 
									| attributeMapCopy |
									attributeMapCopy := attributeMap copy.
									userMapCopy at: userName put: attributeMapCopy.
									attributeMap
										keysAndValuesDo: [ :attributeName :packageMap | 
											| packageMapCopy |
											packageMapCopy := packageMap copy.
											attributeMapCopy at: attributeName put: packageMapCopy.
											packageMap
												keysAndValuesDo: [ :packageName :packageAttribute | packageMapCopy at: packageName put: packageAttribute copy ] ] ] ]
						ifFalse: [ self error: 'Unknown platform name ' , platformName printString ] ].
			conditionalPackageMapSpecs := packageMapSpecsCopy ]
%

category: 'accessing'
method: RwAbstractActiveComponent
postloadDoitName
	^postloadDoitName
%

category: 'accessing'
method: RwAbstractActiveComponent
postloadDoitName: object
	postloadDoitName := object
%

category: 'accessing'
method: RwAbstractActiveComponent
preloadDoitName
	^preloadDoitName
%

category: 'accessing'
method: RwAbstractActiveComponent
preloadDoitName: object
	preloadDoitName := object
%

category: 'accessing'
method: RwAbstractActiveComponent
projectNames
	^ projectNames copy
%

category: 'accessing'
method: RwAbstractActiveComponent
removePackageNamed: aPackageName
	self conditionalPackageMapSpecs
		keysAndValuesDo: [ :platformPattern :packageMapSpecsMap | 
			packageMapSpecsMap
				keysAndValuesDo: [ :userId :packageMapSpecs | 
					(packageMapSpecs at: #'packageNameToPlatformPropertiesMap')
						removeKey: aPackageName
						ifAbsent: [  ] ] ].
	super removePackageNamed: aPackageName
%

category: 'accessing'
method: RwAbstractActiveComponent
removeProjectNamed: aProjectName
	self subclassResponsibility: #'removeProjectNamed:'
%

category: 'accessing'
method: RwAbstractActiveComponent
renameTo: aString in: aResolvedProject
	"change the basename of aComponentPath to <baseName>, i.e., the path is not changed"

	"need to change all the references, so not enough to just change my name"

	^ aResolvedProject renameComponentNamed: self name to: aString
%

category: 'validation'
method: RwAbstractActiveComponent
validate
	"ensure that the data structures within the receiver contain valid information:
		1. only packages defined in the receiver may be referenced in the reciever
		2. platform implementation is responsible for validating platform structures"

	| allDefinedPackageNames |
	self name ifNil: [ self error: 'name is nil' ].
	allDefinedPackageNames := self _validatedPackageNames.
	self conditionalPackageMapSpecs
		keysAndValuesDo: [ :platformName :platformPropertiesMap | 
			(RwSpecification _supportedPlatformNames includes: platformName)
				ifFalse: [ 
					Error
						signal:
							'Unknown platform name ' , platformName printString
								, ' in conditional package map specs' ].
			platformName = 'gemstone'
				ifTrue: [ self _validateGemStonePlatform: allDefinedPackageNames userIdMap: platformPropertiesMap ] ].
	^ true
%

category: 'dispatching'
method: RwAbstractActiveComponent
_addToResolvedProjectComponents: aRwResolvedProjectComponentsV2
	"dispatch to _addActiveComponent: or _addPackageGroup: as appropriate"

	aRwResolvedProjectComponentsV2 _addActiveComponent: self
%

category: 'private'
method: RwAbstractActiveComponent
_canonicalizeGemStonePackageMapSpecs: userMap
	| orderedUserMap |
	orderedUserMap := self class orderedDictionaryClass new.
	(userMap keys asSortedCollection: [ :a :b | a <= b ])
		do: [ :userName | 
			| attributeMap orderedAttributeMap |
			attributeMap := userMap at: userName.
			orderedAttributeMap := self class orderedDictionaryClass new.
			(attributeMap keys asSortedCollection: [ :a :b | a <= b ])
				do: [ :attributeName | 
					| packageMap orderedPackageMap |
					packageMap := attributeMap at: attributeName.
					orderedPackageMap := self class orderedDictionaryClass new.
					(packageMap keys asSortedCollection: [ :a :b | a <= b ])
						do: [ :packageName | 
							(packageMap at: packageName) isEmpty
								ifFalse: [ orderedPackageMap at: packageName put: (packageMap at: packageName) ] ].
					orderedPackageMap isEmpty
						ifFalse: [ orderedAttributeMap at: attributeName put: orderedPackageMap ] ].
			orderedAttributeMap isEmpty
				ifFalse: [ orderedUserMap at: userName put: orderedAttributeMap ] ].
	^ orderedUserMap
%

category: 'doits'
method: RwAbstractActiveComponent
_readDoitsFrom: componentsRoot
	| fileRef |
	preloadDoitName
		ifNotNil: [ 
			fileRef := componentsRoot / preloadDoitName , 'st'.
			fileRef exists
				ifTrue: [ 
					fileRef
						readStreamDo: [ :fileStream | self doitDict at: preloadDoitName put: fileStream contents ] ]
				ifFalse: [ self error: '"no doit file ' , preloadDoitName printString , ' found"' ] ].
	postloadDoitName
		ifNotNil: [ 
			fileRef := componentsRoot / postloadDoitName , 'st'.

			fileRef exists
				ifTrue: [ 
					fileRef
						readStreamDo: [ :fileStream | self doitDict at: postloadDoitName put: fileStream contents ] ]
				ifFalse: [ self error: '"no doit file ' , postloadDoitName printString , ' found"' ] ]
%

category: 'validation'
method: RwAbstractActiveComponent
_validateDoits
	self preloadDoitName
		ifNotNil: [ 
			((self doitDict
				at: self preloadDoitName
				ifAbsent: [ 
					self
						error:
							'Expected doit for ' , self preloadDoitName printString , ' to exist.' ])
				isKindOf: CharacterCollection)
				ifFalse: [ 
					self
						error:
							'Doit for ' , self preloadDoitName printString , ' is not a CharacterCollection' ] ].
	self postloadDoitName
		ifNotNil: [ 
			((self doitDict
				at: self postloadDoitName
				ifAbsent: [ 
					self
						error:
							'Expected doit for ' , self postloadDoitName printString , ' to exist.' ])
				isKindOf: CharacterCollection)
				ifFalse: [ 
					self
						error:
							'Doit for ' , self postloadDoitName printString
								, ' is not a CharacterCollection' ] ]
%

category: 'validation'
method: RwAbstractActiveComponent
_validateGemStonePlatform: allDefinedPackageNames userIdMap: userIdMap
	"ensure that the data structures within the receiver contain valid information:
		1. only packages defined in the receiver may be referenced in the reciever
		2. platform implementation is responsible for validating platform structures"

	userIdMap
		keysAndValuesDo: [ :userId :platformPropertiesMap | 
			platformPropertiesMap
				keysAndValuesDo: [ :key :packagePropertiesMap | 
					key == #'packageNameToPlatformPropertiesMap'
						ifFalse: [ Error signal: 'Unknown platformPropertiesMap key ' , key printString ].
					packagePropertiesMap
						keysAndValuesDo: [ :packageName :packageProperties | 
							(allDefinedPackageNames includes: packageName)
								ifFalse: [ 
									Error
										signal:
											'Undefined package name ' , packageName printString
												, ' used in plaform properties map' ].
							packageProperties
								keysDo: [ :packagePropertyName | 
									(self class _gemstoneSupportedPackagePropertyNames
										includes: packagePropertyName)
										ifFalse: [ Error signal: 'Unknown package property name ' , packagePropertyName printString ] ] ] ] ]
%

! Class implementation for 'RwLoadComponent'

!		Instance methods for 'RwLoadComponent'

category: 'comparing'
method: RwLoadComponent
= aRwLoadComponent
	^ super = aRwLoadComponent
		and: [ self projectNames = aRwLoadComponent projectNames ]
%

category: 'visiting'
method: RwLoadComponent
acceptNestedVisitor: aVisitor

	^ self acceptVisitor: aVisitor
%

category: 'visiting'
method: RwLoadComponent
acceptVisitor: aVisitor
	^ aVisitor visitComponent: self
%

category: 'accessing'
method: RwLoadComponent
conditionalPropertyMatchers
	^ Dictionary new
		at: {(RwUnconditionalPlatformAttributeMatcher new)} put: {};
		yourself
%

category: 'comparing'
method: RwLoadComponent
hash
	^ super hash bitXor: projectNames hash
%

category: 'ston'
method: RwLoadComponent
instVarNamesInOrderForSton
	^ #(#'name' #'projectName' #'preloadDoitName' #'postloadDoitName' #'projectNames' #'componentNames' #'packageNames' #'conditionalPackageMapSpecs' #'comment')
%

category: 'accessing'
method: RwLoadComponent
removeProjectNamed: aProjectName
	projectNames remove: aProjectName ifAbsent: [  ]
%

! Class implementation for 'RwSubcomponent'

!		Instance methods for 'RwSubcomponent'

category: 'comparing'
method: RwSubcomponent
= aRwProjectLoadComponentV2
	^ super = aRwProjectLoadComponentV2
		and: [ self condition = aRwProjectLoadComponentV2 condition ]
%

category: 'visiting'
method: RwSubcomponent
acceptNestedVisitor: aVisitor
	^ aVisitor visitComponent: self
%

category: 'visiting'
method: RwSubcomponent
acceptVisitor: aVisitor
	^ self
		error:
			'Subcomponent cannot be independently loaded. The receiver is nested inside of load components'
%

category: 'accessing'
method: RwSubcomponent
condition
	^condition
%

category: 'accessing'
method: RwSubcomponent
condition: aString
	aString isString
		ifFalse: [ self error: 'The condition is constrained to be a string' ].
	condition := aString
%

category: 'accessing'
method: RwSubcomponent
conditionalPropertyMatchers
	^ Dictionary new
		at: {(self _platformPatternMatcherFor: self condition)} put: {};
		yourself
%

category: 'initialization'
method: RwSubcomponent
initialize
	super initialize.
	condition := 'common'.
%

category: 'ston'
method: RwSubcomponent
instVarNamesInOrderForSton
	^ #(#'name' #'projectName' #'condition' #'preloadDoitName' #'postloadDoitName' #'projectNames' #'componentNames' #'packageNames' #'conditionalPackageMapSpecs' #'comment')
%

category: 'accessing'
method: RwSubcomponent
label

   ^self basename, ' (', self condition, ')'
%

category: 'validation'
method: RwSubcomponent
validate
	"ensure that the data structures within the receiver contain valid information:
		1. only packages defined in the receiver may be referenced in the reciever
		2. platform implementation is responsible for validating platform structures"

	self condition ifNil: [ self error: 'conditions is nil' ].
	^ super validate
%

! Class implementation for 'RwPlatformSubcomponent'

!		Instance methods for 'RwPlatformSubcomponent'

category: 'accessing'
method: RwPlatformSubcomponent
condition
	^condition copy
%

category: 'accessing'
method: RwPlatformSubcomponent
condition: anArray
	anArray _isArray
		ifFalse: [ self error: 'The condition is constrained to be an array' ].
	condition := anArray
%

category: 'accessing'
method: RwPlatformSubcomponent
conditionalPropertyMatchers
	^ Dictionary new
		at:
				(self condition
						collect: [ :aCondition | self _platformPatternMatcherFor: aCondition ])
			put: {};
		yourself
%

category: 'accessing'
method: RwPlatformSubcomponent
label
	| strm |
	strm := WriteStream on: String new.
	strm
		nextPutAll: self basename;
		space;
		nextPut: ${.
	self condition
		do: [ :cond | 
			strm
				space;
				nextPutAll: cond asString ].
	strm
		space;
		nextPut: $}.
	^ strm contents
%

! Class implementation for 'RwPackageGroup'

!		Instance methods for 'RwPackageGroup'

category: 'comparing'
method: RwPackageGroup
= aRwProjectLoadComponentV2
	^ super = aRwProjectLoadComponentV2
		and: [ self condition = aRwProjectLoadComponentV2 condition ]
%

category: 'visiting'
method: RwPackageGroup
acceptNestedVisitor: aVisitor
	^ aVisitor visitPackageGroupComponent: self
%

category: 'accessing'
method: RwPackageGroup
condition
	^condition
%

category: 'accessing'
method: RwPackageGroup
condition: aString
	aString isString
		ifFalse: [ self error: 'The condition is constrained to be a string' ].
	condition := aString
%

category: 'accessing'
method: RwPackageGroup
conditionalPropertyMatchers
	^ Dictionary new
		at: {(self _platformPatternMatcherFor: self condition)} put: {};
		yourself
%

category: 'initialization'
method: RwPackageGroup
initialize
	super initialize.
	condition := 'common'.
%

category: 'ston'
method: RwPackageGroup
instVarNamesInOrderForSton
	^ #(#'name' #'condition' #'componentNames' #'packageNames' #'comment')
%

category: 'accessing'
method: RwPackageGroup
label

   ^'__ ', self basename, ' (', self condition, ')'
%

category: 'accessing'
method: RwPackageGroup
renameTo: aString in: aResolvedProject
	"need to change all the references, so not enough to just change my name"

	^ aResolvedProject renamePackageGroupNamed: self name to: aString
%

category: 'validation'
method: RwPackageGroup
validate
	"ensure that the data structures within the receiver contain valid information:
		1. only packages defined in the receiver may be referenced in the reciever
		2. platform implementation is responsible for validating platform structures"

	self name ifNil: [ self error: 'name is nil' ].
	self condition ifNil: [ self error: 'name is nil' ].
	self _validatedPackageNames.
	^ true
%

category: 'dispatching'
method: RwPackageGroup
_addToResolvedProjectComponents: aRwResolvedProjectComponentsV2
	"dispatch to _addActiveComponent: or _addPackageGroup: as appropriate"

	aRwResolvedProjectComponentsV2 _addPackageGroup: self
%

! Class implementation for 'RwAbstractConfigurationPlatformAttributeMatcher'

!		Instance methods for 'RwAbstractConfigurationPlatformAttributeMatcher'

category: 'matching'
method: RwAbstractConfigurationPlatformAttributeMatcher
match: anObject

	self subclassResponsibility: #match:
%

category: 'matching'
method: RwAbstractConfigurationPlatformAttributeMatcher
matchString: aString

	self subclassResponsibility: #matchString:
%

category: 'matching'
method: RwAbstractConfigurationPlatformAttributeMatcher
matchVersion: anRwGemStoneVersionNumber

	self subclassResponsibility: #matchVersion:
%

category: 'accessing'
method: RwAbstractConfigurationPlatformAttributeMatcher
pattern: anObject
	pattern := anObject
%

category: 'accessing'
method: RwAbstractConfigurationPlatformAttributeMatcher
patternMatchBlock: aBlock
	patternMatchBlock := aBlock
%

! Class implementation for 'RwGemStoneVersionConfigurationPlatformAttributeMatcher'

!		Instance methods for 'RwGemStoneVersionConfigurationPlatformAttributeMatcher'

category: 'matching'
method: RwGemStoneVersionConfigurationPlatformAttributeMatcher
match: anObject

	^ anObject rwPlatformAttributeMatchForGemStoneVersion: self
%

category: 'matching'
method: RwGemStoneVersionConfigurationPlatformAttributeMatcher
matchString: aString

	^ false
%

category: 'matching'
method: RwGemStoneVersionConfigurationPlatformAttributeMatcher
matchVersion: aGemStoneVersion

	^ patternMatchBlock cull: pattern cull: aGemStoneVersion
%

! Class implementation for 'RwGemStoneVersionRangeConfigurationPlatformAttributeMatcher'

!		Instance methods for 'RwGemStoneVersionRangeConfigurationPlatformAttributeMatcher'

category: 'matching'
method: RwGemStoneVersionRangeConfigurationPlatformAttributeMatcher
matchVersion: aGemStoneVersion

	^ patternMatchBlock cull: pattern cull: aGemStoneVersion cull: pattern2
%

category: 'accessing'
method: RwGemStoneVersionRangeConfigurationPlatformAttributeMatcher
pattern2: anObject
	pattern2 := anObject
%

! Class implementation for 'RwStringConfigurationPlatformAttributeMatcher'

!		Instance methods for 'RwStringConfigurationPlatformAttributeMatcher'

category: 'matching'
method: RwStringConfigurationPlatformAttributeMatcher
match: anObject

	^ anObject rwPlatformAttributeMatchForString: self
%

category: 'matching'
method: RwStringConfigurationPlatformAttributeMatcher
matchString: aString

	^ patternMatchBlock cull: pattern cull: aString
%

category: 'matching'
method: RwStringConfigurationPlatformAttributeMatcher
matchVersion: aGemStoneVersion

	^ false
%

! Class implementation for 'RwUnconditionalPlatformAttributeMatcher'

!		Instance methods for 'RwUnconditionalPlatformAttributeMatcher'

category: 'matching'
method: RwUnconditionalPlatformAttributeMatcher
match: anObject
	^ true
%

! Class implementation for 'RwAbstractProjectSetModificationVisitor'

!		Class methods for 'RwAbstractProjectSetModificationVisitor'

category: 'instance creation'
classmethod: RwAbstractProjectSetModificationVisitor
visit: aProjectSetModification
	^ self new visit: aProjectSetModification
%

!		Instance methods for 'RwAbstractProjectSetModificationVisitor'

category: 'actions'
method: RwAbstractProjectSetModificationVisitor
addedClass: aClassModification
	currentClassDefinition := aClassModification after
%

category: 'actions'
method: RwAbstractProjectSetModificationVisitor
addedClassExtension: aClassExtensionModification
	currentClassExtension := aClassExtensionModification after
%

category: 'actions'
method: RwAbstractProjectSetModificationVisitor
addedMethod: aMethodModification
%

category: 'actions'
method: RwAbstractProjectSetModificationVisitor
addedMethodExtension: aMethodExtensionModification
%

category: 'actions'
method: RwAbstractProjectSetModificationVisitor
addedPackage: aPackageModification
	currentPackageDefinition := aPackageModification after
%

category: 'actions'
method: RwAbstractProjectSetModificationVisitor
addedProject: aProjectModification
	currentProjectDefinition := aProjectModification after
%

category: 'actions'
method: RwAbstractProjectSetModificationVisitor
changedClass: aClassModification
	currentClassDefinition := aClassModification after
%

category: 'actions'
method: RwAbstractProjectSetModificationVisitor
changedClassExtension: aClassExtensionModification
	currentClassExtension := aClassExtensionModification after
%

category: 'actions'
method: RwAbstractProjectSetModificationVisitor
changedMethod: aMethodModification
%

category: 'actions'
method: RwAbstractProjectSetModificationVisitor
changedMethodExtension: aMethodExtensionModification
%

category: 'actions'
method: RwAbstractProjectSetModificationVisitor
changedPackage: aPackageModification
	currentPackageDefinition := aPackageModification after
%

category: 'actions'
method: RwAbstractProjectSetModificationVisitor
changedProject: aProjectModification
	currentProjectDefinition := aProjectModification after
%

category: 'accessing'
method: RwAbstractProjectSetModificationVisitor
currentClassDefinition
	^ currentClassDefinition
%

category: 'accessing'
method: RwAbstractProjectSetModificationVisitor
currentClassExtension
	^ currentClassExtension
%

category: 'accessing'
method: RwAbstractProjectSetModificationVisitor
currentPackageDefinition
	^ currentPackageDefinition
%

category: 'accessing'
method: RwAbstractProjectSetModificationVisitor
currentPackageDefinition: aRwPackageDefinition
	currentPackageDefinition := aRwPackageDefinition
%

category: 'accessing'
method: RwAbstractProjectSetModificationVisitor
currentProjectDefinition
	^ currentProjectDefinition
%

category: 'accessing'
method: RwAbstractProjectSetModificationVisitor
currentProjectDefinition: aRwComponentProjectDefinition
	currentProjectDefinition := aRwComponentProjectDefinition
%

category: 'actions'
method: RwAbstractProjectSetModificationVisitor
deletedClass: aClassModification
%

category: 'actions'
method: RwAbstractProjectSetModificationVisitor
deletedClassExtension: aClassExtensionModification
%

category: 'actions'
method: RwAbstractProjectSetModificationVisitor
deletedMethod: aMethodModification
%

category: 'actions'
method: RwAbstractProjectSetModificationVisitor
deletedMethodExtension: aMethodExtensionModification
%

category: 'actions'
method: RwAbstractProjectSetModificationVisitor
deletedPackage: aPackageModification
%

category: 'actions'
method: RwAbstractProjectSetModificationVisitor
deletedProject: aProjectModification
%

category: 'public'
method: RwAbstractProjectSetModificationVisitor
visit: aProjectSetModification
	aProjectSetModification acceptVisitor: self
%

category: 'visiting'
method: RwAbstractProjectSetModificationVisitor
visitClassesModification: aClassesModification
	aClassesModification elementsModified do: [ :each | each acceptVisitor: self ]
%

category: 'visiting'
method: RwAbstractProjectSetModificationVisitor
visitClassExtensionModification: aClassExtensionModification
	aClassExtensionModification isAddition
		ifTrue: [ 
			self addedClassExtension: aClassExtensionModification.
			aClassExtensionModification instanceMethodsModification acceptVisitor: self.
			aClassExtensionModification classMethodsModification acceptVisitor: self.
			^ self ].
	aClassExtensionModification isDeletion
		ifTrue: [ ^ self deletedClassExtension: aClassExtensionModification ].
	self changedClassExtension: aClassExtensionModification.
	aClassExtensionModification instanceMethodsModification acceptVisitor: self.
	aClassExtensionModification classMethodsModification acceptVisitor: self.
	^ self
%

category: 'visiting'
method: RwAbstractProjectSetModificationVisitor
visitClassExtensionsModification: aClassExtensionsModification
	aClassExtensionsModification elementsModified
		do: [ :each | each acceptVisitor: self ]
%

category: 'visiting'
method: RwAbstractProjectSetModificationVisitor
visitClassModification: aClassModification
	aClassModification isAddition
		ifTrue: [ 
			self addedClass: aClassModification.
			aClassModification instanceMethodsModification acceptVisitor: self.
			aClassModification classMethodsModification acceptVisitor: self.
			^ self ].
	aClassModification isDeletion
		ifTrue: [ ^ self deletedClass: aClassModification ].
	self changedClass: aClassModification.
	aClassModification instanceMethodsModification acceptVisitor: self.
	aClassModification classMethodsModification acceptVisitor: self.
	^ self
%

category: 'visiting'
method: RwAbstractProjectSetModificationVisitor
visitExtensionMethodModification: aMethodExtensionModification
	aMethodExtensionModification isAddition
		ifTrue: [ ^ self addedMethodExtension: aMethodExtensionModification ].
	aMethodExtensionModification isDeletion
		ifTrue: [ ^ self deletedMethodExtension: aMethodExtensionModification ].
	^ self changedMethodExtension: aMethodExtensionModification
%

category: 'visiting'
method: RwAbstractProjectSetModificationVisitor
visitExtensionMethodsModification: aMethodExtensionsModification
	aMethodExtensionsModification elementsModified
		do: [ :each | each acceptVisitor: self ]
%

category: 'visiting'
method: RwAbstractProjectSetModificationVisitor
visitMethodModification: aMethodModification
	aMethodModification isAddition
		ifTrue: [ ^ self addedMethod: aMethodModification ].
	aMethodModification isDeletion
		ifTrue: [ ^ self deletedMethod: aMethodModification ].
	^ self changedMethod: aMethodModification
%

category: 'visiting'
method: RwAbstractProjectSetModificationVisitor
visitMethodsModification: aMethodsModification
	aMethodsModification elementsModified do: [ :each | each acceptVisitor: self ]
%

category: 'visiting'
method: RwAbstractProjectSetModificationVisitor
visitPackageModification: aPackageModification
	aPackageModification isAddition
		ifTrue: [ 
			self addedPackage: aPackageModification.
			aPackageModification classesModification acceptVisitor: self.
			aPackageModification classExtensionsModification acceptVisitor: self.
			aPackageModification traitsModification acceptVisitor: self.
			^ self ].
	aPackageModification isDeletion
		ifTrue: [ ^ self deletedPackage: aPackageModification ].
	self changedPackage: aPackageModification.
	aPackageModification classesModification acceptVisitor: self.
	aPackageModification classExtensionsModification acceptVisitor: self.
	aPackageModification traitsModification acceptVisitor: self.
	^ self
%

category: 'visiting'
method: RwAbstractProjectSetModificationVisitor
visitPackagesModification: aPackagesModification
	aPackagesModification elementsModified do: [ :each | each acceptVisitor: self ]
%

category: 'visiting'
method: RwAbstractProjectSetModificationVisitor
visitProjecteSetModification: aProjectSetModification
	aProjectSetModification elementsModified
		do: [ :each | each acceptVisitor: self ]
%

category: 'visiting'
method: RwAbstractProjectSetModificationVisitor
visitProjectModification: aProjectModification
	aProjectModification isAddition
		ifTrue: [ 
			self addedProject: aProjectModification.
			^ aProjectModification packagesModification acceptVisitor: self ].
	aProjectModification isDeletion
		ifTrue: [ ^ self deletedProject: aProjectModification ].
	self changedProject: aProjectModification.
	^ aProjectModification packagesModification acceptVisitor: self
%

category: 'visiting'
method: RwAbstractProjectSetModificationVisitor
visitTraitMethodModification: aTraitMethodModification
	aTraitMethodModification isAddition
		ifTrue: [ ^ self addedMethod: aTraitMethodModification ].
	aTraitMethodModification isDeletion
		ifTrue: [ ^ self deletedMethod: aTraitMethodModification ].
	^ self changedMethod: aTraitMethodModification
%

category: 'visiting'
method: RwAbstractProjectSetModificationVisitor
visitTraitModification: aTraitModification
	aTraitModification isAddition
		ifTrue: [ 
			self addedClass: aTraitModification.
			aTraitModification instanceMethodsModification acceptVisitor: self.
			aTraitModification classMethodsModification acceptVisitor: self.
			^ self ].
	aTraitModification isDeletion
		ifTrue: [ ^ self deletedTrait: aTraitModification ].
	self changedTrait: aTraitModification.
	aTraitModification instanceMethodsModification acceptVisitor: self.
	aTraitModification classMethodsModification acceptVisitor: self.
	^ self
%

category: 'visiting'
method: RwAbstractProjectSetModificationVisitor
visitTraitsModification: aTraitsModification
	true
		ifTrue: [ aTraitsModification elementsModified do: [ :each | each acceptVisitor: self ] ]
%

! Class implementation for 'RwAbstractReaderWriterVisitor'

!		Class methods for 'RwAbstractReaderWriterVisitor'

category: 'accessing'
classmethod: RwAbstractReaderWriterVisitor
tonelClassLabel
	^ 'Class'
%

category: 'accessing'
classmethod: RwAbstractReaderWriterVisitor
tonelExtensionLabel
	^ 'Extension'
%

category: 'accessing'
classmethod: RwAbstractReaderWriterVisitor
tonelTraitLabel
	^ 'Trait'
%

category: 'validation'
classmethod: RwAbstractReaderWriterVisitor
validatePackageConvention: packageConvention forClassCategory: aClassDefinition inPackageNamed: packageName
	"
		RowanHybrid	- [default] Class category is package name, method protocol with leading $* is case insensitive package name
		Monticello		- Class category is package name, method protocol with leading $* begins with case insensitive package name
		Rowan			- Class category and method protocol are not overloaded with packaging information
	"

	"signal an error if the class category does not conform to the convention for the current project"

	packageConvention = 'RowanHybrid'
		ifTrue: [ 
			^ self
				_validateRowanHybridClassCategoryConvention: aClassDefinition
				forPackageNamed: packageName ].
	packageConvention = 'Monticello'
		ifTrue: [ 
			^ self
				_validateRowanMonticelloClassCategoryConvention: aClassDefinition
				forPackageNamed: packageName ].
	"Rowan - no convention ... any old class category is fine"
%

category: 'validation'
classmethod: RwAbstractReaderWriterVisitor
validatePackageConvention: packageConvention forClassDefinition: classDefinition forMethodDefinitionProtocol: methodDef className: className isMeta: isMeta forPackageNamed: packageName
	"
		RowanHybrid	- [default] Class category is package name, method protocol with leading $* is case insensitive package name
		Monticello		- Class category is package name, method protocol with leading $* begins with case insensitive package name
		Rowan			- Class category and method protocol are not overloaded with packaging information
	"

	"signal an error if the protocol does not conform to the convention for the current project"

	packageConvention = 'RowanHybrid'
		ifTrue: [ 
			^ self
				_validateRowanHybridProtocolConventionClassDefinition: classDefinition
				methodDefinition: methodDef
				className: className
				isMeta: isMeta
				forPackageNamed: packageName ].
	packageConvention = 'Monticello'
		ifTrue: [ 
			^ self
				_validateRowanMonticelloProtocolConventionClassDefinition: classDefinition
				methodDefinition: methodDef
				className: className
				isMeta: isMeta
				forPackageNamed: packageName ]
	"Rowan - no convention ... any old protocol is fine"
%

category: 'private'
classmethod: RwAbstractReaderWriterVisitor
_readObjectFrom: aFileReference

	aFileReference readStreamDo: [:stream |
		| reader |
		reader := STON reader on:  (ZnBufferedReadStream on:  stream).
		reader classes at: #'Package' put: Dictionary.
		^ reader next ]
%

category: 'private'
classmethod: RwAbstractReaderWriterVisitor
_repositoryPropertyDictFor: packagesRoot
	| propertiesFile |
	propertiesFile := packagesRoot / 'properties' , 'st'.
	propertiesFile exists
		ifFalse: [ 
			| propertiesDict |
			propertiesFile := packagesRoot / '.filetree'.
			propertiesFile exists
				ifFalse: [ 
					propertiesFile := packagesRoot / '.properties'.
					propertiesFile exists
						ifFalse: [ ^ Dictionary new ] ].
			propertiesDict := self _readObjectFrom: propertiesFile.
			propertiesDict at: #'format' put: 'filetree'.
			^ propertiesDict ].
	^ self _readObjectFrom: propertiesFile
%

category: 'validation'
classmethod: RwAbstractReaderWriterVisitor
_validateRowanHybridClassCategoryConvention: aClassDefinition forPackageNamed: packageName
	aClassDefinition category = packageName
		ifTrue: [ ^ self ].
	RwInvalidClassCategoryConventionErrorNotification
		signalWithClassDefinition: aClassDefinition
		packageName: packageName
		packageConvention: 'RowanHybrid'
%

category: 'validation'
classmethod: RwAbstractReaderWriterVisitor
_validateRowanHybridProtocolConventionClassDefinition: classDefinition methodDefinition: methodDef className: className isMeta: isMeta forPackageNamed: packageName
	| canonProtocol expectedProtocol protocol |
	protocol := methodDef protocol.
	(protocol at: 1) = $*
		ifTrue: [ 
			classDefinition
				ifNotNil: [ 
					"protocol should not start with $* for a non-extension method"
					RwExtensionProtocolNonExtensionMethodErrorNotification
						signalWithMethodDefinition: methodDef
						className: className
						isMeta: isMeta
						packageName: packageName
						packageConvention: 'RowanHybrid'.
					^ self ] ]
		ifFalse: [ 
			classDefinition
				ifNotNil: [ 
					"protocol does not start with $* which is correct"
					^ self ] ].	
	"validate conformance to convention for extension method"
	(protocol at: 1) = $*
		ifFalse: [ 
			"extension method protocol must start with a *"
			RwNonExtensionProtocolExtensionMethodErrorNotification
				signalWithMethodDefinition: methodDef
				className: className
				isMeta: isMeta
				packageName: packageName
				packageConvention: 'RowanHybrid'.
			^ self ].
	canonProtocol := protocol asLowercase.
	expectedProtocol := '*' , packageName asLowercase.
	canonProtocol = expectedProtocol
		ifTrue: [ ^ self ].	
	"protocol does not match package name"
	RwExtensionProtocolExtensionMethodPackageMismatchErrorNotification
		signalWithMethodDefinition: methodDef
		className: className
		isMeta: isMeta
		packageName: packageName
		packageConvention: 'RowanHybrid'
%

category: 'validation'
classmethod: RwAbstractReaderWriterVisitor
_validateRowanMonticelloClassCategoryConvention: aClassDefinition forPackageNamed: packageName
	(aClassDefinition category notNil
		and: [ aClassDefinition category beginsWith: packageName ])
		ifTrue: [ ^ self ].
	RwInvalidClassCategoryConventionErrorNotification
		signalWithClassDefinition: aClassDefinition
		packageName: packageName
		packageConvention: 'Monticello'
%

category: 'validation'
classmethod: RwAbstractReaderWriterVisitor
_validateRowanMonticelloProtocolConventionClassDefinition: classDefinition methodDefinition: methodDef className: className isMeta: isMeta forPackageNamed: packageName
	| canonProtocol expectedProtocol protocol |
	protocol := methodDef protocol.
	(protocol at: 1) = $*
		ifTrue: [ 
			classDefinition
				ifNotNil: [ 
					"protocol should not start with $* for a non-extension method"
					RwExtensionProtocolNonExtensionMethodErrorNotification
						signalWithMethodDefinition: methodDef
						className: className
						isMeta: isMeta
						packageName: packageName
						packageConvention: 'Monticello'.
					^ self ] ]
		ifFalse: [ 
			classDefinition
				ifNotNil: [ 
					"protocol does not start with $* as expected"
					^ self ] ].
	"validate conformance to convention for extension method"
	(protocol at: 1) = $*
		ifFalse: [ 
			"extension method protocol must start with a *"
			RwNonExtensionProtocolExtensionMethodErrorNotification
				signalWithMethodDefinition: methodDef
				className: className
				isMeta: isMeta
				packageName: packageName
				packageConvention: 'Monticello'.
			^ self ].
	canonProtocol := protocol asLowercase.
	expectedProtocol := '*' , packageName asLowercase.
	(canonProtocol beginsWith: expectedProtocol)
		ifTrue: [ ^ self ].	"protocol does not match package name"
	RwExtensionProtocolExtensionMethodPackageMismatchErrorNotification
		signalWithMethodDefinition: methodDef
		className: className
		isMeta: isMeta
		packageName: packageName
		packageConvention: 'Monticello'
%

!		Instance methods for 'RwAbstractReaderWriterVisitor'

category: 'accessing'
method: RwAbstractReaderWriterVisitor
currentClassDefinition

	^ currentClassDefinition
%

category: 'accessing'
method: RwAbstractReaderWriterVisitor
currentClassExtension

	^ currentClassExtension
%

category: 'accessing'
method: RwAbstractReaderWriterVisitor
currentPackageDefinition

	^ currentPackageDefinition
%

category: 'accessing'
method: RwAbstractReaderWriterVisitor
currentPackageDefinition: aRwPackageDefinition

	currentPackageDefinition := aRwPackageDefinition
%

category: 'accessing'
method: RwAbstractReaderWriterVisitor
currentProjectDefinition

	^ currentProjectDefinition
%

category: 'accessing'
method: RwAbstractReaderWriterVisitor
currentProjectDefinition: aRwComponentProjectDefinition

	currentProjectDefinition := aRwComponentProjectDefinition
%

category: 'accessing'
method: RwAbstractReaderWriterVisitor
currentTraitDefinition

	^ currentTraitDefinition
%

category: 'accessing'
method: RwAbstractReaderWriterVisitor
currentTraitDefinition: aRwTraitDefinition
	currentTraitDefinition := aRwTraitDefinition
%

category: 'accessing'
method: RwAbstractReaderWriterVisitor
defaultPackageFormat

	self subclassResponsibility: #defaultPackageFormat
%

category: 'accessing'
method: RwAbstractReaderWriterVisitor
packageConvention

	"
		RowanHybrid	- [default] Class category is package name, method protocol with leading $* is case insensitive package name
		Monticello		- Class category is package name, method protocol with leading $* begins with case insensitive package name
		Rowan			- Class category and method protocol are not overloaded with packaging information
	"

	^ packageConvention ifNil: [ 
		| ppc dpc  |
		ppc := self currentProjectDefinition packageConvention.
		dpc := self _repositoryConventionFor: self packagesRoot.
		dpc ~= ppc
			ifTrue:  [ self error: 'Disk package convention ' , dpc printString, 
           ' does not match expected package convention ', ppc printString. ' for project ', self projectName printString ].
		packageConvention := ppc ]
%

category: 'accessing'
method: RwAbstractReaderWriterVisitor
packagesRoot

	^ self currentProjectDefinition packagesRoot
%

category: 'accessing'
method: RwAbstractReaderWriterVisitor
projectName

	^ self currentProjectDefinition projectName
%

category: 'validation'
method: RwAbstractReaderWriterVisitor
validateClassCategory: aClassDefinition forPackageNamed: packageName
	"
		RowanHybrid	- [default] Class category is package name, method protocol with leading $* is case insensitive package name
		Monticello		- Class category is package name, method protocol with leading $* begins with case insensitive package name
		Rowan			- Class category and method protocol are not overloaded with packaging information
	"

	"signal an error if the protocol does not conform to the convention for the current project"

	aClassDefinition isClassExtension 
		ifTrue: [ 
			"no need to validate category for a class extension definition"
			^ self ].
	(Rowan image
		validClassCategory: aClassDefinition category
		forPackageConvention: self packageConvention
		andPackageNamed: packageName)
		ifTrue: [ ^ self ].
	RwInvalidClassCategoryConventionErrorNotification
		signalWithClassDefinition: aClassDefinition
		packageName: packageName
		packageConvention: packageConvention
%

category: 'validation'
method: RwAbstractReaderWriterVisitor
validateMethodDefinitionProtocol: methodDef className: className isMeta: isMeta forPackageNamed:  packageName

	"
		RowanHybrid	- [default] Class category is package name, method protocol with leading $* is case insensitive package name
		Monticello		- Class category is package name, method protocol with leading $* begins with case insensitive package name
		Rowan			- Class category and method protocol are not overloaded with packaging information
	"

	"signal an error if the protocol does not conform to the convention for the current project"

	self packageConvention = 'RowanHybrid'
		ifTrue: [ ^ self _validateRowanHybridProtocolConvention: methodDef className: className isMeta: isMeta forPackageNamed:  packageName ].
	self packageConvention = 'Monticello'
		ifTrue: [ ^ self _validateRowanMonticelloProtocolConvention:methodDef className: className isMeta: isMeta forPackageNamed:  packageName ].
	"Rowan - no convention ... any old protocol is fine"
%

category: 'private'
method: RwAbstractReaderWriterVisitor
_packageConvention: aString

	packageConvention := aString
%

category: 'private'
method: RwAbstractReaderWriterVisitor
_readObjectFrom: aFileReference

	^ self class _readObjectFrom: aFileReference
%

category: 'private'
method: RwAbstractReaderWriterVisitor
_repositoryConventionFor: packagesRoot

	^ (self _repositoryPropertyDictFor: packagesRoot) at: #convention ifAbsent: [ 'RowanHybrid'  ]
%

category: 'private'
method: RwAbstractReaderWriterVisitor
_repositoryFormatFor: packagesRoot

	^ (self _repositoryPropertyDictFor: packagesRoot) at: #format ifAbsent: [ self defaultPackageFormat ]
%

category: 'private'
method: RwAbstractReaderWriterVisitor
_repositoryPropertyDictFor: packagesRoot

	^ self class _repositoryPropertyDictFor: packagesRoot
%

category: 'validation'
method: RwAbstractReaderWriterVisitor
_validateRowanHybridProtocolConvention: methodDef className: className isMeta: isMeta forPackageNamed: packageName
	| canonProtocol expectedProtocol protocol |
	protocol := methodDef protocol.
	(protocol at: 1) = $*
		ifTrue: [ 
			(currentClassDefinition notNil or: [ currentTraitDefinition notNil ])
				ifTrue: [ 
					"protocol should not start with $* for a non-extension method"
					RwExtensionProtocolNonExtensionMethodErrorNotification
						signalWithMethodDefinition: methodDef
						className: className
						isMeta: isMeta
						packageName: packageName
						packageConvention: 'RowanHybrid'.
					^ self ] ]
		ifFalse: [ 
			currentClassDefinition
				ifNotNil: [ 
					"protocol does not start with $* as expected"
					^ self ].
			currentTraitDefinition
				ifNotNil: [ 
					"protocol does not start with $* as expected"
					^ self ] ].	"
	validate conformance to convention for extension method"
	(protocol at: 1) = $*
		ifFalse: [ 
			"extension method protocol must start with a *"
			RwNonExtensionProtocolExtensionMethodErrorNotification
				signalWithMethodDefinition: methodDef
				className: className
				isMeta: isMeta
				packageName: packageName
				packageConvention: 'RowanHybrid'.
			^ self ].
	canonProtocol := protocol asLowercase.
	expectedProtocol := '*' , packageName asLowercase.
	canonProtocol = expectedProtocol
		ifTrue: [ ^ self ].	"protocol does not match package name"
	RwExtensionProtocolExtensionMethodPackageMismatchErrorNotification
		signalWithMethodDefinition: methodDef
		className: className
		isMeta: isMeta
		packageName: packageName
		packageConvention: 'RowanHybrid'
%

category: 'validation'
method: RwAbstractReaderWriterVisitor
_validateRowanMonticelloProtocolConvention: methodDef className: className isMeta: isMeta forPackageNamed: packageName
	| canonProtocol expectedProtocol protocol |
	protocol := methodDef protocol.
	(protocol at: 1) = $*
		ifTrue: [ 
			(currentClassDefinition notNil or: [ currentTraitDefinition notNil ])
				ifTrue: [ 
					"protocol should not start with $* for a non-extension method"
					RwExtensionProtocolNonExtensionMethodErrorNotification
						signalWithMethodDefinition: methodDef
						className: className
						isMeta: isMeta
						packageName: packageName
						packageConvention: 'Monticello'.
					^ self ] ]
		ifFalse: [ 
			currentClassDefinition
				ifNotNil: [ 
					"protocol does not start with $* as expected"
					^ self ].
			currentTraitDefinition
				ifNotNil: [ 
					"protocol does not start with $* as expected"
					^ self ] ].	"
	validate conformance to convention for extension method"
	(protocol at: 1) = $*
		ifFalse: [ 
			"extension method protocol must start with a *"
			RwNonExtensionProtocolExtensionMethodErrorNotification
				signalWithMethodDefinition: methodDef
				className: className
				isMeta: isMeta
				packageName: packageName
				packageConvention: 'Monticello'.
			^ self ].
	canonProtocol := protocol asLowercase.
	expectedProtocol := '*' , packageName asLowercase copyUpTo: $..
	(canonProtocol beginsWith: expectedProtocol)
		ifTrue: [ ^ self ].	"
	protocol does not match package name"
	RwExtensionProtocolExtensionMethodPackageMismatchErrorNotification
		signalWithMethodDefinition: methodDef
		className: className
		isMeta: isMeta
		packageName: packageName
		packageConvention: 'Monticello'
%

! Class implementation for 'RwModificationWriterVisitor'

!		Class methods for 'RwModificationWriterVisitor'

category: 'accessing'
classmethod: RwModificationWriterVisitor
lineEnding
  "Answer the os-specific line endings"

  ^ String with: Character lf
%

!		Instance methods for 'RwModificationWriterVisitor'

category: 'actions'
method: RwModificationWriterVisitor
addedClass: aClassModification

	currentClassDefinition := aClassModification after.

	self processClass: aClassModification
%

category: 'actions'
method: RwModificationWriterVisitor
addedClassExtension: aClassExtensionModification

	currentClassExtension := aClassExtensionModification after.

	self proces