! Copyright (C) GemTalk Systems 1986-2025.  All Rights Reserved.
! Class extensions for 'Character'

!		Instance methods for 'Character'

category: 'gemstone-tonel'
method: Character
isCharacter

	^ true
%

! Class extensions for 'CharacterCollection'

!		Instance methods for 'CharacterCollection'

category: 'gemstone-tonel'
method: CharacterCollection
endsWith: suffix

	"Answer whether the tail end of the receiver is the same as suffix.
	 The comparison is case-sensitive."

	| ofs |
	suffix size == 0
		ifTrue: [ ^ false ].
	(ofs := self size - suffix size) < 0
		ifTrue: [ ^ false ].
	^ self at: ofs + 1 equals: suffix	"
  'Elvis' endsWith: 'vis'
  'Elvis' endsWith: ''
"
%

category: 'gemstone-tonel'
method: CharacterCollection
findString: subString startingAt: startIndex caseSensitive: aBoolean

	^ self _findString: subString startingAt: startIndex ignoreCase: aBoolean not
%

category: 'gemstone-tonel'
method: CharacterCollection
join: aCollection
	"'*' join: #('WWWWW' 'W  EW' 'zzzz')
		->  'WWWWW*W  EW*zzzz' "
  | res |
  res := self class new .
  aCollection do:[:each | res addAll: each asString ] 
			 separatedBy:[ res addAll: self ] .
  ^ res
%

category: 'gemstone-tonel'
method: CharacterCollection
lineIndicesDo: aBlock
	"execute aBlock with 3 arguments for each line:
	- start index of line
	- end index of line without line delimiter
	- end index of line including line delimiter(s) CR, LF or CRLF"
	
	| cr lf start sz nextLF nextCR |
	start := 1.
	sz := self size.
	cr := Character cr.
	nextCR := self indexOf: cr startingAt: 1.
	lf := Character lf.
	nextLF := self indexOf: lf startingAt: 1.
	[ start <= sz ] whileTrue: [
		(nextLF == 0 and: [ nextCR == 0 ])
			ifTrue: [ "No more CR, nor LF, the string is over"
					aBlock value: start value: sz value: sz.
					^self ].
		(nextCR == 0 or: [ 0 < nextLF and: [ nextLF < nextCR ] ])
			ifTrue: [ "Found a LF"
					aBlock value: start value: nextLF - 1 value: nextLF.
					start := 1 + nextLF.
					nextLF := self indexOf: lf startingAt: start ]
			ifFalse: [ 1 + nextCR == nextLF
				ifTrue: [ "Found a CR-LF pair"
					aBlock value: start value: nextCR - 1 value: nextLF.
					start := 1 + nextLF.
					nextCR := self indexOf: cr startingAt: start.
					nextLF := self indexOf: lf startingAt: start ]
				ifFalse: [ "Found a CR"
					aBlock value: start value: nextCR - 1 value: nextCR.
					start := 1 + nextCR.
					nextCR := self indexOf: cr startingAt: start ]]]
%

category: 'gemstone-tonel'
method: CharacterCollection
putOn: aStream

	^ aStream nextPutAll: self
%

category: 'gemstone-tonel'
method: CharacterCollection
substrings: separators
	"Answer an array containing the substrings in the receiver separated 
	by the elements of separators."
	| result subString ofs sz |
	
	(separators isString or: [ separators allSatisfy: [ :element | element isCharacter ] ])
		ifFalse: [ ^ self error: 'separators must be Characters.' ].
	ofs := 1 .
  sz := self size .
	result := { } .
	subString := String new .
	[ ofs > sz ] whileFalse: [
		| char |
		char := self at: ofs . ofs := ofs + 1 . 
		(separators includesValue: char)
			ifTrue: [
				subString size == 0 ifFalse: [
					result add: subString .
					subString := String new ] ]
			ifFalse: [
				subString add: char ] ].
	subString size == 0 ifFalse: [ result add: subString ].
	^ result 
%

category: 'gemstone-tonel'
method: CharacterCollection
substringsSpace
	"Answer an array containing the substrings in the receiver separated 
	by  Character space"
	| result ofs subStr sepChar sz |
  sepChar := $  "Character space".
	ofs := 1 .
  sz := self size .
	result := { } .
	subStr := String new .
	[ ofs > sz ] whileFalse: [
		| char |
		char := self at: ofs . ofs := ofs + 1 .
		char == sepChar 
			ifTrue: [
				subStr size == 0 ifFalse: [
					result add: subStr .
					subStr := String new ] ]
			ifFalse: [
				subStr add: char ] ].
	subStr size == 0 ifFalse: [ result add: subStr ].
	^ result 
%

category: 'gemstone-tonel'
method: CharacterCollection
trimBoth

	"Trim separators from both sides of the receiving string."
  | left right |
  left := 1 .
  right := self size .
  [ left <= right and:[ (self at: left) isSeparator ]] whileTrue:[ left := left + 1].
  left > right ifTrue:[ ^ self class new ].
  [ (self at: right) isSeparator ] whileTrue:[ right := right - 1].
	^ self copyFrom: left to: right .
%

category: 'gemstone-tonel'
method: CharacterCollection
trimBoth: aBlock

	"Trim characters satisfying the condition given in aBlock from both sides of the receiving string."

	^ self trimLeft: aBlock right: aBlock
%

category: 'gemstone-tonel'
method: CharacterCollection
trimLeft

	"Trim separators from the left side of the receiving string."
  | left right |
  left := 1 .
  right := self size .
  [ left <= right and:[ (self at: left) isSeparator ]] whileTrue:[ left := left + 1].
  left > right ifTrue:[ ^ self class new ].
	^ self copyFrom: left to: right .
%

category: 'gemstone-tonel'
method: CharacterCollection
trimLeft: aBlock

	"Trim characters satisfying the condition given in aBlock from the left side of the receiving string."

	^ self trimLeft: aBlock right: [ :char | false ]
%

category: 'gemstone-tonel'
method: CharacterCollection
trimLeft: aLeftBlock right: aRightBlock

	"Trim characters satisfying the condition given in aLeftBlock from the left side and aRightBlock from the right sides of the receiving string."

	| left right |
	left := 1.
	right := self size.
	[ left <= right and: [ aLeftBlock value: (self at: left) ] ]
		whileTrue: [ left := left + 1 ].
	[ left <= right and: [ aRightBlock value: (self at: right) ] ]
		whileTrue: [ right := right - 1 ].
	^ self copyFrom: left to: right
%

category: 'gemstone-tonel'
method: CharacterCollection
trimRight

	"Trim separators from the right side of the receiving string."
  | right |
  right := self size .
  [ right >= 1 and:[ (self at: right) isSeparator ]] whileTrue:[ right := right - 1].
  right == 0 ifTrue:[ ^ self class new ].
	^ self copyFrom: 1 to: right .
%

category: 'gemstone-tonel'
method: CharacterCollection
trimRight: aBlock

	"Trim characters satisfying the condition given in aBlock from the right side of the receiving string."

	^ self trimLeft: [ :char | false ] right: aBlock
%

category: 'gemstone-tonel'
method: CharacterCollection
withLineEndings: lineEndingString
	| stream |
	stream := nil.
	self
		lineIndicesDo: [ :start :endWithoutDelimiters :end | 
			(stream isNil and: [ endWithoutDelimiters ~= end ])
				ifTrue: [ 
					((self copyFrom: endWithoutDelimiters + 1 to: end)
						_unicodeEqual: lineEndingString)
						ifFalse: [ 
							stream := WriteStreamPortable with: self copy.
							stream position: start - 1 ] ].
			stream
				ifNotNil: [ 
					stream next: endWithoutDelimiters - start + 1 putAll: self startingAt: start.
					endWithoutDelimiters = end
						ifFalse: [ stream nextPutAll: lineEndingString ] ] ].
	^ stream
		ifNil: [ self ]
		ifNotNil: [ 
			stream position = self size
				ifTrue: [ stream collection ]
				ifFalse: [ stream contents ] ]
%

! Class extensions for 'Collection'

!		Instance methods for 'Collection'

category: 'gemstone-tonel'
method: Collection
asDictionary

  | dict |
  dict := Dictionary new.
  self do: [:assoc |
    dict add: assoc].
  ^ dict
%

category: 'gemstone-tonel'
method: Collection
flattened
	
	"Flattens a collection of collections (no matter how many levels of collections exist).
	Strings are considered atoms and, as such, won't be flattened
	
	Examples:
	#(1 #(2 3) #(4 (#5))) flattened returns #(1 2 3 4 5) 
	#('string1' #('string2' 'string3')) flattened returns #('string1' 'string2' 'string3')"
	
	"^ Array streamContents: [ :stream | self flattenOn: stream]."
  | a |
  a := Array new .
  self _flattendAppend: a .
  ^ a
%

category: 'gemstone-tonel'
method: Collection
flattenOn: aStream

	self do: [ :each | (each isCollection and: [each isString not]) 
						ifTrue: [each flattenOn: aStream]
						ifFalse: [aStream nextPut: each]].
%

category: 'gemstone-tonel'
method: Collection
ifNotEmpty: aBlock

	^ self size == 0
		ifFalse: [ aBlock cull: self ]
%

category: 'gemstone-tonel'
method: Collection
isCollection

	"Return true if the receiver is some sort of Collection and responds to basic collection messages such as #size and #do:"

	^ true
%

category: 'gemstone-tonel'
method: Collection
select: selectBlock thenDo: doBlock
  "Utility method to improve readability."

  ^ (self select: selectBlock) do: doBlock
%

category: 'gemstone-tonel'
method: Collection
sort

	"Sort this array into ascending order using the '<=' operator."

	^ self sort: [ :a :b | a <= b ]
%

category: 'gemstone-tonel'
method: Collection
sort: aSortBlock

	"Sort this array using aSortBlock. The block should take two arguments
	and return true if the first element should preceed the second one."

	^ self sortWithBlock: aSortBlock
%

category: 'gemstone-tonel'
method: Collection
_flattendAppend: anArray

	self do: [ :each | (each isCollection and: [each isString not]) 
						ifTrue: [each _flattendAppend: anArray]
						ifFalse: [anArray add: each]].
%

! Class extensions for 'GsFile'

!		Instance methods for 'GsFile'

category: 'gemstone-tonel'
method: GsFile
<< items

 	items putOn: self.
	
	^ self
%

category: 'gemstone-tonel'
method: GsFile
wrappedStreamName
	^ self pathName
%

! Class extensions for 'Object'

!		Instance methods for 'Object'

category: 'gemstone-tonel'
method: Object
isCharacter

	^ false
%

category: 'gemstone-tonel'
method: Object
isCollection

	"Return true if the receiver is some sort of Collection and responds to basic collection messages such as #size and #do:"

	^ false
%

category: 'gemstone-tonel'
method: Object
putOn: aStream

	^ aStream nextPut: self
%

! Class extensions for 'SequenceableCollection'

!		Instance methods for 'SequenceableCollection'

category: 'gemstone-tonel'
method: SequenceableCollection
allButLast

	"Answer a copy of the receiver containing all but the last
	element. Raise an error if there are not enough elements."

	^ self allButLast: 1
%

category: 'gemstone-tonel'
method: SequenceableCollection
allButLast: n

	"Answer a copy of the receiver containing all but the last n
	elements. Raise an error if there are not enough elements."

	^ self copyFrom: 1 to: self size - n
%

category: 'gemstone-tonel'
method: SequenceableCollection
beginsWith: aSequenceableCollection

	(aSequenceableCollection isEmpty
		or: [ self size < aSequenceableCollection size ])
		ifTrue: [ ^ false ].
	aSequenceableCollection
		withIndexDo: [ :each :index | 
			(self at: index) ~= each
				ifTrue: [ ^ false ] ].
	^ true
%

category: 'gemstone-tonel'
method: SequenceableCollection
fifth

	"Answer the fifth element of the receiver.
	Raise an error if there are not enough elements."

	^ self at: 5
%

category: 'gemstone-tonel'
method: SequenceableCollection
fourth

	"Answer the fourth element of the receiver.
	Raise an error if there are not enough elements."

	^ self at: 4
%

category: 'gemstone-tonel'
method: SequenceableCollection
pairsCollect: aBlock
	"Evaluate aBlock with my elements taken two at a time, and return an Array with the results"

	^ (1 to: self size // 2) collect:
		[:index | aBlock value: (self at: 2 * index - 1) value: (self at: 2 * index)]
"
#(1 'fred' 2 'charlie' 3 'elmer') pairsCollect:
	[:a :b | b, ' is number ', a printString]
"
%

category: 'gemstone-tonel'
method: SequenceableCollection
putOn: aStream

	self do: [ :each | each putOn: aStream ]
%

category: 'gemstone-tonel'
method: SequenceableCollection
sixth

	"Answer the sixth element of the receiver.
	Raise an error if there are not enough elements."

	^ self at: 6
%

category: 'gemstone-tonel'
method: SequenceableCollection
third

	"Answer the third element of the receiver.
	Raise an error if there are not enough elements."

	^ self at: 3
%

category: 'gemstone-tonel'
method: SequenceableCollection
withIndexDo: elementAndIndexBlock

	"Just like with:do: except that the iteration index supplies the second argument to the block."

	1 to: self size do: [ :index | elementAndIndexBlock value: (self at: index) value: index ]
%

category: 'gemstone-tonel'
method: SequenceableCollection
writeStreamPortable

	^ WriteStreamPortable on: self
%

! Class extensions for 'Stream'

!		Instance methods for 'Stream'

category: 'gemstone-tonel'
method: Stream
<< items

	items putOn: self
%

category: 'gemstone-tonel'
method: Stream
wrappedStreamName

	^''
%

