! Copyright (C) GemTalk Systems 1986-2025.  All Rights Reserved.
! Class Declarations
! Generated file, do not Edit

doit
(AbstractExternalSession
	subclass: 'GsTsExternalSession'
	instVarNames: #(tsSession socket gciErr callouts lib objInfoBuffers stoneSessionId gemProcessId parameters performArgs lastResult nbCallInProgress nbLoginSession stoneSessionSerial logger gemVersion)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesNonPersistent'  #logCreation )
)
		category: 'ExternalSessions';
		comment: 'GsTsExternalSession is an implementation of AbstractExternalSession that
uses the threads-safe GCI library, $GEMSTONE/lib/libgcits*.so, to
communicate to the Gem which is servicing an instance of GsTsExternalSession .

A loaded libgcits library is represented by an instance of GciTsLibrary, which
is a parameter to GsTsExternalSession.

While the target repository is often the same version of GemStone as the 
executing session, you may also login to repository running a different version
of GemStone. GciTsLibrary supports loading a libgcits library from a different 
version of GemStone; this requires cpp; you should have gcc/g++ installed.

Objects returned by remote session executions can be any type of object. 
 - It is recommended to return specials if possible. 
 - Return values that are kinds of strings are automatically converted to 
   a string in the local session. 
 - Other kinds of byte objects are returned as ByteArrays and may need manual 
   conversion.
 - All other objects are returned as a 3-element Array containing the OOP of 
   the result, the OOP of the class of the result, and the size of the result.

The oops of return values that are byte format, such as strings, are added to 
the remote session''s export set, but are automatically cleared (when the number 
of these reaches 100).  The oops of non-special, non-byte format objects must 
be manually removed from the remote session''s export set using releaseOop: or 
releaseOops:, if the remote session has memory pressure. 

GsTsExternalSession is not supported on AIX.

instVar notes:
  nbCallInProgress values 
    0 no call ,
    1 nbLogin in progress
    2 execution in progress 
    3 execution in progress for getting error details

  objInfoBuffers  is a three element array , 
      CByteArray   sizeof(GciTsObjInfo)
      CByteArray  of intVar values 
      Array of oops to release

Example:
| sess |
sess := GsTsExternalSession newDefault .
sess username: ''DataCurator''; password: ''swordfish'' ; login .
sess executeString: ''System stoneName''.
sess executeBlock: [2 + 5].
sess logout.

Example loading a different GciTsLibrary version:
| param sess |
param := GemStoneParameters new
  gemStoneName: ''gemstone353'';
  username: ''DataCurator'';
  password: ''swordfish'';
  gemService: ''!#netldi:ldi_353!gemnetobject'';
  yourself.
sess := GsTsExternalSession parameters: param
  library: (GciTsLibrary
     newForVersion: ''3.5.3''
     product: ''/lark/users/gsadmin/GemStone64_353'').
sess login.
sess executeString: ''System stoneName''.
sess logout.

Example using a non-blocking login and execute:
| sess result |
sess := GsTsExternalSession newDefault .
sess username: ''DataCurator''; password: ''swordfish'' ; nbLogin .
sess waitForReadReady.
sess nbLoginFinished. 
sess nbExecute: ''2 + 5''.
sess nbResult.
sess logout.
';
		immediateInvariant.
true.
%

removeallmethods GsTsExternalSession
removeallclassmethods GsTsExternalSession

doit
(Array
	subclass: 'BlockSorter'
	instVarNames: #(sortBlock sortNodes)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'System-Utilities';
		comment: 'BlockSorter is a concrete class that along with the class SortBlockNode implements the 
 behavior used to sort collections efficiently. It is an interface to an algorithm based 
 on an efficient merge-sort.  

 To use BlockSorter explicitly outside of the indexing subsystem, 
 the recommended way is to send  sortWithBlock:  or  sortWithBlock:persistentRoot:
 to a kind of Collection .

Constraints:
	sortBlock: Object
	sortNodes: Array';
		immediateInvariant.
true.
%

removeallmethods BlockSorter
removeallclassmethods BlockSorter

doit
(Array
	subclass: 'BtreePlusNode'
	instVarNames: #(rootNode numElements)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-Node';
		comment: 'BtreePlusNode is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

removeallmethods BtreePlusNode
removeallclassmethods BtreePlusNode

doit
(BtreePlusNode
	subclass: 'BtreePlusInteriorNode'
	instVarNames: #(lastValue lastRoot)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-Node';
		comment: 'BtreePlusInteriorNode is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

removeallmethods BtreePlusInteriorNode
removeallclassmethods BtreePlusInteriorNode

doit
(BtreePlusInteriorNode
	subclass: 'BtreePlusInteriorKeyValueNode'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-Node';
		comment: 'BtreePlusInteriorKeyValueNode is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

removeallmethods BtreePlusInteriorKeyValueNode
removeallclassmethods BtreePlusInteriorKeyValueNode

doit
(BtreePlusInteriorNode
	subclass: 'BtreePlusInteriorKeyValueRootObjectNode'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-Node';
		comment: 'BtreePlusInteriorKeyValueRootObjectNode is part of the Indexing and Querying subsystem. 
It implements GemStone internals and is not intended for customer use, by creating instances 
or by subclassing.';
		immediateInvariant.
true.
%

removeallmethods BtreePlusInteriorKeyValueRootObjectNode
removeallclassmethods BtreePlusInteriorKeyValueRootObjectNode

doit
(BtreePlusNode
	subclass: 'BtreePlusLeafNode'
	instVarNames: #(previousLeaf nextLeaf)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-Node';
		comment: 'BtreePlusLeafNode is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

removeallmethods BtreePlusLeafNode
removeallclassmethods BtreePlusLeafNode

doit
(BtreePlusLeafNode
	subclass: 'BtreePlusLeafKeyNode'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-Node';
		comment: 'BtreePlusLeafKeyNode is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

removeallmethods BtreePlusLeafKeyNode
removeallclassmethods BtreePlusLeafKeyNode

doit
(BtreePlusLeafNode
	subclass: 'BtreePlusLeafKeyValueNode'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-Node';
		comment: 'BtreePlusLeafKeyValueNode is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

removeallmethods BtreePlusLeafKeyValueNode
removeallclassmethods BtreePlusLeafKeyValueNode

doit
(BtreePlusLeafNode
	subclass: 'BtreePlusLeafKeyValueRootObjectNode'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-Node';
		comment: 'BtreePlusLeafKeyValueRootObjectNode is part of the Indexing and Querying subsystem. 
It implements GemStone internals and is not intended for customer use, by creating instances 
or by subclassing.';
		immediateInvariant.
true.
%

removeallmethods BtreePlusLeafKeyValueRootObjectNode
removeallclassmethods BtreePlusLeafKeyValueRootObjectNode

doit
(Array
	subclass: 'GsAbstractIndex'
	instVarNames: #(nscRoot btreeRoot options isComplete progress comparisonForSort)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-Index';
		comment: 'GsAbstractIndex is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

removeallmethods GsAbstractIndex
removeallclassmethods GsAbstractIndex

doit
(GsAbstractIndex
	subclass: 'GsIdentityIndex'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-Index';
		comment: 'GsIdentityIndex is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

removeallmethods GsIdentityIndex
removeallclassmethods GsIdentityIndex

doit
(GsAbstractIndex
	subclass: 'GsRangeEqualityIndex'
	instVarNames: #(lastElementClass optimizingComparison)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-Index';
		comment: 'GsRangeEqualityIndex is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

removeallmethods GsRangeEqualityIndex
removeallclassmethods GsRangeEqualityIndex

doit
(GsRangeEqualityIndex
	subclass: 'GsConstrainedCharacterCollectionIndex'
	instVarNames: #(collator constraintType)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-Index';
		comment: 'GsConstrainedCharacterCollectionIndex is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

removeallmethods GsConstrainedCharacterCollectionIndex
removeallclassmethods GsConstrainedCharacterCollectionIndex

doit
(GsConstrainedCharacterCollectionIndex
	subclass: 'GsUnicodeRangeEqualityIndex'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-Index';
		comment: 'GsUnicodeRangeEqualityIndex is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

removeallmethods GsUnicodeRangeEqualityIndex
removeallclassmethods GsUnicodeRangeEqualityIndex

doit
(Array
	subclass: 'GsPathTerm'
	instVarNames: #(name offset securityPolicies children updateBtree needsDepList requirePathTerms termsRequired nilOnPath)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-PathTerm';
		comment: 'GsPathTerm is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

removeallmethods GsPathTerm
removeallclassmethods GsPathTerm

doit
(GsPathTerm
	subclass: 'GsCollectionBasedPathTerm'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-PathTerm';
		comment: 'GsCollectionBasedPathTerm is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

removeallmethods GsCollectionBasedPathTerm
removeallclassmethods GsCollectionBasedPathTerm

doit
(GsCollectionBasedPathTerm
	subclass: 'GsEnumeratedPathTerm'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-PathTerm';
		comment: 'GsEnumeratedPathTerm is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

removeallmethods GsEnumeratedPathTerm
removeallclassmethods GsEnumeratedPathTerm

doit
(GsCollectionBasedPathTerm
	subclass: 'GsSetValuedPathTerm'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-PathTerm';
		comment: 'GsSetValuedPathTerm is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

removeallmethods GsSetValuedPathTerm
removeallclassmethods GsSetValuedPathTerm

doit
(GsPathTerm
	subclass: 'GsOptionalPathTerm'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-PathTerm';
		comment: 'GsOptionalPathTerm is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

removeallmethods GsOptionalPathTerm
removeallclassmethods GsOptionalPathTerm

doit
(GsPathTerm
	subclass: 'GsSelectorPathTerm'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-PathTerm';
		comment: 'GsSelectorPathTerm  is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

removeallmethods GsSelectorPathTerm
removeallclassmethods GsSelectorPathTerm

doit
(Array
	subclass: 'GsSingleRefPathResult'
	instVarNames: #(searchOop isDead)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Repository';
		comment: 'GsSingleRefPathResult is used to represent the results of a reference path scan.
It is a subclass of Array and contains the following instance variables:

searchOop - the object for which the reference path was found.

isDead - a Boolean indicating if the search object was found to be dead
(disconnected from the repository).

The first elment of a GsSingleRefPathResult will be the limit object at the top
of the reference path.  The last element will be searchOop.  The other elements
represent intermediate objects which are traversered to go from the limit object
to the search object.';
		immediateInvariant.
true.
%

removeallmethods GsSingleRefPathResult
removeallclassmethods GsSingleRefPathResult

doit
(Association
	subclass: 'GsAbstractReferenceAssociation'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'The abstract class GsAbstractReferenceAssociation represents the value of an operand in a GsAbstractQueryPredicate.';
		immediateInvariant.
true.
%

removeallmethods GsAbstractReferenceAssociation
removeallclassmethods GsAbstractReferenceAssociation

doit
(GsAbstractReferenceAssociation
	subclass: 'GsConstantReferenceAssociation'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'The class GsConstantReferenceAssociation represents the value of a literal operand in a GsAbstractQueryPredicate.';
		immediateInvariant.
true.
%

removeallmethods GsConstantReferenceAssociation
removeallclassmethods GsConstantReferenceAssociation

doit
(GsAbstractReferenceAssociation
	subclass: 'GsQueryPathReferenceAssociation'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'The class GsQueryPathReferenceAssociation represents the value of a path operand in a GsAbstractQueryPredicate.';
		immediateInvariant.
true.
%

removeallmethods GsQueryPathReferenceAssociation
removeallclassmethods GsQueryPathReferenceAssociation

doit
(GsAbstractReferenceAssociation
	subclass: 'GsVariableReferenceAssociation'
	instVarNames: #(bound)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'The class GsVariableReferenceAssociation  represents the value of a variable operand a GsAbstractQueryPredicate.';
		immediateInvariant.
true.
%

removeallmethods GsVariableReferenceAssociation
removeallclassmethods GsVariableReferenceAssociation

doit
(GsVariableReferenceAssociation
	subclass: 'GsPathReferenceAssociation'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'GsPathReferenceAssociation  is part of the Indexing and Querying subsystem. It implements GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods GsPathReferenceAssociation
removeallclassmethods GsPathReferenceAssociation

doit
(BtreeComparisonForCompare
	subclass: 'BtreeComparisonForIdentity'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-Comparison';
		comment: 'BtreeComparisonForIdentity is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.

During btree sort and compare operations (for BtreeNode and subclasses) the exact method
send for doing comparison operations varies depending upon whether the comparison is for 
a sort or a query (compare). The class translates the message into a variant for sorting.';
		immediateInvariant.
true.
%

removeallmethods BtreeComparisonForIdentity
removeallclassmethods BtreeComparisonForIdentity

doit
(BtreeComparisonForSort
	subclass: 'BtreeOptimizedComparison'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-Comparison';
		comment: 'BtreeOptimizedComparison is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

removeallmethods BtreeOptimizedComparison
removeallclassmethods BtreeOptimizedComparison

doit
(BtreeComparisonForSort
	subclass: 'BtreeOptimizedUnicodeComparison'
	instVarNames: #(collator)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-Comparison';
		comment: 'BtreeOptimizedUnicodeComparison is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

removeallmethods BtreeOptimizedUnicodeComparison
removeallclassmethods BtreeOptimizedUnicodeComparison

doit
(BtreeQuerySpec
	subclass: 'BtreePlusComparisonQuerySpec'
	instVarNames: #(key opCode selector optimizingComparison)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-QuerySpec';
		comment: 'BtreePlusComparisonQuerySpec is an concrete class that implements behavior for handling the double
 dispatching of messages for adding objects from a btreePlusNode that satisfy a particular query
 based on a comparison of a single set of values.

 The implementation for this class and its concrete subclasses is tightly coupled to alogorithms
 implemented in primitives, so these classes should not be modified.';
		immediateInvariant.
true.
%

removeallmethods BtreePlusComparisonQuerySpec
removeallclassmethods BtreePlusComparisonQuerySpec

doit
(BtreePlusComparisonQuerySpec
	subclass: 'BtreePlusRangeComparisonQuerySpec'
	instVarNames: #(key2 opCode2 selector2)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-QuerySpec';
		comment: 'BtreePlusRangeComparisonQuerySpec is an concrete class that implements behavior for handling the double
 dispatching of messages for adding objects from a btreePlusNode that satisfy a particular query
 based on comparisons between two values.

 The implementation for this class and its concrete subclasses is tightly coupled to alogorithms
 implemented in primitives, so these classes should not be modified.';
		immediateInvariant.
true.
%

removeallmethods BtreePlusRangeComparisonQuerySpec
removeallclassmethods BtreePlusRangeComparisonQuerySpec

doit
(BtreePlusRangeComparisonQuerySpec
	subclass: 'BtreePlusUnicodeRangeComparisonQuerySpec'
	instVarNames: #(collator)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-QuerySpec';
		comment: 'BtreePlusUnicodeRangeComparisonQuerySpec is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods BtreePlusUnicodeRangeComparisonQuerySpec
removeallclassmethods BtreePlusUnicodeRangeComparisonQuerySpec

doit
(BtreePlusComparisonQuerySpec
	subclass: 'BtreePlusUnicodeComparisonQuerySpec'
	instVarNames: #(collator)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-QuerySpec';
		comment: 'BtreePlusUnicodeComparisonQuerySpec is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods BtreePlusUnicodeComparisonQuerySpec
removeallclassmethods BtreePlusUnicodeComparisonQuerySpec

doit
(CollectionBasedPathEvaluator
	subclass: 'EnumeratedPathEvaluator'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Evaluators';
		comment: 'EnumeratedPathEvaluator is part of the Indexing and Querying subsystem. It implements GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods EnumeratedPathEvaluator
removeallclassmethods EnumeratedPathEvaluator

doit
(EqualityIndexSpecification
	subclass: 'ConstrainedCharacterCollectionIndexSpecification'
	instVarNames: #(collator constraintType)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-Index';
		comment: 'ConstrainedCharacterCollectionIndexSpecification is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

removeallmethods ConstrainedCharacterCollectionIndexSpecification
removeallclassmethods ConstrainedCharacterCollectionIndexSpecification

doit
(EqualityIndexSpecification
	subclass: 'UnicodeIndexSpecification'
	instVarNames: #(collator)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'The class UnicodeIndexSpecification provides details for specifying an index that contains 
Unicode Strings. Since it contains Unicode Strings, it requires a persistent IcuCollator instance 
associated with the index.';
		immediateInvariant.
true.
%

removeallmethods UnicodeIndexSpecification
removeallclassmethods UnicodeIndexSpecification

doit
(Error
	subclass: 'ExitClientError'
	instVarNames: #(status)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Exceptions';
		comment: 'ExitClientError is a subclass of Error, 
signalled when the application wants topaz (or other Gci client) to exit the
client process with a specified exit status.  Not a fatal error ;
client process should call GciLogout before exiting.
A topaz -l that is interactive and configured with GEM_LISTEN_FOR_DEBUG=true
will treat ExitClientError as an error to be debugged, and will stop
without exiting.';
		immediateInvariant.
true.
%

removeallmethods ExitClientError
removeallclassmethods ExitClientError

doit
(Error
	subclass: 'GciError'
	instVarNames: #(gciErrSType externalSession originalNumber)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'ExternalSessions';
		comment: 'This class is part of the External Sessions implementation and 
represents an execution Error from the GCI interface to the external session.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
	gciErrSType: Object
	externalSession: Object
	originalNumber: Object
';
		immediateInvariant.
true.
%

removeallmethods GciError
removeallclassmethods GciError

doit
(Error
	subclass: 'GsMalformedQueryExpressionError'
	instVarNames: #(errorCondition)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'The class GsMalformedQueryExpressionError is signaled when an attempt is made to execute a malformed GsQueryFormula.';
		immediateInvariant.
true.
%

removeallmethods GsMalformedQueryExpressionError
removeallclassmethods GsMalformedQueryExpressionError

doit
(Error
	subclass: 'GsQueryExpectedImplicitIdentityIndexError'
	instVarNames: #(gsQuery)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing';
		comment: 'GsQueryExpectedImplicitIdentityIndexError is part of the Indexing and Querying subsystem.  
It is used where an implicit identity index that was a side-effect of legacy indexing does
not exist, since btreeplus indexes do not have that side-effect';
		immediateInvariant.
true.
%

removeallmethods GsQueryExpectedImplicitIdentityIndexError
removeallclassmethods GsQueryExpectedImplicitIdentityIndexError

doit
(Error
	subclass: 'GsQueryParseError'
	instVarNames: #(position)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing';
		comment: 'GsQueryParseError is a subclass of Error, signalled when the parsing of a GsQuery finds incorrect syntax';
		immediateInvariant.
true.
%

removeallmethods GsQueryParseError
removeallclassmethods GsQueryParseError

doit
(IdentityKeyValueDictionary
	subclass: 'BtreePlusTraversalMapDictionary'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-PathTerm';
		comment: 'BtreePlusTraversalMapDictionary is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.

Dictionary class for creating reverse lookup map for Btree Plus update operations.';
		immediateInvariant.
true.
%

removeallmethods BtreePlusTraversalMapDictionary
removeallclassmethods BtreePlusTraversalMapDictionary

doit
(Notification
	subclass: 'GsUnsatisfiableQueryNotification'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'The class GsUnsatisfiableQueryNotification is part of the Indexing and Querying subsystem. It implements GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods GsUnsatisfiableQueryNotification
removeallclassmethods GsUnsatisfiableQueryNotification

doit
(Notification
	subclass: 'LogRotateNotification'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Exceptions';
		comment: 'If enabled, LogRotateNotification is signalled asynchronously when a gem or topaz -l
process receives the SIGHUP signal.

It is the responsibility of the application to install a handler for LogRotateNotification,
and in that handler send #reopen to any instances of GsFile and GsLog that should have
log rotate behavior.

By default LogRotateNotification is not enabled. 
If enabled, it is not disabled by default after being signalled.';
		immediateInvariant.
true.
%

removeallmethods LogRotateNotification
removeallclassmethods LogRotateNotification

doit
(Object
	subclass: 'AbstractReferencingObjectPolicy'
	instVarNames: #(manager)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Canonicalization';
		comment: 'AbstractReferencingObjectPolicy is part of the Canonical Object 
Framework.  This class is the abstract superclass for policy classes 
that are used to do the referencing object cleanup (i.e., replacing the 
duplicate object with the canonical object). Subclasses should implement 
#''canonicalizeReferencesIn:''. See ReferencingObjectPolicy for the
default implementation.';
		immediateInvariant.
true.
%

removeallmethods AbstractReferencingObjectPolicy
removeallclassmethods AbstractReferencingObjectPolicy

doit
(AbstractReferencingObjectPolicy
	subclass: 'ReferencingObjectPolicy'
	instVarNames: #(referencingClassHistories)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Canonicalization';
		comment: 'ReferencingObjectPolicy is part of the Canonical Object Framework.  
This class is the default policy used to do the referencing object cleanup.
In order to support manager cleanup, referencing (or container) classes must be 
specified to this policy using #''addRefencingClass:''.';
		immediateInvariant.
true.
%

removeallmethods ReferencingObjectPolicy
removeallclassmethods ReferencingObjectPolicy

doit
(Object
	subclass: 'BtreePlusNodeAuditor'
	instVarNames: #(auditResultString)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-Node';
		comment: 'BtreePlusNodeAuditor is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

removeallmethods BtreePlusNodeAuditor
removeallclassmethods BtreePlusNodeAuditor

doit
(Object
	indexableSubclass: 'BtreePlusRoot'
	instVarNames: #(btreeRootNode indexObject)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-Node';
		comment: 'BtreePlusRoot is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

removeallmethods BtreePlusRoot
removeallclassmethods BtreePlusRoot

doit
(BtreePlusRoot
	subclass: 'RcBtreePlusRoot'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-Node';
		comment: 'RcBtreePlusRoot is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

removeallmethods RcBtreePlusRoot
removeallclassmethods RcBtreePlusRoot

doit
(Object
	subclass: 'BtreePlusRootObjectMap'
	instVarNames: #(roots traversalMap cumulativeFactor pivotObject pivotPathTerm)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-PathTerm';
		comment: 'BtreePlusRootObjectMap is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.

Dictionary class for creating reverse lookup map for Btree Plus update operations.';
		immediateInvariant.
true.
%

removeallmethods BtreePlusRootObjectMap
removeallclassmethods BtreePlusRootObjectMap

doit
(Object
	subclass: 'CanonicalObjectManager'
	instVarNames: #(referencingObjectPolicy registries sessionCacheStatOffset)
	classVars: #()
	classInstVars: #(default securityPolicy)
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Canonicalization';
		comment: 'The Canonical Object Framework provides an optional way to reduce
duplicate instances of equivalent objects in your application. To accomplish
this goal you register a class as being canonicalizable (#''createRegistryFor:'')
and then you can request a canonical object (#''canonicalObjectFor:''). 

To avoid commit conflicts, if a canonical object is not yet in the registry, the 
framework allows overlapping transactions to see different objects as the 
canonical one, but subsequent transactions will see one of the earlier ones.
To ensure that only one object is used, send #''ultimateCanonicalObjectFor:''
and be prepared to handle commit conflicts.

An alternate way to canonicalize objects is to provide a set of objects to the
manager and have it scan them for references to canonicalizable objects
(#''cleanupAll:''). This would typically be used with objects found using a
repository scan (Repository>>#''listReferencesToInstancesOfClasses:toDirectory:'').

Because some objects should not have references arbitrarily replaced (e.g., 
IdentitySets), the framework uses a pluggable policy to decide which
referencing objects can be modified. The default ReferencingObjectPolicy 
bases the decision on the referencing object class.

A special case of object cleanup is #''cleanupWriteSet'' that scans the write
set for the current transaction and replaces references as indicated by the
policy. Thus, a properly configured manager could do appropriate cleanup 
before a commit.

By default, the default instance of CanonicalObjectManager has world write 
permission so that canonical objects can be created by any session and shared.
You can modify this using CanonicalObjectManager class>>#securityPolicy:';
		immediateInvariant.
true.
%

removeallmethods CanonicalObjectManager
removeallclassmethods CanonicalObjectManager

doit
(Object
	subclass: 'CanonicalObjectPolicy'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Canonicalization';
		comment: 'CanonicalObjectPolicy is internal to the Canonical Object Framework.
It may be that in the future we will allow pluggable policies for some
canonicalization behavior.';
		immediateInvariant.
true.
%

removeallmethods CanonicalObjectPolicy
removeallclassmethods CanonicalObjectPolicy

doit
(Object
	subclass: 'CanonicalObjectRegistry'
	instVarNames: #(canonicalObjectPolicy manager potentialCanonicalObjects registry)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Canonicalization';
		comment: 'CanonicalObjectRegistry is internal to the Canonical Object Framework.
There may be one registry for each ClassHistory and it holds a collection 
(a KeyValueDictionary) of the ultimate canonical objects and a collection 
of potentialCanonicalObjects (an RcIdentityBag). If an equivalent object 
is not found in the registry, then the framework scans the potentials for
an equivalent object (which could have been added by any session). If
an equivalent object is found it is returned; otherwise the new object is
added to the potentials and returned.

At some time when conflicts are considered unlikely, one can send 
#''canonicalizePotentialCanonicalObjects'' to the CanonicalObjectManager 
and the potentials will be added to the registry (improving subsequent
lookup performance).';
		immediateInvariant.
true.
%

removeallmethods CanonicalObjectRegistry
removeallclassmethods CanonicalObjectRegistry

doit
(Object
	subclass: 'GciTsLibrary'
	instVarNames: #(version callouts calloutSigs cLibrary)
	classVars: #(Gemstone_GciTsLibrary_default)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'GCI-Support';
		comment: 'A GciTsLibrary represents a loaded CLibrary for FFI access to the
thread safe GCI functions in $GEMSTONE/include/gcits.hf. 
The CLibrary encapsulated by a GciTsLibrary is a loaded
  $GEMSTONE/lib/libgcits*.so  .

You can load a libgcits library from a different version of GemStone
to create a GsTsExternalSession that logs into to a stone that is 
runing a different version of GemStone. 
Use   GciTsLibrary class >> newForVersion:product: 
to load a different version of libgcits.  This method is relatively expensive 
(a second of CPU time to parse the other version $GEMSTONE/include/gcits.hf).
so you may want to cache the instance of GciTsLibrary in SessionTemps,
similar to the caching in   GciTsLibrary class >> newDefault .

Note that loading a libgcits library for a different version of GemStone 
requires the cpp; you will need gcc/g++ to be installed.';
		immediateInvariant.
true.
%

removeallmethods GciTsLibrary
removeallclassmethods GciTsLibrary

doit
(Object
	_newKernelSubclass:'GemStoneParameters'
	instVarNames: #(gemStoneName username password hostUsername hostPassword gemService)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 117505
)
		category: 'ExternalSessions';
		comment: 'GemStoneParameters is used by the class GciInterface.
Instances are used as arguments to the login methods in
GciInterface.

Constraints:
	gemStoneName: String  (the stone name)
	username: String
	password: String
	hostUsername: String
	hostPassword: String
	gemService: String';
		immediateInvariant.
true.
%

removeallmethods GemStoneParameters
removeallclassmethods GemStoneParameters

doit
(Object
	subclass: 'GsEventLog'
	instVarNames: #(entryArray newEntriesInvariant)
	classVars: #()
	classInstVars: #(CurrentLog)
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'System-EventLog';
		comment: 'Instances of GsEventLog hold collections of log entries, each representing an item recorded 
in a logical log file.  There is a shared, system-wide instance in the class instance variable. 
All users are allowed to add and remove entries from this log.  

The entries are stored in an instance of RcArray, allowing concurrent writes of log entries.  
Note that the order of elements is based on the order in which the commits occurred, 
while entry timestamps reflect the time at which the entry was created.

GsEventLog may hold both application (user) events and system events.  
User entires can be added in two ways: class convenience methods such as logError:, logInfo, etc., 
or by creating an instance of GsEventLogEntry and sending addToLog.  
System events should be added only by GemStone code (no events are added at this time).
To restrict modifying or removing events, execute GsEventLog entriesUnmodifiable.  
After this is executed, new entries to the log are made invariant and the standard delete methods 
will not delete them.  However, they are not protected from delete using private delete protocol. 
System events are also protected from modification or delete, other than using private delete 
protocol.

Removing entries is subject to commit conflict, it is recommended to lock the event log prior to 
delete.';
		immediateInvariant.
true.
%

removeallmethods GsEventLog
removeallclassmethods GsEventLog

doit
(Object
	subclass: 'GsEventLogEntry'
	instVarNames: #(pid timestamp label priority object tag)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'System-EventLog';
		comment: 'GsEventLogEntry represents a single entry in a GsEventLog. Instances of GsEventLogEntry are user 
or application-specific events. 
By default, GsEventLogEntries are modifiable.  They can be made invariant in which case they are 
not deleted by default protocol.
It is supported to create custom subclasses with additional fields or different behavior.

GsEventLogEntries have the following fields:

 pid - SmallInteger, the processId of the session that created this entry
 timestamp - DateAndTime, the timestamp that this event was created.
 label - String, a string describing this entry
 priority - SmallInteger (required), the priority, see Class methods errorPrioity, warningPriority, etc.
 object - any object
 tag - any symbol';
		immediateInvariant.
true.
%

removeallmethods GsEventLogEntry
removeallclassmethods GsEventLogEntry

doit
(GsEventLogEntry
	subclass: 'GsEventLogSystemEntry'
	instVarNames: #(subsystem)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'System-EventLog';
		comment: 'GsEventLogSystemEntry represents a single, system-generated entry in a GsEventLog. 
Instances of GsEventLogSystemEntry should only be generated by GemStone code. 
They are not deleted from a GsEventLog using default protocol.
';
		immediateInvariant.
true.
%

removeallmethods GsEventLogSystemEntry
removeallclassmethods GsEventLogSystemEntry

doit
(Object
	subclass: 'GsIndexedQueryEvaluator'
	instVarNames: #(index doBlock)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-Evaluator';
		comment: 'GsIndexedQueryEvaluator is an abstract class that implements the behavior used to 
 evaluate queries against UnordedCollections that have been indexed. This class is
 used in the internal implementation of indexing and should not be modified.';
		immediateInvariant.
true.
%

removeallmethods GsIndexedQueryEvaluator
removeallclassmethods GsIndexedQueryEvaluator

doit
(GsIndexedQueryEvaluator
	subclass: 'GsEqualityIndexQueryEvaluator'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-Evaluator';
		comment: 'GsEqualityIndexQueryEvaluator is a concrete class that implements the behavior used to 
 evaluate queries against UnordedCollections that have equality indexes. This class is
 used in the internal implementation of indexing and should not be modified.';
		immediateInvariant.
true.
%

removeallmethods GsEqualityIndexQueryEvaluator
removeallclassmethods GsEqualityIndexQueryEvaluator

doit
(GsIndexedQueryEvaluator
	subclass: 'GsIdentityIndexQueryEvaluator'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-Evaluator';
		comment: 'GsIdentityIndexQueryEvaluator is a concrete class that implements the behavior used to 
 evaluate queries against UnordedCollections that have identity indexes. This class is
 used in the internal implementation of indexing and should not be modified.';
		immediateInvariant.
true.
%

removeallmethods GsIdentityIndexQueryEvaluator
removeallclassmethods GsIdentityIndexQueryEvaluator

doit
(Object
	subclass: 'GsIndexSpec'
	instVarNames: #(specs defaultOptions)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'GsIndexSpec defines the specification used to create one or more indexes on a collection.  Instance protocol for GsIndexSpec includes methods to create particular kinds of indexes with specific features.  

Once the indexes are defined in the GsIndexSpec, the indexes can be created on a particular collection.  
Printing a GsIndexSpec outputs a string that can be used to recreate the same set of indexes and features.

Instance Variables
  specs -- Array of specifications for individual indexes
  defaultOptions -- instance of GsIndexOptions';
		immediateInvariant.
true.
%

removeallmethods GsIndexSpec
removeallclassmethods GsIndexSpec

doit
(Object
	subclass: 'GsNetworkResourceString'
	instVarNames: #(protocol node authorization encrypted netldi dir log resource body)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'ExternalSessions';
		comment: 'This class is part of the External Sessions implementation and 
represents a Network Resource String (NRS). It is typically used 
to construct an NRS from parts, helping ensure correct syntax.

Class methods provide a variety of "sample" ways to create instances.
Instance methods provide getters and setters for the various NRS attributes,
as well as formatting methods for providing a valid string representation.
';
		immediateInvariant.
true.
%

removeallmethods GsNetworkResourceString
removeallclassmethods GsNetworkResourceString

doit
(Object
	subclass: 'GsOptions'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'The class GsOptions is part of the Indexing and Querying subsystem.  It is an abstract superclass for GsQueryOptions and GsIndexOptions, providing behavior for merging and subtracting between instances. ';
		immediateInvariant.
true.
%

removeallmethods GsOptions
removeallclassmethods GsOptions

doit
(GsOptions
	subclass: 'GsIndexOptions'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'The class GsIndexOptions is part of the Indexing and Querying subsystem.  This class encapsulates the optional refinements that may be used when creating a particular index on a collection.  Each GsIndexSpec has an instance of GsIndexOptions, either the default one or an instance that is created and included in the GsIndexSpec specification method.

GsIndexOptions are stored in dynamic instance variables for ease of migration; all are false by default:
   reducedConflict
   optionalPathTerms
';
		immediateInvariant.
true.
%

removeallmethods GsIndexOptions
removeallclassmethods GsIndexOptions

doit
(GsOptions
	subclass: 'GsQueryOptions'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'The class GsQueryOptions is part of the Indexing and Querying subsystem.  This class encapsulates the optional refinements that may be used when creating a particular query.  Each GsQuery has an associated instance of GsQueryOptions, either the default one or an instance that is created and included in the GsQuery specification method.

GsQueryOptions are stored in dynamic instance variables for ease of migration.  The following are false by default:
   cacheQueryResult
   optionalPathTerms
The following apply to optimization of queries and are true by default:
   applyDeMorgansLaws
   autoOptimize
   consolidateEnumerablePredicates
   consolidateRangePredicates
   consolidateUnaryConstantPredicates
   normalizePredicates
   removeRedundantPredicates
   reorderPredicates
   transformCommonPaths
';
		immediateInvariant.
true.
%

removeallmethods GsQueryOptions
removeallclassmethods GsQueryOptions

doit
(Object
	subclass: 'GsQuery'
	instVarNames: #(nsc formula originalFormula queryOptions queryResult collator)
	classVars: #(DefaultOptimizerClass DefaultQueryOptions)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'GsQuery is an abstraction of a query and conceptually of the query results.  

An instance of GsQuery is created based on:
  -- a string following query syntax,
  -- from a select block as used in the legacy indexing system, or
  --  from a formula output from another queery.  
This GsQuery must be bound to a collection, and any variables resolved, before it can be used as a query.  

Once it is fully bound, it can be treated as a collection of the results.  
However, note that operations will execute the query.';
		immediateInvariant.
true.
%

removeallmethods GsQuery
removeallclassmethods GsQuery

doit
(Object
	subclass: 'GsQueryFormula'
	instVarNames: #(nsc collator pathTermsRequired)
	classVars: #(ComparisonSelectorMap InverseOperatorMap NegatedOperatorMap)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'The abstract class GsQueryFormula represents a formula in a GsQuery. A formula is composed of one or more predicates (instance of GsAbstractQueryPredicate).';
		immediateInvariant.
true.
%

removeallmethods GsQueryFormula
removeallclassmethods GsQueryFormula

doit
(GsQueryFormula
	subclass: 'GsAbstractQueryPredicate'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'The abstract class GsAbstractQueryPredicate is a predicate in a GsQueryFormula. A predicate is a boolean expression composed of two operands and an operator (GsQueryPredicate) or three operands and two operators (GsRangeQueryPredicate).

An operand may be a literal (instance of GsConstantReferenceAssociation), a variable (instance of GsVariableReferenceAssociation) or a path (instance of a GsQueryPathReferenceAssociation). 

A path operand is expected to be an instance of a GsQueryPathReferenceAssociation.
An operator may be one of the standard comparison operators: < > = == <= >= ~= ~~.';
		immediateInvariant.
true.
%

removeallmethods GsAbstractQueryPredicate
removeallclassmethods GsAbstractQueryPredicate

doit
(GsAbstractQueryPredicate
	subclass: 'GsQueryPredicate'
	instVarNames: #(operand1 evaluator1 operator operand2)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'The abstract class GsQueryPredicate is a predicate in a GsQueryFormula. This class applies an operator to two operands.

Operands may be a literal (instance of GsConstantReferenceAssociation), a variable (instance of GsVariableReferenceAssociation), or a path (instance of a GsQueryPathReferenceAssociation).

An operator may be one of the following: < > = == <= >= ~= ~~.';
		immediateInvariant.
true.
%

removeallmethods GsQueryPredicate
removeallclassmethods GsQueryPredicate

doit
(GsQueryPredicate
	subclass: 'GsConstantConstantPredicate'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'The class GsConstantConstantPredicate is a predicate in a GsQueryFormula. This class is a concrete subclass of GsQueryPredicate and applies an operator to two constant operands. 

A constant operand may be a literal (instance of GsConstantReferenceAssociation) or a variable (instance of GsVariableReferenceAssociation).

An operator may be one of the following: < > = == <= >= ~= ~~.';
		immediateInvariant.
true.
%

removeallmethods GsConstantConstantPredicate
removeallclassmethods GsConstantConstantPredicate

doit
(GsQueryPredicate
	subclass: 'GsConstantPathPredicate'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'The class GsConstantPathPredicate is a predicate in a GsQueryFormula. This class is a concrete subclass of GsQueryPredicate and applies an operator to a constant operand and a path operand. 

A constant operand may be a literal (instance of GsConstantReferenceAssociation) or a variable (instance of GsVariableReferenceAssociation). 

A path operand is expected to be an instance of a GsQueryPathReferenceAssociation.

An operator may be one of the following: < > = == <= >= ~= ~~.';
		immediateInvariant.
true.
%

removeallmethods GsConstantPathPredicate
removeallclassmethods GsConstantPathPredicate

doit
(GsQueryPredicate
	subclass: 'GsPathConstantPredicate'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'The class GsPathConstantPredicate is a predicate in a GsQueryFormula. This class is a concrete subclass of GsQueryPredicate and applies an operator to a path operand and a constant operand. 

A constant operand may be a literal (instance of GsConstantReferenceAssociation) or a variable (instance of GsVariableReferenceAssociation). 

A path operand is expected to be an instance of a GsQueryPathReferenceAssociation.

An operator may be one of the following: < > = == <= >= ~= ~~.';
		immediateInvariant.
true.
%

removeallmethods GsPathConstantPredicate
removeallclassmethods GsPathConstantPredicate

doit
(GsPathConstantPredicate
	subclass: 'GsPreparedPathConstantPredicate'
	instVarNames: #(cachedClasses cachedOffsets preparedOperator preparedConstant preparedEvaluator preparedEvaluatorSize)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-Query';
		comment: 'GsPreparedPathConstantPredicate is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

removeallmethods GsPreparedPathConstantPredicate
removeallclassmethods GsPreparedPathConstantPredicate

doit
(GsQueryPredicate
	subclass: 'GsPathPathPredicate'
	instVarNames: #(evaluator2)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'The class GsPathPathPredicate is a predicate in a GsQueryFormula. This class is a concrete subclass of GsQueryPredicate and applies an operator to two path operands. 

A path operand is expected to be an instance of a GsQueryPathReferenceAssociation.

An operator may be one of the following: < > = == <= >= ~= ~~.';
		immediateInvariant.
true.
%

removeallmethods GsPathPathPredicate
removeallclassmethods GsPathPathPredicate

doit
(GsAbstractQueryPredicate
	subclass: 'GsRangeQueryPredicate'
	instVarNames: #(operand1 operator1 path operator2 operand2 evaluator)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'The class GsRangeQueryPredicate is a predicate in a GsQueryFormula. This class is a concrete subclass of GsAbstractQueryPredicate and applies two operators, two constant operands and a path operand.

The constant operands may be a literal (instance of GsConstantReferenceAssociation) or a variable (instance of GsVariableReferenceAssociation).

The path operand is expected to be an instance of a GsQueryPathReferenceAssociation.

Each operator may be one of the range comparison operators: < > <= >=. To qualify as a normalized GsRangeQueryPredicate, if one of the operators is < or <= then the other operator must also be  < or <=, alternately, if one of the operators is > or >= then the other operator must also be  > or >=. ';
		immediateInvariant.
true.
%

removeallmethods GsRangeQueryPredicate
removeallclassmethods GsRangeQueryPredicate

doit
(GsRangeQueryPredicate
	subclass: 'GsPreparedRangeQueryPredicate'
	instVarNames: #(cachedClasses cachedOffsets preparedOperator1 preparedConstant1 preparedOperator2 preparedConstant2 preparedEvaluator preparedEvaluatorSize)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-Query';
		comment: 'GsPreparedRangeQueryPredicate is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

removeallmethods GsPreparedRangeQueryPredicate
removeallclassmethods GsPreparedRangeQueryPredicate

doit
(GsQueryFormula
	subclass: 'GsCompoundClause'
	instVarNames: #(clause1 operator clause2)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'The class GsCompoundClause is a predicate in a GsQueryFormula. This class applies an operator to two clauses or predicates. Each clause or predicate is expected to be a subclass of GsQueryFormula.

An operator may be one of the following: & |.';
		immediateInvariant.
true.
%

removeallmethods GsCompoundClause
removeallclassmethods GsCompoundClause

doit
(GsQueryFormula
	subclass: 'GsUnaryClause'
	instVarNames: #(clause operator)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'The class GsUnaryClause is a predicate in a GsQueryFormula. This class applies the unary operator #not to a clause or a predicate. Each clause or predicate is expected to be a subclass of GsQueryFormula.';
		immediateInvariant.
true.
%

removeallmethods GsUnaryClause
removeallclassmethods GsUnaryClause

doit
(Object
	subclass: 'GsQueryFormulaVisitor'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'GsQueryFormulaVisitor is part of the Indexing and Querying subsystem. It implements GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods GsQueryFormulaVisitor
removeallclassmethods GsQueryFormulaVisitor

doit
(GsQueryFormulaVisitor
	subclass: 'GsAbstractQueryOptimizer'
	instVarNames: #(formula nsc queryOptions)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'GsAbstractQueryOptimizer is part of the Indexing and Querying subsystem. It implements GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods GsAbstractQueryOptimizer
removeallclassmethods GsAbstractQueryOptimizer

doit
(GsAbstractQueryOptimizer
	subclass: 'GsClassicQueryBlockOptimizer'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'GsClassicQueryBlockOptimizer is part of the Indexing and Querying subsystem. It implements GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods GsClassicQueryBlockOptimizer
removeallclassmethods GsClassicQueryBlockOptimizer

doit
(GsClassicQueryBlockOptimizer
	subclass: 'Gs32Optimizer'
	instVarNames: #(transformed)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'Gs32Optimizer is part of the Indexing and Querying subsystem. It implements GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods Gs32Optimizer
removeallclassmethods Gs32Optimizer

doit
(GsAbstractQueryOptimizer
	subclass: 'GsClauseOptimizer'
	instVarNames: #(predicates)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'GsClauseOptimizer is part of the Indexing and Querying subsystem. It implements GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods GsClauseOptimizer
removeallclassmethods GsClauseOptimizer

doit
(GsClauseOptimizer
	subclass: 'Gs32DisjunctiveClauseOptimizer'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'Gs32DisjunctiveClauseOptimizer is part of the Indexing and Querying subsystem. It implements GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods Gs32DisjunctiveClauseOptimizer
removeallclassmethods Gs32DisjunctiveClauseOptimizer

doit
(GsClauseOptimizer
	subclass: 'Gs32UnaryConstantPredicateOptimizer'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'Gs32UnaryConstantPredicateOptimizer is part of the Indexing and Querying subsystem. It implements GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods Gs32UnaryConstantPredicateOptimizer
removeallclassmethods Gs32UnaryConstantPredicateOptimizer

doit
(GsClauseOptimizer
	subclass: 'GsClassicConjunctiveClauseOptimizer'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'GsClassicConjunctiveClauseOptimizer is part of the Indexing and Querying subsystem. It implements GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods GsClassicConjunctiveClauseOptimizer
removeallclassmethods GsClassicConjunctiveClauseOptimizer

doit
(GsClauseOptimizer
	subclass: 'GsConjunctiveClauseConjoinSetChecker'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'GsConjunctiveClauseConjoinSetChecker is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods GsConjunctiveClauseConjoinSetChecker
removeallclassmethods GsConjunctiveClauseConjoinSetChecker

doit
(GsClauseOptimizer
	subclass: 'GsStreamableConjunctiveClauseChecker'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'GsStreamableConjunctiveClauseChecker is part of the Indexing and Querying subsystem. It implements GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods GsStreamableConjunctiveClauseChecker
removeallclassmethods GsStreamableConjunctiveClauseChecker

doit
(GsAbstractQueryOptimizer
	subclass: 'GsQueryConjoinSetChecker'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'GsQueryConjoinSetChecker is part of the Indexing and Querying subsystem. It implements GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods GsQueryConjoinSetChecker
removeallclassmethods GsQueryConjoinSetChecker

doit
(GsAbstractQueryOptimizer
	subclass: 'GsStreamableQueryChecker'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'GsStreamableQueryChecker is part of the Indexing and Querying subsystem. It implements GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods GsStreamableQueryChecker
removeallclassmethods GsStreamableQueryChecker

doit
(Object
	subclass: 'GsQueryLiteral'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'GsQueryLiteral is part of the Indexing and Querying subsystem. It implements GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods GsQueryLiteral
removeallclassmethods GsQueryLiteral

doit
(GsQueryLiteral
	subclass: 'GsQueryLiteralArray'
	instVarNames: #(isByteArray contents)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'GsQueryLiteralArray is part of the Indexing and Querying subsystem. It implements GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods GsQueryLiteralArray
removeallclassmethods GsQueryLiteralArray

doit
(GsQueryLiteral
	subclass: 'GsQueryLiteralValue'
	instVarNames: #(value)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'GsQueryLiteralValue is part of the Indexing and Querying subsystem. It implements GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods GsQueryLiteralValue
removeallclassmethods GsQueryLiteralValue

doit
(Object
	subclass: 'GsSingleRefPathFinder'
	instVarNames: #(searchObjects limitObjects allSearches numSearchesActive numPassesDone otScanDone printToLog scanStartTime opStartTime maxThreads lockWaitTime pageBufferSize percentCpuLimit maxLimitSetDescendantObjs maxLimitSetDescendantLevels)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Repository';
		comment: 'GsSingleRefPathFinder is a class used to determine how each object in a list
are connected to the repository.  It is typically used to determine why objects
expected to be collected by global garbage collection (markForCollection) were
not removed.  The list of objects connecting an object to the repository is
called a reference path.  An object may have more than one reference path,
however this class only determines one reference path for every search object.

Instance Variables:

searchObjects - a GsBitmap containing all objects for which reference paths will
be searched.

limitObjects - an array of GsBitmaps.  The first element contains the base limit
set of the search, that is, a group of objects known to be
connected to the repository.  The base limit set is returned by
the method SystemRepository buildLimitSetForRefPathScan.  The
next element in the array are the children of the based limit
set, and the next are the grandchildren, etc.

allSearches - anArray containing instances of GsSingleRefPathFinderForObject.  One
instance for each search object.

numSearchesActive - number of searches not yet completed.

otScanDone - Boolean indicating if the object table scan has been completed.
This is the first phase of the scan and only runs once.

printToLog - SmallInteger 
 0 no printing
 1  print start and end times 
 2  also print start and end times of each scan
 3  also print limit set details for each scan 

scanStartTime - A SmallInteger representing the timestamp of when the scan
started.

opStartTime - A SmallInteger - representing the timestamp of when an operation
started.  Used to print elapsed times to the log.

maxThreads - number of threads to use to perform the scan.

lockWaitTime - number of seconds to wait when acquiring the garbage collection
lock before starting the scan.

pageBufferSize - number of 16 KB pages each thread will buffer.  Must be a power
of 2.

percentCpuLimit - percentage of total system CPU which the scan may consume.

maxLimitSetDescendantObjs - maximum size of a generation of objects reachable
from the limit set.  At the beginning of the scan, the default limit set is
traversed until the size of the generation exceeds this value.  Default is
one million objects.

maxLimitSetDescendantLevels - maximum number of generations traversed to build
the limit set.  At the beginning of the scan, the default limit set is
traversed until the number of generations searched this value.  Default is 
unlimited.

Steps to find a reference path:

1) Create an instance with default settings:
| inst |
inst := GsSingleRefPathFinder newForSearchObjects: (Array with: mySearchObject)

2) Run the scan
inst runScan

3) Build the result objects (An Array of GsSingleRefPathResult objects)
inst buildResultObjects

The GsSingleRefPathResult object is the equivalent of the structured Array 
returned by findReferencePathToObj* methods in earlier releases.

4) For display, collect the results as strings:
<resultObjs> collect: [:e | e resultString]

For example:

| inst |
inst := GsSingleRefPathFinder newForSearchObjects: { myObj }.
inst runScan.
(inst buildResultObjects) 
   collect: [:e | e resultString]

Steps 2-4 can be done using inst scanAndReport. For example:

(GsSingleRefPathFinder newForSearchObjects: { myObj }) scanAndReport
';
		immediateInvariant.
true.
%

removeallmethods GsSingleRefPathFinder
removeallclassmethods GsSingleRefPathFinder

doit
(Object
	subclass: 'GsSingleRefPathFinderForObject'
	instVarNames: #(completed isDead refPathFinder limitOopsFound searchOopsUnion searchOop resultObject parentBitmaps)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Repository';
		comment: 'GsSingleRefPathFinderForObject holds the state of a reference path search for one
search object.  It has the following instance variables:

completed - A Boolean indicating if the search for searchOop has finished.
True if the reference path was found or if the object was
determined to be dead.

isDead - A Boolean indicating if the object is unreachable and eligible for
garbage collection.

refPathFinder - Reference to the instance of GsSingleRefPathFinder that created
this object.

limitOopsFound - a GsBitmap containing the objects in the limit set which can
be traversed to reach searchOop.

searchOopsUnion - a GsBitmap containing all objects already searched for in
this reference path scan.

searchOop - the object for which the reference path is to be found.

resultObject - an instance of GsSingleRefPathResult which contains the
reference path to searchOop.

parentBitmaps - an Array of GsBitmaps which contain ancestors of searchOop.
';
		immediateInvariant.
true.
%

removeallmethods GsSingleRefPathFinderForObject
removeallclassmethods GsSingleRefPathFinderForObject

doit
(Object
	subclass: 'JsonWebToken'
	instVarNames: #(header payload signature signedString)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Credentials';
		comment: 'This class is used to represent a JSON Web Token as defined in RFC 7519.
It has the following instance variables:

#header (SymbolDictionary)  - key/value pairs in the JWT header.
#payload (SymbolDictionary) - key/value pairs in the JWT payload.
#signature (ByteArray) - cryptographic signature for the receiver.
#signedString (String) - signed part of the JWT in base64url format.';
		immediateInvariant.
true.
%

removeallmethods JsonWebToken
removeallclassmethods JsonWebToken

doit
(Object
	subclass: 'PPCharSetPredicate'
	instVarNames: #(block classification)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Tools';
		comment: 'I am a predicate, allowing verificaiton if a character is included in the set of char that is described by the Block that this object is initialized with.
I work efficiently on characters for which the code point is between 1 and 255 using a lookup table.
For example,
  [[[
  charSetPredicate := PPCharSetPredicate on: [ :char | #($a $b $c) includes: char ].
  charSetPredicate value: $a. "true"
  charSetPredicate value: $z. "false"
  ]]]';
		immediateInvariant.
true.
%

removeallmethods PPCharSetPredicate
removeallclassmethods PPCharSetPredicate

doit
(Object
	subclass: 'PPContext'
	instVarNames: #(stream root properties globals furthestFailure)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Core';
		comment: 'A PPContext is provides contextual information to the parsing function.

Instance Variables
	globals:		<Dictionary>
	properties:		<Dictionary>
	root:		<PPParser>
	stream:		<PPStream>
	furthestFailure:	<PPFailure>

globals
	- properties that are not restored after backtracking

properties
	- properties that are restored after backtracking

root
	- the root parser

stream
	- input stream
';
		immediateInvariant.
true.
%

removeallmethods PPContext
removeallclassmethods PPContext

doit
(Object
	subclass: 'PPContextMemento'
	instVarNames: #(stream position properties)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Core';
		comment: 'I am an implementation of the memento design pattern.
My goal is to remember the state of a PPContext to eventually be able to restore its state later.
I should be instantiated using PPContext>>#remember method.
A PPContext can restore its state by providing the memento to PPContext>>#restore:.';
		immediateInvariant.
true.
%

removeallmethods PPContextMemento
removeallclassmethods PPContextMemento

doit
(Object
	subclass: 'PPFailure'
	instVarNames: #(message context position)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Core';
		comment: 'The failure object in PetitParser. It is the only class that responds to #isPetitFailure with true. It contains an error message and a position of the occurrence of the failure.

Instance Variables:
	message	<String>	The error message of this failure.
	position	<Integer>	The position of this failure in the input stream.
';
		immediateInvariant.
true.
%

removeallmethods PPFailure
removeallclassmethods PPFailure

doit
(Object
	subclass: 'PPForwardingParser'
	instVarNames: #(forwardee)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'Forwards (almost) all messages to its forwardee parser, making them for most purposes the same object.
This is used to simulate the one-way become that is used in other ports of PetitParser to resolve parsers.';
		immediateInvariant.
true.
%

removeallmethods PPForwardingParser
removeallclassmethods PPForwardingParser

doit
(Object
	subclass: 'PPMemento'
	instVarNames: #(result count context)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Core';
		comment: 'PPMemento is an internal class used by PPMemoizedParser to cache results and detect left-recursive calls.

Instance Variables:
	result	<Object>	The cached result.
	count	<Integer>	The number of recursive cycles followed.
	context	<PPContext>	The context of the cached result in the input stream.';
		immediateInvariant.
true.
%

removeallmethods PPMemento
removeallclassmethods PPMemento

doit
(Object
	subclass: 'PPParser'
	instVarNames: #(properties)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'An abstract parser for all parsers in PetitParser. Subclasses implement #parseOn: to perform 
the actual recursive-descent parsing. All parsers support a variety of methods to perform an 
actual parse, see the methods in the #parsing protocol. Parsers are combined with a series 
of operators that can be found in the #operations protocol.

Instance Variables:
	properties	<Dictionary>	Stores additional state in the parser object.

GemStone implementation notes:

CharacterCollection>>#asParser
	We have this instead of String>>#asParser
Collection>>#asParser
	We use #isKindOf: instead of #isCharacter
DoubleByteSymbol>>#asParser
	We added this
Interval>>#asParser
	We use #isKindOf: instead of #isCharacter
PositionableStream
	#peekTwice and #asPetitStream moved to PositionableStreamPortable
PositionableStreamPortable>>#collection
	We added as compatibility with PositionableStream in Pharo/Squeak
PPActionParser>>#setBlock:
	Modified to support Symbol as argument
PPCompositeParser>>#productionAt:ifAbsent:
	Remove #asString since we store instVarNames as symbols
PPForwardingParser
	We use this instead of #becomeForward: in PPParser>>#def:
PPLiteralObjectParser>>#caseInsensitive
	We use #isEquivalent: instead of #sameAs:
PPLiteralSequenceParser>>#caseInsensitive
	We use #isEquivalent: instead of #sameAs:
PPParser>>#def:
	Modified since we dont have #becomeForward:
PPParser>>#queryToken
	Added to support GsQueryTokenParser
PPRepeatingParser>>#initialize
	Modified to use #maximumValue instead of #maxValue
PPRepeatingParser>>#printOn:
	Modified to use #maximumValue instead of #maxValue
PPSequenceParser>>#permutation:
	Modified to use #_isInteger instead of #isInteger
PPStream
	Superclass changed to ReadStream Portable
PPStream>>#back and #peekBack
	Added to match Pharo/Squeak PositionableStream
PPStream>>#printOn:
	Modified to avoid non-Ascii character in source code
PPToken
	Remove NewLineParser from class variable (permissions and commit conflicts)
QuadByteSymbol>>#asParser
	Added
String>>#asParser
	Moved to CharacterCollection
Text>>#asPetitStream
	Not supported

PPParser>>#matchingRangesIn:do:
	Should change to match since no recognizable difference
';
		immediateInvariant.
true.
%

removeallmethods PPParser
removeallclassmethods PPParser

doit
(PPParser
	subclass: 'PPDelegateParser'
	instVarNames: #(parser)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'A parser that delegates to another parser.

Instance Variables:
	parser	<PPParser>	The parser to delegate to.';
		immediateInvariant.
true.
%

removeallmethods PPDelegateParser
removeallclassmethods PPDelegateParser

doit
(PPDelegateParser
	subclass: 'GsQueryErrorHandlingParser'
	instVarNames: #(errorMessage nestMessages)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Internals';
		comment: 'GsQueryErrorHandlingParser is part of the Indexing and Querying subsystem. It implements GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods GsQueryErrorHandlingParser
removeallclassmethods GsQueryErrorHandlingParser

doit
(PPDelegateParser
	subclass: 'PPActionParser'
	instVarNames: #(block)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'A parser that performs an action block with the successful parse result of the delegate.

Instance Variables:
	block	<BlockClosure>	The action block to be executed.
';
		immediateInvariant.
true.
%

removeallmethods PPActionParser
removeallclassmethods PPActionParser

doit
(PPActionParser
	subclass: 'PPWrappingParser'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'A parser that performs an action block upon activation with the stream and a continuation block.';
		immediateInvariant.
true.
%

removeallmethods PPWrappingParser
removeallclassmethods PPWrappingParser

doit
(PPDelegateParser
	subclass: 'PPAndParser'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'The and-predicate, a parser that succeeds whenever its delegate does, but does not consume the input stream [Parr 1994, 1995].';
		immediateInvariant.
true.
%

removeallmethods PPAndParser
removeallclassmethods PPAndParser

doit
(PPDelegateParser
	subclass: 'PPCompositeParser'
	instVarNames: #(dependencies)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Tools';
		comment: 'A PPCompositeParser is composed parser built from various primitive parsers. 

Every production in the receiver is specified as a method that returns its parser. Note that every production requires an instance variable of the same name, otherwise the production is not cached and cannot be used in recursive grammars. Productions should refer to each other by reading the respective inst-var. Note: these inst-vars are typically not written, as the assignment happens in the initialize method using reflection.

The start production is defined in the method start. It is aliased to the inst-var parser defined in the superclass of PPCompositeParser.';
		immediateInvariant.
true.
%

removeallmethods PPCompositeParser
removeallclassmethods PPCompositeParser

doit
(PPCompositeParser
	subclass: 'GsQueryGrammar'
	instVarNames: #(arrayItem arrayLiteral arrayLiteralArray binary byteLiteral byteLiteralArray char charLiteral charToken expression falseLiteral falseToken identifier identifierToken literal nilLiteral nilToken not notMessage notToken number numberLiteral numberToken parenExpression parenPredicate path pathToken predicateExpression predicateMessage primary primaryIdentifier rangePrimary rangePredicateExpression relop relopToken queryPath queryPathToken simplePredicateExpression string stringLiteral stringToken symbol symbolLiteral symbolLiteralArray trueLiteral trueToken variable)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'GsQueryGrammar is part of the Indexing and Querying subsystem. It implements GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods GsQueryGrammar
removeallclassmethods GsQueryGrammar

doit
(GsQueryGrammar
	subclass: 'GsQueryParser'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'GsQueryParser is part of the Indexing and Querying subsystem. It implements GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods GsQueryParser
removeallclassmethods GsQueryParser

doit
(PPDelegateParser
	subclass: 'PPConditionalParser'
	instVarNames: #(block)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'A PPConditionalParser is a delegate parser that evaluates a block and if that returns true, the delegate parser is invoked and its result returned. If the block evaluates to false, the PPFailure is returned.

The block accepts one argument, context.

E.g.
    (''a'' asParser if: [ :ctx | (ctx propertyAt: #myProperty) isNotNil ]) parse: ''a''';
		immediateInvariant.
true.
%

removeallmethods PPConditionalParser
removeallclassmethods PPConditionalParser

doit
(PPDelegateParser
	subclass: 'PPEndOfInputParser'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'A parser that succeeds only at the end of the input stream.';
		immediateInvariant.
true.
%

removeallmethods PPEndOfInputParser
removeallclassmethods PPEndOfInputParser

doit
(PPDelegateParser
	subclass: 'PPExpressionParser'
	instVarNames: #(operators)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Tools';
		comment: 'A PPExpressionParser is a parser to conveniently define an expression grammar with prefix, postfix, and left- and right-associative infix operators.

The following code initializes a parser for arithmetic expressions. First we instantiate an expression parser, a simple parser for expressions in parenthesis and a simple parser for integer numbers.

	expression := PPExpressionParser new.
	parens := $( asParser token trim , expression , $) asParser token trim 
		==> [ :nodes | nodes second ].
	integer := #digit asParser plus token trim
		==> [ :token | token value asInteger ].
	
Then we define on what term the expression grammar is built on:

	expression term: parens / integer.
	
Finally we define the operator-groups in descending precedence. Note, that the action blocks receive both, the terms and the parsed operator in the order they appear in the parsed input. 
	
	expression
		group: [ :g |
			g prefix: $- asParser token trim do: [ :op :a | a negated ] ];
		group: [ :g |
			g postfix: ''++'' asParser token trim do: [ :a :op | a + 1 ].
			g postfix: ''--'' asParser token trim do: [ :a :op | a - 1 ] ];
		group: [ :g |
			g right: $^ asParser token trim do: [ :a :op :b | a raisedTo: b ] ];
		group: [ :g |
			g left: $* asParser token trim do: [ :a :op :b | a * b ].
			g left: $/ asParser token trim do: [ :a :op :b | a / b ] ];
		group: [ :g |
			g left: $+ asParser token trim do: [ :a :op :b | a + b ].
			g left: $- asParser token trim do: [ :a :op :b | a - b ] ].
		
After evaluating the above code the ''expression'' is an efficient parser that evaluates examples like:

	expression parse: ''-8++''.
	expression parse: ''1+2*3''.
	expression parse: ''1*2+3''.
	expression parse: ''(1+2)*3''.
	expression parse: ''8/4/2''.
	expression parse: ''8/(4/2)''.
	expression parse: ''2^2^3''.
	expression parse: ''(2^2)^3''.
	
Instance Variables:
	operators	<Dictionary>	The operators defined in the current group.';
		immediateInvariant.
true.
%

removeallmethods PPExpressionParser
removeallclassmethods PPExpressionParser

doit
(PPDelegateParser
	subclass: 'PPFlattenParser'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'A parser that answers a flat copy of the range my delegate parses.';
		immediateInvariant.
true.
%

removeallmethods PPFlattenParser
removeallclassmethods PPFlattenParser

doit
(PPFlattenParser
	subclass: 'PPTokenParser'
	instVarNames: #(tokenClass)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'A parser that answers a token of the range my delegate parses.

Instance Variables:
	tokenClass	<PPToken class>	The token sub-class to be used.';
		immediateInvariant.
true.
%

removeallmethods PPTokenParser
removeallclassmethods PPTokenParser

doit
(PPTokenParser
	subclass: 'GsQueryTokenParser'
	instVarNames: #()
	classVars: #(SeparatorPredicate)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'GsQueryTokenParser is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods GsQueryTokenParser
removeallclassmethods GsQueryTokenParser

doit
(PPDelegateParser
	subclass: 'PPMemoizedParser'
	instVarNames: #(buffer identifier)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'A memoized parser, for refraining redundant computations.

Instance Variables:
	stream	<PositionableStream>	The stream of the associated memento objects.
	buffer	<Array of: PPMemento>	The buffer of memento objects.
';
		immediateInvariant.
true.
%

removeallmethods PPMemoizedParser
removeallclassmethods PPMemoizedParser

doit
(PPDelegateParser
	subclass: 'PPNotParser'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'The not-predicate, a parser that succeeds whenever its delegate does not, but consumes no input [Parr 1994, 1995].';
		immediateInvariant.
true.
%

removeallmethods PPNotParser
removeallclassmethods PPNotParser

doit
(PPDelegateParser
	subclass: 'PPOptionalParser'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'A parser that optionally parsers its delegate, or answers nil.';
		immediateInvariant.
true.
%

removeallmethods PPOptionalParser
removeallclassmethods PPOptionalParser

doit
(PPDelegateParser
	subclass: 'PPRepeatingParser'
	instVarNames: #(min max)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'An abstract parser that repeatedly parses between ''min'' and ''max'' instances of its delegate. The default configuration parses an infinite number of elements, as ''min'' is set to 0 and ''max'' to infinity (SmallInteger maxVal).

Instance Variables:
	min	<Integer>	The minimum number of repetitions.
	max	<Integer>	The maximum number of repetitions.';
		immediateInvariant.
true.
%

removeallmethods PPRepeatingParser
removeallclassmethods PPRepeatingParser

doit
(PPRepeatingParser
	subclass: 'PPLimitedRepeatingParser'
	instVarNames: #(limit)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'An abstract parser that repeatedly parses between ''min'' and ''max'' instances of my delegate and that requires the input to be completed with a specified parser ''limit''. Subclasses provide repeating behavior as typically seen in regular expression implementations (non-blind).

Instance Variables:
	limit	<PPParser>	The parser to complete the input with.';
		immediateInvariant.
true.
%

removeallmethods PPLimitedRepeatingParser
removeallclassmethods PPLimitedRepeatingParser

doit
(PPLimitedRepeatingParser
	subclass: 'PPGreedyRepeatingParser'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'A greedy repeating parser, commonly seen in regular expression implementations. It aggressively consumes as much input as possible and then backtracks to meet the ''limit'' condition.

This class essentially implements the iterative version of the following recursive parser composition:

	| parser |
	parser := PPChoiceParser new.
	parser setParsers: (Array
		with: (self , parser map: [ :each :rest | rest addFirst: each; yourself ])
		with: (limit and ==> [ :each | OrderedCollection new ])).
	^ parser ==> [ :rest | rest asArray ]';
		immediateInvariant.
true.
%

removeallmethods PPGreedyRepeatingParser
removeallclassmethods PPGreedyRepeatingParser

doit
(PPLimitedRepeatingParser
	subclass: 'PPLazyRepeatingParser'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'A lazy repeating parser, commonly seen in regular expression implementations. It limits its consumption to meet the ''limit'' condition as early as possible.

This class essentially implements the iterative version of the following recursive parser composition:

	| parser |
	parser := PPChoiceParser new.
	parser setParsers: (Array
		with: (limit and ==> [ :each | OrderedCollection new ])
		with: (self , parser map: [ :each :rest | rest addFirst: each; yourself ])).
	^ parser ==> [ :rest | rest asArray ]';
		immediateInvariant.
true.
%

removeallmethods PPLazyRepeatingParser
removeallclassmethods PPLazyRepeatingParser

doit
(PPRepeatingParser
	subclass: 'PPPossessiveRepeatingParser'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'The default repeating parser with standard PEG semantics (i.e. possessive, blind, eager).';
		immediateInvariant.
true.
%

removeallmethods PPPossessiveRepeatingParser
removeallclassmethods PPPossessiveRepeatingParser

doit
(PPDelegateParser
	subclass: 'PPTrimmingParser'
	instVarNames: #(trimmer)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'A parser that silently consumes spaces before and after the delegate parser.';
		immediateInvariant.
true.
%

removeallmethods PPTrimmingParser
removeallclassmethods PPTrimmingParser

doit
(PPParser
	subclass: 'PPEndOfFileParser'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'A PPEndOfFileParser is parser that will will return true if the stream position is at the end, returns failure otherwise.

The diffirenece between PPEndOfFIleParser and PPEndOfInputParser is:
 - PPEndOfFileParser can be created using #eof asParser
 - PPEndOfInputParser can be created by using parser end
 - PPEndOfFileParser does not delegate to any other parser
 - PPEndOfInputParser parsers its delegate and then decides if the input is at the end.

The PPEndOfFileParser can be used to accept some input only if it is at the end of the input, e.g:

   (''a'' asParser, #eof asParser) parse: ''a''
   (''a'' asParser, #eof asParser) parse: ''aa''
';
		immediateInvariant.
true.
%

removeallmethods PPEndOfFileParser
removeallclassmethods PPEndOfFileParser

doit
(PPParser
	subclass: 'PPEndOfLineParser'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'A PPEndOfLineParser is a parser that does not fail, if the stream position is at the end of a line. It does not consume anything.';
		immediateInvariant.
true.
%

removeallmethods PPEndOfLineParser
removeallclassmethods PPEndOfLineParser

doit
(PPParser
	subclass: 'PPEpsilonParser'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'A parser that consumes nothing and always succeeds.';
		immediateInvariant.
true.
%

removeallmethods PPEpsilonParser
removeallclassmethods PPEpsilonParser

doit
(PPParser
	subclass: 'PPFailingParser'
	instVarNames: #(message)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'A parser that consumes nothing and always fails.

Instance Variables:
	message <String>	The failure message.';
		immediateInvariant.
true.
%

removeallmethods PPFailingParser
removeallclassmethods PPFailingParser

doit
(PPParser
	subclass: 'PPListParser'
	instVarNames: #(parsers)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'Abstract parser that parses a list of things in some way (to be specified by the subclasses).

Instance Variables:
	parsers	<SequenceableCollection of: PPParser>	A sequence of other parsers to delegate to.';
		immediateInvariant.
true.
%

removeallmethods PPListParser
removeallclassmethods PPListParser

doit
(PPListParser
	subclass: 'PPChoiceParser'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'A parser that uses the first parser that succeeds.';
		immediateInvariant.
true.
%

removeallmethods PPChoiceParser
removeallclassmethods PPChoiceParser

doit
(PPChoiceParser
	subclass: 'PPLimitedChoiceParser'
	instVarNames: #(limit)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'A PPLimitedChoiceParser is similar to the choice parser except for the fact, that limit must pass if one of the choices passes. This is similar strategy as with the PPLimitedRepeatingParsers.

This way, one can implement choices that successfully parse this (if limit is filled with ''a''):

(''aa'' // ''a'') ''a'' parse: ''aa''

The limit can be automatically filled using elements from either follow or next set (see methods  PPParser>>followSets or PPParser>>nextSets).

Limit is by default epsilon and therefore it behaves as an ordinary ordered choice.

Instance Variables
	limit:		<Object>

limit
	- xxxxx
';
		immediateInvariant.
true.
%

removeallmethods PPLimitedChoiceParser
removeallclassmethods PPLimitedChoiceParser

doit
(PPListParser
	subclass: 'PPSequenceParser'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'A parser that parses a sequence of parsers.';
		immediateInvariant.
true.
%

removeallmethods PPSequenceParser
removeallclassmethods PPSequenceParser

doit
(PPParser
	subclass: 'PPLiteralParser'
	instVarNames: #(literal message)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'Abstract literal parser that parses some kind of literal type (to be specified by subclasses).

Instance Variables:
	literal	<Object>	The literal object to be parsed.
	message	<String>	The error message to be generated.
';
		immediateInvariant.
true.
%

removeallmethods PPLiteralParser
removeallclassmethods PPLiteralParser

doit
(PPLiteralParser
	subclass: 'PPLiteralObjectParser'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'A parser that accepts a single literal object, such as a character. This is the same as the predicate parser ''PPPredicateParser expect: literal'' but slightly more efficient.';
		immediateInvariant.
true.
%

removeallmethods PPLiteralObjectParser
removeallclassmethods PPLiteralObjectParser

doit
(PPLiteralParser
	subclass: 'PPLiteralSequenceParser'
	instVarNames: #(size)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'A parser accepts a sequence of literal objects, such as a String. This is an optimization to avoid having to compose longer sequences from PPSequenceParser.';
		immediateInvariant.
true.
%

removeallmethods PPLiteralSequenceParser
removeallclassmethods PPLiteralSequenceParser

doit
(PPParser
	subclass: 'PPPluggableParser'
	instVarNames: #(block)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'A pluggable parser that passes the parser stream into a block. This enables users to perform manual parsing or to embed other parser frameworks into PetitParser.

Instance Variables:
	block	<BlockClosure>	The pluggable one-argument block.
';
		immediateInvariant.
true.
%

removeallmethods PPPluggableParser
removeallclassmethods PPPluggableParser

doit
(PPParser
	subclass: 'PPPredicateParser'
	instVarNames: #(predicate predicateMessage negated negatedMessage)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'An abstract parser that accepts if a given predicate holds.

Instance Variables:
	predicate	<BlockClosure>	The block testing for the predicate.
	predicateMessage	<String>	The error message of the predicate.
	negated	<BlockClosure>	The block testing for the negation of the predicate.
	negatedMessage	<String>	The error message of the negated predicate.';
		immediateInvariant.
true.
%

removeallmethods PPPredicateParser
removeallclassmethods PPPredicateParser

doit
(PPPredicateParser
	subclass: 'PPPredicateObjectParser'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'A parser that accepts if a given predicate on one element of the input sequence holds.';
		immediateInvariant.
true.
%

removeallmethods PPPredicateObjectParser
removeallclassmethods PPPredicateObjectParser

doit
(PPPredicateParser
	subclass: 'PPPredicateSequenceParser'
	instVarNames: #(size)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'A parser that accepts if a given predicate on an arbitrary number of elements of the input sequence holds.

Instance Variables:
	size	<Integer>	The number of elements to consume.';
		immediateInvariant.
true.
%

removeallmethods PPPredicateSequenceParser
removeallclassmethods PPPredicateSequenceParser

doit
(PPParser
	subclass: 'PPStartOfLineParser'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'A PPStartOfLineParser is that does not fail, if the stream position is at the beginning of a line. It does not consume anything.';
		immediateInvariant.
true.
%

removeallmethods PPStartOfLineParser
removeallclassmethods PPStartOfLineParser

doit
(PPParser
	subclass: 'PPStartOfLogicalLineParser'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'A PPStartOfLogicalLineParser is that does not fail, if the stream position is at the first non-blank character of a line. It does not consume anything.';
		immediateInvariant.
true.
%

removeallmethods PPStartOfLogicalLineParser
removeallclassmethods PPStartOfLogicalLineParser

doit
(PPParser
	subclass: 'PPStartOfWordParser'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Parsers';
		comment: 'A PPStartOfWordParser is that matches a word boundary.

I return success if no word character preceeds my position and if word chracter succeeds my position.

Word characters are any alphanumeric characters.';
		immediateInvariant.
true.
%

removeallmethods PPStartOfWordParser
removeallclassmethods PPStartOfWordParser

doit
(PPParser
	subclass: 'PPUnresolvedParser'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Tools';
		comment: 'This is a temporary placeholder or forward reference to a parser that has not been defined yet. If everything goes well it will eventually be replaced with the real parser instance.';
		immediateInvariant.
true.
%

removeallmethods PPUnresolvedParser
removeallclassmethods PPUnresolvedParser

doit
(Object
	subclass: 'PPToken'
	instVarNames: #(newLineParser collection start stop value)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'PetitParser-Core';
		comment: 'PPToken represents a parsed part of the input stream. Contrary to a simple String it remembers where it came from, the original collection and its start and stop position.

Instance Variables:
	collection	<SequenceableCollection>	The collection this token comes from.
	start	<Integer>	The start position in the collection.
	stop	<Integer>	The stop position in the collection.';
		immediateInvariant.
true.
%

removeallmethods PPToken
removeallclassmethods PPToken

doit
(PathEvaluator
	subclass: 'OptionalTermPathEvaluator'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Evaluators';
		comment: 'OptionalTermPathEvaluator is part of the Indexing and Querying subsystem. It implements GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods OptionalTermPathEvaluator
removeallclassmethods OptionalTermPathEvaluator

doit
(PathEvaluator
	subclass: 'SelectorPathEvaluator'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Evaluators';
		comment: 'SelectorPathEvaluator is part of the Indexing and Querying subsystem. It implements GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

removeallmethods SelectorPathEvaluator
removeallclassmethods SelectorPathEvaluator

doit
(PrivateObject
	subclass: 'Upgrade3Init'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Kernel-Build';
		comment: 'Upgrade3Init is a class used during image upgrade.  
Methods should only be executed via the image upgrade scripts.';
		immediateInvariant.
true.
%

removeallmethods Upgrade3Init
removeallclassmethods Upgrade3Init

doit
(RcEqualityIndexSpecification
	subclass: 'RcUnicodeIndexSpecification'
	instVarNames: #(collator)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Query';
		comment: 'The class RcUnicodeIndexSpecification provides details for specifying an index that is 
reduced-conflict and contains Unicode Strings. Since it contains Unicode Strings, it requires 
a persistent IcuCollator instance associated with the index.';
		immediateInvariant.
true.
%

removeallmethods RcUnicodeIndexSpecification
removeallclassmethods RcUnicodeIndexSpecification

doit
(SequenceableCollection
	byteSubclass: 'Uint16Array'
	classVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'2byteWords'  #logCreation )
)
		category: 'Collections-NumericArrays';
		comment: 'Instances of Uint16Array are byte format arrays that store 16 bit unsigned integers.
For an instance loaded into memory, the integers are in machine native byte order.';
		immediateInvariant.
true.
%

removeallmethods Uint16Array
removeallclassmethods Uint16Array

doit
(Uint16Array
	subclass: 'Int16Array'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'signed2byteWords'  #logCreation )
)
		category: 'Collections-NumericArrays';
		comment: 'Instances of Int16Array are byte format arrays that store 16 bit signed integers.
For an instance loaded into memory, the integers are in machine native byte order.';
		immediateInvariant.
true.
%

removeallmethods Int16Array
removeallclassmethods Int16Array

doit
(SequenceableCollection
	byteSubclass: 'Uint32Array'
	classVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'4byteWords'  #logCreation )
)
		category: 'Collections-NumericArrays';
		comment: 'Instances of Uint32Array are byte format arrays that store 32 bit unsigned integers.
For an instance loaded into memory, the integers are in machine native byte order.';
		immediateInvariant.
true.
%

removeallmethods Uint32Array
removeallclassmethods Uint32Array

doit
(Uint32Array
	subclass: 'Int32Array'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'signed4byteWords'  #logCreation )
)
		category: 'Collections-NumericArrays';
		comment: 'Instances of Int32Array are byte format arrays that store 32 bit signed integers.
For an instance loaded into memory, the integers are in machine native byte order.';
		immediateInvariant.
true.
%

removeallmethods Int32Array
removeallclassmethods Int32Array

doit
(SequenceableCollection
	byteSubclass: 'Uint64Array'
	classVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'8byteWords'  #logCreation )
)
		category: 'Collections-NumericArrays';
		comment: 'Instances of Uint64Array are byte format arrays that store 64 bit unsigned integers.
For an instance loaded into memory, the integers are in machine native byte order.';
		immediateInvariant.
true.
%

removeallmethods Uint64Array
removeallclassmethods Uint64Array

doit
(Uint64Array
	subclass: 'Int64Array'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'signed8byteWords'  #logCreation )
)
		category: 'Collections-NumericArrays';
		comment: 'Instances of Int64Array are byte format arrays that store 64 bit signed integers.
For an instance loaded into memory, the integers are in machine native byte order.';
		immediateInvariant.
true.
%

removeallmethods Int64Array
removeallclassmethods Int64Array

doit
(SortedCollection
	subclass: 'IcuSortedCollection'
	instVarNames: #(collator)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Collections-Ordered';
		comment: 'An IcuSortedCollection is a SortedCollection that
encapsulates an IcuCollator to be used when comparing elements.  
Elements must respond to compareTo:collator:  and thus should be 
instances of Utf8, Unicode7, Unicode16, or Unicode32. ';
		immediateInvariant.
true.
%

removeallmethods IcuSortedCollection
removeallclassmethods IcuSortedCollection

doit
(Stream
	subclass: 'BtreePlusReadStream'
	instVarNames: #(currentNode currentIndex currentLastValIndex currentEntrySize endNode endIndex)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-Streams';
		comment: 'BtreePlusReadStream supports the composition of query results by providing access
 to a B-tree structure.

 A BtreePlusReadStream can read all the entries of the B-tree one at a time.  Supply
 the root node when you create the stream, and send the ''next'' message to
 read the first node.  Send the ''next'' message repeatedly to iterate over
 the B-tree''s contents, and send the ''atEnd'' message to check if there are
 any more nodes.
';
		immediateInvariant.
true.
%

removeallmethods BtreePlusReadStream
removeallclassmethods BtreePlusReadStream

doit
(BtreePlusReadStream
	subclass: 'BtreePlusGsIndexReadStream'
	instVarNames: #(gsIndex streamQuerySpec optimizedComparison mustCompare)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-Streams';
		comment: 'BtreePlusGsIndexReadStream is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing. ';
		immediateInvariant.
true.
%

removeallmethods BtreePlusGsIndexReadStream
removeallclassmethods BtreePlusGsIndexReadStream

doit
(BtreePlusGsIndexReadStream
	subclass: 'BtreePlusGsReversedIndexReadStream'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Indexing-Btree-Streams';
		comment: 'BtreePlusGsReversedIndexReadStream is part of the Indexing and Querying subsystem. 
It implements GemStone internals and is not intended for customer use, by creating instances 
or by subclassing';
		immediateInvariant.
true.
%

removeallmethods BtreePlusGsReversedIndexReadStream
removeallclassmethods BtreePlusGsReversedIndexReadStream

! Class implementation for 'GsPathTerm'

!		Instance methods for 'GsPathTerm'

category: 'Private'
method: GsPathTerm
_findAllValuesForIdenticalRootObject: rootObject
	" if index directly on NSC elements or anObject is nil "

	| key tmpList |
	(self indicatesIndexOnNscElements or: [ nil == rootObject ])
		ifTrue: [ key := rootObject ]
		ifFalse: [ key := self _nextObjectFor: rootObject ].
	tmpList := IdentityBag new.
	self updateBtree btreeRoot _findAllValuesForIdenticalKey: key into: tmpList.
	^ (tmpList occurrencesOf: rootObject) <= 1
%

! Class implementation for 'GsOptionalPathTerm'

!		Instance methods for 'GsOptionalPathTerm'

category: 'Adding'
method: GsOptionalPathTerm
addMappingsForObject: anObject root: rootObject logging: aBoolean
	"Add dependency list entries for anObject."

	| ivOffset |
	(nil == anObject or: [ self size == 0 ])
		ifTrue: [ ^ self ].
	(ivOffset := self _ivOffsetFor: anObject) == nil
		ifTrue: [ ^ self recordNilOnPathForRoot: rootObject ].
	^ super addMappingsForObject: anObject root: rootObject logging: aBoolean
%

category: 'Adding'
method: GsOptionalPathTerm
removeMappingsFor: anObject root: rootObject lastOne: aBoolean logging: doLogging
  "Remove entries in the btree and dependency lists for anObject."

	| ivOffset |
	(nil == anObject or: [ self size == 0 ])
		ifTrue: [ ^ self ].
	(ivOffset := self _ivOffsetFor: anObject) == nil
		ifTrue: [ ^ self removeNilOnPathForRoot: rootObject ].
	^ super removeMappingsFor: anObject root: rootObject lastOne: aBoolean logging: doLogging
%

category: 'Private'
method: GsOptionalPathTerm
_findAllValuesForIdenticalRootObject: rootObject
	" if index directly on NSC elements or anObject is nil "

	| ivOffset |
	ivOffset := self _ivOffsetFor: rootObject.
	ivOffset
		ifNil: [ 
			"no values in index for rootObject"
			^ IdentityBag new ].
	^ super _findAllValuesForIdenticalRootObject: rootObject
%

category: 'Accessing'
method: GsOptionalPathTerm
_nextObjectFor: anObject atInstVar: anIvOffset
	"Returns the object at the instance variable that corresponds to the receiver
 path term."

	| ivOffset |
	ivOffset := self _ivOffsetFor: anObject.
	ivOffset ifNil: [ ^ nil ].
	^ super _nextObjectFor: anObject atInstVar: anIvOffset
%

! Class implementation for 'GciError'

!		Class methods for 'GciError'

category: 'signalling'
classmethod: GciError
signal: aGciErrSType in: anExternalSession
	self new
		signal: aGciErrSType
		in: anExternalSession
    details: nil
%

category: 'signalling'
classmethod: GciError
signal: aGciErrSType in: anExternalSession details: aString
	self new
		signal: aGciErrSType
		in: anExternalSession
    details: aString
%

!		Instance methods for 'GciError'

category: 'accessing'
method: GciError
actualExceptionClassOr: aBlock
	"Answer the class of the actual exception if there is one,
	 or the result of evaluating aBlock if not."

	| actualCls |
	actualCls := (LegacyErrNumMap atOrNil: self number ) ifNotNil: [ :a | a atOrNil: 1].
	^actualCls ifNil: aBlock
%

category: 'accessing'
method: GciError
category

	^gciErrSType category.
%

category: 'updating'
method: GciError
clearStack
  (originalNumber ~~ nil and:[ originalNumber < 4000]) ifTrue:[
         externalSession clearStackFor: gciErrSType.
  ].
%

category: 'accessing'
method: GciError
context

	^gciErrSType context.
%

category: 'updating'
method: GciError
continue
	"Continue code execution in GemStone after an error.
	See GciContinue() in the GemBuilder for C manual for details."

	^externalSession continue: gciErrSType context.
%

category: 'updating'
method: GciError
continueWith: anObject
	"This function is a variant of the continue method, except
	that it allows you to modify the call stack before attempting
	to continue the suspended Smalltalk execution.
	See GciContinueWith() in the GemBuilder for C manual for details."

	^externalSession
		continue: gciErrSType context
		with: anObject.
%

category: 'signalling'
method: GciError
error: aGciErrSType in: anExternalSession details: aString
  self _error: aGciErrSType in: anExternalSession .
  aGciErrSType ifNotNil:[ | num |
    num := aGciErrSType number .
    (num ~~ 2203"GCI_ERR_OP_IN_PROGRESS" and:[ num ~~ 2336"RT_ERR_CLIENT_FWD_SEND"]) ifTrue:[
	    self stack ifNotNil: [:stack | messageText lf ; add: stack].
    ].
  ].
  aString ifNotNil:[ messageText add:', '; add: aString asString].
  self details: messageText.
%

category: 'accessing'
method: GciError
externalErrorNumber

	^gciErrSType number.
%

category: 'accessing'
method: GciError
gciErrSType

	^gciErrSType
%

category: 'testing'
method: GciError
matchesClasses: expClass
	"expClass is either a Class or an Array of Classes"

	| actualCls |
	actualCls := self actualExceptionClassOr: [^false].
	expClass _isArray
		ifTrue: [^expClass anySatisfy: [:aCls | actualCls isSubclassOf: aCls]]
		ifFalse: [^actualCls isSubclassOf: expClass]
%

category: 'accessing'
method: GciError
originalNumber
  ^ originalNumber
%

category: 'signalling'
method: GciError
signal: aGciErrSType in: anExternalSession
  ^ self signal: aGciErrSType in: anExternalSession details: nil
%

category: 'signalling'
method: GciError
signal: aGciErrSType in: anExternalSession details: aString
  self error: aGciErrSType in: anExternalSession details: aString ;
     signal .
%

category: 'signalling'
method: GciError
signalCompileError
	| delimiter gAry |
	self details: gciErrSType message.
	gsArgs := gciErrSType args.
	gsArgs size: gciErrSType argCount.
	gsArgs := (gAry := gsArgs) collect: [:each |
		externalSession resolveResult: each toLevel: 4.
	].
	messageText := String withAll: 'Compile error(s): '.
	delimiter := ''.
  gsArgs size > 0 ifTrue:[ | firstArg |
	  firstArg := gsArgs atOrNil:1 .
    firstArg size > 0 ifTrue:[
      firstArg do: [:each | 
        each size > 0 ifTrue:[
          messageText addAll: delimiter.
          (each atOrNil: 3) ifNotNil:[:v | messageText addAll: v asString ].
			    messageText addAll: ' (error #' .
			    (each atOrNil: 1) ifNotNil:[:v | messageText addAll: v printString].
			    messageText addAll: ') at offset '.
			    (each atOrNil:2) ifNotNil:[:v | messageText addAll: v printString ].
		      delimiter := '; '.
        ]
      ]
	  ].
  ].
	self signal.
%

category: 'accessing'
method: GciError
stack
  gciErrSType ifNil:[ ^ nil ].
	gciErrSType context == nil asOop ifTrue: [^nil].	"NO CALL IN PROGRESS"
	self externalErrorNumber >= 4000 ifTrue: [^nil].	"NOT A RUNTIME ERROR"
  ^ externalSession _getStackForOop: gciErrSType context .
%

category: 'signalling'
method: GciError
_error: aGciErrSType in: anExternalSession
	gciErrSType := aGciErrSType.
	externalSession := anExternalSession.
  aGciErrSType ifNil:[
    originalNumber := 4100 "GCI_ERR_BAD_SESSION_ID".
    messageText := 'invalid session' copy .
  ] ifNotNil:[
         (originalNumber := gciErrSType number) == 1001 ifTrue: [^self signalCompileError].
         messageText := gciErrSType message.
  ].
	"avoid killing current session with fatal errors"
	(originalNumber between: 4000 and: 4999) ifTrue: [
		messageText add: ' original number: ' , originalNumber asString,
		' for session ' , externalSession _describe.
		"and self number is inherited value 2710"
	] ifFalse: [
		self _number: originalNumber.
	].
%

! Class implementation for 'LogRotateNotification'

!		Class methods for 'LogRotateNotification'

category: 'Control'
classmethod: LogRotateNotification
disableSignalling
  System _updateSignalErrorStatus: 11 toState: false
%

category: 'Control'
classmethod: LogRotateNotification
enableSignalling
  System _updateSignalErrorStatus: 11 toState: true 
%

category: 'Control'
classmethod: LogRotateNotification
signallingEnabled
  ^ System _signalErrorStatus: 11
%

!		Instance methods for 'LogRotateNotification'

category: 'Handling'
method: LogRotateNotification
defaultAction
"Return an error to the controlling debugger or GCI client .
 See AbstractException>>defaultAction for documentation."

 ^ self _signalToDebugger
%

! Class implementation for 'GciTsLibrary'

!		Class methods for 'GciTsLibrary'

category: 'Instance Creation'
classmethod: GciTsLibrary
newDefault
  ^ (self classVarAt: #Gemstone_GciTsLibrary_default otherwise: nil) ifNil:[
     Error signal: 'Gemstone_GciTsLibrary_default  not initialized'.
  ].
%

category: 'Instance Creation'
classmethod: GciTsLibrary
newForVersion: verString product: pathArg
  "Requires cpp; should have gcc/g++ installed"

  | res hdr path hdrPath libPath suffix |
  (res := self new )
    version: verString . "checks verString"
  path := pathArg.
  path last == $/ ifFalse:[ (path := path copy) add: $/ ].
  hdrPath := path, 'include/gcits.hf'  .
  suffix := ((System gemVersionReport at: 'gsBuildArchitecture') at:1 equals:'Darwin')
             ifTrue:[ '-64.dylib' ] ifFalse:[ '-64.so' ].
  libPath := path, 'lib/libgcits-', (res version) , suffix .
  hdr := CHeader path: hdrPath .
  res
    libPath: libPath ;
    _initCallouts: hdr .
  ^ res
%

category: 'Private'
classmethod: GciTsLibrary
_initializeDefault
 "executed by image upgrade and slowfilein"
 | val f |
 (f := GsFile openReadOnServer: '$upgradeDir/GciTsLibrary.dat') ifNotNil:[
    val := (PassiveObject newOnStream: f) activate.
    GsFile gciLogServer:'loaded GciTsLibrary.dat' .
 ] ifNil:[ "this path executes in slowfilein only"
   val := self newForVersion: System _gemVersion  product: '$GEMSTONE'. "run FFI parsing..."
   f := GsFile openWriteOnServer:  'GciTsLibrary.dat' . "to current dir of filein"
   PassiveObject passivate: val toStream: f .
   GsFile gciLogServer:'generated  GciTsLibrary.dat' .
 ].
 f close .
 self _addClassVar: #Gemstone_GciTsLibrary_default value: val .  
%

!		Instance methods for 'GciTsLibrary'

category: 'Accessing'
method: GciTsLibrary
callouts
  ^ callouts
%

category: 'Updating'
method: GciTsLibrary
libPath: aPath
  cLibrary := CLibrary named: aPath .
%

category: 'Accessing'
method: GciTsLibrary
version
 "Returns a String of the form  3.6.0 "
  ^ version
%

category: 'Updating'
method: GciTsLibrary
version: verString
  "can't yet load v3.4.x libs into a 3.5 VM , see bug 48749"
  | ok ofs vs |
  ofs := (vs := verString) indexOf: $, startingAt: 1 .
  ofs > 0 ifTrue:[ 
    vs := vs copyFrom: 1 to: ofs - 1 .
  ].
  ok := false .
  (vs at: 1 equals: '3.5') ifTrue:[ | x |
     x := vs copyFrom: 1 to: 5 .
     ok := x >= '3.5.3' . 
  ] ifFalse:[ | v |
    ofs := vs indexOf: $. startingAt: 1 .
    ofs > 0 ifTrue:[
      ofs := vs indexOf: $. startingAt: ofs + 1  . "second . "
      ofs > 0 ifTrue:[
        v := Float fromString:(vs copyFrom: 1 to: ofs - 1 ) .
        ok :=   v >= 3.6 .
      ].
    ]. 
  ].
  ok ifTrue:[ version := vs ]
     ifFalse:[ Error signal:'Cannot load library that has version ', verString].
%

category: 'Private'
method: GciTsLibrary
_initCallouts: aCHeader
 | fcts list |
 callouts := { } .
 "calloutSigs not used, send   signatureString  to a callout to  see the signature"
 fcts := aCHeader functions .
 "Callouts used by GsTsExternalSession must be at fixed offsets in array of callouts."
 list := #(
    'GciTsLogin'  "order of list must match offsets used in GsTsExternalSession"
    'GciTsLogout'
    'GciTsAbort'
    'GciTsCommit'
    'GciTsExecute'
    'GciTsPerform'
    'GciTsContinueWith' "7"
    'GciTsClearStack'
    'GciTsFetchObjInfo'
    'GciTsNbLogout'  "10"
  ) copy .
  version >= '3.5.3' ifTrue:[
   list addAll: #(
    'GciTsNbPerform' "11"
    'GciTsNbResult'
    'GciTsSocket'
    'GciTsNbExecute' ).
  ].
  version >= '3.6.0' ifTrue:[
   list addAll: #(
    'GciTsNbLogin'   "15" 
    'GciTsNbLoginFinished'
    'GciTsBreak'
    'GciTsBegin'
    'GciTsX509Login'
    'GciTsNewUtf8String' "20" 
    'GciTsReleaseObjs').
  ].
  version >= '3.7.0' ifTrue:[
   list addAll: #(
    'GciTsDebugConnectToGem'   "22"
    'GciTsDebugStartDebugService'
    'GciTsGemTrace' ).
  ].
  "todo, add more functions"
  list  do:[ :fn | | f c |
    f := fcts at: fn .
    c := (f cCalloutForLibrary: cLibrary) copy .
    c coerceNameToSymbol . "for efficient consistency checks in GsTsExternalSession"
    callouts add: c .
    fcts removeKey: fn .
  ].
  "now add remaining callouts to the arrays ."
  list := SortedCollection withAll:( fcts keys ).
  list do:[:fn | | f c |
    (fn at: 1 equals: 'Gci') ifTrue:[
      f := fcts at: fn .
      c := (f cCalloutForLibrary: cLibrary) copy .
      c coerceNameToSymbol . "for efficient consistency checks in GsTsExternalSession"
      callouts add: c .
    ].
  ].
%

! Class implementation for 'GsNetworkResourceString'

!		Class methods for 'GsNetworkResourceString'

category: 'Accessing'
classmethod: GsNetworkResourceString
currentGemHostName

	^System gemVersionReport at: #nodeName.
%

category: 'Accessing'
classmethod: GsNetworkResourceString
currentStoneHostName

  GsSession currentSession isSolo ifTrue:[ ^ 'localhost' ].

  ^System stoneVersionReport at: #nodeName
%

category: 'Accessing'
classmethod: GsNetworkResourceString
currentStoneName
	"The name of the current running stone, excluding host and other NRS information"

	^(System stoneName subStrings: $!) last
%

category: 'Instance Creation'
classmethod: GsNetworkResourceString
defaultGemNRSFromCurrent
"Return a new gem NRS with the gem's host being the same as the current login.
 Use default gem service, and default netldi, or as set by environment variable GEMSTONE_NRS_ALL.
 If GEMSTONE_NRS_ALL contains a #dir component, include that in result.
 Ignore any other parameters in the NRS of the current login"

^ self defaultGemNRSFromCurrentForHost: self currentGemHostName
%

category: 'Instance Creation'
classmethod: GsNetworkResourceString
defaultGemNRSFromCurrentForHost: aHostName

"Return a new gem NRS with the gem's host being set to aHostName.
 Use default gem service, and default netldi, or as set by environment variable GEMSTONE_NRS_ALL.
 If GEMSTONE_NRS_ALL contains a #dir component, include that in result.
 Ignore any other parameters in the NRS of the current login"

| list ldiName dir res log |
list := self _nrsAllComponents .
ldiName := (list detect: [:nrs | nrs first matchPattern: #( 'netldi' ) ] 
             ifNone: [ { self defaultNetLDIName } ]) last .
list do:[:elem | | key |
  key := elem at: 1 .
  key = 'dir' ifTrue:[ dir := elem at: 2 ].
  key = 'log' ifTrue:[ log := elem at: 2 ].
].
(res := self new)
	node: aHostName;
	netldi: ldiName;
	resource: 'task';
	body: self defaultGemService .
dir ifNotNil:[ res dir: dir ].
log ifNotNil:[ res log: log ].
^ res
%

category: 'Defaults'
classmethod: GsNetworkResourceString
defaultGemService
	^'gemnetobject'
%

category: 'Defaults'
classmethod: GsNetworkResourceString
defaultNetLDIName
	^'gs64ldi'
%

category: 'Defaults'
classmethod: GsNetworkResourceString
defaultStoneName
	^'gs64stone'
%

category: 'Instance Creation'
classmethod: GsNetworkResourceString
defaultStoneNRSFromCurrent
	"Return a new stone NRS with the stone name and stone's host being the same as the current login.
	Ignore any other login parameters in the NRS of the current login"

	| stoneNameParts resourceParts protocolParts body resource node res |
	stoneNameParts := System stoneName subStrings: $!.
  stoneNameParts size >= 3 ifTrue:[
	  body := stoneNameParts at: 3.
	  resourceParts := (stoneNameParts at: 2) subStrings: $#.
	  resource := resourceParts last.
	  protocolParts := (resourceParts at: 1) subStrings: $@.
  ] ifFalse:[
    body := stoneNameParts at: 1.
    resource := 'server' .
  ].
	protocolParts size < 2 ifTrue:["handle default stone name of the form   '!#server!gs64stone' "
		node := self currentGemHostName	"if stone does not have host specified, uses gem host"
  ] ifFalse:[
    node := protocolParts at: 2
  ].
	(res := self new)
		node: node;
		resource: resource;
		body: body.
  ^ res
%

category: 'Instance Creation'
classmethod: GsNetworkResourceString
gemNRS

"Return a new basic gem NRS, which is only the gem service"

	^self new
		body: self defaultGemService;
		yourself.
%

category: 'Instance Creation'
classmethod: GsNetworkResourceString
gemNRSForNetLDI: nameOrPort

"Return a new gem NRS for a gem with the given netldi."

	^self new
		netldi: nameOrPort;
		body: self defaultGemService;
		yourself.
%

category: 'Instance Creation'
classmethod: GsNetworkResourceString
gemNRSForNetLDI: nameOrPort onHost: gemhostname

"Return a new gem NRS for a gem that will run on the given host, using the given netldi"

	^self new
		node: gemhostname;
		netldi: nameOrPort;
		body: self defaultGemService;
		yourself.
%

category: 'Instance Creation'
classmethod: GsNetworkResourceString
gemNRSForNetLDI: nameOrPort onHost: gemhostname gemService: customGemService

"Return a new gem NRS for a gem that will run on the given host, using the given netldi,
 and specifying the customGemService.  Options for <customGemService> are
 gemnetobject, gemnetdebug, or a custom script that starts up a gem."

	^self new
		node: gemhostname;
		netldi: nameOrPort;
		body: customGemService;
		yourself.
%

category: 'Instance Creation'
classmethod: GsNetworkResourceString
new

	^super new
		initialize;
		yourself.
%

category: 'Instance Creation'
classmethod: GsNetworkResourceString
stoneNRS
	"Return a new stone NRS for stone with default name."

	^self new
		body: self defaultStoneName;
		yourself
%

category: 'Instance Creation'
classmethod: GsNetworkResourceString
stoneNRSForStoneName: aStoneName
	"Return a new stone NRS with stone with the given name."

	^self new
		body: aStoneName;
		yourself
%

category: 'Instance Creation'
classmethod: GsNetworkResourceString
stoneNRSForStoneName: aStoneName onHost: stoneHostName
	"Return a new stone NRS with stone with the given name."

	^self new
		node: stoneHostName;
		body: aStoneName;
		yourself
%

category: 'Instance Creation'
classmethod: GsNetworkResourceString
systemNetLDIName

	| list |
	list := self _nrsAllComponents .
	^(list detect: [:nrs | nrs first matchPattern: #( 'netldi' ) ]
         ifNone: [ { self defaultNetLDIName } ]) last
%

category: 'Private'
classmethod: GsNetworkResourceString
_nrsAllComponents
  | ev ofs b list |
  (ev := System gemEnvironmentVariable: 'GEMSTONE_NRS_ALL') ifNil:[
    ^ { { 'netldi' . self defaultNetLDIName } }
  ].
  ev first == $! ifTrue:[ ev := ev copyFrom: 2 to: ev size ].
  ofs := ev indexOf: $! startingAt: 1 .
  ofs ~~ 0 ifTrue:[ ev := ev copyFrom: 1 to: ofs - 1 ]."exclude nrs-body"
  b := ev subStrings: $# .
  list := b collect:[:x | x subStrings: $: ].
  ^ list
%

!		Instance methods for 'GsNetworkResourceString'

category: 'Formatting'
method: GsNetworkResourceString
asString

	^self printString
%

category: 'Accessing'
method: GsNetworkResourceString
authorization
	"username [@password]
	 A valid user on the target network (default is the current user).
	 A valid password is needed only if the resource type requires authentication.
	 If no authentication information is specified, the system will try to get it from the .netrc file
		(this type of authorization is the default)."

	^authorization
%

category: 'Updating'
method: GsNetworkResourceString
authorization: aString
	"username [@password]
	 A valid user on the target network (default is the current user).
	 A valid password is needed only if the resource type requires authentication.
	 If no authentication information is specified, the system will try to get it from the .netrc file
		(this type of authorization is the default)."

	(aString isKindOf: String) ifFalse: [self error: 'parameter must be a String'].
	authorization := aString.
%

category: 'Updating'
method: GsNetworkResourceString
beEncrypted

	encrypted := true.
%

category: 'Updating'
method: GsNetworkResourceString
beNotEncrypted

	encrypted := false.
%

category: 'Accessing'
method: GsNetworkResourceString
body
	"The <body> is interpreted according to the context established by the <resource>.
	 No extended identifier expansion is done in the <body> and no special escapes are needed."

	^body.
%

category: 'Updating'
method: GsNetworkResourceString
body: aString
	"The <body> is interpreted according to the context established by the <resource>.
	 No extended identifier expansion is done in the body and no special escapes are needed."

	(aString isKindOf: String) ifFalse: [self error: 'parameter must be a String'].
	body := aString.
%

category: 'Accessing'
method: GsNetworkResourceString
dir
	"<dir> sets the default directory of the network resource.
	It has no effect if the resource already exists.
	If a directory is not set, the pattern %H is used.

	The string can contain patterns that are expanded in the context of the created resource.
	The following patterns are supported:
		%H	home directory
		%M	machine's network node name
		%N	executable's base name
		%P	process pid
		%U	user name
		%%	%"

	^dir
%

category: 'Updating'
method: GsNetworkResourceString
dir: aString
	"<dir> sets the default directory of the network resource.
	It has no effect if the resource already exists.
	If a directory is not set, the pattern %H is used.

	The string can contain patterns that are expanded in the context of the created resource.
	The following patterns are supported:
		%H	home directory
		%M	machine's network node name
		%N	executable's base name
		%P	process pid
		%U	user name
		%%	%"

	(aString isKindOf: String) ifFalse: [self error: 'parameter must be a String'].
	dir := aString.
%

category: 'Accessing'
method: GsNetworkResourceString
encrypted
	"Answer whether the authorization credentials are encrypted."

	^encrypted
%

category: 'Updating'
method: GsNetworkResourceString
gemConfig: aString
  (aString includes: $') ifTrue:[ Error signal:'unexpected quote in argument'].
  self body: ( self body , ' -C ', $' , aString, $' )
%

category: 'Private'
method: GsNetworkResourceString
hasNrsHeader

	^(protocol , node , authorization , netldi , dir , log , resource)
		notEmpty
%

category: 'Private'
method: GsNetworkResourceString
initialize

	protocol := ''.
	node := ''.
	authorization := ''.
	encrypted := false.
	netldi := ''.
	dir := ''.
	log := ''.
	resource := ''.
	body := ''.
%

category: 'Accessing'
method: GsNetworkResourceString
log
	"<log> sets the name of the log file of the network resource.
	It has no effect if the resource already exists.
	If the log name is a relative path, it is relative to the working directory.
	If a log name is not set, the pattern '%N%P%M.log' is used.

	The string can contain patterns that are expanded in the context of the created resource.
	The following patterns are supported:
		%H	home directory
		%M	machine's network node name
		%N	executable's base name
		%P	process pid
		%U	user name
		%%	%"

	^log
%

category: 'Updating'
method: GsNetworkResourceString
log: aString
	"<log> sets the name of the log file of the network resource.
	It has no effect if the resource already exists.
	If the log name is a relative path, it is relative to the working directory.
	If a log name is not set, the pattern '%N%P%M.log' is used.

	The string can contain patterns that are expanded in the context of the created resource.
	The following patterns are supported:
		%H	home directory
		%M	machine's network node name
		%N	executable's base name
		%P	process pid
		%U	user name
		%%	%"


	(aString isKindOf: String) ifFalse: [self error: 'parameter must be a String'].
	log := aString.
%

category: 'Updating'
method: GsNetworkResourceString
nativeCodeConfig: anInt
 "Pass in the setting for GEM_NATIVE_CODE_ENABLED to use for the
  session, may be 0, 1, or 2."

  self body: (self body , ' -N ', anInt asString)
%

category: 'Accessing'
method: GsNetworkResourceString
netldi
	"Use the named GsNetLDI to service the request."

	^netldi
%

category: 'Updating'
method: GsNetworkResourceString
netldi: aString
	"Use the named GsNetLDI to service the request."

	(aString isKindOf: String) ifFalse: [self error: 'parameter must be a String'].
	netldi := aString.
%

category: 'Accessing'
method: GsNetworkResourceString
node
	"Specifies the host on which the resource exists.
	If no node is specified, the current machine's network node name is used.
	The identifier may be an Internet-style numeric address."

	^node
%

category: 'Updating'
method: GsNetworkResourceString
node: aString
	"Specifies the host on which the resource exists.
	If no node is specified, the current machine's network node name is used.
	The identifier may be an Internet-style numeric address."

	(aString isKindOf: String) ifFalse: [self error: 'parameter must be a String'].
	node := aString.
%

category: 'Formatting'
method: GsNetworkResourceString
printOn: aStream

	| bang |
	bang := self hasNrsHeader ifTrue: ['!'] ifFalse: [''].
	aStream nextPutAll: bang.
	self
		printSegment: node designated: '@' on: aStream;
		printSegment: authorization
			designated: (encrypted ifTrue: ['#encrypted:'] ifFalse: ['#auth:'])
			on: aStream;
		printSegment: netldi designated: '#netldi:' on: aStream;
		printSegment: dir designated: '#dir:' on: aStream;
		printSegment: log designated: '#log:' on: aStream;
		printSegment: resource designated: '#' on: aStream.
	aStream
		nextPutAll: bang;
		nextPutAll: body
%

category: 'Private'
method: GsNetworkResourceString
printSegment: aString designated: designationString on: aStream

	aString isEmpty ifTrue: [^self].
	aStream
		nextPutAll: designationString;
		nextPutAll: aString
%

category: 'Accessing'
method: GsNetworkResourceString
protocol
	"Only tcp is supported"

	^ 'tcp'
%

category: 'Updating'
method: GsNetworkResourceString
protocol: aString
   "The only supported protocol is TCP"

	(aString isKindOf: String)
		ifFalse: [self error: 'parameter must be a String'].
	((aString isEquivalent: 'TCP') or:[ aString = ''
	   or:[ aString isEquivalent: 'DEFAULT']])
		ifFalse: [self error: 'Invalid protocol: ' , aString].
	protocol := 'tcp'.
%

category: 'Accessing'
method: GsNetworkResourceString
resource
	"Identifies the intended purpose of the <body>.
	An NRS can contain only one resource modifier.
	The default resource modifier is context sensitive.
	For instance, if the system expects an NRS for a database file
	(say, in the context of copydbf), then the default is #dbf.

	'server' directs the GsNetLDI to search for the network address of a server,
	such as a GsStone or another GsNetLDI. If successful, it returns the address.
	The <body> is a network server name. A successful lookup means only
	that the service has been defined; it does not indicate whether the service
	is currently running. A new process will not be started.
	(Authorization is needed only if the GsNetLDI is on a remote node
	and is running in secure mode.)

	'task' starts a new Gem. The <body> is a GsNetLDI service name
	(such as 'gemnetobject'), followed by arguments to the command line.
	The GsNetLDI creates the named service by looking first for an entry in
	$GEMSTONE/bin/services.dat, and then in the user's home directory
	for an executable having that name.
	The GsNetLDI returns the network address of the service.
	(Authorization is needed to create a new process unless the GsNetLDI
	is in guest mode.)
	The 'task' resource modifier is also used internally to create page servers.

	'dbf' is used to access a database file. The <body> is the file spec
	of a GemStone dataabse file.
	The GsNetLDI creates a page server on the given node to access
	the database and returns the network address of the page server.
	(Authorization is needed unless the GsNetLDI is in guest mode.)

	'spawn' is used internally to start the garbage-collection Gem process.

	'monitor' is used internally to start up a shared page cache monitor.

	'file' means the nrs-body is the file spec of a file on the given host (not
	currently implemented)."

	^resource
%

category: 'Updating'
method: GsNetworkResourceString
resource: aString
	"Identifies the intended purpose of the <body>.
	An NRS can contain only one resource modifier.
	The default resource modifier is context sensitive.
	For instance, if the system expects an NRS for a database file
	(say, in the context of copydbf), then the default is #dbf.

	'server' directs the GsNetLDI to search for the network address of a server,
	such as a GsStone or another GsNetLDI. If successful, it returns the address.
	The <body> is a network server name. A successful lookup means only
	that the service has been defined; it does not indicate whether the service
	is currently running. A new process will not be started.
	(Authorization is needed only if the GsNetLDI is on a remote node
	and is running in secure mode.)

	'task' starts a new Gem. The <body> is a GsNetLDI service name
	(such as 'gemnetobject'), followed by arguments to the command line.
	The GsNetLDI creates the named service by looking first for an entry in
	$GEMSTONE/bin/services.dat, and then in the user's home directory
	for an executable having that name.
	The GsNetLDI returns the network address of the service.
	(Authorization is needed to create a new process unless the GsNetLDI
	is in guest mode.)
	The 'task' resource modifier is also used internally to create page servers.

	'dbf' is used to access a database file. The <body> is the file spec
	of a GemStone dataabse file.
	The GsNetLDI creates a page server on the given node to access
	the database and returns the network address of the page server.
	(Authorization is needed unless the GsNetLDI is in guest mode.)

	'spawn' is used internally to start the garbage-collection Gem process.

	'monitor' is used internally to start up a shared page cache monitor.

	'file' means the nrs-body is the file spec of a file on the given host (not
	currently implemented)."

	(aString isKindOf: String) ifFalse: [self error: 'parameter must be a String'].
	(#('server' 'task' 'dbf' 'spawn' 'monitor' 'file') includes: aString) ifFalse: [self error: 'Invalid resource: ', aString].
	resource := aString.
%

category: 'Updating'
method: GsNetworkResourceString
temporaryObjectCacheSize: sizeKB
  self body: (self body , ' -T ', sizeKB asString)
%

! Class implementation for 'Upgrade3Init'

!		Class methods for 'Upgrade3Init'

category: 'Image Upgrade'
classmethod: Upgrade3Init
_checkObsoleteClasses: obsoleteClassNames
  "Check for obsolete classes in obsoleteClassNames"
  | obsDict |
  obsDict := Globals at: #ObsoleteClasses otherwise: nil.
  obsoleteClassNames do:[:sym | 
    (Globals includesKey: sym) ifTrue:[ 
      | assoc |
      assoc := Globals associationAt: sym  .
      Globals removeAssociation: assoc .
      obsDict addAssociation: assoc .
    ].
  ].
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_checkObsoleteDisallowedSubclasses
  "Check for obsolete classes used in _disallowSubclasses"
  self _checkObsoleteClasses: 
        #( ObsoleteMetaclass CompiledMethod UnimplementedFloat1 UnimplementedFloat2 
             MethodContext Block SelectionBlock JISCharacter StackSegment StackBuffer 
             Activation Process ExecutableBlock SimpleBlock ComplexBlock ComplexVCBlock
             GsMethod )
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_checkObsoleteInstancesDisallowed
  "Check for obsolete classes used in _buildInstancesDisallowed"
  self _checkObsoleteClasses: 
             #( Activation Block GsMethod ComplexBlock ComplexVCBlock ExecutableBlock 
                  JISCharacter ObsoleteMetaclass MethodContext Process SelectionBlock
                  SimpleBlock StackBuffer StackSegment )
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_checkObsoleteMigrateGroups
  "Check for obsolete classes used in _migrateGroups"
  self _checkObsoleteClasses: 
        #( CanonicalStringDictionary )
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_checkObsoleteVmClasses
  "Check for obsolete classes used in _checkVmClasses"
  self _checkObsoleteClasses: 
             #( AbstractCharacter )
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_disallowSubclasses
| list blk obsDict |
  self _checkObsoleteDisallowedSubclasses.
  obsDict := Globals at: #ObsoleteClasses otherwise: nil.
	blk := [:cls | "_unsafeDisallowSubclasses"
          cls _unsafeAt: 2 "offset of format"
             put: (cls format bitOr: 32 "subclasses disallowed bit") .
          cls _refreshClassCache: false
       ].
  list := { Behavior . Class . (obsDict at: #ObsoleteMetaclass) . Repository . UserProfileSet .
     AbstractUserProfileSet .
     (obsDict at: #CompiledMethod) . Float . DecimalFloat . SmallFloat . SmallDouble .
     Symbol . DoubleByteSymbol .
     (obsDict at: #UnimplementedFloat1) . (obsDict at: #UnimplementedFloat2) .
     (obsDict at: #MethodContext) . (obsDict at: #Block) . (obsDict at: #SelectionBlock) .
     GsObjectSecurityPolicy . SymbolList . System . UndefinedObject . UserProfile . Boolean .
     Character . SmallInteger . Integer . LargeInteger .
     (obsDict at: #JISCharacter) . (obsDict at: #StackSegment) .
     (obsDict at: #StackBuffer) . (obsDict at: #Activation) . (obsDict at: #Process) . 
     VariableContext . BlockClosure .

     ExecBlock . (obsDict at: #ExecutableBlock) . (obsDict at: #SimpleBlock) . 
     (obsDict at: #ComplexBlock) . (obsDict at: #ComplexVCBlock) . 
     ExecBlock0 . ExecBlock1 . ExecBlock2 . ExecBlock3 . ExecBlock4 . ExecBlock5 . ExecBlockN .
     (obsDict at: #GsMethod) . GsNMethod . GsNativeCode .
     GsProcess . GsMethodDictionary . GsStackBuffer .

     SelectBlock . BasicSortNode .
     RcIndexDictionary . NscBuilder .

     "PathTerm . ConstrainedPathTerm . SetValuedPathTerm"  "fix bug 11484"
     }.
  list do: [ :aClass | blk value: aClass ].

  list do: [ :aClass |
     aClass subclassesDisallowed ifFalse:[ ^ 'Error on ' , aClass name ].
     ] .
%

category: 'Image Upgrade'
classmethod: Upgrade3Init
_setByteSwizzles
" Set the NbyteWords swizzle option in some byte format classes, so it
  shows up in the result of Class>>definition.  ominit.c synthesizes the
  in-memory swizzle info for the classes if needed when class is faulted in.
  Part of fix 47516."
| blk |
GsFile gciLogServer:'_setByteSwizzles'.
blk := [:cls :aSym | | fmt newFmt |
   fmt := cls format .
   newFmt := cls _addByteSwizzle: aSym toFormat: fmt newClassName: cls name signed: false .
   newFmt = fmt ifTrue:[
     GsFile gciLogServer: '  ',cls name, ' no change'.
   ] ifFalse:[
     cls _unsafeAt: 2 put: newFmt .
     GsFile gciLogServer: '  ',cls name, ' old format ', fmt asString, ' new format ', newFmt asString
   ].
].
{ DoubleByteString .
  DoubleByteSymbol .
  Unicode16  .
  Utf16
} do:[:aCls | blk value: aCls value: #'2byteWords' ].

{ LargeInteger  .
  QuadByteString .
  QuadByteSymbol .
  Unicode32 .
  SmallFloat .
  BitSet .
} do:[:aCls | blk value: aCls value: #'4byteWords' ].

{  Float
} do:[ :aCls | blk value: aCls value: #'8byteWords' ].
%

! Class implementation for 'Int16Array'

!		Instance methods for 'Int16Array'

category: 'Updating'
method: Int16Array
at: anOffset put: aValue

"aValue must be a SmallInteger representable as a 16bit signed integer.
 returns aValue ."
 
<primitive: 254>
aValue _validateClass: SmallInteger .
(aValue < -32768 or:[ aValue > 32767]) ifTrue:[
  aValue _error: #rtErrArgOutOfRange args:{ -32768 . 32767 }
].
(anOffset _isSmallInteger) ifTrue: [
  ((anOffset > (self size + 1)) or: [anOffset < 1]) ifTrue: [
    ^ self _errorIndexOutOfRange: anOffset
  ] 
] ifFalse: [
  ^ self _errorNonIntegerIndex: anOffset
] . 
self _primitiveFailed: #at:put: args: { anOffset . aValue }
%

! Class implementation for 'Int32Array'

!		Instance methods for 'Int32Array'

category: 'Updating'
method: Int32Array
at: anOffset put: aValue

"aValue must be a SmallInteger representable as a 32bit unsigned integer.
 returns aValue ."

<primitive: 1075>
| min max |
aValue _validateClass: SmallInteger .
min := -2147483648 .
max := 2147483647 .
(aValue < min or:[ aValue > max]) ifTrue:[
  aValue _error: #rtErrArgOutOfRange args:{ min . max }
].
(anOffset _isSmallInteger) ifTrue: [
  ((anOffset > (self size + 1)) or: [anOffset < 1]) ifTrue: [
    ^ self _errorIndexOutOfRange: anOffset
  ]
] ifFalse: [
  ^ self _errorNonIntegerIndex: anOffset
] .
self _primitiveFailed: #at:put: args: { anOffset . aValue }
%

! Class implementation for 'Int64Array'

!		Instance methods for 'Int64Array'

category: 'Updating'
method: Int64Array
at: anOffset put: aValue

"aValue must be an Integer representable as a 64bit unsigned integer.
 returns aValue ."

<primitive: 1077>
| max min |
aValue _validateClass: Integer .
max := 16r7FFFFFFFFFFFFFFF .
min := -9223372036854775808 .
(aValue < min or:[ aValue > max ]) ifTrue:[
  aValue _error: #rtErrArgOutOfRange args:{ min . max }
].
(anOffset _isSmallInteger) ifTrue: [
  ((anOffset > (self size + 1)) or: [anOffset < 1]) ifTrue: [
    ^ self _errorIndexOutOfRange: anOffset
  ]
] ifFalse: [
  ^ self _errorNonIntegerIndex: anOffset
] .
self _primitiveFailed: #codePointAt:put: args: { anOffset . aValue }
%

