! Copyright (C) GemTalk Systems 1986-2025.  All Rights Reserved.
! Class Declarations
! Generated file, do not Edit

doit
(Object
	subclass: 'Reflection'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Kernel-Processes';
		comment: 'Reflection is an abstract class that has no instances.  It implements class
 methods for object so that it is safe to get information about the object
 without sending it a message.';
		immediateInvariant.
true.
%

removeallmethods Reflection
removeallclassmethods Reflection

doit
(PrivateObject
	subclass: 'Upgrade1B'
	instVarNames: #()
	classVars: #(doit err)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Kernel-Build';
		comment: 'Upgrade1B is a class used during image upgrade.  
Methods should only be executed via the image upgrade scripts.';
		immediateInvariant.
true.
%

removeallmethods Upgrade1B
removeallclassmethods Upgrade1B

! Class implementation for 'Reflection'

!		Class methods for 'Reflection'

category: 'Accessing'
classmethod: Reflection
classOf: anObject
"Answers the class of the object, the object whose
 oop would be returned by GciFetchClass."

^self _reflect: anObject opCode: 2
%

category: 'Accessing'
classmethod: Reflection
fetchDynamicInstVar: anObject named: aSymbol

 "Return the value of specified dynamic instance variable, or nil if anObject
  has no such dynamic instance variable.  Does not consider instVars defined
  by the anObject's class.  See Object>>dynamicInstVarAt: "


^self _reflect: anObject opCode: 6 arg: aSymbol
%

category: 'Accessing'
classmethod: Reflection
fetchFrom: anObject at: anIndex
" Answers the object or byte found at the given index in the object.
  Legal values for anIndex are 1 to sizeOf: anObject. Not valid for 0-size objects.
  Indices are consistent with GciFetchOop and GciFetchByte."

^self _reflect: anObject opCode: 2 arg: anIndex - 1
%

category: 'Accessing'
classmethod: Reflection
fetchTagOf: anObject tagNum: tagNumber

" Answer the object referred to by the given tag number of the object.
  tagNumber must be from 1 to the value reported by tagSizeOf: "

^self _reflect: anObject opCode: 5 arg: tagNumber
%

category: 'Updating'
classmethod: Reflection
from: anNsc removeObject: anObject

" Removes an existing object from the NSC. Consistent with
  GciRemoveOopFromNsc.
  Answer true if the object was in the NSC and has been removed, false if the
  object was not present."

^self _reflect: anNsc opCode: 4 arg: anObject
%

category: 'Accessing'
classmethod: Reflection
implementationOf: anObject
"Answers #pointers, #bytes, #NSC, or #special, analagous
 to the intergers returned by GciFetchObjImpl."

| impl |
impl := self _reflect: anObject opCode: 3.
(impl == 0) ifTrue: [ ^ #pointers ].
(impl == 1) ifTrue: [ ^ #bytes ].
(impl == 2) ifTrue: [ ^ #NSC ].
(impl == 3) ifTrue: [ ^ #special ].
^ #InvalidImplementation
%

category: 'Accessing'
classmethod: Reflection
namedSizeOf: anObject

" Answers 0 if #implementationOf: answers #special.
  Otherwise, answers the number of named instance variables in the object.

  Consistent with GciFetchNamedSize."

^ self _reflect: anObject opCode: 5
%

category: 'Accessing'
classmethod: Reflection
oopOf: anObject
"Answers the oop of the object, consistent with Object>>asOop."

^self _reflect: anObject opCode: 1
%

category: 'Updating'
classmethod: Reflection
setSizeOf: anObject to: newSize

" Sets the indexable size of anObject so that it will subsequently answer newSize
  when sent sizeOf:. Consistent with GciSetVaryingSize.
  Not valid for #NSC or #special objects."

self _reflect: anObject opCode: 1 arg: newSize
%

category: 'Accessing'
classmethod: Reflection
sizeOf: anObject

" Answers 0 if #implementationOf: answers #special.
  Otherwise, answers the number of pointers (for #pointers or #NSC)
    or bytes (#bytes) that the object currently holds.

  For #pointers objects (small and large), this includes both named instance variables
    and the object's varying size.
  Consistent with GciFetchSize. "

^ self _reflect: anObject opCode: 4
%

category: 'Updating'
classmethod: Reflection
storeDynamicInstVar: anObject named: aSymbol newValue: aValue

 "Store the value of specified dynamic instance variable,
  If aValue ~~ _remoteNil, creates the dynamic instance variable if needed.
  aValue == _remoteNil effectively removes the instance variable.
  Does not consider instVars defined by the anObject's class.
  Generates an error if anObjectreceiver is an ExecBlock, Behavior, GsNMethod,
  or special object.  See  Object>>dynamicInstVarAt:put: "

self _reflect: anObject opCode: 3 arg1: aSymbol arg2: aValue
%

category: 'Updating'
classmethod: Reflection
storeTagTo: anObject tagNum: tagNumber newValue: aValue

" Store the given value into the specified tag number of the object.
  tagNumber must be 1 or 2. Similar to prim 280."

self _reflect: anObject opCode: 2 arg1: tagNumber arg2: aValue
%

category: 'Updating'
classmethod: Reflection
storeTo: anObject at: anIndex put: aValue
" Stores aValue, which may be any object for #pointers objects, but which
  must be 0-255 for #byte objects, at the given index in the object.
  Indices are consistent with GciStoreOop and GciStoreByte. Legal indices are 1 to
  sizeOf: anObject."

self _reflect: anObject opCode: 1 arg1: anIndex - 1 arg2: aValue
%

category: 'Accessing'
classmethod: Reflection
tagSizeOf: anObject

" Returns the number of words of dynamic instVars in the object."

^ self _reflect: anObject opCode: 6
%

category: 'Updating'
classmethod: Reflection
to: anNsc addObject: anObject

" Add a new object to the NSC. Consistent with GciAddOopToNsc."

self _reflect: anNsc opCode: 3 arg: anObject
%

category: 'Private'
classmethod: Reflection
_reflect: anObject opCode: anInt

<primitive: 837 >
anInt _validateClass: SmallInteger.
anInt > 4 ifTrue: [ anInt _error: #rtErrArgOutOfRange "bad opcode" ].
self _primitiveFailed: #_reflect:opcode: args: { anObject . anInt } .
%

category: 'Private'
classmethod: Reflection
_reflect: anObject opCode: opcodeInt arg1: anArg1 arg2: anArg2

<primitive: 839 >
opcodeInt _validateClass: SmallInteger.
opcodeInt > 3 ifTrue: [ opcodeInt _error: #rtErrArgOutOfRange "bad opcode" ].
opcodeInt <= 2 ifTrue:[ anArg1 _validateClass: SmallInteger ]
          ifFalse:[     anArg1 _validateClass: Symbol ].
self _primitiveFailed: #_reflect:opcode:withArg:
     args: { anObject . opcodeInt . anArg1 . anArg2 } .
%

category: 'Private'
classmethod: Reflection
_reflect: anObject opCode: opcodeInt arg: anArg

<primitive: 838 >
opcodeInt _validateClass: SmallInteger.
opcodeInt > 6 ifTrue: [ opcodeInt _error: #rtErrArgOutOfRange "bad opcode" ].
opcodeInt == 6 ifTrue:[ anArg _validateClass: Symbol ].
self _primitiveFailed: #_reflect:opcode:withArg:
     args: { anObject . opcodeInt . anArg } .
%

! Class implementation for 'Upgrade1B'

!		Class methods for 'Upgrade1B'

category: 'Image Upgrade'
classmethod: Upgrade1B
initialize
  self _initFilein1  .
  self _clearErrors ;
   _initRuntimeErrs1 ;
   _initRuntimeErrs2 ;
   _initRuntimeErrs3 ;
   _initRuntimeErrs4 ;
   _initRuntimeErrs5 ;
   _initRuntimeErrs6 ;
   _initRuntimeErrs7 ;
   _initRuntimeErrs8 ;
   _initAbortingErrs ;
   _initFatalErrs ;
   _initAsyncErrs .
  ErrorSymbols rebuildIfNeeded .
  System commit .
  self _createErrorDescArray;
    _createCompileErrs1 ;
    _createCompileErrs2 ;
    _createCompileErrs3 ;
    _createRtErrs1 ;
    _createRtErrs2 ;
    _createRtErrs3 ;
    _createRtErrs4 ;
    _createRtErrs5 ;
    _createRtErrs6 ;
    _createRtErrs7 ;
    _createRtErrs8 ;
    _createRtErrs9 ;
    _createRtErrs10 ;
    _createRtErrs11 ;
    _createRtErrs12 ;
    _createRtErrs13 ;
    _createRtErrs14 ;
    _createRtErrs15 ;
    _createRtErrs16 ;
    _createRtErrs17 ;
    _createRtErrs18 ;
    _createRtErrs19 ;
    _createRtErrs20 ;
    _createRtErrs21 ;
    _createRtErrs22 ;
    _createRtErrs23 ;
    _createRtErrs24 ;
    _createRtErrs25 ;
    _createRtErrs26 ;
    _createRtErrs27 ;
    _createAbortingErrs ;
    _createFatalErrs ;
    _createAsyncErrs .
  System commit .
  self _initFloatingPointError ;
    _initDcUserGlobals ;
    _initAuthorizationSymbols ;
    _initDate ;
    _initObsoleteDateTime;
    _initLanguageNames ;
    _checkObsoleteErrorClasses;
    _initLegacyErrMap1 ;
    _initLegacyErrMap2 ;
    _initDateAndTime .
  ^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_checkObsoleteErrorClasses
  "Check for obsolete Ruby and Regex exception classes in ObsoleteClasses in a virgin dbf"
  | keys obsDict |
  obsDict := Globals at: #ObsoleteClasses otherwise: nil.
  keys := #( RubyThrowException RubyBreakException RegexpError ).
   keys do:[:sym | 
      (Globals includesKey: sym) ifTrue:[ 
          | assoc |
          assoc := Globals associationAt: sym  .
          Globals removeAssociation: assoc .
          obsDict addAssociation: assoc .
        ].
      ].
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_clearErrors
  ErrorSymbols removeAllKeys .
  ErrorSymbols size .
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createAbortingErrs

doit value: #rtErrAbortTrans value: err value:
    #('The transaction was aborted by the user.').
"abortErrInternal deleted"

doit value: #abortErrCommitsSuspended value: err value:
   #('Commits are suspended, ' 1 ).

doit value: #abortErrGarbageCollection value: err value:
  #('Garbage collection aborted, reason: '
	1  ', conflict code: ' 2
	'.  Garbage collection was aborted and should be tried again later.').

doit value: #bkupErrRestoreLogSuccess value: err value:
    #( 'Restore from transaction log succeeded.' ).
doit value: #bkupErrRestoreLogFail value: err value:
    #( 'Restore from transaction log failed. Reason: ' 1 ).

doit value: #bkupErrRestoreSuccessful value: err value:
    #( 'Restore from full backup completed with ' 1 ' objects restored and '
       2 ' corrupt objects not restored.' 3 ).

"bkupErrCorruptFile deleted"
"bkupErrWrongFile deleted"

doit value: #gsErrShrpcLostOtTimeout value: err value:
    #( 'LostOt timeout during shared cache access' ).

"abortErrFinishedMark deleted"

doit value: #abortErrLostOtRoot value: err value:
    #('When running outside of a transaction the session failed to respond '
      'quickly enough to a request from Stone to abort.  All object caches '
      'have been cleared. ' 1 ).

doit value: #errAutoAbort value: err value:
    #('A sigAbort was serviced automatically by idle Gem.').

doit value: #errAutoLostOt value: err value:
    #('A LostOt was serviced automatically by idle Gem.' ) .

^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createAsyncErrs

doit value: #rtErrPause value: err value:
    #('Execution has been suspended by a "pause" or "halt" message.').
"rtErrStep deleted"
doit value: #rtErrStep value: err value:
    #('Single-step breakpoint encountered.').
doit value: #rtErrSoftBreak value: err value:
    #('A soft break was received. ' ).
doit value: #rtErrHardBreak value: err value:
    #('A hard break was received.').
doit value: #rtErrCodeBreakpoint value: err value:
    #('Method breakpoint encountered.').
doit value: #rtErrStackBreakpoint value: err value:
    #('Stack breakpoint encountered on return from method or block.').
doit value: #rtErrCommitAbortPending value: err value:
    #('A transaction commit or abort is pending.').

doit value: #rtErrSignalCommit value: err value:
    #('This error indicates that a member of the notify set has been '
      'committed and was added to the signaledObjects set.').
doit value: #rtErrSignalAbort value: err value:
    #('This error indicates that when running outside of a '
      'transaction Stone signaled the Gem to request an abort').

doit value: #rtErrSignalGemStoneSession value: err value:
    #('The signal ' 2 ' was received from sessionSerialNumber = ' 1
      ' and the message string associated with the signal is ' 3).

doit value: #rtErrUncontinuable value: err value:
    #('Execution cannot be continued, ' 1 ).

doit value: #rtErrSignalFinishTransaction value: err value:
    #('Stone requests commit, abort or continueTransaction of the current '
      'transaction.' ) .

doit value: #rtErrSignalAlmostOutOfMemory value: err value:
    #('Session''s temporary object memory is almost full' ) .

doit value: #rtErrProcessStepInNative value: err value:
    #('Breakpoint and single-step not supported in native code' ) .

doit value: #rtErrTimeoutInterrupt value: err value: #('Timeout interrupt' ) .
doit value: #rtErrSignalException value: err value: #('SignalException interrupt' ) .
doit value: #rtErrGcFinalize value: err value: #('GcFinalize interrupt for ephemerons' ) .
doit value: #rtErrTerminateProcess value: err value: #('TerminateProcess interrupt' ) .
doit value: #rtErrSignalTrap value: err value: #('Signal ' 3 ' trapped (by Ruby)').
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createCompileErrs1
" create error strings for compiler category"
doit value: #compilerErrStDB value: err value:
    'compilation errors -- parameter 1 is error descriptor'.
doit value: #StDBErrMaxPath value: err value: 'path too long'.
doit value: #StDBErrArrayTooLarge value: err value: 'Array constructor too large (exceeds 10000 elements)'.
doit value: #StDBErrEofInStrLit value: err value:
    'missing end of literal mark (prime)'.
doit value: #StDBErrEofInComment value: err value:
    'missing end of comment (")'.
doit value: #StDBErrEofInChrLit value: err value:
    'invalid or missing Character'.
doit value: #StDBErrUnexpectedColon value: err value:
    'invalid colon'.
doit value: #StDBErrUnexpectedPound value: err value: 'invalid pound sign'.
doit value: #StDBErrBadChr value: err value: 'illegal character'.
doit value: #StDBErrLitTooBig value: err value: 'string literal too big (exceeds 5M bytes)'.
doit value: #StDBErrSymTooBig value: err value: 'selector or symbol literal would exceed 1024 bytes' .
doit value: #StDBErrBadRadix value: err value: 'illegal radix'.
doit value: #StDBErrBadChrInRadixNum value: err value:
    'illegal Character in number'.
doit value: #StDBErrExpectedRightParen value: err value:
    'expected a right parenthesis'.
doit value: #StDBErrExpectedPrimary value: err value:
    'expected a primary expression'.
doit value: #StDBErrExpectedVar value: err value:
    'expected a variable name' .
doit value: #StDBErrExpectedSelector value: err value:
    'missing or bad message pattern'.
doit value: #StDBErrMaxArg value: err value: 'too many arguments'.
doit value: #StDBErrExpectedEof value: err value:
    'characters found after end of method'.
doit value: #StDBErrExpectedStatement value: err value: 'expected start of a statement'.
doit value: #StDBErrExpectedPrim value: err value:
    'expected keyword "primitive"'.
doit value: #StDBErrExpectedPrimNum value: err value: 'expected an integer'.
doit value: #StDBErrBadPrimNum value: err value: 'illegal primitive number'.
doit value: #StDBErrExpectedRightBrace value: err value:
    'expected a right brace (}) ' .
doit value: #StDBErrMaxArgsTemps value: err value:
    'too many arguments and temporaries'.
doit value: #StDBbadAtRuby value: err value:
    'second and subsequent keywords for @ruby may only be  _:  or __STAR: ' .
doit value: #StDBnoRuby value: err value:
    'This VM does not support Ruby code generation' .
doit value: #StDBBadLit value: err value: 'invalid numeric literal' .
^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createCompileErrs2

doit value: #StDBErrExpectedVerticalBar value: err value:
    'missing end of temporaries mark (|)'.
doit value: #StDBErrExpectedMsgPattern value: err value:
    'invalid message pattern'.
doit value: #StDBErrExpectedGt value: err value:
    'missing end of primitive mark (>)'.
doit value: #StDBErrBadFlt value: err value: 'illegal exponent'.
doit value: #StDBErrExpectedAssignable value: err value:
    'expected an assignable variable' .
doit value: #StDBErrAlreadyDefined value: err value:
    'variable has already been declared'.
doit value: #StDBErrNotDefined value: err value: 'undefined symbol'.
doit value: #StDBErrPredicateTooBig value: err value:
    'predicate too complex'.
doit value: #StDBErrBlocksTooDeep value: err value:
    'blocks or if statements can only be nested 255 levels'.
doit value: #StDBErrUnexpectedToken value: err value: 'unexpected token'.
doit value: #StDBErrExpectedRightBracket value: err value:
    'expected a right bracket (])'.
doit value: #StDBErrStmtNoEffect value: err value: 'statement has no effect'.
doit value: #StDBErrCodeTooBig value: err value: 'method too large'.
doit value: #StDBErrPrimNotAllowed value: err value:
    'Must be SystemUser or have CompilePrimitives privilege to compile a primitive or protected method.'.
doit value: #StDBErrExpectedBoolOrExpr value: err value:
    'The object was not true, false or a non-literal expression.'.
doit value: #StDBErrExpectedLitOrExpr value: err value:
    'The object was not a literal or a non-literal expression.'.
doit value: #StDBErrExpectedBlockOrExpr value: err value:
    'The object was not a block or a non-literal expression.'.
doit value: #StDBErrExpectedIntOrExpr value: err value:
    'The object was not a kind of Integer or a non-literal expression.'.
doit value: #StDBErrNotPosIntOrExpr value: err value:
   'The object was not a positive kind of Integer or a non-literal expression.'.
doit value: #StDBErrDisallowedSelector value: err value:
    'You may not compile a method for this selector.'.
doit value: #StDBErrBadNumOfArgs value: err value:
    'The block has the wrong number of arguments for this selector.'.
doit value: #StDBNoDigitInAtEnv value: err value:
    'For @rubyN: or @envN: , no digits found for N ' .
doit value: #StDBBadChInAtEnv value: err value:
    '@env or @ruby is followed by character other than 0..9 or : ' .
doit value: #StDBEnvTooBig value: err value:
    'For @envN: or @rubyN: , value of N is > 255  ' .
doit value: #StDBByteArrElemRange value: err value:
    'Element of a ByteArray literal not a SmallInteger within 0..255' .
^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createCompileErrs3

doit value: #StDBErrLiteralInvariant value: err value:
    'Attempt to modify an invariant literal.'.

doit value: #StDBErrExpectedOperand value: err value:
    'An operand was missing from the given SelectBlock term.'.
doit value: #StDBErrBadSelectOperator value: err value:
    'An unacceptable operator was given in the SelectBlock ' ,
	'term.  The operator must be one of <, >, <=, >=, =, ~=, ==, ' ,
	' or ~~.'.
doit value: #StDBErrExpectedSelectTerm value: err value:
    'The given SelectBlock must contain a Boolean expression.'.
doit value: #StDBErrTermsNotParen value: err value:
    'The conjoined terms of the given SelectBlock were not ' ,
	'parenthesized.'.
doit value: #StDBErrBadNumOfSelectArgs value: err value:
    'A SelectBlock was encountered that does not have ' ,
	'one argument.'.
doit value: #StDBErrSourceNotEUCFormat value: err value:
    'The bytes of the source string are not in EUC format.'.
doit value: #StDBErrMaxArgs value: err value:
    'The maximum number of arguments to a method or block is 255.'.
doit value: #StDBErrCodeGenLogic value: err value:
    'Internal logic error in compiler:' .
doit value: #StDBErrFirstTermCannotBeSetValued value: err value:
    'The first term of a path in a SelectBlock cannot indicate ' ,
        'search over a set-valued instance variable (i.e. cannot be *). '.
doit value: #StDBErrIllegalProtectedMethod value: err value:
    'The specified primitive may not be a protected method.' .
doit value: #StDBMissingProtectedToken value: err value:
    'Method requires either <protected> or <unprotected> directive.' .
doit value: #StDBSuperNotAllowed value: err value:
    'super not allowed in instance method for Object or when superClass is nil.'.
doit value: #StDBUnusedTemp value: err value:
    'Unused method or block temporary.'.
doit value: #StDBMbStrOddSize value: err value:
    'Corrupt source string, a Double/QuadByteString has odd basic size.'.
doit value: #StDBPrimitiveInPragma value: err value:
    'primitive:, protected, unprotected, requiresVc not allowed as keywords in pragma.'.
doit value: #StDBPragmaInPrim value: err value:
    'pragma not allowed in a primitive:, protected, unprotected , or requiresVc method.'.
^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createErrorDescArray
"initialize class variables"
err := Array new: 4154.
(Globals at: #GemStoneError) at: #English put: err.
doit := [:key :errsArray :message | | theOffset |
          theOffset := ErrorSymbols at: key.
          errsArray size < theOffset ifTrue: [ errsArray size: theOffset].
          errsArray at: theOffset put: message
        ].
^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createFatalErrs

doit value: #gsErrBadRootPage value: err value:
    #('The Repository root page is corrupted or contains a disk media defect.').
doit value: #repErrReposFull value: err value:
    #('The Repository is full and can no longer be expanded.').
doit value: #repErrNoFreePages value: err value:
    #('No free pages were found after growing the Repository ' 1 '.').
doit value: #hostFatalErrOutOfMem value: err value:
    #('Host memory allocation failed. Insufficient '
      'swap space and/or RAM to allocate: ' 1 ).
doit value: #gsErrCorruptObjSize value: err value:
   #('The object ' 1 ' is corrupted and has size ' 2 '. The correct size
      is ' 3 '.' ).
doit value: #repErrBadBkupSwizzle value: err value:
   #('An invalid swizzle transform was detected in the backup file'
     ' long transform: ' 1 ' short transform: ' 2 ) .
doit value: #repErrBadDbfSwizzle value: err value:
   #('An invalid swizzle transform was detected in an extent'
     ' long transform: ' 1 ' short transform: ' 2 ) .
doit value: #gciErrActionDefined value: err value:
    #('Attempt to install user failed, there is already a user action '
      'installed with the name: ' 1 ).
doit value: #errUserProfileLost value: err value:
    #('The UserProfile with object ID ' 1 ' has been garbage collected '
      'as a result of a successful restore or by a commit of another session').
doit value: #gsErrShrpcConnectionFailure value: err value:
    #('The Gem''s connection to the local shared cache monitor was lost. '
      'Error text: ' 1).
doit value: #gsErrShrpcUnexpectedNetEvent value: err value:
    #('There was an unexpected read or write event ' 1
      ' from the shared cache monitor.').
doit value: #gsErrShrpcInvalidConfig value: err value:
    #('The process tried to login to a Stone with the configuration file '
      'specifying that the SharedPageCache should NOT be used when '
      'the Stone already has a SharedPageCache active on the host machine').

doit value: #repErrBadBkupVersion value: err value:
   #('The backup file is incompatible with this version of GemStone.'
     ' Backup file version is: ' 1 ).

doit value: #rtErrCantSuspendLogins value: err value:
   #('Request to Suspend logins denied. ' 1 ).

doit value: #objErrCorruptObj value: err value:
    #('The object with object ID ' 1 ' is corrupt. Reason: ' 2).

doit value: #gsErrStnNetProtocol value: err value:
    #('A fatal network protocol error occurred on the Gem to Stone '
      'network, failure code = ' 1 ' .').
doit value: #errTranLogOpenFail value: err value:
    #('GemStone is unable to open the next transaction log for writing.').

doit value: #errFinishedObjAuditRepair value: err value:
    #('Repair operation completed: ' 1 'repairs were made.').

doit value: #gsErrStnNetLost value: err value:
    #('The GemStone session has lost its connection to the Stone repository '
      'monitor.').

doit value: #gsErrDisconnectInLogin value: err value:
    #('The session lost its connection to the Stone repository monitor during '
      'login. Logins are disabled or the maximum number of users are already '
      'logged in.').
doit value: #gsErrMaxSessionsLimit value: err value:
    #('Login failed: the maximum number of users is already logged in.').
doit value: #lgcErrIncompatGci value: err value:
    #('The version of GemBuilder for C (GCI) is not compatible with the '
      'version of the Gem').
doit value: #hostErrCantSpawn value: err value:
    #('Unable to create a GemStone session.').
doit value: #gsActiveUserLimitExceeded value: err value:
  #( 'Login failed: Too many sessions already logged in with this userId.').
doit value: #gsErrLoginDenial value: err value:
    #('Login failed:  the GemStone userId/password combination is invalid '
      'or expired.').

doit value: #gsErrLoginsDisabled value: err value:
    #('Login failed:  GemStone logins are currently disabled.').

doit value: #gsErrCacheTooBig value: err value:
    #('Login failed:  GemStone could not start a remote shared page cache because the '
      'requested cache size exceeds the license limit.').

doit value: #gsErrStnShutdown value: err value:
    #('The Stone repository monitor has shut down.').
doit value: #gsErrSessionShutdown value: err value:
    #('Your GemStone session has been forcibly terminated, probably '
      'by DataCurator, ').
doit value: #gsErrGemNormalShutdown value: err value:
    #('The GemStone session is terminating normally.').

doit value: #gsErrGemFatalShutdown value: err value:
    #('The GemStone session is terminating abnormally.').
doit value: #gsErrNoMoreOops value: err value:
    #('GemStone system ran out of OOPs.').
doit value: #netErrNoSuchStn value: err value:
    #('The given Stone repository monitor cannot be reached:' 1).
doit value: #gciErrBadSessionId value: err value:
    #('The given GemStone session ID is invalid.').
doit value: #gciErrUnexpectedLnkErr value: err value:
    #('Fatal unexpected error in Linkable GemBuilder for C (GCI) session while '
      'GemBuilder for C call in progress on another RPC session').
doit value: #gciErrInternalRpc value: err value:
    #('A logic error was detected in the implementation of an RPC GemBuilder for C call. '
      'Please report to your GemStone Administrator.').
doit value: #fatalErrInternal value: err value:
    #('Please report to your GemStone Administrator. Fatal Internal Error: ' 1
	' with arguments:  ' 2 ' ' 3 ' ' 4 ' ' 5 ' ' 6 ' ' 7 ' ' 8 ' ' 9
	' ' 10 '.').
doit value: #netErrConnectionRefused value: err value:
    #('The connection to the Stone repository monitor was refused.').
doit value: #netErr value: err value: #('Network error, text follows:' 1).
doit value: #repErrSystemRepNotAttached value: err value:
    #('The Repository is not attached.').
doit value: #authErrSegLoginSeg value: err value:
    #('You have no authorization to write in your default login security policy, ' 1 ).

doit value: #gsErrCopyProtection value: err value:
    #('Copy protection check failed, invalid keyfile.').
doit value: #gsErrNoCapability value: err value:
    #('Attempt to use a feature not licensed by your keyfile.').
doit value: #gsErrBadGemStoneVersion value: err value:
    #('The Gem version ' 1 ' and the Stone version ' 2 ' are incompatible.').
doit value: #gsErrBadGemDbfVersion value: err value:
    #('The Gem version ' 1 ' and the Repository version ' 2
      ' are incompatible.').
doit value: #gsErrSslShutdown value: err value:
    #('A network error occurred while switching from SSL to non-SSL communication.').

doit value: #errLostOtGci value: err value:
    #('A LostOtRoot signal was received while waiting for a GCI command to complete.').

doit value: #errDuringLostOtService value: err value:
    #('An error occurred while servicing a LostOtRoot signal.').
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createRtErrs1

doit value: #rtErrInvalidTransMode value: err value:
     #( 1 ' is not recognized as a valid transactionMode.' ).
doit value: #rtErrBadSymbolList value: err value:
    #('The user''s symbol list is not a kind of Array containing '
	   'objects that are a kind of SymbolDictionary.').
doit value: #objErrBadOffsetIncomplete value: err value:
    #('An indexable object or NSC ' 1 ' was referenced with an '
	   'index ' 2 ' that was out of range.').
doit value: #rtErrBadSubscript value: err value:
    #('A subscript ' 2 ' that was out of range or not an Integer was used to '
	   'index the object ' 1 '.').
doit value: #gciErrBadNumMsgParts value: err value:
    #( 'GciSendMsg was called with an inconsistent number of '
	   ' message parts.').
doit value: #rtErrAuthArraySize value: err value:
    #('(OBSOLETE) An attempt was made to change GsObjectSecurityPolicy authorization with '
	   'an Array ' 1 ' which should be of size 5.').
doit value: #rtErrShouldNotImplement value: err value:
    #('A method was invoked that has been specifically disallowed '
	   'in a subclass. Receiver:  ' 1 '.  Selector:  ' 2 '.').
doit value: #objErrClassVariant value: err value:
    #('An attempt was made to create an instance of the modifiable'
	   ' class ' 1 ' .  Send "immediateInvariant" to the class to terminate'
	   ' class modification and allow instance creation.' ).
doit value: #rtErrDoesNotUnderstand value: err value:
    #('No method was found for the selector ' 2
	   ' when sent to ' 1 ' with arguments contained in ' 3 '.').
doit value: #objErrNotObjectSecurityPolicy value: err value:
    #('Invalid objectSecurityPolicyId ' 1 ' , ' 2 ).
doit value: #objErrNotIndexable value: err value:
    #('An attempt was made to index the object ' 1 ' that is not indexable.').
doit value: #rtErrCantPerform value: err value:
    #(1 ' cannot perform the selector ' 2 ' with the arguments in ' 3  '. '
      'Perform may have been attempted with wrong number of args.').
doit value: #classErrSubclassDisallowed value: err value:
    #('Cannot create a subclass of the class ' 1 '.').
doit value: #objErrNotInColl value: err value:
    #('The object ' 2 ' was not found in the collection ' 1 '.').
doit value: #rtErrBadPattern value: err value:
    #(1 ' is an illegal pattern for string comparisons.').

^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createRtErrs10


doit value: #assocErrBadComparison value: err value:
    #('The evaluation of a SelectBlock resulted '
	'in an illegal comparison being performed.').
doit value: #repErrIncompatibleRepos value: err value:
    #('The Repository version does not match the version '
	'of the GemStone executable.').
doit value: #assocErrClassModifiable value: err value:
    #('Index creation failed because the class ' 1 ' is modifiable.'
	' Send "immediateInvariant" to the class to enable index creation. '  ).
doit value: #classErrConstrInher value: err value:
    #('The constraint ' 1 ' is not a subclass of the inherited '
	' constraint ' 2 ' for offset ' 3 '.').
doit value: #rtErrBadDictConstraint value: err value:
    #('Only Association or one of its subclasses can be used as a constraint'
      ' in ' 1 '.').
doit value: #rtErrCantBecomeIndexedNsc value: err value:
    #('Become is not allowed because the object ' 1 ' is a kind of '
      ' Bag and currently has indexes').
doit value: #rtErrNoIndexForPath value: err value:
    #('An index with the path ' 2 ' was not found for the NSC.').
doit value: #rtErrBadSession value: err value:
    #('The specified session does not exist.').
doit value: #rtErrNotOnlyUser value: err value:
    #('An operation that requires exclusive use of the '
	'system was attempted when ' 1 ' users were logged in.').
doit value: #objErrMaxSize value: err value:
    #('An attempt was made to extend an object to size '
	2 ' when the maximum legal size is ' 3 ', object: ').
doit value: #rtErrInvalidMethod value: err value:
    #('Cannot execute method, ' 1 ).
doit value: #gciErrNoStartCmd value: err value:
    #('A request was made to complete a non-blocking GemBuilder for C call '
	'when no such call was initiated.').

^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createRtErrs11

doit value: #repErrMaxOnlineRepos value: err value:
    #('Too many repositories are already attached.').
doit value: #rtErrRcQueueEntriesFound value: err value:
    #('In attempting to reset the maximum session ID for the queue to a '
      'smaller value, an entry was found that was added by a session '
      'whose session ID is larger than the value currently being set. '
      'Remove and save all entries in the queue.  Then change the maximum '
      'session ID and add the saved entries back into the queue.').
doit value: #rtErrFirstPathTermSetValued value: err value:
    #('The first term in an NSC index path expression cannot indicate '
      ' a set-valued instance variable (i.e. cannot be an asterisk).').
doit value: #gciErrParentSession value: err value:
    #('The attempted GemBuilder for C operation is illegal in a user action '
      'when applied to a session owned by a parent GemBuilder for C or '
      'GemStone Smalltalk scope.' ) .
doit value: #gciErrAlreadyLoggedIn value: err value:
    #('The current GemBuilder for C (GCI) session is already logged in.').
doit value: #classErrBadIdentifier value: err value:
    #('An illegal identifier ' 1
	' was used to name an instance variable or class.').
doit value: #classErrConstrPrivateIv value: err value:
    #('Illegal attempt to constrain the private instanceVariable ' 1 ).
doit value: #rtErrNoPriv value: err value:
    #('An attempt was made to do a privileged operation '
	'for which no privilege had been granted.').
doit value: #rtErrInvalidBtreeReadStream value: err value:
    #('The BtreeReadStream is invalid (possibly due to modifications '
      'to objects referenced by the stream).').
doit value: #rtErrDecrNotAllowed value: err value:
    #('The RcPositiveCounter with value ' 3 ' cannot be decremented by ' 2 '.').
doit value: #repErrReposNotAttached value: err value:
    #('The Repository could not be attached.').
doit value: #repErrReposNeedsRecovery value: err value:
    #('The Repository needs recovery.').
doit value: #repErrReposRead value: err value:
    #('A disk read error was detected when reading from the Repository extent '
	2 ' on page number ' 1 '.').
doit value: #repErrReposWrite value: err value:
    #('A disk write error was detected when writing to the Repository extent '
	2 ' on page number ' 1 '.' ).
 doit value: #errIllegalRamSelf value: err value:
    #('Self is not a ram oop, method needs recompile.').

^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createRtErrs12

doit value: #rtErrSelectiveAbort value: err value:
    #('selectiveAbort illegal because ' 2 ', for object ' 1  ).
doit value: #objErrDateTimeOutOfRange value: err value:
    #( 'DateTime argument to GciDateTimeToCTime is out of range of time_t, or '
       'the seconds instance variable is not between 0 and 86399 inclusive.').
doit value: #objErrLongNotSmallInt value: err value:
    #('A C long used in a GemBuilder for C (GCI) call is not representable '
      'as a SmallInteger.').
doit value: #objErrNotLong value: err value:
    #('Argument to GciOopToLong or GciOopToInt64 , ' 1
  ', is not an Integer or is not representable in the C function result type.').
doit value: #objErrNotChr value: err value:
    #('GciOopToChr was passed an object which was not a Character.').
doit value: #lgcErrCompressFailure value: err value:
    #('compress() in the zlib library failed, status ' 1 ).
doit value: #lgcErrUncompressFailure value: err value:
    #('uncompress() in the zlib library failed.').
doit value: #lgcErrTravswizzFailure value: err value:
    #('travBuffSwizzle() in the linkgc module failed.').
doit value: #errArgTooLarge value: err value:
  #( 'The object ' 1 ' is too large, maximum size/value is ' 2  ) .
doit value: #commitPromoteFailed value: err value:
  #( 'Unable to promote commit to a checkpoint, ' 1 ) .
doit value: #objErrDiffSizeColl value: err value:
  #( 'Receiver and argument collections must be the same size' ).
doit value: #rtErrUalibLoadFailed value: err value:
    #('user action library load failed, ' 1 ).
doit value: #lgcErrObjRepHdrSize value: err value:
    #('Mismatch in size of GciObjRepHdrSType between GCI client and server.').

doit value: #authErrSegLoad value: err value:
    #('Unable to load auth cache, ' 1 ', for object ' 2 ).
doit value: #authErrSegRecursion value: err value:
    #('Infinite recursion when attempting load GsObjectSecurityPolicy with objectSecurityPolicyId ' 1
      ', the GsObjectSecurityPolicy is not in DataCuratorObjectSecurityPolicy.' ).
doit value: #assocErrPathTooLong value: err value:
    #('The path ' 1 ' has more than 1024 characters.').
doit value: #rtErrSemaphore value: err value:
    #('A semaphore operation failed on semaphore with index ' 1
	'.  Reason: ' 2  '.').
doit value: #repErrFileNameTooBig value: err value:
    #('The filename ' 1 ' has more than ' 2 ' characters.').
doit value: #rtErrPasswordTooBig value: err value:
    #('A password was specified with more than 1024 characters.').

^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createRtErrs13

doit value: #errNotSameClassHist value: err value:
    #('Migration is not allowed because the classes '
       1 ' and ' 2 ' do not have identical class histories.').

doit value: #classErrMethDictLimit value: err value:
    #('The class ' 1 ' has more than 1500 methods in its method dictionary.').
doit value: #rtErrShrPcDetach value: err value:
    #('Error occurred during SharedPageCache detach: ' 1).
doit value: #repErrCantDispose value: err value:
    #('Unable to dispose of the file ' 1 '.').
doit value: #rtErrInternal value: err value:
    #('Please report to your GemStone Administrator.  Internal Runtime Error:  '
	1 ' with arguments:  ' 2 ' ' 3 ' ' 4 ' ' 5 ' ' 6 ' ' 7 ' ' 8 ' ' 9
        ' ' 10 '.').
doit value: #rtErrBadStreamColl value: err value:
    #('An attempt was made to create an instance of ' 1
	' from the stream ' 2 ', but the collection in the stream is'
	' not a ' 3 '.').
doit value: #rtErrBadFormat value: err value:
    #('An attempt was made to create an instance of ' 1 ' from ' 2
	' but either the format is incorrect or the contents of ' 2
	' are incomplete.').
doit value: #segErrBadGroup value: err value:
    #(1 ' is not currently a group.').
doit value: #rtErrShrpcCompatibility value: err value:
    #('The compatibility level of the SharedPageCache Monitor' 1
      'does not match that of the executable trying to attach' 2).
doit value: #rtErrBadPriv value: err value:
    #(1 ' is not a valid privilege.').
doit value: #rtErrResolveSymFailed value: err value:
    #('GciResolveSymbol failed; the symbol is not defined').
doit value: #rtErrSymAlreadyDefined value: err value:
    #(2 ' is already defined.').
doit value: #rtErrSymNotFound value: err value:
    #(2 ' could not be found in the symbol list for ' 1 '.').
doit value: #rtErrEofOnReadStream value: err value:
    #('End of stream was encountered in ReadStream:  ' 1 '.').
doit value: #assocErrSortOddLengthArray value: err value:
    #('An illegal sorting was specified:  ' 1 '.').

^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createRtErrs14

doit value: #assocErrBadDirection value: err value:
    #('A sort direction must be ''ascending'' or ''descending'', not ' 1 '.').
doit value: #rtErrConfigReadOnly value: err value:
    #('GemStone Smalltalk access to the configuration parameter ' 1 ' is read-only.').

doit value: #rtErrBadFormatSpec value: err value:
    #(2 ' is an illegal formatting Array for ' 1 '.').
doit value: #hostErrFileExport value: err value:
    #('GemStone cannot export the string ' 1 ' to the file '
	2 ' in the server OS.').
doit value: #hostErrFileImport value: err value:
    #('GemStone cannot import the file ' 1 ' from the server OS.' 2 ).
doit value: #hostErrFileDirectory value: err value:
    #('GemStone cannot fetch the server OS directory ' 1 '.').
^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createRtErrs15
  " more runtime errors"

doit value: #hostErrFileDelete value: err value:
    #('GemStone cannot delete the file ' 1 ' from the server OS.').
doit value: #hostErrPerform value: err value:
    #('GemStone cannot execute "' 1 '" on the server OS shell, ' 2
       ' errno=' 3 ' rawStatus=' 4 ' childStatus=' 5 ).
doit value: #rtErrSigMsgTooBig value: err value:
    #('Attempt to send a string of size ' 2 ' bytes as argument to a signal. '
      'The maximum allowed size is ' 3 ' bytes.').
doit value: #objErrBadClusterBucket value: err value:
    #('The clusterId ' 1 ' is invalid. Max legal clusterId is ' 2 ' .' ).
doit value: #rtErrEpochGcArraySize value: err value:
    #('The number of elements in the Array used to set the Epoch Garbage '
      'Collector information is incorrect.  The size of ' 1
      ' should be 4.').
doit value: #objErrResultNscTooBig value: err value:
    #('The NSC operation failed; the size of the result would have exceeded '
      ' the maximum size for an NSC.' ).
doit value: #hostErrMemoryAlloc value: err value:
    #('Host memory allocation failed; there is insufficient '
      'swap space and/or RAM.').
doit value: #gciErrCatchBuffNotFound value: err value:
    #('A non-existent catch buffer was specified.').
doit value: #gciErrCatchBuffLimit value: err value:
    #('Catch buffer level is outside the range 0 to 20.').
doit value: #objErrNotBoolean value: err value:
    #('Argument to GciOopToBool() must be either OOP_TRUE or OOP_FALSE.').
doit value: #rtErrUncompiledMethod value: err value:
    #(' The method with source ' 2 ' in class ' 3 ' is obsolete after '
      ' schema modification and must be recompiled.' ).
doit value: #rtErrMustBeSystemUser value: err value:
    #('An operation was attempted that may only be performed by SystemUser.' ) .
doit value: #rtErrBadPassword value: err value:
    #('The given password is not the password of ' 1 '.').
doit value: #gciErrTravObjNotFound value: err value:
    #('Object not found in the traversal buffer.').
doit value: #gciErrTravCompleted value: err value:
    #('A continuation of a traversal was attempted when there '
	'was no traversal in progress.').

^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createRtErrs16

doit value: #gciErrTravBuffTooSmall value: err value:
    #('The traversal buffer was smaller than the minimum size '
      'GCI_MIN_TRAV_BUFF_SIZE (which is 2048)' ).
doit value: #rtErrPathToStrIvname value: err value:
    #('Path to String conversion starting with class ' 1 ' failed at term ' 2
	' because there is no named instance variable at offset ' 3
	' in class ' 4 ' that has ' 5 ' named instance variables.').
doit value: #objErrNegativeCount value: err value:
    #('In GciFetchBytes, GciFetchIdxOops, or GciFetchNamedOops, '
	'a negative count of ' 1 ' was specified.').
doit value: #gciErrResultPathTooLarge value: err value:
    #('GciStrToPath or GciPathToStr, result of size ' 1
	' is larger than specified max size of ' 2  '.').
doit value: #gciErrFetchPathFail value: err value:
    #('GciFetchPaths failed on a path; OOP_ILLEGAL substituted in '
        'result Array.').
doit value: #rtErrStrToPathIvname value: err value:
    #('String to path conversion starting with class ' 1 ' failed on path term '
      2 ' because there is no instance variable named ' 3 ' in class ' 4 '.').

doit value: #errAlmostOomPending value: err value:
    #('AlmostOutOfMemory after 2 attempts to signal as a Notification') .

doit value: #lgcErrTravRead value: err value:
    #('Socket error while reading traversal buffer from gci peer').
doit value: #lgcErrPacketKindBad value: err value:
    #('A packet of the wrong kind was received.  Expected: ' 1
	', Received: ' 2 '.').
doit value: #lgcErrExpectedContinue value: err value:
    #('A packet kind of ' 1 ' was received rather than '
	'the continue packet that was expected.').
doit value: #lgcErrOopPacketTooLong value: err value:
    #('An OOP Array packet was received over the network that was too long.').
^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createRtErrs17

doit value: #lgcErrPacketKindUnknown value: err value:
    #('An unknown packet kind was received: ' 1 '.').
doit value: #hostErrLogFileNotOpened value: err value:
    #('The log file was not opened before adding messages to it.').
doit value: #classErrMaxInstVars value: err value:
    #('An attempt was made to create a subclass of ' 1
	 ' with more than 2030 instance variables specified in ' 2 '.').
doit value: #rtErrTooManyErrArgs value: err value:
    #('System | signal:args:signalDictionary: was sent with '
	 'an Array argument containing ' 2 ' arguments, but it '
	 'is limited to 10.').
doit value: #objErrBadSize value: err value:
    #('For class ' 1 ' the size ' 2 ' is illegal.').
doit value: #lgcErrInconsistentSize value: err value:
    #('When using GemBuilder for C (GCI), the specified size ' 1
      'is inconsistent with the size ' 2 ' implied by other arguments.').

doit value: #lgcErrInconsistentObjKind value: err value:
    #('Inconsistent implementation received.  Class = ' 1
	 ', implementation = ' 2 '.').
doit value: #rtErrNscParticipatesInMultipleTerms value: err value:
    #('The NSC ' 1 ' is not allowed to participate in more than one term '
      'in an index path (' 2 ').' ).

doit value: #rtErrStartGc value: err value:
    #('A GcGem is already running, or a session that is attempting to run '
      'reclaim or epoch garbage collection is not the GcGem.').
doit value: #lgcErrSequenceMismatch value: err value:
    #('Sequence number mismatch for an IPC response packet.').
doit value: #rtErrExceptBlockNumArgs value: err value:
    #('The block ' 1 ' which takes ' 3 ' arguments, cannot be used as'
      ' an Exception block. Exception blocks require ' 2 ' arguments.').

doit value: #rtErrGciStoreFloat value: err value:
    #('An illegal GemBuilder for C (GCI) store into the float object ' 1
      ' was detected.  You must use GciStoreBytesInst with the correct class '
      'argument.') .

^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createRtErrs18

doit value: #rtErrGciStoreClassMismatch value: err value:
    #('Mismatch between class in store traversal buffer and class in Repository
       for object ' 1 '.  Class in buffer is ' 2 ' , class in Repository is '
      3).

doit value: #rtErrBadArgKind2 value: err value:
    #('The object ' 1 ' was neither of class ' 2 ' nor ' 3 ).
doit value: #lgcErrSequenceMismatch value: err value:
    #('Sequence number mismatch for an IPC response packet.').
doit value: #rtErrCommitDbInRestore value: err value:
    #('Commits are not allowed while a restore from backups or transaction'
      ' logs is in progress.').

doit value: #rtErrCommitDisallowed value: err value:
    #('Further commits have been disabled for this session because: ' 1
      '. This session must logout.' ).
doit value: #tranLogIoError value: err value:
    #('I/O error when writing the transaction log. This transaction must be aborted.').
doit value: #lgcErrPacketKind value: err value:
    #('Internal error:  Gem to Client packet kind is unknown or unexpected.').
doit value: #rtErrLoadSaveStack value: err value:
    #('Error ' 1 ' , '  2 ' . Execution cannot continue.').
doit value: #rtErrUnknownBytecode value: err value:
    #('Unknown opcode = ' 1 ' encountered during GemStone Smalltalk execution.').
doit value: #errSesBlockedOnOutput value: err value:
    #('Attempt to send signal to session ' 1 ' failed. Buffer from Stone to '
      ' that session is full.').
doit value: #errPrimNotSupported value: err value:
    #('Primitive failure, primitive for receiver= ' 1 ' selector= ' 2
      '  is not supported in this executable. You must run "' 3
     '" in order to use this method.') .
doit value: #authErrSegCurrentSeg value: err value:
    #('(OBSOLETE)No authorization write in your current security policy ' 1 '.' 'Resetting '
      'current security policy to default login security policy.' ).
doit value: #authErrSegSetCurrentSeg value: err value:
    #('No authorization to set the current security policy to ' 1 '.').
doit value: #rtErrPrimFailed value: err value:
    #('Primitive failed, receiver ' 1 ' selector ' 2 ' arguments ' 3 ' .').

^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createRtErrs19

doit value: #gciErrExecClientUserAct value: err value:
    #('Request to invoke client userAction named ' 1 ', invocation failed.').
doit value: #gciErrActiveSessions value: err value:
    #('You may not install a user action after logging in. Action name:  ' 1).
doit value: #gciErrMaxActionArgs value: err value:
    #('User action invoked with too many arguments. '
      ' action name ' 1 ' actual number ' 2 ' maximum number ' 3 ).
doit value: #gciErrBadNumMethodArgs value: err value:
    #('The method ' 1 ' takes ' 2 ' arguments, not ' 3 ' as passed.').
doit value: #gciErrUserActionPending value: err value:
    #('You attempted an illegal GemBuilder for C (GCI) operation during '
        'a user defined action ' 1 '.').
doit value: #gciErrBadNumUaActionArgs value: err value:
     #( 'You invoked a user action with the wrong number of arguments.'
        ' action name ' 1 ' correct number ' 2 ' actual number ' 3 ).
doit value: #rtErrInstvarAddToNsc value: err value:
     #( 'An attempt was made to add a named instance variable to '
	' the class ' 1 ' which has a format of NSC.' ).
doit value: #rtErrVaryingConstrBytes value: err value:
     #( 'An attempt was made to constrain the indexable portion'
	' of the class ' 1 ' which has a format of Bytes.' ).
doit value: #rtErrVaryingConstrNonidx value: err value:
     #( 'An attempt was made to constrain the indexable portion'
	' of the class ' 1 ' which is not indexable.' ).
doit value: #rtErrInstvarAddToBytes value: err value:
     #( 'An attempt was made to add a named instance variable to'
	 ' the class ' 1 ' which has a format of Bytes.' ).
doit value: #rtErrClassNotModifiable value: err value:
     #( 'The class ' 1 ' is not modifiable.' ).
doit value: #rtErrAddDupInstvar value: err value:
     #( 'The name of the new instance variable, ' 2 ', would'
	' duplicate the name of an existing instance variable in class ' 1 '.').
doit value: #rtErrNotASubclassOf value: err value:
     #( 'The class ' 1 ' is neither identical to nor a subclass of'
	' the class ' 2 '.').
doit value: #rtErrConstrNotSubclassOf value: err value:
     #( 'In a class modification operation, the new constraint ' 1
	' was neither identical to, nor a subclass of, the inherited '
        'constraint ' 2 '.' ).

^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createRtErrs2

doit value: #repErrMaxExtents value: err value:
    #('Attempt to create new extent failed because ' 1 ) .
doit value: #rtErrBadBlockArgCount value: err value:
    #('An attempt was made to evaluate the block or method ' 1 ' with ' 3
	   ' arguments when ' 2 ' were expected.').
doit value: #objErrCollectionEmpty value: err value:
    #('An attempt was made to access elements of the empty '
	   'collection ' 1 '.').
doit value: #rtErrArgNotChr value: err value:
    #('An attempt was made to store the object ' 1 ' into a string.').
doit value: #rtErrKeyNotFound value: err value:
    #('A reference using the non-existent key ' 2
       ' was made into the dictionary ' 1 ).
doit value: #rtErrBadDateTimeArgs value: err value:
    #('Invalid arguments given to DateTime instance creation.').
doit value: #genericKernelError value: err value:
    #( 'Error, ' 1 ) .
doit value: #rtErrNoSuchBp value: err value:
    #('The specified breakpoint does not exist.').
doit value: #repErrCantCreateFile value: err value:
    #('The system was unable to create the file ' 1 ', ' 2 ).
doit value: #numErrIntDivisionByZero value: err value:
    #('An attempt was made to divide ' 1 ' by zero.').
doit value: #rtErrSpecialOrNotCommitted value: err value:
    #('A committed object was expected rather than object ' 1 ', which is either special or uncommitted.').
doit value: #repErrPreGrowFailure value: err value:
    #('The extent ' 1 ' could not be created because of an attempt to '
      'initialize the file size when the disk was too full.').
doit value: #rtErrBeginTrans value: err value:
 #('An attempt was made to begin a new transaction when already in a transaction.').
doit value: #rtErrPrimOutsideTrans value: err value:
    #('An attempt was made to execute a primitive that is not allowed when not '
       'inside of a transaction.  Examples are: commit, backup and restore.').

^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createRtErrs20

doit value: #rtErrConstrNotAClass value: err value:
     #( 'The new constraint ' 1 ' was not a class.').
doit value: #rtErrObjInvariant value: err value:
     #( 'The object ' 1 ' is invariant.' ).
doit value: #classErrDupVarConstr value: err value:
     #( 'Two constraints, ' 1 ' and ' 2 ', were specified upon the '
	'indexable portion of the class. Only one constraint is allowed.' ).

doit value: #bkupErrLoginsEnabled value: err value:
     #( 'A restore operation requires that logins be disabled.'
        ' Run   System suspendLogins    before doing restores.').
doit value: #classErrRemoveInherIv value: err value:
     #( 'In class ' 1 ', an attempt was made to remove the '
	' instance variable ' 2 ' which is inherited from a superclass.' ).
doit value: #concurErrInvalidMode value: err value:
     #( 1 ' is not recognized as a valid Concurrency Control Mode.' ).
doit value: #classErrSelectorLookup value: err value:
     #( 'The message ' 4 ' sent to object ' 1 ' was found in class '
         2 '. It should have been found in class ' 3 ).
doit value: #rtErrBadEUCFormat value: err value:
     #('The bytes of the EUCString with oop ' -1 ' are not in EUC format.').
doit value: #rtErrGaijiNotSupported value: err value:
     #('A Gaiji Character was encountered in the JapaneseString '
         1 ' but Gaiji is not supported.').
doit value: #rtErrInvalidArgClass value: err value:
     #(1 ' is not one of the class kinds in ' 2 '.').
doit value: #rtErrSizeLimit value: err value:
     #('The object ' 1 ' was referenced with a byte index ' 2
                        ' which is out of range.').
doit value: #rtErrNoEUCRep value: err value:
     #(1 ' cannot be represented in EUC format.').
doit value: #rtErrBadEUCValue value: err value:
     #(1 ' is not a valid EUC value and does not correspond to '
                        'a JISCharacter.').
doit value: #rtErrInvalidLang value: err value:
     #('The compiler language environment ' 1 ' is invalid.').
doit value: #rtErrInvalidIndexPathExpression value: err value:
     #('The following string is an invalid term in a path expression: ' 2 ).
doit value: #rtErrDependencyListTooLarge value: err value:
     #('A dependency list ' 1 ' is too large.').
doit value: #rtErrMaxCommitRetry value: err value:
    #('There were too many attempts to commit after a concurrency conflict '
       'or after failing to resolve RC conflicts.  You must abort before '
       'attempting to commit again.').
doit value: #rtErrInvalidArgument value: err value:
    #( 'The object ' 1 ' was an invalid argument to a method, reason: ' 2 ).

^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createRtErrs21

doit value: #rtErrPathNotTraversable value: err value:
    #( 'The class ' 2 ' does not have an instance variable ' 3
       ' on the index path.').
doit value: #rtErrBtreeReadStreamEndOfStream value: err value:
    #( 'An attempt was made to read beyond the end of the stream. ').
doit value: #rtErrObjectPathTermNotInDependencyList value: err value:
    #( 'The object ' 1 ' did not have the path term ' 2 ' in its dependency list. ').
doit value: #rtErrObjectInvalidOffset value: err value:
    #( 'The object ' 1 ' does not have an instance variable with the given name ' 2).
doit value: #rtErrObjectNoDependencyList value: err value:
    #( 'The object ' 1 ' does not have a dependency list. ').
doit value: #rtErrIndexDictionaryEntryNotInDictionary value: err value:
    #( 'An entry for the key/term/value (' 2 '/' 3 '/' 4 ') was not present in the dictionary ' 1 ).
doit value: #rtErrPathTermObjectNotAnNsc value: err value:
    #( 'The object ' 1 ' traversed along an index path through a set-valued '
       'instance variable was not an NSC. ' ).
doit value: #rtErrIdentityIndexCannotInvokeRangeOperation value: err value:
    #( 'An attempt was made to use a range operation ( <, >, =, <=, or >= ) on a path '
       'expression only supported by an identity index.').
doit value: #rtErrRangeEqualityIndexInvalidClassKindForBtree value: err value:
    #( 'Attempt to insert a key of class ' 1 ' for path term ' 2
       ' into the B-tree that is an invalid class for which the B-tree was created ( ' 3 '). ').
doit value: #rtErrRangeEqualityIndexObjectNotInBtree value: err value:
    #( 'An entry for the key/value pair (' 2 '/' 3 ') was not present in the index.' ).
doit value: #errNoBackupInProgress value: err value:
    #( 'A backup or restore continuation was attempted before
        executing either restoreFrom: or fullBackupTo:MBytes: . ').
doit value: #bkupErrOpenFailed value: err value:
    #( ' An attempt to open file ' 1 ' for ' 2 ' failed because ' 3 '.').
doit value: #bkupErrMbyteLimitBadRange value: err value:
    #( 'The byte limit specified ' 1 ' is out of the allowable '
        ' range from ' 2 ' to ' 3 ' MBytes.').
doit value: #bkupErrWriteFailed value: err value:
    #( 'An attempt to write to file ' 1 ' failed because ' 2 '.'
       'This error terminates the backup and the backup file is not usable.').
doit value: #bkupErrInProgress value: err value:
    #( 'An attempt was made to start a full backup, '
       'but a backup is currently in progress by another session.').
doit value: #bkupErrReadFailed value: err value:
    #( 'Restore failed, file read error ' 1 ', file name ' 2 ' record ' 3 ).
doit value: #bkupErrNotInProgress value: err value:
    #( 'An attempt to continue a full backup when no backup is in progress.' ).

^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createRtErrs22

doit value: #rtErrBagClassDoesNotSupportRangeOperators value: err value:
    #( ' An attempt was made to create an equality index with a class ' 2
       ' that does not support range operators. ' ).
doit value: #rtErrBagOnlySelectBlockAllowed value: err value:
    #( ' Only select blocks are allowed for selectAsStream. ' ).
doit value: #rtErrBagOnlyOnePredicateAllowed value: err value:
    #( ' Only one predicate is allowed for selectAsStream. ' ).
doit value: #rtErrBagNoRangeIndexOnPathExpression value: err value:
    #( ' The path expression in the predicate for selectAsStream does '
       'not have a range equality index. ' ).
doit value: #rtErrBagInvalidPredicateForStreamSelection value: err value:
    #( ' The predicate for selectAsStream was invalid. ' ).
doit value: #rtErrBagOperationNotSupportedForStreamSelection value: err value:
    #( ' The comparison operation in the predicate for selectAsStream is '
       'not supported. ' ).
doit value: #rtErrBagInvalidSortSpecification value: err value:
    #( ' Unable to sort using the sort specification: ' 2 ).
doit value: #rtErrIndexAuthErrSegRead value: err value:
    #('(OBSOLETE) An attempt was made to read the object using index ' 2
        ' in security policy ' 3 ' with insufficient authorization.').
doit value: #objErrTime_tOutOfRange value: err value:
    #( 'Given time_t is out of range; must be greater '
	   'than or equal to zero.').
doit value: #genericError value: err value:
    #( 'User defined error, ' 2 ) .
doit value: #rtErrMethodProtected value: err value:
    #( 'Illegal attempt to execute a protected method. ' ) .
"rtErrPreventingCommit deleted"
doit value: #rtErrRemoveAllIndexesFailed value: err value:
    #( '  An attempt to remove all indexes on ' 1 ' has failed. Index participation info: ' 2 '.').
doit value: #rtErrCollectionWithIncompleteIndex value: err value:
    #( '  An attempt was made to create an index on a collection that has incomplete indexes.'
       ' The incomplete indexes must be removed before creating new indexes.' ).
doit value: #rtErrCantBecomeSelfOnStack value: err value:
    #( 'Object ' 1 ' is present on the GemStone Smalltalk stack as "self", and '
       'cannot participate in become: or changeClassTo:' ).
doit value: #rtErrObjectProtected value: err value:
    #( 'Illegal attempt to fetch/store into a protected object. ' ) .
doit value: #rtErrNewTranlogDirFail value: err value:
    #( 'Attempt to define new transaction log directory failed, reason: ' 1 ).
doit value: #rtErrNoMoreObjectSecurityPolicies value: err value:
    #( 'No more security policies can be created. The object SystemRepository has reached maximum allowed size.' ).
doit value: #rtErrNotInExportSet value: err value:
    #( 'During GciStoreTravDoTravRefs, OOP ' 1 '  was not found in ExportSet' ).
doit value: #rtErrGciTravNotLicensed value: err value:
    #( 'License does not allow Gci Traversal operations.').
doit value: #rtErrExceptionAlreadyInstalled value: err value:
    #( 'ensure block already installed in the current frame'  ).
doit value: #rtErrCommitDisallowedUntilAbort value: err value:
    #('Commits are disabled until after the next abort because: ' 1
      '  The session must abort.').

^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createRtErrs23

doit value: #errCommitWhileBackupInProgress value: err value:
    #( 'A commit or abort was attempted while a multi-file full backup is '
       'in progress.  This may have been caused by mistakenly repeating the '
       'fullBackupTo:MBytes: method instead of using the '
       'continueFullBackupTo:MBytes: method.  '
       'To cancel the backup use the abortFullBackup method. '
       'To continue the backup use the continueFullBackupTo:MBytes: method.').
doit value: #errUnconvertedObject value: err value:
    #( 'Incomplete conversion from previous version of GemStone, object: '
       1 ' reason: ' 2 ).
doit value: #rtErrCommitProhibitingError value: err value:
    #(1 '  This error occurred during object manager recursion to GemStone '
      'Smalltalk.  This transaction must be aborted.').
doit value: #rtErrAttemptToPassivateInvalidObject value: err value:
    #( 'Attempted to write ' 1 ' to a passive object.  '
       'nil was written instead.').
doit value: #rtErrTimeToRestoreToArg value: err value:
    #( 'timeToRestoreTo: failed, reason:  ' 1 ).
doit value: #lockErrAllSymbols value: err value:
    #('Users are not allowed to lock AllSymbols').
doit value: #gciErrSymbolFwdRef value: err value:
    #('User attempted to create a forward reference, OOP = ' 1
      ' to a Symbol or fill in the state of an existing forward reference'
      ' as a Symbol').
doit value: #rtErrChangeSymbol value: err value:
    #('Changing the class of an object ' 1
       ' from or to class Symbol is disallowed').
doit value: #rtErrObjVariant value: err value:
     #( 'The object ' 1 ' is not invariant.' ).
doit value: #rtErrAlreadyHasSubclasses value: err value:
     #( 'In disallowSubclasses, ' 1 ' already has subclasses.' ).
doit value: #clientForwarderSend value: err value:
     #( 'Message to forward to client, forwarder: ' 1 ' receiver: ' 2 '
          selector: ' 3 ' args: ' 4 ).
doit value: #rtErrBadSize value: err value:
     #( 'Invalid object size, required size ' 2 ' actual size ' 3
        ' for object ' 1) .
doit value: #rtErrFreeSpaceThreshold value: err value:
     #( 'The Repository is currently running below the freeSpaceThreshold.').
doit value: #rtErrTranlogDirFull value: err value:
     #( 'All transaction log directories are full. The Stone process is '
        'waiting for an operator to make more space available by either '
        'cleaning up the existing files (copying them to archive media and '
        'deleting them) or by adding a new transaction log directory.').
^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createRtErrs24
  " more runtime errors"
doit value: #rtMaxPasswordSize value: err value:
     #( 'The maximum size of a password is ' 2 ' characters.  The string '
        1 ' is too large.' )  .
doit value: #rtMinPasswordSize value: err value:
     #( 'The minimum size of a password is ' 2 ' characters.  The string '
        1 ' is too small.' )  .

doit value: #rtMaxRepeatingChars value: err value:
  #( 'A password may not have more than ' 2 ' repetitions of a Character. '
     ' The substring ' 3 ' is invalid in the password ' 1 ).

doit value: #rtMaxConsecutiveChars value: err value:
  #( 'A password may not have more than ' 2 ' consecutive characters. '
     'The substring ' 3 ' is invalid in the password ' 1 ).

doit value: #rtMaxCharsOfSameType value: err value:
  #( 'A password may not have more than ' 2 ' consecutive ' 3 ' characters. '
     'The substring ' 4 ' is invalid in the password ' 1 ).

doit value: #rtDisallowedPassword value: err value:
  #( 'A password may not have the value ' 1 ) .

doit value: #rtErrWarningPasswordExpire value: err value:
  #( 'The password of the current UserProfile is about to expire.' ).

doit value: #errLogDirNotExist value: err value:
  #( 'Directory or raw device not found, ' 1 ) .

doit value: #errArgTooSmall value: err value:
  #( 'The object ' 1 ' is too small, minimum size/value is ' 2  ) .

doit value: #errNoStructuralUpdate value: err value:
  #( 'GemBuilder for C (GCI) update operation ' 2
     ' is not supported on object ' 1 ) .

doit value: #rtObsoleteClass value: err value:
  #( 'New instances of this obsolete class are not allowed.' ).

^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createRtErrs25


doit value: #rtErrLocalSessionFailedCommit value: err value:
  #( 'Local session failed to commit after remote sessions voted to commit.').

doit value: #rtErrRemoteSessionFailedCommit value: err value:
  #('Remote session ' 2 ' failed to commit after voting affirmative.').

doit value: #rtErrNoElemDetected value: err value:
  #('The object ' 2 ' was not detected in ' 1 '.').

doit value: #rtErrDateTimeOutOfRange value: err value:
  #('The resulting DateTime object would be out of range.').

doit value: #rtErrObjNotFound value: err value:
  #('The object ' 2 ' was not found in ' 1 '.').

doit value: #rtErrFailedStnCfgWrite value: err value:
  #( 'The operation should update the Stone configuration file, '
     'but the write failed.  See Stone log for more details.' ).

doit value: #gciErrNoUserAction value: err value:
  #( 'Attempt to call a user action that is not registered with this '
     'virtual machine, user action name: ' 1 ).

doit value: #segErrMaxUserProfileGroups value: err value:
    #('An attempt was made to add the UserProfile ' 1 ' to the group ' 2
	   ' when the UserProfile was already a member of four groups.').

doit value: #rtErrGsCommitListNBTimeout value: err value:
    #('During synchronized commits, session ' 2 ' timed out.').

doit value: #rtErrGcGemStartupFailures value: err value:
    #('Warning: Stone has logged GcGem startup failures since last success').

doit value: #rtErrGsSocket value: err value:
    #('A GsSocket method failed due to a socket error.').

doit value: #rtErrGsSocketInvariant value: err value:
    #('The GsSocket object ' 1 ' that was not changable was sent a '
      'message that would have required it to change.').

doit value: #rtErrLostSessionState value: err value:
    #('The object ' 1 ' that has transient session state has lost that '
      'transient state.') .

^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createRtErrs26

doit value: #rtErrDelayInProgress value: err value:
    #('The interval delay object ' 1 ' already has a process waiting on it.').

doit value: #rtErrSchedulerDeadlocked value: err value:
    #('The process scheduler object ' 1 ' is deadlocked.').

doit value: #authErrProcessSwitch  value: err value:
    #('Processor scheduler cannot switch processes while a primitive
      is within a bypass-authorization block' ).

doit value: #rtErrPrimitiveSysErr value: err value:
    #('A primitive failed with the following system error: ' 1).

doit value: #rtErrGsProcessTerminated value: err value:
    #('A main GsProcess was sent the terminate message.').

doit value: #rtErrNoMoreCBuffers value: err value:
    #('All available CBuffers are in use.').

doit value: #rtErrRemoteError value: err value:
"    #('A GemBuilder for C error occurred on the remote host: ' 2). "
    #('Remote Error: ' 2).

doit value: #rtErrRemoteLoginFailed value: err value:
    #('Remote logins to this repository are disabled by the keyfile.').

doit value: #rtErrClientFwd value: err value:
    #('The client encountered an uncaught exception, client error number ' 1
      'when a message was forwarded.  The client error message is: ' 2
      'The stack trace from the client is: ' 3).
doit value: #rtErrBadGsProcessArgCount value: err value:
    #('An attempt was made to create a GsProcess for the block ' 1 ' with ' 3
	   ' arguments when ' 2 ' were expected.').
doit value: #rtErrPasswordNotVariant value: err value:
    #('The password for session parameters must be variant.').
doit value: #rtErrNotEnoughCBuffers value: err value:
    #('There are not any more C buffers available to allocate a new one.').

doit value: #rtErrGsProcessNotDebuggable value: err value:
    #('The gsprocess ' 1 ' is not in a debuggable state.').

doit value: #gciErrArgNotPairs value: err value:
    #('The argument must be an Array with pairs of objects and booleans, of maximum size 20.').

doit value: #rtErrClientActionDisallowed value: err value:
    #('An attempt was made to execute the client user action ' 1
       ' from a session that is not allowed to do this.').

^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createRtErrs27

doit value: #rtErrRemoveSpecialUser value: err value:
    #('An attempt was made to remove the userProfile with userId ' 1
       ' from AllUsers.').

doit value: #errLostOtHandlingFailed value: err value:
    #('Fatal error during lostOt handling, sharedOt cache may be invalid.').

doit value: #rtErrExceptionAlreadyInstalled value: err value:
    #('ExecBlock>>ensure: exception already installed in frame, for block ' 1).

doit value: #rtErrNativeCodeGen value: err value:
    #('Native code error, ' 1 ).

doit value: #rtErrNativeCodeNoBreakpts value: err value:
    #('Breakpoints and single-step not supported in native code' ).

doit value: #rtErrDynIvDependencyTag value: err value:
    #('Cannot add or modify a dynamic instance variable in an object with a dependency tag, object: ' 1 ).

doit value: #rtErrDynIvStore  value: err value:
    #('cannot store because ' 2 '; receiver: ' 1  ) .

doit value: #rtErrComExpressionDepth value: err value:
    #('expression nesting too deep in method source, increase GEM_TEMPOBJ_SCOPES_SIZE in gem config file.').

doit value: #ansiNotification value: err value:
    #('Notification signalled, ' ).

doit value: #rtErrReposUpgradeNeeded value: err value:
    #( 'Repository upgrade needed' ) .

doit value: #rtErrCannotConvertStack value: err value:
    #('Cannot convert native stack to portable stack, ' 1 ) .

doit value: #rtErrRcUpdateDisallowed value: err value:
    #('An attempt was made to update an RC object in a continued transaction. '
      'The transaction must be aborted.').

doit value: #rtErrGetGcLockFailed value: err value:
    #('Request for gcLock timed out. ' 1 ).

doit value: #rtErrCantBecomeGeneric value: err value:
    #('become is not allowed on ' 1 ', ' 2 ).

doit value: #rtErrOpNotAllowed value: err value:
    #('The current operation is not allowed at this time, reason: ' 1 ).

doit value: #rtErrInvalidAuthSchemeId value: err value:
    #('Invalid authentication scheme id: ' 1 ).

doit value: #rtErrInvalidAuthSchemeSymbol value: err value:
    #('Invalid authentication scheme symbol: ' 1 ).

doit value: #rtErrInvalidUnixUserId value: err value:
    #('The specified UNIX user ID is invalid: ' 1 ).

doit value: #rtErrIllegalAuthSchemeChange value: err value:
    #('Illegal attempt to modify authentication scheme of a special UserProfile: ' 1 ).

doit value: #rtErrAuthIllegalOperation value: err value:
    #('Attempt to perform an illegal operation under the current authentication scheme. '
      'UserProfile: ' 1   '  AuthScheme: ' 2 ).

doit value: #rtErrAuthIllegalPasswordChange value: err value:
    #('Attempt to change the password of a UserProfile that is not using GemStone authentication. '
      'UserProfile: ' 1 ).

doit value: #rtErrIllegalPasswordExpiration value: err value:
    #('An attempt was made enable password expiration for a special UserProfile. ' 1 ).

doit value: #rtErrIllegalDn value: err value:
    #('The string is not a valid distinguished name or does not contain the %s pattern. ' 1 ).

doit value: #errSslLibLoadFailed value: err value:
    #('GemStone was unable to load the OpenSSL shared libraries.  Reason: ' 1 ).

doit value: #rtErrGroupAlreadyExists value: err value:
    #('An attempt was made to create a UserProfileGroup with a name that already exists.  Name: ' 1 ).

doit value: #rtErrPrincipalAlreadyExists value: err value:
    #('An attempt was made to create a Kerberos principal with a name that already exists.  Name: ' 1 ).

doit value: #rtErrGsSecureSocket value: err value:
    #('A GsSecureSocket method failed due to an error.').
doit value: #rtErrRollbackDlFail value: err value:
    #('Rollback of a specific dirty list not allowed after commit failure,
       session must abort entire transaction.').

^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createRtErrs3

doit value: #objErrInvariant value: err value:
    #('Attempt to modify the invariant object ' 1 ).
doit value: #classErrMethCatExists value: err value:
    #('An attempt was made to create the method category ' 2
	   ' which already exists.  Class:  ' 1 '.').
doit value: #classErrSelectorNotFound value: err value:
    #('A reference was made to the selector ' 2
	   ' which could not be found in the class ' 1
	   ' method dictionary.').
doit value: #classErrMethCatNotFound value: err value:
    #('In searching the class ' 1 ' the category name ' 2 ' was not found.').
doit value: #lockErrRemove value: err value:
    #('The user is not allowed to remove a lock on an object ' 1
      ' that they do not have a lock on.').
doit value: #classErrByteObjInstVars value: err value:
    #('An attempt was made to create a byte subclass with '
	   'instance variables.  Superclass:  ' 1 '.').
doit value: #classErrInvariantSuperClass value: err value:
    #('An attempt was made to create a variant subclass of an '
	   'invariant class.').
doit value: #classErrNscNotIndexable value: err value:
    #('An attempt was made to create an indexable subclass of '
	   'the NSC class ' 1 '.').
doit value: #repErrExtentNotMounted value: err value:
    #('The extent with filename or extentId: ' 1 ' , '
       ' was not part of the Repository.').
doit value: #rtErrPagesNeedScavenging value: err value:
    #('Attempt to schedule pages for scavenging failed because '
       'some other session had the commit token.  Try again later.').
doit value: #classErrNscInstVars value: err value:
    #('An attempt was made to create an NSC subclass ' 1
	   ' with instance variables.').
doit value: #classErrClassVarNameExists value: err value:
    #('An attempt was made to create the new class variable ' 2
	   ' with the same name as an existing class variable in class '
	   1 '.').
doit value: #classErrPoolDictExists value: err value:
    #('An attempt was made to add the dictionary ' 2
	   ' to a shared pool of class ' 1
	   ' in which it was already a member.').

^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createRtErrs4

doit value: #classErrPoolDictNotFound value: err value:
    #('An attempt was made to remove the dictionary ' 2
	   ' from the shared pool of class ' 1
	   ' in which it was not a member.').
doit value: #clampErrNoSuchInstvar value: err value:
    #('During clamp compilation for class ' 1
	   ' an instance variable clamp was encountered for '
	   ' non-existent instance variable ' 2 '.').
doit value: #clampErrNotAClass value: err value:
    #('An object ' 1 ' was specified for instance '
	   'variable clamping that was not a class object.').
doit value: #clampErrNotAClampspec value: err value:
    #('In an attempt to perform clamped object traversal, the '
	   'specified object ' 1 ' was not a ClampSpecification object.').
doit value: #clampErrBadArg value: err value:
    #('The object ' 1 ' has an implementation or size not allowed'
	   ' in clamp specifications.').
doit value: #repErrBadExtentSize value: err value:
    #('The given maximum extent size (' 1 ') is smaller than the '
	   'minimum size (' 2 ') allowed for an extent.').
doit value: #repErrCantOpenFile value: err value:
    #('The file ' 1 ' could not be opened.').
doit value: #rtErrNoSuchInstVar value: err value:
    #('The instance variable ' 2 ' was not found in evaluating '
	   'a path expression for the object ' 1 '.').
doit value: #rtErrTagNotAllowed value: err value:
    #('An attempt was made to put a tag on the object '
	   1 ' which does not support tags.').
doit value: #rtErrBadTagNum value: err value:
    #('The tag index ' 2 ' requested for object ' 1 ' is not '
	   ' allowed, max tag index is ' 3 ).
doit value: #segErrMaxSegGroups value: err value:
    #('(OBSOLETE) An attempt was made to add the group ' 2
	   ' to the security policy ' 1 ', which already recognizes four groups.').
doit value: #rtErrNoMessage value: err value:
    #('There is no error message for the error ' 1
	   ' in the SymbolDictionary ' 2 '.').
doit value: #segErrBadAuthKind value: err value:
    #('An attempt was made to change the authorization for '
	   'the security policy ' 1 ' to the unrecognized value ' 2 '.').
doit value: #rtUnresolvedFwdRefs value: err value:
    #('Commit failed. GciCreate/GciStore have left unsatisfied'
                 ' forward references to the objectId ' 1 '.'
                 '  Create the object with GciCreate and retry commit.').

^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createRtErrs5

doit value: #rtErrArgNotPositive value: err value:
    #(1 ' was found where a positive numeric value was expected.').
doit value: #rtErrArgOutOfRange value: err value:
    #('Argument is too large or out of range: ' 1
       ', allowed range is ' 2 ' to '  3 ).
doit value: #rtErrCannotChgConstraint value: err value:
    #('A constraint cannot be changed in a Dictionary that is not empty.').

doit value: #rtErrStackLimit value: err value:
    #('Smalltalk execution stack error, ' 1 ).
doit value: #rtErrStackLimitRed value: err value:
    #('Smalltalk execution stack overflow, Red Zone.').
doit value: #rtErrNewStackLimit value: err value:
    #('The value ' 1 ' specified for the new stack limit'
 ' is too large or is smaller than the current size of the execution stack.' ).
doit value: #numErrArgNotChr value: err value:
    #('An attempt was made to coerce the integer ' 1
	   ' into a ' 2 ', but its value was not in range.').
doit value: #numErrFltException value: err value:
    #('A floating point exception of type ' 1 ' was raised on the operation '
      2 '.  The default result is ' 3 '.  The first argument is ' 4 '.').
doit value: #numErrArgNotFltException value: err value:
    #('An unrecognized float exception ' 1 ' was specified.').
doit value: #numErrArgNotRoundingMode value: err value:
    #('An unrecognized float rounding mode ' 1 ' was specified.').
doit value: #segErrCantMoveObj value: err value:
    #('An attempt was made to change the security policy of '
	   'the special object or symbol ' 1 '.').
doit value: #rtErrExceptionNotLinked value: err value:
    #('An attempt was made to unlink an exception ' 1
	   ' that is not installed.').
doit value: #numErrArgNotFltStatus value: err value:
    #('An invalid float status ' 1 ' was specified.').
doit value: #lockErrUndefinedLock value: err value:
    #('A request to lock object ' 1 ' using an invalid kind ' 2 '.').

"rtErrHardStackLimit deleted"

doit value: #lockErrIncomplete value: err value:
    #('One or more of the locks you requested was denied or is dirty.').
doit value: #lockErrObjHasChanged value: err value:
    #('A request to lock object ' 1 ' was granted, but the object '
	   ' has been read or written since you started this transaction.').
doit value: #lockErrDenied value: err value:
    #('A request to lock object ' 1 ' with lock kind ' 2 ' was denied.').
doit value: #rtErrMaxClusterId value: err value:
    #('A request to create a new ClusterBucket exceeded the maximum '
      'size allowed for a clusterId = ' 1 '.').
doit value: #lockErrDeadlock  value: err value:
    #('A request to lock object ' 1 ' might deadlock.') .
doit value: #lockErrTimeout  value: err value:
    #('A request to lock object ' 1 ' timed out.') .
doit value: #lockErrInvalidObject  value: err value:
    #('Lock queue already bound to a different object, ' 1 ).
doit value: #rtErrLrgIntOverflow value: err value:
    #('Integer overflow, an Integer would exceed 130144 bits.').
doit value: #rtErrCompilerBadIr value: err value:
    #('Invalid IR input to code generator, ' 1 ).
doit value: #errPrintf value: err value:
    #('Error parsing format string, ' 1 ).
doit value: #errBadIvName value: err value:
    #('Invalid instVar name, ' 1 2 ).
doit value: #errRangeErr value: err value:
    #('RangeError,  ' 1 ).
doit value: #errTypeErr value: err value:
    #('TypeError,  ' 1 ).
doit value: #errArgumentErr value: err value:
    #('ArgumentError,  ' 1 ).
doit value: #errRubySystemExitErr value: err value:
    #('SystemExit Error,  ' 1 ).
doit value: #errMemoryRegionFull value: err value:
    #('The memory region ' 1 ',  is full.' ).
doit value: #rtErrNotPowerOfTwo value: err value:
    #('The value ' 1 ' was expected to be a power of 2.' ).
doit value: #rtErrPasswordMissingChar value: err value:
    #('The password must contain at least one character of type: ' 2 ).
doit value: #errDuringMtOperation value: err value:
   #('An error occurred during a multi-threaded operation: ' 1 ).
doit value: #authErrStoreTrav value: err value:
   #('Attempt to change GsObjectSecurityPolicy via store traversal. ' 1 ) .
^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createRtErrs6

doit value: #rtErrBadErr value: err value:
    #('An attempt to signal error ' 1 ' in dictionary ' 3
       ' was made, but the signal number ' 1 ' is less than one.').
doit value: #rtErrUserIdAlreadyExists value: err value:
    #('An attempt was made to add a UserProfile to the UserProfileSet ' 1
	   ' which already has an entry with the same userId:  ' 2 '.').
doit value: #rtErrCantReturn value: err value:
    #('Execution could not return from the current Activation, ' 1 ).
doit value: #rtErrCantChangeClass value: err value:
    #('An illegal attempt was made to change the class of '
	   'object ' 1 ' to class ' 2 ' ; ' 3 ).
doit value: #rtErrCantBecomeSpecial value: err value:
    #('An attempt was made to use become on the object ' 1
	   ' that has a special implementation.') .
doit value: #rtErrGarbageCollect value: err value:
    #('Attempt to run markForCollection when not the only user on the '
      'system and the concurrency mode is set for NO_RW_CHECKS_NO_READ_SET.').
doit value: #rtErrPrimNotFound value: err value:
    #('Primitive number ' 1 ' does not exist in the virtual machine.') .
doit value: #rtErrNilKey value: err value:
    #('An illegal attempt was made to store nil '
      'as a key in the dictionary ' 1 '.').
doit value: #rtErrNoInstVars value: err value:
    #('An attempt was made to directly access the instance '
	   'variables of the object ' 1
	   ' but the object has no instance variables.').
doit value: #rtErrExpectedBoolean value: err value:
    #('Expected ' 1 ' to be a Boolean.').
doit value: #rtErrDirtyObjsNeedsInit value: err value:
  #('GciDirtyObjsInit must be executed at least once before GciDirtySaveObjs.').

doit value: #rtErrWeakDictNeedsInit value: err value:
  #('GciWeakDictInit must be executed before other weak dictionary calls.').

doit value: #rtErrCantChangePassword value: err value:
    #('An illegal attempt was made to change the password '
	   'of ' 1 ', which is not the UserProfile '
           'of the current session.').

doit value: #rtErrBadCopyFromTo value: err value:
    #('An invalid index range was specified for a sequenceable collection '
           'starting index ' 1 ', ending index ' 2 '.').

doit value: #rtErrCantBecomeBothIdx value: err value:
    #('Both the receiver and argument of become participate in indexes. '
      'Become is not allowed because they are not of the same class.  '
      1 ' , ' 2   ) .

doit value: #rtErrSymbolTooLarge  value: err value:
    #('Cannot create a Symbol, String exceeds 1024 Characters. ' 1 ).

doit value: #rtErrOmFlushFailed  value: err value:
    #('Cannot commit, ' 1 ).

doit value: #rtErrNoExistingSymbol  value: err value:
    #('Message send failed, there is no Symbol with the value ' 1 ).

doit value: #rtErrObjMustBeCommitted value: err value:
    #('The object ' 1 ' is a temporary object but is required to '
      'be a committed object. ' 2 ).

doit value: #rtErrCantWriteFile value: err value:
    #('Error writing to file ' 1 '.  errno=' 2 ' message=' 3 ).

doit value: #rtErrCantReadFile value: err value:
    #('Error reading file ' 1 '.  errno= ' 2 ' message=' 3 ).

doit value: #rtErrFileCorrupt value: err value:
    #('The file ' 1 ' is corrupt, ' 2).

doit value: #rtErrGcCommitFailure value: err value:
    #('A commit during a garbage collection operation failed.').

doit value: #rtErrSymbolCreateErr value: err value:
    #('Symbol creation not allowed, ' 1 ', symbol value ' 2 ) .

doit value: #rtErrObjIsNp value: err value:
    #('The object ' 1 ' may not be committed, ' 2 ) .

doit value: #rtErrSuperclassIsNP value: err value:
    #('Cannot make instances of ' 1 ' persistent because instances of superClass are non-persistent.' ) .

doit value: #rtErrContinueTransFail value: err value:
    #('continueTransaction failed, ' 1 ).

doit value: #rtErrMethodSrcInvalid value: err value:
    #(' invalid method source string').

doit value: #lgcErrTravBuffSize value: err value:
    #(' Traversal buffer received over the network exceeds destination allocatedBytes ' ).

doit value: #rtErrAbortWouldLoseData value: err value:
    #('A method that requires an abort is being executed, however, an abort would result in lost data.').

doit value: #gciErrCallNotSupported value: err value:
    #('This GCI call is not supported when invoked from a client user action.' ).

^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createRtErrs7

doit value: #rtErrNoProcessToContinue value: err value:
    #('The Process ' 1 ' to continue from is invalid,' 2).
doit value: #rtErrBadStreamPosition value: err value:
    #('An attempt was made to set the Stream ' 1
	   ' to position ' 2 ' beyond the limits of the collection.').
doit value: #rtErrBadArgKind value: err value:
    #('The object ' 1 ' was not of the expected class ' 2 '.').
doit value: #classErrClassVarNotFound value: err value:
    #('An attempt was made to remove the non-existent class '
	   'variable ' 2 ' from the class ' 1 '.').
doit value: #assocErrNoElementsDetected value: err value:
    #('detect: was sent to a collection, but no elements of '
	   'the collection ' 1 ' satisfied the block ' 2 '.').
doit value: #classErrNotAVar value: err value:
    #('The symbol ' 2 ' was not resolvable as a variable within the class '
         1 '.').
doit value: #segErrTooManyGroups value: err value:
    #('The collection of groups ' 1
	   ' was specified that held more than four members.').
doit value: #rtErrExpectedByteValue value: err value:
    #('Byte objects store values from 0 to 255, not ' 1 '.').
doit value: #classErrBadFormat value: err value:
    #('Invalid format for new class ' 1 ' , ' 2 ).
doit value: #objErrDoesNotExist value: err value:
    #('The object with object ID ' 1 ' does not exist. ' 2).
doit value: #objErrNotOopKind value: err value:
    #('The object ' 1 ' is not implemented as a pointer object.').
doit value: #objErrNotByteKind value: err value:
    #('The object ' 1 ' is not implemented as a byte object.').
doit value: #objErrNotNscKind value: err value:
    #('The object ' 1 ' is not implemented as an NSC object.').
doit value: #objErrAlreadyExists value: err value:
    #('Attempt to create an object with object identifier ' 2
      ', which already exists as object ' 1 '.' ).
doit value: #objErrOopNotAllocated value: err value:
    #('Attempt to store a forward reference using the object '
	'identifier ' 1 ' which has not been allocated to this session.').
doit value: #objErrConstraintViolation value: err value:
    #('Attempt to store ' 2 ' of class ' 4 ' into an instance '
        'variable of ' 1 ' constrained to be ' 3 '.').

^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createRtErrs8

doit value: #objErrDictConstraintViolation value: err value:
    #('Attempt to store ' 2 ' of class ' 4 ' into ' 1 ' constrained '
      'to hold only instances which are a kind of ' 3 '.').

doit value: #rtErrExpectedClass value: err value:
    #('The object ' 1 ' was expected to be a class but was not.').
doit value: #objClassNotOopKind value: err value:
    #('The class ' 1  ' does not specify pointer object format.').
doit value: #objClassNotOopOrNscKind value: err value:
    #('The class ' 1 ', used as argument to GciCreateOopObj '
	' does not specify pointer or NSC object format.').
doit value: #rtMaxRecursion value: err value:
    #('Too many levels of recursion from user actions to GemStone Smalltalk or '
      'within object manager.').
doit value: #gciErrOpInProgress value: err value:
    #('GCI operation requested before the current '
	'nonblocking or thread safe call was completed.').

doit value: #repErrBkupNoStart value: err value:
   #('Unable to begin full backup, ' 1 ).

doit value: #rtErrDecodedObjDoesNotExist value: err value:
  #('The decoded object ID ' 1 ' at offset ' 2 ' does not exist. ').

doit value: #rtErrMaxSuperclassDepth value: err value:
  #('Cannot create subclass of ' 1 ' . Subclass would exceed ' 2
     ' levels below Object when following the superClass chain. ' ).

doit value: #rtErrReclaimAllMissingGcGem value: err value:
  #('A reclaimAll operation was attempted but at least one GC session '
    'is not running.  Ensure all reclaim sessions and the Admin GC session '
    'are running and try the operation again.' ).

^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_createRtErrs9

doit value: #objErrBadOffset value: err value:
    #('The object ' 1 ' was indexed using structural access with the index ' 3
       ' that was out of range. The maximum index is ' 2 '.').
doit value: #objErrCantCreateInstance value: err value:
    #('Creating an instance of class ' 1 ' is not allowed.').
doit value: #objClassNotByteKind value: err value:
    #('The class ' 1 ', used as argument to GciCreateByteObj '
	'does not specify byte object format.').
doit value: #lockErrArgSize value: err value:
    #('An argument to a locking primitive was too large.').
doit value: #objErrNotSpecialKind value: err value:
    #('The object ' 1 ' is not implemented as a special object.').
doit value: #authErrSegRead value: err value:
    #('An attempt was made to read the object with ID ' 1
	' in objectSecurityPolicyId ' 2 ' with insufficient authorization. ' 3).
doit value: #authErrSegWrite value: err value:
    #('An attempt was made to modify the object ' 1
	' in objectSecurityPolicyId ' 2 ' with insufficient authorization.').
doit value: #objErrNotOopOrNsc value: err value:
    #('An operation was attempted on the object ' 1
	' that is legal only on pointer or NSC objects.').
doit value: #rtErrObsolete value: err value:
    #(1 ' cannot respond to the selector ' 2 ' because its class is obsolete.').
doit value: #objErrNotFlt value: err value:
    #('The object ' 1 ' is not a float.').
doit value: #rtErrCantBecomeOneIdx value: err value:
    #('Become is not allowed because the object ' 1 ' participates in'
      ' an index and the object ' 2 ' has a different format. '
       ) .
doit value: #rtErrCantBecomeClassKind value: err value:
    #('Become is not allowed because the object ' 1 ' is a kind of ' 2 ).

doit value: #classErrByteSubclass value: err value:
    #('You may not create a byte subclass of ' 1 '.').
doit value: #repErrCantCreateRepos value: err value:
    #('The Repository ' 1 ' could not be created.').
doit value: #repErrBadFileSpec value: err value:
    #('The file specification is invalid.').
doit value: #repErrFileAlreadyExists value: err value:
    #('The file ' 1 ' already exists.').
doit value: #rtErrDuplicateKey value: err value:
    #('The key ' 2 ' already exists in dictionary ' 1 ).

^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_initAbortingErrs
ErrorSymbols at: #rtErrAbortTrans put: 3001.  "possibly unused"
ErrorSymbols at: #abortErrCommitsSuspended put: 3002 .
ErrorSymbols at: #abortErrGarbageCollection put: 3006.
ErrorSymbols at: #errAutoAbort put: 3007.
ErrorSymbols at: #errAutoLostOt put: 3008.

ErrorSymbols at: #abortErrLostOtRoot put: 3031.
^true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_initAsyncErrs
ErrorSymbols at: #rtErrPause put: 6001.
ErrorSymbols at: #rtErrStep  put: 6002 .
ErrorSymbols at: #rtErrSoftBreak put: 6003.
ErrorSymbols at: #rtErrHardBreak put: 6004.  "Not trappable with Exceptions"
ErrorSymbols at: #rtErrCodeBreakpoint put: 6005.
ErrorSymbols at: #rtErrStackBreakpoint put: 6006.

  "Warning, following error number hard coded in methods for speed"
ErrorSymbols at: #rtErrCommitAbortPending put: 6007.  "Not trappable with Exceptions"

ErrorSymbols at: #rtErrSignalCommit put: 6008.
ErrorSymbols at: #rtErrSignalAbort put: 6009.
ErrorSymbols at: #rtErrSignalGemStoneSession put: 6010.
ErrorSymbols at: #rtErrUncontinuable put: 6011.  "Not trappable with Exceptions"
ErrorSymbols at: #rtErrSignalFinishTransaction put: 6012.
ErrorSymbols at: #rtErrSignalAlmostOutOfMemory put: 6013.
ErrorSymbols at: #rtErrProcessStepInNative put: 6014.
ErrorSymbols at: #rtErrTimeoutInterrupt put: 6015. "private to ProcessScheduler"
ErrorSymbols at: #rtErrSignalException put: 6016.  "private to ProcessScheduler"
ErrorSymbols at: #rtErrGcFinalize put: 6017.  "private to ProcessScheduler"
ErrorSymbols at: #rtErrTerminateProcess put: 6018.  "private to ProcessScheduler"
ErrorSymbols at: #rtErrSignalTrap put: 6019.

^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_initAuthorizationSymbols
  | policy |
  policy := GsObjectSecurityPolicy objectSecurityPolicy ifNil:[ SystemRepository at: 1 ].
  policy  setCurrentWhile:[
    GsObjectSecurityPolicy _classVars at: #AuthorizationSymbols put: { #none . #write . #read . #write } .
  ].
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_initDate
(Date objectSecurityPolicy) setCurrentWhile:[
  | langDict englishArray |
  langDict := LanguageDictionary new.
  englishArray := Array new.
  langDict at: #English put: englishArray.

  englishArray at: 1 put: 'Sunday';
	       at: 2 put: 'Monday';
	       at: 3 put: 'Tuesday';
	       at: 4 put: 'Wednesday';
	       at: 5 put: 'Thursday';
	       at: 6 put: 'Friday';
	       at: 7 put: 'Saturday'.

  Date _classVars at: #WeekDayNames put: langDict.
  DateTime _classVars at: #WeekDayNames put: langDict copy.

  langDict := LanguageDictionary new.
  englishArray := Array new.
  langDict at: #English put: englishArray.

  englishArray at: 1 put: 'January';
	       at: 2 put: 'February';
	       at: 3 put: 'March';
	       at: 4 put: 'April';
	       at: 5 put: 'May';
	       at: 6 put: 'June';
	       at: 7 put: 'July';
	       at: 8 put: 'August';
	       at: 9 put: 'September';
	       at: 10 put: 'October';
	       at: 11 put: 'November';
	       at: 12 put: 'December'.

  Date _classVars at: #MonthNames put: langDict.
  DateTime _classVars at: #MonthNames put: langDict copy.
].
^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_initDateAndTime
  "create classVar if coming from 3.3.x"
  DateAndTime addClassVarName: #DefaultScale 
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_initDcUserGlobals
| symList newDict sysUser |
(Globals includesKey: #DbfHistory) ifTrue:[
  "image upgraded, do nothing"
] ifFalse:[
  (Globals at: #DataCuratorObjectSecurityPolicy) setCurrentWhile:[
    symList:= (AllUsers detect: [:x | x userId = 'DataCurator']) symbolList.
    newDict := SymbolDictionary new .
    newDict name: #UserGlobals.
    symList insertObject: newDict at: 1.

    sysUser := AllUsers detect: [:x | x userId = 'SystemUser'] .
    symList:= sysUser symbolList.
    newDict := SymbolDictionary new .
    newDict name: #UserGlobals.
    symList insertObject: newDict at: 1.

    "SymbolUser does not exist yet, not created in bom.c "
  ].
].
^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_initFatalErrs
ErrorSymbols at: #gsErrBadRootPage put: 4001.
ErrorSymbols at: #repErrReposFull put: 4002.
ErrorSymbols at: #repErrNoFreePages put: 4003.
ErrorSymbols at: #hostFatalErrOutOfMem put: 4004.
ErrorSymbols at: #gsErrCorruptObjSize put: 4005 .
ErrorSymbols at: #repErrBadDbfSwizzle put: 4006 .
ErrorSymbols at: #errUserProfileLost put: 4008.
ErrorSymbols at: #gsErrShrpcConnectionFailure put: 4009.
ErrorSymbols at: #gsErrShrpcUnexpectedNetEvent put: 4010.
ErrorSymbols at: #gsErrShrpcInvalidConfig put: 4011.
ErrorSymbols at: #gsErrSslShutdown put: 4016 . "GS_ERR_SSL_SHUTDOWN_ERR"
ErrorSymbols at: #errLostOtGci put: 4030 . "ERR_LOST_OT_GCI"
ErrorSymbols at: #errDuringLostOtService put: 4031 . "ERR_DURING_LOST_OT_SERVICE"

ErrorSymbols at: #errTranLogOpenFail  put: 4032.
ErrorSymbols at: #errFinishedObjAuditRepair put: 4033.
ErrorSymbols at: #gsErrStnNetProtocol put: 4034.
ErrorSymbols at: #gsErrStnNetLost put: 4035.
ErrorSymbols at: #gsErrCopyProtection put: 4036.
ErrorSymbols at: #gsErrNoCapability put: 4037.
ErrorSymbols at: #gsErrDisconnectInLogin put: 4038.
ErrorSymbols at: #gsErrMaxSessionsLimit put: 4039.
ErrorSymbols at: #lgcErrIncompatGci put: 4040.
ErrorSymbols at: #hostErrCantSpawn put: 4042.
ErrorSymbols at: #gsErrBadGemStoneVersion put: 4044.
ErrorSymbols at: #gsErrBadGemDbfVersion put: 4045.
ErrorSymbols at: #bkupErrRestoreSuccessful put: 4046.  "Not trappable with Exceptions"
ErrorSymbols at: #gsErrShrpcLostOtTimeout put: 4047 .

ErrorSymbols at: #bkupErrRestoreLogSuccess put: 4048.
ErrorSymbols at: #bkupErrRestoreLogFail put: 4049.

ErrorSymbols at: #gsActiveUserLimitExceeded put: 4050 .
ErrorSymbols at: #gsErrLoginDenial put: 4051.
" 4052 not used "
ErrorSymbols at: #gsErrLoginsDisabled put: 4053.
ErrorSymbols at: #gsErrCacheTooBig put: 4054.
ErrorSymbols at: #gsErrStnShutdown put: 4057.
ErrorSymbols at: #errLostOtHandlingFailed put: 4058 .
ErrorSymbols at: #gsErrSessionShutdown put: 4059.
ErrorSymbols at: #gsErrGemNormalShutdown put: 4060.
ErrorSymbols at: #gsErrGemFatalShutdown put: 4061.
ErrorSymbols at: #gsErrNoMoreOops put: 4062.
ErrorSymbols at: #netErrNoSuchStn put: 4065.
ErrorSymbols at: #gciErrBadSessionId put: 4100.
ErrorSymbols at: #gciErrUnexpectedLnkErr put: 4101 .
ErrorSymbols at: #gciErrInternalRpc put: 4102 .
ErrorSymbols at: #fatalErrInternal put: 4126.
ErrorSymbols at: #netErrConnectionRefused put: 4136.
ErrorSymbols at: #netErr put: 4137.
ErrorSymbols at: #repErrSystemRepNotAttached put: 4138.
ErrorSymbols at: #authErrSegLoginSeg put: 4140.

ErrorSymbols at: #errSslLibLoadFailed put: 4150 .
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_initFilein1
  SortedCollection initDefaultSortblock .
  UserProfile      _initPrivilegeNames .
  GsObjectSecurityPolicy _disallowGciCreateStore .
  System commit .
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_initFloatingPointError
  FloatingPointError _initializeConstants .
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_initLanguageNames
UserProfile objectSecurityPolicy setCurrentWhile:[
  UserProfile _classVars at: #LanguageNames put: #(#ASCII #'JIS-EUC').
].
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_initLegacyErrMap1
 "The raw legacy map defined here is modified  _initLegacyErrMap2 "
	| map |
map := Array new: 6100 .
Globals at: #LegacyErrNumMap put: map .
	map at: 1001 put: CompileError .
	map at: 2001 put: ArgumentError .
	map at: 2002 put: #'none' .
	map at: 2003 put: OffsetError .
	map at: 2004 put: { ArgumentError  . OffsetError } .
	map at: 2005 put: #'none' .
	map at: 2006 put: #'none' .
	map at: 2007 put: Error .
	map at: 2008 put: Error .
        map at: 2009 put: ImproperOperation  . "class is variant"
	map at: 2010 put: MessageNotUnderstood .
	map at: 2011 put: #'none' .
	map at: 2012 put: OffsetError .
	map at: 2013 put: MessageNotUnderstood .
        map at: 2014 put: ImproperOperation  . "subclass disallowed"
	map at: 2015 put: LookupError .
	map at: 2016 put: RepositoryError .
	map at: 2017 put: ArgumentError .
	map at: 2018 put: ArgumentError .
	map at: 2019 put: ImproperOperation .
	map at: 2020 put: #'none' .
	map at: 2021 put: LookupError .
	map at: 2022 put: OutOfRange .
	map at: 2023 put: InternalError .
	map at: 2024 put: InternalError .
	map at: 2025 put: RepositoryError .
	map at: 2026 put: ZeroDivide .
	map at: 2027 put: ArgumentError .
	map at: 2028 put: RepositoryError .
	map at: 2029 put: #'none' .
	map at: 2030 put: ImproperOperation .
	map at: 2031 put: ArgumentTypeError . "store to invariant object"
	map at: 2032 put: ImproperOperation .
	map at: 2033 put: LookupError .
	map at: 2034 put: #'none' .
	map at: 2035 put: LookupError .
	map at: 2036 put: ImproperOperation .
	map at: 2037 put: #'none' .
	map at: 2038 put: ImproperOperation .
	map at: 2039 put: ImproperOperation .
	map at: 2040 put: RepositoryError .
	map at: 2041 put: #'none' .
	map at: 2042 put: #'none' .
	map at: 2043 put: ImproperOperation .
	map at: 2044 put: ImproperOperation .
	map at: 2045 put: LookupError .
	map at: 2046 put: LookupError .
	map at: 2047 put: ArgumentTypeError .
	map at: 2048 put: ArgumentTypeError .
	map at: 2049 put: ArgumentError .
        map at: 2050 put: ImproperOperation .
	map at: 2051 put: OutOfRange .
	map at: 2052 put: RepositoryError .
	map at: 2053 put: LookupError .
	map at: 2054 put: ImproperOperation .
	map at: 2055 put: OutOfRange .
	map at: 2056 put: #'none' .
	map at: 2057 put: ArgumentError .
	map at: 2058 put: TransactionError .
	map at: 2059 put: AlmostOutOfStack .
	map at: 2060 put: ArgumentError .
	map at: 2061 put: OutOfRange .
	map at: 2062 put: ImproperOperation .
	map at: 2063 put: #'none' .
	map at: 2064 put: OutOfRange .
	map at: 2065 put: ArgumentError .
	map at: 2066 put: FloatingPointException .
	map at: 2067 put: ArgumentError .
	map at: 2068 put: ImproperOperation .
	map at: 2069 put: #'none' .
	map at: 2070 put: ArgumentError .
	map at: 2071 put: ArgumentError .
	map at: 2073 put: LockError .
	map at: 2074 put: LockError .
	map at: 2075 put: LockError .
	map at: 2076 put: ImproperOperation .
	map at: 2077 put: ArgumentError .
	map at: 2078 put: ImproperOperation .
	map at: 2079 put: CannotReturn .
	map at: 2080 put: ImproperOperation .
	map at: 2081 put: ImproperOperation .
	map at: 2082 put: #'none' .
	map at: 2083 put: ImproperOperation .
	map at: 2084 put: ArgumentError  .
	map at: 2085 put: ImproperOperation .
	map at: 2086 put: ImproperOperation .
	map at: 2087 put: ImproperOperation .
	map at: 2088 put: #'none' .
	map at: 2089 put: ImproperOperation .
	map at: 2090 put: ArgumentError .
	map at: 2091 put: #'none' .
	map at: 2092 put: InternalError .
	map at: 2093 put: { ArgumentError  . OutOfRange . ImproperOperation } .
	map at: 2094 put: ArgumentTypeError .
	map at: 2095 put: LookupError .
	map at: 2096 put: LookupError .
	map at: 2097 put: LookupError .
	map at: 2098 put: #'none' .
	map at: 2099 put: ArgumentError .
	map at: 2100 put: ImproperOperation .
	map at: 2101 put: { LookupError  . InternalError } .
	map at: 2102 put: ImproperOperation .
	map at: 2103 put: ArgumentTypeError .
	map at: 2104 put: ArgumentTypeError .
	map at: 2105 put: ImproperOperation .
	map at: 2106 put: ImproperOperation .
	map at: 2107 put: ArgumentTypeError .
	map at: 2108 put: ArgumentTypeError .
	map at: 2109 put: ArgumentTypeError .
	map at: 2110 put: OutOfRange .
	map at: 2111 put: ImproperOperation .
	map at: 2112 put: ArgumentTypeError .
	map at: 2113 put: ArgumentError .
	map at: 2114 put: ArgumentTypeError .
	map at: 2115 put: SecurityError .
	map at: 2116 put: SecurityError .
	map at: 2117 put: ArgumentTypeError .
	map at: 2118 put: ImproperOperation .
	map at: 2119 put: ArgumentError .
	map at: 2120 put: ArgumentTypeError .
	map at: 2121 put: ArgumentTypeError .
	map at: 2122 put: ImproperOperation .
	map at: 2123 put: #'none' .
	map at: 2124 put: #'none' .
	map at: 2125 put: ArgumentError .
	map at: 2126 put: ImproperOperation .
	map at: 2127 put: ImproperOperation .
	map at: 2128 put: ImproperOperation .
	map at: 2129 put: #'none' .
	map at: 2130 put: #'none' .
	map at: 2131 put: ImproperOperation .
	map at: 2132 put: #'none' .
	map at: 2133 put: #'none' .
	map at: 2135 put: ArgumentError .
	map at: 2136 put: LookupError .
	map at: 2137 put: ArgumentTypeError .
	map at: 2138 put: ImproperOperation .
	map at: 2139 put: ImproperOperation .
	map at: 2140 put: ImproperOperation .
	map at: 2141 put: ImproperOperation .
	map at: 2142 put: ImproperOperation .
	map at: 2143 put: RepositoryError .
	map at: 2144 put: ImproperOperation .
	map at: 2145 put: #'none' .
	map at: 2146 put: ImproperOperation .
	map at: 2147 put: ImproperOperation .
  map at: 2148 put: #'none' .
	map at: 2149 put: ArgumentError .
	map at: 2150 put: ImproperOperation .
	map at: 2151 put: SecurityError .
	map at: 2152 put: ImproperOperation .
	map at: 2153 put: OutOfRange .
	map at: 2154 put: #'none' .
	map at: 2155 put: #'none' .
	map at: 2156 put: Error .  "illegal ram self"
	map at: 2157 put: RepositoryError .
	map at: 2158 put: RepositoryError .
	map at: 2159 put: #'none' .
	map at: 2160 put: ImproperOperation .
	map at: 2161 put: OutOfRange .
	map at: 2162 put: OutOfRange .
	map at: 2163 put: ArgumentError .
	map at: 2164 put: ArgumentTypeError .
	map at: 2165 put: GciTransportError .
	map at: 2166 put: GciTransportError .
	map at: 2167 put: GciTransportError .
	map at: 2168 put: ArgumentError .
	map at: 2169 put: TransactionError .
	map at: 2170 put: ArgumentError .
	map at: 2171 put: ImproperOperation .
	map at: 2172 put: GciTransportError .
	map at: 2173 put: SecurityError .
	map at: 2174 put: SecurityError .
	map at: 2175 put: ArgumentError .
	map at: 2176 put: ArgumentError .
	map at: 2177 put: #'none' .
	map at: 2178 put: ArgumentError .
	map at: 2179 put: ArgumentError .
	map at: 2180 put: #'none' .
	map at: 2181 put: #'none' .
	map at: 2182 put: GciTransportError .
	map at: 2184 put: ArgumentTypeError .
	map at: 2185 put: ImproperOperation .
	map at: 2186 put: #'none' .
	map at: 2187 put: LookupError .
	map at: 2188 put: ArgumentError .
	map at: 2189 put: #'none' .
	map at: 2190 put: ImproperOperation .
	map at: 2191 put: LookupError .
	map at: 2192 put: EndOfStream .
	map at: 2193 put: ArgumentError .
	map at: 2194 put: ArgumentError .
	map at: 2195 put: ImproperOperation .
	map at: 2196 put: ArgumentError .
	map at: 2197 put: { ArgumentError . ArgumentTypeError. IOError } .
	map at: 2198 put: { ArgumentTypeError  . IOError . ArgumentError } .
	map at: 2199 put: ArgumentError .
	map at: 2200 put: { ArgumentError  . IOError } .
	map at: 2201 put: ExternalError .
	map at: 2202 put: ArgumentError .
	map at: 2203 put: ImproperOperation .
	map at: 2204 put: #'none' .
	map at: 2205 put: OutOfRange .
	map at: 2206 put: #'none' .
	map at: 2207 put: ImproperOperation .
	map at: 2208 put: ExternalError .
	map at: 2209 put: ImproperOperation .
	map at: 2210 put: OutOfRange .
	map at: 2211 put: ArgumentError .
	map at: 2212 put: ImproperOperation .
	map at: 2213 put: SecurityError .
	map at: 2214 put: SecurityError .
	map at: 2215 put: ImproperOperation .
	map at: 2216 put: ImproperOperation .
	map at: 2217 put: ImproperOperation .
	map at: 2218 put: ImproperOperation .
	map at: 2219 put: OffsetError .
	map at: 2220 put: ImproperOperation .
	map at: 2221 put: #'none' .
	map at: 2222 put: ImproperOperation .
	map at: 2223 put: #'none' .
	map at: 2224 put: #'none' .
	map at: 2225 put: GciTransportError .
	map at: 2226 put: GciTransportError .
	map at: 2227 put: #'none' .
	map at: 2228 put: #'none' .
	map at: 2229 put: GciTransportError .
	map at: 2230 put: GciTransportError .
	map at: 2231 put: GciTransportError .
	map at: 2232 put: GciTransportError .
	map at: 2233 put: GciTransportError .
	map at: 2234 put: GciTransportError .
	map at: 2235 put: #'none' .
	map at: 2236 put: ArgumentError .
	map at: 2237 put: ArgumentError .
	map at: 2238 put: GciTransportError .
	map at: 2239 put: GciTransportError .
	map at: 2240 put: GciTransportError .
	map at: 2241 put: ImproperOperation .
	map at: 2242 put: ArgumentTypeError .
	map at: 2243 put: #'none' .
	map at: 2244 put: ArgumentError .
	map at: 2245 put: #'none' .
	map at: 2246 put: ImproperOperation .
	map at: 2248 put: TransactionError .
	map at: 2249 put: TransactionError .
	map at: 2250 put: RepositoryError .
	map at: 2251 put: GciTransportError .
	map at: 2252 put: ImproperOperation .
	map at: 2253 put: InternalError .
	map at: 2254 put: SignalBufferFull .
	map at: 2255 put: #'none' .
	map at: 2256 put: #'none' .
	map at: 2257 put: SecurityError .
	map at: 2258 put: ArgumentError .
	map at: 2259 put: GciTransportError . "no instances created"
	map at: 2260 put: #'none' .
	map at: 2261 put: InternalError .
	map at: 2262 put: ArgumentError .
	map at: 2263 put: ArgumentError .
	map at: 2264 put: ImproperOperation .
	map at: 2265 put: ArgumentError .
	map at: 2266 put: #'none' .
	map at: 2267 put: ArgumentError .
	map at: 2268 put: ArgumentError .
	map at: 2269 put: ArgumentError .
	map at: 2270 put: ImproperOperation .
	map at: 2271 put: ImproperOperation .
	map at: 2272 put: ArgumentError .
	map at: 2273 put: #'none' .
	map at: 2274 put: ArgumentError .
	map at: 2275 put: ImproperOperation .
	map at: 2276 put: ImproperOperation .
	map at: 2277 put: #'none' .
	map at: 2278 put: ImproperOperation .
	map at: 2279 put: #'none' .
	map at: 2280 put: LookupError .
	map at: 2281 put: ImproperOperation .
	map at: 2282 put: ImproperOperation .
	map at: 2283 put: ArgumentTypeError .
	map at: 2284 put: { ImproperOperation  . OffsetError } .
	map at: 2285 put: ImproperOperation .
	map at: 2286 put: ImproperOperation .
	map at: 2287 put: #none  .
	map at: 2288 put: ImproperOperation .
	map at: 2289 put: ImproperOperation .
	map at: 2290 put: RepositoryError .
	map at: 2291 put: ArgumentError .
	map at: 2292 put: ImproperOperation .
	map at: 2293 put: EndOfStream .
	map at: 2294 put: LookupError .
	map at: 2295 put: LookupError .
	map at: 2296 put: #'none' .
	map at: 2297 put: LookupError .
	map at: 2298 put: #'none' .
	map at: 2299 put: ImproperOperation .
	map at: 2300 put: ImproperOperation .
	map at: 2301 put: LookupError .
	map at: 2302 put: RepositoryError .
	map at: 2303 put: RepositoryError .
	map at: 2304 put: ArgumentError .
	map at: 2305 put: RepositoryError .
	map at: 2306 put: RepositoryError .
	map at: 2307 put: RepositoryError .
	map at: 2308 put: #'none' .
	map at: 2309 put: ImproperOperation .
	map at: 2310 put: ImproperOperation .
	map at: 2311 put: ImproperOperation .
	map at: 2312 put: ImproperOperation .
	map at: 2313 put: ImproperOperation .
	map at: 2314 put: ImproperOperation .
	map at: 2315 put: #'none' .
	map at: 2316 put: #'none' .
	map at: 2317 put: ArgumentError .
	map at: 2318 put: UserDefinedError .
	map at: 2319 put: ImproperOperation .
	map at: 2320 put: #'none' .
	map at: 2321 put: IndexingErrorPreventingCommit . "error number no longer used"
	map at: 2322 put: ImproperOperation .
	map at: 2323 put: ImproperOperation .
	map at: 2324 put: RepositoryError .
	map at: 2325 put: TransactionError .
	map at: 2326 put: InternalError .
	map at: 2327 put: #'none' .
	map at: 2328 put: TransactionError .
	map at: 2329 put: ImproperOperation .
	map at: 2330 put: RepositoryError .
	map at: 2331 put: ArgumentError .
	map at: 2332 put: ImproperOperation .
	map at: 2333 put: ImproperOperation .
	map at: 2334 put: ImproperOperation .
	map at: 2335 put: ImproperOperation .
	map at: 2336 put: ClientForwarderSend .
	map at: 2337 put: ArgumentError .
	map at: 2338 put: RepositoryError .
	map at: 2339 put: RepositoryError .
	map at: 2340 put: ArgumentError .
	map at: 2341 put: SecurityError .
	map at: 2342 put: SecurityError .
	map at: 2343 put: SecurityError .
	map at: 2344 put: SecurityError .
	map at: 2345 put: SecurityError .
	map at: 2346 put: SecurityError .
	map at: 2347 put: SecurityError .
	map at: 2348 put: RepositoryError .
	map at: 2349 put: ArgumentError .
	map at: 2350 put: ImproperOperation .
	map at: 2351 put: ImproperOperation .
	map at: 2352 put: TransactionError .
	map at: 2353 put: TransactionError .
	map at: 2354 put: #'none' .
	map at: 2355 put: ArgumentError .
	map at: 2356 put: LookupError .
	map at: 2357 put: RepositoryError .
	map at: 2358 put: ImproperOperation .
	map at: 2359 put: #'none' .
	map at: 2360 put: TransactionError .
	map at: 2361 put: InternalError .
	map at: 2362 put: SocketError .
	map at: 2363 put: #'none' .
	map at: 2364 put: ImproperOperation .
	map at: 2365 put: ImproperOperation .
	map at: 2366 put: ThreadError  .  "rtErrSchedulerDeadlocked"
	map at: 2367 put: { ImproperOperation  . ImproperOperation } .
	map at: 2368 put: TerminateProcess .
	map at: 2369 put: #'none' .
	map at: 2370 put: #'none' .
	map at: 2371 put: SecurityError .
	map at: 2372 put: #'none' .
	map at: 2373 put: ArgumentError .
	map at: 2374 put: #'none' .
	map at: 2376 put: ImproperOperation .
	map at: 2377 put: ArgumentError .
	map at: 2378 put: ImproperOperation .
	map at: 2379 put: ArgumentError .
	map at: 2381 put: ImproperOperation .
	map at: 2388 put: IOError .
	map at: 2389 put: RepositoryError .
	map at: 2390 put: RepositoryError .
	map at: 2391 put: ImproperOperation .
	map at: 2392 put: RepositoryError .
	map at: 2393 put: #'none' .
	map at: 2394 put: ImproperOperation .
	map at: 2395 put: RepositoryError .
	map at: 2400 put: SecurityError .
	map at: 2401 put: #'none' .
	map at: 2402 put: ImproperOperation .
	map at: 2403 put: TransactionError .
	map at: 2404 put: NameError  .
	map at: 2405 put: ImproperOperation .
	map at: 2406 put: RepositoryError .
	map at: 2407 put: TransactionError .
	map at: 2408 put: ImproperOperation .
	map at: 2409 put: TransactionError .

	map at: 2411 put: InternalError .
	map at: 2412 put: TransactionError .
	map at: 2413 put: ImproperOperation .
	map at: 2414 put: ImproperOperation .
	map at: 2415 put: Error .
	map at: 2416 put: ImproperOperation .
	map at: 2417 put: SecurityError .
	map at: 2418 put: LockError .
	map at: 2419 put: LockError .
	map at: 2420 put: LockError .
	map at: 2421 put: #'none' .
	map at: 2422 put: InternalError .
	map at: 2423 put: ImproperOperation .
	map at: 2424 put: ImproperOperation .
	map at: 2425 put: ImproperOperation .
	map at: 2426 put: ImproperOperation .
	map at: 2427 put: ImproperOperation .
	map at: 2480 put: #'none' .
	map at: 2481 put: InternalError .
	map at: 2482 put: ImproperOperation .
	map at: 2483 put: #'none' .
	map at: 2484 put: ImproperOperation .
	map at: 2485 put: Error .

	map at: 2487 put: Notification .
	map at: 2488 put: #'none' .
	map at: 2489 put: ImproperOperation .
	map at: 2500 put: #'none' .
	map at: 2501 put: Error .
	map at: 2502 put: AlmostOutOfStack .
	map at: 2503 put: NumericError .  "fix 50198"

	map at: 2505 put: ArgumentError .
	map at: 2506 put: NameError .
	map at: 2507 put: OutOfRange .
	map at: 2508 put: ArgumentTypeError .
	map at: 2509 put: ArgumentError .
        map at: 2511 put: AlmostOutOfMemory .
	map at: 2512 put: ArgumentError .
        map at: 2513 put: SecurityError .
        map at: 2514 put: Error .
        map at: 2515 put: Warning  .
        map at: 2518 put: SecurityError .

	map at: 2600 put: ArgumentError .
	map at: 2601 put: ArgumentError .
	map at: 2602 put: LookupError .
	map at: 2603 put: ImproperOperation .
	map at: 2604 put: ImproperOperation .
	map at: 2605 put: ImproperOperation .
	map at: 2606 put: ImproperOperation .
	map at: 2607 put: ArgumentError .
      	map at: 2608 put: ImproperOperation . "RT_ERR_GROUP_ALREADY_EXIST"
      	map at: 2609 put: ImproperOperation . "RT_ERR_GROUP_ALREADY_EXIST"

  "the new per-ANSI-class error numbers"
  "2701 is AbstractException, do not include"
  map at: 2702  put: Exception  .
  map at: 2703  put: (ObsoleteClasses at: #RubyBreakException)  .
  map at: 2704  put: (ObsoleteClasses at: #RubyThrowException)  .
  map at: 2705  put: ControlInterrupt  .
  map at: 2706  put: Break  .
  map at: 2707  put: Breakpoint  .
  map at: 2709  put: Halt  .
  map at: 2710  put: Error  .
  map at: 2711  put: InterSessionSignal   .
  map at: 2712  put: EndOfStream  .
  map at: 2713  put: ExternalError  .
  map at: 2714  put: IOError  .
  map at: 2715  put: SocketError  .
  map at: 2716  put: SystemCallError  .
  map at: 2717  put: ImproperOperation  .
  map at: 2718  put: ArgumentError  .
  map at: 2719  put: ArgumentTypeError  .
  map at: 2720  put: CannotReturn  .
  map at: 2721  put: LookupError  .
  map at: 2722  put: OffsetError  .
  map at: 2723  put: OutOfRange  .
  map at: 2724  put: FloatingPointError  .
  map at: 2725  put: (ObsoleteClasses at: #RegexpError)  .
  map at: 2726  put: IndexingErrorPreventingCommit  .
  map at: 2727  put: InternalError  .
  map at: 2728  put: GciTransportError  .
  map at: 2729  put: LockError  .
  map at: 2730  put: NameError  .
  map at: 2731  put: Warning  .
  map at: 2732  put: NumericError  .
  map at: 2733  put: ZeroDivide  .
  map at: 2734  put: RepositoryError  .
  map at: 2735  put: SecurityError  .
  map at: 2736  put: SignalBufferFull  .
  map at: 2737  put: ThreadError  .
  map at: 2738  put: TransactionError  .
  map at: 2739  put: UncontinuableError  .
  map at: 2740  put: UserDefinedError  .
  map at: 2741  put: Notification  .
  map at: 2742  put: Admonition  .
  map at: 2743  put: AlmostOutOfStack  .
  map at: 2744  put: AlmostOutOfMemory  .
  map at: 2745  put: RepositoryViewLost  .
  map at: 2746  put: Deprecated  .
  map at: 2747  put: FloatingPointException  .
  map at: 2748  put: ObjectsCommittedNotification  .
  map at: 2750  put: TransactionBacklog  .
  map at: 2751  put: TestFailure  .
  "2752 is SystemExitError , #define ERR_RUBY_SystemExitError 2752 /* class"
  map at: 2755  put: SecureSocketError .
  map at: 2756  put: CryptoError .
  map at: 2758  put: UncontinuableError . "cannot return from on:do: across FFI call"
  map at: 2759  put: SshSocketError .
  map at: 2760  put: AwsError .
  map at: 2761  put: PostgresError .
  map at: 2789  put: AzureError .
  map at: 2790  put: Halt .
        map at: 3002 put: RepositoryError  .
        map at: 3006 put: RepositoryError  .
        map at: 3007 put: TransactionBacklog .
        map at: 3008 put: RepositoryViewLost .
        "3020 changed to 2515"
	map at: 3031 put: RepositoryViewLost .

        map at: 4016  put: SecureSocketError .
        map at: 4030  put: ImproperOperation .
        map at: 4031  put: ImproperOperation .
	map at: 6001 put: Halt .
	map at: 6002 put: Breakpoint .
	map at: 6003 put: Break .
	map at: 6004 put: Break .
	map at: 6005 put: Breakpoint .
	map at: 6006 put: Breakpoint .
	map at: 6007 put: TransactionError " signaled from image"  .
	map at: 6008 put: ObjectsCommittedNotification .
	map at: 6009 put: TransactionBacklog .
	map at: 6010 put: InterSessionSignal .
	map at: 6011 put: UncontinuableError .
	map at: 6012 put: TransactionBacklog .
	map at: 6013 put: AlmostOutOfMemory .
        map at: 6014 put: ImproperOperation  .
        map at: 6015 put: ControlInterrupt .
        map at: 6016 put: ControlInterrupt .  "no instances created"
        map at: 6017 put: ControlInterrupt .
        map at: 6018 put: ControlInterrupt .
        map at: 6019 put: (ObsoleteClasses at: #RubyThrowException) "only used in Ruby" .
        map at: 6020 put: Break .
        map at: 6021 put: Break .
        map at: 6022 put: AlmostOutOfMemoryError .
^true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_initLegacyErrMap2
| set bag map numToReason templates defaultTemplate |
set := IdentitySet new .
bag := IdentityBag new .
ErrorSymbols valuesDo:[ :v |
  set add: v . bag add: v
].
( bag - set ) size == 0 ifFalse:[ nil error:'duplicate values'] .
numToReason := IdentityKeyValueDictionary new .
ErrorSymbols keysAndValuesDo:[:k :v |
  "convert Error symbols to reason Strings "
  numToReason at: v put: k asString immediateInvariant
].
templates := (Globals at: #GemStoneError) at: #English.
map := Globals at: #LegacyErrNumMap .
defaultTemplate := #( nil ) .
1 to: map size do:[:j | | vAry tStr val |
  (val := map at: j ) ifNotNil:[
    tStr := (templates atOrNil: j) ifNil:[
      (j >= 2700 and:[ j <= 2799 ]) ifTrue:[ nil ] ifFalse:[ defaultTemplate ].
    ].
    val _isSymbol ifTrue:[
	val == #none ifTrue:[
	  vAry := { InternalError . #rtErrNoMessage . defaultTemplate }
	] ifFalse:[ nil error:'unknown symbol' ].
			  ] ifFalse: [
    val _isArray ifTrue:[
       vAry := { val at: 1 . numToReason at: j ifAbsent:[nil] . tStr . val }
			  ] ifFalse:[
    val isBehavior ifTrue:[
       vAry := { val"a Class" . numToReason at: j ifAbsent:[ nil ] . tStr } .
    ] ifFalse:[
       nil error:'bad value'
    ]]] .
    "vAry is { aClass . aReasonString . legacyTemplateStringOrNil }
	or { firstClass . aReasonString . legacyTemplateStringOrNil.
		  { list of split classes...} } "
    map at: j put: vAry immediateInvariant
  ] ifNil:[
    (j < 2000 and: [j > 1001]) ifTrue:[
       (templates at: j) ifNotNil:[ :compileMsg |  map at: j put: compileMsg ].
    ]
  ].
].

map at: 6023 put: (map at: 6002) copy .  "Breakpoint  single step"
map at: 6024 put: (map at: 6005) copy .  "Breakpoint  method"
map at: 6025 put: (map at: 6006) copy.  "Breakpoint  stack"
"map immediateInvariant .  future optimization"
Globals at:#LegacyErrNumMap put: map .

"(Globals associationAt:#LegacyErrNumMap) immediateInvariant.  future optimization"
^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_initObsoleteDateTime
 | cls |
 cls := ObsoleteClasses at: #ObsoleteDateTime .
 cls objectSecurityPolicy setCurrentWhile:[
  | langDict englishArray |
  langDict := LanguageDictionary new.
  englishArray := Array new.
  langDict at: #English put: englishArray.
  cls _classVars at: #WeekDayNames put: langDict.

  englishArray at: 1 put: 'Sunday';
	       at: 2 put: 'Monday';
	       at: 3 put: 'Tuesday';
	       at: 4 put: 'Wednesday';
	       at: 5 put: 'Thursday';
	       at: 6 put: 'Friday';
	       at: 7 put: 'Saturday'.

  langDict := LanguageDictionary new.
  englishArray := Array new.
  langDict at: #English put: englishArray.
  cls _classVars at: #MonthNames put: langDict.

  englishArray at: 1 put: 'January';
	       at: 2 put: 'February';
	       at: 3 put: 'March';
	       at: 4 put: 'April';
	       at: 5 put: 'May';
	       at: 6 put: 'June';
	       at: 7 put: 'July';
	       at: 8 put: 'August';
	       at: 9 put: 'September';
	       at: 10 put: 'October';
	       at: 11 put: 'November';
	       at: 12 put: 'December'.
].
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_initRuntimeErrs1
ErrorSymbols at: #compilerErrStDB put: 1001.
ErrorSymbols at: #StDBErrMaxPath put: 1002.
ErrorSymbols at: #StDBErrArrayTooLarge put: 1003.
ErrorSymbols at: #StDBErrEofInStrLit put: 1004.
ErrorSymbols at: #StDBErrEofInComment put: 1005.
ErrorSymbols at: #StDBErrEofInChrLit put: 1006.
ErrorSymbols at: #StDBErrUnexpectedColon put: 1007.
ErrorSymbols at: #StDBErrUnexpectedPound put: 1008.
ErrorSymbols at: #StDBErrBadChr put: 1009.
ErrorSymbols at: #StDBErrLitTooBig put: 1010.
ErrorSymbols at: #StDBErrBadRadix put: 1011.
ErrorSymbols at: #StDBErrBadChrInRadixNum put: 1012.
ErrorSymbols at: #StDBErrExpectedRightParen put: 1013.
ErrorSymbols at: #StDBErrExpectedPrimary put: 1014.
ErrorSymbols at: #StDBErrExpectedVar put: 1015.
ErrorSymbols at: #StDBErrExpectedSelector put: 1016.
ErrorSymbols at: #StDBErrMaxArg put: 1017.
ErrorSymbols at: #StDBErrExpectedEof put: 1018.
ErrorSymbols at: #StDBErrExpectedStatement put: 1019.
ErrorSymbols at: #StDBErrExpectedPrim put: 1020.
ErrorSymbols at: #StDBErrExpectedPrimNum put: 1021.
ErrorSymbols at: #StDBErrBadPrimNum put: 1022.
ErrorSymbols at: #StDBErrExpectedRightBrace put: 1023.
ErrorSymbols at: #StDBErrMaxArgsTemps put: 1024.
ErrorSymbols at: #StDBErrExpectedVerticalBar put: 1025.
ErrorSymbols at: #StDBErrExpectedMsgPattern put: 1026.
ErrorSymbols at: #StDBErrExpectedGt put: 1027.
ErrorSymbols at: #StDBErrBadFlt put: 1028.
ErrorSymbols at: #StDBErrExpectedAssignable put: 1029.
ErrorSymbols at: #StDBErrAlreadyDefined put: 1030.
ErrorSymbols at: #StDBErrNotDefined put: 1031.
ErrorSymbols at: #StDBErrPredicateTooBig put: 1032.
ErrorSymbols at: #StDBErrBlocksTooDeep put: 1033.
ErrorSymbols at: #StDBErrUnexpectedToken put: 1034.
ErrorSymbols at: #StDBErrExpectedRightBracket put: 1035.
ErrorSymbols at: #StDBErrStmtNoEffect put: 1037 .
ErrorSymbols at: #StDBErrCodeTooBig put: 1038.
ErrorSymbols at: #StDBErrPrimNotAllowed put: 1041.
ErrorSymbols at: #StDBErrExpectedBoolOrExpr put: 1042.
ErrorSymbols at: #StDBErrExpectedBlockOrExpr put: 1043.
ErrorSymbols at: #StDBErrExpectedIntOrExpr put: 1044.
ErrorSymbols at: #StDBErrNotPosIntOrExpr put: 1045.
ErrorSymbols at: #StDBErrDisallowedSelector put: 1046.
ErrorSymbols at: #StDBErrBadNumOfArgs put: 1047.
ErrorSymbols at: #StDBErrLiteralInvariant put: 1048 .
ErrorSymbols at: #StDBErrExpectedOperand put: 1049.
ErrorSymbols at: #StDBErrBadSelectOperator put: 1050.
ErrorSymbols at: #StDBErrExpectedSelectTerm put: 1051.
ErrorSymbols at: #StDBErrTermsNotParen put: 1052.
ErrorSymbols at: #StDBErrBadNumOfSelectArgs put: 1053.
ErrorSymbols at: #StDBErrSourceNotEUCFormat put: 1054.
ErrorSymbols at: #StDBErrMaxArgs put: 1056.
ErrorSymbols at: #StDBErrCodeGenLogic put: 1057.
ErrorSymbols at: #StDBErrFirstTermCannotBeSetValued put: 1058.
ErrorSymbols at: #StDBErrIllegalProtectedMethod put: 1059.
ErrorSymbols at: #StDBMissingProtectedToken put: 1060.
ErrorSymbols at: #StDBSuperNotAllowed put: 1061.
ErrorSymbols at: #StDBUnusedTemp put: 1062.
ErrorSymbols at: #StDBMbStrOddSize put: 1063.
ErrorSymbols at: #StDBPrimitiveInPragma put: 1064.
ErrorSymbols at: #StDBPragmaInPrim put: 1065.
ErrorSymbols at: #StDBErrExpectedLitOrExpr put: 1066 .
ErrorSymbols at: #StDBNoDigitInAtEnv put: 1067  .
ErrorSymbols at: #StDBBadChInAtEnv put: 1068  .
ErrorSymbols at: #StDBEnvTooBig put: 1069  .
ErrorSymbols at: #StDBByteArrElemRange put: 1070 .
"1071 is ArrayBuilder conversion,  should not be in dictionary"
ErrorSymbols at: #rtErrCompilerBadIr put: 1072 .
ErrorSymbols at: #rtErrComExpressionDepth put: 1073 .
ErrorSymbols at: #rtErrMethodSrcInvalid put: 1074 .
"1075 is MALFORMED_COMPILER_ERROR, hard coded in image"
ErrorSymbols at: #StDBErrSymTooBig put: 1076 .
ErrorSymbols at: #StDBbadAtRuby put: 1077 .
ErrorSymbols at: #StDBnoRuby put: 1079 .
ErrorSymbols at: #StDBBadLit put: 1080 .
^true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_initRuntimeErrs2
ErrorSymbols at: #rtErrInvalidTransMode put: 2001.
ErrorSymbols at: #rtErrBadSymbolList put: 2002.
ErrorSymbols at: #objErrBadOffsetIncomplete put: 2003.
ErrorSymbols at: #rtErrBadSubscript put: 2004.
ErrorSymbols at: #gciErrBadNumMsgParts put: 2005.
ErrorSymbols at: #rtErrAuthArraySize put: 2006.
ErrorSymbols at: #rtErrShouldNotImplement put: 2007.
ErrorSymbols at: #rtErrSubclassResponsibility put: 2008.
ErrorSymbols at: #objErrClassVariant put: 2009.

  "Warning, following error number hard coded in methods for speed"
ErrorSymbols at: #rtErrDoesNotUnderstand put: 2010.

ErrorSymbols at: #objErrNotObjectSecurityPolicy put: 2011.
ErrorSymbols at: #objErrNotIndexable put: 2012.
ErrorSymbols at: #rtErrCantPerform put: 2013.
ErrorSymbols at: #classErrSubclassDisallowed put: 2014.

ErrorSymbols at: #objErrNotInColl put: 2015.

ErrorSymbols at: #repErrMaxExtents put: 2016.
ErrorSymbols at: #rtErrBadPattern put: 2017.
ErrorSymbols at: #rtErrBadBlockArgCount put: 2018.
ErrorSymbols at: #objErrCollectionEmpty put: 2019.
ErrorSymbols at: #rtErrArgNotChr put: 2020.
ErrorSymbols at: #rtErrKeyNotFound put: 2021.
ErrorSymbols at: #rtErrBadDateTimeArgs put: 2022.
ErrorSymbols at: #genericKernelError put: 2023 .
ErrorSymbols at: #rtErrNoSuchBp put: 2024.
ErrorSymbols at: #repErrCantCreateFile put: 2025.
ErrorSymbols at: #numErrIntDivisionByZero put: 2026.
ErrorSymbols at: #rtErrSpecialOrNotCommitted put: 2027.
ErrorSymbols at: #repErrPreGrowFailure put: 2028.
ErrorSymbols at: #rtErrBeginTrans put: 2029.
ErrorSymbols at: #rtErrPrimOutsideTrans put: 2030.
ErrorSymbols at: #objErrInvariant put: 2031.
ErrorSymbols at: #classErrMethCatExists put: 2032.
ErrorSymbols at: #classErrSelectorNotFound put: 2033.
ErrorSymbols at: #lockErrRemove put: 2034.
ErrorSymbols at: #classErrMethCatNotFound put: 2035.
ErrorSymbols at: #classErrByteObjInstVars put: 2036.
"2037 is reserved for GBS 32-bit backward compatibility. Do not reuse."
ErrorSymbols at: #classErrInvariantSuperClass put: 2038.
ErrorSymbols at: #classErrNscNotIndexable put: 2039.
ErrorSymbols at: #repErrExtentNotMounted put: 2040.
ErrorSymbols at: #rtErrPagesNeedScavenging put: 2041.
ErrorSymbols at: #classErrNscInstVars put: 2042.
ErrorSymbols at: #classErrClassVarNameExists put: 2043.
ErrorSymbols at: #classErrPoolDictExists put: 2044.
ErrorSymbols at: #classErrPoolDictNotFound put: 2045.
ErrorSymbols at: #clampErrNoSuchInstvar put: 2046.
ErrorSymbols at: #clampErrNotAClass put: 2047.
ErrorSymbols at: #clampErrNotAClampspec put: 2048.
ErrorSymbols at: #clampErrBadArg put: 2049.
ErrorSymbols at: #repErrBadExtentSize put: 2051.
ErrorSymbols at: #repErrCantOpenFile put: 2052.
ErrorSymbols at: #rtErrNoSuchInstVar put: 2053.
ErrorSymbols at: #rtErrTagNotAllowed put: 2054.
ErrorSymbols at: #rtErrBadTagNum put: 2055.
ErrorSymbols at: #segErrMaxSegGroups put: 2056.
ErrorSymbols at: #segErrBadAuthKind put: 2057.
ErrorSymbols at: #rtUnresolvedFwdRefs put: 2058.
ErrorSymbols at: #rtErrStackLimit put: 2059.
ErrorSymbols at: #rtErrArgNotPositive put: 2060.
ErrorSymbols at: #rtErrArgOutOfRange put: 2061.
ErrorSymbols at: #rtErrCannotChgConstraint put: 2062.
^true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_initRuntimeErrs3
ErrorSymbols at: #rtErrNoMessage put: 2063.
   "2063 hard coded in object.gs, to handle damaged error dictionary case"

ErrorSymbols at: #numErrArgNotChr put: 2064.
ErrorSymbols at: #numErrArgNotFltException put: 2065.
ErrorSymbols at: #numErrFltException put: 2066.
ErrorSymbols at: #numErrArgNotRoundingMode put: 2067.
ErrorSymbols at: #segErrCantMoveObj put: 2068.
ErrorSymbols at: #rtErrExceptionNotLinked put: 2069.
ErrorSymbols at: #numErrArgNotFltStatus put: 2070.
ErrorSymbols at: #lockErrUndefinedLock put: 2071.
ErrorSymbols at: #rtErrBadDictConstraint put: 2072.
ErrorSymbols at: #lockErrIncomplete put: 2073.
ErrorSymbols at: #lockErrObjHasChanged put: 2074.
ErrorSymbols at: #lockErrDenied put: 2075.
ErrorSymbols at: #rtErrMaxClusterId put: 2076.
ErrorSymbols at: #rtErrBadErr put: 2077.
ErrorSymbols at: #rtErrUserIdAlreadyExists put: 2078.
ErrorSymbols at: #rtErrCantReturn put: 2079.
ErrorSymbols at: #rtErrCantChangeClass put: 2080.
ErrorSymbols at: #rtErrCantBecomeSpecial put: 2081.
ErrorSymbols at: #rtErrGarbageCollect put: 2082.
ErrorSymbols at: #rtErrPrimNotFound put: 2083.
ErrorSymbols at: #rtErrNoInstVars put: 2084.
ErrorSymbols at: #rtErrExpectedBoolean put: 2085.
ErrorSymbols at: #rtErrDirtyObjsNeedsInit put: 2086.
ErrorSymbols at: #rtErrCantChangePassword put: 2087.
ErrorSymbols at: #rtErrNewStackLimit put:2088 .
ErrorSymbols at: #rtErrBadCopyFromTo put: 2089.
ErrorSymbols at: #rtErrNilKey put: 2090.
ErrorSymbols at: #rtErrCantBecomeBothIdx put: 2091 .
ErrorSymbols at: #rtErrNoProcessToContinue put: 2092.
ErrorSymbols at: #rtErrBadStreamPosition put: 2093.
ErrorSymbols at: #rtErrBadArgKind put: 2094.
ErrorSymbols at: #classErrClassVarNotFound put: 2095.
ErrorSymbols at: #assocErrNoElementsDetected put: 2096.
ErrorSymbols at: #classErrNotAVar put: 2097.
ErrorSymbols at: #segErrTooManyGroups put: 2098.
ErrorSymbols at: #rtErrExpectedByteValue put: 2099.
ErrorSymbols at: #classErrBadFormat put: 2100.
ErrorSymbols at: #objErrDoesNotExist put: 2101.
ErrorSymbols at: #objErrNotOopKind put: 2102.
ErrorSymbols at: #objErrNotByteKind put: 2103.
ErrorSymbols at: #objErrNotNscKind put: 2104.
ErrorSymbols at: #objErrAlreadyExists put: 2105.
ErrorSymbols at: #objErrOopNotAllocated put: 2106.
ErrorSymbols at: #objErrConstraintViolation put: 2107.
ErrorSymbols at: #rtErrExpectedClass put: 2108.
ErrorSymbols at: #objClassNotOopKind put: 2109.
ErrorSymbols at: #objErrBadOffset put: 2110.
ErrorSymbols at: #objErrCantCreateInstance put: 2111.
ErrorSymbols at: #objClassNotByteKind put: 2112.
ErrorSymbols at: #lockErrArgSize put: 2113 .
ErrorSymbols at: #objErrNotSpecialKind put: 2114.
ErrorSymbols at: #authErrSegRead put: 2115.
ErrorSymbols at: #authErrSegWrite put: 2116.
ErrorSymbols at: #objErrNotOopOrNsc put: 2117.
ErrorSymbols at: #rtErrObsolete put: 2118.
ErrorSymbols at: #rtErrCantBecomeOneIdx put: 2119 .
ErrorSymbols at: #objErrNotFlt put: 2120.
ErrorSymbols at: #rtErrCantBecomeClassKind put: 2121 .
ErrorSymbols at: #classErrByteSubclass put: 2122.
ErrorSymbols at: #repErrBadBkupSwizzle put: 2123 .
ErrorSymbols at: #repErrCantCreateRepos put: 2124.
ErrorSymbols at: #repErrBadFileSpec put: 2125.
^true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_initRuntimeErrs4
ErrorSymbols at: #repErrFileAlreadyExists put: 2126.
ErrorSymbols at: #rtErrDuplicateKey put: 2127 .
ErrorSymbols at: #assocErrBadComparison put: 2128.
ErrorSymbols at: #repErrIncompatibleRepos put: 2129.
ErrorSymbols at: #assocErrClassModifiable put: 2130.
ErrorSymbols at: #classErrConstrInher put: 2131.
"2132 is reserved for GBS 32-bit backward compatibility. Do not reuse."
ErrorSymbols at: #repErrBadBkupVersion put: 2133.
"2134 reserved for GBS backward compatibility with GS 6.1  DO NOT REUSE"

ErrorSymbols at: #rtErrCantBecomeIndexedNsc put: 2135.
ErrorSymbols at: #rtErrNoIndexForPath put: 2136.
ErrorSymbols at: #objClassNotOopOrNscKind put: 2137.
ErrorSymbols at: #rtMaxRecursion put: 2138.
ErrorSymbols at: #rtErrBadSession put: 2139.
ErrorSymbols at: #rtErrNotOnlyUser put: 2140.
ErrorSymbols at: #objErrMaxSize put: 2141.
ErrorSymbols at: #rtErrInvalidMethod put: 2142.
ErrorSymbols at: #repErrMaxOnlineRepos put: 2143.
ErrorSymbols at: #rtErrRcQueueEntriesFound put: 2144.
ErrorSymbols at: #rtErrFirstPathTermSetValued put: 2145.
ErrorSymbols at: #gciErrParentSession put: 2146.
ErrorSymbols at: #gciErrAlreadyLoggedIn put: 2147.
"2148 is reserved for GBS 32-bit backward compatibility. Do not reuse."
ErrorSymbols at: #classErrBadIdentifier put: 2149.
ErrorSymbols at: #classErrConstrPrivateIv put: 2150.
ErrorSymbols at: #rtErrNoPriv put: 2151.
ErrorSymbols at: #rtErrInvalidBtreeReadStream put: 2152.
ErrorSymbols at: #rtErrDecrNotAllowed put: 2153.
ErrorSymbols at: #repErrReposNotAttached put: 2154.
ErrorSymbols at: #repErrReposNeedsRecovery put: 2155.
ErrorSymbols at: #errIllegalRamSelf put: 2156.
ErrorSymbols at: #repErrReposRead put: 2157.
ErrorSymbols at: #repErrReposWrite put: 2158.
"2159 is reserved for GBS 32-bit backward compatibility. Do not reuse."
ErrorSymbols at: #rtErrSelectiveAbort put: 2160.
ErrorSymbols at: #objErrDateTimeOutOfRange put: 2161.
ErrorSymbols at: #objErrLongNotSmallInt put: 2162.
ErrorSymbols at: #objErrNotLong put: 2163.
ErrorSymbols at: #objErrNotChr put: 2164.
ErrorSymbols at: #lgcErrCompressFailure put: 2165.
ErrorSymbols at: #lgcErrUncompressFailure put: 2166.
ErrorSymbols at: #lgcErrTravswizzFailure put: 2167.
ErrorSymbols at: #errArgTooLarge put: 2168 .
ErrorSymbols at: #commitPromoteFailed put: 2169 .
ErrorSymbols at: #objErrDiffSizeColl put: 2170 .
ErrorSymbols at: #rtErrUalibLoadFailed put: 2171.
ErrorSymbols at: #lgcErrObjRepHdrSize put: 2172 .
ErrorSymbols at: #authErrSegLoad put: 2173.
ErrorSymbols at: #authErrSegRecursion put: 2174.
ErrorSymbols at: #assocErrPathTooLong put: 2175.
ErrorSymbols at: #repErrFileNameTooBig put: 2176.
ErrorSymbols at: #rtErrSemaphore put: 2177.
ErrorSymbols at: #rtErrPasswordTooBig put: 2178.
ErrorSymbols at: #errNotSameClassHist put: 2179.
ErrorSymbols at: #classErrMethDictLimit put: 2180.
ErrorSymbols at: #rtErrShrPcDetach put: 2181.
^true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_initRuntimeErrs5
ErrorSymbols at: #repErrCantDispose put: 2182.
ErrorSymbols at: #rtErrInternal put: 2183.
ErrorSymbols at: #rtErrBadStreamColl put: 2184.
ErrorSymbols at: #rtErrBadFormat put: 2185.
ErrorSymbols at: #rtErrShrpcCompatibility put: 2186.
ErrorSymbols at: #segErrBadGroup put: 2187.
ErrorSymbols at: #rtErrBadPriv put: 2188.
ErrorSymbols at: #rtErrResolveSymFailed put: 2189.
ErrorSymbols at: #rtErrSymAlreadyDefined put: 2190.
ErrorSymbols at: #rtErrSymNotFound put: 2191.
ErrorSymbols at: #rtErrEofOnReadStream put: 2192.
ErrorSymbols at: #assocErrSortOddLengthArray put: 2193.
ErrorSymbols at: #assocErrBadDirection put: 2194.
ErrorSymbols at: #rtErrConfigReadOnly put: 2195 .
ErrorSymbols at: #rtErrBadFormatSpec put: 2196.
ErrorSymbols at: #hostErrFileExport put: 2197.
ErrorSymbols at: #hostErrFileImport put: 2198.
ErrorSymbols at: #hostErrFileDirectory put: 2199.
ErrorSymbols at: #hostErrFileDelete put: 2200.
ErrorSymbols at: #hostErrPerform put: 2201.
ErrorSymbols at: #rtErrSigMsgTooBig put: 2202.
ErrorSymbols at: #gciErrOpInProgress put: 2203.
ErrorSymbols at: #gciErrNoStartCmd put: 2204.
ErrorSymbols at: #objErrBadClusterBucket put: 2205.
ErrorSymbols at: #rtErrEpochGcArraySize put: 2206.
ErrorSymbols at: #objErrResultNscTooBig put: 2207.
ErrorSymbols at: #hostErrMemoryAlloc put: 2208.
ErrorSymbols at: #gciErrCatchBuffNotFound put: 2209.
ErrorSymbols at: #gciErrCatchBuffLimit put: 2210.
ErrorSymbols at: #objErrNotBoolean put: 2211.
ErrorSymbols at: #rtErrUncompiledMethod put: 2212.
ErrorSymbols at: #rtErrMustBeSystemUser put: 2213.
ErrorSymbols at: #rtErrBadPassword put: 2214.
ErrorSymbols at: #gciErrTravObjNotFound put: 2215.
ErrorSymbols at: #gciErrTravCompleted put: 2216.
ErrorSymbols at: #gciErrTravBuffTooSmall put: 2217.
ErrorSymbols at: #rtErrPathToStrIvname put: 2218.
ErrorSymbols at: #objErrNegativeCount put: 2219.
ErrorSymbols at: #gciErrResultPathTooLarge put: 2220.
ErrorSymbols at: #gciErrFetchPathFail put: 2221.
ErrorSymbols at: #rtErrStrToPathIvname put: 2222.
"2223 is reserved for GBS 32-bit backward compatibility. Do not reuse."
ErrorSymbols at: #lgcErrOopPacketTooLong put: 2229.
ErrorSymbols at: #lgcErrTravRead put: 2516.
ErrorSymbols at: #errAlmostOomPending put: 2517.
ErrorSymbols at: #lgcErrPacketKindBad put: 2230.
ErrorSymbols at: #lgcErrExpectedContinue put: 2231.
ErrorSymbols at: #lgcErrPacketKindUnknown put: 2233.
ErrorSymbols at: #hostErrLogFileNotOpened put: 2235.
ErrorSymbols at: #classErrMaxInstVars put: 2236.
ErrorSymbols at: #rtErrTooManyErrArgs put: 2237.
ErrorSymbols at: #objErrBadSize put: 2238.
ErrorSymbols at: #lgcErrInconsistentSize put: 2239.
ErrorSymbols at: #lgcErrInconsistentObjKind put: 2240.
^true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_initRuntimeErrs6
ErrorSymbols at: #rtErrStartGc put: 2241.
ErrorSymbols at: #rtErrBadArgKind2 put: 2242.
ErrorSymbols at: #lgcErrSequenceMismatch put: 2243.
ErrorSymbols at: #rtErrExceptBlockNumArgs put: 2244 .
ErrorSymbols at: #rtErrGciStoreFloat put: 2245 .
ErrorSymbols at: #rtErrGciStoreClassMismatch put: 2246 .
ErrorSymbols at: #rtErrNscParticipatesInMultipleTerms put: 2247.

ErrorSymbols at: #rtErrCommitDbInRestore put: 2248 .
ErrorSymbols at: #rtErrCommitDisallowed put: 2249 .
ErrorSymbols at: #tranLogIoError put: 2250.
ErrorSymbols at: #lgcErrPacketKind put: 2251.
ErrorSymbols at: #rtErrLoadSaveStack put: 2252.
ErrorSymbols at: #rtErrUnknownBytecode put: 2253.
ErrorSymbols at: #errSesBlockedOnOutput put: 2254 .
ErrorSymbols at: #errPrimNotSupported put: 2255 .
ErrorSymbols at: #authErrSegCurrentSeg put: 2256.
ErrorSymbols at: #authErrSegSetCurrentSeg put: 2257.
ErrorSymbols at: #rtErrPrimFailed put: 2258 .
ErrorSymbols at: #gciErrExecClientUserAct put: 2259.
ErrorSymbols at: #gciErrActiveSessions put: 2260.
ErrorSymbols at: #objErrCorruptObj put: 2261.
ErrorSymbols at: #gciErrMaxActionArgs put: 2262.
ErrorSymbols at: #gciErrBadNumMethodArgs put: 2263.
ErrorSymbols at: #gciErrUserActionPending put: 2264.
ErrorSymbols at: #gciErrBadNumUaActionArgs put: 2265.
ErrorSymbols at: #rtErrInstvarAddToNsc put: 2266.
ErrorSymbols at: #rtErrVaryingConstrBytes put: 2267.
ErrorSymbols at: #rtErrVaryingConstrNonidx put: 2268.
ErrorSymbols at: #rtErrInstvarAddToBytes put: 2269.
ErrorSymbols at: #rtErrClassNotModifiable put: 2270.
ErrorSymbols at: #rtErrAddDupInstvar put: 2271.
ErrorSymbols at: #rtErrNotASubclassOf put: 2272.
ErrorSymbols at: #rtErrConstrNotSubclassOf put: 2273.
ErrorSymbols at: #rtErrConstrNotAClass put: 2274.
ErrorSymbols at: #rtErrObjInvariant put: 2275.
ErrorSymbols at: #classErrDupVarConstr put: 2276.
ErrorSymbols at: #bkupErrLoginsEnabled put: 2277.
ErrorSymbols at: #classErrRemoveInherIv put: 2278.
ErrorSymbols at: #concurErrInvalidMode put: 2279.
ErrorSymbols at: #classErrSelectorLookup put: 2280.
ErrorSymbols at: #rtErrBadEUCFormat put: 2281.
ErrorSymbols at: #rtErrGaijiNotSupported put: 2282.
ErrorSymbols at: #rtErrInvalidArgClass put: 2283.
ErrorSymbols at: #rtErrSizeLimit put: 2284.
ErrorSymbols at: #rtErrNoEUCRep put: 2285.
ErrorSymbols at: #rtErrBadEUCValue put: 2286.
ErrorSymbols at: #rtErrInvalidLang put: 2287.
ErrorSymbols at: #rtErrInvalidIndexPathExpression put: 2288.
ErrorSymbols at: #rtErrDependencyListTooLarge put: 2289.
ErrorSymbols at: #rtErrMaxCommitRetry put: 2290.
ErrorSymbols at: #rtErrInvalidArgument put: 2291.
ErrorSymbols at: #rtErrPathNotTraversable put: 2292.
ErrorSymbols at: #rtErrBtreeReadStreamEndOfStream put: 2293.
ErrorSymbols at: #rtErrObjectPathTermNotInDependencyList put: 2294.
ErrorSymbols at: #rtErrObjectInvalidOffset put: 2295.
ErrorSymbols at: #rtErrObjectNoDependencyList put: 2296.
ErrorSymbols at: #rtErrIndexDictionaryEntryNotInDictionary put: 2297.
ErrorSymbols at: #rtErrPathTermObjectNotAnNsc put: 2298.
ErrorSymbols at: #rtErrIdentityIndexCannotInvokeRangeOperation put: 2299.
^ true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_initRuntimeErrs7
ErrorSymbols at: #rtErrRangeEqualityIndexInvalidClassKindForBtree put: 2300.
ErrorSymbols at: #rtErrRangeEqualityIndexObjectNotInBtree put: 2301.
ErrorSymbols at: #errNoBackupInProgress put: 2302.
ErrorSymbols at: #bkupErrOpenFailed put: 2303.
ErrorSymbols at: #bkupErrMbyteLimitBadRange put: 2304.
ErrorSymbols at: #bkupErrWriteFailed put: 2305.
ErrorSymbols at: #bkupErrInProgress put: 2306.
ErrorSymbols at: #bkupErrReadFailed put: 2307.
"2308 is reserved for GBS 32-bit backward compatibility. Do not reuse."
ErrorSymbols at: #rtErrBagClassDoesNotSupportRangeOperators put: 2309.
ErrorSymbols at: #rtErrBagOnlySelectBlockAllowed put: 2310.
ErrorSymbols at: #rtErrBagOnlyOnePredicateAllowed put: 2311.
ErrorSymbols at: #rtErrBagNoRangeIndexOnPathExpression put: 2312.
ErrorSymbols at: #rtErrBagInvalidPredicateForStreamSelection put: 2313.
ErrorSymbols at: #rtErrBagOperationNotSupportedForStreamSelection put: 2314.
ErrorSymbols at: #rtErrBagInvalidSortSpecification put: 2315.
ErrorSymbols at: #rtErrIndexAuthErrSegRead put: 2316.
ErrorSymbols at: #objErrTime_tOutOfRange put: 2317.
ErrorSymbols at: #genericError put: 2318.
ErrorSymbols at: #rtErrMethodProtected put: 2319.
"2320 is reserved for GBS 32-bit backward compatibility. Do not reuse."
"ErrorSymbols at: #rtErrPreventingCommit put: 2321.  no longer used"
ErrorSymbols at: #rtErrCantBecomeSelfOnStack put: 2322 .
ErrorSymbols at: #rtErrObjectProtected put: 2323 .
ErrorSymbols at: #rtErrNewTranlogDirFail put: 2324 .
ErrorSymbols at: #errCommitWhileBackupInProgress put: 2325 .
ErrorSymbols at: #errUnconvertedObject put: 2326 .
"2327 is reserved for GBS 32-bit backward compatibility. Do not reuse."
ErrorSymbols at: #rtErrCommitProhibitingError put: 2328 .
ErrorSymbols at: #rtErrAttemptToPassivateInvalidObject put: 2329 .
ErrorSymbols at: #rtErrTimeToRestoreToArg put: 2330 .
ErrorSymbols at: #lockErrAllSymbols put: 2331.
ErrorSymbols at: #gciErrSymbolFwdRef put: 2332.
ErrorSymbols at: #rtErrChangeSymbol put: 2333.
ErrorSymbols at: #rtErrObjVariant put: 2334.
ErrorSymbols at: #rtErrAlreadyHasSubclasses put: 2335.
ErrorSymbols at: #clientForwarderSend put: 2336.
ErrorSymbols at: #rtErrBadSize put: 2337.
ErrorSymbols at: #rtErrFreeSpaceThreshold put: 2338.
ErrorSymbols at: #rtErrTranlogDirFull put: 2339.
ErrorSymbols at: #objErrDictConstraintViolation put: 2340.
ErrorSymbols at: #rtMaxPasswordSize put: 2341 .
ErrorSymbols at: #rtMinPasswordSize put: 2342 .
ErrorSymbols at: #rtMaxConsecutiveChars put: 2343 .
ErrorSymbols at: #rtMaxRepeatingChars put: 2344 .
ErrorSymbols at: #rtMaxCharsOfSameType put: 2345 .
ErrorSymbols at: #rtDisallowedPassword put: 2346 .
ErrorSymbols at: #rtErrWarningPasswordExpire put: 2347 .
ErrorSymbols at: #errLogDirNotExist put: 2348 .
ErrorSymbols at: #errArgTooSmall put: 2349 .
ErrorSymbols at: #errNoStructuralUpdate put: 2350 .
ErrorSymbols at: #rtObsoleteClass put: 2351 .
ErrorSymbols at: #rtErrLocalSessionFailedCommit put: 2352 .
ErrorSymbols at: #rtErrRemoteSessionFailedCommit put: 2353 .
ErrorSymbols at: #rtErrNoElemDetected put: 2354 .
ErrorSymbols at: #rtErrDateTimeOutOfRange put: 2355 .
ErrorSymbols at: #rtErrObjNotFound put: 2356 .
ErrorSymbols at: #rtErrFailedStnCfgWrite put: 2357 .
ErrorSymbols at: #gciErrNoUserAction put: 2358 .
ErrorSymbols at: #segErrMaxUserProfileGroups put: 2359.
ErrorSymbols at: #rtErrGsCommitListNBTimeout put: 2360.
ErrorSymbols at: #rtErrGcGemStartupFailures put: 2361.
ErrorSymbols at: #rtErrGsSocket put: 2362.
ErrorSymbols at: #rtErrGsSocketInvariant put: 2363.
ErrorSymbols at: #rtErrLostSessionState put: 2364.
ErrorSymbols at: #rtErrDelayInProgress put: 2365.
ErrorSymbols at: #rtErrSchedulerDeadlocked put: 2366.
ErrorSymbols at: #rtErrPrimitiveSysErr put: 2367.
ErrorSymbols at: #rtErrGsProcessTerminated put: 2368.
ErrorSymbols at: #rtErrNoMoreCBuffers put: 2369.
ErrorSymbols at: #rtErrRemoteError put: 2370.
ErrorSymbols at: #rtErrRemoteLoginFailed put: 2371.
ErrorSymbols at: #rtErrClientFwd put: 2372.
ErrorSymbols at: #rtErrBadGsProcessArgCount put: 2373.
ErrorSymbols at: #rtErrPasswordNotVariant put: 2374.
ErrorSymbols at: #rtErrNotEnoughCBuffers put: 2375.
ErrorSymbols at: #rtErrGsProcessNotDebuggable put: 2376.
ErrorSymbols at: #gciErrArgNotPairs put: 2377.
ErrorSymbols at: #rtErrClientActionDisallowed put: 2378.
ErrorSymbols at: #rtErrRemoveSpecialUser put: 2379.
"2380 changed to 4058"

"2382 reserved for GBS backward compatibility with GS 6.1  DO NOT REUSE"
"2383 reserved for GBS backward compatibility with GS 6.1  DO NOT REUSE"
"2384 reserved for GBS backward compatibility with GS 6.1  DO NOT REUSE"
"2385 reserved for GBS backward compatibility with GS 6.1  DO NOT REUSE"
"2386 reserved for GBS backward compatibility with GS 6.1  DO NOT REUSE"
"2387 reserved for GBS backward compatibility with GS 6.1  DO NOT REUSE"


ErrorSymbols at: #rtErrCantReadFile put: 2388.
ErrorSymbols at: #rtErrFileCorrupt put: 2389.
ErrorSymbols at: #rtErrGcCommitFailure put: 2390.
ErrorSymbols at: #rtErrSymbolCreateErr put: 2391.
ErrorSymbols at: #repErrBkupNoStart put: 2392.
ErrorSymbols at: #rtErrDecodedObjDoesNotExist put: 2393.
ErrorSymbols at: #rtErrMaxSuperclassDepth put: 2394 .
ErrorSymbols at: #rtErrReclaimAllMissingGcGem put: 2395 .

ErrorSymbols at: #rtErrCantSuspendLogins put: 2400 .
ErrorSymbols at: #rtErrWeakDictNeedsInit put: 2401 .
ErrorSymbols at: #rtErrSymbolTooLarge put: 2402 .
ErrorSymbols at: #rtErrOmFlushFailed put: 2403 .
ErrorSymbols at: #rtErrNoExistingSymbol put: 2404 .
ErrorSymbols at: #rtErrObjMustBeCommitted put: 2405 .
ErrorSymbols at: #rtErrCantWriteFile put: 2406 .
ErrorSymbols at: #rtErrObjIsNp put: 2407 .
ErrorSymbols at: #rtErrSuperclassIsNP put: 2408 .
ErrorSymbols at: #rtErrContinueTransFail put: 2409 .
ErrorSymbols at: #lgcErrTravBuffSize put: 2411 .
ErrorSymbols at: #rtErrAbortWouldLoseData put: 2412 .
ErrorSymbols at: #bkupErrNotInProgress put: 2413.
ErrorSymbols at: #gciErrCallNotSupported put: 2414.
ErrorSymbols at: #rtErrRemoveAllIndexesFailed put: 2415.
ErrorSymbols at: #rtErrCollectionWithIncompleteIndex put: 2416.
ErrorSymbols at: #rtErrNoMoreObjectSecurityPolicies put: 2417.
ErrorSymbols at: #lockErrDeadlock put: 2418.
ErrorSymbols at: #lockErrTimeout put: 2419.
ErrorSymbols at: #lockErrInvalidObject put: 2420 .
ErrorSymbols at: #authErrProcessSwitch put: 2421 .
ErrorSymbols at: #rtErrNotInExportSet put: 2422.
ErrorSymbols at: #rtErrGciTravNotLicensed put: 2423.
ErrorSymbols at: #rtErrCommitDisallowedUntilAbort put: 2424.
ErrorSymbols at: #rtErrRollbackDlFail put: 2425.
ErrorSymbols at: #rtErrCantBecomeGeneric put: 2426.
ErrorSymbols at: #rtErrOpNotAllowed put: 2427.

ErrorSymbols at: #rtErrExceptionAlreadyInstalled put: 2480.
ErrorSymbols at: #rtErrNativeCodeGen put: 2481 .
ErrorSymbols at: #rtErrNativeCodeNoBreakpts put: 2482 .
ErrorSymbols at: #rtErrDynIvDependencyTag put: 2483 .
ErrorSymbols at: #rtErrDynIvStore  put: 2484 .
"no image error info for 2485, GS_ERR_VM_OUT_OF_GSSCOPES"
ErrorSymbols at: #rtErrReposUpgradeNeeded put: 2486 .
ErrorSymbols at: #ansiNotification put: 2487 .
ErrorSymbols at: #rtErrCannotConvertStack put: 2488 .
ErrorSymbols at: #gciErrActionDefined put: 2489.   "v3.0, number changed, no longer fatal"

ErrorSymbols at: #rtErrRcUpdateDisallowed put: 2500.
ErrorSymbols at: #rtErrGetGcLockFailed put: 2501.
ErrorSymbols at: #rtErrStackLimitRed put: 2502 .  "Not trappable with Exceptions"
ErrorSymbols at: #rtErrLrgIntOverflow put: 2503 .
ErrorSymbols at: #errPrintf put: 2505 .
ErrorSymbols at: #errBadIvName put: 2506 .
ErrorSymbols at: #errRangeErr put: 2507 .
ErrorSymbols at: #errTypeErr put: 2508 .
ErrorSymbols at: #errArgumentErr put: 2509 .
ErrorSymbols at: #errRubySystemExitErr put: 2510 .
ErrorSymbols at: #errMemoryRegionFull put: 2511 .
ErrorSymbols at: #rtErrNotPowerOfTwo put: 2512 .
ErrorSymbols at: #rtErrPasswordMissingChar put: 2513 .
ErrorSymbols at: #errDuringMtOperation put: 2514 .
ErrorSymbols at: #authErrStoreTrav put: 2518 .
^true
%

category: 'Image Upgrade'
classmethod: Upgrade1B
_initRuntimeErrs8
"Authentication errors new in Gs64 v3.0"
ErrorSymbols at: #rtErrInvalidAuthSchemeId put: 2600.
ErrorSymbols at: #rtErrInvalidAuthSchemeSymbol put: 2601.
ErrorSymbols at: #rtErrInvalidUnixUserId put: 2602.
ErrorSymbols at: #rtErrIllegalAuthSchemeChange put: 2603.
ErrorSymbols at: #rtErrAuthIllegalOperation put: 2604 .
ErrorSymbols at: #rtErrAuthIllegalPasswordChange put: 2605.
ErrorSymbols at: #rtErrIllegalPasswordExpiration put: 2606.
ErrorSymbols at: #rtErrIllegalDn put: 2607.
ErrorSymbols at: #rtErrGroupAlreadyExists put: 2608.
ErrorSymbols at: #rtErrPrincipalAlreadyExists put: 2609.
ErrorSymbols at: #rtErrGsSecureSocket put: 2755 .
^true
%

! Class Initialization Excluded by export visitor
!  Upgrade1B initialize.
