! Copyright (C) GemTalk Systems 1986-2025.  All Rights Reserved.
! Class extensions for 'Behavior'

!		Instance methods for 'Behavior'

category: 'Category'
method: Behavior
category

"FINAL version of this method in behavio_2.gs .

 Returns the classCategory instance variable of the receiver.  If the receiver's
 category is nil, returns its superclass's category."

| categ supercls |
categ := self _classCategory .
supercls := self superClass .
categ == nil ifTrue: [
  supercls == Object ifTrue:[ ^'User Classes' ].
  supercls == nil ifTrue: [ ^'Kernel' ].
  ^ supercls category
].
^ categ
%

category: 'Pragmas'
method: Behavior
compiledMethodAt: aSelector environmentId: envId otherwise: notFoundVal
  | sym pmd md meth |
  sym := Symbol _existingWithAll: aSelector.
  sym ifNil:[ ^ notFoundVal ].
  md := self transientMethodDictForEnv: envId .
  md ifNotNil:[
    meth := md at: sym otherwise: nil .
    meth ifNotNil:[ ^ meth ].
  ].
  pmd := self persistentMethodDictForEnv: envId .
  meth := notFoundVal .
  pmd ifNotNil:[
    meth := pmd at: sym otherwise: notFoundVal .
  ].
  ^ meth
%

category: 'Updating the Method Dictionary'
method: Behavior
compileMethod: sourceString dictionaries: aSymbolList category: aCategoryString environmentId: environmentId
	"This compiles some source code for the receiver.  The first argument,
 sourceString, is the string of source code to be compiled.  The second
 argument is a SymbolList to be used in parsing, along with the list of all
 class variables and pool dictionaries for the receiver and all of its
 superclasses.  The third argument (a String) indicates the method's category.

 sourceString must be a kind of String or DoubleByteString.  Instances of
 JapaneseString are not supported as source strings.  String literals
 ('abc') are generated as instances of the class of sourceString,
 unless sourceString is a Symbol, in which case 'abc' produces a String.
 If sourceString is a DoubleByteSymbol, 'abc' produces a DoubleByteString.

 anEnvironmentId must be a SmallInteger >= 0 and <= 16rFFFF.
 0 denotes the base Smalltalk image.  1 was reserved for use by Ruby .

 If there are no errors, this adds the resulting compiled method to the
 receiver's method dictionary and returns that method,
 otherwise signals a CompileError .
 A CompileWarning may be signaled, after adding the new method
 to a receiver's method dictionary."

	| symList categ meth |
	self _validatePrivilege
		ifFalse: [ ^ nil ].

	aSymbolList class == SymbolList
		ifTrue: [ symList := aSymbolList ]
		ifFalse: [ 
			aSymbolList _validateClass: Array.
			symList := SymbolList withAll: aSymbolList ].
	categ := aCategoryString asSymbol.

	GsObjectSecurityPolicy
		setCurrent: self objectSecurityPolicy
		while: [ 
			meth := self
				compileMethod: sourceString
				dictionaries: symList
				category: categ
				intoMethodDict: nil
				intoCategories: nil
				environmentId: environmentId ].
	^ meth
%

category: 'Accessing Categories'
method: Behavior
env: environmentId categorysDo: aBlock
  "evaluates aBlock for each method category of receiver
   in specified environment. Returns the receiver.

   aBlock should be a two argument block
   expecting the args  categoryNameSymbol ,   selectorsSet.
   If the package manager is active in the current session,
   aBlock may be invoked more than once for each category name.
   The iteration is done directly over the receiver's categories."

  self env: environmentId baseCategorysDo: aBlock
%

category: 'Accessing the Method Dictionary'
method: Behavior
includesSelector: aString environmentId: envId

"Returns true if the receiver defines a method for responding to aString."
  (Symbol _existingWithAll: aString) ifNotNil:[:sym |
     ^ (self compiledMethodAt: sym environmentId: envId otherwise: nil) ~~ nil
  ].
  ^ false
%

category: 'Pragmas'
method: Behavior
pragmasForMethod: selector
        "Need to install SessionMethod support to access Pragmas"

        ^#()
%

category: 'Modifying Classes'
method: Behavior
recompileAllMethodsInContext: aSymbolList

"behavio_2.gs installs real implementation"

^ self
%

category: 'Modifying Classes'
method: Behavior
recompileAllSubclassMethodsInContext: aSymbolList

"behavio_2.gs installs real implementation"

^ self
%

category: 'Updating the Method Dictionary'
method: Behavior
removeAllMethods
"FINAL implementation in Filein3B ... "
  ^ self removeAllMethods: 0
%

category: 'Updating the Method Dictionary'
method: Behavior
removeAllMethods: envId

"Removes all methods from the receiver.  This should not be done without
 considerable forethought!"

"FINAL implementation in Filein4Rowan"

| baseCats baseMeths |
self _validatePrivilege ifFalse:[ ^ nil ].
baseCats := self _baseCategorys: envId .
baseCats ifNotNil: [ baseCats removeAll ].
baseMeths := self persistentMethodDictForEnv: envId .
baseMeths ifNotNil: [
  baseMeths removeAll .
].
self _clearLookupCaches: envId .
%

category: 'Updating Categories'
method: Behavior
removeCategory: categoryName environmentId: envId
  "behavio_2.gs installs real implementation"
  ^ self _removeBaseCategory: categoryName environmentId: envId
%

category: 'Updating the Method Dictionary'
method: Behavior
removeSelector: aString environmentId: envId

	"Filein3B.gs installs final implementation"
| sym |
sym := Symbol _existingWithAll: aString .
sym ifNil:[ self error:'the selector ', aString , '  does not exist' ].
self _basicRemoveSelector: sym environmentId: envId.
self env: envId baseCategorysDo: [ :categName :selectors |
  (selectors remove: sym ifAbsent:[ nil ]) ifNotNil:[
    ^ self "done"
  ].
].
%

category: 'Accessing the Method Dictionary'
method: Behavior
whichClassIncludesSelector: aString environmentId: envId

"behavio_2.gs installs real implementation"

  | currClass aSymbol |
  aSymbol := Symbol _existingWithAll: aString .
  aSymbol ifNil:[ ^ nil ].

  currClass := self.
  [ currClass == nil ] whileFalse:[
    (currClass includesSelector: aSymbol) ifTrue:[ ^ currClass ].
    currClass := currClass superClass
  ].
  ^ nil
%

category: 'Modifying Classes'
method: Behavior
_addClassVar: aSymbol value: aVal

"Adds the class variable with name aSymbol to the receiver's
 class variables dictionary.

 FINAL implementation in behavio_2.gs "
  | dict |
  self _validatePrivilege ifTrue:[
    (dict := classVars) ifNil:[
      dict := self _createClassVarsDict .
    ].
    dict at: aSymbol put: aVal .
  ]
%

category: 'Updating the Method Dictionary'
method: Behavior
_basicRemoveSelector: aSymbol environmentId: envId
  "returns  true if a method found to remove"
| md pmd removed tmeth pmeth |
self _validatePrivilege ifFalse:[ ^ false ].
md := self transientMethodDictForEnv: envId .
removed := false .
md ifNotNil:[
  tmeth := md removeKey: aSymbol otherwise: nil .
].
pmd := self persistentMethodDictForEnv: envId .
pmd ifNotNil:[
  pmeth := pmd removeKey: aSymbol otherwise: nil .
].
"refresh method lookup caches to account for removal of the selector
 and delete any breakpoints in the removed method(s) ."
tmeth ifNotNil:[
  removed := true .
  self _refreshLookupCache: aSymbol oldMethod: tmeth env: envId .
].
pmeth ifNotNil:[
  removed := true .
  self _codeChangedForEnv: envId .
  self _refreshLookupCache: aSymbol oldMethod: pmeth env: envId .
].
^ removed
%

category: 'Updating the Method Dictionary'
method: Behavior
_rwCompileMethodForConditionalPackaging: sourceString symbolList: symList category: categ environmentId: environmentId ifUnpackagedDo: unpackagedBlock
	"Stub method for use when Rowan is NOT installed. Rowan overrides this method to include additional functionality required by Rowan"

	^ unpackagedBlock value
%

category: 'Updating Categories'
method: Behavior
_rwMoveMethod: aSelector toCategory: categoryName
	^ self _moveMethod: aSelector toCategory: categoryName
%

category: 'Updating the Method Dictionary'
method: Behavior
_rwRemoveAllMethods: baseMeths environmentId: envId
	"Stub method for use when Rowan is NOT installed. Rowan overrides this method to include additional functionality required by Rowan"

	envId == 0
		ifFalse: [ 
			"only set time stamps for methods in envId 0"
			^ self ].
	baseMeths
		keysAndValuesDo: [ :sel :meth | 
			self setStamp: nil forMethod: sel ].
%

category: 'Updating the Method Dictionary'
method: Behavior
_rwRemoveSelector: aString environmentId: envId ifUnpackagedDo: unpackagedBlock
	"Stub method for use when Rowan is NOT installed. Rowan overrides this method to include additional functionality required by Rowan"

	^ unpackagedBlock value
%

category: 'Accessing the Method Dictionary'
method: Behavior
_topazMethodLookup: aString env: envId usePackages: ignoreBool
  "Returns an Array   { actualSelector , class } "
  | sel |
  sel := aString .
  ^ { sel .
      self whichClassIncludesSelector: sel environmentId: envId
    }
%

category: 'Accessing Categories'
method: Behavior
_unifiedCategorys: envId
  | cats |
  cats := self _baseCategorys: envId .
  cats ifNil:[ cats := GsMethodDictionary new ] ifNotNil:[ cats copy ].
  ^ cats
%

! Class extensions for 'Character'

!		Class methods for 'Character'

category: 'Non-Printable Characters'
classmethod: Character
backspace

"Returns the ASCII back-space Character."
"recompiled in charact2.gs"

^ self codePoint: 8
%

category: 'Non-Printable Characters'
classmethod: Character
cr

"Returns the ASCII carriage-return Character."
"recompiled in charact2.gs"

^ self codePoint: 13

%

category: 'Non-Printable Characters'
classmethod: Character
esc

"Returns the ASCII escape Character."
"recompiled in charact2.gs"

^  self codePoint: 27
%

category: 'Non-Printable Characters'
classmethod: Character
lf

"Returns the ASCII line-feed Character."
"recompiled in charact2.gs"

^ self codePoint: 10

%

category: 'Non-Printable Characters'
classmethod: Character
newPage

"Returns the ASCII new-page Character."
"recompiled in charact2.gs"

^ self codePoint: 12
%

category: 'Non-Printable Characters'
classmethod: Character
tab

"Returns the ASCII tab Character."
"recompiled in charact2.gs"

^ self codePoint: 9
%

! Class extensions for 'CharacterCollection'

!		Instance methods for 'CharacterCollection'

category: 'Updating'
method: CharacterCollection
tab

"Appends a tab to the receiver and returns the receiver."
"Recompiled in charcoll2.gs"

self add:  Character tab
%

! Class extensions for 'Class'

!		Instance methods for 'Class'

category: 'Subclass Creation'
method: Class
subclass: aString instVarNames: anArrayOfInstvarNames classVars: anArrayOfClassVars classInstVars: anArrayOfClassInstVars poolDictionaries: anArrayOfPoolDicts inDictionary: aDictionary newVersionOf: oldClass description: aDescription options: optionsArray
	"optionsArray is an Array of Symbols containing zero or more of
   #noInheritOptions,  #subclassesDisallowed, #disallowGciStore, #modifiable ,
   #traverseByCallback #selfCanBeSpecial #logCreation
 and at most one of
   #dbTransient, #instancesNonPersistent, #instancesInvariant
 If present, #noInheritOptions must be the first element and it causes
 none of subclassesDisallowed, disallowGciStore, traverseByCallback,
         dbTransient, instancesNonPersistent, instancesInvariant
 to be inherited from the superclass, nor copied from the
 current version of the class.
 #selfCanBeSpecial is never inherited and is needed only when modifying
 superclass hierarchy above classes with special format.
 The option #logCreation, if present in the options array, causes logging
 with GsFile(C)>>gciLogSever:  of class creation / equivalence.

 Returns oldClass if it would be equivalent to the requested new class.
 (See the class comment for Class). "

	"final version defined in File4Rowan"

	^ self
		_subclass: aString
		instVarNames: anArrayOfInstvarNames
		classVars: anArrayOfClassVars
		classInstVars: anArrayOfClassInstVars
		poolDictionaries: anArrayOfPoolDicts
		inDictionary: aDictionary
		newVersionOf: oldClass
		description: aDescription
		options: optionsArray
%

category: 'Private'
method: Class
_clearCachedOrganizer
  ^ self "bootstrap implementation , remplemented in class2.gs"
%

category: 'Private'
method: Class
_logServer: aString
 "bootstrap implementation"
  GsFile gciLogServer: aString .
%

category: 'Subclass Creation'
method: Class
_makeClassVarDict: anArrayOfClassVars

"Turns Array of class variable names into a SymbolDictionary.
 Returns nil if anArrayOfClassVars is empty or nil.

 FINAL implementation in class2.gs "

| newDict |
self _validatePrivilege ifTrue:[
  anArrayOfClassVars ifNotNil:[
    anArrayOfClassVars _isArray ifFalse:[
      (anArrayOfClassVars _validateClass: Array) ifFalse:[ ^ nil ].
    ].
    anArrayOfClassVars size ~~ 0 ifTrue:[
      newDict := SymbolDictionary new.
      1 to: anArrayOfClassVars size do: [:index|
        | aVarName aSym definingClass |
        aVarName := anArrayOfClassVars at: index .
        (aVarName _isOneByteString or:[ aVarName _validateClass: CharacterCollection]) ifTrue:[
          aSym := aVarName asSymbol .
          aSym validateIsIdentifier "fix bug 9666" .
          definingClass := self _classDefiningClassVar: aSym .  "fix bug 10480"
          definingClass ifNotNil:[
            LookupError new object: definingClass; key: aSym ; reason: #classErrClassVarNameExists ;
                details: 'class variable already exists'; signal
          ] ifNil:[
            newDict at: aSym put: nil
          ]
        ].
      ].
    ].
  ].
].
^ newDict .
%

category: 'Private'
method: Class
_rwCategory: newCategory
"Sets the classCategory variable of the receiver.
 The argument should be a kind of CharacterCollection or nil."
"Stub method for use when Rowan is NOT installed.Rowan overrides this method to include additional functionality required by Rowan" 

	self _category: newCategory
%

category: 'Private'
method: Class
_rwCreateSubclass: aString instVarNames: anArrayOfInstvarNames classVars: anArrayOfClassVars classInstVars: anArrayOfClassInstVars poolDictionaries: anArrayOfPoolDicts inDictionary: aDictionary newVersionOf: oldClass description: aDescription options: optionsArray ifUnpackagedDo: unpackagedBlock
	"Stub method for use when Rowan is NOT installed. Rowan overrides this method to include additional functionality required by Rowan"

^ unpackagedBlock value
%

category: 'Private'
method: Class
_sortedClassVarNames

"Return an unsorted list because the image is still being bootstrapped."
  classVars ifNil:[ ^ { } ].
  ^ classVars keys
%

category: 'Subclass Creation'
method: Class
_subclass: aString
instVarNames: anArrayOfInstvarNames
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
newVersionOf: oldClass
description: aDescription
options: optionsArray

 "optionsArray is an Array of Symbols containing zero or more of
   #noInheritOptions,  #subclassesDisallowed, #disallowGciStore, #modifiable ,
   #traverseByCallback #selfCanBeSpecial #logCreation
 and at most one of
   #dbTransient, #instancesNonPersistent, #instancesInvariant
 If present, #noInheritOptions must be the first element and it causes
 none of subclassesDisallowed, disallowGciStore, traverseByCallback,
         dbTransient, instancesNonPersistent, instancesInvariant
 to be inherited from the superclass, nor copied from the
 current version of the class.
 #selfCanBeSpecial is never inherited and is needed only when modifying
 superclass hierarchy above classes with special format.
 The option #logCreation, if present in the options array, causes logging
 with GsFile(C)>>gciLogSever:  of class creation / equivalence.

 Returns oldClass if it would be equivalent to the requested new class.
 (See the class comment for Class). "

	| hist descr |
	descr := aDescription.
	oldClass
		ifNotNil:
			[ (self
				_equivalentSubclass: oldClass
				superCls: self
				name: aString
				newOpts: optionsArray
				newFormat: oldClass format
				newInstVars: anArrayOfInstvarNames
				newClassInstVars: anArrayOfClassInstVars
				newPools: anArrayOfPoolDicts
				newClassVars: anArrayOfClassVars
				inDict: aDictionary
				isKernel: false)
					ifTrue:
						[oldClass _commentOrDescription: aDescription.
						^oldClass	"avoid creation of a new version"].
			hist := oldClass classHistory.
			descr
				ifNil:
					[descr := [oldClass commentForFileout] on: Error
								do: [:ex | 'old comment not available']]].
	^self
		_subclass: aString
		instVarNames: anArrayOfInstvarNames
		format: format
		classVars: anArrayOfClassVars
		classInstVars: anArrayOfClassInstVars
		poolDictionaries: anArrayOfPoolDicts
		inDictionary: aDictionary
		inClassHistory: hist
		description: descr
		options: optionsArray
%

category: 'Private'
method: Class
_subclass: className
instVarNames: anArrayOfInstvarNames
format: theFormat
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
inClassHistory: aClassHistory
description: aDescription
options: optionsArray

	"The preferred private subclass creation method.
 optionsArray is an Array of Symbols containing zero or more of
   #noInheritOptions,  #subclassesDisallowed, #disallowGciStore, #modifiable ,
   #traverseByCallback #selfCanBeSpecial #logCreation
 and at most one of
   #dbTransient, #instancesNonPersistent, #instancesInvariant .
 If present, #noInheritOptions must be the first element and it causes
 none of subclassesDisallowed, disallowGciStore, traverseByCallback,
         dbTransient, instancesNonPersistent, instancesInvariant
 to be inherited from the superclass, nor copied from the
 current version of the class.
 #selfCanBeSpecial is never inherited and is needed only when modifying
 superclass hierarchy above classes with special format.
 The option #logCreation, if present in the options array, causes logging
 with GsFile(C)>>gciLogSever:  of class creation / equivalence.
"

"Final version of this method installed in Filein3Init package"

	| cvDict result theName ivNames theHist poolDicts modifiableBool fmtArr fmt nCivs sza szb
    civNames tNow |
	self _validatePrivilege ifFalse: [^nil].
	className _isOneByteString
		ifFalse: [(className _validateClass: CharacterCollection) ifFalse: [^nil]].
	self subclassesDisallowed
		ifTrue: [^self _error: #classErrSubclassDisallowed].
	anArrayOfClassInstVars
		ifNotNil:
			[anArrayOfClassInstVars _isArray
				ifFalse: [(anArrayOfClassInstVars _validateClass: Array) ifFalse: [^nil]]].
	aDictionary
		ifNotNil: [(aDictionary _validateClass: SymbolDictionary) ifFalse: [^nil]].
	fmtArr := self _validateOptions: optionsArray withFormat: theFormat newClassName: className .
	fmt := fmtArr at: 1.
	modifiableBool := fmtArr at: 2.
	(self instancesInvariant and: [(fmt bitAnd: 16r8) == 0])
		ifTrue: [^self _error: #classErrInvariantSuperClass].
	anArrayOfInstvarNames _isArray
		ifFalse: [(anArrayOfInstvarNames _validateClass: Array) ifFalse: [^nil]].
	ivNames := {}.
	1 to: anArrayOfInstvarNames size
		do: [:j | ivNames add: (anArrayOfInstvarNames at: j)].
	nCivs := anArrayOfClassInstVars size.
	civNames := anArrayOfClassInstVars.
	nCivs ~~ 0
		ifTrue:
			[| aSet |
			civNames := Array new: nCivs.
			aSet := IdentitySet new.
			1 to: nCivs
				do:
					[:k |
					| aName |
					aName := (anArrayOfClassInstVars at: k) asSymbol.
					self class _validateNewClassInstVar: aName.
					civNames at: k put: aName.
					aSet add: aName.
					aSet size < k
						ifTrue:
							[ImproperOperation
								signal: 'array of new class instanceVariables contains a duplicate '
										, aName printString]]].

	"Gs64 v3.0 , cvDict and poolDicts maybe nil from caller,
    and will be converted to nil if caller passed an empty Array."
	cvDict := self _makeClassVarDict: anArrayOfClassVars.

	"undo the compiler's canonicalization of empty arrays (fix bug 14103) "
	poolDicts := anArrayOfPoolDicts.
	(poolDicts _isArray and: [poolDicts size == 0]) ifTrue: [poolDicts := nil].
  self _validateNewClassName: className . "reject invalids before converting to Symbol"
	theName := className asSymbol.
	tNow := DateTime now.
	result := self
				_subclass: theName
				instVarNames: ivNames
				format: fmt
				classVars: cvDict
				poolDictionaries: poolDicts
				classInstanceVars: civNames.
	modifiableBool ifTrue: [result _subclasses: IdentitySet new].
	subclasses ifNotNil: [subclasses add: result].
	aDictionary 
		ifNotNil: [
			"Avoid permission errors for classes that have not changed --- Rowan bootstrap
				class defintions should not be changing the oop of the class --- upgrades? "
			result == (aDictionary at: theName ifAbsent: []) 
				ifFalse: [ aDictionary at: theName put: result ] ].
	"leave extraDict as nil"
	result _commentOrDescription: aDescription.
	theHist := aClassHistory.
	theHist ifNil: [theHist := ClassHistory new name: className].
	theHist notEmpty ifTrue: [result category: theHist current _classCategory].
	theHist add: result.
	result classHistory: theHist.
	result timeStamp: tNow  .
	result userId: System myUserProfile userId.
	sza := self class instSize + anArrayOfClassInstVars size.
	szb := result class instSize.
	sza == szb
		ifFalse:
			[InternalError
				signal: 'prim 233: inconsistent class instance variables, superClass+args=>'
						, sza asString , '  newClass=>'
						, szb asString].
	modifiableBool ifFalse: [result immediateInvariant].
	result copyVariables.
	self _clearCachedOrganizer.
  (fmtArr at: 3) ifTrue: [ 
    "not the final oop if a reserved oop class"
     self _logServer: 'created class ' , className, ' oop ', result asOop asString  .
  ].
	^result
%

category: 'Private'
method: Class
_validateInstancesPersistent

"check that it is legal to make instances of the receiver
 persistent."

^ true
%

! Class extensions for 'DateTime'

!		Class methods for 'DateTime'

category: 'Instance Creation'
classmethod: DateTime
now

"Creates and returns an instance of the receiver representing the current
 time."
  ^ self now: nil "TimeZone not functional yet during bootstrap"
%

! Class extensions for 'GsCurrentSession'

!		Instance methods for 'GsCurrentSession'

category: 'Initialization'
method: GsCurrentSession
initialize

  "Final version of this method installed in package Filein3B"

^ self
%

! Class extensions for 'GsNMethod'

!		Instance methods for 'GsNMethod'

category: 'Private'
method: GsNMethod
_rwRecompileFromSourceIfUnpackagedDo: unpackagedBlock
	"Stub method for use when Rowan is NOT installed. Rowan overrides this method to include additional functionality required by Rowan"

	^ unpackagedBlock value
%

category: 'Traits'
method: GsNMethod
_sourceOriginString
  "Answer a string indicating the origin of the method: traitName or packageName. 
    No special message if origin is the receiver."

	"Stub method for use when Rowan is NOT installed. Rowan overrides this method to include additional functionality required by Rowan"

	self isFromTrait
		ifTrue: [ ^ '---ORIGIN: Trait method ' , self origin name printString , '---' ].
	^ ''
%

! Class extensions for 'GsProcess'

!		Instance methods for 'GsProcess'

category: 'Private'
method: GsProcess
terminate
 "make it easer to debug with topaz during filein"
 ^ 'not installed yet in slowfilein'
%

category: 'Private'
method: GsProcess
terminate9
 "make it easer to debug with topaz during filein"
 ^ 'not installed yet in slowfilein'
%

category: 'Private'
method: GsProcess
terminateTimeoutMs: timeoutMs
 "make it easer to debug with topaz during filein"
 ^ 'not installed yet in slowfilein'
%

category: 'Private'
method: GsProcess
terminateTries: numTries eachTimeoutMs: timeoutMs
 "make it easer to debug with topaz during filein"
 ^ 'not installed yet in slowfilein'
%

category: 'Private'
method: GsProcess
unsafeTerminate
 "make it easer to debug with topaz during filein"
 ^ 'not installed yet in slowfilein'
%

! Class extensions for 'Module'

!		Instance methods for 'Module'

category: 'Accessing'
method: Module
transientMethodDictForEnv: envId put: aValue
  "aValue should be a GsMethodDictionary, or nil ,
   caller responsible for _refreshClassCache "

<protected>
| ofs |
ofs := envId*4 + 1 .
transientMethDicts size < ofs ifTrue:[ transientMethDicts size: ofs ].
transientMethDicts at: ofs put: aValue
%

! Class extensions for 'Object'

!		Instance methods for 'Object'

category: 'Error Handling'
method: Object
_error: errorSymbol
 "final implementation comes later in filein"
^ Error signal: errorSymbol asString
%

category: 'Repository Conversion'
method: Object
_unsafeSet11Oop: aPositiveInteger

  "aPositiveInteger must be the integer value of a gs64v1.1 OopType"

  <primitive: 385>
  ^ self _primitiveFailed: #_unsafeSet11Oop: args: { aPositiveInteger }
%

category: 'Repository Conversion'
method: Object
_unsafeSetOop: aPositiveInteger

  "aPositiveInteger must be the integer value of a gs64v2.x OopType"

  <primitive: 535>
  ^ self _primitiveFailed: #_unsafeSetOop: args: { aPositiveInteger }
%

