! File Filein2Upgrade.gs

run
| rowan |
((System myUserProfile resolveSymbol: #Published) ifNotNil:[:assoc | assoc value ]) 
     ifNotNil:[:published |  rowan := published associationAt: #Rowan otherwise: nil ].
(Globals includesKey: #GsHostProcess) ifTrue:[ | oldCls |
	oldCls := Globals at: #GsHostProcess .
	oldCls instSize < 8 ifTrue:[
		ObsoleteClasses at: #ObsoleteGsHostProcess put: oldCls .
		oldCls removeAllMethods .
		oldCls class removeAllMethods .
    oldCls _unsafeAt: 11 put: #ObsoleteGsHostProcess . "change name"
		Globals removeKey: #GsHostProcess .
		GsFile gciLogServer:'Moved old GsHostProcess to ObsoleteClasses'.
    rowan ifNotNil:[
        | loadedClass loadedPackage |
        (rowan class respondsTo: #versionString)
          ifTrue: [
            "Rowan metadata for ObsoleteClasses must be removed ... not needed for Rowan V1"
            loadedClass := oldCls _extraDictAt: #rowanLoadedClass.
            loadedPackage := (oldCls _extraDictAt: #rowanLoadedClass) loadedPackage.
			    	oldCls _extraDictRemoveKey: #rowanLoadedClass.
            loadedPackage removeLoadedClass: loadedClass.
            loadedPackage markNotDirty.
            GsFile gciLogServer:'removed Rowan metadata for ObsoleteGsHostProcess'
        ].        
    ].
	] ifFalse:[ | oid |
		(oid:= oldCls asOop) == 160769 ifFalse: [
			GsFile gciLogServer: '------------', oldCls definition .
			Error signal:'Unexpected GsHostProcess oop = ' , oid asString.
		].
		GsFile gciLogServer:'No change to GsHostProcess'.
	].
] ifFalse:[
  GsFile gciLogServer:'GsHostProcess does not exist yet.'
].
true
%
run
(Globals at: #CDeclaration otherwise: nil) ifNotNil:[:cls |
  "delete code in case a new version of CDeclaration is created."
  cls removeAllMethods .
  cls class removeAllMethods .
  GsFile gciLogServer:'deleted methods'.
].
true
%
run
| rowan |
((System myUserProfile resolveSymbol: #Published) ifNotNil:[:assoc | assoc value ]) 
     ifNotNil:[:published |  rowan := published associationAt: #Rowan otherwise: nil].
(Globals includesKey: #JsonPetitParser) ifFalse:[
  (Globals associationAt: #JsonParser otherwise: nil) ifNotNil:[:ass |
    (ass value superclass == PPCompositeParser) ifTrue:[
      Globals removeAssociation: ass .
      ass key: #JsonPetitParser .
      ass value changeNameTo: #JsonPetitParser .
      Globals addAssociation: ass .
      GsFile gciLogServer:'renamed JsonParser to JsonPetitParser'.
      rowan ifNotNil:[
        | loadedPackage |
        "Rowan metadata for JsonParser must be repaired ... not needed for Rowan V1"
        (ass value _extraDictAt: #rowanLoadedClass)
          ifNotNil: [ :loadedClass |
            "RowanV2 and RowanV3 share a common API at this level"
            loadedPackage := (ass value _extraDictAt: #rowanLoadedClass) loadedPackage.
            loadedPackage removeLoadedClass: loadedClass.
            loadedClass initializeForName: 'JsonPetitParser'.
            loadedPackage addLoadedClass: loadedClass.
            loadedPackage markNotDirty.
            GsFile gciLogServer:'patched Rowan metadata for JsonPetitParser'.
        ] ifNil: [
          GsFile gciLogServer:'Rowan V1 does NOT need a metadata patch for JsonPetitParser'.
        ].
      ].
    ].
  ].
].
true.
%
run
(Globals includesKey: #TreeSet) ifFalse:[
  Globals at: #TreeSet put: nil .
  GsFile gciLogServer:'added TreeSet'.
].
true
%
