"

	""/usr/include/netinet/in.h line 239
/* Structure describing an Internet socket address.  */
struct sockaddr_in
  {
    __SOCKADDR_COMMON (sin_);
    in_port_t sin_port;			/* Port number.  */
    struct in_addr sin_addr;		/* Internet address.  */

    /* Pad to size of `struct sockaddr'.  */
    unsigned char sin_zero[sizeof (struct sockaddr) -
			   __SOCKADDR_COMMON_SIZE -
			   sizeof (in_port_t) -
			   sizeof (struct in_addr)];
  };""

"
Class {
	#name : 'StructSockaddrIn6',
	#superclass : 'CByteArray',
	#category : 'X509-HostAgent'
}

{ #category : 'Instance Creation' }
StructSockaddrIn6 class >> byteSize [

	^28
]

{ #category : 'Instance Creation' }
StructSockaddrIn6 class >> new [

	^self gcMalloc: self byteSize
]

{ #category : 'Instance Creation' }
StructSockaddrIn6 class >> on: aCByteArray [

	^self withAll: aCByteArray.

]

{ #category : 'Conversion' }
StructSockaddrIn6 >> _stringFromBytes: aByteArray [

	| index |
	index := aByteArray indexOf: 0.
	^aByteArray
		at: 1 
		sizeBytes: 1 
		stringSize: (0 == index ifTrue: [aByteArray size] ifFalse: [index - 1]).

]

{ #category : 'Accessing' }
StructSockaddrIn6 >> address [
	"Answer a 16-byte ByteArray containing the IPv6 address in human-readable order
	example: #[0 0 0 0 0 0 0 0 255 255 0 0 127 0 0 1]"

	^self sin_addr byteArrayFrom: 0 to: 15
]

{ #category : 'Initialization' }
StructSockaddrIn6 >> initialize [

]

{ #category : 'Initialization' }
StructSockaddrIn6 >> initialize: aCByteArray [

	1 to: (self size min: aCByteArray size) do: [:i | 
		self uint8At: i put: (aCByteArray uint8At: i).
	].

]

{ #category : 'Accessing' }
StructSockaddrIn6 >> sin_addr [

	^self
		newFrom: 8
		numBytes: 16.

]

{ #category : 'Updating' }
StructSockaddrIn6 >> sin_addr: aByteArray [

	self
		copyBytesFrom: aByteArray
		from: 1
		to: 16
		into: 8

	"self
		replaceFrom: 4
		to: 3 + (4 min: aByteArray size)
		with: aByteArray
		startingAt: 1."

]

{ #category : 'Accessing' }
StructSockaddrIn6 >> sin_family [

	^self uint16At: 0.

]

{ #category : 'Updating' }
StructSockaddrIn6 >> sin_family: anObject [

	self 
		uint16At: 0
		put: anObject.

]

{ #category : 'Accessing' }
StructSockaddrIn6 >> sin_port [

	^(self uint8At: 2) * 16r100 + (self uint8At: 3)
]

{ #category : 'Updating' }
StructSockaddrIn6 >> sin_port: anObject [

	self 
		uint16At: 2
		put: anObject.

]

{ #category : 'Accessing' }
StructSockaddrIn6 >> sin_zero [

	^self _stringFromBytes: (self 
		byteArrayFrom: 8
		to: 15).

]

{ #category : 'Updating' }
StructSockaddrIn6 >> sin_zero: aByteArray [

	self
		replaceFrom: 8
		to: 7 + (8 min: aByteArray size)
		with: aByteArray
		startingAt: 1.

]
