"
No class-specific documentation for LibCrypto, hierarchy is: 
Object
  LibCrypto

"
Class {
	#name : 'LibCrypto',
	#superclass : 'Object',
	#classVars : Array [
          'FunctionASN1_STRING_get0_data',
          'FunctionOBJ_txt2obj' ,
          'FunctionX509_free' ,
          'FunctionX509_get_subject_name',
          'FunctionX509_NAME_get_index_by_OBJ' ,
          'FunctionX509_NAME_get_entry' ,
          'FunctionX509_NAME_ENTRY_get_data'
	],
	#category : 'X509-HostAgent'
}

{ #category : 'Initializing - private' }
LibCrypto class >> initialize [

	| library |
	library := nil.
	"library := CLibrary named: '/daytank1/users/mmcclure/prefix/lib/libcrypto.so.1.1'."
	self
                initializeFunction_ASN1_STRING_get0_data_inLibrary: library;
                initializeFunction_OBJ_txt2obj_inLibrary: library;
                initializeFunction_X509_NAME_ENTRY_get_data_inLibrary: library;
                initializeFunction_X509_NAME_get_entry_inLibrary: library;
                initializeFunction_X509_NAME_get_index_by_OBJ_inLibrary: library;
                initializeFunction_X509_get_subject_name_inLibrary: library;
                initializeFunction_X509_free_inLibrary: library;
		yourself.
]

{ #category : 'Initializing - private' }
LibCrypto class >> initializeFunction_ASN1_STRING_get0_data_inLibrary: cLibrary [

        FunctionASN1_STRING_get0_data := CCallout
                library: cLibrary
                name: 'ASN1_STRING_get0_data'
                result: #'char*'
                args: #(#'ptr')
                varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibCrypto class >> initializeFunction_OBJ_txt2obj_inLibrary: cLibrary [

        FunctionOBJ_txt2obj := CCallout
                library: cLibrary
                name: 'OBJ_txt2obj'
                result: #'ptr'
                args: #(#'const char*' #'int32')
                varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibCrypto class >> initializeFunction_X509_free_inLibrary: cLibrary [

        FunctionX509_free := CCallout
                library: cLibrary
                name: 'X509_free'
                result: #'void'
                args: #(#'ptr')
                varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibCrypto class >> initializeFunction_X509_get_subject_name_inLibrary: cLibrary [

        FunctionX509_get_subject_name := CCallout
                library: cLibrary
                name: 'X509_get_subject_name'
                result: #'ptr'
                args: #(#'ptr')
                varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibCrypto class >> initializeFunction_X509_NAME_ENTRY_get_data_inLibrary: cLibrary [

        FunctionX509_NAME_ENTRY_get_data := CCallout
                library: cLibrary
                name: 'X509_NAME_ENTRY_get_data'
                result: #'ptr'
                args: #(#'ptr')
                varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibCrypto class >> initializeFunction_X509_NAME_get_entry_inLibrary: cLibrary [

        FunctionX509_NAME_get_entry := CCallout
                library: cLibrary
                name: 'X509_NAME_get_entry'
                result: #'ptr'
                args: #(#'ptr' #'int32')
                varArgsAfter: -1.
]

{ #category : 'Initializing - private' }
LibCrypto class >> initializeFunction_X509_NAME_get_index_by_OBJ_inLibrary: cLibrary [

        FunctionX509_NAME_get_index_by_OBJ := CCallout
                library: cLibrary
                name: 'X509_NAME_get_index_by_OBJ'
                result: #'int32'
                args: #(#'ptr' #'ptr' #'int32')
                varArgsAfter: -1.

]

{ #category : 'Functions' }
LibCrypto >> ASN1_STRING_get0_data_: x [
        "/daytank1/users/mmcclure/prefix/include/openssl/asn1.h line 554
const unsigned char *ASN1_STRING_get0_data(const ASN1_STRING *x);"
        "Interpreted as #char* from #( #'ptr' )"

        ^FunctionASN1_STRING_get0_data callWith: {x}
]

{ #category : 'Functions' }
LibCrypto >> OBJ_txt2obj_: s _: no_name [
        "/daytank1/users/mmcclure/prefix/include/openssl/objects.h line 963
ASN1_OBJECT *OBJ_txt2obj(const char *s, int no_name);"

        "Interpreted as #ptr from #( #'const char*' #'int32' )"

        ^FunctionOBJ_txt2obj callWith: { s. no_name }

]

{ #category : 'Functions' }
LibCrypto >> X509_free_: x [

	^FunctionX509_free callWith: {x}

]

{ #category : 'Functions' }
LibCrypto >> X509_get_subject_name_: a [
        "/daytank1/users/mmcclure/prefix/include/openssl/x509.h line 623
X509_NAME *X509_get_subject_name(const X509 *a);"

        "Interpreted as #ptr from #( #'ptr' )"

        ^FunctionX509_get_subject_name callWith: { a }

]

{ #category : 'Functions' }
LibCrypto >> X509_NAME_ENTRY_get_data_: ne [
        "/daytank1/users/mmcclure/prefix/include/openssl/x509.h line 822
ASN1_STRING * X509_NAME_ENTRY_get_data(const X509_NAME_ENTRY *ne);"

        "Interpreted as #ptr from #( #'ptr' )"

        ^FunctionX509_NAME_ENTRY_get_data callWith: { ne }

]

{ #category : 'Functions' }
LibCrypto >> X509_NAME_get_entry_: name _: loc [
        "/daytank1/users/mmcclure/prefix/include/openssl/x509.h line 793
X509_NAME_ENTRY *X509_NAME_get_entry(const X509_NAME *name, int loc);"

        "Interpreted as #ptr from #( #'ptr' #'int32' )"

        ^FunctionX509_NAME_get_entry callWith: { name. loc }

]

{ #category : 'Functions' }
LibCrypto >> X509_NAME_get_index_by_OBJ_: name _: obj _: lastpos [
        "/daytank1/users/mmcclure/prefix/include/openssl/x509.h line 791
int X509_NAME_get_index_by_OBJ(X509_NAME *name, const ASN1_OBJECT *obj,
                               int lastpos);"

        "Interpreted as #int32 from #( #'ptr' #'ptr' #'int32' )"

        ^FunctionX509_NAME_get_index_by_OBJ callWith: { name. obj. lastpos }

]
