"
A GemLogger provides various facilities, for writing to the gem log (standard out of the gem process).
"
Class {
	#name : 'GemLogger',
	#superclass : 'Object',
	#instVars : [
		'levelsToLog',
		'logLevel'
	],
	#category : 'X509-HostAgent'
}

{ #category : 'instance creation' }
GemLogger class >> logLevel: levelSymbol [

	^self new initializeForlogLevel: levelSymbol
]

{ #category : 'initialization' }
GemLogger >> initializeForlogLevel: levelSymbol [
	"Legal levels are #error, #routine, #debug."

	levelsToLog := KeyValueDictionary new.
	levelsToLog at: #error put: '***ERROR*** '.
	levelSymbol == #error ifTrue: [logLevel := levelSymbol. ^self].
	levelsToLog at: #routine put: ''.
	levelSymbol == #routine ifTrue: [logLevel := levelSymbol. ^self].
	levelsToLog at: #debug put: '...'.
	levelSymbol == #debug ifTrue: [logLevel := levelSymbol. ^self].
	self error: 'Unrecognized logging level: ' , levelSymbol
]

{ #category : 'public' }
GemLogger >> log: message level: level [
	"Only log messages if they're at a level that we are currently logging."

	| header |
	header := levelsToLog at: level ifAbsent: [nil].
	header ifNotNil: [self logHeader: header message: message]
]

{ #category : 'private' }
GemLogger >> logHeader: headerString message: messageString [

	| stream |
	stream := AppendStream on: String new.
	self printTimestampOn: stream.
	stream
		space;
		nextPutAll: headerString;
		nextPutAll: messageString.
	GsFile gciLogServer: stream contents
]

{ #category : 'public' }
GemLogger >> logLevel [
  ^ logLevel
]

{ #category : 'private' }
GemLogger >> printTimestampOn: aStream [
	"Print to nearest millisecond."

	DateAndTime now printLocalMsOn: aStream .
]
