"
Object
   IPv4Subnet ( name cidr ) 

Associates a name with a subnet.

 The value of name is a String .
 The value of cidr is a Cidr
"
Class {
	#name : 'IPv4Subnet',
	#superclass : 'Object',
	#instVars : [
		'name',
		'cidr'
	],
	#category : 'X509-Core'
}

{ #category : 'instance creation' }
IPv4Subnet class >> named: nameString forSubnet: cidrString [
  | cidr |
  cidr := CidrParser parse: cidrString .
  (cidr isKindOf: PPFailure) ifTrue:[
    Error new arg: cidr; signal:'CidrParser error: ',
       cidr message asString, ' at ', cidr position asString  .
  ].
  ^ self new named: nameString cidr: cidr .
]

{ #category : 'comparing' }
IPv4Subnet >> <= aIPv4Subnet [
  ^ cidr <= aIPv4Subnet cidr
]

{ #category : 'comparing' }
IPv4Subnet >> = aIPv4Subnet [
  ^ cidr = aIPv4Subnet cidr
]

{ #category : 'printing' }
IPv4Subnet >> asString [
  ^ self printString
]

{ #category : 'accessing' }
IPv4Subnet >> cidr [
  ^ cidr
]

{ #category : 'queries' }
IPv4Subnet >> containsCidr: aCidr [
  ^ cidr containsCidr: aCidr 
]

{ #category : 'queries' }
IPv4Subnet >> containsIP: ipAddrString [
  ^ cidr containsCidr: (Cidr fromIP: ipAddrString) 
]

{ #category : 'queries' }
IPv4Subnet >> containsSubnet: anIPv4Subnet [
  ^ cidr containsCidr: anIPv4Subnet cidr 
]

{ #category : 'copying' }
IPv4Subnet >> copyForFilterMap [
  "Returns a deep copy in ObjectFiltersSecurityPolicy"
  | res n c policy |
  res := self shallowCopy .
  res named: (n := name copy) cidr: (c := cidr copy) .
  policy := ObjectFiltersSecurityPolicy .
  res objectSecurityPolicy: policy.
  n objectSecurityPolicy: policy. 
  c objectSecurityPolicy: policy .
  ^ res
]

{ #category : 'comparing' }
IPv4Subnet >> hash [
  ^ cidr hash 
]

{ #category : 'accessing' }
IPv4Subnet >> name [
  ^ name
]

{ #category : 'updating' }
IPv4Subnet >> named: aName cidr: aCidr [
  name := aName .
  cidr := aCidr .
]

{ #category : 'printing' }
IPv4Subnet >> printString [
  | str |
  (str := name copy) addAll:' '; addAll: cidr printString .
  ^ str  
]
