"
The grammar for IPv4 classless internet domain routing strings such as
10.0.0.0/8
or
192.168.0.0/16
"
Class {
	#name : 'CidrGrammar',
	#superclass : 'PPCompositeParser',
	#instVars : [
		'cidr',
		'ipAddress',
		'maskNumber',
		'number',
		'octetNumber'
	],
	#category : 'X509-Core'
}

{ #category : 'productions' }
CidrGrammar >> cidr [

	^ipAddress , $/ asParser , maskNumber
]

{ #category : 'productions' }
CidrGrammar >> ipAddress [

	| dot |
	dot := $. asParser.
	^octetNumber , dot , octetNumber , dot , octetNumber , dot , octetNumber
]

{ #category : 'productions' }
CidrGrammar >> maskNumber [

	^number
]

{ #category : 'productions' }
CidrGrammar >> number [

	| digit |
	digit := PPPredicateObjectParser between: $0 and: $9.
	^digit plus
]

{ #category : 'productions' }
CidrGrammar >> octetNumber [

	^number
]

{ #category : 'productions' }
CidrGrammar >> start [

	^cidr
]
