Class {
	#name : 'GsUnmanagedSymbolDictionariesReport',
	#superclass : 'GsAbstractUnmanagedReport',
	#category : 'GemStone-Rowan-Tools'
}

{ #category : 'enumerating' }
GsUnmanagedSymbolDictionariesReport >> unmanagedClassesDo: aBlock [
	| unpackagedName |
	unpackagedName := Rowan unpackagedName.
	(self at: 'symbolDictionaryDetails')
		keysAndValuesDo: [ :symbolDictionaryName :symbolDictionaryDetail | 
			(symbolDictionaryDetail at: 'classDetails')
				keysAndValuesDo: [ :className :classDetail | 
					(classDetail at: 'packageName') = unpackagedName
						ifTrue: [ aBlock cull: classDetail cull: symbolDictionaryDetail ] ] ]
]

{ #category : 'enumerating' }
GsUnmanagedSymbolDictionariesReport >> unmanagedMethodsDo: aBlock [
	| unpackagedName |
	unpackagedName := Rowan unpackagedName.
	(self at: 'symbolDictionaryDetails')
		keysAndValuesDo: [ :symbolDictionaryName :symbolDictionaryDetail | 
			(symbolDictionaryDetail at: 'classDetails')
				keysAndValuesDo: [ :className :classDetail | 
					(classDetail at: 'instanceMethodDetails')
						keysAndValuesDo: [ :methodSelector :methodDetail | 
							(methodDetail at: 'method') isFromTrait
								ifFalse: [ 
									"isFromTrait methods are EXPECTED to be unpackaged"
									(methodDetail at: 'packageName') = unpackagedName
										ifTrue: [ aBlock cull: methodDetail cull: classDetail cull: symbolDictionaryDetail ] ] ].
					(classDetail at: 'classMethodDetails')
						keysAndValuesDo: [ :methodSelector :methodDetail | 
							(methodDetail at: 'method') isFromTrait
								ifFalse: [ 
									"isFromTrait methods are EXPECTED to be unpackaged"
									(methodDetail at: 'packageName') = unpackagedName
										ifTrue: [ aBlock cull: methodDetail cull: classDetail cull: symbolDictionaryDetail ] ] ] ] ]
]
