"
GsModificationTopazWriterVisitor is used to export bootstrap
.gs files. The bootstrap .gs are used for loading classes and
methods during image creation and for updating class and 
method definitions during image upgrade.

During image upgrade it is necessary to ensure that all 
methods are removed from each class before installing the 
new methods, since some methods from earlier versions of
GemStone may no longer apply.

Rowan packages are used as the files of record for method
and class source in a GemStone image and the
GsModificationTopazWriterVisitor generates the bootstrap .gs
files from the Rowan packages. Since some classes are 
created in bom.c, while others are created by Rowan class
definitions, it isn't feasible to remove the existing methods
immediately after the class definition is filed in, so this class
manages the logic for determining when the method removal
code should be inserted in the bootstrap .gs files.
"
Class {
	#name : 'GsModificationTopazWriterVisitor',
	#superclass : 'RwGsModificationTopazWriterVisitorV2',
	#category : 'GemStone-Rowan-Tools'
}

{ #category : 'session management' }
GsModificationTopazWriterVisitor class >> _sessionTempsKey [

	^#GsModificationTopazWriterVisitor_classTrackingSet "in SessionTemps"
]

{ #category : 'session management' }
GsModificationTopazWriterVisitor class >> classTrackingSet [
	^ SessionTemps current at: self _sessionTempsKey ifAbsent: [  ]
]

{ #category : 'session management' }
GsModificationTopazWriterVisitor class >> isTrackingClassNames [
	^ SessionTemps current includesKey: self _sessionTempsKey
]

{ #category : 'session management' }
GsModificationTopazWriterVisitor class >> startTrackingClassNames [
	SessionTemps current at: self _sessionTempsKey put: Set new
]

{ #category : 'session management' }
GsModificationTopazWriterVisitor class >> stopTrackingClassNames [
	SessionTemps current removeKey: self _sessionTempsKey ifAbsent: [  ]
]

{ #category : 'private exporting' }
GsModificationTopazWriterVisitor >> _fileOutMethod: methodDefinition forClass: className isMeta: isMeta on: aStream [
	"conditionaly remove all methods for class BEFORE first method definition"

	self _fileoutRemoveAllMethodsFor: className on: aStream.
	super
		_fileOutMethod: methodDefinition
		forClass: className
		isMeta: isMeta
		on: aStream
]

{ #category : 'private exporting' }
GsModificationTopazWriterVisitor >> _fileoutRemoveAllMethodsFor: className on: aStream [
	"export remove all methods commands if removeall methods
		are enabled and this is first time the class has been seen"

	self classTrackingSet
		ifNotNil: [ :classTrackingSet | 
			(classTrackingSet includes: className)
				ifFalse: [ 
					super _fileoutRemoveAllMethodsFor: className on: aStream.
					classTrackingSet add: className ] ]
]

{ #category : 'private exporting' }
GsModificationTopazWriterVisitor >> classTrackingSet [
	^ self class classTrackingSet
]
