"
An instance of Utf16 is a UTF-16 encoded string.
For every codePoint cp in a Utf16 the following
evaluates to true:
      cp >= 0 and:[ cp <= 16r10FFFF]
Codepoints in a Utf16 use a variable number of bytes
per codePoint, and thus only certain comparison
methods, directly supported by the libicu libraries,
are implemented.  All other string manipulation must
be done on the result of sending asUnicodeString to the
instance of Utf16, and then operating on the
equivalent Unicode7, Unicode16 or Unicode32 string.

Methods inherited from ByteArray operate on the raw bytes
of the UTF-16 encoded string, and have no support for accessing codePoints. 
"
Class {
	#name : 'Utf16',
	#superclass : 'ByteArray',
	#gs_options : [
		'2byteWords'
	],
	#gs_reservedoop : '158465',
	#category : 'Collections-Strings'
}
