"
UserProfileSet is a concrete subclass of AbstractUserProfileSet that implements
 and enforces some account and password security features for all of its
 elements.

 Only one instance of UserProfileSet, called AllUsers, is allowed to exist,
 and is provided with a fresh GemStone server.  All UserProfiles in GemStone
 belong to this set.  AllUsers supports security features for all users.
 AllUsers also ensures uniqueness of userId Strings; no two UserProfiles can
 have the same ID.

 GemStone, as shipped from the factory, disables all the security features
 supported by AllUsers.  To activate any or all of those features, an
 administrator with the proper privileges must execute methods on AllUsers.
 Activated features can also be deactivated later by reapplying the settings
 that do not constrain GemStone's behavior.

 Password format constraints are applied only after an administrator commits
 the changes in AllUsers.  They are then enforced only when users change their
 own passwords with the UserProfile>>oldPassword:newPassword: method, not when
 administrators or other users make changes with methods that require the
 OtherPassword privilege.  In addition, enforcement does not apply to existing
 passwords created before new constraints were committed.

Constraints:
	_varyingSize: Object
	_numEntries: Object
	_indexedPaths: Object
	_levels: Object
	userIdDictionary: StringKeyValueDictionary
	userSecurityData: StringKeyValueDictionary
	passwordAgeLimit: Number
	passwordAgeWarning: Number
	staleAccountAgeLimit: Number
	securityBits: SmallInteger
	disallowedPasswords: Set
	maxPasswordSize: SmallInteger
	minPasswordSize: SmallInteger
	maxRepeatingChars: SmallInteger
	maxConsecutiveChars: SmallInteger
	maxCharsOfSameType: SmallInteger
	[elements]: UserProfile

--- instVar disallowedPasswords
A Set of Strings that cannot be used as passwords.  The userId Strings of
 GemStone users also cannot be used as passwords, even if they do not appear in
 this Set.

--- instVar maxCharsOfSameType
A SmallInteger that gives maximum number of adjacent characters in a password
 that are permitted to have the same type (alphabetic, numeric, or special).
 Zero means there is no maximum.

--- instVar maxConsecutiveChars
A SmallInteger that gives maximum number of adjacent characters in a password
 that form an ascending or descending sequence of Character values, such as
 ""123"" or ""fed"".  Zero means there is no maximum.  Such sequences are determined
 by case-sensitive comparisons.

--- instVar maxPasswordSize
A SmallInteger that gives maximum size of new passwords.  Zero means there is
 no maximum.

--- instVar maxRepeatingChars
A SmallInteger that gives maximum number of adjacent characters in a password
 that can have the same value.  Zero means there is no maximum.  The value 1
 prevents passwords of the form aa, but not aba.

--- instVar minPasswordSize
A SmallInteger that gives minimum size of new passwords.

--- instVar passwordAgeLimit
The maximum Number of hours for which a user can retain a password.  When a
 password is set, it expires this Number of hours later.  The user must change
 the password before it expires, or else GemStone disables the account.  Once
 a password has expired, an administrator must reset the password from another
 account before the user can login again.

 Zero means there is no expiration time for passwords.  This setting may be
 overridden in indivdual UserProfiles.  Applies only to UserProfiles which use
 GemStone authentication.

--- instVar passwordAgeWarning
The maximum Number of hours prior to a password expiration time for which a
 user can login without a warning.  If the user logs in to GemStone within this
 Number of hours before the password is due to expire, GemStone issues a warning
 about the impending expiration.  This feature grants a user the opportunity to
 change the password conveniently and to prevent the account from being
 disabled.  This setting may be overridden in indivdual UserProfiles.
 Applies only to UserProfiles which use GemStone authentication.

--- instVar securityBits
A SmallInteger.  A number of bit fields encoded as a SmallInteger which
 control various security features.

--- instVar staleAccountAgeLimit
The maximum Number of hours for which a user account can remain enabled without
 a login.  Once the user logs in, he or she has up to this Number of hours to
 login again, or else GemStone disables the account.  Once the account has been
 disabled, an administrator must reset the password from another account before
 the user can login again.

 Zero means there is no expiration time for accounts.  This setting may be
 overridden in indivdual UserProfiles.  Applies only to UserProfiles which use
 GemStone authentication.

--- instVar userIdDictionary
A StringKeyValueDictionary whose keys are userId Strings and whose values are
 the UserProfiles of the instance.

--- instVar userSecurityData
The userSecurityData variable is used internally by GemStone.

"
Class {
	#name : 'UserProfileSet',
	#superclass : 'AbstractUserProfileSet',
	#instVars : [
		'userIdDictionary',
		'userSecurityData',
		'passwordAgeLimit',
		'passwordAgeWarning',
		'staleAccountAgeLimit',
		'securityBits',
		'disallowedPasswords',
		'maxPasswordSize',
		'minPasswordSize',
		'maxRepeatingChars',
		'maxConsecutiveChars',
		'maxCharsOfSameType'
	],
	#gs_reservedoop : '112129',
	#category : 'System-Users'
}
