"
Each instance of UserProfile contains a number of characteristics associated
 with a given system user.  For more information, see the GemStone System
 Administration Guide and the GemStone Programming Guide.

Constraints:
	encryptedPassword: String
	userId: String
	symbolList: SymbolList
	defaultObjectSecurityPolicy: GsObjectSecurityPolicy
	privileges: SmallInteger
	groups: IdentitySet
	kerberosPrincipal: KerberosPrincipal
	spare2: Object
	loginHook: Object
	compilerLanguage: SmallInteger

--- instVar defaultObjectSecurityPolicy
The GsObjectSecurityPolicy in which new objects are stored after each login.

--- instVar groups
An IdentitySet; the groups to which the user belongs.

--- instVar privileges
A SmallInteger describing the level of access to certain privileged system
 functions that are ordinarily performed by the GemStone data curator.

--- instVar kerberosPrincipal
The KerberosPrincipal object that maps to this UserProfile, or nil.

--- instVar spare2
Reserved for future use.

--- instVar loginHook
Used to store the login Block.

--- instVar symbolList
An Array of SymbolDictionaries that are used for resolving compile-time
 Symbols.

--- instVar userId
A String that identifies the user to the system at login; limited to
 1024 Characters.  Methods in this class enforce uniqueness by the value of
 all user IDs of UserProfiles in AllUsers.

--- classVar PrivilegeNames
An Array of Symbols that identify the privileges (that is, the levels of
 access to certain privileged system functions) that may be assigned to a
 UserProfile.  See UserProfile | privileges for a list of privilege names and
 their associated privileged methods.

"
Class {
	#name : 'UserProfile',
	#superclass : 'Object',
	#instVars : [
		'encryptedPassword',
		'userId',
		'symbolList',
		'defaultObjectSecurityPolicy',
		'privileges',
		'groups',
		'kerberosPrincipal',
		'spare2',
		'loginHook',
		'compilerLanguage'
	],
	#classVars : [
		'GSC_SET_USER_PROFILE_no_login_logging',
		'InversePrivileges',
		'LanguageNames',
		'OC_USER_SECUR_DATA_ACTIVE_USR_LIM',
		'OC_USER_SECUR_DATA_ALIAS_USERID',
		'OC_USER_SECUR_DATA_AUTH_SCHEME',
		'OC_USER_SECUR_DATA_BIT_FLAGS',
		'OC_USER_SECUR_DATA_LAST_LOGIN_TIM',
		'OC_USER_SECUR_DATA_LAST_PWD_CHNG',
		'OC_USER_SECUR_DATA_LDAP_BASE_DN',
		'OC_USER_SECUR_DATA_LDAP_FILTER',
		'OC_USER_SECUR_DATA_LOGINS_BEFORE_EXPIR',
		'OC_USER_SECUR_DATA_OLD_PASSWDS_ARRAY',
		'OC_USER_SECUR_DATA_ONETIME_PW_WL',
		'OC_USER_SECUR_DATA_PASSWD_AGE_LIMIT',
		'OC_USER_SECUR_DATA_PASSWD_AGE_WARNING',
		'OC_USER_SECUR_DATA_PASSWD_NEVER_EXPIRES',
		'OC_USER_SECUR_DATA_POS_WHITELIST',
		'OC_USER_SECUR_DATA_READ_ONLY',
		'OC_USER_SECUR_DATA_REASON_DISABLED',
		'OC_USER_SECUR_DATA_SALT',
		'OC_USER_SECUR_DATA_STALE_ACCOUNT_AGE_LIMIT',
		'OC_USER_SECUR_DATA_USED_SALTS',
		'OC_USER_SECUR_DATA_USED_VERIFIERS',
		'OC_USER_SECUR_DATA_VERIFIER',
		'OC_USER_SECUR_X509_STATUS',
		'PrivilegeNames',
		'OC_USER_SECUR_DATA_JWT_DATA'
	],
	#gs_options : [
		'subclassesDisallowed'
	],
	#gs_reservedoop : '76545',
	#category : 'System-Users'
}
