"
UnorderedCollection is an abstract class for collections of objects whose
 elements are not logically arranged in any particular order.  The elements are
 also not physically stored in any fixed order.  Any implied ordering at any
 given time is independent of the order in which the elements were added to the
 collection and cannot be relied upon to persist.

 The elements of unordered collections are all of the same kind.  Unless
 restricted further by a subclass, the kind of elements in unordered collections
 is Object.  That is, the class of each element must simply be some kind of
 Object.

 You cannot add nil to any kind of unordered collection.  Attempts to do so have
 no effect.

 UnorderedCollection provides for fast associative access of collection elements
 in searches by means of the use of indexes with selection blocks.
 UnorderedCollection creates each index for an individual instance, where
 specified, and maintains that index thereafter unless it is removed
 explicitly.

 Indexing is done on instance variables, not on values returned by messages.
 When an index path is used as an argument to a method, it is specified by a
 String that consists of instance variable names separated by periods (such as
 the String 'instvar1.instvar2.instvar3').  The ith name in the String
 corresponds to the ith position in the path.  A path String may include up to
 16 names and is limited to a total of 1024 Characters.

 If aPathString is an empty path (that is, a zero-length String), the method
 operates upon the elements of the receiver itself rather than upon the instance
 variables of those elements.

 For more information about index structures and path expressions, see the
 GemStone Programming Guide.

All instance variables start with an underscore and are for GemStone internal use.

"
Class {
	#name : 'UnorderedCollection',
	#superclass : 'Collection',
	#instVars : [
		'_varyingSize',
		'_numEntries',
		'_indexedPaths',
		'_levels'
	],
	#gs_reservedoop : '96257',
	#category : 'Collections-Unordered'
}
