"

UncontinuableError is signaled when an attempt is made to continue
execution after a handler from which continuing execution is not allowed.
For example, it is generally fine to return from a dynamic (stack-based)
handler:
	[2 / 0] on: ZeroDivide do: [:ex | ex return: 3].
On the other hand, it is not permitted to return from a default (static)
handler:
	ZeroDivide addDefaultHandler: [:ex | ex return: 3].
	[2 / 0] on: UncontinuableError do: [:ex | ex halt].

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object

"
Class {
	#name : 'UncontinuableError',
	#superclass : 'Error',
	#gs_reservedoop : '150529',
	#category : 'Exceptions'
}
