"
An instance of Time describes a time of day with one-millisecond resolution.
 The class Time also provides methods for examining the system clock and for
 measuring the performance of a block.

 The internal representation of a Time is based on local time.

 From Gemstone64 v3.6 onwards, newly created instances are instances of 
 the subclass SmallTime .

 You can convert a Time to a String (using Formatting instance methods), and
 you can convert a String to a Time (using Instance Creation class methods).
 Such conversions require a specification to describe the format of the String.
 Some methods provide for the default format, HH:MM:SS, which uses a 24-hour
 clock.

 Explicit string-formatting specifications take the form of an Array, described
 in the following table.  A specification is incorrect if it is missing an
 element or if an element value is not one of the acceptable values listed in
 the table.

 String-formatting Specification Array for Time.

 Element   Acceptable Value     Explanation
 
 1st       A Character literal  Separates hours, minutes, and seconds.
           (such as $: or $.)

 2nd       true                 Include seconds.

 2nd       false                Do not include seconds.

 3rd       true                 Time is expressed in 12-hour format, with
                                am or pm (such as 1:30:55 pm).  The space is
                                required preceding the am or pm indicator.

 3rd       false                Time is expressed in 24-hour format
                                (such as 13:30:55).

Instance variables
  milliseconds - The number of milliseconds since midnight, local time.

"
Class {
	#name : 'Time',
	#superclass : 'Magnitude',
	#instVars : [
		'milliseconds'
	],
	#gs_options : [
		'selfCanBeSpecial'
	],
	#gs_reservedoop : '100865',
	#category : 'TimeRelated'
}
