"
A StringKeyValueDictionary is a KeyValueDictionary in which the keys are
 Strings or MultiByteStrings.  The hash function treats the strings as
 case-sensitive and is equivalent to String >> hash .
 Key comparisons always use code point comparison.

 Key arguments which are Symbols are converted to Strings prior
 to lookup in or addition to a StringKeyValueDictionary .

 The hashing algorithm is described in

 Pearson, Peter K.,
 ""Fast Hashing of Variable-Length Text Strings,""
 Communications of the ACM, 33:6 (June 1990), 667-680.

 The implementation employs two modifications:

 * The hash function uses at most 2008 bytes of the string.  Strings that are
   identical within this range have the same hash value.

 * In his paper, Pearson describes a technique for producing a larger number of
   hash values by always computing the hash function to 24 bits.  The hash
   value is the result of this function modulo the table size.  Therefore,
   there is no value in specifying a table size greater than 2 to the 24th
   power.

Constraints:
	numElements: SmallInteger
	numCollisions: SmallInteger
	collisionLimit: SmallInteger
	tableSize: SmallInteger
"
Class {
	#name : 'StringKeyValueDictionary',
	#superclass : 'KeyValueDictionary',
	#classVars : [
		'StringKVDSentinel'
	],
	#gs_reservedoop : '79873',
	#category : 'Collections-Dictionaries'
}
