"

An exception signaled when certain GsSshSocket methods fail.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object

"
Class {
	#name : 'SshSocketError',
	#superclass : 'SocketError',
	#category : 'OSAccess-Sockets'
}

{ #category : 'Formatting' }
SshSocketError >> buildMessageText [
| result |
result := (self buildMessageText: nil) trimTrailingBlanks .
(result last == $,) ifTrue:[ result size: (result size - 1) ].
messageText := result.
^ result
]

{ #category : 'Instance initialization' }
SshSocketError >> initialize [
  gsNumber := ERR_SshSocketError.
  gsResumable := true .
  gsTrappable := true .

]
