"
A SoftReference contains a reference to another object which may be
 cleared by the in-memory garbage collector.   Instances of SoftReference
 are non-persistent and may not be committed ot the repository .

 A SoftReference's value instVar is only cleared if
 there are no strong references to the referenced value , and if
 the inUse instVar is not true .

 If a SoftReference to A is cleared, all other SoftReferences
 to objects B such that B->A is a strong reference, are also cleared .
 All SoftReferences that are legal to clear are cleared before
 generating AlmostOutOfMemory error .

 VM scavenge will never clear SoftReferences , and the normal stubbing of
 references from temporary to committed objects is not performed
 in SoftReferences .

 If percentMemUsed > GEM_SOFTREF_CLEANUP_PERCENT_MEM at start of markSweep,
 markSweep will will attempt to clear SoftReferences as follows:

 if percentMemUsed < 60%,
 markSweep will try to clear the least recently used 10% of SoftReferences.

 if percentMemUsed >= 60% and < 90% ,
 markSweep will try to clear the least recently used 20% of SoftReferences.

 if percentMemUsed >= 90%
 markSweep will try to clear all SoftReferences.

Constraints:
	inUse: Boolean
	useCount: SmallInteger
	value: Object

--- instVar inUse
A Boolean , if true prevents the garbage collector from clearing value.

--- instVar useCount
Private to the garbage collector and primitives, used to implement least
 recently used behavior for clearing of value.

--- instVar value
Reference to another object, may be cleared by the garbage collector.

"
Class {
	#name : 'SoftReference',
	#superclass : 'Object',
	#instVars : [
		'inUse',
		'useCount',
		'value'
	],
	#gs_options : [
		'disallowGciStore',
		'instancesNonPersistent',
		'subclassesDisallowed'
	],
	#gs_reservedoop : '120065',
	#category : 'Collections-Internals'
}
