"
Instances of SmallInteger are an optimization for commonly occurring integers
 (between -(2 to the 60 power) and ((2 to the 60 power) - 1) ).  You may not
 create subclasses of class SmallInteger.  You may not create any new
 SmallIntegers.  Note that all instances of a given SmallInteger refer to a
 single, unique GemStone object.  That is, they are all both equal (=) and
 identical (==).

 The following selectors are are special. 
 These are compiled to bytecodes that do not do a message send if receiver and 
 argument are both SmallIntegers, and the result is a SmallInteger:
   +  -  * bitAnd: bitXor: 

 These are compiled to bytecodes that not do a message send if receiver and
 argument are both SmallIntegers:
   <  >= <= 

"
Class {
	#name : 'SmallInteger',
	#superclass : 'Integer',
	#type : 'immediate',
	#gs_options : [
		'instancesInvariant',
		'selfCanBeSpecial'
	],
	#gs_reservedoop : '74241',
	#category : 'Numbers'
}
