"
 This class represents 8-byte binary floating point numbers, as defined in IEEE
 standard 754, but with a reduced exponent.
 SmallDouble has 8 bits of exponent, compared to 11 bits of exponent in
 an IEEE-754 8-byte float.

 You may not create subclasses of SmallDouble.

 Literal numbers in evaluated code that include a decimal point by default create 
 a SmallDouble or Float. If the value is in the SmallDouble range, a SmallDouble 
 will be created, otherwise a Float will be created. Literal floats may be 
 specified using exponential notation.  e and E, and also the ANSI exponents d, D, 
 and q, are all legal exponent notation and produce the same results, either a 
 SmallDouble or Float depending on the range.

 Each SmallDouble contains a 61 bit value.  The floats are stored on Disk and
 in object memory in big-endian IEEE format.  GemStone Smalltalk primitives and
 GemBuilder for C (GCI) float conversion functions automatically convert
 the format of a float to or from the machine's native format, as required.

 In big-endian layout,
  An IEEE 64 bit binary float (a C double) has this bit layout
   seeeeeee|eeeeffff|ffffffff|ffffffff|ffffffff|ffffffff|ffffffff|ffffffff
   If (e > 0) the double has value (-1 * s) * 2^^(e-0x3ff) * 1.f  .
   If (e == 0) and f != 0 ,
     the double has value (-1 * s) * 2^^(e-0x3fe) * 0.f  (i.e. subnormal) .
   zero is represented as s==0, e==0, f==0  . See Sparc V9 Arch Manual pg 28.

  An instance of SmallDouble has this OopType layout:
   eeeeeeee|ffffffff|ffffffff|ffffffff|ffffffff|ffffffff|ffffffff|ffffs110
  which is the same number of bits of mantissa as a C double, but
  only 8 bits of exponent as compared to 11 bits of exponent in C double.
  The bottom 3 bits are the tag bits of the OopType .

  If the C double has value zero , the SmallDouble has all e and f bits zero,
  otherwise the SmallDouble has non-zero exponent, and
  the value is (-1 * s) * 2^^(e - 0x7f ) * 1.f

  There are no subnormal, infinity, nor NaN SmallDoubles .
  Thus SmallDoubles can represent  C doubles that have value zero
  or that have exponent bits in range 0x381 to 0x3ff,
  which correspends to about 5.0e-39 to 6.0e+38 , which
  is also the exponent range of  C 4-byte float  .
 
"
Class {
	#name : 'SmallDouble',
	#superclass : 'Float',
	#type : 'immediate',
	#gs_options : [
		'instancesInvariant',
		'selfCanBeSpecial'
	],
	#gs_reservedoop : '121345',
	#category : 'Numbers'
}
