"
SequenceableCollection is an abstract superclass for collections that define a
 consistent ordering on their elements.  You can think of the elements as
 forming a sequence of objects, numbered from 1 to n.  You can use the Integer i
 as an index to refer to the ith element in that sequence.  The elements are
 said to be indexable.

 The indexability of SequenceableCollections should not be confused with indexes
 that are specially built on UnorderedCollections to improve their performance
 when they search their elements (using associative access).

--- Category:  Adding
Methods in the Adding category modify their receivers.  They generally execute
 faster than methods in the Concatenating category, which do not modify their
 receivers.  Please see that category for more comparative information.

--- Category:  Concatenating
Methods in the Concatenating category do not modify their receivers.  They copy
 their receivers and then apply the concatenation to the copy.  Thus, they
 generally execute slower than methods in the Adding category, which do modify
 their receivers.

 Consider the following code example involving Strings:

    | n result |
    n := 1000.
    result := String new.
    n timesRepeat: [result := result , $x.].
    ^ result

 Each time through the loop, this code first generates a new instance of String,
 a copy of the previous result, to which it then adds one Character.  In n times
 through the loop then, n * (n - 1) / 2 Characters are copied, and n Characters
 are added.  Thus, the time complexity to execute such a loop is proportional to
 n * (n + 1) / 2.  Space and garbage collection overhead can be expensive, too.

 The following code example executes in time that is proportional to n, without
 any of the space and garbage collection overhead of the previous example:

    | n result |
    n := 1000.
    result := String new.
    n timesRepeat: [ result add: $x].
    ^ result

 The result is the same in both examples.

"
Class {
	#name : 'SequenceableCollection',
	#superclass : 'Collection',
	#gs_reservedoop : '73729',
	#category : 'Collections-Ordered'
}
