"
Instances of LargeInteger represent Integers not representable as a SmallInteger.
 Each instance of LargeInteger is stored as an array of bytes, where every
 4 bytes represents a base 4294967296 digit.  The first 4 bytes are the sign
 digit (0 or 1) , the next 4 bytes in that
 array constitute the least significant base 4294967296 digit, and the last 4
 bytes are the most significant base 4294967296 digit.
 Instance have a maximum size of 4067 digits plus the sign .

 For a LargeInteger loaded into memory, the bytes in each digit are in
 machine native byte order for a C unsigned int.

 Coercion between LargeInteger and SmallInteger occurs automatically.
"
Class {
	#name : 'LargeInteger',
	#superclass : 'Integer',
	#type : 'byteSubclass',
	#classVars : [
		'MaximumDecimalFloat',
		'MaximumDigits',
		'MaximumFloat',
		'MaximumValue'
	],
	#gs_options : [
		'4byteWords'
	],
	#gs_reservedoop : '136193',
	#category : 'Numbers'
}
