"
An IdentityKeyValueDictionary is a KeyValueDictionary that is an identity-based
 collection instead of equality-based.  That is, two keys or two values are
 considered to be the same only if they are identical; equivalent objects are
 not the same.  Thus, if you add two key-value pairs to an
 IdentityKeyValueDictionary and the keys are equivalent but not identical, then
 the result is that you have two pairs in the dictionary because the keys are
 not the same.

 An IdentityKeyValueDictionary sends #identityHash to keys to obtain the
 hash value, and sends #==  to compare two keys.
 It does not use  #hashFunction: and #compareKey:with:  methods.

 IdentityKeyValueDictionary exhibits better performance than KeyValueDictionary
 and is to be preferred where it is appropriate.

 For multiuser applications that involve a lot of concurrent use of
 dictionaries, use RcKeyValueDictionary.

Constraints:
	numElements: SmallInteger
	numCollisions: SmallInteger
	collisionLimit: SmallInteger
	tableSize: SmallInteger
"
Class {
	#name : 'IdentityKeyValueDictionary',
	#superclass : 'KeyValueDictionary',
	#gs_reservedoop : '90881',
	#category : 'Collections-Dictionaries'
}
