"
IdentityDictionary is a Dictionary that is identity-based rather than
 equality-based.

 IdentityDictionary implements key-value pairs by storing key-Association
 pairs.  Each Association contains a key-value pair, and the key is
 duplicated in the dictionary or collision bucket for implementation reasons.

 As with other identity-based collections, in an IdentityDictionary two keys or
 two values are considered to be the same only if they are identical; equivalent
 objects are not the same.  Thus, if you add two key-value pairs to an
 IdentityDictionary and the keys are equivalent but not identical, then the
 result is that you have two pairs in the dictionary because the keys are not
 the same.

 IdentityDictionary exhibits better performance than Dictionary and is to be
 preferred where it is appropriate.

Constraints:
	numElements: SmallInteger
	numCollisions: SmallInteger
	collisionLimit: SmallInteger
	tableSize: SmallInteger
"
Class {
	#name : 'IdentityDictionary',
	#superclass : 'IdentityKeyValueDictionary',
	#gs_reservedoop : '101633',
	#category : 'Collections-Dictionaries'
}
