"
  An IcuLocale encapsulates an instance of C++ Locale from
  the libicu libraries, documented at icu-project.org .
  C data is a Locale from locid.h, not freed on GC,
  auto-initialized when the instance is faulted into memory.

  Classes Unicode7, Unicode16 and Unicode32 are added to support
  Locale sensitive comparison of Strings, and fix bug 41964 .
  Comparison and conversion between instances of the different
  classes is provided by the libicu libraries, from icu-project.org .
  These libraries are shipped in $GEMSTONE/lib
  and automatically loaded during gem or  topaz -l  process initialization.
  Any libicu libraries installed as part of the operating system
  are ignored.

  Also added is class Utf8 representing Utf8 encoded
  strings, and IcuCollator representing a C++ Collator from libicu.

  These new classes appear in the hierarchy as follows.
  Object
    IcuLocale
    IcuCollator
    Collection
      SequenceableCollection
        ByteArray
          Utf8
        CharacterCollection
          String
            Unicode7
          MultiByteString
            DoubleByteString
              Unicode16
            QuadByteString
              Unicode32

  Class Utf8 supports comparison methods and conversion to
   one of Unicode7, Unicode16, Unicode32  .

  The classes Unicode7, Unicode16, Unicode32 support
  the full CharacterCollection API.

  If the source string of a method compilation is a Unicode32, Unicode16,
  or Unicode7, literal strings within the compiled method will be
  instances of Unicode32, Unicode16, or Unicode7 using the minimum
  bytes per codePoint required to represent each literal.

Constraints:
	name: String

"
Class {
	#name : 'IcuLocale',
	#superclass : 'Object',
	#instVars : [
		'name'
	],
	#gs_reservedoop : '153601',
	#category : 'System-Localization'
}
