"
GsTsX509ExternalSession is a variant of GsTsExternalSession which uses an 
X509 certificate as login credentials rather than a user id and password.

Example:

| p s |
p := GemStoneX509Parameters
      newFromPemFilesWithNetldiPort: '54321'
      netldiHost: 'localhost'
      certificate: 'DataCurator.chain.pem'
      caCertificate: 'stoneCA-gs64stone.cert.pem'
      privateKey: 'DataCurator.privkey.pem' .
s := GsTsX509ExternalSession newWithX509Parameters: p.
s login .


"
Class {
	#name : 'GsTsX509ExternalSession',
	#superclass : 'GsTsExternalSession',
	#instVars : [
		'username'
	],
	#category : 'ExternalSessions'
}

{ #category : 'Instance Creation' }
GsTsX509ExternalSession class >> gemNRS: gemNRS stoneNRS: stoneNRS username: aUsername password: aPassword [

"Disallowed"

self shouldNotImplement: #gemNRS:stoneNRS:username:password:

]

{ #category : 'Instance Creation' }
GsTsX509ExternalSession class >> gemNRS: gemNRS stoneNRS: stoneNRS username: gsUsername password: gsPassword hostUsername: hostUsername hostPassword: hostPassword [

"Disallowed"

self shouldNotImplement: #gemNRS:stoneNRS:username:password:hostUsername:hostPassword:

]

{ #category : 'Instance Creation' }
GsTsX509ExternalSession class >> newDefault [

self shouldNotImplement: #newDefault

]

{ #category : 'Instance Creation' }
GsTsX509ExternalSession class >> newWithX509Parameters: aGemStoneX509Parameters [
  ^ self _basicNew _parameters: aGemStoneX509Parameters library: GciTsLibrary newDefault
]

{ #category : 'Instance Creation' }
GsTsX509ExternalSession class >> newWithX509Parameters: aGemStoneX509Parameters library: aGciTsLibrary [
  ^ self _basicNew _parameters: aGemStoneX509Parameters library: aGciTsLibrary 
]

{ #category : 'Private' }
GsTsX509ExternalSession >> _gemHost [

^ parameters netldiHost

]

{ #category : 'Private' }
GsTsX509ExternalSession >> _parameters: aGemStoneX509Parameters library: aGciTsLibrary [
  parameters := aGemStoneX509Parameters .
  callouts := aGciTsLibrary callouts .
  lib := aGciTsLibrary .  
  nbCallInProgress := 0
]

{ #category : 'Parameters' }
GsTsX509ExternalSession >> gemNRS: anNRS [

  self shouldNotImplement: #gemNRS:

]

{ #category : 'Parameters' }
GsTsX509ExternalSession >> hostPassword: aString [

  self shouldNotImplement: #hostPassword:

]

{ #category : 'Parameters' }
GsTsX509ExternalSession >> hostUsername: aString [

  self shouldNotImplement: #hostUsername:

]

{ #category : 'Parameters' }
GsTsX509ExternalSession >> initializeDefaultResources [

  self shouldNotImplement: #initializeDefaultResources
]

{ #category : 'Public' }
GsTsX509ExternalSession >> login [
	| c args ptr |
	self isLoggedIn ifTrue: [
		ImproperOperation signal: 'Already logged in'.
	].
  c := self _calloutAt: 19 name: #'GciTsX509Login' .
  gciErr := GciErrSType new .
  args := { 
     parameters asGciX509LoginArg . 
     ( CByteArray gcMalloc: 4 "BoolType *executedSessionInit") .
     gciErr
  }.
  ptr := c callWith: args .
  ptr memoryAddress == 0 ifTrue:[
    self _signalError:'GciTsLogin failed'.
  ].
  tsSession := ptr .
  socket := GsSocket fromFileHandle: self _getSocketFd .
  self _allocateBuffers .
  gciErr number > 0 ifTrue:[
    self _signalError:'Warning from GciTsLogin'.
  ].
]

{ #category : 'Parameters' }
GsTsX509ExternalSession >> password: aString [
  self shouldNotImplement: #password:

]

{ #category : 'Parameters' }
GsTsX509ExternalSession >> stoneNRS: anNRS [
  self shouldNotImplement: #stoneNRS:
]

{ #category : 'Parameters' }
GsTsX509ExternalSession >> username [
  ^ username ifNil:[ 
     username := self executeString:'System myUserProfile userId'
  ]
]

{ #category : 'Parameters' }
GsTsX509ExternalSession >> username: aString [
 self shouldNotImplement: #username:
]
