"
GsSocket provides the means for creating and binding TCP sockets through the
 operating system of the machine that is running the session's Gem process, and
 for communicating across those sockets.
 When the current GsProcess is suspended until a socket is ready to read or write,
 other GsProcess that are ready to run will be run by the process scheduler.
 Methods that suspend the current GsProcess until the socket operation completes
 are interruptable by a hard break.
 (You can get a hard break in Topaz by pressing the control-C key twice.  You can get
 a hard break in GemBuilder for C by calling the GciHardBreak function, and in
 GemBuilder for Smalltalk by calling the corresponding hard break method.)

 Beginning with Gs64 v3.0,  instances of GsSocket automatically have
 their C state (including their file descriptor) closed when
 the instance is garbage collected or when a persistent instance drops out of memory.

                              Warning:
    Do not retain an instance of GsSocket from one session to another.
    Instances of GsSocket are intended to exist only within a given GemStone
    session.  GsSockets that are used across sessions always generate an error.

 The interrupting instVar, if true, causes the VM to poll the socket
 asynchronously while executing bytecodes if a GsProcess is waiting
 for the socket to be ready for read or write.

 All instVars of GsSocket are private, for use by the implementation
 of socket methods, and for use by the ProcessorScheduler only.
 The in-memory state of a committed GsSocket is not changed by a transaction abort.

Constraints:
	fileDescriptor: SmallInteger
	lineNumber: SmallInteger
	readWaiters: Object
	writeWaiters: Object
	readyEvents: SmallInteger
	pollArrayOfs: SmallInteger
	interrupting: Boolean
"
Class {
	#name : 'GsSocket',
	#superclass : 'IO',
	#instVars : [
		'readWaiters',
		'writeWaiters',
		'readyEvents',
		'pollArrayOfs',
		'interrupting'
	],
	#classVars : [
		'SocketErrorSymbols'
	],
	#gs_options : [
		'disallowGciStore'
	],
	#gs_reservedoop : '135425',
	#category : 'OSAccess-Sockets'
}
