"
A GsNMethod is a compiled form of a GemStone Smalltalk method.
 Subclasses of GsNMethod are disallowed.

 For Gs64 v3.x, all ""step points"" are expressed in terms of
 a source offset within the method (or home method) source.
 Source offsets are 1-based in Smalltalk
 and zero-based in primitives C code.

Constraints:
	iFields1: SmallInteger
	selector: SmallInteger
	inClass: Object
	debugInfo: Array

--- instVar debugInfo
An Array that contains debugging info and reference to sourceString,
   see file opalcls.ht for details .

--- instVar iFields1
A SmallInteger encoding the various fields per opalcls.ht .

--- instVar inClass
The Behavior (a Class or Metaclass or Module) for which the method was compiled,
 or nil in an anonymous method ,
 or the home method if this method contains code for a block .

--- instVar selector
A SmallInteger that encodes the oopNumber of a Symbol plus a
 16 bit unsigned environment identifer.

"
Class {
	#name : 'GsNMethod',
	#superclass : 'Object',
	#type : 'variable',
	#instVars : [
		'iFields1',
		'selector',
		'inClass',
		'debugInfo'
	],
	#classVars : [
		'CopyingBlockIdxSize_mask',
		'CopyingBlockIdxSize_shift',
		'DbgI1fileInfo_mask',
		'DbgI1fileInfo_shift',
		'debugI2_hasPragmas_shift',
		'DEBUGINFO_BLK_HDRSIZE',
		'DebugInfo_fields1_offset',
		'DebugInfo_Fields2_offset',
		'DebugInfo_fields2_offset',
		'DebugInfo_FirstLastSrcOffset_offset',
		'DEBUGINFO_MTH_HDRSIZE',
		'DEBUGINFO_packageInfo',
		'DEBUGINFO_pragmas',
		'DEBUGINFO_RowanMTH_HDRSIZE',
		'DebugInfo_source_offset',
		'GEN_MAX_ARGS',
		'GSNMETHOD_FIRST_INSTR_OFFSET',
		'GsNMethod_InstSize',
		'HighLiteralsOffset_mask',
		'HighLiteralsOffset_shift',
		'IsMethodForBlock_shift',
		'IsRubyBridgeMeth_shift',
		'LineNumberBias_bits',
		'LineNumberBias_mask',
		'LineNumberBias_shift',
		'LiteralsOffset_lrgBit',
		'LiteralsOffset_mask',
		'LiteralsOffset_shift',
		'LiteralsOffset_smallBits',
		'MethCompilerVers_mask',
		'MethCompilerVers_shift',
		'NArgs_mask',
		'NumArgDescrLits_mask',
		'NumArgDescrLits_shift',
		'NumArgsPlusTemps_mask',
		'NumArgsPlusTemps_shift',
		'NumArgs_mask',
		'NumBlockLiterals_mask',
		'NumIpSteps_mask',
		'NumIpSteps_shift',
		'NumSends_mask',
		'NumSends_shift',
		'OptimizedSelectors',
		'RubyPrivate_shift',
		'RubyProtected_shift',
		'SELECTORID_ENV_mask',
		'SI_SELECTORID_ENV_shift',
		'TraceIR'
	],
	#gs_options : [
		'subclassesDisallowed'
	],
	#gs_reservedoop : '144897',
	#category : 'Kernel-Methods'
}
