"

An instance of GsFileStat contains the results of an operating system fstat()
call for an instance of GsFile.

The instance variables are as follows, all values should be SmallIntegers.
Values of type time_t are in seconds since 00:00:00 UTC, Jan. 1, 1970 .
     atime      time_t of last access
     blksize    perferred IO block size in bytes
     blocks     number of 512 byte blocks allocated for the file
     ctime      time_t of last file status change
     dev        ID of device containing directory entry for the file
     gid        Group ID of file's group
     ino        Inode number
     mode       Filemode (see mknod(2)
     mtime      time_t of last data modification
     nlink      Number of links
     rdev       ID of device (only valid for char special or block special files)
     size       File size in bytes
     uid        User ID of the file's owner

See class GsFile for methods which return instances of GsFileStat.
Instances of GsFileStat represent the state of a GsFile at the point
when the instance of GsFileStat  was created and do not reflect subsequent
changes to the underlying file.

Constraints:
	atime: SmallInteger
	blksize: SmallInteger
	blocks: SmallInteger
	ctime: SmallInteger
	dev: SmallInteger
	gid: SmallInteger
	ino: SmallInteger
	mode: SmallInteger
	mtime: SmallInteger
	nlink: SmallInteger
	rdev: SmallInteger
	size: SmallInteger
	uid: SmallInteger

"
Class {
	#name : 'GsFileStat',
	#superclass : 'Object',
	#instVars : [
		'atime',
		'blksize',
		'blocks',
		'ctime',
		'dev',
		'gid',
		'ino',
		'mode',
		'mtime',
		'nlink',
		'rdev',
		'size',
		'uid'
	],
	#gs_reservedoop : '137985',
	#category : 'OSAccess'
}
