"
GcFinalizeNotification is private to the VM and 
is used to implement finalization of ephemonons .

To have finalization execute in a specific GsProcess, see
GsSignalingSocket class >> newForAsyncExceptions: 
and GsSignalingSocket >> readNotification .
Otherwise,  GcFinalizeNotification >> _signalGcFinalize:
will be executed as needed by the VM .
"
Class {
	#name : 'GcFinalizeNotification',
	#superclass : 'Notification',
	#category : 'Kernel-Internals'
}

{ #category : 'Private' }
GcFinalizeNotification >> _finalizeEphemerons [
  | chunk chunkSize anEphemeron  |
  chunk := System __sessionStateAt: 2 . "head of finalization queue"
  [ chunk ~~ nil ] whileTrue:[
    chunkSize := chunk size .
    1 to: chunkSize - 1 do:[:n |
      anEphemeron := chunk at: n .
      [ anEphemeron mourn
      ] onException: Error do:[:ex |
        GsFile gciLogServer: ex asString , 'during mourn'
      ].
    ].
    chunk := chunk at: chunkSize . "last element is next chunk"
    System __sessionStateAt: 2 put: chunk. "deref chunk just processed"
  ]
]

{ #category : 'Private' }
GcFinalizeNotification >> _signalGcFinalize: saveProtectedMode [

  "To be sent only by the virtual machine.
   The receiver is an asynchronous Exception for error 6017 "
  [
    self _finalizeEphemerons .
  ] ensure:[
    self _enableEvents . "reenable interrupts if resume not successful"
  ].
  self _gsReturnNothingEnableEvents "special selector optimized by compiler"
]
