"
 This class represents 8-byte binary floating point numbers, as defined in IEEE
 standard 754.

 You may not create subclasses of Float.

 Literal numbers in evaluated code that include a decimal point by default create 
 a SmallDouble or Float. If the value is in the SmallDouble range, a SmallDouble 
 will be created, otherwise a Float will be created. Literal floats may be 
 specified using exponential notation.  e and E, and also the ANSI exponents d, D, 
 and q, are all legal exponent notation and produce the same results, either a 
 SmallDouble or Float depending on the range.

 The ANSI class names FloatE, FloatD, and FloatQ also resolve to Float class. 

 The mathematics package of the vendor of the machine where the Gem is running
 implements the numerical behavior of instances of Float.

 Each float contains a 64 bit value in IEEE format, in cpu-native byte order 
 when in memory, and the byte order of the extent when on disk.

 The following details are provided for application programmers who choose
 to access bytes of a float directly.

 Starting from the most significant bit of the byte (self _basicAt: 1), the
 bits of a Float on a big-endian machine are as follows:

 *  1 bit of sign (0 means positive, 1 means negative)
 * 11 bits of exponent
 * 52 bits of mantissa

 Here are the 8 byte patterns of the exceptional values:

                   byte 1                                           byte 8
 PlusQuietNaN       16#7f  16#ff  16#ff  16#ff  16#ff  16#ff  16#ff  16#ff
 MinusQuietNaN      16#ff  16#ff  16#ff  16#ff  16#ff  16#ff  16#ff  16#ff
 MinusInfinity      16#ff  16#f0      0      0      0      0      0      0
 MinusSignalingNaN  16#ff  16#f0      0      0      0      0      0      1
 PlusInfinity       16#7f  16#f0      0      0      0      0      0      0
 PlusSignalingNaN   16#7f  16#f0      0      0      0      0      0      1

 If the Float is an exceptional value (a NaN or an Infinity) then
 the exponent bits are all 1.  If in addition the mantissa is 0 then
 the float is an Infinity; if the mantissa is non-zero then the
 float is a NaN.  In a NaN, if the most significant bit of the
 Mantissa is 1 then the NaN is a quiet NaN.
"
Class {
	#name : 'Float',
	#superclass : 'BinaryFloat',
	#type : 'byteSubclass',
	#classVars : [
		'MaximumFloat',
		'MinusInfinity',
		'MinusQuietNaN',
		'MinusSignalingNaN',
		'PlusInfinity',
		'PlusQuietNaN',
		'PlusSignalingNaN'
	],
	#gs_options : [
		'8byteWords',
		'selfCanBeSpecial',
		'subclassesDisallowed'
	],
	#gs_reservedoop : '135937',
	#category : 'Numbers'
}
