"

 A DoubleByteString is a string for which each Character occupies two bytes.
 Instances are in CPU-native byte order when in memory.

 For historical reasons dealing with the now-deprecated constraints,
 DoubleByteString is in the ClassHistory of String.

 Storing a codePoint > 16rFFFF into an instance of DoubleByteString
 will cause that object to change class to QuadByteString.

 Category: Comparision
   Unless noted otherwise, comparisons between DoubleByteStrings are
   case-sensitive.
   Some of these methods determine whether one strings collates before
   another.  In collation, the Characters of the receiver and aString are
   compared Character-by-Character, from left to right, in case-sensitive
   fashion.  If two strings are of different length, and all Characters in the
   shorter string are equal to their counterparts in the longer strings, the
   shorter string collates before the longer.

   These methods require that the argument be a kind of CharacterCollection,
   not necessarily a String.
"
Class {
	#name : 'DoubleByteString',
	#superclass : 'MultiByteString',
	#gs_options : [
		'2byteWords'
	],
	#gs_reservedoop : '143873',
	#category : 'Collections-Strings'
}
