"
 This class represents base 10 floating point numbers, as defined in IEEE
 standard 854-1987.  This class is fully supported but not being updated
 for new features, and is expected to be deprecated when a replacement
 per IEEE754-2008 is developed.

 You may not create subclasses of DecimalFloat.

 Objects of class DecimalFloat have 20 digits of precision, with an exponent in
 the range -15000 to +15000.  The first byte has encoded in it the sign and kind
 of the floating-point number.  Bit 0 is the sign bit (0=positive, 1=negative).
 The values in bits 1 through 3 indicate the kind of DecimalFloat:

 * 001x = normal
 * 010x = subnormal
 * 011x = infinity
 * 100x = zero
 * 101x = quiet NaN
 * 110x = signaling NaN

 Bytes 2 and 3 encode the exponent as a biased 16-bit number (byte 2 is more
 significant).  The actual exponent is calculated by subtracting 15000.  Bytes
 4 through 13 form the mantissa of the number.  Each byte holds two BCD digits,
 with bits 4 through 7 of byte 4 containing the most significant digit.

 Literal DecimalFloats can be specified in exponential notation using the f or F 
 character; for example, 5.432F2 creates a DecimalFloat equivalent to 543.2.
"
Class {
	#name : 'DecimalFloat',
	#superclass : 'Number',
	#type : 'byteSubclass',
	#classVars : [
		'DecimalMinusInfinity',
		'DecimalMinusQuietNaN',
		'DecimalMinusSignalingNaN',
		'DecimalPlusInfinity',
		'DecimalPlusQuietNaN',
		'DecimalPlusSignalingNaN',
		'MaximumFloat'
	],
	#gs_options : [
		'instancesInvariant',
		'subclassesDisallowed'
	],
	#gs_reservedoop : '69889',
	#category : 'Numbers'
}
