"
CharacterCollection is an abstract superclass for behavior that is common
 to all indexed collections of Characters.

 Subclasses must reimplement the following selectors:

 size
 size:
 at:
 at:put:
 removeFrom:to:
 insertAll:at:

 However these selectors do not generate the subclass-responsibility error
 (error 2008) because to do so would break the Object | printString method.

--- Category:  Comparing
Some of these methods determine whether one String collates before another.
 In collation, the values of the receiver and aCharCollection are compared
 Character-by-Character, from left to right, in case-sensitive fashion.  If two
 CharacterCollections are of different length, and all Characters in the
 shorter collection are equal to their counterparts in the longer one, the
 shorter collection collates before the longer.

 Unlike the comparison methods for the superclass SequenceableCollection, these
 methods merely require that both the receiver and argument be kinds of
 CharacterCollection (rather than requiring both to be of the same class).

"
Class {
	#name : 'CharacterCollection',
	#superclass : 'SequenceableCollection',
	#gs_reservedoop : '80385',
	#category : 'Collections-Strings'
}
