"
Special56bit7 supports application defined special objects.

The bit format of an instance is
   xxxxxxxx|xxxxxxxx|xxxxxxxx|xxxxxxxx|xxxxxxxx|xxxxxxxx|xxxxxxxx|ccccc100
    bits x  56 bits signed or unsigned integer .
    bits c  specify the class.
"
Class {
	#name : 'Special56bit7',
	#superclass : 'Object',
	#type : 'immediate',
	#gs_options : [
		'instancesInvariant',
		'selfCanBeSpecial',
		'subclassesDisallowed'
	],
	#gs_reservedoop : '163073',
	#category : 'Kernel-Classes'
}

{ #category : 'Base Methods' }
Special56bit7 class >> new [
  "Disallowed."
  self shouldNotImplement: #new

]

{ #category : 'Base Methods' }
Special56bit7 class >> new: aSize [
  "Disallowed."
  self shouldNotImplement: #new:

]

{ #category : 'Base Methods' }
Special56bit7 class >> unsignedValue: aSmallInteger [
  "aSmallInteger must be an unsigned integer representable in 56 bits."

  <primitive: 250>
  | min max |
  aSmallInteger _validateInstanceOf: SmallInteger .
  min := 0 .
  max := 72057594037927935 .
  (aSmallInteger > max or:[ aSmallInteger < min ]) ifTrue:[
    ^ OutOfRange new name:'argument' min: min max: max actual: aSmallInteger ; signal
  ].
  ^ self _primitiveFailed: #value: args: { aSmallInteger }.  

]

{ #category : 'Base Methods' }
Special56bit7 class >> value: aSmallInteger [
  "aSmallInteger must be a signed integer representable in 56 bits."

  <primitive: 248>
  | min max |
  aSmallInteger _validateInstanceOf: SmallInteger .
  min := -36028797018963968 .
  max := 36028797018963967 .
  (aSmallInteger > max or:[ aSmallInteger < min ]) ifTrue:[
    ^ OutOfRange new name:'argument' min: min max: max actual: aSmallInteger ; signal
  ].
  ^ self _primitiveFailed: #value: args: { aSmallInteger }.  

]

{ #category : 'Base Methods' }
Special56bit7 >> asString [
  "Implemented in GemStone base code, modifications may be overwritten by upgrade"

  | str radix |
  str := self value asHexString .
  (str at: 1) == $- ifTrue:[ str at: 1 put: $r . radix := '-16' ] 
                   ifFalse:[ radix := '16r' ].
  ^ 'a ' , self class name ,' value ', radix, str 
]

{ #category : 'Base Methods' }
Special56bit7 >> containsIdentity [
  ^ true

]

{ #category : 'Base Methods' }
Special56bit7 >> isSpecial [
  ^ true

]

{ #category : 'Base Methods' }
Special56bit7 >> unsignedValue [
"Returns a a SmallInteger , the 56bit unsigned value contained in the receiver."
  <primitive: 249 >
  ^ self _primitiveFailed: #unsignedValue  

]

{ #category : 'Base Methods' }
Special56bit7 >> value [
"Returns a SmallInteger , the 56bit signed value contained in the receiver."
  <primitive: 82 >
  ^ self _primitiveFailed: #value  

]
