"
A CanonicalStringDictionary is a StringKeyValueDictionary that provides
 protocol that is similar to Set in addition to its dictionary protocol.
 This is the old (32-bit GS/S) class of AllSymbols.

Constraints:
	numElements: SmallInteger
	numCollisions: SmallInteger
	collisionLimit: SmallInteger
	tableSize: SmallInteger
"
Class {
	#name : 'CanonicalStringDictionary',
	#superclass : 'StringKeyValueDictionary',
	#gs_reservedoop : '109825',
	#category : nil
}

{ #category : 'Testing' }
CanonicalStringDictionary >> _isLarge [

"Returns true if the object is implemented as a tree of private smaller objects"

^ true

]

{ #category : 'Repository Conversion' }
CanonicalStringDictionary >> _migrateSymbolSet: aSymbolSet [

"Using the receiver as the canonicalization dictionary, migrate aSymbolSet
 to an IdentitySet of canonical Strings, and return the IdentitySet."

| newSet |

((aSymbolSet isKindOf: SymbolSet) or:[
   aSymbolSet isKindOf: (Globals at:#ObsoleteSymbolSet
                                ifAbsent:[ ObsoleteClasses at: #ObsoleteSymbolSet ])])
  ifTrue:[
  newSet := IdentitySet new .
  aSymbolSet do:[ :aSym | | aStr groupStr |
    aStr := String withAll: aSym .
    groupStr := self add: aStr .
    newSet add: groupStr .
    ].
  newSet objectSecurityPolicy: aSymbolSet objectSecurityPolicy .
  ^ newSet
  ].

^ aSymbolSet

]

{ #category : 'Accessing' }
CanonicalStringDictionary >> _validateGroupString: aString [

| aValue |
aValue := self at: aString otherwise: nil .
aValue == nil ifTrue:[
  aString _error: #segErrBadGroup .
  ^ nil
].
^ aValue

]

{ #category : 'Updating' }
CanonicalStringDictionary >> add: aString [

"Adds aString if it is not already present in the receiver, and returns
 either aString or the canonical string already present."

| aValue |
(aString isKindOf: String) ifTrue:[
  aValue := self at: aString otherwise: nil .
  aValue == nil ifTrue:[
    aString immediateInvariant .
    self at: aString put: aString .
    ^ aString
    ].
  ^ aValue
  ].
"assume aString is an Association."
^ super add: aString

]

{ #category : 'Updating' }
CanonicalStringDictionary >> addAll: aCollection [

"Adds elements of aCollection to the receiver. Returns aCollection."

aCollection == self ifTrue:[ ^ aCollection ].
(aCollection isKindOf: AbstractDictionary)
  ifTrue:[ ^ super addAll: aCollection].
aCollection accompaniedBy: self do:[ :me :aString | me add: aString ].
^ aCollection

]

{ #category : 'Updating' }
CanonicalStringDictionary >> addAssociation: anAssociation [

"Add the argument anAssociation to the receiver."

^ super add: anAssociation

]

{ #category : 'Private' }
CanonicalStringDictionary >> compareKey: key1 with: key2 [

"Returns whether key1 is equivalent to key2."

 key1 == key2 ifTrue:[ ^ true ].

 (key1 _isSymbol ~~ key2 _isSymbol)
    ifTrue:[ ^ key1 asString = key2 asString ]
   ifFalse:[ ^ key1 = key2 ].

]

{ #category : 'Hashing' }
CanonicalStringDictionary >> hashFunction: aKey [

"The hash function performs an operation on the value of the
 key (aKey) and returns a value in the range 1..tableSize."

^((self _hashOfKey: aKey) \\  self tableSize) + 1

]

{ #category : 'Accessing' }
CanonicalStringDictionary >> includes: aString [

"Returns true if the receiver contains aString as a key, false otherwise."

| aValue |
aValue := self at: aString otherwise: nil .
^ aValue ~~ nil

]

{ #category : 'Accessing' }
CanonicalStringDictionary >> includesValue: aString [

"Returns true if the receiver contains aString as a key, false otherwise."

| aValue |
aValue := self at: aString otherwise: nil .
^ aValue ~~ nil

]

{ #category : 'Updating' }
CanonicalStringDictionary >> remove: aString [

"Removes aString if present in the receiver and returns the removed value.  If
 aString is not present, generates an error."

^ self removeKey: aString

]

{ #category : 'Updating' }
CanonicalStringDictionary >> remove: aString ifAbsent: aBlock [

"Removes aString if present in the receiver and returns the removed value.  If
 aString is not present, returns the result of evaluating the zero
 argument Block aBlock."

^ self removeKey: aString ifAbsent: aBlock

]
