"
GsComLitLeaf  represents a literal leaf , and has these instVars:

  stringForm , a String  ,   the source form of the literal reference ,
                     stringForm is nil if literal is a GsNMethod (for Ruby)
  litValue   , an Object ,   the value of the literal
  litKind    , SmallInteger   , a ComParLitEtype

 A GsComLitLeaf is typically referenced by a GsComLiteralNode
 thus allowing canonicalization of literal references, if the
 Parser maintains a dictionary, keyed on string source form of a literal
 and with values being instances of GsComLitLeaf.

 stringForm and litValue are provided separately in case a parser wants
 to do conversions such as string to numeric during a second pass.  The
 generator only looks at litValue , and the stringForm is present in the IR
 graph for use in debugging the parser or generator.
 The generator may change litValue to a canonicalize zero sized
 literal arrays or strings, such as  Smalltalk  #() , ''  .
 In 64bit Gemstone,  the float 0.0  is a SmallDouble and no longer needs
 canonicalization.

 The instance initializer methods assume the parser would like
 to pass the string form of numeric literal, and have the class library
 convert from String to numeric form immediately.  String to numeric
 conversion could generate errors if the parser does not catch all illegal
 floating point formats, etc.   So if the parser did not want to worry
 about errors during numeric conversion, it might want other methods
 to trigger numeric conversion later ...

 The following numeric literals are not supported yet by the initializer methods:
   COMPAR_SCALED_DEC_LIT ,   ScaledDecimal, assume not needed by Ruby
   COMPAR_DECIMAL_FLT_LIT ,  DecimalFloat, assume not needed by Ruby
   COMPAR_FixedPoint_LIT ,   FixedPoint  , assume not needed by Ruby

 The symbolic names of ComParLitEtype are available as
 class variables in GsCompilerIRNode .
 typedef enum {
  COMPAR_CHAR_LIT = 0,
  COMPAR_INT_LIT = 1,
  COMPAR_SYM_LIT = 2,
  COMPAR_SPECIAL_LIT = 3,
  COMPAR_FLT_LIT = 4,
  COMPAR_SCALED_DEC_LIT = 5,
  COMPAR_DECIMAL_FLT_LIT = 6,
  COMPAR_STR_LIT = 7,
  COMPAR_ARRAY_LIT = 8,
  COMPAR_METHOD_LIT = 9,   // generic object used as a literal, for Ruby
  COMPAR_RUBY_COPYING_STR_LIT = 10 ,
  COMPAR_ASSOC_LIT = 11,   // Assocation or RubyConstRef literal
  COMPAR_BYTEARRAY_LIT = 12,
  COMPAR_FixedPoint_LIT = 13
 }   ComParLitEtype;

"
Class {
	#name : 'GsComLitLeaf',
	#superclass : 'GsCompilerIRNode',
	#instVars : [
		'stringForm',
		'litValue',
		'litKind'
	],
	#gs_reservedoop : '243969',
	#category : nil
}
