Extension { #name : 'GsComVariableNode' }

{ #category : 'Instance Creation' }
GsComVariableNode class >> globalNamed: aSymbol inDict: aDictionary [
| assoc node |
assoc := aDictionary associationAt: aSymbol .
(node := self new)
  leaf: (GsComVarLeaf new literalVariable: assoc).
^ node

]

{ #category : 'Instance Creation' }
GsComVariableNode class >> newSelf [
| node |
(node := self new) leaf: (GsComVarLeaf new initializeSelf).
^ node

]

{ #category : 'Instance Initialization' }
GsComVariableNode >> leaf: aGsComVarLeaf [

kind := COMPAR_VAR_NODE .
leaf := aGsComVarLeaf

]

{ #category : 'Accessing' }
GsComVariableNode >> litVarValue [
  ^ leaf litVarValue

]

{ #category : 'Accessing' }
GsComVariableNode >> litVarValueOrNil [
  ^ leaf litVarValue

]

{ #category : 'Printing' }
GsComVariableNode >> printFormattedOn: aStream [
  super printOn: aStream .
  leaf printFormattedOn: aStream .
  aStream   nextPut: $) ; cr .

]

{ #category : 'Accessing' }
GsComVariableNode >> varLeaf [
  ^ leaf

]
