Extension { #name : 'GsComStatementsNode' }

{ #category : 'Instance creation' }
GsComStatementsNode class >> new [
  ^ self _basicNew initialize

]

{ #category : 'Instance Initialization' }
GsComStatementsNode >> initialize [
  kind := COMPAR_STATEMENTS_NODE .

]

{ #category : 'Printing' }
GsComStatementsNode >> lastLineNumber [
  | lst sz |
  lst := list .
  (sz := lst size) _downTo: 1 do:[:n | | num |
    num := (lst at: n) lastLineNumber .
    num ifNotNil:[
       ^ num
    ].
  ].
  ^ nil

]

{ #category : 'Printing' }
GsComStatementsNode >> lastSourceOffset [
  | lst sz |
  lst := list .
  (sz := lst size) _downTo: 1 do:[:n | | num |
    num := (lst at: n) lastSourceOffset .
    num ifNotNil:[
       ^ num
    ].
  ].
  ^ nil

]

{ #category : 'Printing' }
GsComStatementsNode >> lineNumber [
  | lst |
  (lst := list) size ~~ 0 ifTrue:[ ^ ( lst at: 1) lineNumber ]  .

]

{ #category : 'Instance Initialization' }
GsComStatementsNode >> list: anArray [
  list := anArray

]

{ #category : 'Printing' }
GsComStatementsNode >> printFormattedOn: aStream [
  super printOn: aStream .
  aStream
    nextPutAll:' list:'; do: list ;
  nextPut: $) ; cr .

]

{ #category : 'Printing' }
GsComStatementsNode >> sourceOffset [
  | lst |
  (lst := list) size ~~ 0 ifTrue:[ ^ ( lst at: 1) sourceOffset ]  .

]
