Extension { #name : 'GsComReturnNode' }

{ #category : 'Instance Initialization' }
GsComReturnNode >> breakFromRubyBlock: aNode [
  kind := COMPAR_RETURN_NODE .
  expr := aNode .
  returnKind := -1 " would be COM_RTN_TWO_LEVELS " .
  self error:'COM_RTN_TWO_LEVELS not implemented in VM yet' .

]

{ #category : 'Printing' }
GsComReturnNode >> printFormattedOn: aStream [
  super printOn: aStream .
  aStream print:' returnKind:' int: returnKind ; cr ;
    indentMore .
  expr printFormattedOn: aStream .
  aStream indentLess ; nextPut: $) ; cr .

]

{ #category : 'Instance Initialization' }
GsComReturnNode >> return: aNode [
  kind := COMPAR_RETURN_NODE .
  expr := aNode .
  returnKind := COM_RTN_NORMAL .

]

{ #category : 'Instance Initialization' }
GsComReturnNode >> returnFromHome: aNode [
  kind := COMPAR_RETURN_NODE .
  expr := aNode .
  returnKind := COM_RTN_FROM_HOME.

]
