Extension { #name : 'GsComLiteralNode' }

{ #category : 'Instance Creation' }
GsComLiteralNode class >> newConstantRef: aRubyConstantRef [
 ^ self new leaf: (GsComLitLeaf new  constRefLiteral: aRubyConstantRef)

]

{ #category : 'Instance Creation' }
GsComLiteralNode class >> newFalse [
  ^ self new leaf: (GsComLitLeaf new specialLiteral: false)

]

{ #category : 'Instance Creation' }
GsComLiteralNode class >> newInteger: aSmallInt [
 ^ self new leaf: (GsComLitLeaf new  integerLiteral: aSmallInt)

]

{ #category : 'Instance Creation' }
GsComLiteralNode class >> newNil [
  ^ self new leaf: (GsComLitLeaf new specialLiteral: nil)

]

{ #category : 'Instance Creation' }
GsComLiteralNode class >> newObject: anObject [
 ^ self new leaf: (GsComLitLeaf new  objectLiteral: anObject)

]

{ #category : 'Instance Creation' }
GsComLiteralNode class >> newRemoteNil [
  ^ self new leaf: (GsComLitLeaf new specialLiteral: _remoteNil)

]

{ #category : 'Instance Creation' }
GsComLiteralNode class >> newString: aString [
  | str |
  str := aString .
  str isInvariant ifFalse:[ str := aString copy ].
  ^ self new leaf: (GsComLitLeaf new stringLiteral: str ).

]

{ #category : 'Instance Creation' }
GsComLiteralNode class >> newTrue [
  ^ self new leaf: (GsComLitLeaf new specialLiteral: true)

]

{ #category : 'Printing' }
GsComLiteralNode >> leaf: aGsComLitLeaf [
  leaf := aGsComLitLeaf .
  kind := COMPAR_LIT_NODE .

]

{ #category : 'Printing' }
GsComLiteralNode >> printFormattedOn: aStream [
  super printOn: aStream .
  leaf printFormattedOn: aStream .
  aStream nextPut: $) ; cr .

]

{ #category : 'Accessing' }
GsComLiteralNode >> symbolLiteralValue [
  | val |
  val := leaf symbolLiteralValue .
  val ifNil:[ self error:'invalid leaf for symbolLiteralValue'].
  ^ val

]
