Extension { #name : 'GsComBlockNode' }

{ #category : 'Instance creation' }
GsComBlockNode class >> new [
"create an instance registered with VM for finalization of cData"

<primitive: 674>
self _primitiveFailed: #new

]

{ #category : 'Instance Initialization' }
GsComBlockNode >> _appendLastStatement: aNode [
  "OBSOLETE"
  self appendStatement: aNode .
  srcOffset ifNotNil:[
    self lastSourceOffset: aNode lastSourceOffset
  ] ifNil: [ | num |
    num := aNode lastLineNumber .
    num ifNotNil:[ self lastLineNumber: num ].
  ]

]

{ #category : 'Instance Initialization' }
GsComBlockNode >> _computeLastLineNumber [
  "OBSOLETE"
  | list sz |
  list := statements .
  srcOffset ifNotNil:[
    (sz := list size) _downTo: 1 do:[:n | | num |
      num := (list at: n) lastSourceOffset .
      num ifNotNil:[
         self lastSourceOffset: num .
         ^ self
      ].
    ].
    self lastSourceOffset: srcOffset .
    ^ self
  ].
  (sz := list size) _downTo: 1 do:[:n | | num |
      num := (list at: n) lastLineNumber .
      num ifNotNil:[
         self lastLineNumber: num .
         ^ self
      ].
  ].
  sz > 1 ifTrue:[ self error:'could not find a last source position'].

]

{ #category : 'Instance Initialization' }
GsComBlockNode >> _finishLastStatement [
  "OBSOLETE"
  | stmts last |
  stmts := statements .
  last := stmts atOrNil: stmts size .
  last ifNotNil:[
    srcOffset ifNotNil:[
      self lastSourceOffset: last lastSourceOffset
    ] ifNil:[ | num |
      num := last lastLineNumber .
      num ifNotNil:[ self lastLineNumber: num ].
    ]
  ]

]

{ #category : 'Instance Initialization' }
GsComBlockNode >> appendArg: aGsComVarLeaf [
  | argKnd needSynth |
  needSynth := false .
  (argKnd := aGsComVarLeaf varKind) == COMPAR_BLOCK_ARG_VAR ifTrue:[
    (aGsComVarLeaf lexLevel < lexLevel and:[ COM_RUBY_COMPAT_LEVEL == 18]) ifTrue:[
      "Fix Ticket 113, block arg escaping to outer block arg,
       Synthesize a blockArg node, and add an assignment to the
       outer arg"
      needSynth := true
    ] ifFalse:[
      args addLast: aGsComVarLeaf.      "normal block arg"
      ^ self .
    ].
  ].
  ((argKnd == COMPAR_METHOD_TEMP_VAR
      or:[ argKnd == COMPAR_BLOCK_TEMP_VAR
        or:[ argKnd == COMPAR_METHOD_ARG_VAR] ])
    and:[ aGsComVarLeaf lexLevel < lexLevel
        and:[ COM_RUBY_COMPAT_LEVEL == 18 ]]) ifTrue:[
    "Fix for Ticket 21, ruby block args escaping to outer level.
     Synthesize a blockArg node, and add an assignment to the
     outer temp"
    needSynth := true
  ].
  needSynth ifTrue:[
    | synthArg assnNod ags |
    synthArg := GsComVarLeaf new blockArg: aGsComVarLeaf varName
                argNumber: (ags := args) size + 1
                forBlock: self .
    ags add: synthArg .
    assnNod := GsComAssignmentNode new dest: aGsComVarLeaf
                source: (GsComVariableNode new leaf: synthArg ).
    statements insertObject: assnNod at: 1 .
    ^ self
  ].
  self error: 'VarLeaf.varKind=', (GsComVarLeaf varKindToString: argKnd) ,
        ' illegal for a block arg'

]

{ #category : 'Instance Initialization' }
GsComBlockNode >> appendMasgnDummyArg [
  "for a Ruby block of the form  { | x, |  } append a dummy arg
   so the block-args processing will then do the right thing at runtime"
  | ags dummy |
  (ags := args) size == 1 ifFalse:[ self error:'before appendMasgnDummyArg, size not 1'].
  dummy := GsComVarLeaf new blockArg: #_dummyarg argNumber: 2 forBlock: self .
  ags add: dummy

]

{ #category : 'Instance Initialization' }
GsComBlockNode >> appendStatement: aNode [
  aNode sourceOffset ifNil:[ | bsiz |
    (bsiz := statements size) ~~ 0 ifTrue:[
      aNode sourceOffset:( (statements at: bsiz) sourceOffset).
    ]
  ].
  statements addLast: aNode . ^
  srcOffset ifNil:[ | ofs |
    ofs := aNode sourceOffset .
    ofs ifNotNil:[ srcOffset := ofs ]
        ifNil:[ lineNumber ifNil:[ lineNumber := aNode lineNumber]].
  ].

]

{ #category : 'Instance Initialization' }
GsComBlockNode >> appendTemp: aGsComVarLeaf [
  aGsComVarLeaf varKind == COMPAR_BLOCK_TEMP_VAR ifFalse:[
    self error: 'bad arg kind ', aGsComVarLeaf varKindString
  ].
  temps addLast: aGsComVarLeaf

]

{ #category : 'Accessing' }
GsComBlockNode >> args [
  ^ args

]

{ #category : 'Instance Initialization' }
GsComBlockNode >> lastLineNumber: anInt [
  | first last |
  last := anInt .
  srcOffset ifNotNil:[ self error:'should use lastSourceOffset:' ].
  (first := lineNumber) ifNil:[
    lineNumber := anInt
  ] ifNotNil:[
    anInt < first ifTrue:[
      statements do:[ :aNode | | num |
        (num := aNode lineNumber) ifNotNil:[
           num < first ifTrue:[ first := num ].
           num > last ifTrue:[ last := num ].
        ]
      ].
      lineNumber := first.
    ]
  ].
  lastSrcOffset := last  "store a line number"

]

{ #category : 'Instance Initialization' }
GsComBlockNode >> lastSourceOffset: anOffset [
  lastSrcOffset := anOffset

]

{ #category : 'Accessing' }
GsComBlockNode >> lexLevel [
  ^ lexLevel

]

{ #category : 'Instance Initialization' }
GsComBlockNode >> lexLevel: aLevel [
"the primary initialization method"
  kind := COMPAR_BLOCK_NODE.
  aLevel < 0 ifTrue:[ aLevel error:'out of range' ].
  lexLevel := aLevel .
  blkKind := 0 .
  args := { } .
  temps := { } .
  statements := { } .
  lastArgInfo := 0 .
  "terms left as nil"

]

{ #category : 'Accessing' }
GsComBlockNode >> numArgs [
  ^ args size

]

{ #category : 'Accessing' }
GsComBlockNode >> numStatements [
  ^ statements size

]

{ #category : 'Printing' }
GsComBlockNode >> printFormattedOn: aStream [
  super printOn: aStream .
  aStream print:' lexLevel:' int: lexLevel ;
    print:' lastArgInfo:' int: lastArgInfo ; cr ;
    nextPutAll:' args:'; do: args ;
    nextPutAll:' temps:'; do: temps ;
    nextPutAll:' statements:'; do: statements ;
  nextPut: $) ; cr .

]

{ #category : 'Instance Initialization' }
GsComBlockNode >> setAmpersandArg [
  lastArgInfo := lastArgInfo bitOr: HasBlockArg_mask

]

{ #category : 'Instance Initialization' }
GsComBlockNode >> setLastArgStar [
  "filter out anonymous star here,   {|*| }  equivalent to { }  "
  args size ~~ 0 ifTrue:[ lastArgInfo := lastArgInfo bitOr: LastArgStar_mask ].

]

{ #category : 'Instance Initialization' }
GsComBlockNode >> setNoArgsDecl [
  lastArgInfo := lastArgInfo bitOr: NoDeclaredArgs_mask  .

]
