Extension { #name : 'GsComAssignmentNode' }

{ #category : 'Instance Initialization' }
GsComAssignmentNode >> dest: aGsComVarLeaf source: sourceNode [
    "returns receiver."
  kind := COMPAR_ASSIGNMENT_NODE .
  dest := aGsComVarLeaf .
  source := sourceNode .
  assignKind := 0 .
  sourceNode ifNil:[ self error:'illegal nil source for assignment'].
  aGsComVarLeaf ifNil:[ self error: 'illegal nil destination for assignment'].

]

{ #category : 'Instance Initialization' }
GsComAssignmentNode >> destSrcOffset: anOffset [
  destSrcOffset := anOffset

]

{ #category : 'Printing' }
GsComAssignmentNode >> printFormattedOn: aStream [

  super printOn: aStream .
  aStream print:' assignKind:' int: assignKind ; cr ;
  nextPut: $( ; indentMore .
     dest printFormattedOn: aStream .
  aStream  nextPutAll:') := (' .
     source printFormattedOn: aStream .
  aStream indentLess ; nextPutAll: '))'  ; cr .

]

{ #category : 'Instance Initialization' }
GsComAssignmentNode >> setMethodArgDefault [
  assignKind := 1

]
