Extension { #name : 'GsComArrayBuilderNode' }

{ #category : 'Instance creation' }
GsComArrayBuilderNode class >> _basicNew [
"create an instance registered with VM for finalization of cData"

<primitive: 674>
self _primitiveFailed: #_basicNew

]

{ #category : 'Instance creation' }
GsComArrayBuilderNode class >> new [
^ self _basicNew initialize

]

{ #category : 'Instance creation' }
GsComArrayBuilderNode class >> with: aNode [
 | res |
 (res := self new) appendElement: aNode .
  ^ res

]

{ #category : 'Instance Initialization' }
GsComArrayBuilderNode >> appendElement: aGsCompilerIRNode [
  aGsCompilerIRNode ifNil:[ self error:'invalid nil arg to GsComArrayBuilderNode'].
  elements addLast: aGsCompilerIRNode

]

{ #category : 'Instance Initialization' }
GsComArrayBuilderNode >> initialize [
  kind := COMPAR_ARRAY_BUILDER_NODE .
  elements := { } .

]

{ #category : 'Printing' }
GsComArrayBuilderNode >> printFormattedOn: aStream [

  super printOn: aStream .
  aStream print:' count:' int: elements size ;
      do: elements ;
  nextPut: $) ; cr .

]

{ #category : 'Accessing' }
GsComArrayBuilderNode >> size [
  ^ elements size

]
