Extension { #name : 'ObsoleteSymbolKeyValueDictionary' }

{ #category : 'Repository Conversion' }
ObsoleteSymbolKeyValueDictionary class >> _correspondingNewClass [

"The class all instances of receiver are converted to during conversion."

(self == ObsoleteSymbolKeyValueDictionary)
  ifTrue: [ ^ SymbolKeyValueDictionary ].

^ self.

]

{ #category : 'Storing and Loading' }
ObsoleteSymbolKeyValueDictionary class >> loadFrom: passiveObj [

"Reads from passiveObj the passive form of an object with named instance
 variable format.  Converts the object to its active form by loading the
 information into a new instance of the receiver.  Returns the new instance."

^ self loadFrom: passiveObj mappingToClass: SymbolKeyValueDictionary

]

{ #category : 'Updating' }
ObsoleteSymbolKeyValueDictionary >> at: aKey put: aValue [

"Stores the aKey/aValue pair in the receiver.  If aKey is a CharacterCollection
 but not an obsolete symbol, an obsolete symbol of equal value is created for
 the key.  Rebuilds
 the hash table if the addition causes the number of collisions to exceed the
 limit allowed.  Returns aValue.

 If aKey is being added for the first time, an invariant copy of it is stored
 as the key."

"_stringAt:put: primitive has been removed from the VM."
Error signal:'ObsoleteSymbolKeyValueDictionary>>at:put: no longer implemented'.

]

{ #category : 'Repository Conversion' }
ObsoleteSymbolKeyValueDictionary >> containsOnlySymbols [

"Private. Checks to see if all its keys are Symbols (and not ObsoleteSymbols)"

self keysDo: [ :aKey |
  (aKey _isSymbol) ifFalse: [ ^ false ]
  ].

^ true.

]

{ #category : 'Repository Conversion' }
ObsoleteSymbolKeyValueDictionary >> convertToStringKeyValDict [

"Private. Converts the receiver to be an instance of StringKeyValueDictionary."

<primitive: 484>
self _primitiveFailed: #convertToStringKeyValDict

]

{ #category : 'Repository Conversion' }
ObsoleteSymbolKeyValueDictionary >> convertToSymbolKeyValDict [

"Private. Converts the receiver to be an instance of SymbolKeyValueDictionary."

<primitive: 484>
self _primitiveFailed: #convertToSymbolKeyValDict

]

{ #category : 'Repository Conversion' }
ObsoleteSymbolKeyValueDictionary >> rehashForConversion [

"Private. Rehashes the receiver because the hash values of some of its keys
 may have changed."

| newSize |

(self class == ObsoleteSymbolKeyValueDictionary)
  ifTrue: [
    (self containsOnlySymbols)
      ifTrue:  [ self convertToSymbolKeyValDict ]
      ifFalse: [ self convertToStringKeyValDict ].
    ].

newSize := (Integer _selectedPrimeGreaterThan: numElements) max: tableSize.
self rebuildTable: newSize.

]
